clc
clear all

tmax = 8000;
%%%% analytical %%%%%%%%%%
t = 0:1:tmax;

cInitial = 1.0;
hInitial = 1.0e-5;

[t, x] = ode45( @rhs, t, [cInitial; hInitial]);

hh = x(: , 2);
hh = hh(2:tmax+1);
tt = t(2:tmax+1);
% plot(t, (hInitial - x(:, 2))/2);
% plot(t, x(:, 2));
save('analytical_h.txt', 'hh', '-ascii');
save('analytical_t.txt', 'tt', '-ascii');

% %%%% simulation %%%%%%%%%%
% hSimulation = importdata('MicroHeightInlet.txt');
% plot(tt, hh, tt, hSimulation);



function dxdt = rhs(t, x) % x = [c; h]
    K = 5e-9;
    V = 0.1;

    dxdt1 = - 2 * K * x(1) * (1.0 - x(1) * V) / x(2);
    dxdt2 = - 2 * K * V * x(1);
    dxdt = [dxdt1; dxdt2];
end