clc
clear all

data=xlsread('aperture.xlsx');

x = 1:1:301;
x = x / 301;

h0 = 1e-5;
s = (h0 - data)/2;
% 
% 
% x=full(:,1);
% x2=multi2(:,1);
% x=(x-0.00185435)/(0.0535146-0.00185435);
% x2=(x2-0.00185435)/(0.0535146-0.00185435);


color1=[253	174	107]/255;
color2=[253	141	60]/255;
color3=[241	105	19]/255;
color4=[217	72	1]/255;
color5=[140	45	4]/255;



p1=plot( x, s(:, 1), 'markers',8,'linewidth',2, 'color', color1);
hold on
p2=plot( x, s(:, 2), 'markers',8,'linewidth',2, 'color', color2);
p3=plot( x, s(:, 3), 'markers',8,'linewidth',2, 'color', color3);
p4=plot( x, s(:, 4), 'markers',8,'linewidth',2, 'color', color4);
p5=plot( x, s(:, 5), 'markers',8,'linewidth',2, 'color', color5);

%%%%%% Axis %%%%%%
xlabel('$x/L$','FontSize',20,'Interpreter','latex');
ylabel('Thickness (m)','FontSize',20,'Interpreter','latex');
% ylim([-0.001 1.1])
set(gca,'FontName','Times New Roman','FontSize',...
    20,'LineWidth',2,'Yscale','linear');

%%%%%%% Legend %%%%%%
% legend([p1(1) p2(1) p3(1) p4(1) p5(1) p6(1)], '','','','','FontSize',18,'Interpreter','latex')
% set(legend, 'box', 'off', 'Position', [0.7 0.77 0 0])
% a=axes('position',get(gca,'position'),'visible','off');
% legend(a,[p1(2) p2(2) p3(2) p4(2)], '$\hat{t}=0.5$','$\hat{t}=1$','$\hat{t}=2$','$\hat{t}=5$','FontSize',18,'Interpreter','latex')
% set(legend, 'box', 'off', 'Position', [0.78 0.77 0 0])

legend('t=1,000 s','t=3,000 s','t=5,000 s','t=10,000 s','t=19,280 s','FontSize',18,'Interpreter','latex')
set(legend,'EdgeColor', 'none','location','northeast')


%%%%%%%%% Figure %%%%%%%%%%
set(gcf, 'Units', 'centimeters',...
    'Position',[3 4 16 12],... % [left bottom width height]
    'PaperPositionMode', 'auto');
h=gcf;
pos = get(gcf, 'Position');
set(h,'PaperUnits','centimeters', 'PaperSize', pos(3:4));
print(h,'-dpdf', sprintf('./%s.pdf',mfilename));