clc
clear all

D=1e-9;

flux=xlsread('flux.xlsx') * D;
prediction=xlsread('prediction.xlsx') * D;

dt = 100;
tMax = 100000;
t = dt : dt : tMax;

n=50;
for i=1:n
    prediction2(i,:)=prediction(i*1000/n-1,:);
    t2(i) = t(i*1000/n-1);
end


% 
% 
% x=full(:,1);
% x2=multi2(:,1);
% x=(x-0.00185435)/(0.0535146-0.00185435);
% x2=(x2-0.00185435)/(0.0535146-0.00185435);


color1=[161	217	155]/255;
color2=[116	196	118]/255;
color3=[49	163	84]/255;
color4=[0	109	44]/255;



p1=plot( t2, prediction2(:, 1),'o',t, flux(:,1), 'markers',8,'linewidth',2, 'color', color1);
hold on
p2=plot( t2, prediction2(:, 3),'o',t, flux(:,3), 'markers',8,'linewidth',2, 'color', color2);
p3=plot( t2, prediction2(:, 2),'o',t, flux(:,2), 'markers',8,'linewidth',2, 'color', color3);
p4=plot( t2, prediction2(:, 4),'o',t, flux(:,4), 'markers',8,'linewidth',2, 'color', color4);

%%%%%% Axis %%%%%%
xlabel('$t$ (s)','FontSize',20,'Interpreter','latex');
ylabel('$f_{in}$ ([C]m/s)','FontSize',20,'Interpreter','latex');
ylim([-160*D 10*D])
set(gca,'FontName','Times New Roman','FontSize',...
    20,'LineWidth',2,'Yscale','linear');

%%%%%%% Legend %%%%%%
% legend([p1(1) p2(1) p3(1) p4(1) p5(1) p6(1)], '','','','','FontSize',18,'Interpreter','latex')
% set(legend, 'box', 'off', 'Position', [0.7 0.77 0 0])
% a=axes('position',get(gca,'position'),'visible','off');
% legend(a,[p1(2) p2(2) p3(2) p4(2)], '$\hat{t}=0.5$','$\hat{t}=1$','$\hat{t}=2$','$\hat{t}=5$','FontSize',18,'Interpreter','latex')
% set(legend, 'box', 'off', 'Position', [0.78 0.77 0 0])

legend('Prediction','Reference','FontSize',18,'Interpreter','latex')
set(legend,'box', 'off', 'location', 'southeast')


%%%%%%%%% Figure %%%%%%%%%%
set(gcf, 'Units', 'centimeters',...
    'Position',[3 4 16 12],... % [left bottom width height]
    'PaperPositionMode', 'auto');
h=gcf;
pos = get(gcf, 'Position');
set(h,'PaperUnits','centimeters', 'PaperSize', pos(3:4));
print(h,'-dpdf', sprintf('./%s.pdf',mfilename));