clc
clear all

multi=xlsread('multiscale.xlsx');

x=multi(:,1);
x=(x-0.00185435)/(0.0535146-0.00185435);


% color1=[158	202	225]/255;
% color2=[107	174	214]/255;
% color3=[66	146	198]/255;
% color4=[33	113	181]/255;
% color5=[8	69	148]/255;

color1=[198	219	239]/255;
color2=[158	202	225]/255;
color3=[107	174	214]/255;
color4=[66	146	198]/255;

color5=[33	113	181]/255;
color6=[8	81	156]/255;
color7=[8	48	107]/255;



p1=plot( x,multi(:,2),'--','linewidth',2, 'color', color1);
hold on
p2=plot( x,multi(:,3),'--','linewidth',2, 'color', color2);
p4=plot( x,multi(:,4),'--','linewidth',2, 'color', color3);
p5=plot( x,multi(:,5),'linewidth',2, 'color', color4);
p6=plot( x,multi(:,6),'linewidth',2, 'color', color5);
p7=plot( x,multi(:,7),'linewidth',2, 'color', color6);
p9=plot( x,multi(:,8),'linewidth',2, 'color', color7);

%%%%%% Axis %%%%%%
xlabel('$x/L$','FontSize',20,'Interpreter','latex');
ylabel('$c$','FontSize',20,'Interpreter','latex');
ylim([-0.001 1.1])
set(gca,'FontName','Times New Roman','FontSize',...
    20,'LineWidth',2,'Yscale','linear');

%%%%%%% Legend %%%%%%
% legend([p1(1) p2(1) p3(1) p4(1) p5(1) p6(1)], '','','','','FontSize',18,'Interpreter','latex')
% set(legend, 'box', 'off', 'Position', [0.7 0.77 0 0])
% a=axes('position',get(gca,'position'),'visible','off');
% legend(a,[p1(2) p2(2) p3(2) p4(2)], '$\hat{t}=0.5$','$\hat{t}=1$','$\hat{t}=2$','$\hat{t}=5$','FontSize',18,'Interpreter','latex')
% set(legend, 'box', 'off', 'Position', [0.78 0.77 0 0])

legend('t=1,000 s','t=3,000 s','t=10,000 s','t=15,000 s','t=20,000 s','t=30,000 s','t=100,000 s','FontSize',14,'Interpreter','latex')
% set(legend,'box', 'off','location','southwest')
set(legend,'EdgeColor', 'none','location','southwest')

%%%%%%%%% Figure %%%%%%%%%%
set(gcf, 'Units', 'centimeters',...
    'Position',[3 4 16 12],... % [left bottom width height]
    'PaperPositionMode', 'auto');
h=gcf;
pos = get(gcf, 'Position');
set(h,'PaperUnits','centimeters', 'PaperSize', pos(3:4));
print(h,'-dpdf', sprintf('./%s.pdf',mfilename));