clc
clear all

full=xlsread('fullyresolved.xlsx');
multi=xlsread('multiscale.xlsx');

err=multi-full;
err(:,1)=full(:,1);


x=full(:,1);
x=(x-0.00185435)/(0.0535146-0.00185435);


color1=[158	202	225]/255;
color2=[107	174	214]/255;
color3=[66	146	198]/255;
color4=[33	113	181]/255;
color5=[8	69	148]/255;

plot( x,err(:,2), 'markers',8,'linewidth',2, 'color', color1)
hold on
plot( x,err(:,3), 'markers',8,'linewidth',2, 'color', color2)
plot( x,err(:,4), 'markers',8,'linewidth',2, 'color', color3)
plot( x,err(:,5), 'markers',8,'linewidth',2, 'color', color4)
plot( x,err(:,6), 'markers',8,'linewidth',2, 'color', color5)

% xlabel('{\itx}/{\itL}')
% ylabel('Error')

% % ylim([0 1])
% set(gca,'FontName','Times New Roman','FontSize',35,'FontWeight','normal','linewidth',3)
% set(gcf,'color','w')
% legend('$\hat{t}$=1','$\hat{t}$=3','$\hat{t}$=5','$\hat{t}$=8','$\hat{t}$=10','$\hat{t}$=50','Location','southeast')
% 
% set(legend,'Interpreter','latex','edgecolor', 'none')
% %legend('multiscale','fully resolved')



xlabel('$x/L$','FontSize',20,'Interpreter','latex');
ylabel('Error','FontSize',20,'Interpreter','latex');
% ylim([-0.015 0.02])


legend('$t=1,000$ s', '$t=3,000$ s', '$t=5,000$ s', '$t=10,000$ s' , '$t=50,000$ s', ...
    'FontSize',14,'Interpreter','latex')
set(legend,'box', 'on','Location','southeast', 'edgecolor', 'none')
%%%%%%%%% group requirements %%%%%%%%%%
set(gcf, 'Units', 'centimeters',...
    'Position',[3 4 16 12],... % [left bottom width height]
    'PaperPositionMode', 'auto');
set(gca,'FontName','Times New Roman','FontSize',...
    20,'LineWidth',2,'Yscale','linear');
h=gcf;
pos = get(gcf, 'Position');
set(h,'PaperUnits','centimeters', 'PaperSize', pos(3:4));
print(h,'-dpdf', sprintf('./%s.pdf',mfilename));