clc
clear all

full=xlsread('fullyresolved.xlsx');
multi=xlsread('multiscale.xlsx');

for i=1:50
    multi2(i,:)=multi(i*10-1,:);
end


x=full(:,1);
x2=multi2(:,1);
x=(x-0.00185435)/(0.0535146-0.00185435);
x2=(x2-0.00185435)/(0.0535146-0.00185435);


color1=[158	202	225]/255;
color2=[107	174	214]/255;
color3=[66	146	198]/255;
color4=[33	113	181]/255;
color5=[8	69	148]/255;

% color1=[158	202	225]/255;
% color2=[107	174	214]/255;
% color3=[49	130	189]/255;
% color4=[8	81	156]/255;


p1=plot( x2,multi2(:,2),'ok',x,full(:,2),'k', 'markers',8,'linewidth',2, 'color', color1);
hold on
p2=plot (x2,multi2(:,3),'ok',x,full(:,3),'k', 'markers',8,'linewidth',2, 'color', color2);
p3=plot (x2,multi2(:,4),'ok',x,full(:,4),'k', 'markers',8,'linewidth',2, 'color', color3);
p4=plot (x2,multi2(:,5),'ok',x,full(:,5),'k', 'markers',8,'linewidth',2, 'color', color4);
p5=plot (x2,multi2(:,6),'ok',x,full(:,6),'k', 'markers',8,'linewidth',2, 'color', color5);

%%%%%% Axis %%%%%%
xlabel('$x/L$','FontSize',20,'Interpreter','latex');
ylabel('$c$','FontSize',20,'Interpreter','latex');
ylim([-0.001 1])
set(gca,'FontName','Times New Roman','FontSize',...
    20,'LineWidth',2,'Yscale','linear');

%%%%%%% Legend %%%%%%
legend([p1(1) p2(1) p3(1) p4(1) p5(1)], '','','','','','FontSize',18,'Interpreter','latex')
set(legend, 'box', 'off', 'Position', [0.6 0.74 0 0])
a=axes('position',get(gca,'position'),'visible','off');
legend(a,[p1(2) p2(2) p3(2) p4(2) p5(2)], '$t=1,000$ s', '$t=3,000$ s', '$t=5,000$ s', '$t=10,000$ s' , '$t=50,000$ s','FontSize',18,'Interpreter','latex')
set(legend, 'box', 'off', 'Position', [0.73 0.74 0 0])

% legend('Deep learning','Fully resolved','FontSize',18,'Interpreter','latex')
% set(legend,'box', 'off')


%%%%%%%%% Figure %%%%%%%%%%
set(gcf, 'Units', 'centimeters',...
    'Position',[3 4 16 12],... % [left bottom width height]
    'PaperPositionMode', 'auto');
h=gcf;
pos = get(gcf, 'Position');
set(h,'PaperUnits','centimeters', 'PaperSize', pos(3:4));
print(h,'-dpdf', sprintf('./%s.pdf',mfilename));