clc
clear all

full=xlsread('fullyresolved.xlsx');
multi=xlsread('patch.xlsx');
deep=xlsread('deepLearning.xlsx');
steady=xlsread('steady.xlsx');

for i=1:60
    multi2(i,:)=multi(i*5-1,:);
end

for i=1:60
    deep2(i,:)=deep(i*5-1,:);
end

for i=1:100
    steady2(i,:)=steady(i*3-1,:);
end

x=full(:,1);
x2=multi2(:,1);

x=x/30;
x2=x2/30;

color1=[158	202	225]/255;
color2=[107	174	214]/255;
color3=[49	130	189]/255;
color4=[8	81	156]/255;


size = 9;

p1=plot( x2,deep2(:,2),'o', x2,multi2(:,2),'x', x,full(:,2) ,   'markers',size,'LineWidth',1.5, 'color', color1);
hold on
p5=plot(steady2(:,1)/30, steady2(:,2),'.-k','markers',14,'linewidth',1.5);
p2=plot( x2,deep2(:,3),'o' , x2,multi2(:,3),'x', x,full(:,3),   'markers',size,'LineWidth',1.5, 'color', color2);
p3=plot(  x2,deep2(:,4),'o', x2,multi2(:,4),'x', x,full(:,4),   'markers',size,'LineWidth',1.5, 'color', color3);
p4=plot(  x2,deep2(:,5),'o', x2,multi2(:,5), 'x', x,full(:,5), 'markers',size,'linewidth',1.5, 'color', color4);

% plot( x,full(:,5),'w')


%%%%%% Axis %%%%%%
xlabel('$x/L$','FontSize',20,'Interpreter','latex');
ylabel('$c$','FontSize',20,'Interpreter','latex');
ylim([0 1])
set(gca,'FontName','Times New Roman','FontSize',...
    20,'LineWidth',2,'Yscale','linear');

%%%%%%% Legend %%%%%%
legend('Deep learning', 'Patch-based', 'Fully resolved','Analytical','FontSize',18,'Interpreter','latex')
set(legend,'box', 'off')
% legend([p1(1) p2(1) p3(1) p4(1)], '','','','','FontSize',18,'Interpreter','latex')
% set(legend, 'box', 'off', 'Position', [0.7 0.77 0 0])
% a=axes('position',get(gca,'position'),'visible','off');
% legend(a,[p1(2) p2(2) p3(2) p4(2)], '$\hat{t}=1$','$\hat{t}=3$','$\hat{t}=10$','$\hat{t}=50$','FontSize',18,'Interpreter','latex')
% set(legend, 'box', 'off', 'Position', [0.78 0.77 0 0])
% a=axes('position',get(gca,'position'),'visible','off');
% legend(a,p5,'Analytical','FontSize',18,'Interpreter','latex')
% set(legend, 'box', 'off', 'Position', [0.76 0.6 0 0])


%%%%%%%%% Figure %%%%%%%%%%
set(gcf, 'Units', 'centimeters',...
    'Position',[3 4 16 12],... % [left bottom width height]
    'PaperPositionMode', 'auto');
h=gcf;
pos = get(gcf, 'Position');
set(h,'PaperUnits','centimeters', 'PaperSize', pos(3:4));
print(h,'-dpdf', sprintf('./%s.pdf',mfilename));