import os
import numpy as np
import matplotlib.pyplot as plt
from scipy.interpolate import make_interp_spline
from scipy.interpolate import interp1d

TSR_num = [0.2, 0.4, 0.6, 0.7, 0.8, 0.9, 1.0, 1.2]
cp_num = [0.15602421, 0.19025419, 0.22930043 ,0.25275078 ,0.2604103 , 0.26212099,
 0.25430981, 0.22306343]

TSR_exp = [0.18797,0.32109,0.52801,0.6382,0.68407,0.73442,0.78478,0.84461,0.89497,0.98222,1.16122,1.22554]#,1.39556]
cp_exp = [0.06597,0.12689,0.19521,0.21711,0.22929,0.22523,0.2277,0.22602,0.22602,0.21305,0.17976,0.17809]#,0.11797]
cq_exp = [0.35096026,0.395185151,0.369708907,0.340191163,0.335184996,0.306677378,0.290145009,0.267602799,0.252544778,0.216906599,0.154802707,0.145315534]#,0.084532374]

TSR_VPM = [0.2, 0.4, 0.6, 0.8, 1.0, 1.2]
cp_VPM = [0.14323978,  0.18165177,  0.2443782,   0.28607914,  0.11387168, -0.09542241]

TSR_VPM_treatment = [0.2, 0.4, 0.6, 0.7, 0.8, 0.9, 1.0, 1.2]
cp_VPM_treatment = [0.14937334, 0.16027018, 0.21274271, 0.2431069,  0.26982703, 0.24501736,
 0.22030908, 0.19041811]

plt.rc('xtick', labelsize = 17)
plt.rc('ytick', labelsize = 17)
#plt.rc('font', family='Times New Roman')

plt.figure(figsize=(7,5))
plt.grid()
plt.plot(TSR_num, cp_num, label='URANS', linewidth=2, marker='o')
plt.plot(TSR_exp, cp_exp, label='Experiment', linewidth=2)
plt.scatter(TSR_VPM, cp_VPM, label=r'DTVPM$_\mathtt{nonvisc}$', color='green', marker='o')
plt.scatter(TSR_VPM_treatment, cp_VPM_treatment, label=r'DTVPM$_\mathtt{visc}$', color='red', marker='o')
plt.legend(loc='best', prop={'size':16});
plt.xlabel('$\lambda$',fontsize=17)
plt.ylabel('$c_p$',fontsize=17)
plt.subplots_adjust(bottom=0.15, left=0.17, top=0.95, right=0.95)
#plt.title('Power coefficient for different TSRs(0.2~1.4)', fontsize=17)
plt.savefig('power_coeff_CFDEXPDTVPM_new.pdf')
