# Data used in the paper "Resonant Drag Instabilities in Polydisperse Dust II. The streaming and settling instabilities" (Paardekooper & Aly 2025)

This repository holds the data and the scripts to generate the plots of the paper "Resonant Drag Instabilities in Polydisperse Dust I. The streaming and settling instabilities" by Paardekooper & Aly (2025). The data consists of numerically calculated growth rates of the instability, using the publicly available package [psitools](https://github.com/psitools).

The file `paper_figures.py` contains the Python script to generate all plots. It requires the `numpy`, `scipy` and `matplotlib` packages. If these are not available, they can be installed using the requirements file: `pip install -r requirements.txt`. Running `paper_figures.py` generates png files corresponding the figures in the paper.

The `*.npz` files contain the numerically generated data in the [numpy.savez](https://numpy.org/doc/stable/reference/generated/numpy.savez.html) format:

- `fig_si_monoresonance.npz`: growth rates as a function of wave number for the monodisperse streaming insytability, corresponding to figure 1 in the paper.
- `fig_si_resonance.npz`: growth rates as a function of wave number for the polydisperse streaming instability, corresponding to figure 2 in the paper.
- `fig_si_cont.npz`: growth rates as a function of horizontal wave number for the streaming instability, decomposed into contributions from density and relative velocity. This data generates figure 3 in the paper.
- `fig_si_delta.npz`: growth rates for the streaming instability as a function of the width of the size ditribution, corresponding to figure 4 in the paper.
- `fig_dsi_monoresonance.npz`: growth rates as a function of wave number for the monodisperse settling instability, corresponding to figure 5 in the paper.
- `fig_dsi_contour_growth.npz`: growth rates as a function of wave number for both the monodisperse and polydisperse settling instability, corresponding to figure 6 in the paper.
- `fig_dsi_poly_kx.npz`: growth rates as a function of wave number for the polydisperse settling instability, decomposed into contributions from density and relative velocity. This data generates figure 7 in the paper.
- `fig_dsi_double_growth.npz`: growth rates as a function of wave number for the settling instability, for different widths of the size distribution. This data generates figure 9 of the paper.
- `fig_dsi_visc.npz`: growth rates for the settling instability as a function of wavenumber, with varying levels of diffusion. This data generates figure 10 in the paper.
- `fig_dsi_convergence.npz`: growth rates as a function of wave number for the settling instability, calculated with the direct method, corresponding to figure 11 in the paper.
- `fig_dsi_convergence_max.npz`: growth rates as a function of wave number for the settling instability, comparing the direct method to the root-finding algorithm. This data generates figure 12 in the paper.
