#!/bin/bash
#
#SBATCH --job-name="genMIXnewheur"
#SBATCH --partition=compute
#SBATCH --time=00:05:00
#SBATCH --account=research-ME-mtt

R="newheur3_MIX"
seeds=("107437" "131576" "140541" "255803" "274681" "346931" "466777" "491721" "616125" "669939" "708096" "763410" "772412" "777604" "800933" "873068" "899074" "909290" "925786" "942019")
# w="ContvotSYST"
for i in ${seeds[*]}
do
	touch SND_SAA${R}_${i}draws_3nodes.sh
	echo "#!/bin/bash" >> SND_SAA${R}_${i}draws_3nodes.sh
	echo "#SBATCH --job-name=newheur3MIX_${i}              # Job name" >> SND_SAA${R}_${i}draws_3nodes.sh
	echo "#SBATCH --partition=compute" >> SND_SAA${R}_${i}draws_3nodes.sh
	echo "#SBATCH --mail-type=END,FAIL             # Mail events (NONE, BEGIN, END, FAIL, ALL)" >> SND_SAA${R}_${i}draws_3nodes.sh
	echo "#SBATCH --mail-user=a.nicolet@tudelft.nl # Where to send mail" >> SND_SAA${R}_${i}draws_3nodes.sh
	echo "#SBATCH --ntasks=1                       # Run on a single CPU" >> SND_SAA${R}_${i}draws_3nodes.sh
	echo "#SBATCH --cpus-per-task=1" >> SND_SAA${R}_${i}draws_3nodes.sh
	echo "#SBATCH --mem=150G                        # Job memory request" >> SND_SAA${R}_${i}draws_3nodes.sh
	echo "#SBATCH --time=15:00:00                 # Time limit hrs:min:sec" >> SND_SAA${R}_${i}draws_3nodes.sh
	echo "#SBATCH --account=research-ME-mtt" >> SND_SAA${R}_${i}draws_3nodes.sh
	echo "#SBATCH --output=newheur3MIX_${i}.log      # Standard output and error log" >> SND_SAA${R}_${i}draws_3nodes.sh
	echo " " >> SND_SAA${R}_${i}draws_3nodes.sh
	echo "module load 2022r2" >> SND_SAA${R}_${i}draws_3nodes.sh
	echo "module load python/3.8.12" >> SND_SAA${R}_${i}draws_3nodes.sh
	echo " " >> SND_SAA${R}_${i}draws_3nodes.sh
	echo "srun python3 Heur_Mixed_9n.py ${i} 500" >> SND_SAA${R}_${i}draws_3nodes.sh
        sbatch SND_SAA${R}_${i}draws_3nodes.sh
        rm SND_SAA${R}_${i}draws_3nodes.sh
done
