import itertools
import numpy as np
import gurobipy as gp
from gurobipy import GRB,quicksum
import math
import pandas as pd
import scipy.stats as sps
import sys
import gc

N_draws = int(sys.argv[2])
R=range(N_draws)

MU_b_c_inter = 2.40
SIGMA_b_c_inter = 0.618

R_b_c_inter = []

sysEpsilons = []

seedH=int(sys.argv[1])

np.random.seed(seedH)

for r in R:
#     syspoint=(r+1)/(N_draws+1)
    sysEpsilons.append(sps.gumbel_r.rvs())
#     syspointR=sps.uniform.ppf(syspoint, loc=0.01, scale=0.98)
#     sysEpsilons.append(0)
#         R_b_c_inter.append(-5.76)
    R_b_c_inter.append(-np.exp(MU_b_c_inter + SIGMA_b_c_inter * sps.norm.rvs()))


Eps_IC=np.random.permutation(sysEpsilons)
Eps_IWT=np.random.permutation(sysEpsilons)
Eps_ROAD=np.random.permutation(sysEpsilons)
Eps_RAIL=np.random.permutation(sysEpsilons)


# Define all vessel related parameters

vesseltypes=["M8","M11"]
V_fleet=[24,18] # Fleet per vessel type
T_operate=120 # Maximal time a vessel can operate per week
U_cap=[180,300] # Maximal capacity per vessel type
M=100000

# Define all demand related parameters

terminals = ["RTM", "NIJ", "DUI", "BON", "AND", "MAI", "LUH", "SXB", "BSL"]
#OD_matrix=[[0,4700,1100],[6900,0,100],[700,200,0]] # Weekly demand for IWT
OD_matrix_allM = [[0, 5700, 6500, 1900, 100, 600, 3500, 400, 800],
                  [4900, 0, 50, 50, 0, 100, 50, 0, 0],
                  [8400, 100, 0, 6700, 900, 300, 50, 0, 100],
                  [1500, 50, 6500, 0, 2000, 500, 50, 0, 100],
                  [200, 50, 900, 2200, 0, 2100, 0, 50, 50],
                  [600, 50, 100, 400, 1500, 0, 0, 200, 50],
                  [3100, 50, 200, 0, 0, 0, 0, 0, 50],
                  [500, 0, 0, 0, 50, 200, 0, 0, 200],
                  [1200, 50, 50, 50, 50, 50, 0, 100, 0]]  # Weekly demand for all modes
# Define all cost related parameters

Ocosts = [[[0, 1600, 2200, 2700, 3300, 3900, 4200, 5700, 5800],
           [4200, 0, 1400, 1800, 2400, 3000, 3300, 4900, 5000],
           [4700, 1300, 0, 1100, 1800, 2300, 2700, 4400, 4300],
           [5100, 1600, 1100, 0, 1300, 1900, 2200, 3800, 3900],
           [5600, 2100, 1800, 1300, 0, 1300, 1600, 3100, 3200],
           [6100, 2600, 2300, 1900, 1300, 0, 1000, 2600, 2700],
           [6400, 2900, 2700, 2200, 1600, 1000, 0, 2200, 2300],
           [7600, 4200, 4100, 3800, 3100, 2600, 2200, 0, 700],
           [7700, 4300, 4200, 3900, 3200, 2700, 2300, 700, 0]],
          [[0, 2600, 3600, 4200, 5100, 5900, 6400, 8700, 8800],
           [5300, 0, 2300, 3000, 3900, 4700, 5200, 7500, 7600],
           [6100, 2100, 0, 2000, 2900, 3700, 4200, 6500, 6600],
           [6600, 2600, 2000, 0, 2200, 3100, 3600, 5900, 6000],
           [7300, 3300, 2900, 2200, 0, 2200, 2700, 5000, 5100],
           [8000, 4000, 3700, 3100, 2200, 0, 1800, 4100, 4200],
           [8400, 4400, 4200, 3600, 2700, 1800, 0, 3600, 3700],
           [10100, 6500, 6100, 5900, 5000, 4100, 3600, 0, 1300],
           [10200, 6600, 6200, 6000, 5100, 4200, 3700, 1300,0]]]  # Operational costs per vessel type for each OD

Vcosts = [[[0, 14, 24, 31, 40, 49, 54, 78, 79],
           [11, 0, 11, 18, 27, 36, 41, 65, 66],
           [13, 6, 0, 8, 17, 26, 31, 55, 56],
           [18, 10, 8, 0, 10, 19, 24, 48, 49],
           [22, 17, 15, 10, 0, 9, 15, 39, 40],
           [27, 26, 23, 19, 9, 0, 6, 30, 31],
           [31, 29, 24, 22, 15, 6, 0, 25, 26],
           [68, 64, 55, 48, 39, 30, 25, 0, 8],
           [70, 66, 56, 49, 40, 31, 26, 8, 0]],
          [[0, 12, 21, 27, 35, 43, 47, 68, 69],
           [6, 0, 10, 15, 24, 31, 36, 57, 58],
           [10, 4, 0, 6, 15, 22, 27, 48, 49],
           [12, 7, 6, 0, 9, 16, 21, 42, 43],
           [16, 15, 11, 9, 0, 8, 13, 34, 35],
           [19, 17, 16, 14, 8, 0, 5, 26, 27],
           [21, 19, 17, 16, 13, 5, 0, 21, 22],
           [61, 57, 48, 42, 34, 26, 21, 0, 7],
           [62, 58, 49, 43, 35, 27, 22, 7, 0]]]

# Define all time related parameters

Twaitport = [30, 1, 1, 1, 1, 1, 1, 1, 1]  # Waiting time at each terminal
Thandport = [round(value * 0.024) for value in U_cap] # Handling time to load/unload a vessel type
Tsailod = [[[0, 9, 15, 19, 26, 31, 35, 50, 51],
            [8, 0, 6, 11, 17, 22, 27, 42, 43],
            [13, 5, 0, 4, 11, 16, 19, 35, 36],
            [16, 10, 4, 0, 6, 12, 15, 30, 31],
            [22, 14, 11, 6, 0, 5, 9, 25, 26],
            [26, 19, 16, 12, 5, 0, 3, 18, 19],
            [29, 22, 19, 15, 9, 3, 0, 15, 16],
            [41, 35, 33, 30, 25, 18, 15, 0, 4],
            [42, 36, 34, 31, 26, 19, 16, 4, 0]],
           [[0, 11, 19, 25, 33, 40, 44, 63, 64],
            [9, 0, 8, 14, 22, 29, 34, 53, 54],
            [15, 6, 0, 5, 14, 21, 25, 44, 45],
            [19, 11, 5, 0, 7, 15, 19, 39, 40],
            [26, 17, 14, 7, 0, 7, 12, 31, 32],
            [31, 22, 21, 15, 7, 0, 4, 24, 25],
            [35, 27, 25, 29, 12, 4, 0, 20, 21],
            [50, 43, 42, 39, 31, 24, 20, 0, 5],
            [51, 44, 43, 40, 32, 25, 21, 5,0]]]  # Sailing time per vessel type for each OD (sail+lock time)

#Define utility related parameters
a_road=2.35
a_rail=0.816
b_port=1.60
b_freq_inter=0.0262
b_acc_road=0.0506
b_acc_inter=0.173
b_c_road=-8.73

# Define all parameters for competing modes

costsROAD = [[0, 171, 252, 317, 439, 566, 584, 1001, 1075],
        [171, 0, 175, 247, 367, 444, 511, 924, 1006],
        [251, 174, 0, 136, 240, 333, 390, 657, 901],
        [315, 246, 136, 0, 159, 278, 294, 571, 652],
        [436, 365, 240, 159, 0, 183, 183, 454, 535],
        [563, 442, 333, 278, 183, 0, 182, 388, 468],
        [581, 509, 390, 294, 183, 182, 0, 371, 452],
        [997, 920, 657, 571, 454, 388, 371, 0, 167],
        [1103, 1032, 927, 675, 553, 484, 467, 172, 0]]

costsRAIL = [[0, 162, 203, 214, 238, 262, 283, 348, 355],
        [162, 0, 173, 184, 208, 232, 253, 321, 327],
        [203, 173, 0, 152, 174, 198, 219, 287, 293],
        [214, 184, 152, 0, 155, 182, 200, 269, 275],
        [238, 208, 174, 155, 0, 165, 176, 244, 251],
        [262, 232, 198, 182, 165, 0, 158, 223, 229],
        [283, 253, 219, 200, 176, 158, 0, 202, 208],
        [348, 321, 287, 269, 244, 223, 202, 0, 141],
        [355, 327, 293, 275, 251, 229, 208, 141, 0]]

accROAD = [[0, 37, 45, 42, 23, 35, 32, 23, 28],
        [37, 0, 48, 45, 26, 38, 35, 26, 31],
        [45, 48, 0, 53, 34, 46, 43, 34, 39],
        [42, 45, 53, 0, 31, 43, 40, 31, 36],
        [23, 26, 34, 31, 0, 24, 21, 12, 17],
        [35, 38, 46, 43, 24, 0, 33, 24, 29],
        [32, 35, 43, 40, 21, 33, 0, 21, 26],
        [23, 26, 34, 31, 12, 24, 21, 0, 17],
        [28, 31, 39, 36, 17, 29, 26, 17, 0]]

accRAIL = [[0, 6, 15, 9, 7, 7, 11, 9, 11],
        [6, 0, 11, 5, 3, 3, 7, 5, 7],
        [15, 11, 0, 14, 12, 12, 16, 14, 16],
        [9, 5, 14, 0, 6, 6, 10, 8, 10],
        [7, 3, 12, 6, 0, 4, 8, 6, 8],
        [7, 3, 12, 6, 4, 0, 8, 6, 8],
        [11, 7, 16, 10, 8, 8, 0, 10, 12],
        [9, 5, 14, 8, 6, 6, 10, 0, 10],
        [11, 7, 16, 10, 8, 8, 12, 10, 0]]

freqRAIL = [[0, 0, 78, 5, 0, 7, 26, 5, 19],
        [0, 0, 0, 0, 0, 0, 0, 0, 0],
        [78, 0, 0, 2, 0, 0, 20, 30, 19],
        [5, 0, 2, 0, 0, 0, 0, 10, 20],
        [0, 0, 0, 0, 0, 0, 0, 0, 0],
        [7, 0, 0, 0, 0, 0, 0, 1, 0],
        [26, 0, 20, 0, 0, 0, 0, 0, 0],
        [5, 0, 30, 10, 0, 1, 0, 0, 10],
        [19, 0, 19, 20, 0, 0, 0, 10, 0]]

VOTcostROAD = [[0, 3, 4, 5, 6, 8, 9, 12, 14],
        [3, 0, 3, 4, 5, 6, 7, 11, 13],
        [4, 3, 0, 2, 3, 5, 6, 10, 11],
        [5, 4, 2, 0, 2, 4, 5, 8, 10],
        [6, 5, 3, 2, 0, 3, 4, 6, 8],
        [8, 6, 5, 4, 3, 0, 3, 5, 7],
        [8, 7, 6, 4, 3, 2, 0, 5, 6],
        [12, 11, 10, 8, 6, 5, 4, 0, 3],
        [14, 13, 11, 10, 8, 7, 6, 3, 0]]

VOTcostRAIL = [[0, 4, 6, 7, 9, 10, 12, 17, 18],
        [4, 0, 5, 6, 8, 10, 12, 16, 17],
        [6, 5, 0, 3, 4, 6, 8, 12, 13],
        [7, 6, 3, 0, 3, 5, 6, 10, 12],
        [9, 8, 4, 3, 0, 4, 5, 10, 12],
        [10, 10, 6, 5, 4, 0, 4, 8, 9],
        [12, 12, 8, 6, 5, 4, 0, 7, 8],
        [17, 16, 12, 11, 10, 8, 7, 0, 4],
        [18, 17, 13, 12, 11, 9, 8, 4, 0]]

VOTcostIWT = [[0, 23, 32, 39, 49, 57, 63, 86, 88],
        [55, 0, 20, 27, 36, 44, 50, 73, 75],
        [62, 17, 0, 17, 26, 34, 40, 63, 65],
        [67, 22, 17, 0, 20, 28, 34, 56, 58],
        [74, 29, 26, 20, 0, 18, 24, 47, 49],
        [80, 35, 34, 28, 18, 0, 15, 38, 40],
        [85, 40, 39, 34, 24, 15, 0, 35, 36],
        [102, 66, 63, 56, 47, 38, 35, 0, 12],
        [103, 68, 65, 58, 49, 40, 36, 12, 0]]

# Define mode parameters for IWT
freqIC = [[0, 4, 22, 4, 1, 3, 1, 3, 4],
        [4, 0, 1, 0, 0, 0, 0, 0, 1],
        [19, 1, 0, 6, 1, 0, 1, 0, 0],
        [6, 0, 5, 0, 5, 4, 0, 0, 0],
        [1, 0, 0, 5, 0, 4, 0, 0, 0],
        [3, 1, 0, 4, 4, 0, 0, 0, 0],
        [3, 1, 1, 0, 0, 1, 0, 0, 1],
        [2, 0, 0, 0, 0, 0, 0, 0, 7],
        [3, 1, 1, 0, 0, 0, 0, 7, 0]]

costsIC = [[0, 54, 68, 76, 89, 100, 107, 140, 141],
        [61, 0, 50, 59, 72, 83, 90, 123, 124],
        [69, 45, 0, 46, 58, 70, 76, 109, 110],
        [74, 50, 46, 0, 49, 60, 67, 100, 101],
        [82, 58, 56, 49, 0, 48, 55, 88, 89],
        [89, 72, 70, 60, 48, 0, 43, 76, 77],
        [93, 79, 76, 67, 55, 43, 0, 69, 70],
        [112, 118, 109, 100, 88, 76, 69, 0, 37],
        [113, 119, 110, 101, 89, 77, 70, 37, 0]]

acc = [[0, 6, 17, 8, 7, 7, 9, 5, 7],
        [6, 0, 13, 4, 3, 3, 5, 1, 3],
        [17, 13, 0, 15, 14, 14, 16, 12, 14],
        [8, 4, 15, 0, 5, 5, 7, 3, 5],
        [7, 3, 14, 5, 0, 4, 6, 2, 4],
        [7, 3, 14, 5, 4, 0, 6, 2, 4],
        [9, 5, 16, 7, 6, 6, 0, 4, 6],
        [5, 1, 12, 3, 2, 2, 4, 0, 2],
        [7, 3, 14, 5, 4, 4, 6, 2, 0]]

portif = [[0, 1, 1, 1, 1, 1, 1, 1, 1],
        [1, 0, 0, 0, 0, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0, 0, 0]]


# Determine number of nodes, max number of legs of services and numbre of vessel types

N_nodes=len(terminals)
N=range(N_nodes)
nodes = list(N)
maxLegs=2*(N_nodes-1)
L=range(maxLegs)
N_Vtypes=len(vesseltypes)
K=range(N_Vtypes)

# Determine the considered services together with their legs

legs_matrix=[]
services=[]
service_list=[]

for P in range(2,N_nodes + 1):
    for subset in itertools.combinations(nodes, P):
        legs=np.zeros((maxLegs,N_nodes,N_nodes))
        l=0
        for seq in range(1,len(subset)):
            legs[l][subset[seq-1]][subset[seq]]=1
            l+=1
        for revseq in reversed(range(1,len(subset))):
            legs[l][subset[revseq]][subset[revseq-1]]=1
            l+=1
        legs_matrix.append(legs)
        services.append(subset)
        node_list=[]
        for w in subset:
            node_list.append(terminals[w])
        service_list.append(node_list)

N_services=len(services)
S=range(N_services)

# Determine what OD demand will use each leg of each service 

usage_matrix=np.zeros((N_services,maxLegs,N_nodes,N_nodes))

for s in S:
    for l in range(len(services[s])-1):
        for k in range(l+1):
            for q in range(l+1,len(services[s])):
                usage_matrix[s][l][services[s][k]][services[s][q]]=1
    lt=0
    for r in reversed(range(l+1,2*(l+1))):
        usage_matrix[s][r]=np.transpose(usage_matrix[s][lt])
        lt+=1

# Determine fixed costs of each service for each vessel type

fixed_costs=np.zeros((N_Vtypes,N_services))
for k in K:
    for s in S:
        fcost=0
        for leg in legs_matrix[s]:
            for i in N:
                for j in N:
                    fcost+=leg[i][j]*Ocosts[k][i][j]
        fixed_costs[k][s] = fcost

# Determine variable costs of each service for each vessel type

var_costs=np.zeros((N_Vtypes,N_services,N_nodes,N_nodes))

for k in K:
    for i in N:
        for j in N:
            if i!=j:
                for s in S:
                    vcost=0
                    for l in range(2*(len(services[s])-1)):
                        vcost+=usage_matrix[s][l][i][j]*sum(legs_matrix[s][l][a][b]*Vcosts[k][a][b] for a in N for b in N)
                    if vcost==0:
                        var_costs[k][s][i][j]=M
                    else:
                        var_costs[k][s][i][j]=vcost

# Determine sailing and port times of each service for each vessel type

t_sail=np.zeros((N_Vtypes,N_services))
t_port=np.zeros((N_Vtypes,N_services))

for k in K:
    for s in S:
        tstemp=0
        tptemp=0
        for l in range(2*(len(services[s])-1)):
            tstemp+=sum(legs_matrix[s][l][a][b]*Tsailod[k][a][b] for a in N for b in N)
            tptemp+=sum(legs_matrix[s][l][a][b]*(Twaitport[b]+2*Thandport[k]) for a in N for b in N)
        t_sail[k][s] = tstemp
        t_port[k][s] = tptemp

# Determine max. number of cycles per vessel for each service for each vessel type

maxCycles=np.zeros((N_Vtypes,N_services))

for k in K:
    for s in S:
        maxCycles[k][s]=T_operate/(t_sail[k][s]+t_port[k][s])


# Determine the ODs that can be served by a service

servOD_matrix=np.zeros((N_services,N_nodes,N_nodes))

for i in N:
    for j in N:
        if i!=j:
            for s in S:
                if var_costs[0][s][i][j]!=M:
                    servOD_matrix[s][i][j]=1


# Determine utilities for competing modes

Vroad=np.zeros((N_nodes,N_nodes,N_draws))

for i in N:
    for j in N:
        if i!=j:
            for r in R:
                Vroad[i][j][r]=a_road+b_c_road*(costsROAD[i][j]+VOTcostROAD[i][j])/1000+b_acc_road*accROAD[i][j]+Eps_ROAD[r]

# # Determine upper bounds for frequency

# Bound_f=np.zeros((N_nodes,N_nodes), dtype=int)

# for i in N:
    # for j in N:
        # Bound_f[i][j]=int(math.ceil(math.log2(35)))

Vrail=np.zeros((N_nodes,N_nodes,N_draws))
Vic=np.zeros((N_nodes,N_nodes,N_draws))

for i in N:
    for j in N:
        if i!=j:
            for r in R:
                Vrail[i][j][r]=a_rail+R_b_c_inter[r]*(costsRAIL[i][j]+VOTcostRAIL[i][j])/1000+b_acc_inter*accRAIL[i][j]+b_freq_inter*freqRAIL[i][j]+Eps_RAIL[r]
                Vic[i][j][r]=R_b_c_inter[r]*(costsIC[i][j]+VOTcostIWT[i][j])/1000+b_acc_inter*acc[i][j]+b_freq_inter*freqIC[i][j]+b_port*portif[i][j]+Eps_IC[r]

maxV=np.zeros((N_nodes,N_nodes,N_draws))
maxALT=np.zeros((N_nodes,N_nodes,N_draws))
for i in N:
    for j in N:
        if i!=j:
            for r in R:
                maxV[i][j][r]=max(Vroad[i][j][r],Vrail[i][j][r],Vic[i][j][r])
                maxALT[i][j][r]=np.argmax([Vroad[i][j][r],Vrail[i][j][r],Vic[i][j][r]])
                
N_prices=50
P=range(N_prices)
N_freq=36
F=range(N_freq)

Viwtf=np.zeros((N_freq,N_nodes,N_nodes,N_draws,N_prices))
Diwtf=np.zeros((N_prices,N_nodes,N_nodes,N_freq))
profitf=np.zeros((N_freq,N_freq,N_nodes,N_nodes,N_prices))
maxPROFf=np.zeros((N_nodes,N_nodes,N_freq,N_freq))
maxPROFfij=np.zeros((N_nodes,N_nodes,N_freq,N_freq))
optPf=np.zeros((N_nodes,N_nodes,N_freq,N_freq))

for f in F:
    if f>0:
        print(f)
        for i in N:
            for j in N:
                if i<j:
                    for fsmall in range(V_fleet[0]*math.ceil(maxCycles[0][i+j-1])):
                        for fbig in range(V_fleet[1]*math.ceil(maxCycles[1][i+j-1])):
                            if fsmall+fbig==f:
                                for p in P:
                                    D=[0,0]
                                    for r in R:
                                        Viwtf[f][i][j][r][p]=R_b_c_inter[r]*(p*10+VOTcostIWT[i][j])/1000+b_freq_inter*f+b_acc_inter*acc[i][j]+b_port*portif[i][j]+Eps_IWT[r]
                                        Viwtf[f][j][i][r][p]=R_b_c_inter[r]*(p*10+VOTcostIWT[j][i])/1000+b_freq_inter*f+b_acc_inter*acc[j][i]+b_port*portif[j][i]+Eps_IWT[r]
                                        if Viwtf[f][i][j][r][p]>=maxV[i][j][r]:
                                            D[0]+=OD_matrix_allM[i][j]/N_draws
                                        if Viwtf[f][j][i][r][p]>=maxV[j][i][r]:
                                            D[1]+=OD_matrix_allM[j][i]/N_draws
                                    Diwtf[p][i][j][f]=D[0]
                                    Diwtf[p][j][i][f]=D[1]
                                    Ksmall=fsmall*U_cap[0]
                                    Kbig=fbig*U_cap[1]
                                    dsmall=[0,0]
                                    dbig=[0,0]
                                    if D[0] >= Ksmall+Kbig:
                                        D[0]=Ksmall+Kbig
                                        dsmall[0]=Ksmall
                                        dbig[0]=Kbig
                                    elif D[0] >= Kbig:
                                        dbig[0]=Kbig
                                        dsmall[0]=D[0]-dbig[0]
                                    else:
                                        dbig[0]=D[0]
                                        dsmall[0]=0
                                    if D[1] >= Ksmall+Kbig:
                                        D[1]=Ksmall+Kbig
                                        dsmall[1]=Ksmall
                                        dbig[1]=Kbig
                                    elif D[1] >= Kbig:
                                        dbig[1]=Kbig
                                        dsmall[1]=D[1]-dbig[1]
                                    else:
                                        dbig[1]=D[1]
                                        dsmall[1]=0
                                    profitf[fsmall][fbig][i][j][p]=D[0]*p*10-(fsmall*fixed_costs[0][i+j-1]/2+fbig*fixed_costs[1][i+j-1]/2)-(dsmall[0]*var_costs[0][i+j-1][i][j]+dbig[0]*var_costs[1][i+j-1][i][j])
                                    profitf[fsmall][fbig][j][i][p]=D[1]*p*10-(fsmall*fixed_costs[0][i+j-1]/2+fbig*fixed_costs[1][i+j-1]/2)-(dsmall[1]*var_costs[0][i+j-1][j][i]+dbig[1]*var_costs[1][i+j-1][j][i])
                                optPf[i][j][fsmall][fbig]=10*np.argmax(profitf[fsmall][fbig][i][j])
                                optPf[j][i][fsmall][fbig]=10*np.argmax(profitf[fsmall][fbig][j][i])
                                maxPROFf[i][j][fsmall][fbig]=np.max(profitf[fsmall][fbig][i][j])
                                maxPROFf[j][i][fsmall][fbig]=np.max(profitf[fsmall][fbig][j][i])
                                maxPROFfij[i][j][fsmall][fbig]=maxPROFf[i][j][fsmall][fbig]+maxPROFf[j][i][fsmall][fbig]

price1=np.zeros((N_nodes,N_nodes))
f1=np.zeros((N_services,N_Vtypes))


price2=np.zeros((N_nodes,N_nodes))
f2=np.zeros((N_services,N_Vtypes))

for i in N:
    for j in N:
        if i<j:
            imax=np.unravel_index(np.argmax(maxPROFfij[i][j]), maxPROFfij[i][j].shape)
            price2[i][j]=optPf[i][j][imax[0]][imax[1]]
            price2[j][i]=optPf[j][i][imax[0]][imax[1]]
			
Flist=list(F)

del maxPROFf
del Viwtf
del profitf
gc.collect()

pvisit = []
fvisit = []

while (not price2.tolist() in pvisit) or (not f2.tolist() in fvisit):
    print(price2)
    price1=np.copy(price2)
    pvisit.append(price1.tolist())
    print(f2)
    f1=np.copy(f2)
    fvisit.append(f1.tolist())
    
    DemandMaxIWT=np.zeros((N_nodes,N_nodes,N_freq))
    for i in N:
        for j in N:
            DemandMaxIWT[i][j]=Diwtf[int(price1[i][j]/10)][i][j]

    n = gp.Model("SND_SAA.lp")

    freq = []
    bfreq=[]
    Fod=[]
    Dmax=[]
    flow = []
    vessel = []

    for s in S:
        freq.append([])
        vessel.append([])
        for k in K:
            freq[s].append(n.addVar(lb = 0, vtype = GRB.INTEGER, name = 'freq_sk('+str(s)+','+str(k)+')'))
            vessel[s].append(n.addVar(lb = 0, vtype = GRB.INTEGER, name = 'vessel_sk('+str(s)+','+str(k)+')'))

    z = []

    for i in N:
        flow.append([])
        z.append([])
        bfreq.append([])
        Fod.append([])
        Dmax.append([])
        for j in N:
            z[i].append([])
            flow[i].append([])
            bfreq[i].append([])
            Fod[i].append(n.addVar(lb = 0, vtype = GRB.INTEGER, name = 'freq_ij('+str(i)+','+str(j)+')'))
            Dmax[i].append(n.addVar(lb = 0, vtype = GRB.CONTINUOUS, name = 'Dmax_ij('+str(i)+','+str(j)+')'))
            for s in S:
                flow[i][j].append([])
                for k in K:
                    flow[i][j][s].append([])
                    for r in R:
                        flow[i][j][s][k].append(n.addVar(lb = 0, vtype = GRB.CONTINUOUS, name = 'x_ijskr('+str(i)+','+str(j)+','+str(s)+','+str(k)+','+str(r)+')'))
            for r in R:
                z[i][j].append(n.addVar(lb = 0, vtype = GRB.CONTINUOUS, name = 'z1_ijr('+str(i)+','+str(j)+','+str(r)+')'))
            for f in F:
                bfreq[i][j].append(n.addVar(lb = 0, vtype = GRB.BINARY, name = 'bf_ijf('+str(i)+','+str(j)+','+str(f)+')'))

    n.setObjective((1/N_draws)*(quicksum(price1[i][j]*flow[i][j][s][k][r] for i in N for j in N for s in S for k in K for r in R)-quicksum(freq[s][k]*fixed_costs[k][s] for s in S for k in K for r in R)-quicksum(flow[i][j][s][k][r]*(var_costs[k][s][i][j]) for k in K for s in S for i in N for j in N for r in R)))

    n.modelSense = GRB.MAXIMIZE
    n.update()


    for i in N:
        for j in N:
            for s in S:
                for k in K:
                    for r in R:
                        n.addConstr(flow[i][j][s][k][r] <= quicksum(usage_matrix[s][l][i][j] for l in L)*OD_matrix_allM[i][j])

    for k in K:     
        for s in S:
            n.addConstr(freq[s][k]<=maxCycles[k][s]*vessel[s][k])
    #         n.addConstr(freq[s][k]*(t_sail[k][s]+t_port[k][s])/T_operate<=vessel[s][k])
    #         n.addConstr((freq[s][k]*(t_sail[k][s]+t_port[k][s])/T_operate)+0.999>=vessel[s][k])
            for l in L:
                n.addConstr(quicksum((1/N_draws)*flow[i][j][s][k][r]*usage_matrix[s][l][i][j] for i in N for j in N for r in R) <= freq[s][k]*U_cap[k])

    for k in K:
        n.addConstr(quicksum(vessel[s][k] for s in S)<=V_fleet[k])

    for i in N:
        for j in N:
            for r in R:
                n.addConstr(quicksum(flow[i][j][s][k][r] for s in S for k in K)+z[i][j][r]==OD_matrix_allM[i][j])

    for i in N:
        for j in N:
            n.addConstr(quicksum(bfreq[i][j][f] for f in F)<=1)
            n.addConstr(Dmax[i][j]==quicksum(bfreq[i][j][f]*DemandMaxIWT[i][j][f] for f in F))
            n.addConstr(Fod[i][j]==quicksum(bfreq[i][j][f]*Flist[f] for f in F))
            n.addConstr(Fod[i][j]==quicksum(servOD_matrix[s][i][j]*freq[s][k] for s in S for k in K))
            n.addConstr(quicksum((1/N_draws)*flow[i][j][s][k][r] for s in S for k in K for r in R)<=Dmax[i][j])

    n.update()


    n.write('TEST_SNDpaper.lp')
#     n.setParam('OutputFlag', True)
    n.optimize()

    for i in N:
        for j in N:
            if i!=j:
                fs=int(sum(servOD_matrix[s][i][j]*freq[s][0].x for s in S))
                fb=int(sum(servOD_matrix[s][i][j]*freq[s][1].x for s in S))
                price2[i][j]=optPf[i][j][fs][fb]
                
    for s in S:
        for k in K:
            f2[s][k]=freq[s][k].x

                
dobj={'Amounts [EUR]': pd.Series([n.ObjVal,sum(price2[i][j]*flow[i][j][s][k][r].x for i in N for j in N for s in S for k in K for r in R)/N_draws,sum(f2[s][k]*fixed_costs[k][s] for s in S for k in K),sum(flow[i][j][s][k][r].x*var_costs[k][s][i][j] for k in K for s in S for i in N for j in N for r in R)/N_draws], index=['Profit','Revenue','FixedCosts','VariableCosts'])}


dfreq={}
dvessel={}
for k in K:
    fff=[]
    vvv=[]
    iii=[]
    for s in S:
        fff.append(freq[s][k].x)
        vvv.append(vessel[s][k].x)
        iii.append("-".join(service_list[s]))
    dfreq[vesseltypes[k]+'freq']=pd.Series(fff, index=iii)
    dvessel[vesseltypes[k]+'vessels']=pd.Series(vvv, index=iii)

dicofv = {**dfreq, **dvessel}


dprice={}
dvol={}
dshare={}

ppp=[]
vvv=[]
sss=[]
iii=[]
for i in N:
    for j in N:
        if i!=j:
            voliter=sum(flow[i][j][s][k][r].x for s in S for k in K for r in R)/N_draws
            if voliter>0:
                ppp.append(price2[i][j])
            else:
                ppp.append(-1000)
            vvv.append(voliter)
            if OD_matrix_allM[i][j]>0:
                sss.append(voliter/OD_matrix_allM[i][j])
            else:
                sss.append(0)
            iii.append(terminals[i]+"-"+terminals[j])
dprice["IWT"]=pd.Series(ppp, index=iii)
dvol["IWTvol"]=pd.Series(vvv, index=iii)
dshare["IWTshare"]=pd.Series(sss, index=iii)

ppp=[]
vvv=[]
sss=[]
for i in N:
    for j in N:
        if i!=j:
            ppp.append(costsROAD[i][j])
            volivola=0
            for r in R:
                if maxALT[i][j][r]==0:
                    volivola+=z[i][j][r].x
            vvv.append(volivola/N_draws)
            if OD_matrix_allM[i][j]>0:
                sss.append(volivola/N_draws/OD_matrix_allM[i][j])
            else:
                sss.append(0)
dprice["Road"]=pd.Series(ppp, index=iii)
dvol["Roadvol"]=pd.Series(vvv, index=iii)
dshare["Roadshare"]=pd.Series(sss, index=iii)

ppp=[]
vvv=[]
sss=[]
for i in N:
    for j in N:
        if i!=j:
            ppp.append(costsRAIL[i][j])
            volivola=0
            for r in R:
                if maxALT[i][j][r]==1:
                    volivola+=z[i][j][r].x
            vvv.append(volivola/N_draws)
            if OD_matrix_allM[i][j]>0:
                sss.append(volivola/N_draws/OD_matrix_allM[i][j])
            else:
                sss.append(0)
dprice["Rail"]=pd.Series(ppp, index=iii)
dvol["Railvol"]=pd.Series(vvv, index=iii)
dshare["Railshare"]=pd.Series(sss, index=iii)

ppp=[]
vvv=[]
sss=[]
for i in N:
    for j in N:
        if i!=j:
            ppp.append(costsIC[i][j])
            volivola=0
            for r in R:
                if maxALT[i][j][r]==2:
                    volivola+=z[i][j][r].x
            vvv.append(volivola/N_draws)
            if OD_matrix_allM[i][j]>0:
                sss.append(volivola/N_draws/OD_matrix_allM[i][j])
            else:
                sss.append(0)
dprice["IC"]=pd.Series(ppp, index=iii)
dvol["ICvol"]=pd.Series(vvv, index=iii)
dshare["ICshare"]=pd.Series(sss, index=iii)

dicovs = {**dvol, **dshare}

with pd.ExcelWriter('heur3MIX9n_'+sys.argv[2]+'_'+sys.argv[1]+'.xlsx') as writer:
    pd.DataFrame(dobj).to_excel(writer,sheet_name='ObjectiveFunction')
    pd.DataFrame(dprice).to_excel(writer,sheet_name='Prices')
    pd.DataFrame(dicofv).to_excel(writer,sheet_name='Frequencies')
    pd.DataFrame(dicovs).to_excel(writer,sheet_name='Shares')
