# Energy-Aware and Quantized Training for Vision Models

This repository provides training pipelines for Vision Transformers (ViT) and ResNet-34 using approximate multipliers and variational inference strategies inspired by Occam’s Razor. It includes energy-aware training, post-training quantization, and supports object detection datasets including Waymo, nuScenes, and KITTI.

## Features

- Energy-efficient variational training with real-time energy tracking.
- Post-training 8-bit quantization with approximate arithmetic.
- Dataset support: Waymo Open Dataset (TFRecord), nuScenes, KITTI.
- Implementations in both PyTorch and TensorFlow.
- ViT and ResNet-based models integrated with approximate computation logic.

## Requirements

Install dependencies using the provided `requirements.txt`:

```bash
pip install -r requirements.txt


# Train with Energy-Aware (VIET) or Post-Training Quantization (VIPT) in PyTorch

python main.py --dataset [kitti|nuscenes|waymo] --data_path /path/to/data --mode [viet|vipt]


