# Evaluating Error Message Hints in Agda: User Study Data

This repository contains the user study data accompanying the thesis "_Enhancing Proof Assistant Error Messages with Hints: A User Study_". 

## Programming Questions

We provide all of the programming exercises created for the user study in `programming_exercises`. There, each folder corresponds to a programming exercise. The folder name correlates to how the exercises are referred to in `response-data.json` and in the thesis.

We created the following exercises for the user study:

| Full exercise name used in thesis | Hint correctness | Exercise name used in respository |
| --------------------------------- | ---------------- | --------------------------------- |
| `Missing Space (A)`               | Correct          | `Missing-Space_CORRECT_(A)`       |
| `Missing Space (B)`               | Correct          | `Missing-Space_CORRECT_(B)`       |
| `Missing Space (C)`               | Incorrect        | `Missing-Space_INCORRECT_(C)`     |
| `Missing Space (D)`               | Incorrect        | `Missing-Space_INCORRECT_(D)`     |
| `Unicode Confusables (A)`         | Correct          | `Unicode-Confusables_CORRECT_(A)` |
| `Unicode Confusables (B)`         | Correct          | `Unicode-Confusables_CORRECT_(B)` |
| `Too Few Args (A)`                | Correct          | `Too-Few-Args_CORRECT_(A)`        |
| `Too Few Args (B)`                | Correct          | `Too-Few-Args_CORRECT_(B)`        |
| `Too Few Args (C)`                | Incorrect        | `Too-Few-Args_INCORRECT_(C)`      |
| `Too Few Args (D)`                | Incorrect        | `Too-Few-Args_INCORRECT_(D)`      |

For clarity, we have appended the hint correctness to the names of the programming exercises.

The following files can be found in each exercise folder:

- `exercise.agda` : the pre-written code presented to the participant. There is exactly one error in it.
- `expected_solution.agda` : the expected solution for the exercise
- `ORIGINAL.err` : the original Agda error message - without the hint (as is shown in WebLab)
- `ENHANCED.err` : the enhanced Agda error message - with the hint (as is shown in WebLab)
- `README.md` : a brief description of the "mistake" we wanted to mimic in creating the programming exercise

As the exercise file is referred to as `solution.agda` by WebLab, the error message files reference the error being in `solution.agda`.

## Response Data

The response data is represented in `response-data.json`.

The structure of the data is clarified in the following annotated excerpt:

```
{
    "VARIANT A": {                                  <--- VARIANT
        "Too-Few-Args_CORRECT_(B)_ORIGINAL": {      <--- PROGRAMMING EXERCISE NAME
            "00": {                                 <--- PARTICIPANT ID
                "succeeded": true,                  
                "timestamps": [
                    1743413319000,
                    1743413269000
                ],
                "Likert response": 3
            },
```

- **VARIANT:** The variant that the responses come from (A or B)
- **PROGRAMMING EXERCISE NAME:** The name of the exercise. It is separated into the following parts:
    - Which hint was evoked by the programming question:
        - `Unicode-Confusables`
        - `Missing-Space`
        - `Too-Few-Args`
    - Does the evoked hint provide a "`CORRECT`" or "`INCORRECT`" suggestion?
    - Identifying letter of the programming exercise. This is done to differentiate between the (2-4) different exercises that were created for each hint.
        - `(A)` and `(B)` are reserved for exercises that evoke "correct" hints
        - `(C)` and `(D)` are reserved for exercises that evoke "incorrect" hints
    - Are these responses for the "original" or "enhanced" error messages?
        - `ORIGINAL` : participants received the original error message (without hint)
        - `ENHANCED` : participants received the enhanced error message (with hint) 

This structure correlates with how these programming exercises are referred to within the thesis. For example, submissions from `Too-Few-Args_CORRECT_(B)_ORIGINAL` and `Too-Few-Args_CORRECT_(B)_ORIGINAL` are referred to as "`Too Few Args (B)`".

Furthermore, this can be used to get the programming question and accompanying error message(s) from this repository. Taking `Too-Few-Args_CORRECT_(B)_ORIGINAL` as an example,

- The programming exercise can be found at `exercise.agda` in the folder `Too-Few-Args_CORRECT_(B)`
- The error message participants received can be found at `ORIGINAL.err` in `Too-Few-Args_CORRECT_(B)`

- **PARTICIPANT ID:** An anonymised representation of the participant. Each participant is assigned a random number in the range (0-72).

### Submission Information

- `succeeded` : a boolean representing if the participant managed to successfully resolve the error
- `timestamps` : a list of epoch timestamps of each time the participant recompiled the programming exercise. If `succeeded` is true, then only the last timestamp is a success.
- `likert_reponse` : a numerical representation of the response the participant gave to the question _"Did you find the error message helpful"_

| Likert Response | Number |
| --- | --- |
|'The error message was very helpful' | 5 |
| 'The error message was helpful' | 4 |
| 'The error message was neither helpful nor misleading' | 3 |
| 'The error message was misleading' | 2 |
| 'The error message was very misleading' | 1 |
| '(N/A) I did not read the error message' | 0 |


