data List (A : Set) : Set where
  []    : List A
  _::_  : A → List A → List A
infixr 5 _::_

_++_ : {A : Set} → List A → List A → List A
[]         ++  ys  = ys
(x :: xs)  ++  ys  = x :: (xs ++ ys)
infixr 5 _++_

foldr : {A B : Set} → (A → B → B) → B → List A → B
foldr c n []       = n
foldr c n (x :: xs) = c x (foldr c n xs)

intersperse : {A : Set} → A → List A → List A
intersperse x []       = []
intersperse x (y :: []) = y :: []
intersperse x (y :: ys) = y :: x :: foldr x ys

