open import Agda.Builtin.Nat public
open import Agda.Builtin.Equality public

-- symmetry of equality
sym : {A : Set} {x y : A} → x ≡ y → y ≡ x
sym refl = refl

-- transitivity of equality
trans : {A : Set} {x y z : A} → x ≡ y → y ≡ z → x ≡ z
trans refl refl = refl

-- congruence of equality
cong : {A B : Set} {x y : A} → (f : A → B) → x ≡ y → f x ≡ f y
cong f refl = refl

_=⟨_⟩_ : {A : Set} → (x : A) → {y z : A}
       → x ≡ y → y ≡ z → x ≡ z
x =⟨ p ⟩ q = trans p q
infixr  2  _=⟨_⟩_

_=⟨⟩_ : {A : Set} → (x : A) → {y : A} → x ≡ y → x ≡ y
x =⟨⟩ q = x =⟨ refl ⟩ q
infixr  2  _=⟨⟩_

begin_ : {A : Set} → {x y : A} → x ≡ y → x ≡ y
begin p = p
infix   1  begin_

_end : {A : Set} → (x : A) → x ≡ x
x end = refl
infix   3  _end

postulate
  +-identity : ∀ (m : Nat) → m + zero ≡ m
  +-suc : ∀ (m n : Nat) → m + suc n ≡ suc (m + n)
  
id : (A : Set) -> A -> A
id A x = x

+-comm : ∀ (m n : Nat) → m + n ≡ n + m
+-comm m zero =
  begin
    m + zero
  =⟨ +-id m ⟩
    zero + m
  end 
+-comm m (suc n) = 
  begin
    m + (suc n)
  =⟨ +-suc m n ⟩
    suc (m + n)
  =⟨ cong suc (+-comm m n) ⟩
    (suc n) + m
  end
