open import Agda.Builtin.Equality public
open import Agda.Builtin.Nat public
open import Agda.Builtin.Bool public
open import Agda.Builtin.List public

data ⊥ : Set where
    
¬_ : Set → Set
¬ A = A → ⊥

infix 3 ¬_

~_ : Bool → Bool
~ true = false 
~ false = true

infix  7 ~_

giveNum : Bool → Nat
giveNum false = 1 
giveNum true = 2

giveNum-diff-results : (b : Bool) → ¬(giveNum b ≡ giveNum (~b))
giveNum-diff-results false = λ () 
giveNum-diff-results true = λ ()
