open import Agda.Builtin.Nat public

data _×_ (A B : Set) : Set where
  _,_ : A → B → A × B
  
fst : {A B : Set} → A × B → A
fst (x , y) = x

snd : {A B : Set} → A × B → B
snd (x , y) = y

data Vec (A : Set) : Nat → Set where
  []    : Vec A zero
  _::_  : {n : Nat} → A → Vec A n → Vec A (suc n)
infixr 5 _::_

_++_ : {A : Set}{n m : Nat} → Vec A m → Vec A n → Vec A (m + n)
[]        ++ ys = ys
(x :: xs) ++ ys = x :: (xs ++ ys)
infixr 5 _++_

zip : ∀ {n} {A B : Set} → Vec A n → Vec B n → Vec (A × B) n
zip []        []        = []
zip (x :: xs) (y :: ys) = (x , y) :: zip xs ys
