data ℕ : Set where
  zero : ℕ
  suc : ℕ → ℕ

Nat = ℕ

infixl 9 _+_ 

_+_ : ℕ → ℕ → ℕ
zero  + n = n
suc m + n = suc (m + n)

data _≡_ {ℓ} {A : Set ℓ} (x : A) : A → Set ℓ where
  refl : x ≡ x

{-# BUILTIN EQUALITY _≡_ #-}

infix 3 _≡_ 

+assoc : ∀ (a b c : ℕ) → a + (b + c) ≡ (a + b) + с
+assoc zero b c = refl
+assoc (suc a) b c rewrite +assoc a b c = refl
