open import Agda.Builtin.Nat public

data Fin : Nat → Set where
  zero : {n : Nat} → Fin (suc n)
  suc  : {n : Nat} → Fin n → Fin (suc n)

data Vec (A : Set) : Nat → Set where
  []    : Vec A zero
  _::_  : {n : Nat} → A → Vec A n → Vec A (suc n)
infixr 5 _::_

updateElement : {A B : Set}{n : Nat} → Vec A n → Fin n → B → (A → B → A) → Vec A n
updateElement (x :: xs) zero    b f = f x b :: xs
updateElement (x :: xs) (suc i) b f = x :: updateElement xs i b f
