open import Agda.Builtin.Nat public

data _×_ (A B : Set) : Set where
  _,_ : A → B → A × B
  
fst : {A B : Set} → A × B → A
fst (x , y) = x

snd : {A B : Set} → A × B → B
snd (x , y) = y

data Fin : Nat → Set where
  zero : {n : Nat} → Fin (suc n)
  suc  : {n : Nat} → Fin n → Fin (suc n)

data Vec (A : Set) : Nat → Set where
  []    : Vec A zero
  _::_  : {n : Nat} → A → Vec A n → Vec A (suc n)
infixr 5 _::_

removeAt : {A : Set}{n : Nat} → Vec A (suc n) → Fin (suc n) → Vec A n
removeAt (x :: xs)         zero    = xs
removeAt (x :: xs@(_ :: _)) (suc i) = x :: removeAt xs i
