%% this script processes the pressure data from the hydrophone 
clearvars


% after copying the data in the right folder, execute the script that
% processes the data "processDataGeneral.mat"in EMLab

%then import hte mat file containing the extracted data
frequency = 2.5;   % enter the frequency in MHz
% starting_distance = 10;
% pressure profile of 1 MHz was measured with 50V at TX. 
fun1MHz = @(x) 0.00416*x - 0.000213;
% pressure profile of 2.5 MHz was measured with 10V at TX. 
fun2_5MHz = @(x) 0.0034911*x - 0.0027092;
test_voltage_TX = 95; % input voltage at TX during power transfer experiment 

[filename,pathname] = uigetfile('C:\Users\320033994\OneDrive - Philips\Power transfer\Experiments\US vs inductive benchmarking\EM_lab_processed_data\*.mat','Select the mat file containing the data');

load(strcat(pathname,filename));
acoustic_data = acoustic{1,2};
acoustic_info_exp = acoustic{1,1};
clearvars acoustic

% find number of rows matrix
rows = length(find(arrayfun(@(x) acoustic_data(x).Y == 0, 1:numel(acoustic_data))));
col = find(diff([acoustic_data.Z]'),1);
dim3 = length(unique([acoustic_data.X]'));

% extract the matrices of the measurement position and the pkpk value 
z_matrix  = transpose(reshape([acoustic_data.Z]',col,rows));
y_matrix  = transpose(reshape([acoustic_data.Y]',col,rows));
x_matrix  = [acoustic_data.X]';
voltage_matrix = transpose(reshape([acoustic_data.sourcepp]',col,rows)); % extracts the Vpp of the line vector which containes the volatge signal of the hidrophone to be transformed in pressure
vin_matrix = transpose(reshape([acoustic_data.signalpp]',col,rows)); % extracts the Vpp of the input signal to the transducer

% rearranges the data in the matrix 
for k = 2:2:rows
    voltage_matrix(k,:) = fliplr(voltage_matrix(k,:));
    vin_matrix(k,:) = fliplr(vin_matrix(k,:));
    y_matrix(k,:) = fliplr(y_matrix(k,:));
end

needle = acoustic_info_exp.needle.data;

% find the sensitivity of the needle at that frequency
total_sensitivity = needle{1, 2}.sens_needle;
[~, sensitivity_index] = min(abs(frequency-needle{1, 2}.freq_needle)); % find the closest frequency of the calibrated ones to the actual measuring frequency
sensitivity = total_sensitivity(sensitivity_index); % sensitivity = mV/MPa


% calculate pressure and intensity 
% the pressure from the hydrophone is the peak to peak pressure
pressure = (voltage_matrix.*10^(3))./sensitivity;    % pressure in MPa  (multiply voltage by 10^3 to have mV)


% 3D plot
figure
surf(y_matrix,z_matrix,pressure,'edgecolor','interp')
zlabel('Pressure [MPa]')
xlabel('Y [mm]')
ylabel('Z [mm]')
title(['Vin = ',num2str(vin_matrix(1)*10),'V'])

%2D plot
figure;
imagesc(y_matrix(1,1:col),z_matrix(1:rows,1),pressure)
c = colorbar;
c.Label.String = 'Pressure peak-to-peak [MPa]';
xlabel('Y [mm]')
ylabel('Z [mm]')
title(['Vin = ',num2str(vin_matrix(1)*10),'V'])


pressure_scaling_coeff = test_voltage_TX/ (vin_matrix(1)*10);

pressure_PT_experiment = pressure * pressure_scaling_coeff;
figure;
imagesc(y_matrix(1,1:col),z_matrix(1:rows,1),pressure_PT_experiment)
xlabel('Y [mm]')
ylabel('Z [mm]')
title(['Vin = ',num2str(test_voltage_TX),'V'])
xlim([-5.5 5.5])
ylim([-5.5 5.5])
daspect([1,1,1])
c = colorbar;
c.Label.String = 'Pressure peak-to-peak [MPa]';

    % intensity = (pressure.*(10^6)).^2/(8*1.483e6);    % intensity from measurement I = p(pkpk)^2/(8*water_imped)


% %% compare to simulation results
% 
% % extract output pressure field at y=0 --> create cross-section
% y0 = find(y_matrix ==0); % find the index of the colum of zeros
% line_pressure_1 = pressure(y0);
% z0 = find(z_matrix == 0);
% line_pressure_2 = pressure(z0);
% 
% figure;
% plot(z_matrix(y0),line_pressure_1./max(line_pressure_1),'.--')
% hold on
% plot(y_matrix(z0),line_pressure_2./max(line_pressure_2),'.--')
% plot(y*1000,abs_pressure(slice,:)./max(abs_pressure(slice,:)), 'k','linewidth',1)
% ylabel('Normalized Pressure')
% xlabel('Lateral distance from centre [mm]')
% title(['Pressure Field at ', num2str(distance*1000),' mm'])

%% calculation of the average power received by the receiver

% rough calculation
power_at_receiver = [];
average_intensity_ROI = [];
peak_to_peak_pressure_ROI_phase = [];
power_at_receiver_ampl = [];

lines=1;
for dimY = 2:2:10 % first dimesion of the receiver in mm (it is actually half of the dimension of the side)
    dimZ = dimY; % second dimension of the reciver in mm
    area_occupied = (dimY*2) * (dimZ*2); % area occupied by the receiver

    % find the indices of the data corresponding to the area 
    ROI_indices = find(abs([acoustic_data.Z])'<= dimZ & abs([acoustic_data.Y])'<= dimY);

    % determine the number of rows and columns in the region of interest
    rows_ROI = length(find([acoustic_data(ROI_indices).Y]' == 0));
    col_ROI = find(diff([acoustic_data(ROI_indices).Z]'),1);

    % build matrices out of the data 
    z_matrix_ROI  = transpose(reshape([acoustic_data(ROI_indices).Z]',col_ROI,rows_ROI));
    y_matrix_ROI  = transpose(reshape([acoustic_data(ROI_indices).Y]',col_ROI,rows_ROI));

    voltage_matrix_ROI = transpose(reshape([{acoustic_data(ROI_indices).line}]',col_ROI,rows_ROI)); % extracts the signal recorded at each point of the selected region of interest. 
    % Each cell contains the recording 
    
    % create a matrix that contains all the data in one big matrix, with each
    % recording one below each other 

    total_voltage_matrix_ROI = zeros(rows_ROI+col_ROI, length(voltage_matrix_ROI{1,1}));
    total_voltage_ampl = zeros(rows_ROI,col_ROI);
    k =1;
    figure;
    for i = 1:rows_ROI
        for j = 1:col_ROI
            total_voltage_matrix_ROI(k,:) = voltage_matrix_ROI{i,j}; % extracts the signal recorded at each point of the selected region of interest. 
            total_voltage_ampl(i,j) = max(total_voltage_matrix_ROI(k,11000:15000)) - min(total_voltage_matrix_ROI(k,11000:15000));
            k = k+1;
            plot(voltage_matrix_ROI{i,j});
            hold on
        end
    end

    % summ all the recordings together and divide by the number of them 
    average_voltage_ROI = mean(total_voltage_matrix_ROI);
%     plot(average_voltage_ROI, 'k', 'linewidth', 1)
    average_pressure_ROI = pressure_scaling_coeff * (average_voltage_ROI.*10^(3))./sensitivity; % pressure in MPa  (multiply voltage by 10^3 to have mV)
    average_pressure_ROI_ampl = pressure_scaling_coeff * (mean(total_voltage_ampl,'all')*10^3)/sensitivity;
    peak_to_peak_pressure_ROI_phase(lines,:) = (max(average_pressure_ROI) - min(average_pressure_ROI));

    % calculate intensity 
    average_intensity_ROI(lines,:) = (peak_to_peak_pressure_ROI_phase(lines,:).*(10^6)).^2/(8*1.483e6);    % intensity from measurement I = p(pkpk)^2/(8*water_imped) [W/m^2]
    average_intensity_ROI_ampl = (average_pressure_ROI_ampl.*(10^6)).^2/(8*1.483e6);
    power_at_receiver(lines,:) = average_intensity_ROI(lines,:) * area_occupied *1e-6;
    power_at_receiver_ampl(lines,:) = average_intensity_ROI_ampl * area_occupied *1e-6;
    lines=lines+1;
    
end

figure;
plot((2:2:10)*2, power_at_receiver*1e3,'.-k','linewidth', 1.5,'MarkerSize',20)
hold on
plot((2:2:10)*2, power_at_receiver_ampl*1e3,'.-k')
ylabel('Average power at receiver [mW]')
xlabel('Lateral dimension of receiver [mm]')
grid on

figure;
yyaxis left
plot((2:2:10)*2, average_intensity_ROI*0.1,'.-','linewidth', 1.5,'MarkerSize',20)
ylabel('Avearge intensity at receiver [mW/cm^2]')
xlabel('Lateral dimension of receiver [mm]')
grid on

yyaxis right
plot((2:2:10)*2, peak_to_peak_pressure_ROI_phase,'.-','linewidth', 1.5,'MarkerSize',20)
ylabel('Average peak-to-peak pressure at receiver [MPa]')



% 
% %% precise calculation
% 
% diam_drum = 85e-6;
% radius_drum = diam_drum/2;
% drum_pcolumn = 56;
% drum_rows = 6;
% num_drums = drum_pcolumn * drum_rows;
% 
% % calculates the dimensions of the packing in which the CMUTs are arranged
% height_packing = (2*drum_pcolumn+1)*radius_drum;
% width_packing = (2 + (drum_rows -1)*sqrt(3))*radius_drum;
% area_occupied = height_packing * width_packing; % area occupied by the packing 
% 
% % position of the centers of the drums 
% 
% x_center = linspace(-width_packing/2+radius_drum,width_packing/2-radius_drum,drum_rows)';
% y_center = linspace(-height_packing/2+radius_drum,height_packing/2-radius_drum,drum_pcolumn)';
% 
% [x_mesh,y_mesh] = meshgrid(x_center,y_center);
% 
% for k = 2:2:drum_rows
%     y_mesh(:,k) = y_mesh(:,k)-radius_drum;
% end
% 
% % builds teh array of the position of the centers of the drums 
% 
% z_center_total = reshape(y_mesh,[],1);
% y_center_total = reshape(x_mesh,[],1);
% center_drums = [y_center_total z_center_total];
% 
% %% build an interpolant function
% 
% y_array = reshape(y_matrix,[],1)*1e-3;
% z_array = reshape(z_matrix,[],1)*1e-3;
% intensity_array = reshape(intensity,[],1);
% 
% F = scatteredInterpolant(y_array,z_array,intensity_array);
% %% evaluate the interpolant in the center of the drums
% 
% intensity_interp = F(y_center_total,z_center_total);
% 
% % plots the pressure values 
% % figure
% % plot3(y_array,z_array,F(y_array,z_array),'o')
% % grid on
% % hold on
% % plot3(y_center_total,z_center_total,intensity_interp,'o')
% % legend('measured pressure','extrapolated pressure','location','best')
% % zlabel('Intensity [W/m^2]')
% 
% %% calculate the efficiency
% mean_total_intensity = mean(intensity_interp);
% % mean_total_pressure = mean(acoustic.SourcePeakPeak.*1e9./sensitivity)/sqrt(8)
% mean_total_pressure = mean(mean(pressure/2))
% power_US = mean_total_intensity*area_occupied % the area occupied is a pi/(2+sqrt(3)) fraction of that area 
% 
% Efficiency = max_power/power_US*100  
% %%
% 
% % rearrange the interpolated intensity in a matrix
% intensity_interp_matrix = reshape(intensity_interp,56,6);
% 
% 
% figure
% % surf(y_interp_grid*1e-3,z_interp_grid*1e-3,pressure_interp,'edgecolor','interp')
% surf(x_mesh,y_mesh,intensity_interp_matrix,'edgecolor','interp')
% xlabel('Width [m]')
% ylabel('Height [m]')
% xlim([min(y_center_total)-radius_drum max(y_center_total)+radius_drum])
% ylim([min(z_center_total)-radius_drum max(z_center_total)+radius_drum])
% hp = colorbar;
% 
% ylabel(hp,'W/m^2')
% title(['Intensity at CMUT surface, ', num2str(frequency),'MHz'])
% hold on
% viscircles(center_drums,radius_drum*ones(num_drums,1),'EnhanceVisibility',false,'linewidth',1.5);
% daspect([1 1 350000])
% % imagesc(y_interp*1e-3,z_interp*1e-3,pressure_interp)
% imagesc([min(y_center_total)-radius_drum max(y_center_total)+radius_drum],[min(z_center_total)-radius_drum max(z_center_total)+radius_drum],intensity_interp_matrix)
% % rectangle('position',[-width_packing/2-radius_drum -height_packing/2-2*radius_drum width_packing+2*radius_drum height_packing+3*radius_drum])
% % set(gca,'FontName','Arial','FontSize',18)
% 
% %% calculate feasibility in humans
% 
% % take max pressure value, therefore divide by 2 since it's pkpk what is
% % measured
% z_0 = 993*1515; % rho*c
% TBD = 10/frequency; %10 cycles of burst
% PRF = 10;
% % pulse intensity integral
% PII = (pressure/2*1e6).^2*TBD/(2*z_0);  
% 
% Isppa = PII/TBD*1e-4; % in W/cm^2
% Ispta = PII*PRF*1e-4; % in W/cm^2
% 
% max_Isppa = max(max(Isppa)) % in W/cm^2
% max_Ispta = max(max(Ispta))*1e3 % in mW/cm^2
% MI = max(max(pressure/2))/sqrt(frequency)

