% this script tests the effct of the partitioning on the simulation

clearvars;

% define the varibales of the TX transducer
frequency = 1e6; % frequency of the simulation
% radius = in2m(1.5/2); % transform to meters the radius of the TX
radius = 39e-3/2;

rotation_phi_deg = 0; % rotation of the TX transducer according to Euler angles in degrees
rotation_theta_deg = 0;
rotation_psi_deg = 0;

lateral_shift_x = 0; % shift of centre of TX with respect to centre of RX in meters 
lateral_shift_y = 0; 

% define the variables of the RX transducer
RX_x = 20*1e-3; % dimension of RX in x coordinate
RX_y = RX_x; % dimension of RX in y coordinate
test_distance = 221*1e-3; % distance at which to perform the simulation in meters

% correcting_factor_phase = 0.9717; % ratio between the phase power to pkpk power with no partitioning and no misalignment. Calculate this at the start  

medium = set_medium('water');
% medium.attenuationdBcmMHz = 0.6;
% lateral_step = 2e-3;

%% calculate the power without partitioning
  
% shift the position of the TX transducer such that the area on
% whcih to calculate the power is still at the centre
for rotation = 1:length(rotation_theta_deg)

    coord_shift = rotate_vector_forward([lateral_shift_x lateral_shift_y test_distance], ...
                    [deg2rad(rotation_phi_deg) deg2rad(rotation_theta_deg(rotation)) deg2rad(rotation_psi_deg)]);  
    
    xdc = get_circ(radius, -coord_shift + [0 0 test_distance],...
                    [deg2rad(rotation_phi_deg) deg2rad(rotation_theta_deg(rotation)) deg2rad(rotation_psi_deg)]);
    
    xy_edges = [0.02 0.04];
    for field_size = 1:length(xy_edges)
    
        % this measures are in meters
        xmin = -xy_edges(field_size);
        xmax = -xmin;
        ymin = -xy_edges(field_size);
        ymax = -ymin;
        zmin = test_distance;
        zmax = test_distance;
        
        % [delta, xpoints, ypoints, zpoints] = create_input_coordinate_grid(xmin,xmax,ymin,ymax,zmin,zmax,lateral_step);
        delta = [(xmax-xmin)/2001 (ymax-ymin)/2001 1];                                                                      
        coord_grid=set_coordinate_grid(delta, xmin, xmax, ymin, ymax, zmin, zmax);
        
        ndiv= 20;
        p_cw=cw_pressure(xdc, coord_grid, medium, ndiv, frequency); % simulate the pressure filed
        
        x = xmin:delta(1):xmax;
        y = ymin:delta(2):ymax;
        z = zmin:delta(3):zmax;
        
        clearvars xmin xmax ymin ymax zmin zmax xpoints ypoints zpoints 
        
        
        % extracts the pressure values that are in the area corresponding to the
        % size of the receiver 
        ROI_x_simulation = find(abs(x*1e4) <= RX_x*1e4/2);
        ROI_y_simulation = find(abs(y*1e4) <= RX_y*1e4/2);
        ROI_pressure_simulation = p_cw(ROI_x_simulation, ROI_y_simulation);
                               
        [mean_power_simulation_phase, mean_power_simulation_pkpk] = ...
            calculate_power_simulation_CW(frequency,medium,ROI_pressure_simulation,RX_x,RX_y,'n');
        
        %% test the partitioning 
        
        partitions = 4; % partitions per side
        
        remainder = mod(size(ROI_pressure_simulation,1),partitions); % remaining measurement points after subdivision in partitions
        measurement_pt_partition = floor(size(ROI_pressure_simulation,1)./partitions);
        subdivision_table = table(partitions, measurement_pt_partition, remainder,'VariableNames',{'partitions','pt_in_partition','remainder'});
        
        % remove combinations in which less than two points in the measurements is
        % available and when there are too many remainders
        subdivision_table = subdivision_table(subdivision_table.pt_in_partition >= 2 & subdivision_table.remainder < subdivision_table.partitions/3,:);
        % subdivision_table = subdivision_table(subdivision_table.pt_in_partition >= 2 & subdivision_table.remainder == 0,:);
        
        k=1;
        data_power_partitioning = zeros(height(subdivision_table),6);
        for a = 1:height(subdivision_table)
        
            disp(['Calculating partition ', num2str(subdivision_table.partitions(a)), ' angle ', num2str(rotation_theta_deg(rotation))])
            % define the subareas cerated by the partitons
            size_partition_x = RX_x/subdivision_table.partitions(a); % lateral size of the partition
            size_partition_y = size_partition_x;
            % add one more measurement point to the partition if there is a remainder from the division
            
            partition_allocation = repmat(subdivision_table.pt_in_partition(a),1,subdivision_table.partitions(a)); % this is the ideal distribution of the point when there is no remainder from the division
            partition_allocation(round(linspace(1,subdivision_table.partitions(a),subdivision_table.remainder(a)))) = ...
                partition_allocation(round(linspace(1,subdivision_table.partitions(a),subdivision_table.remainder(a)))) + 1;
        
        
            % subdivide the data into the partitions 
            sub_array = mat2cell(ROI_pressure_simulation,partition_allocation,partition_allocation);
        
            mean_power_partition_phase = zeros(size(sub_array));
            mean_power_partition_pkpk = zeros(size(sub_array));
            for b = 1:size(sub_array,1)
                for c = 1:size(sub_array,2)
                    % calculate the power in each of the paritions 
        
                    [mean_power_partition_phase(b,c), mean_power_partition_pkpk(b,c)] = ...
                            calculate_power_simulation_CW(frequency,medium,sub_array{b,c},size_partition_x,size_partition_y,'n');
                end
            end
        
            % summarize results in table 
            data_power_partitioning(k,:) = [subdivision_table.partitions(a), size_partition_x,...
                sum(mean_power_partition_pkpk,'all'), sum(mean_power_partition_phase,'all'),mean_power_simulation_pkpk,mean_power_simulation_phase];
            k=k+1;
        end
    
        if exist('data_table','var') == 1 % if table exists already, append
            appended_table = array2table(data_power_partitioning,'VariableNames',...
                {'n_partitions','size_partition','power_pkpk','power_phase','power_pkpk_nopart','power_phase_nopart'});
            data_table = [data_table; appended_table];
        else
            data_table = array2table(data_power_partitioning,'VariableNames',...
                {'n_partitions','size_partition','power_pkpk','power_phase','power_pkpk_nopart','power_phase_nopart'});
        end
    end
    
    data_table = sortrows(data_table,"n_partitions");
    % unify redundant rows in table 
    unique_partitions = unique(data_table.n_partitions);
    summary_table = table('Size',[length(unique_partitions), 7],'VariableNames',...
        {'n_partitions','size_partition','power_pkpk','power_phase','power_pkpk_nopart','power_phase_nopart','angle'},...
                'VariableTypes',["double","double","double","double","double","double","double"]);
    for w = 1:length(unique_partitions)
        table_extract = data_table(data_table.n_partitions == unique_partitions(w),:);
        table_extract = varfun(@mean, table_extract, 'InputVariables', @isnumeric);
        summary_table(w,:) = [table_extract,array2table(rotation_theta_deg(rotation))];
    end

    if exist('final_table','var') == 1 % if table exists already, append
        final_table = [final_table; summary_table];
    else
        final_table = summary_table;
    end

    clearvars data_table
    
    % test improvement with partitioning 
%     improvement = final_table.power_phase./(final_table.power_pkpk*correcting_factor_phase);
    
%     lambda = medium.soundspeed/frequency; % wavelength
    
    % figure
    % semilogx(final_table.size_partition/lambda,improvement,'Marker','o','MarkerSize',8)
    % xlabel('Number of wavelengths')
    % ylabel('Relative efficiency')
    % 
    % figure
    % semilogx(final_table.n_partitions.^2,improvement,'Marker','o','MarkerSize',8)
    % xlabel('Number of partitions')
    % ylabel('Relative efficiency')
    
    
    % figure
    % t = tiledlayout(1,1);
    % ax1 = axes(t); 
    % semilogx(final_table.n_partitions.^2,improvement,'Marker','.','MarkerSize',4)
    % xlabel('Number of partitions')
    % ylabel('Relative efficiency')
    % xlim([min(final_table.n_partitions.^2) max(final_table.n_partitions.^2)])
    % ylim([0 1])
    % ax1.XTick = final_table.n_partitions.^2;
    % ax1.XTickLabelRotation = 45;
    % legend('10 deg')
    % 
    % ax2 = axes(t);
    % ax2.XAxisLocation = 'top';
    % ax2.YAxisLocation = 'right';
    % ax2.XScale = 'log';
    % ax2.Color = 'none';
    % % ax1.Box = 'off';
    % % ax2.Box = 'off';
    % ax2.YAxis.Visible = 'off'; 
    % xlabel('Number of wavelengths')
    % ax2.XLim = [min(final_table.size_partition/lambda) max(final_table.size_partition/lambda)];
    % ax2.XDir = "reverse";
    % ax2.XTick = flipud(final_table.size_partition/lambda);
    % % ax2.XTickLabel = num2str(round(flipud(final_table.size_partition/lambda),1));
    % ax2.XTickLabelRotation = 45;
    
%     figure
%     semilogx(final_table.n_partitions.^2,improvement,'Marker','.','DisplayName',[num2str(rotation_theta_deg(rotation)),' deg'])
%     xlabel('Number of partitions')
%     ylabel('Relative efficiency')
%     xlim([min(final_table.n_partitions.^2) max(final_table.n_partitions.^2)])
%     ylim([0 1])
%     ax1 = gca;
%     ax1.XTick = final_table.n_partitions.^2;
%     ax1.XTickLabelRotation = 90;
%     ax1.XAxis.MinorTick = 'off';
%     legend
%     
%     ax2 = axes('Position',get(ax1,'Position'),...
%                'XAxisLocation','top',...
%                'YAxisLocation','right',...
%                'Color','none',...
%                'XScale','log');
%     
%     ax2.YAxis.Visible = 'off';
%     ax2.YTick = [];
%     xlabel('Number of wavelengths')
%     ax2.XLim = [min(final_table.size_partition/lambda) max(final_table.size_partition/lambda)];
%     ax2.XDir = "reverse";
%     ax2.XTick = flipud(final_table.size_partition/lambda);
%     ax2.XTickLabel = compose('%1.1f', flipud(final_table.size_partition/lambda));
%     ax2.XTickLabelRotation = 90;
%     ax2.XAxis.MinorTick = 'off';
%     
%     % linking axis
%     linkprop([ax1, ax2],{'Units','Position','ActivePositionProperty'});
%     ax1.Position(4) = ax1.Position(4) * .93;


end

lambda = medium.soundspeed/frequency; % wavelength

% improvement = final_table.power_phase./(final_table.power_pkpk*correcting_factor_phase);
improvement = final_table.power_phase./max(final_table.power_phase);
nopart_loss = final_table.power_phase_nopart./max(final_table.power_phase_nopart);
figure
plot(final_table.angle,nopart_loss,'--','DisplayName','No partition')
hold on
plot(final_table.angle, improvement,'DisplayName',[num2str(partitions.^2),' partitions | ', num2str(final_table.size_partition(1)/lambda),'\lambda'])
xlabel('Rotation [deg]')
ylabel('Normalised power loss')
legend


