% with this script the effect of the partitioning will be tested

clearvars;

% define the varibales of the TX transducer
frequency = 1e6; % frequency of the simulation
radius = in2m(1.5/2); % transform to meters the radius of the TX

% define the variables of the RX transducer
RX_x = 20*1e-3; % dimension of RX in x coordinate
RX_y = RX_x; % dimension of RX in y coordinate
test_distance = 221*1e-3; % distance at which to perform the simulation in meters

medium = set_medium('water');
lateral_step = 1e-3; % this is the step from the measurement data 

%% load the data from the hydrophone measurements 

% measured data to the pressure at the desired driving voltage 
pressure_scaling_coeff = 10; % multiplication coefficient to convert measured data to the pressure at the desired driving voltage for the measurements done at 2.5 MHz is 10 times 
[filename,pathname] = uigetfile('C:\Users\320033994\OneDrive - Philips\Power transfer\Experiments\US vs inductive benchmarking\EM_lab_processed_data\*.mat','Select the mat file containing the data');

load(strcat(pathname,filename));
acoustic_data = acoustic{1,2};
acoustic_info_exp = acoustic{1,1};
clearvars acoustic

%% process the data
% find the indices of the data corresponding to the area 
ROI_indices = find(abs([acoustic_data.Z])'<= RX_x*1e3/2 & abs([acoustic_data.Y])'<= RX_y*1e3/2);
rows_ROI = length(find([acoustic_data(ROI_indices).Y]' == 0)); % determine the number of rows and columns in the region of interest
col_ROI = find(diff([acoustic_data(ROI_indices).Z]'),1);
acoustic_data = struct2table(acoustic_data);
ROI_data = sortrows(acoustic_data(ROI_indices,:),{'Y','Z'});

voltage_matrix_ROI_pkpk = reshape(ROI_data.sourcepp,rows_ROI,col_ROI); 
voltage_matrix_ROI = reshape(ROI_data.line,rows_ROI,col_ROI); % extracts the signal recorded at each point of the selected region of interest. 

% Each cell contains the recording 

% find the sensitivity of the needle at that frequency
needle = acoustic_info_exp.needle.data;
total_sensitivity = needle{1, 2}.sens_needle;
[~, sensitivity_index] = min(abs(frequency/1e6 - needle{1, 2}.freq_needle)); % find the closest frequency of the calibrated ones to the actual measuring frequency
sensitivity = total_sensitivity(sensitivity_index); % sensitivity = mV/MPa

pressure = pressure_scaling_coeff*(voltage_matrix_ROI_pkpk.*10^(3))./sensitivity;

%2D plot
figure;
imagesc(1:col_ROI,1:rows_ROI,pressure)
c = colorbar;
c.Label.String = 'Pressure peak-to-peak [MPa]';
xlabel('Y [mm]')
ylabel('Z [mm]')

%% calculate the effect of the partitioning

% create table to subdivide extra measurement points to partitions 
partitions = (1:1:10)';

remainder = mod(size(voltage_matrix_ROI,1),partitions); % remaining measurement points after subdivision in partitions
measurement_pt_partition = floor(size(voltage_matrix_ROI,1)./partitions);
subdivision_table = table(partitions, measurement_pt_partition, remainder,'VariableNames',{'partitions','pt_in_partition','remainder'});

% remove combinations in which less than two points in the measurements is
% available and when there are too many remainders
subdivision_table = subdivision_table(subdivision_table.pt_in_partition >= 2 & subdivision_table.remainder < subdivision_table.partitions/3,:);
% subdivision_table = subdivision_table(subdivision_table.pt_in_partition >= 2 & subdivision_table.remainder == 0,:);

data_power_partitioning = zeros(height(subdivision_table),4);
for a = 1:height(subdivision_table)

    disp(['Calculating partition ', num2str(subdivision_table.partitions(a))])
    % define the subareas cerated by the partitons
    size_partition_x = RX_x/subdivision_table.partitions(a); % lateral size of the partition
    size_partition_y = size_partition_x;
    % add one more measurement point to the partition if there is a remainder from the division
    
    partition_allocation = repmat(subdivision_table.pt_in_partition(a),1,subdivision_table.partitions(a)); % this is the ideal distribution of the point when there is no remainder from the division
        partition_allocation(round(linspace(1,subdivision_table.partitions(a),subdivision_table.remainder(a)))) = ...
            partition_allocation(round(linspace(1,subdivision_table.partitions(a),subdivision_table.remainder(a)))) + 1;

    % subdivide the data into the partitions 
    sub_array = mat2cell(voltage_matrix_ROI,partition_allocation,partition_allocation);

    mean_power_partition_phase = zeros(size(sub_array));
    mean_power_partition_pkpk = zeros(size(sub_array));
    for b = 1:size(sub_array,1)
        for c = 1:size(sub_array,2)
            % calculate the power in each of the paritions 

            [mean_power_partition_phase(b,c), mean_power_partition_pkpk(b,c)] = ...
                calculate_power_measurements(size(sub_array{b,c},1),size(sub_array{b,c},2),sub_array{b,c},sensitivity,...
                                            frequency,medium,pressure_scaling_coeff,size_partition_x,size_partition_y,'n');
        end
    end

    % summarize results in table 
    data_power_partitioning(a,:) = [subdivision_table.partitions(a), size_partition_x, sum(mean_power_partition_pkpk,'all'), sum(mean_power_partition_phase,'all')];
end

data_table = array2table(data_power_partitioning,'VariableNames',{'n_partitions','size_partition','power_pkpk','power_phase'});

% test improvement with partitioning 
improvement = data_table.power_phase./data_table.power_pkpk;
lambda = medium.soundspeed/frequency; % wavelength

% figure
% plot(data_table.n_partitions.^2,improvement,'Marker','o','MarkerSize',8)
% xlabel('Number of partitions')
% ylabel('Relative efficiency')

figure
t = tiledlayout(1,1);
ax1 = axes(t); 
semilogx(data_table.n_partitions.^2,improvement,'Marker','o','MarkerSize',4)
xlabel('Number of partitions')
ylabel('Relative efficiency')
xlim([min(data_table.n_partitions.^2) max(data_table.n_partitions.^2)])
ax1.XTick = data_table.n_partitions.^2;
ax1.XTickLabelRotation = 45;

ax2 = axes(t);
ax2.XAxisLocation = 'top';
ax2.YAxisLocation = 'right';
ax2.XScale = 'log';
ax2.Color = 'none';
% ax1.Box = 'off';
% ax2.Box = 'off';
ax2.YAxis.Visible = 'off'; 
xlabel('Number of wavelengths')
ax2.XLim = [min(data_table.size_partition/lambda) max(data_table.size_partition/lambda)];
ax2.XDir = "reverse";
ax2.XTick = flipud(data_table.size_partition/lambda);
% ax2.XTickLabel = num2str(round(flipud(data_table.size_partition/lambda),1));
ax2.XTickLabelRotation = 45;

