function [mean_power_simulation_phase, mean_power_simulation_pkpk] = calculate_power_simulation_transient(medium,ROI_pressure_simulation,RX_x,RX_y,figure_show)
%calculate_power_simulation_transient calculates the power at the receiver with
%both only taking into account the peak-to-peak value and with taking into
%account the phase with the measurement data 

%   figure_show = 'y' shows the sine waves for each point in the area of
%   the RX
%   mean_power_simulation_phase: is the average power at the receiver
%   calculated by coherently averaging the pressur signal over the area
%   mean_power_simulation: is the average power at the reciver calculated
%   by averaging only the peak to peak values of the pressure signal
    
total_pressure_simulation = zeros(prod(size(ROI_pressure_simulation,1,2)),length(ROI_pressure_simulation(1,1,:)));
pp_pressure_simulation = zeros(size(ROI_pressure_simulation,1,2));
k=1;

h = figure('visible','off');
for i = 1:size(ROI_pressure_simulation,1)
    for j = 1:size(ROI_pressure_simulation,2)
        
        total_pressure_simulation(k,:) = ROI_pressure_simulation(i,j,:);
        pp_pressure_simulation(i,j) = max(total_pressure_simulation(k,:))-min(total_pressure_simulation(k,:));
        plot(total_pressure_simulation(k,:))
        hold on
        k=k+1;
    end
end


mean_pressure_simulation_phase = mean(total_pressure_simulation); % calculate the mean pressure of the simulation taking into account the phase
plot(mean_pressure_simulation_phase,'k','linewidth',1)
if strcmp(figure_show,'y')
    set(h, 'visible', 'on'); 
end

mean_pressure_simulation = mean(pp_pressure_simulation,'all'); % this is the mean of the peak to peak values 

mean_intensity_simulation_phase = (max(mean_pressure_simulation_phase)-min(mean_pressure_simulation_phase)).^2/(8*medium.density*medium.soundspeed);
mean_intensity_simulation_pkpk = mean_pressure_simulation^2/(8*medium.density*medium.soundspeed);


mean_power_simulation_phase = mean_intensity_simulation_phase * RX_x * RX_y;
mean_power_simulation_pkpk = mean_intensity_simulation_pkpk * RX_x * RX_y;


end