function [mean_power_simulation_phase, mean_power_simulation_pkpk] = calculate_power_simulation_MUST(P_field,RX_size,param,figure_show)
% function [mean_power_simulation_phase, mean_power_simulation_pkpk] = calculate_power_simulation_MUST(P_field,RX_size,param,figure_show)

%calculate_power_simulation_MUST calculates the power at the receiver with
%both only taking into account the peak-to-peak value and with taking into
%account the phase with the measurement data 



t_compensated = linspace(0,2/param.fc,500); % build an array with the size of 2 periods
total_pressure_simulation = zeros(numel(P_field),length(t_compensated));
pp_pressure_simulation = zeros(size(P_field,1),size(P_field,2));
k=1;

% h = figure('visible','off');

for i = 1:size(P_field,1)
    for j = 1:size(P_field,2)
        % convert the pressure value from imaginary to sine wave for the 0,0 point
        [theta, rho] = cart2pol(real(P_field(i,j)),imag(P_field(i,j)));
        total_pressure_simulation(k,:) = rho*sqrt(2)*sin(2*pi*param.fc*t_compensated+theta);
        pp_pressure_simulation(i,j) = max(total_pressure_simulation(k,:))-min(total_pressure_simulation(k,:)); % this is the peak to peak pressure
        
%         plot(t,total_pressure_simulation(k,:))
%         hold on
        k=k+1;
    end
end

mean_pressure_simulation_phase = mean(total_pressure_simulation); % calculate the mean pressure of the simulation taking into account the phase
    
% plot(t_compensated,mean_pressure_simulation_phase,'k','linewidth',2)
% if strcmp(figure_show,'y')
%     set(h, 'visible', 'on'); 
% end


mean_intensity_simulation_phase = (max(mean_pressure_simulation_phase)-min(mean_pressure_simulation_phase)).^2/...
                                    (8*1000*param.c);
mean_power_simulation_phase = mean_intensity_simulation_phase * RX_size * RX_size;

% calculate the incoming power only considering the peak to peak values 
mean_pressure_simulation = mean(pp_pressure_simulation,'all');
mean_intensity_simulation = mean_pressure_simulation^2/(8*1000*param.c);
mean_power_simulation_pkpk = mean_intensity_simulation * RX_size * RX_size;

end