function [mean_power_measurement_phase, mean_power_measurement_pkpk, mean_pressure_measurement] = calculate_power_measurements(rows_ROI,col_ROI,voltage_matrix_ROI,sensitivity,frequency,medium,pressure_scaling_coeff,RX_x,RX_y,figure_show)
%calculate_power_measurement_transient calculates the power at the receiver with
%both only taking into account the peak-to-peak value and with taking into
%account the phase with the measurement data 

%   figure_show = 'y' shows the sine waves for each point in the area of
%   the RX
%   mean_power_simulation_phase: is the average power at the receiver
%   calculated by coherently averaging the pressur signal over the area
%   mean_power_simulation: is the average power at the reciver calculated
%   by averaging only the peak to peak values of the pressure signal
    
sampl_frequency = 2.5e9; % sampling frequency of oscilloscope in EM lab is 2.5 GHz  
total_pressure_matrix_measurement = zeros(rows_ROI*col_ROI,length(voltage_matrix_ROI{1,1}));
start_index = zeros(rows_ROI*col_ROI,1);
end_index = zeros(rows_ROI*col_ROI,1);

k =1;

for i = 1:rows_ROI
    for j = 1:col_ROI
        % extracts the signal recorded at the corresponding point in the
        % selected region of interest
        current_signal = voltage_matrix_ROI{i,j};
        [up,lo] = envelope(current_signal,1/frequency*sampl_frequency,'peak'); % calculate the envelope of the signal to detect when it starts. Take one period as the sample number for the envelope
        start_index(k) = find((up-lo)>5e-4,1); % detect when the signal starts
        end_index(k) = find((up-lo)>5e-4,1,'last'); % detect when the signal ends

        total_pressure_matrix_measurement(k,:) = current_signal; 
        k = k+1;
    end
end

% check which is the minimum start index and which is the maximum end index
% to extract the right part of the signal 
total_pressure_matrix_measurement = total_pressure_matrix_measurement(:,round(mean(start_index)):round(mean(end_index)));

% remove the first three cycles to remove the overshoot
total_pressure_matrix_measurement = total_pressure_matrix_measurement(:,round(4/frequency*sampl_frequency):end);

% h = figure('visible','off');
% for a = 1:size(total_pressure_matrix_measurement,1)
%     plot(total_pressure_matrix_measurement(a,:))
%     hold on
% end
% plot(mean(total_pressure_matrix_measurement),'k', 'linewidth', 2)
% if strcmp(figure_show,'y')
%     set(h, 'visible', 'on'); 
% end

mean_pressure_measurement_phase = pressure_scaling_coeff * mean(total_pressure_matrix_measurement).*1e3./sensitivity; % calculates the mean value of pressure 


total_pressure_pkpk_measurement = peak2peak(total_pressure_matrix_measurement,2); % calculate peak to peak value in each measuremnt point
mean_pressure_measurement_pkpk = pressure_scaling_coeff * mean(total_pressure_pkpk_measurement)*1e3./sensitivity;

% calculate intensity 
mean_intensity_measurement_phase = (peak2peak(mean_pressure_measurement_phase).*1e6).^2/(8*medium.density*medium.soundspeed);    % intensity from measurement I = p(pkpk)^2/(8*water_imped) [W/m^2]
mean_intensity_measurement_pkpk = (mean_pressure_measurement_pkpk.*1e6).^2/(8*medium.density*medium.soundspeed);
mean_power_measurement_phase = mean_intensity_measurement_phase * RX_x * RX_y;
mean_power_measurement_pkpk = mean_intensity_measurement_pkpk * RX_x * RX_y;

mean_pressure_measurement = (peak2peak(mean_pressure_measurement_phase)+mean_pressure_measurement_pkpk)/2;


end