function [mean_tilt_theta, mean_tilt_psi] = calculate_phase_shift(rows,col,acoustic_data,medium)
%calculate_time_delay computes the phase shift or angular shift of the transducer 
%   Detailed explanation goes here

sampl_frequency = 2.5e9; % sampling frequency of oscilloscope in EM lab is 2.5 GHz 
% transform the data into table 
acoustic_data = struct2table(acoustic_data);

% check the number of data 
points_per_side = min(rows,col);
num_tests = (points_per_side - 1)/2; % assuming one point is in the centre and then consider one point on each side
max_coordinate = min(max(abs(acoustic_data.Y)),max(abs(acoustic_data.Z)));
step_size = max_coordinate/num_tests;

data_hor_vert = zeros(num_tests,3);
current_radius = step_size;
for i = 1:num_tests
    % find the indices of the data of interest (data in up down left and
    % right of the central point
    ROI_indices = find((acoustic_data.Y == current_radius & acoustic_data.Z == 0) | ...
                       (acoustic_data.Y == -current_radius & acoustic_data.Z == 0) |...
                       (acoustic_data.Y == 0 & acoustic_data.Z == current_radius) |...
                       (acoustic_data.Y == 0 & acoustic_data.Z == -current_radius));
    data_ROI = acoustic_data(ROI_indices,:); % subtable containing the data of interest

    % extracts the data at opposing points
    y_data = data_ROI(abs(data_ROI.Y) == current_radius,:);
    z_data = data_ROI(abs(data_ROI.Z) == current_radius,:);

    % trim the signals  
    signals_y = zeros(2,length(y_data.line{1}));
    signals_z = zeros(2,length(z_data.line{1}));
    for j = 1:2
        signals_y(j,:) = y_data.line{j}; 
        signals_z(j,:) = z_data.line{j};
    end

    % calculate the time difference between the two signals
    delay_y = finddelay(signals_y(1,:),signals_y(2,:)); % find the delay on the y axis
    if delay_y < 0 % if the first signal comes later than the second one in the function input order
        [aligned_signals_y(1,:),aligned_signals_y(2,:)] = alignsignals(signals_y(2,:),signals_y(1,:),Truncate=1);
    elseif delay_y > 0 % if the first signal comes first
        [aligned_signals_y(1,:),aligned_signals_y(2,:)] = alignsignals(signals_y(1,:),signals_y(2,:),Truncate=1);
    end

    delay_z = finddelay(signals_z(1,:),signals_z(2,:)); % find the delay on the z axis
    if delay_z < 0 % if the first signal comes later than the second one in the function input order
        [aligned_signals_z(1,:),aligned_signals_z(2,:)] = alignsignals(signals_z(2,:),signals_z(1,:),Truncate=1);
    elseif delay_z > 0 % if the first signal comes first
        [aligned_signals_z(1,:),aligned_signals_z(2,:)] = alignsignals(signals_z(1,:),signals_z(2,:),Truncate=1);
    end

%     figure;
%     subplot(1,2,1)
%     plot(aligned_signals_y(1,:))
%     hold on
%     plot(aligned_signals_y(2,:))
%     subplot(1,2,2)
%     plot(aligned_signals_z(1,:))
%     hold on
%     plot(aligned_signals_z(2,:))
%     title(num2str(current_radius))

    data_hor_vert(i,:) = [current_radius, delay_y, delay_z];
    current_radius = current_radius + step_size;
end

table_delay = array2table(data_hor_vert,"VariableNames",{'radius','delay_y','delay_z'});
table_delay.time_delay_y = abs(table_delay.delay_y./sampl_frequency);
table_delay.time_delay_z = abs(table_delay.delay_z./sampl_frequency);

table_delay.tilt_theta = 90 - atand((table_delay.radius*2*1e-3)./(table_delay.time_delay_y*medium.soundspeed)); % dimetre of test circle/space_delay due to misalignment
table_delay.tilt_psi = 90 - atand((table_delay.radius*2*1e-3)./(table_delay.time_delay_z*medium.soundspeed));

mean_tilt_theta = mean(table_delay.tilt_theta);
mean_tilt_psi = mean(table_delay.tilt_psi);

% table_delay.phase_y = table_delay.time_delay_y.*2.5e6*360;

end