% with this script the theoretical power transfer between TX and RX is
% calculated for differend distances and sizes of the RX
% clearvars;

% define the varibales of the TX transducer
frequency = 1e6; % frequency of the simulation
% radius = in2m(1.5/2); % transform to meters the radius of the TX
radius = 25*1e-3/2; % transform to meters the radius of the TX
far_field = radius^2*frequency/(1500)

rotation_phi_deg = 0; % rotation of the TX transducer according to Euler angles in degrees
rotation_theta_deg = -2:1:7;
rotation_psi_deg = 0;

lateral_shift_x = 0; % shift of centre of TX with respect to centre of RX in meters 
lateral_shift_y = 0; 

% define the variables of the RX transducer
RX_x = 5*1e-3; % dimension of RX in x coordinate
RX_y = RX_x; % dimension of RX in y coordinate
test_distance = 110*1e-3; % distance at which to perform the simulation in meters

medium = set_medium('water');
lateral_step = 0.5e-3;


%% start a loop that calculates the amount of power for each of the lateral or tilt conditions 

data_matrix = zeros(length(RX_x)*length(lateral_shift_x)*length(lateral_shift_y)...
    *length(rotation_theta_deg)*length(rotation_psi_deg)*length(test_distance),8);
% disp(['Number of iterations: ',num2str(size(data_matrix,1))])
k=1;

for a = 1:length(RX_x)        
    for f = 1:length(test_distance)
        for b = 1: length(lateral_shift_x)
            for c = 1:length(lateral_shift_y)
                for d = 1:length(rotation_theta_deg)
                    for e = 1:length(rotation_psi_deg)

                        disp(['Iteration ',num2str(k),'/',num2str(size(data_matrix,1))])    
                        % shift the position of the TX transducer such that the area on
                        % whcih to calculate the power is still at the centre
                        coord_shift = rotate_vector_forward([lateral_shift_x(b) lateral_shift_y(c) test_distance(f)], ...
                                        [deg2rad(rotation_phi_deg) deg2rad(rotation_theta_deg(d)) deg2rad(rotation_psi_deg(e))]);  
                
                        xdc = get_circ(radius, -coord_shift + [0 0 test_distance(f)],...
                                        [deg2rad(rotation_phi_deg) deg2rad(rotation_theta_deg(d)) deg2rad(rotation_psi_deg(e))]);
                       
                
%                         disp([num2str(rotation_theta_deg(d)),' deg ', num2str(-coord_shift + [0 0 test_distance(f)])])
                        % this measures are in meters
                        xmin = -0.025;
                        xmax = -xmin;
                        ymin = -0.025;
                        ymax = -ymin;
                        zmin = test_distance(f);
                        zmax = test_distance(f);
                        
                        [delta, xpoints, ypoints, zpoints] = create_input_coordinate_grid(xmin,xmax,ymin,ymax,zmin,zmax,lateral_step);
                        coord_grid=set_coordinate_grid(delta, xmin, xmax, ymin, ymax, zmin, zmax);
                        
                        ndiv= 20;
                        
                        p_cw=cw_pressure(xdc, coord_grid, medium, ndiv, frequency); % simulate the pressure filed
%                         power_cw=cw_power(xdc, coord_grid, medium, ndiv, frequency); % simulate the pressure filed

                
                        x = xmin:delta(1):xmax;
                        y = ymin:delta(2):ymax;
                        z = zmin:delta(3):zmax;
                        
                        clearvars xmin xmax ymin ymax zmin zmax xpoints ypoints zpoints 

                        % plot the pressure field 
%                         figure();
%                         h = pcolor(x*1e3,y*1e3,abs(p_cw));
%                         set(h,'edgecolor','none');
%                         title(['Pressure field at ',num2str(test_distance(f)*1e3),' mm']);
%                         xlabel('x (mm)');
%                         ylabel('y (mm)');
%                         daspect([1, 1, 1])
%                         colorbar
%                         
                        % plot the phase
%                         figure();
%                         h = pcolor(x*1e3,y*1e3,rad2deg(angle(p_cw)));
%                         set(h,'edgecolor','none');
%                         title(['Phase at ',num2str(test_distance(f)*1e3),' mm']);
%                         xlabel('x (mm)');
%                         ylabel('y (mm)');
%                         daspect([1, 1, 1])
%                         colorbar
                        
                        % extracts the pressure values that are in the area corresponding to the
                        % size of the receiver 
                        ROI_x_simulation = find(round(abs(x*1e3)) <= RX_x(a)*1e3/2);
                        ROI_y_simulation = find(round(abs(y*1e3)) <= RX_y(a)*1e3/2);
                        ROI_pressure_simulation = p_cw(ROI_x_simulation, ROI_y_simulation);
                        
                        [mean_power_simulation_phase, mean_power_simulation] = ...
                            calculate_power_simulation_CW(frequency,medium,ROI_pressure_simulation,RX_x(a),RX_y(a),'n');
        
                        % create matrix to store the data
                        data_matrix(k,:) = [RX_x(a)*1e3, lateral_shift_x(b), lateral_shift_y(c), test_distance(f), rotation_theta_deg(d), rotation_psi_deg(e),...
                                            mean_power_simulation, mean_power_simulation_phase];
                        k=k+1;
    
                
                    end
                end
            end
        end
    end
end

% convert data to table 
data_table = array2table(data_matrix,'VariableNames',{'RX_lat_size','shift_x','shift_y','distance','theta_deg','psi_deg','avgP','avgP_phase'});

% % plot of the power when the TX and RX are perfectly aligned 
% figure;
% plot(data_table,'RX_lat_size',["avgP","avgP_phase"],'LineStyle','--','Marker','.','MarkerSize',11,'LineWidth',1);
% ylabel('Power at RX')
% xlabel('RX lateral size')
% grid on
% legend

for plot_dist = 1:length(test_distance)
    sub_data = data_table(data_table.distance == test_distance(plot_dist),:);
    power_matrix = reshape(sub_data.avgP_phase,length(lateral_shift_x),length(lateral_shift_y));
    figure
%     imagesc([0 20],[0 20],rot90(power_matrix)./max(power_matrix,[],"all"),[0 1])
    imagesc([0 10],[0 10],rot90(power_matrix)./max(sub_data.avgP),[0 1])
    colormap pink
    colorbar
    title([num2str(test_distance(plot_dist)),' mm'])
    daspect([1 1 1])
%     print(['C:\Users\320033994\OneDrive - Philips\Power transfer\Experiments\US vs inductive benchmarking\Images\Misalignment_scenarios\',...
%         'Pphase_lat_shift_d',num2str(test_distance(plot_dist)*1e3),'_RX',num2str(RX_x*1e3)],'-depsc')
%     print(['C:\Users\320033994\OneDrive - Philips\Power transfer\Experiments\US vs inductive benchmarking\Images\Misalignment_scenarios\',...
%         'Pphase_lat_shift_d',num2str(test_distance(plot_dist)*1e3),'_RX',num2str(RX_x*1e3)],'-dpng')
end

% figure
% for RX_size = 1:length(RX_x)
%     sub_data = data_table(data_table.RX_lat_size == RX_x(RX_size)*1e3,:);
%     plot(sub_data.distance,sub_data.avgP_phase./max(sub_data.avgP_phase),'DisplayName',[num2str(RX_x(RX_size)*1e3),' mm'])
%     hold on
% %     print(['C:\Users\320033994\OneDrive - Philips\Power transfer\Experiments\US vs inductive benchmarking\Images\Misalignment_scenarios\',...
% %         'Pphase_lat_shift_d',num2str(test_distance(plot_dist)*1e3),'_RX',num2str(RX_x*1e3)],'-depsc')
% %     print(['C:\Users\320033994\OneDrive - Philips\Power transfer\Experiments\US vs inductive benchmarking\Images\Misalignment_scenarios\',...
% %         'Pphase_lat_shift_d',num2str(test_distance(plot_dist)*1e3),'_RX',num2str(RX_x*1e3)],'-dpng')
% end
% legend

figure
for plot_dist = 1:length(test_distance)
% for plot_rx_size = 1:length(RX_x)
    avg_power_psi = zeros(1,length(rotation_theta_deg));
    max_power_psi = zeros(1,length(rotation_theta_deg));
    min_power_psi = zeros(1,length(rotation_theta_deg));

    sub_data = data_table(data_table.distance == test_distance(plot_dist),:);
%     sub_data = data_table(data_table.RX_lat_size == RX_x(plot_rx_size)*1e3,:);

    % calculate the average of power for same theta but different psi
    for theta = 1:length(rotation_theta_deg)
        avg_power_psi(theta) = mean(sub_data.avgP_phase(sub_data.theta_deg == rotation_theta_deg(theta))); % take all the power values for different psi and do average
        max_power_psi(theta) = max(sub_data.avgP_phase(sub_data.theta_deg == rotation_theta_deg(theta)));
        min_power_psi(theta) = min(sub_data.avgP_phase(sub_data.theta_deg == rotation_theta_deg(theta)));
    end
    
%     x2 = [rotation_theta_deg, fliplr(rotation_theta_deg)];
%     inBetween = [max_power_psi./max(sub_data.avgP_phase), fliplr(min_power_psi./max(sub_data.avgP_phase))];
%     figure
%     fill(x2, inBetween, 'b');
%     hold on
    plot(rotation_theta_deg, avg_power_psi/max(sub_data.avgP_phase))
    
%     plot(rotation_theta_deg, avg_power_psi/max(sub_data.avgP_phase),'DisplayName',[num2str(RX_x(plot_rx_size)*1e3),' mm, ', num2str(frequency/1e6),' MHz'])
%     errorbar(rotation_theta_deg, avg_power_psi/max(sub_data.avgP_phase),...
%         (avg_power_psi-min_power_psi)./max(sub_data.avgP_phase),(max_power_psi-avg_power_psi)./max(sub_data.avgP_phase),'vertical')
    hold on


%     power_matrix = reshape(sub_data.avgP_phase,length(rotation_theta_deg),length(rotation_psi_deg));
%     figure
%     imagesc([0 20],[0 20],rot90(power_matrix)./max(power_matrix,[],'all'),[0 1])
%     colorbar

    
%     title([num2str(test_distance(plot_dist)),' mm'])
%     print(['C:\Users\320033994\OneDrive - Philips\Power transfer\Experiments\US vs inductive benchmarking\Images\Misalignment_scenarios\',...
%         'Pphase_rot_d',num2str(test_distance(plot_dist)*1e3),'_RX',num2str(RX_x*1e3)],'-depsc')
%     print(['C:\Users\320033994\OneDrive - Philips\Power transfer\Experiments\US vs inductive benchmarking\Images\Misalignment_scenarios\',...
%         'Pphase_rot_d',num2str(test_distance(plot_dist)*1e3),'_RX',num2str(RX_x*1e3)],'-dpng')
end
legend()
xlabel('angle [deg]')
ylabel('power loss')

% max(data_table.avgP_phase)
% 
% sub_data_sim = data_table(data_table.theta_deg == 2,:);
% sub_data_sim.simulation_power_ratio = sub_data_sim.avgP_phase./sub_data_sim.avgP;

% figure
% plot(data_table.distance*1e3,data_table.avgP_phase)
% xlabel('distance from the PZT element [mm]')
% ylabel('Power at RX')
% title('1 MHz, RX 10 mm x 10mm')