function [Summary, path] = import_pressure_data(varargin)
%   this function imports the pressure data from the hydrophone or fiber
%   optics 
% 
%   output: acoustic table containing the parameters

%% Initialize variables.
path = uigetdir('C:\Users\320033994\OneDrive - Philips\Power transfer\Experiments\US vs inductive benchmarking\pressure_measurements\','Select the folder that contains the data to extract:');
% [file,pathname] = uigetfile(strcat(path,'\data\Summary.txt'));
filename = strcat(path,'\data\Summary.txt'); % load the summary file 
delimiter = '\t';
startRow = 2;

%% Format for each line of text:
formatSpec = '%*s%f%f%f%f%f%f%f%f%f%f%f%f%[^\n\r]';

%% Open the text file.
fileID = fopen(filename,'r');

%% Read columns of data according to the format.

dataArray = textscan(fileID, formatSpec, 'Delimiter', delimiter, 'TextType', 'string', 'HeaderLines' ,startRow-1, 'ReturnOnError', false, 'EndOfLine', '\r\n');

%% Close the text file.
fclose(fileID);

%% Create output variable
Summary = table(dataArray{1:end-1}, 'VariableNames', {'X','Y','Z','Burstrate','Burstcount','Bias','PulseWidth','Pulseperiod','Amplitude','SourcePeakPeak','SignalPeakPea','Current'});

%% Clear temporary variables
clearvars filename delimiter startRow formatSpec fileID dataArray ans file;

%% select the raw data channel files 
file = uigetfile(strcat(path,'\data\RawDataChannel*.txt'),'MultiSelect','on','Select the RawDataChannel files');
file = cellstr(file);

for i = 1:length(file)
    filename = char(strcat(path,'\data\',file(i)));
    delimiter = {''};
    startRow = 4;
    formatSpec = '%f%[^\n\r]';

    fileID = fopen(filename,'r');
    dataArray = textscan(fileID, formatSpec, 'Delimiter', delimiter, 'TextType', 'string', 'EmptyValue', NaN, 'HeaderLines' ,startRow-1, 'ReturnOnError', false, 'EndOfLine', '\r\n');
    fclose(fileID);

    %% Create output variable
    dataArray1 = cellfun(@(x) num2cell(x), dataArray, 'UniformOutput', false);
    line_data{i,1} = [dataArray1{1:end-1}];
    
    line_data_corr{i,1} = num2cell(dataArray{1,1} - mean(dataArray{1,1}));
%     line_data_corr_cell = [line_data_corr{1:end-1}];
    
end
clearvars i file filename delimiter startRow formatSpec fileID dataArray dataArray1 ans file;

Summary.line_data = line_data;
Summary.line_data_corr = line_data_corr;
Summary = removevars(Summary, 'SignalPeakPea');

clearvars line_data_corr line_data
%% add biasT data 

file = uigetfile(strcat(path,'\data\RawData_*.txt'),'MultiSelect','on','Select the RawData files');
file = cellstr(file);

for i = 1:length(file)
    filename = char(strcat(path,'\data\',file(i)));
    delimiter = '\t';
    startRow = 4;
    formatSpec = '%f%f%*s%[^\n\r]';

    fileID = fopen(filename,'r');
    dataArray = textscan(fileID, formatSpec, 'Delimiter', delimiter, 'TextType', 'string', 'EmptyValue', NaN, 'HeaderLines' ,startRow-1, 'ReturnOnError', false, 'EndOfLine', '\r\n');
    fclose(fileID);
    dataArray = cellfun(@(x) num2cell(x), dataArray, 'UniformOutput', false);
    biasT_data{i,1} = [dataArray{1,1}];
    pulse_sense{i,1} = [dataArray{1,2}];
end
clearvars i file filename delimiter startRow formatSpec fileID dataArray ans;

Summary.pulse_biasT = biasT_data;
Summary.pulse_sense = pulse_sense;

clearvars biasT_data pulse_sense;


end

