function [total_points,lateral_step,pts_in_partition,size_element] = create_space_data_partitioning(transducer_lateral_size,partitions,min_pts_in_partition, max_lateral_step)
%create_space_data_partitioning determines the right side of the step size
% to create a grid. gives the number of points in each subdivision and the total number of points  
%   
% total_points = total number of points in each coordinate, assuming x and
% y are the same 
% lateral_step = is the step size in space for the construction of the grid
% pts_in_partition = number of points of the grid in each side of the
% partition

size_element = transducer_lateral_size/partitions;
    
lateral_step = size_element/(min_pts_in_partition); % take at least 3 points in each partition
pts_in_partition = min_pts_in_partition;

while lateral_step > max_lateral_step 
    pts_in_partition = pts_in_partition +1; % increase the minimun number of points in each partition
    lateral_step = size_element/pts_in_partition; 
end

total_points = round(transducer_lateral_size/lateral_step);

while mod(total_points,partitions) ~= 0
    total_points = total_points + 1;
    lateral_step = transducer_lateral_size/total_points;
    pts_in_partition = total_points/partitions;
end
end