function [delta, xpoints, ypoints, zpoints] = create_input_coordinate_grid(xmin,xmax,ymin,ymax,zmin,zmax,lateral_step)
%create_input_coordinate_grid creates the data to input to create the
%coordinate grid 

    if xmin - xmax == 0
        xpoints = 1;
        delta(1) = 1;
    else
        delta(1) = lateral_step;
        xpoints = round((xmin-xmax)/delta(1));
    end
    if ymin - ymax == 0
        ypoints = 1;
        delta(2) = 1;
    else
        delta(2) = lateral_step;
        ypoints = round((ymin-ymax)/delta(2));
    end
    if zmin - zmax == 0
        zpoints = 1;
        delta(3) = 1;
    else
        delta(3) = lateral_step;
        zpoints = round((zmin-zmax)/delta(3));
    end

end