function [mean_pressure_simulation_phase,mean_start_sample,mean_peak_peak] = calculate_time_delay_transient(ROI_pressure_simulation,figure_show)
%calculate_power_simulation_transient calculates the power at the receiver with
%both only taking into account the peak-to-peak value and with taking into
%account the phase with the measurement data 

%   figure_show = 'y' shows the sine waves for each point in the area of
%   the RX
%   mean_power_simulation_phase: is the average power at the receiver
%   calculated by coherently averaging the pressur signal over the area
%   mean_power_simulation: is the average power at the reciver calculated
%   by averaging only the peak to peak values of the pressure signal
    
total_pressure_simulation = zeros(prod(size(ROI_pressure_simulation,1,2)),length(ROI_pressure_simulation(1,1,:)));
k=1;

h = figure('visible','off');
for i = 1:size(ROI_pressure_simulation,1)
    for j = 1:size(ROI_pressure_simulation,2)
        
        total_pressure_simulation(k,:) = squeeze(ROI_pressure_simulation(i,j,:));
        [up,lo] = envelope(squeeze(ROI_pressure_simulation(i,j,:)));
        start_sample(i,j) = find((up-lo) > 1e5,1);
        peak_peak(i,j) = peak2peak(squeeze(ROI_pressure_simulation(i,j,:)));
        plot(total_pressure_simulation(k,:))
        hold on
        k=k+1;
    end
end


mean_pressure_simulation_phase = mean(total_pressure_simulation); % calculate the mean pressure of the simulation taking into account the phase
mean_start_sample = mean(start_sample,"all");
mean_peak_peak = mean(peak_peak,'all');
plot(mean_pressure_simulation_phase,'k','linewidth',1)
if strcmp(figure_show,'y')
    set(h, 'visible', 'on'); 
end

end