function [mean_theta] = calculate_phase_area(ROI_pressure_simulation)
%calculate_phase_area calculates the average phase for the input data

    
    theta = zeros(size(ROI_pressure_simulation,1),size(ROI_pressure_simulation,2));
    for i = 1:size(ROI_pressure_simulation,1)
        for j = 1:size(ROI_pressure_simulation,2)
            % convert the pressure value from imaginary to sine wave for the 0,0 point
            [theta(i,j), ~] = cart2pol(conj(real(ROI_pressure_simulation(i,j))),conj(imag(ROI_pressure_simulation(i,j))));
            
        end
    end
    
    theta = reshape(unwrap(reshape(theta,[],1)),size(ROI_pressure_simulation,1),size(ROI_pressure_simulation,2));
    mean_theta = mean(theta,'all');
end            