function [sig_opp_side_1_shift,sig_opp_side_2_shift,sig_centre_shift,delay_opp_side,delay_centre] = calculate_delay_signals(sig_opposing_side_1,sig_opposing_side_2,sig_centre,use_method)
%this function calculates the delay between signals at opposing sides and
%compares to the centre. use_method with "y"enables the slign signal with
%the risetime method

% calculate the delay between signals at opposing side 
if strcmp(use_method,"y")
    [sig_opp_side_1_shift,sig_opp_side_2_shift,delay_opp_side] = alignsignals(sig_opposing_side_1,sig_opposing_side_2,"Method","risetime","StateLevels",[0.5e-3 1.5e-3]);
else
    [sig_opp_side_1_shift,sig_opp_side_2_shift,delay_opp_side] = alignsignals(sig_opposing_side_1,sig_opposing_side_2);
end
        if delay_opp_side < 0 % meaning the second signal comes first
            [sig_centre_shift,sig_opp_side_1_shift,delay_centre] = alignsignals(sig_centre,sig_opp_side_1_shift);
            if delay_centre < 0
                sig_opp_side_1_shift = circshift(sig_opp_side_1_shift,delay_centre);
                sig_centre_shift = circshift(sig_centre_shift,delay_centre);
            end
        else
            [sig_centre_shift,sig_opp_side_2_shift,delay_centre] = alignsignals(sig_centre,sig_opp_side_2_shift);
            if delay_centre < 0
                sig_opp_side_2_shift = circshift(sig_opp_side_2_shift,delay_centre);
                sig_centre_shift = circshift(sig_centre_shift,delay_centre);
            end
        end
end

% sig_opposing_side_1= total_pressure_measurement(2,:);
% sig_opposing_side_2=total_pressure_measurement(3,:);
% sig_centre=total_pressure_measurement(1,:);
% 
% figure;
% plot(sig_opp_side_1_shift)
% hold on
% plot(sig_opp_side_2_shift)
% plot(sig_centre_shift)