% clear all
% close all
clearvars
% Create a circular element transducer 
frequency = 1e6;
% frequency = 2.5e6;

el_x = 1;
el_y = 1;

% radius = [6, 10, 13, 19, 25, 29, 39]*1e-3/2; % transform to meters
radius = 25*1e-3/2;
% radius = (5:5:40)*1e-3/2;
distance = (0:5:150)*1e-3;

RX_x = 5e-3; % dimension of the side of the receiver
RX_y = 5e-3;

data = zeros(length(frequency)*length(radius)*length(distance),5);
m =1;
for w = 1:length(radius)
    kerf_x = 1e-3;
    kerf_y = 1e-3;

    xdc = create_circ_planar_array(el_x, el_y, radius(w), kerf_x, kerf_y);

%     draw_array(xdc)
%     daspect([1,1,1]);
    for a = 1:length(distance)

        % this measures are in meters
        xmin = -0.05;
        xmax = 0.05;
        ymin = -0.05;
        ymax = 0.05;
        zmin = distance(a);
        zmax = distance(a);
    
        xpoints = 2000;
        ypoints = 2000;
        zpoints = 1;
    
        delta = [(xmax-xmin)/xpoints (ymax-ymin)/ypoints (zmax-zmin)/zpoints];
    %     delta = [2e-3 2e-3 1];
        coord_grid=set_coordinate_grid(delta, xmin, xmax, ymin, ymax, zmin, zmax);
    
        ndiv= 20;
    
        %%
        for k = 1:length(frequency)
        
            % define the medium
            f0 = frequency(k);
    %         define_media();
            medium = set_medium('water');
    
            p_cw=cw_pressure(xdc, coord_grid, medium, ndiv, f0);
            disp(['Simulating f=', num2str(f0/1e6), ' MHz, radius = ', num2str(radius(w)*1e3),'mm, distance =', num2str(distance(a))])
        
            %%
            % create the arrays to plot the data 
            x = xmin:delta(1):xmax;
            y = ymin:delta(2):ymax;
            z = zmin:delta(3):zmax;
            
            p_cw = squeeze(p_cw); % squeezes the array in 2D
            
    %         figure
    %         h = pcolor(x*1000,y*1000,abs(p_cw));
    %         set(h,'edgecolor','none');
    %         daspect([1, 1, 1])
    %         colorbar
            
             % take the area of interest in the plot
            ROI_x = find(abs(x) <= RX_x/2);
            ROI_y = find(abs(y) <= RX_y/2);
    
            ROI_p = p_cw(ROI_x, ROI_y);
    
            real_p_cw = real(ROI_p); % calculates real and imaginary part
            imag_p_cw = imag(ROI_p);
            [theta_p_cw, rho_p_cw] = cart2pol(real_p_cw, imag_p_cw);
            % calculate the average power taking into consideration only the
            % peak to peak value of the pressure 
            mean_power_ampl = ((mean(rho_p_cw*sqrt(2)*2,'all')).^2/(8*medium.density*medium.soundspeed))* RX_x * RX_y;
            
            % calculate the average power taking into consideration also the
            % phase
            t = 0: 1/f0/100: 1/f0; % create an array to evaluate signal over a period 
            
            total_pressure_matrix_ROI = zeros(size(ROI_p,1)*size(ROI_p,2), length(t));
            d =1;
            for q= 1:size(ROI_p,1)
                for b = 1:size(ROI_p,2)
                    total_pressure_matrix_ROI(d,:) = rho_p_cw(q,b)*sin(2*pi*f0*t + theta_p_cw(q,b));
                    d=d+1;
                end
            end
            mean_pressure_ROI = mean(total_pressure_matrix_ROI);
            peak_to_peak_pressure_ROI = (max(mean_pressure_ROI) - min(mean_pressure_ROI));
           
    %         figure
    %         h = pcolor(x(ROI_x)*1000,y(ROI_y)*1000,abs(ROI_p));
    %         set(h,'edgecolor','none');
    %         daspect([1, 1, 1])
            
            
            mean_intensity = (peak_to_peak_pressure_ROI).^2/(8*medium.density*medium.soundspeed);
            mean_power_phase = mean_intensity * RX_x * RX_y;
            % calculate incoming power
    %         ROI_power = trapz(y(ROI_y),trapz(x(ROI_x),ROI_I,2));
            
            data(m,:) = [radius(w), f0, distance(a), mean_power_phase, mean_power_ampl];
            m = m+1;
        end

    end
end

data_table = array2table(data,'VariableNames',{'radius','f0','distance','mean_power_phase','mean_power_ampl'});

% figure
% plot3(data_table.radius*2*1e3,data_table.f0*1e-6,data_table.mean_power_phase,'.')
% grid on
% xlabel('D pzt [mm]')
% ylabel('Frequency [MHz]')
% zlabel('Power [a.u.]')

% figure
% count = 1;
% for w = 1:length(radius)
%     
%     plot3(data(count:count+length(frequency)-1,1)*2*1e3,data(count:count+length(frequency)-1,2)*1e-6,data(count:count+length(frequency)-1,3),'linewidth',1.5,'DisplayName',[num2str(radius(w)*2*1e3),' mm'])
%  
%     count = count + length(frequency);
%     hold on
% end
% legend('location','bestoutside')
% count = 1;
% for w = 1:length(radius)
%     
%     plot3(data(count:count+length(frequency)-1,1)*2*1e3,data(count:count+length(frequency)-1,2)*1e-6,data(count:count+length(frequency)-1,4),'DisplayName',[num2str(radius(w)*2*1e3),' mm'])
%     count = count + length(frequency);
%     hold on
% end
% grid on
% xlabel('D pzt [mm]')
% ylabel('Frequency [MHz]')
% zlabel('Power [a.u.]')
% view(90,0)


figure;
for w =1:length(radius)
    % select data from table 
    data_table_plot = data_table(data_table.radius == radius(w),:);
    plot(data_table_plot.distance*1e3,data_table_plot.mean_power_phase,'linewidth',1.5,...
        'DisplayName',[num2str(radius(w)*2*1e3),' mm'])
    hold on
end

legend('location','bestoutside')
xlabel('Distance TX RX [mm]')
ylabel('Power [a.u.]')

