# Nvidia Omniverse Data Quality Gate

This project contains the source code to an Nvidia Omniverse extension capable of flawlessly identifying the six most critical data quality insufficiencies within the 3D environment of an automitve manufacturer's virtual factory models, perform an applicable analysis of the data obtained from this identification and derive concrete KPIs. 

## Project Description

Problem: 
Data quality assessments of virtual factory models visualised in the Nvidia Omniverse 3D environment have to be conducted fully manually. This procedure is time-consuming and prone to errors, causing the benefits of the Nvidia Omniverse in the automotive manufacturing sector to be outweighed by the costs of ensuring sufficient data quality. 

Objective:
This software extension to the Nvidia Omniverse is capable of automatically identifying the most critical insufficiencies within a virtual factory model and performing an analysis of the results to compute adequate KPIs. Based on these KPIs, minimum data quality requirements are to be defined that need to be met by virtual factory models coming from the Factory Assembler to be published for visualisation in the Nvidia Omniverse. Thereby, a data quality gate is created that ensures a certain quality standard of data in the Nvidia Omniverse.

## Get Started

1. In the Omniverse App open extension manager: Window → Extensions.
2. In the Extension Manager Window open a settings page, with a small gear button in the top left bar.
3. In the settings page there is a list of Extension Search Paths. Add file path to `exts` subfolder there as another search path
4. Now you can find omniverse.quality.gate extension in the top left search bar. Select and enable it.
5. "Nvidia Omniverse Data Quality Gate" window will pop up in bottom right corner. Extension Manager watches for any file changes and updates extension following a hotreload.

## Table of Contents

All relevant code is part of the `exts`-folder. The content of any other folder is provided by Nvidia and not created by the software extension creator. The only relevant files created or edited as part of this project are detailed below:

### Key Source Code
The relevant functionalities are stored in: `exts/omniverse.quality.gate/omniverse/quality/gate´

Functionalities:

`quality_checks.py`: Identification functions for each of the six data quality insufficiency checks (+ relevant reoccuring functions enbaling these checks)

`ui_window.py`: All UI specifications including window set-up and automatic data analysis to create KPI dashboard

`draw_util.py`: Function to draw bounding box for Position-Check-Light

`extension.py`: Basic functions to enable start-up and destroyment of extension window in Nvidia Omniverse + get viewport specifications for bounding box drawing in Position-Check-Light

### Technical Information
`extension.toml` under the file path `exts/omniverse.quality.gate/config/` contains relevant metadata, such as the project author, title, version, description and logo

