install.packages("linprog")
library("linprog")
library(xlsx)

rm(list=ls(all=TRUE));

setwd("M:\\My Documents\\Documents PhD\\Data management plan\\2021.06.28_FoodProtectsPaper3(Vissers)DMF_BEC\\Final data and syntax");

dat2 <- read.table("Dataset_subindicators_Final.csv", header = TRUE, sep = ";");

y <-with(dat2,cbind(NRLM, Welfarequality, NH3emission, PM10emission)) # These are the sub-indicators NRLM, animal welfare, NH3 emission and PM10 emission 

M <- dim(y)[2];		# Number of sub-indicators
J <- dim(y)[1];		# Number of combinations of system changes

#====================================================================================#
# NRLM driven scenario                                                               #
#====================================================================================#
# Matrices to store the results
tB.opt <- t(matrix(rep(0,J),J,M));   
tg.opt <- t(matrix(rep(0,J),J));

for (j in 1:J)
{
  # objective coefficients
  cvec <- c(y[j,1], y[j,2], y[j,3], y[j,4]);     # parameters of the objective function
  
  # Construct matrix A       -> these are the parameters at the left hand side of the sub-indicator share restrictions.
  Row1LHS <- y;   
  o <- matrix(rep(0,J), J,1)
  Row2LHS <- cbind(y[j,1], -y[j,2], 0, 0)   # Sub-indicator shares y1 (NRLM) and sub-indicator share y2 (animal welfare).   
  Row3LHS <- cbind(y[j,1], 0, -y[j,3], 0)   # Sub-indicator shares y1 (NRLM) and sub-indicator share y3 (NH3 emission). 
  Row4LHS <- cbind(y[j,1], 0, 0, -y[j,4])   # Sub-indicator shares y1 (NRLM) and sub-indicator share y4 (PM10 emission). 
  Amat <- rbind(Row1LHS, Row2LHS, Row3LHS, Row4LHS)
  
  # Direction of the inequality constraints
  direction <- c(rep("<=", J), rep(">=", 3));   
  
  # Right hand side  of the sub-indicator share restrictions. Right hand side is 1.
  Row1RHS<- matrix(1,J);
  Row2RHS <-matrix(0,1)  
  Row3RHS <-matrix(0,1)  
  Row4RHS <-matrix(0,1)  
  bvec <- rbind(Row1RHS, Row2RHS, Row3RHS, Row4RHS)
  
  firm.solution <- solveLP(cvec, bvec, Amat,direction, maximum=TRUE, lpSolve=TRUE); 
  
  # Store the results
  
  tB.opt[,j] <- firm.solution$solution[1:M];    # weights
  tg.opt[,j] <- firm.solution$opt;              # efficiency scores
}

result <- list("g.opt" = t(tg.opt));
result
# G.opt indicates the performance scores of the combinations of system changes in the NRLM driven scenario


#====================================================================================#
# Animal welfare driven scenario                                                     #
#====================================================================================#
# Matrices to store the results
tB.opt <- t(matrix(rep(0,J),J,M));   
tg.opt <- t(matrix(rep(0,J),J));

for (j in 1:J)
{
  # objective coefficients
  cvec <- c(y[j,1], y[j,2], y[j,3], y[j,4]);     # parameters of the objective function
  
  # Construct matrix A       -> these are the parameters at the left hand side of the sub-indicator share restrictions. The lines below show the NRLM driven scenario.
  Row1LHS <- y;   
  o <- matrix(rep(0,J), J,1)
  Row2LHS <- cbind(-y[j,1], y[j,2], 0, 0)   # Sub-indicator shares y1 (NRLM) and sub-indicator share y2 (animal welfare).   
  Row3LHS <- cbind(0, y[j,2], -y[j,3], 0)   # Sub-indicator shares y2 (Animal welfare) and sub-indicator share y3 (NH3 emission). 
  Row4LHS <- cbind(0, y[j,2], 0, -y[j,4])   # Sub-indicator shares y2 (Animal welfare) and sub-indicator share y4 (PM10 emission). 
  Amat <- rbind(Row1LHS, Row2LHS, Row3LHS, Row4LHS)
  
  # Direction of the inequality constraints
  direction <- c(rep("<=", J), rep(">=", 3));   
  
  # Right hand side  of the sub-indicator share restrictions. Right hand side is 1.
  Row1RHS<- matrix(1,J);
  Row2RHS <-matrix(0,1)  
  Row3RHS <-matrix(0,1)  
  Row4RHS <-matrix(0,1)  
  bvec <- rbind(Row1RHS, Row2RHS, Row3RHS, Row4RHS)
  
  firm.solution <- solveLP(cvec, bvec, Amat,direction, maximum=TRUE, lpSolve=TRUE); 
  
  # Store the results
  
  tB.opt[,j] <- firm.solution$solution[1:M];    # weights
  tg.opt[,j] <- firm.solution$opt;              # efficiency scores
}

result <- list("g.opt" = t(tg.opt));
result

# G.opt indicates the performance scores of the combinations of system changes in the AW-driven scenario

#====================================================================================#
# NH3 driven scenario                                                                #
#====================================================================================#
# Matrices to store the results
tB.opt <- t(matrix(rep(0,J),J,M));   
tg.opt <- t(matrix(rep(0,J),J));

for (j in 1:J)
{
  # objective coefficients
  cvec <- c(y[j,1], y[j,2], y[j,3], y[j,4]);     # parameters of the objective function
  
  # Construct matrix A       -> these are the parameters at the left hand side of the sub-indicator share restrictions. The lines below show the NRLM driven scenario.
  Row1LHS <- y;   
  o <- matrix(rep(0,J), J,1)
  Row2LHS <- cbind(-y[j,1], 0, y[j,3], 0)   # Sub-indicator shares y1 (NRLM) and sub-indicator share y3 (NH3 emission).   
  Row3LHS <- cbind(0, -y[j,2], y[j,3], 0)   # Sub-indicator shares y2 (Animal welfare) and sub-indicator share y3 (NH3 emission). 
  Row4LHS <- cbind(0, 0, y[j,3], -y[j,4])       # Sub-indicator shares y3 (NH3 emission) and sub-indicator share y4 (PM10 emission). 
  Amat <- rbind(Row1LHS, Row2LHS, Row3LHS, Row4LHS)
  # Direction of the inequality constraints
  direction <- c(rep("<=", J), rep(">=", 3));   
  
  # Right hand side  of the sub-indicator share restrictions. Right hand side is 1.
  Row1RHS<- matrix(1,J);
  Row2RHS <-matrix(0,1)  
  Row3RHS <-matrix(0,1)  
  Row4RHS <-matrix(0,1)  
  bvec <- rbind(Row1RHS, Row2RHS, Row3RHS, Row4RHS)
  
  firm.solution <- solveLP(cvec, bvec, Amat,direction, maximum=TRUE, lpSolve=TRUE); 
  
  # Store the results
  
  tB.opt[,j] <- firm.solution$solution[1:M];    # weights
  tg.opt[,j] <- firm.solution$opt;              # efficiency scores
}

result <- list("g.opt" = t(tg.opt));
result

# G.opt indicates the performance scores of the combinations of system changes in the NH3 driven scenario

#====================================================================================#
# PM10 driven scenario                                                                #
#====================================================================================#

# Matrices to store the results
tB.opt <- t(matrix(rep(0,J),J,M));   
tg.opt <- t(matrix(rep(0,J),J));

for (j in 1:J)
{
  # objective coefficients
  cvec <- c(y[j,1], y[j,2], y[j,3], y[j,4]);     # parameters of the objective function
  
  # Construct matrix A       -> these are the parameters at the left hand side of the sub-indicator share restrictions. The lines below show the NRLM driven scenario.
  Row1LHS <- y;   
  o <- matrix(rep(0,J), J,1)
  Row2LHS <- cbind(-y[j,1], 0, 0, y[j,4])   # Sub-indicator shares y1 (NRLM) and sub-indicator share y4 (PM10 emission).   
  Row3LHS <- cbind(0, -y[j,2], 0, y[j,4])   # Sub-indicator shares y2 (Animal welfare) and sub-indicator share y4 (PM10 emission). 
  Row4LHS <- cbind(0, 0, -y[j,3], y[j,4])   # Sub-indicator shares y3 (NH3 emission) and sub-indicator share y4 (PM10 emission). 
  Amat <- rbind(Row1LHS, Row2LHS, Row3LHS, Row4LHS)
  
  # Direction of the inequality constraints
  direction <- c(rep("<=", J), rep(">=", 3));   
  
  # Right hand side  of the sub-indicator share restrictions. Right hand side equals 1.
  Row1RHS<- matrix(1,J);
  Row2RHS <-matrix(0,1)  
  Row3RHS <-matrix(0,1)  
  Row4RHS <-matrix(0,1) 
  bvec <- rbind(Row1RHS, Row2RHS, Row3RHS, Row4RHS)
  
  firm.solution <- solveLP(cvec, bvec, Amat,direction, maximum=TRUE, lpSolve=TRUE); 
  
  # Store the results
  
  tB.opt[,j] <- firm.solution$solution[1:M];    # weights
  tg.opt[,j] <- firm.solution$opt;              # efficiency scores
}

result <- list("g.opt" = t(tg.opt));
result

# G.opt indicates the performance scores of the combinations of system changes in the PM10 driven scenario



#====================================================================================#
# NRLM driven scenario - Feed price + 1 Standard deviation                           #
#====================================================================================#

y <-with(dat2,cbind(NRLMInputprices, Welfarequality, NH3emission, PM10emission)) # These are the sub-indicators NRLM, animal welfare, NH3 emission and PM10 emission 

M <- dim(y)[2];		# Number of sub-indicators
J <- dim(y)[1];		# Number of combinations of system changes

# Matrices to store the results
tB.opt <- t(matrix(rep(0,J),J,M));   
tg.opt <- t(matrix(rep(0,J),J));

for (j in 1:J)
{
  # objective coefficients
  cvec <- c(y[j,1], y[j,2], y[j,3], y[j,4]);     # parameters of the objective function
  
  # Construct matrix A       -> these are the parameters at the left hand side of the sub-indicator share restrictions.
  Row1LHS <- y;   
  o <- matrix(rep(0,J), J,1)
  Row2LHS <- cbind(y[j,1], -y[j,2], 0, 0)   # Sub-indicator shares y1 (NRLM) and sub-indicator share y2 (animal welfare).   
  Row3LHS <- cbind(y[j,1], 0, -y[j,3], 0)   # Sub-indicator shares y1 (NRLM) and sub-indicator share y3 (NH3 emission). 
  Row4LHS <- cbind(y[j,1], 0, 0, -y[j,4])   # Sub-indicator shares y1 (NRLM) and sub-indicator share y4 (PM10 emission). 
  Amat <- rbind(Row1LHS, Row2LHS, Row3LHS, Row4LHS)
  
  # Direction of the inequality constraints
  direction <- c(rep("<=", J), rep(">=", 3));   
  
  # Right hand side  of the sub-indicator share restrictions. Right hand side is 1.
  Row1RHS<- matrix(1,J);
  Row2RHS <-matrix(0,1)  
  Row3RHS <-matrix(0,1)  
  Row4RHS <-matrix(0,1)  
  bvec <- rbind(Row1RHS, Row2RHS, Row3RHS, Row4RHS)
  
  firm.solution <- solveLP(cvec, bvec, Amat,direction, maximum=TRUE, lpSolve=TRUE); 
  
  # Store the results
  
  tB.opt[,j] <- firm.solution$solution[1:M];    # weights
  tg.opt[,j] <- firm.solution$opt;              # efficiency scores
}

result <- list("g.opt" = t(tg.opt));
result
# G.opt indicates the performance scores of the combinations of system changes in case of a 1 standard deviation increase in the feed price



#====================================================================================#
# NRLM driven scenario - Producer price + 1 Standard deviation                       #
#====================================================================================#
y <-with(dat2,cbind(NRLMOutputprices, Welfarequality, NH3emission, PM10emission)) # These are the sub-indicators NRLM, animal welfare, NH3 emission and PM10 emission 

M <- dim(y)[2];		# Number of sub-indicators
J <- dim(y)[1];		# Number of combinations of system changes


# Matrices to store the results
tB.opt <- t(matrix(rep(0,J),J,M));   
tg.opt <- t(matrix(rep(0,J),J));

for (j in 1:J)
{
  # objective coefficients
  cvec <- c(y[j,1], y[j,2], y[j,3], y[j,4]);     # parameters of the objective function
  
  # Construct matrix A       -> these are the parameters at the left hand side of the sub-indicator share restrictions.
  Row1LHS <- y;   
  o <- matrix(rep(0,J), J,1)
  Row2LHS <- cbind(y[j,1], -y[j,2], 0, 0)   # Sub-indicator shares y1 (NRLM) and sub-indicator share y2 (animal welfare).   
  Row3LHS <- cbind(y[j,1], 0, -y[j,3], 0)   # Sub-indicator shares y1 (NRLM) and sub-indicator share y3 (NH3 emission). 
  Row4LHS <- cbind(y[j,1], 0, 0, -y[j,4])   # Sub-indicator shares y1 (NRLM) and sub-indicator share y4 (PM10 emission). 
  Amat <- rbind(Row1LHS, Row2LHS, Row3LHS, Row4LHS)
  
  # Direction of the inequality constraints
  direction <- c(rep("<=", J), rep(">=", 3));   
  
  # Right hand side  of the sub-indicator share restrictions. Right hand side is 1.
  Row1RHS<- matrix(1,J);
  Row2RHS <-matrix(0,1)  
  Row3RHS <-matrix(0,1)  
  Row4RHS <-matrix(0,1)  
  bvec <- rbind(Row1RHS, Row2RHS, Row3RHS, Row4RHS)
  
  firm.solution <- solveLP(cvec, bvec, Amat,direction, maximum=TRUE, lpSolve=TRUE); 
  
  # Store the results
  
  tB.opt[,j] <- firm.solution$solution[1:M];    # weights
  tg.opt[,j] <- firm.solution$opt;              # efficiency scores
}

result <- list("g.opt" = t(tg.opt));
result
# G.opt indicates the performance scores of the combinations of system changes in case of a 1 standard deviation increase in the output price




