/**
 * File RandomConstraint.java
 *
 * This file is part of the jSAM project.
 *
 * Copyright 2016 TNO
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package nl.coenvl.sam.constraints;

import nl.coenvl.sam.variables.DiscreteVariable;

/**
 * RandomConstraint
 *
 * @author leeuwencjv
 * @version 0.1
 * @since 26 feb. 2016
 */
public class RandomConstraint<V> extends CostMatrixConstraint<V> {

    public static final double MAX_COST = 1;

    public RandomConstraint(DiscreteVariable<V> var1, DiscreteVariable<V> var2) {
        super(var1,
                var2,
                RandomConstraint.randomMatrix(var1.getRange(), var2.getRange()),
                RandomConstraint.randomMatrix(var2.getRange(), var1.getRange()));
    }

    /**
     * Create a matrix of random doubles of size x by y. Each element is generated by a call to Math.random, multiplied
     * by the MAX_COST variable. Therefore the domain of the random values is [0,MAX_COST).
     *
     * @param x
     * @param y
     * @return
     */
    public static double[][] randomMatrix(int x, int y) {
        double[][] costs = new double[x][y];

        for (int i = 0; i < x; i++) {
            for (int j = 0; j < y; j++) {
                costs[i][j] = Math.random() * RandomConstraint.MAX_COST;
            }
        }

        return costs;
    }
}
