%List of parameters
pv = 2.9; % value of time (eur/h)
pw = 2*pv; % relative value of waiting time
pa = 2.5*pv; % relative value of access time
A = 10; % main haul distance (km)
L = 2; % side of the capture zone (km) for SAV pick ups and walk distances
gamma = 0.73; %shortest path to pick up K passengers in a unit square; a naive upper bound
v_c = 25; % average speed for PT, SAV and car (km/h) 
v_a = 4; % average walking speed (km/h)
q = 0.3; % average distance between the centre of unit square to a point in it
delta = q; % assumed extra distance of private cars compared to public transport. Value delta = q is selected as the midpoint of range [0;2q]
cA = 4; % monetary costs car trip; 1 eur / l; 10 km / l + depreciation
c0 = 4.02; % monetary costs (independent of capacity) per hour for PT
c1 = 0.29; % monetary costs per seat per hour for PT
B = 10; % private travel benefit
K_SAV = 3; % capacity of SAV
K_PT = 50; % capacity of PT
fmax=0.5; %f if capacity=2
fmin=0.25; 
K_SAV_VECTOR=2:12;


%first we study the effect K_SAV
P_PT1=zeros(1,numel(K_SAV_VECTOR));
P_A1=P_PT1;
P_PT2=P_PT1;
P_A2=P_PT1;
P_SAV2=P_PT1;
V1=P_PT1;
V2=P_PT1;
FVector=zeros(numel(K_SAV_VECTOR)-1,3);


for k=2:numel(K_SAV_VECTOR)
    K_SAV=K_SAV_VECTOR(k);

    %% Choose one among the following three lines
     f1 = fmax + (K_SAV-K_SAV_VECTOR(1))*(fmin-fmax)/(K_SAV_VECTOR(end)-K_SAV_VECTOR(1));
    FVector(k-1,1)=f1;
     f2 = 0.5;
    FVector(k-1,2)=f2;
     fminAux = (fmin-fmax*K_SAV_VECTOR(1)/K_SAV_VECTOR(end))/(1-K_SAV_VECTOR(1)/K_SAV_VECTOR(end));  f3=fminAux + (K_SAV_VECTOR(1)/K_SAV)*(fmax-fminAux);
    FVector(k-1,3)=f3;

    gPT=Gamma_PT(A,L,gamma,v_c,c0,c1,cA,pw,pv,pa,K_PT,q,delta,K_SAV,v_a);
    gA=Gamma_A(A,L,gamma,v_c,c0,c1,cA,pw,pv,pa,K_PT,q,delta,K_SAV,v_a);
    gSAV=Gamma_SAV(A,L,gamma,v_c,c0,c1,cA,pw,pv,pa,K_PT,q,delta,K_SAV,v_a);

    x=CheckThreeConditions(gPT,gSAV,gA,f1,B);

    [aux1,aux2]=ModalShare1(gPT,gSAV,gA,f1,B);
    P_PT1(k)=aux1;
    P_A1(k)=aux2;
    [aux1,aux2,aux3]=ModalShare2(gPT,gSAV,gA,f1,B);
    P_PT2(k)=aux1;
    P_A2(k)=aux2;
    P_SAV2(k)=aux3;

    V_A=VKT_A(A,L,gamma,v_c,c0,c1,cA,pw,pv,pa,K_PT,q,delta,K_SAV,v_a);
    V_PT=VKT_PT(A,L,gamma,v_c,c0,c1,cA,pw,pv,pa,K_PT,q,delta,K_SAV,v_a);
    V_SAV=VKT_SAV(A,L,gamma,v_c,c0,c1,cA,pw,pv,pa,K_PT,q,delta,K_SAV,v_a);

    V1(k)=VKT_1(gPT,gSAV,gA,f1,B,V_PT,V_SAV,V_A);
    V2(k)=VKT_2(gPT,gSAV,gA,f1,B,V_PT,V_SAV,V_A);

    V2_f2(k)=VKT_2(gPT,gSAV,gA,f2,B,V_PT,V_SAV,V_A);
    V2_f3(k)=VKT_2(gPT,gSAV,gA,f3,B,V_PT,V_SAV,V_A);

end

% %now we study the effect of B
% K_SAV=4;
% f = fmax + (K_SAV-K_SAV_VECTOR(1))*(fmin-fmax)/(K_SAV_VECTOR(end)-K_SAV_VECTOR(1));
% B_VECTOR=linspace(4,20,100);
% P_PT1=zeros(1,numel(B_VECTOR));
% P_A1=P_PT1;
% P_PT2=P_PT1;
% P_A2=P_PT1;
% P_SAV2=P_PT1;
% V1=P_PT1;
% V2=P_PT1;
% 
% for k=1:numel(B_VECTOR)
%     B=B_VECTOR(k);
%     gPT=Gamma_PT(A,L,gamma,v_c,c0,c1,cA,pw,pv,pa,K_PT,q,delta,K_SAV,v_a);
%     gA=Gamma_A(A,L,gamma,v_c,c0,c1,cA,pw,pv,pa,K_PT,q,delta,K_SAV,v_a);
%     gSAV=Gamma_SAV(A,L,gamma,v_c,c0,c1,cA,pw,pv,pa,K_PT,q,delta,K_SAV,v_a);
% 
%     x=CheckThreeConditions(gPT,gSAV,gA,f,B);
% 
%     [aux1,aux2]=ModalShare1(gPT,gSAV,gA,f,B);
%     P_PT1(k)=aux1;
%     P_A1(k)=aux2;
%     [aux1,aux2,aux3]=ModalShare2(gPT,gSAV,gA,f,B);
%     P_PT2(k)=aux1;
%     P_A2(k)=aux2;
%     P_SAV2(k)=aux3;
% 
%     V_A=VKT_A(A,L,gamma,v_c,c0,c1,cA,pw,pv,pa,K_PT,q,delta,K_SAV,v_a);
%     V_PT=VKT_PT(A,L,gamma,v_c,c0,c1,cA,pw,pv,pa,K_PT,q,delta,K_SAV,v_a);
%     V_SAV=VKT_SAV(A,L,gamma,v_c,c0,c1,cA,pw,pv,pa,K_PT,q,delta,K_SAV,v_a);
% 
%     V1(k)=VKT_1(gPT,gSAV,gA,f,B,V_PT,V_SAV,V_A);
%     V2(k)=VKT_2(gPT,gSAV,gA,f,B,V_PT,V_SAV,V_A);
% 
% end
