***Is Conversational XAI All You Need? Human-AI Decision Making With a Conversational XAI Assistant.***
Authors: Gaole He, Nilay Aishwarya, Ujwal Gadiraju
Web Information Systems Group, Faculty of EEMCS, Delft University of Technology

Corresponding author: Ujwal Gadiraju
Contact Information:
u.k.gadiraju@tudelft.nl

Delft University of Technology - Faculty of EEMCS, Department of Software Technology, Web Information Systems Group
Building 28, Van Mourik Broekmanweg 6
2628 XE Delft
The Netherlands

***General Introduction***
This dataset contains data collected during experiments at Delft University of Technology, as part of Gaole He's PhD Thesis project: It is being made public both to act as supplementary data for publications and the PhD thesis of Gaole He and in order for other researchers to use this data in their own work.

The data in this data set was collected in the Web Information Systems Group, Faculty of EEMCS, between June 2023 and Sep 2024.


***Purpose of the dataset***
The purpose of these experiments was to investigate (1)  How does a conversational XAI interface shape user understanding of an AI system, in comparison with the XAI Dashboard? and (2) How does a conversational XAI interface influence user trust and reliance on an AI system, in comparison with the XAI Dashboard?


***Description of the data in this dataset***
The dataset (data.zip) consists of dataset user responses in our main study (data.zip) in loan approval tasks from [Kaggle loan prediction](https://www.kaggle.com/altruistdelhite04/loan-prediction-problem-dataset) dataset and the data analysis code (code.zip). All data released are anonymized.

The user responses are collected from Prolific Platform. util.py in code.zip shows how to load these csv files.

- xailabdata_all.csv, it includes all data collected for conditions control, dashboard, CXAI, ECXAI.
- xailabdata_llmagent.csv, it includes all data collected for condition LLM agent.

Both above files follow the same format: "userid,group,page,data". It records how one user indicate their choice on a specific page. To interpret these two data files, you need to use code/util.py. It includes user choice, user click, user conversation etc.


***Code Usage***

The naming of code (xx.ipynb) typycally indicates its usage. Experimental results are also shown in the notebooks.
code used in data analysis (data_analysis.zip):

- analysis_H1.ipynb: analysis for hypothesis 1 in paper.
- analysis_H2.ipynb: analysis for hypothesis 2 in paper.
- analysis_H3.ipynb: analysis for hypothesis 3 in paper.
- calc_measures.py: calculate the depedent variables with reliance and appropriate relaince.
- descriptive_statistics.ipynb: Sec 5.1, Distribution of covariates, Performance Overview
- draw_explanation_utility_plot.py: bar plot illustrating the explanation utility (Figure 4 in section 5.1)
- estimation_plot_reliance.ipynb: code to draw estimation plot for user trust across conditions (used in supplementary materials)
- estimation_plot_trust.ipynb: code to draw estimation plot for user reliance across conditions (used in supplementary materials)
- exploratory_confidence_comparison.ipynb, exploratory analysis of confidence dynamics across conditions (shown in appendix)
- exploratory_covariate_correlation.ipynb: exploratory analysis of Spearman rank order correlation between covariates and dependent variables (shown in appendix)
- exploratory_engagement.ipynb: exploratory analysis of user engagement across conditions (shown in appendix)
- exploratory_personalization.ipynb: exploratory analysis of Enhanced Conversation and XAI Usage (section A.2.5)
- exploratory_reliance_R_square.ipynb: Correlation between perception-based variables (i.e., user understanding, explanation utility, and user trust) and
behavior-based variables. (Table 5 in Appendix)
- util.py: prepare necessary variables for evaluation (e.g., correct answers, user responses)

