# Data underlying the research on: Stated COVID-19 risk ratings and train route choices
Authors: Thijs van de Wiel, Sanmay Shelat, Eric Molin, Hans van Lint, Oded Cats,

Department of Transport and Planning, Delft University of Technology

Corresponding author: Sanmay Shelat

Contact Information: s.shelat@tudelft.nl

## Introduction
This dataset contains stated choice data and personal characteristics (COVID-19 related qualitative measures, socio-economic, mobility characteristics) data collected from an online survey for the MSc thesis of Thijs van de Wiel: "Impacts of COVID-19 Risk Perceptions on Train Travel Decisions: A Hierarchical Information Integration Analysis" (http://resolver.tudelft.nl/uuid:ad83794c-fc52-41c3-8a27-276187c5b81e)

The data can be used to replicate the analysis in the paper linked to the dataset.

## Data
A 2-stage stated choice experiment was conducted to under the effect of COVID-19 on public transport route choice. The first stage is used to analyse travellers' perceived COVID-19 risk and the second stage is used to see how this perceived risk is traded off with other attributes for route choice. In addition, personal characteristics and qualitative measures are collected to understand how they influence risk perception and route choice.

## Description of the data set
The regression data file (regression_data_for_upload.sav) contains data from the first stage of the experiment and relevant personal characteristics (to COVID-19 risk perception).

The choice data file (choice_data_for_upload.xlsx) contains data from the second stage of the experiment and relevant personal characteristics (to route choice behaviour).

Details regarding attribute levels and coding can be found in the linked paper.