%%
%%% The simulated spectral characterists of gold NP-doped optical fibre %%%

%figure 1: period number vs number of gold NPs in the gauge lengths
%figure 2: period number vs gold concentration in core of the optical fibre
%figure 3: period number vs gold volume ratio in core of the optical fibre
%figure 4: period number vs gold volume ratio in core of the optical fibre
%figure 5: light intensity (backscattering) vs volume ratio of gold
%figure 6: light intensity (backscattering) vs volume ratio of gold [guage lengths: 0.1069cm, 0.5345cm, 1.0690cm and 2.1379cm]
%figure 7: light intensity (backscattering) vs volume ratio of gold  [the guage length is 1.069mm]
%figure 8: period number vs effective RI real part of NP-doped optical fibre
%figure 9: period number vs effecitive RI imaginary part

clear
clc


%%
%input
%nanoparticlediameter=100;%nm 


%waixunhuan1 :noise level
%noiselevelinput=0:0.1:0.5;%0~1; %noise to signal ratio
noiselevelinput=0;%test
[temp,waixunhuan1end]=size(noiselevelinput);

%waixunhuan2 :strain
%strainrangeinput=-3000:200:3000;
strainrangeinput=100;%test
[temp,waixunhuan2end]=size(strainrangeinput);

%waixunhuan3 :length
Ldnumbdainput=[2000,10*10^3,20*10^3,40*10^3];%length of the sensor/Numbeda1550
[temp,waixunhuan3end]=size(Ldnumbdainput);
totalfibrelength=Ldnumbdainput*1550/2/1.45/10^(7);

%waixunhuan4 :total NP number
totalNumberNP2input=[100,200,300,400,500,600,700,800,900,1000,2000,3000,4000,5000,10*10^3];%number of NP in the sensor
%totalNumberNP2input=[1*10^2];%test
[temp,waixunhuan4end]=size(totalNumberNP2input);
%%
%inital result arrays
%1 wavelength shift;2 wavelength shift deviation; 3 light intensity; 4 light intensity deviation; 5 end period number; 6 end period number deviation; 
%7 NP size; 8 strain; 9 length; 10 number of NPs; 11 concentration; 12 volume ratio; 13 noise level; 
%14 single scattering length; 15 3dB length; 16 real eff refractive index; 
%17 imag eff refractive index
%18 median end period number; 19 min end period number 20 max end period number
%21 min wavelength shift; 22 max wavelength shift

%%
%input2
givenlambda=1550;%nm
n2=1.45;
corediameter=9500;%nm


lambdamin=1545;%small range
lambdamax=1555;
lambdaresolution=0.001;%nm


lambda2=lambdamin:lambdaresolution:lambdamax;%large range


[p1,q1]=size(lambda2);

%%
load data.mat

%%
for i=1:1:waixunhuan3end %length
    for j=1:1:waixunhuan4end %NP number
        suozaihang=find(result1array100nm(:,9)==totalfibrelength(i)&result1array100nm(:,10)==totalNumberNP2input(j));
        shift100nm(i,j)=result1array100nm(suozaihang,1);
        shift100nmdeviation(i,j)=result1array100nm(suozaihang,2);
        intensity100nm(i,j)=result1array100nm(suozaihang,3);
        intensity100nmdeviation(i,j)=result1array100nm(suozaihang,4);
        endperiod100nm(i,j)=result1array100nm(suozaihang,5);
        endperiod100nmstd(i,j)=result1array100nm(suozaihang,6);
        concentration100nm(i,j)=result1array100nm(suozaihang,11);
        volumeratio100nm(i,j)=result1array100nm(suozaihang,12);
        realRI100nm(i,j)=result1array100nm(suozaihang,16);
        imagRI100nm(i,j)=result1array100nm(suozaihang,17);
    end
end
for i=1:1:waixunhuan3end %length
    for j=1:1:waixunhuan4end %NP number
        suozaihang=find(result1array200nm(:,9)==totalfibrelength(i)&result1array200nm(:,10)==totalNumberNP2input(j));
        shift200nm(i,j)=result1array200nm(suozaihang,1);
        shift200nmdeviation(i,j)=result1array200nm(suozaihang,2);
        intensity200nm(i,j)=result1array200nm(suozaihang,3);
        intensity200nmdeviation(i,j)=result1array200nm(suozaihang,4);
        endperiod200nm(i,j)=result1array200nm(suozaihang,5);
        endperiod200nmstd(i,j)=result1array200nm(suozaihang,6);
        concentration200nm(i,j)=result1array200nm(suozaihang,11);
        volumeratio200nm(i,j)=result1array200nm(suozaihang,12);
        realRI200nm(i,j)=result1array200nm(suozaihang,16);
        imagRI200nm(i,j)=result1array200nm(suozaihang,17);
    end
end
for i=1:1:waixunhuan3end %length
    for j=1:1:waixunhuan4end %NP number
        suozaihang=find(result1array300nm(:,9)==totalfibrelength(i)&result1array300nm(:,10)==totalNumberNP2input(j));
        shift300nm(i,j)=result1array300nm(suozaihang,1);
        shift300nmdeviation(i,j)=result1array300nm(suozaihang,2);
        intensity300nm(i,j)=result1array300nm(suozaihang,3);
        intensity300nmdeviation(i,j)=result1array300nm(suozaihang,4);
        endperiod300nm(i,j)=result1array300nm(suozaihang,5);
        endperiod300nmstd(i,j)=result1array300nm(suozaihang,6);
        concentration300nm(i,j)=result1array300nm(suozaihang,11);
        volumeratio300nm(i,j)=result1array300nm(suozaihang,12);
        realRI300nm(i,j)=result1array300nm(suozaihang,16);
        imagRI300nm(i,j)=result1array300nm(suozaihang,17);
    end
end
for i=1:1:waixunhuan3end %length
    for j=1:1:waixunhuan4end %NP number
        suozaihang=find(result1array400nm(:,9)==totalfibrelength(i)&result1array400nm(:,10)==totalNumberNP2input(j));
        shift400nm(i,j)=result1array400nm(suozaihang,1);
        shift400nmdeviation(i,j)=result1array400nm(suozaihang,2);
        intensity400nm(i,j)=result1array400nm(suozaihang,3);
        intensity400nmdeviation(i,j)=result1array400nm(suozaihang,4);
        endperiod400nm(i,j)=result1array400nm(suozaihang,5);
        endperiod400nmstd(i,j)=result1array400nm(suozaihang,6);
        concentration400nm(i,j)=result1array400nm(suozaihang,11);
        volumeratio400nm(i,j)=result1array400nm(suozaihang,12);
        realRI400nm(i,j)=result1array400nm(suozaihang,16);
        imagRI400nm(i,j)=result1array400nm(suozaihang,17);
    end
end




%%
figure(1)
subplot(2,2,1)
errorbar(totalNumberNP2input,endperiod100nm(1,:),endperiod100nmstd(1,:),'.')
hold on
errorbar(totalNumberNP2input,endperiod100nm(2,:),endperiod100nmstd(2,:),'.')
hold on
errorbar(totalNumberNP2input,endperiod100nm(3,:),endperiod100nmstd(3,:),'.')
hold on
errorbar(totalNumberNP2input,endperiod100nm(4,:),endperiod100nmstd(4,:),'.')
hold off
xlabel('NP number (-)')
ylabel('Period number (-)')
%xlim([50,20000])
legend('0.1069cm','0.5345cm','1.0690cm','2.1379cm','Location','Northeast');
grid on
title('100nm')
subplot(2,2,2)
errorbar(totalNumberNP2input,endperiod200nm(1,:),endperiod200nmstd(1,:),'.')
hold on
errorbar(totalNumberNP2input,endperiod200nm(2,:),endperiod200nmstd(2,:),'.')
hold on
errorbar(totalNumberNP2input,endperiod200nm(3,:),endperiod200nmstd(3,:),'.')
hold on
errorbar(totalNumberNP2input,endperiod200nm(4,:),endperiod200nmstd(4,:),'.')
hold off
xlabel('NP number (-)')
ylabel('Period number (-)')
%xlim([50,20000])
legend('0.1069cm','0.5345cm','1.0690cm','2.1379cm','Location','Northeast');
grid on
title('200nm')
subplot(2,2,3)
errorbar(totalNumberNP2input,endperiod300nm(1,:),endperiod300nmstd(1,:),'.')
hold on
errorbar(totalNumberNP2input,endperiod300nm(2,:),endperiod300nmstd(2,:),'.')
hold on
errorbar(totalNumberNP2input,endperiod300nm(3,:),endperiod300nmstd(3,:),'.')
hold on
errorbar(totalNumberNP2input,endperiod300nm(4,:),endperiod300nmstd(4,:),'.')
hold off
xlabel('NP number (-)')
ylabel('Period number (-)')
%xlim([50,20000])
legend('0.1069cm','0.5345cm','1.0690cm','2.1379cm','Location','Northeast');
grid on
title('300nm')
subplot(2,2,4)
errorbar(totalNumberNP2input,endperiod400nm(1,:),endperiod400nmstd(1,:),'.')
hold on
errorbar(totalNumberNP2input,endperiod400nm(2,:),endperiod400nmstd(2,:),'.')
hold on
errorbar(totalNumberNP2input,endperiod400nm(3,:),endperiod400nmstd(3,:),'.')
hold on
errorbar(totalNumberNP2input,endperiod400nm(4,:),endperiod400nmstd(4,:),'.')
hold off
xlabel('NP number (-)')
ylabel('Period number (-)')
%xlim([50,20000])
legend('0.1069cm','0.5345cm','1.0690cm','2.1379cm','Location','Northeast');
grid on
title('400nm')
%%
figure(2)
subplot(2,2,1)
plot(concentration100nm(1,:),endperiod100nm(1,:),'.')
hold on
plot(concentration100nm(2,:),endperiod100nm(2,:),'o')
hold on
plot(concentration100nm(3,:),endperiod100nm(3,:),'*')
hold on
plot(concentration100nm(4,:),endperiod100nm(4,:),'>')
hold off
xlabel('Concentration (/mL)')
ylabel('Period number (-)')
%xlim([50,20000])
legend('0.1069cm','0.5345cm','1.0690cm','2.1379cm','Location','Northeast');
grid on
title('100nm')
set(gca,'XScale','log')
subplot(2,2,2)
plot(concentration200nm(1,:),endperiod200nm(1,:),'.')
hold on
plot(concentration200nm(2,:),endperiod200nm(2,:),'o')
hold on
plot(concentration200nm(3,:),endperiod200nm(3,:),'*')
hold on
plot(concentration200nm(4,:),endperiod200nm(4,:),'>')
hold off
xlabel('Concentration (/mL)')
ylabel('Period number (-)')
%xlim([50,20000])
legend('0.1069cm','0.5345cm','1.0690cm','2.1379cm','Location','Northeast');
grid on
title('200nm')
set(gca,'XScale','log')
subplot(2,2,3)
plot(concentration300nm(1,:),endperiod300nm(1,:),'.')
hold on
plot(concentration300nm(2,:),endperiod300nm(2,:),'o')
hold on
plot(concentration300nm(3,:),endperiod300nm(3,:),'*')
hold on
plot(concentration300nm(4,:),endperiod300nm(4,:),'>')
hold off
xlabel('Concentration (/mL)')
ylabel('Period number (-)')
%xlim([50,20000])
legend('0.1069cm','0.5345cm','1.0690cm','2.1379cm','Location','Northeast');
grid on
title('300nm')
set(gca,'XScale','log')
subplot(2,2,4)
plot(concentration400nm(1,:),endperiod400nm(1,:),'.')
hold on
plot(concentration400nm(2,:),endperiod400nm(2,:),'o')
hold on
plot(concentration400nm(3,:),endperiod400nm(3,:),'*')
hold on
plot(concentration400nm(4,:),endperiod400nm(4,:),'>')
hold off
xlabel('Concentration (/mL)')
ylabel('Period number (-)')
%xlim([50,20000])
legend('0.1069cm','0.5345cm','1.0690cm','2.1379cm','Location','Northeast');
grid on
title('400nm')
set(gca,'XScale','log')
%%
figure(3)
subplot(2,2,1)
plot(volumeratio100nm(1,:),endperiod100nm(1,:),'.')
hold on
plot(volumeratio100nm(2,:),endperiod100nm(2,:),'o')
hold on
plot(volumeratio100nm(3,:),endperiod100nm(3,:),'*')
hold on
plot(volumeratio100nm(4,:),endperiod100nm(4,:),'>')
hold off
xlabel('Volumeratio (-)')
ylabel('Period number (-)')
%xlim([50,20000])
legend('0.1069cm','0.5345cm','1.0690cm','2.1379cm','Location','Northeast');
grid on
title('100nm')
set(gca,'XScale','log')
subplot(2,2,2)
plot(volumeratio200nm(1,:),endperiod200nm(1,:),'.')
hold on
plot(volumeratio200nm(2,:),endperiod200nm(2,:),'o')
hold on
plot(volumeratio200nm(3,:),endperiod200nm(3,:),'*')
hold on
plot(volumeratio200nm(4,:),endperiod200nm(4,:),'>')
hold off
xlabel('Volumeratio (-)')
ylabel('Period number (-)')
%xlim([50,20000])
legend('0.1069cm','0.5345cm','1.0690cm','2.1379cm','Location','Northeast');
grid on
title('200nm')
set(gca,'XScale','log')
subplot(2,2,3)
plot(volumeratio300nm(1,:),endperiod300nm(1,:),'.')
hold on
plot(volumeratio300nm(2,:),endperiod300nm(2,:),'o')
hold on
plot(volumeratio300nm(3,:),endperiod300nm(3,:),'*')
hold on
plot(volumeratio300nm(4,:),endperiod300nm(4,:),'>')
hold off
xlabel('Volumeratio (-)')
ylabel('Period number (-)')
%xlim([50,20000])
legend('0.1069cm','0.5345cm','1.0690cm','2.1379cm','Location','Northeast');
grid on
title('300nm')
set(gca,'XScale','log')
subplot(2,2,4)
plot(volumeratio400nm(1,:),endperiod400nm(1,:),'.')
hold on
plot(volumeratio400nm(2,:),endperiod400nm(2,:),'o')
hold on
plot(volumeratio400nm(3,:),endperiod400nm(3,:),'*')
hold on
plot(volumeratio400nm(4,:),endperiod400nm(4,:),'>')
hold off
xlabel('Volumeratio (-)')
ylabel('Period number (-)')
%xlim([50,20000])
legend('0.1069cm','0.5345cm','1.0690cm','2.1379cm','Location','Northeast');
grid on
title('400nm')
set(gca,'XScale','log')
%%
figure(4)
plot([volumeratio100nm(1,:),result1array100nm_2(1,12)'],[endperiod100nm(1,:),result1array100nm_2(1,5)'],'r.')
hold on
plot([volumeratio100nm(2,:),result1array100nm_2(2,12)'],[endperiod100nm(2,:),result1array100nm_2(2,5)'],'ro')
hold on
plot([volumeratio100nm(3,:),result1array100nm_2(3,12)'],[endperiod100nm(3,:),result1array100nm_2(3,5)'],'r*')
hold on
plot([volumeratio100nm(4,:),result1array100nm_2(4,12)'],[endperiod100nm(4,:),result1array100nm_2(4,5)'],'r>')
hold on

plot([volumeratio200nm(1,:),result1array200nm_2(1,12)'],[endperiod200nm(1,:),result1array200nm_2(1,5)'],'g.')
hold on
plot([volumeratio200nm(2,:),result1array200nm_2(2,12)'],[endperiod200nm(2,:),result1array200nm_2(2,5)'],'go')
hold on
plot([volumeratio200nm(3,:),result1array200nm_2(3,12)'],[endperiod200nm(3,:),result1array200nm_2(3,5)'],'g*')
hold on
plot([volumeratio200nm(4,:),result1array200nm_2(4,12)'],[endperiod200nm(4,:),result1array200nm_2(4,5)'],'g>')
hold on

plot(volumeratio300nm(1,:),endperiod300nm(1,:),'b.')
hold on
plot(volumeratio300nm(2,:),endperiod300nm(2,:),'bo')
hold on
plot(volumeratio300nm(3,:),endperiod300nm(3,:),'b*')
hold on
plot(volumeratio300nm(4,:),endperiod300nm(4,:),'b>')
hold on

plot(volumeratio400nm(1,:),endperiod400nm(1,:),'black.')
hold on
plot(volumeratio400nm(2,:),endperiod400nm(2,:),'blacko')
hold on
plot(volumeratio400nm(3,:),endperiod400nm(3,:),'black*')
hold on
plot(volumeratio400nm(4,:),endperiod400nm(4,:),'black>')
hold off
xlabel('Volume ratio (-)')
ylabel('Period number (-)')
legend('0.1069cm 100nm','0.5345cm 100nm','1.0690cm 100nm','2.1379cm 100nm','0.1069cm 200nm','0.5345cm 200nm','1.0690cm 200nm','2.1379cm 200nm','0.1069cm 300nm','0.5345cm 300nm','1.0690cm 300nm','2.1379cm 300nm','0.1069cm 400nm','0.5345cm 400nm','1.0690cm 400nm','2.1379cm 400nm','Location','Northeast');
grid on
set(gca,'XScale','log')

%%
figure(5)
plot(volumeratio100nm(1,:),intensity100nm(1,:),'r.')
hold on
plot(volumeratio100nm(2,:),intensity100nm(2,:),'ro')
hold on
plot(volumeratio100nm(3,:),intensity100nm(3,:),'r*')
hold on
plot(volumeratio100nm(4,:),intensity100nm(4,:),'r>')
hold on

plot(volumeratio200nm(1,:),intensity200nm(1,:),'g.')
hold on
plot(volumeratio200nm(2,:),intensity200nm(2,:),'go')
hold on
plot(volumeratio200nm(3,:),intensity200nm(3,:),'g*')
hold on
plot(volumeratio200nm(4,:),intensity200nm(4,:),'g>')
hold on

plot(volumeratio300nm(1,:),intensity300nm(1,:),'b.')
hold on
plot(volumeratio300nm(2,:),intensity300nm(2,:),'bo')
hold on
plot(volumeratio300nm(3,:),intensity300nm(3,:),'b*')
hold on
plot(volumeratio300nm(4,:),intensity300nm(4,:),'b>')
hold on

plot(volumeratio400nm(1,:),intensity400nm(1,:),'black.')
hold on
plot(volumeratio400nm(2,:),intensity400nm(2,:),'blacko')
hold on
plot(volumeratio400nm(3,:),intensity400nm(3,:),'black*')
hold on
plot(volumeratio400nm(4,:),intensity400nm(4,:),'black>')
hold off
xlabel('Volume ratio (-)')
ylabel('Intensity (pW)')
legend('0.1069cm 100nm','0.5345cm 100nm','1.0690cm 100nm','2.1379cm 100nm','0.1069cm 200nm','0.5345cm 200nm','1.0690cm 200nm','2.1379cm 200nm','0.1069cm 300nm','0.5345cm 300nm','1.0690cm 300nm','2.1379cm 300nm','0.1069cm 400nm','0.5345cm 400nm','1.0690cm 400nm','2.1379cm 400nm','Location','Northeast');
grid on
set(gca,'XScale','log')
set(gca,'YScale','log')

%%
figure(6)
subplot(2,2,1)
errorbar(volumeratio100nm(1,:),intensity100nm(1,:),intensity100nmdeviation(1,:),'Marker','.','Color','#0072BD','LineStyle','none')
hold on
errorbar(volumeratio200nm(1,:),intensity200nm(1,:),intensity200nmdeviation(1,:),'Marker','o','Color','#D95319','LineStyle','none')
hold on
volumeratio300nmappend=[volumeratio300nm(1,:),result1array300nm_append(:,12)'];
intensity300nmappend=[intensity300nm(1,:),result1array300nm_append(:,3)'];
intensity300deviationnmappend=[intensity300nmdeviation(1,:),result1array300nm_append(:,4)'];
errorbar(volumeratio300nmappend(1,:),intensity300nmappend(1,:),intensity300deviationnmappend(1,:),'Marker','*','Color','#EDB120','LineStyle','none')
hold on
volumeratio400nmappend=[volumeratio400nm(1,:),result1array400nm_append(:,12)'];
intensity400nmappend=[intensity400nm(1,:),result1array400nm_append(:,3)'];
intensity400deviationnmappend=[intensity400nmdeviation(1,:),result1array400nm_append(:,4)'];
errorbar(volumeratio400nmappend(1,:),intensity400nmappend(1,:),intensity400deviationnmappend(1,:),'Marker','>','Color','#7E2F8E','LineStyle','none')
hold on
plot([8.4313*10^(-5),8.4313*10^(-5)],[10^2,10^7],'Color','#0072BD','linewidth',1,'HandleVisibility','off')
hold on
plot([1.5882*10^(-5),1.5882*10^(-5)],[10^2,10^7],'Color','#D95319','linewidth',1,'HandleVisibility','off')
hold on
plot([5.8611*10^(-6),5.8611*10^(-6)],[10^2,10^7],'Color','#EDB120','linewidth',1,'HandleVisibility','off')
hold on
plot([6.1961*10^(-6),6.1961*10^(-6)],[10^2,10^7],'Color','#7E2F8E','linewidth',1,'HandleVisibility','off')
hold off
xlabel('Volume ratio (-)')
ylabel('Intensity (pW)')
legend('0.1069cm 100nm','0.1069cm 200nm','0.1069cm 300nm','0.1069cm 400nm','Location','Southeast');
grid on
set(gca,'XScale','log')
set(gca,'YScale','log')
xlim([10^(-7),10^(-2)]);
ylim([10^2,10^7]);
subplot(2,2,2)
errorbar(volumeratio100nm(2,:),intensity100nm(2,:),intensity100nmdeviation(2,:),'.')
hold on
errorbar(volumeratio200nm(2,:),intensity200nm(2,:),intensity200nmdeviation(2,:),'o')
hold on
errorbar(volumeratio300nm(2,:),intensity300nm(2,:),intensity300nmdeviation(2,:),'*')
hold on
errorbar(volumeratio400nm(2,:),intensity400nm(2,:),intensity400nmdeviation(2,:),'>')
hold off
xlabel('Volume ratio (-)')
ylabel('Intensity (pW)')
legend('0.5345cm 100nm','0.5345cm 200nm','0.5345cm 300nm','0.5345cm 400nm','Location','Southeast');
grid on
set(gca,'XScale','log')
set(gca,'YScale','log')
xlim([10^(-7),10^(-2)]);
ylim([10^2,10^7]);
subplot(2,2,3)
errorbar(volumeratio100nm(3,:),intensity100nm(3,:),intensity100nmdeviation(3,:),'.')
hold on
errorbar(volumeratio200nm(3,:),intensity200nm(3,:),intensity200nmdeviation(3,:),'o')
hold on
errorbar(volumeratio300nm(3,:),intensity300nm(3,:),intensity300nmdeviation(3,:),'*')
hold on
errorbar(volumeratio400nm(3,:),intensity400nm(3,:),intensity400nmdeviation(3,:),'>')
hold off
xlabel('Volume ratio (-)')
ylabel('Intensity (pW)')
legend('1.0690cm 100nm','1.0690cm 200nm','1.0690cm 300nm','1.0690cm 400nm','Location','Southeast');
grid on
set(gca,'XScale','log')
set(gca,'YScale','log')
xlim([10^(-7),10^(-2)]);
ylim([10^2,10^7]);
subplot(2,2,4)
errorbar(volumeratio100nm(4,:),intensity100nm(4,:),intensity100nmdeviation(4,:),'.')
hold on
errorbar(volumeratio200nm(4,:),intensity200nm(4,:),intensity200nmdeviation(4,:),'o')
hold on
errorbar(volumeratio300nm(4,:),intensity300nm(4,:),intensity300nmdeviation(4,:),'*')
hold on
errorbar(volumeratio400nm(4,:),intensity400nm(4,:),intensity400nmdeviation(4,:),'>')
hold off
xlabel('Volume ratio (-)')
ylabel('Intensity (pW)')
legend('2.1379cm 100nm','2.1379cm 200nm','2.1379cm 300nm','2.1379cm 400nm','Location','Southeast');
grid on
set(gca,'XScale','log')
set(gca,'YScale','log')
xlim([10^(-7),10^(-2)]);
ylim([10^2,10^7]);

%%
%%
figure(7)%0.1609cm
errorbar([volumeratio100nm(1,:),result1array100nm_2(1,12)',result1array100nm_3(1,12)'],[intensity100nm(1,:),result1array100nm_2(1,3)',result1array100nm_3(1,3)'],[intensity100nmdeviation(1,:),result1array100nm_2(1,4)',result1array100nm_3(1,4)'],'Marker','.','Color','#0072BD','LineStyle','none')
hold on
errorbar(volumeratio200nm(1,:),intensity200nm(1,:),intensity200nmdeviation(1,:),'Marker','o','Color','#D95319','LineStyle','none')
hold on
volumeratio300nmappend=[volumeratio300nm(1,:),result1array300nm_append(:,12)'];
intensity300nmappend=[intensity300nm(1,:),result1array300nm_append(:,3)'];
intensity300deviationnmappend=[intensity300nmdeviation(1,:),result1array300nm_append(:,4)'];
errorbar(volumeratio300nmappend(1,:),intensity300nmappend(1,:),intensity300deviationnmappend(1,:),'Marker','*','Color','#EDB120','LineStyle','none')
hold on
volumeratio400nmappend=[volumeratio400nm(1,:),result1array400nm_append(:,12)'];
intensity400nmappend=[intensity400nm(1,:),result1array400nm_append(:,3)'];
intensity400deviationnmappend=[intensity400nmdeviation(1,:),result1array400nm_append(:,4)'];
errorbar(volumeratio400nmappend(1,:),intensity400nmappend(1,:),intensity400deviationnmappend(1,:),'Marker','>','Color','#7E2F8E','LineStyle','none')
hold on
plot([8.4313*10^(-5),8.4313*10^(-5)],[10^2,10^7],'Color','#0072BD','linewidth',1,'HandleVisibility','off')
hold on
plot([1.5882*10^(-5),1.5882*10^(-5)],[10^2,10^7],'Color','#D95319','linewidth',1,'HandleVisibility','off')
hold on
plot([5.8611*10^(-6),5.8611*10^(-6)],[10^2,10^7],'Color','#EDB120','linewidth',1,'HandleVisibility','off')
hold on
plot([6.1961*10^(-6),6.1961*10^(-6)],[10^2,10^7],'Color','#7E2F8E','linewidth',1,'HandleVisibility','off')
hold off
xlabel('Volume ratio (-)')
ylabel('Intensity (pW)')
legend('100nm','200nm','300nm','400nm','Location','Southeast');
grid on
set(gca,'XScale','log')
set(gca,'YScale','log')
%xlim([5*10^(-7),5*10^(-3)]);
ylim([10^2,10^7]);

%%
figure(8)
plot([realRI100nm(1,:),result1array100nm_2(1,16)'],[endperiod100nm(1,:),result1array100nm_2(1,5)'],'r.')
hold on
plot([realRI100nm(2,:),result1array100nm_2(2,16)'],[endperiod100nm(2,:),result1array100nm_2(2,5)'],'ro')
hold on
plot([realRI100nm(3,:),result1array100nm_2(3,16)'],[endperiod100nm(3,:),result1array100nm_2(3,5)'],'r*')
hold on
plot([realRI100nm(4,:),result1array100nm_2(4,16)'],[endperiod100nm(4,:),result1array100nm_2(4,5)'],'r>')
hold on

plot([realRI200nm(1,:),result1array200nm_2(1,16)'],[endperiod200nm(1,:),result1array200nm_2(1,5)'],'g.')
hold on
plot([realRI200nm(2,:),result1array200nm_2(2,16)'],[endperiod200nm(2,:),result1array200nm_2(2,5)'],'go')
hold on
plot([realRI200nm(3,:),result1array200nm_2(3,16)'],[endperiod200nm(3,:),result1array200nm_2(3,5)'],'g*')
hold on
plot([realRI200nm(4,:),result1array200nm_2(4,16)'],[endperiod200nm(4,:),result1array200nm_2(4,5)'],'g>')
hold on

plot(realRI300nm(1,:),endperiod300nm(1,:),'b.')
hold on
plot(realRI300nm(2,:),endperiod300nm(2,:),'bo')
hold on
plot(realRI300nm(3,:),endperiod300nm(3,:),'b*')
hold on
plot(realRI300nm(4,:),endperiod300nm(4,:),'b>')
hold on

plot(realRI400nm(1,:),endperiod400nm(1,:),'black.')
hold on
plot(realRI400nm(2,:),endperiod400nm(2,:),'blacko')
hold on
plot(realRI400nm(3,:),endperiod400nm(3,:),'black*')
hold on
plot(realRI400nm(4,:),endperiod400nm(4,:),'black>')
hold off
xlabel('effective RI real part (-)')
ylabel('Period number (-)')
legend('0.1069cm 100nm','0.5345cm 100nm','1.0690cm 100nm','2.1379cm 100nm','0.1069cm 200nm','0.5345cm 200nm','1.0690cm 200nm','2.1379cm 200nm','0.1069cm 300nm','0.5345cm 300nm','1.0690cm 300nm','2.1379cm 300nm','0.1069cm 400nm','0.5345cm 400nm','1.0690cm 400nm','2.1379cm 400nm','Location','Northeast');
grid on
title('real')

%%
figure(9)
plot([imagRI100nm(1,:),result1array100nm_2(1,17)',result1array100nm_3(1,17)'],[endperiod100nm(1,:),result1array100nm_2(1,5)',result1array100nm_3(1,5)'],'r*')
hold on
%plot([imagRI100nm(2,:),result1array100nm_2(2,17)'],[endperiod100nm(2,:),result1array100nm_2(2,5)'],'ro')
plot([imagRI100nm(2,:),result1array100nm_2(2,17)',result1array100nm_3(2,17)'],[endperiod100nm(2,:),result1array100nm_2(2,5)',result1array100nm_3(2,5)'],'ro')
hold on
plot([imagRI100nm(3,:),result1array100nm_2(3,17)',result1array100nm_3(3,17)'],[endperiod100nm(3,:),result1array100nm_2(3,5)',result1array100nm_3(3,5)'],'r.')
%plot([imagRI100nm(3,:),result1array100nm_2(3,17)'],[endperiod100nm(3,:),result1array100nm_2(3,5)'],'r.')
hold on
plot([imagRI100nm(4,:),result1array100nm_2(4,17)',result1array100nm_3(4,17)'],[endperiod100nm(4,:),result1array100nm_2(4,5)',result1array100nm_3(4,5)'],'r>')
%plot([imagRI100nm(4,:),result1array100nm_2(4,17)'],[endperiod100nm(4,:),result1array100nm_2(4,5)'],'r>')
hold on

%plot([imagRI200nm(1,:),result1array200nm_2(1,17)'],[endperiod200nm(1,:),result1array200nm_2(1,5)'],'g*')
plot([imagRI200nm(1,:),result1array200nm_2(1,17)',result1array200nm_3(1,17)'],[endperiod200nm(1,:),result1array200nm_2(1,5)',result1array200nm_3(1,5)'],'g*')
hold on
plot([imagRI200nm(2,:),result1array200nm_2(2,17)',result1array200nm_3(2,17)'],[endperiod200nm(2,:),result1array200nm_2(2,5)',result1array200nm_3(2,5)'],'go')
%plot([imagRI200nm(2,:),result1array200nm_2(2,17)'],[endperiod200nm(2,:),result1array200nm_2(2,5)'],'go')
hold on
plot([imagRI200nm(3,:),result1array200nm_2(3,17)',result1array200nm_3(3,17)'],[endperiod200nm(3,:),result1array200nm_2(3,5)',result1array200nm_3(3,5)'],'g.')
%plot([imagRI200nm(3,:),result1array200nm_2(3,17)'],[endperiod200nm(3,:),result1array200nm_2(3,5)'],'g.')
hold on
plot([imagRI200nm(4,:),result1array200nm_2(4,17)',result1array200nm_3(4,17)'],[endperiod200nm(4,:),result1array200nm_2(4,5)',result1array200nm_3(4,5)'],'g>')
%plot([imagRI200nm(4,:),result1array200nm_2(4,17)'],[endperiod200nm(4,:),result1array200nm_2(4,5)'],'g>')
hold on

plot([imagRI300nm(1,:),result1array300nm_append(:,17)'],[endperiod300nm(1,:),result1array300nm_append(:,18)'],'b*')
hold on
plot([imagRI300nm(2,:),result1array300nm_05345(:,17)'],[endperiod300nm(2,:),result1array300nm_05345(:,18)'],'bo')
hold on
plot([imagRI300nm(3,:),result1array300nm_10690(:,17)'],[endperiod300nm(3,:),result1array300nm_10690(:,18)'],'b.')
hold on
plot([imagRI300nm(4,:),result1array300nm_21379(:,17)'],[endperiod300nm(4,:),result1array300nm_21379(:,18)'],'b>')
hold on

plot([imagRI400nm(1,:),result1array400nm_append(:,17)'],[endperiod400nm(1,:),result1array400nm_append(:,18)'],'black*')
hold on
plot([imagRI400nm(2,:),result1array400nm_05345(:,17)'],[endperiod400nm(2,:),result1array400nm_05345(:,18)'],'blacko')
hold on
plot([imagRI400nm(3,:),result1array400nm_10690(:,17)'],[endperiod400nm(3,:),result1array400nm_10690(:,18)'],'black.')
hold on
plot([imagRI400nm(4,:),result1array400nm_21379(:,17)'],[endperiod400nm(4,:),result1array400nm_21379(:,18)'],'black>')


hold on
plot(7.2236*10^(-6),250,'r*','HandleVisibility','off')
plot(1.4447*10^(-6),250,'ro','HandleVisibility','off')
plot(7.2236*10^(-7),250,'r.','HandleVisibility','off')
plot(3.6118*10^(-7),250,'r>','HandleVisibility','off')

plot(8.2323*10^(-6),246,'g*','HandleVisibility','off')
plot(1.6465*10^(-6),246,'go','HandleVisibility','off')
plot(8.2323*10^(-7),246,'g.','HandleVisibility','off')
plot(4.1161*10^(-7),246,'g>','HandleVisibility','off')

plot(8.4846*10^(-6),242,'b*','HandleVisibility','off')
plot(1.6969*10^(-6),242,'bo','HandleVisibility','off')
plot(8.4846*10^(-7),242,'b.','HandleVisibility','off')
plot(4.2423*10^(-7),242,'b>','HandleVisibility','off')

plot(8.5402*10^(-6),238,'black*','HandleVisibility','off')
plot(1.7080*10^(-6),238,'blacko','HandleVisibility','off')
plot(8.5402*10^(-7),238,'black.','HandleVisibility','off')
plot(4.2701*10^(-7),238,'black>','HandleVisibility','off')




hold off
xlabel('Effective RI imaginary part(-)')
ylabel('Period number (-)')
legend('0.1069cm 100nm','0.5345cm 100nm','1.0690cm 100nm','2.1379cm 100nm','0.1069cm 200nm','0.5345cm 200nm','1.0690cm 200nm','2.1379cm 200nm','0.1069cm 300nm','0.5345cm 300nm','1.0690cm 300nm','2.1379cm 300nm','0.1069cm 400nm','0.5345cm 400nm','1.0690cm 400nm','2.1379cm 400nm','Location','Northeast');
grid on
%title('imag')
set(gca,'XScale','log')
%set(gca,'YScale','log')