def fscriptfile(filename, CPUs, tow_width, tow_height, E11, E22, E33, G12, G12T, G13, G23, CC1, CC2, CC4, CC5):

    upperName = filename.upper()
    fileE1 = filename + '_E.inp'
    fileE = filename + '_E'

    fileG1 = filename + '_G.inp'
    fileG = filename + '_G'

    Dispx = 2 * tow_width * 0.0005
    Dispy = 2 * tow_height * 0.0005
    Dispz = Dispx

    L = 4 * tow_width
    W = 4 * tow_width
    H = 2 * tow_height

    script = f"""from abaqus import *
from abaqusConstants import *
import time
import os

path = os.getcwd()
start = time.time()


"""

    if E11 == True or E22 == True or E33 == True:
        script += f"""mdb.ModelFromInputFile(inputFileName='{fileE1}', name='{fileE}')

# Create a static step.
mdb.models['{fileE}'].StaticStep(name='Step-1', previous='Initial', initialInc=0.1,  minInc=1e-10, maxNumInc=500, timePeriod=1)

a = mdb.models['{fileE}'].rootAssembly

"""

    ## Elastic modulus E11 ##
    if E11 == True:
        script += f"""for i in mdb.models['{fileE}'].loads.keys():
    del mdb.models['{fileE}'].loads[i]
for i in mdb.models['{fileE}'].boundaryConditions.keys():
    del mdb.models['{fileE}'].boundaryConditions[i]

region = a.sets['RP4']
mdb.models['{fileE}'].DisplacementBC(name='E11-1', createStepName='Step-1',
                                     region=region, u1={Dispx}, u2=UNSET, u3=UNSET, ur1=UNSET, ur2=UNSET, ur3=UNSET,
                                     amplitude=UNSET, fixed=OFF, distributionType=UNIFORM, fieldName='',
                                     localCsys=None)

regionDef = mdb.models['{fileE}'].rootAssembly.sets['C1']
mdb.models['{fileE}'].HistoryOutputRequest(name='H-Output-2',
                                           createStepName='Step-1', variables=('RT',), region=regionDef,
                                           sectionPoints=DEFAULT, rebar=EXCLUDE)

import os, glob

mdb.Job(name='Job-{fileE}-E11', model='{fileE}', description='', type=ANALYSIS,
        atTime=None, waitMinutes=0, waitHours=0, queue=None, memory=90,
        memoryUnits=PERCENTAGE, getMemoryFromAnalysis=True,
        explicitPrecision=SINGLE, nodalOutputPrecision=SINGLE, echoPrint=OFF,
        modelPrint=OFF, contactPrint=OFF, historyPrint=OFF, userSubroutine='',
        scratch='', multiprocessingMode=DEFAULT, numCpus={CPUs}, numDomains={CPUs}, numGPUs=0)
mdb.jobs['Job-{fileE}-E11'].submit(consistencyChecking=OFF)
mdb.jobs['Job-{fileE}-E11'].waitForCompletion()
o3 = session.openOdb(name='%s' % (path + '\Job-{fileE}-E11.odb'))

odb = session.odbs['%s' % (path + '\Job-{fileE}-E11.odb')]

session.viewports['Viewport: 1'].setValues(displayedObject=o3)
odbName = session.viewports[session.currentViewportName].odbDisplay.name

for i in session.xyDataObjects.keys():
    del session.xyDataObjects['%s' % (i)]

session.odbData[odbName].setValues(activeFrames=(('Step-1', (-1,)),))
session.xyDataListFromField(odb=odb, outputPosition=NODAL, variable=(('RF', NODAL, ((COMPONENT, 'RF1'),)),),
                            nodeSets=('RP4',))

forceE11 = 0
for i in session.xyDataObjects.keys():
    forceE11 = forceE11 + (session.xyDataObjects[i][0][1])

print(forceE11)
stressE11 = abs(forceE11/({H*W}))

E11 = stressE11/({Dispx/L})  

for i in session.xyDataObjects.keys():
    del session.xyDataObjects['%s' % (i)]

session.odbData[odbName].setValues(activeFrames=(('Step-1', (-1,)),))
session.xyDataListFromField(odb=odb, outputPosition=NODAL, variable=(('U', NODAL, ((COMPONENT, 'U1'),)),),
                            nodeSets=('C1', 'C2',))

C1U1new = session.xyDataObjects['U:U1 PI: %s N: %s' % ('TOW4-T', {CC1})][0][1] + {L}

C2U1new = session.xyDataObjects['U:U1 PI: %s N: %s' % ('TOW1-T', {CC2})][0][1] + 0
Dis = abs(C1U1new - C2U1new)

E11U1 = abs({L} - Dis)

for i in session.xyDataObjects.keys():
    del session.xyDataObjects['%s' % (i)]

session.odbData[odbName].setValues(activeFrames=(('Step-1', (-1,)),))
session.xyDataListFromField(odb=odb, outputPosition=NODAL, variable=(('U', NODAL, ((COMPONENT, 'U2'),)),),
                            nodeSets=('C1', 'C5',))

C1U2new = session.xyDataObjects['U:U2 PI: %s N: %s' % ('TOW4-T', {CC1})][0][1] + {H}

C5U2new = session.xyDataObjects['U:U2 PI: %s N: %s' % ('TOW4-B', {CC5})][0][1] + 0
Dis = abs(C1U2new - C5U2new)

E11U2 = abs({H} - Dis)

for i in session.xyDataObjects.keys():
    del session.xyDataObjects['%s' % (i)]

session.odbData[odbName].setValues(activeFrames=(('Step-1', (-1,)),))
session.xyDataListFromField(odb=odb, outputPosition=NODAL, variable=(('U', NODAL, ((COMPONENT, 'U3'),)),),
                            nodeSets=('C1', 'C4',))

C1U3new = session.xyDataObjects['U:U3 PI: %s N: %s' % ('TOW4-T', {CC1})][0][1] + {W}

C4U3new = session.xyDataObjects['U:U3 PI: %s N: %s' % ('TOW4-T', {CC4})][0][1] + 0
Dis = abs(C1U3new - C4U3new)

E11U3 = abs({W} - Dis)

V13 = (E11U2 / {H}) / (E11U1 / {L})
V12 = (E11U3 / {W}) / (E11U1 / {L})
"""
    ## Elastic modulus E33 ##
    if E11 == False:
        script +="""E11 = 'N/A'
V12 = 'N/A'
V13 = 'N/A'
"""

    if E33 == True:
        script += f"""for i in mdb.models['{fileE}'].loads.keys():
    del mdb.models['{fileE}'].loads[i]
for i in mdb.models['{fileE}'].boundaryConditions.keys():
    del mdb.models['{fileE}'].boundaryConditions[i]

region = a.sets['RP5']
mdb.models['{fileE}'].DisplacementBC(name='E33-1', createStepName='Step-1',
                                     region=region, u1=UNSET, u2={Dispy}, u3=UNSET, ur1=UNSET, ur2=UNSET, ur3=UNSET,
                                     amplitude=UNSET, fixed=OFF, distributionType=UNIFORM, fieldName='',
                                     localCsys=None)

regionDef = mdb.models['{fileE}'].rootAssembly.sets['C1']
mdb.models['{fileE}'].HistoryOutputRequest(name='H-Output-2',
                                           createStepName='Step-1', variables=('RT',), region=regionDef,
                                           sectionPoints=DEFAULT, rebar=EXCLUDE)

import os, glob

mdb.Job(name='Job-{fileE}-E33', model='{fileE}', description='', type=ANALYSIS,
        atTime=None, waitMinutes=0, waitHours=0, queue=None, memory=90,
        memoryUnits=PERCENTAGE, getMemoryFromAnalysis=True,
        explicitPrecision=SINGLE, nodalOutputPrecision=SINGLE, echoPrint=OFF,
        modelPrint=OFF, contactPrint=OFF, historyPrint=OFF, userSubroutine='',
        scratch='', multiprocessingMode=DEFAULT, numCpus={CPUs}, numDomains={CPUs}, numGPUs=0)
mdb.jobs['Job-{fileE}-E33'].submit(consistencyChecking=OFF)
mdb.jobs['Job-{fileE}-E33'].waitForCompletion()
o3 = session.openOdb(name='%s' % (path + '\Job-{fileE}-E33.odb'))

odb = session.odbs['%s' % (path + '\Job-{fileE}-E33.odb')]

session.viewports['Viewport: 1'].setValues(displayedObject=o3)
odbName = session.viewports[session.currentViewportName].odbDisplay.name

for i in session.xyDataObjects.keys():
    del session.xyDataObjects['%s' % (i)]

session.odbData[odbName].setValues(activeFrames=(('Step-1', (-1,)),))
session.xyDataListFromField(odb=odb, outputPosition=NODAL, variable=(('RF', NODAL, ((COMPONENT, 'RF2'),)),),
                            nodeSets=('RP5',))

forceE33 = 0
for i in session.xyDataObjects.keys():
    forceE33 = forceE33 + (session.xyDataObjects[i][0][1])

stressE33 = abs(forceE33 / ({W} * {L}))

E33 = stressE33 / ({Dispy} / {H})

for i in session.xyDataObjects.keys():
    del session.xyDataObjects['%s' % (i)]

session.odbData[odbName].setValues(activeFrames=(('Step-1', (-1,)),))
session.xyDataListFromField(odb=odb, outputPosition=NODAL, variable=(('U', NODAL, ((COMPONENT, 'U1'),)),),
                            nodeSets=('C1', 'C2',))

C1U1new = session.xyDataObjects['U:U1 PI: %s N: %s' % ('TOW4-T', {CC1})][0][1] + {L}

C2U1new = session.xyDataObjects['U:U1 PI: %s N: %s' % ('TOW1-T', {CC2})][0][1] + 0
Dis = abs(C1U1new - C2U1new)

E33U1 = abs({L} - Dis)

for i in session.xyDataObjects.keys():
    del session.xyDataObjects['%s' % (i)]

session.odbData[odbName].setValues(activeFrames=(('Step-1', (-1,)),))
session.xyDataListFromField(odb=odb, outputPosition=NODAL, variable=(('U', NODAL, ((COMPONENT, 'U2'),)),),
                            nodeSets=('C1', 'C5',))

C1U2new = session.xyDataObjects['U:U2 PI: %s N: %s' % ('TOW4-T', {CC1})][0][1] + {H}

C5U2new = session.xyDataObjects['U:U2 PI: %s N: %s' % ('TOW4-B', {CC5})][0][1] + 0
Dis = abs(C1U2new - C5U2new)

E33U2 = abs({H} - Dis)

for i in session.xyDataObjects.keys():
    del session.xyDataObjects['%s' % (i)]

session.odbData[odbName].setValues(activeFrames=(('Step-1', (-1,)),))
session.xyDataListFromField(odb=odb, outputPosition=NODAL, variable=(('U', NODAL, ((COMPONENT, 'U3'),)),),
                            nodeSets=('C1', 'C4',))

C1U3new = session.xyDataObjects['U:U3 PI: %s N: %s' % ('TOW4-T', {CC1})][0][1] + {W}

C4U3new = session.xyDataObjects['U:U3 PI: %s N: %s' % ('TOW4-T', {CC4})][0][1] + 0
Dis = abs(C1U3new - C4U3new)

E33U3 = abs({W} - Dis)

V31 = (E33U1 / {L}) / (E33U2 / {H})
V32 = (E33U3 / {W}) / (E33U2 / {H})
"""
    ## Elastic modulus E22 ##
    if E33 == False:
        script += """E33 = 'N/A'
V31 = 'N/A'
V32 = 'N/A'
"""

    if E22 == True:
        script += f"""for i in mdb.models['{fileE}'].loads.keys():
    del mdb.models['{fileE}'].loads[i]
for i in mdb.models['{fileE}'].boundaryConditions.keys():
    del mdb.models['{fileE}'].boundaryConditions[i]

region = a.sets['RP6']
mdb.models['{fileE}'].DisplacementBC(name='E22-1', createStepName='Step-1',
                                     region=region, u1=UNSET, u2=UNSET, u3={Dispz}, ur1=UNSET, ur2=UNSET, ur3=UNSET,
                                     amplitude=UNSET, fixed=OFF, distributionType=UNIFORM, fieldName='',
                                     localCsys=None)

regionDef = mdb.models['{fileE}'].rootAssembly.sets['C1']
mdb.models['{fileE}'].HistoryOutputRequest(name='H-Output-2',
                                           createStepName='Step-1', variables=('RT',), region=regionDef,
                                           sectionPoints=DEFAULT, rebar=EXCLUDE)

import os, glob

mdb.Job(name='Job-{fileE}-E22', model='{fileE}', description='', type=ANALYSIS,
        atTime=None, waitMinutes=0, waitHours=0, queue=None, memory=90,
        memoryUnits=PERCENTAGE, getMemoryFromAnalysis=True,
        explicitPrecision=SINGLE, nodalOutputPrecision=SINGLE, echoPrint=OFF,
        modelPrint=OFF, contactPrint=OFF, historyPrint=OFF, userSubroutine='',
        scratch='', multiprocessingMode=DEFAULT, numCpus={CPUs}, numDomains={CPUs}, numGPUs=0)
mdb.jobs['Job-{fileE}-E22'].submit(consistencyChecking=OFF)
mdb.jobs['Job-{fileE}-E22'].waitForCompletion()
o3 = session.openOdb(name='%s' % (path + '\Job-{fileE}-E22.odb'))

odb = session.odbs['%s' % (path + '\Job-{fileE}-E22.odb')]

session.viewports['Viewport: 1'].setValues(displayedObject=o3)
odbName = session.viewports[session.currentViewportName].odbDisplay.name

for i in session.xyDataObjects.keys():
    del session.xyDataObjects['%s' % (i)]

session.odbData[odbName].setValues(activeFrames=(('Step-1', (-1,)),))
session.xyDataListFromField(odb=odb, outputPosition=NODAL, variable=(('RF', NODAL, ((COMPONENT, 'RF3'),)),),
                            nodeSets=('RP6',))

forceE22 = 0
for i in session.xyDataObjects.keys():
    forceE22 = forceE22 + (session.xyDataObjects[i][0][1])

stressE22 = abs(forceE22 / ({H} * {L}))

E22 = stressE22 / ({Dispz} / {W})

for i in session.xyDataObjects.keys():
    del session.xyDataObjects['%s' % (i)]

session.odbData[odbName].setValues(activeFrames=(('Step-1', (-1,)),))
session.xyDataListFromField(odb=odb, outputPosition=NODAL, variable=(('U', NODAL, ((COMPONENT, 'U1'),)),),
                            nodeSets=('C1', 'C2',))

C1U1new = session.xyDataObjects['U:U1 PI: %s N: %s' % ('TOW4-T', {CC1})][0][1] + {L}

C2U1new = session.xyDataObjects['U:U1 PI: %s N: %s' % ('TOW1-T', {CC2})][0][1] + 0
Dis = abs(C1U1new - C2U1new)

E22U1 = abs({L} - Dis)

for i in session.xyDataObjects.keys():
    del session.xyDataObjects['%s' % (i)]

session.odbData[odbName].setValues(activeFrames=(('Step-1', (-1,)),))
session.xyDataListFromField(odb=odb, outputPosition=NODAL, variable=(('U', NODAL, ((COMPONENT, 'U2'),)),),
                            nodeSets=('C1', 'C5',))

C1U2new = session.xyDataObjects['U:U2 PI: %s N: %s' % ('TOW4-T', {CC1})][0][1] + {H}

C5U2new = session.xyDataObjects['U:U2 PI: %s N: %s' % ('TOW4-B', {CC5})][0][1] + 0
Dis = abs(C1U2new - C5U2new)

E22U2 = abs({H} - Dis)

for i in session.xyDataObjects.keys():
    del session.xyDataObjects['%s' % (i)]

session.odbData[odbName].setValues(activeFrames=(('Step-1', (-1,)),))
session.xyDataListFromField(odb=odb, outputPosition=NODAL, variable=(('U', NODAL, ((COMPONENT, 'U3'),)),),
                            nodeSets=('C1', 'C4',))

C1U3new = session.xyDataObjects['U:U3 PI: %s N: %s' % ('TOW4-T', {CC1})][0][1] + {W}

C4U3new = session.xyDataObjects['U:U3 PI: %s N: %s' % ('TOW4-T', {CC4})][0][1] + 0
Dis = abs(C1U3new - C4U3new)

E22U3 = abs({W} - Dis)

V21 = (E22U1 / {L}) / (E22U3 / {W})
V23 = (E22U2 / {H}) / (E22U3 / {W})
"""
    if E22 == False:
        script += """E22 = 'N/A'
V21 = 'N/A'
V23 = 'N/A'
"""

    if G12 == True or G12T == True or G13 == True or G23 == True:
        script += f"""mdb.ModelFromInputFile(inputFileName='{fileG1}', name='{fileG}')

# Create a static step.
mdb.models['{fileG}'].StaticStep(name='Step-1', previous='Initial', initialInc=0.1,  minInc=1e-10, maxNumInc=500, timePeriod=1)


a = mdb.models['{fileG}'].rootAssembly

"""

    ## Shear modulus G13 ##
    if G13 == True:
        script += f"""for i in mdb.models['{fileG}'].loads.keys():
    del mdb.models['{fileG}'].loads[i]
for i in mdb.models['{fileG}'].boundaryConditions.keys():
    del mdb.models['{fileG}'].boundaryConditions[i]

region = a.sets['RP4']
mdb.models['{fileG}'].DisplacementBC(name='G13-1', createStepName='Step-1',
                                     region=region, u1={Dispx}, u2={Dispy}, u3=UNSET, ur1=UNSET, ur2=UNSET,
                                     ur3=UNSET,
                                     amplitude=UNSET, fixed=OFF, distributionType=UNIFORM, fieldName='',
                                     localCsys=None)

region = a.sets['RP5']
mdb.models['{fileG}'].DisplacementBC(name='G13-2', createStepName='Step-1',
                                     region=region, u1=0, u2=0, u3=0, ur1=UNSET, ur2=UNSET, ur3=UNSET,
                                     amplitude=UNSET, fixed=OFF, distributionType=UNIFORM, fieldName='',
                                     localCsys=None)

region = a.sets['RP6']
mdb.models['{fileG}'].DisplacementBC(name='G13-3', createStepName='Step-1',
                                     region=region, u1=0, u2=0, u3=0, ur1=UNSET, ur2=UNSET, ur3=UNSET,
                                     amplitude=UNSET, fixed=OFF, distributionType=UNIFORM, fieldName='',
                                     localCsys=None)

regionDef = mdb.models['{fileG}'].rootAssembly.sets['C1']
mdb.models['{fileG}'].HistoryOutputRequest(name='H-Output-2',
                                           createStepName='Step-1', variables=('RT',), region=regionDef,
                                           sectionPoints=DEFAULT, rebar=EXCLUDE)

import os, glob

mdb.Job(name='Job-{fileG}-G13', model='{fileG}', description='', type=ANALYSIS,
        atTime=None, waitMinutes=0, waitHours=0, queue=None, memory=90,
        memoryUnits=PERCENTAGE, getMemoryFromAnalysis=True,
        explicitPrecision=SINGLE, nodalOutputPrecision=SINGLE, echoPrint=OFF,
        modelPrint=OFF, contactPrint=OFF, historyPrint=OFF, userSubroutine='',
        scratch='', multiprocessingMode=DEFAULT, numCpus={CPUs}, numDomains={CPUs}, numGPUs=0)
mdb.jobs['Job-{fileG}-G13'].submit(consistencyChecking=OFF)

mdb.jobs['Job-{fileG}-G13'].waitForCompletion()

o3 = session.openOdb(name='%s' % (path + '\Job-{fileG}-G13.odb'))

odb = session.odbs['%s' % (path + '\Job-{fileG}-G13.odb')]

session.viewports['Viewport: 1'].setValues(displayedObject=o3)
odbName = session.viewports[session.currentViewportName].odbDisplay.name

for i in session.xyDataObjects.keys():
    del session.xyDataObjects['%s' % (i)]

session.odbData[odbName].setValues(activeFrames=(('Step-1', (-1,)),))
session.xyDataListFromField(odb=odb, outputPosition=NODAL, variable=(('RF',
                                                                      NODAL, ((COMPONENT, 'RF1'),)),),
                            nodeSets=('RP4',))

forceG13 = 0
for i in session.xyDataObjects.keys():
    forceG13 = forceG13 + (session.xyDataObjects[i][0][1])

stressG13 = abs(forceG13 / ({L} * {W}))

G13 = stressG13 / (({Dispx} / {L}) + ({Dispy} / {H}))
"""

    ## Shear modulus G13 ##
    if G13 == False:
        script += "G13 = 'N/A' \n"

    if G12 == True:
        script += f"""for i in mdb.models['{fileG}'].loads.keys():
    del mdb.models['{fileG}'].loads[i]
for i in mdb.models['{fileG}'].boundaryConditions.keys():
    del mdb.models['{fileG}'].boundaryConditions[i]

region = a.sets['RP5']
mdb.models['{fileG}'].DisplacementBC(name='G12-1', createStepName='Step-1',
                                     region=region, u1={Dispx}, u2=UNSET, u3={Dispz}, ur1=UNSET, ur2=UNSET,
                                     ur3=UNSET,
                                     amplitude=UNSET, fixed=OFF, distributionType=UNIFORM, fieldName='',
                                     localCsys=None)

region = a.sets['RP4']
mdb.models['{fileG}'].DisplacementBC(name='G12-2', createStepName='Step-1',
                                     region=region, u1=0, u2=0, u3=0, ur1=UNSET, ur2=UNSET, ur3=UNSET,
                                     amplitude=UNSET, fixed=OFF, distributionType=UNIFORM, fieldName='',
                                     localCsys=None)

region = a.sets['RP6']
mdb.models['{fileG}'].DisplacementBC(name='G12-3', createStepName='Step-1',
                                     region=region, u1=0, u2=0, u3=0, ur1=UNSET, ur2=UNSET, ur3=UNSET,
                                     amplitude=UNSET, fixed=OFF, distributionType=UNIFORM, fieldName='',
                                     localCsys=None)

regionDef = mdb.models['{fileG}'].rootAssembly.sets['C1']
mdb.models['{fileG}'].HistoryOutputRequest(name='H-Output-2',
                                           createStepName='Step-1', variables=('RT',), region=regionDef,
                                           sectionPoints=DEFAULT, rebar=EXCLUDE)

import os, glob

mdb.Job(name='Job-{fileG}-G12', model='{fileG}', description='', type=ANALYSIS,
        atTime=None, waitMinutes=0, waitHours=0, queue=None, memory=90,
        memoryUnits=PERCENTAGE, getMemoryFromAnalysis=True,
        explicitPrecision=SINGLE, nodalOutputPrecision=SINGLE, echoPrint=OFF,
        modelPrint=OFF, contactPrint=OFF, historyPrint=OFF, userSubroutine='',
        scratch='', multiprocessingMode=DEFAULT, numCpus={CPUs}, numDomains={CPUs}, numGPUs=0)
mdb.jobs['Job-{fileG}-G12'].submit(consistencyChecking=OFF)

mdb.jobs['Job-{fileG}-G12'].waitForCompletion()

o3 = session.openOdb(name='%s' % (path + '\Job-{fileG}-G12.odb'))

odb = session.odbs['%s' % (path + '\Job-{fileG}-G12.odb')]

session.viewports['Viewport: 1'].setValues(displayedObject=o3)
odbName = session.viewports[session.currentViewportName].odbDisplay.name

for i in session.xyDataObjects.keys():
    del session.xyDataObjects['%s' % (i)]

session.odbData[odbName].setValues(activeFrames=(('Step-1', (-1,)),))
session.xyDataListFromField(odb=odb, outputPosition=NODAL, variable=(('RF',
                                                                      NODAL, ((COMPONENT, 'RF1'),)),),
                            nodeSets=('RP5',))

forceG12 = 0
for i in session.xyDataObjects.keys():
    forceG12 = forceG12 + (session.xyDataObjects[i][0][1])

stressG12 = abs(forceG12 / ({H} * {L}))

G12 = stressG12 / (({Dispx} / {L}) + ({Dispz} / {W}))
"""

    if G12 == False:
        script += "G12 = 'N/A' \n"

    if G12T == True:
        script += f"""for i in mdb.models['{fileG}'].loads.keys():
    del mdb.models['{fileG}'].loads[i]
for i in mdb.models['{fileG}'].boundaryConditions.keys():
    del mdb.models['{fileG}'].boundaryConditions[i]

region = a.sets['RP5']
mdb.models['{fileG}'].DisplacementBC(name='G12T-1', createStepName='Step-1',
                                     region=region, u1={Dispx}, u2=UNSET, u3={Dispz}, ur1=UNSET, ur2=UNSET,
                                     ur3=UNSET,
                                     amplitude=UNSET, fixed=OFF, distributionType=UNIFORM, fieldName='',
                                     localCsys=None)

region = a.sets['RP4']
mdb.models['{fileG}'].DisplacementBC(name='G12T-2', createStepName='Step-1',
                                     region=region, u1=0, u2=0, u3=0, ur1=UNSET, ur2=UNSET, ur3=UNSET,
                                     amplitude=UNSET, fixed=OFF, distributionType=UNIFORM, fieldName='',
                                     localCsys=None)

region = a.sets['RP6']
mdb.models['{fileG}'].DisplacementBC(name='G12T-3', createStepName='Step-1',
                                     region=region, u1=0, u2=0, u3=0, ur1=UNSET, ur2=UNSET, ur3=UNSET,
                                     amplitude=UNSET, fixed=OFF, distributionType=UNIFORM, fieldName='',
                                     localCsys=None)

regionDef = mdb.models['{fileG}'].rootAssembly.sets['C1']
mdb.models['{fileG}'].HistoryOutputRequest(name='H-Output-2',
                                           createStepName='Step-1', variables=('RT',), region=regionDef,
                                           sectionPoints=DEFAULT, rebar=EXCLUDE)

import os, glob

mdb.Job(name='Job-{fileG}-G12T', model='{fileG}', description='', type=ANALYSIS,
        atTime=None, waitMinutes=0, waitHours=0, queue=None, memory=90,
        memoryUnits=PERCENTAGE, getMemoryFromAnalysis=True,
        explicitPrecision=SINGLE, nodalOutputPrecision=SINGLE, echoPrint=OFF,
        modelPrint=OFF, contactPrint=OFF, historyPrint=OFF, userSubroutine='',
        scratch='', multiprocessingMode=DEFAULT, numCpus={CPUs}, numDomains={CPUs}, numGPUs=0)
mdb.jobs['Job-{fileG}-G12T'].submit(consistencyChecking=OFF)

mdb.jobs['Job-{fileG}-G12T'].waitForCompletion()

o3 = session.openOdb(name='%s' % (path + '\Job-{fileG}-G12T.odb'))

odb = session.odbs['%s' % (path + '\Job-{fileG}-G12T.odb')]

session.viewports['Viewport: 1'].setValues(displayedObject=o3)
odbName = session.viewports[session.currentViewportName].odbDisplay.name

for i in session.xyDataObjects.keys():
    del session.xyDataObjects['%s' % (i)]

session.odbData[odbName].setValues(activeFrames=(('Step-1', (-1,)),))
session.xyDataListFromField(odb=odb, outputPosition=NODAL, variable=(('RF',
                                                                      NODAL, ((COMPONENT, 'RF3'),)),),
                            nodeSets=('RP5',))

forceG12T = 0
for i in session.xyDataObjects.keys():
    forceG12T = forceG12T + (session.xyDataObjects[i][0][1])

stressG12T = abs(forceG12T / ({H} * {L}))

G12T = stressG12T / (({Dispx} / {L}) + ({Dispz} / {W}))
"""

    if G12T == False:
        script += "G12T = 'N/A' \n"

    ## Shear modulus G23 ##
    if G23 == True:
        script += f"""for i in mdb.models['{fileG}'].loads.keys():
    del mdb.models['{fileG}'].loads[i]
for i in mdb.models['{fileG}'].boundaryConditions.keys():
    del mdb.models['{fileG}'].boundaryConditions[i]

region = a.sets['RP6']
mdb.models['{fileG}'].DisplacementBC(name='G23-1', createStepName='Step-1',
                                     region=region, u1=UNSET, u2={Dispy}, u3={Dispz}, ur1=UNSET, ur2=UNSET,
                                     ur3=UNSET,
                                     amplitude=UNSET, fixed=OFF, distributionType=UNIFORM, fieldName='',
                                     localCsys=None)

region = a.sets['RP4']
mdb.models['{fileG}'].DisplacementBC(name='G23-2', createStepName='Step-1',
                                     region=region, u1=0, u2=0, u3=0, ur1=UNSET, ur2=UNSET, ur3=UNSET,
                                     amplitude=UNSET, fixed=OFF, distributionType=UNIFORM, fieldName='',
                                     localCsys=None)

region = a.sets['RP5']
mdb.models['{fileG}'].DisplacementBC(name='G23-3', createStepName='Step-1',
                                     region=region, u1=0, u2=0, u3=0, ur1=UNSET, ur2=UNSET, ur3=UNSET,
                                     amplitude=UNSET, fixed=OFF, distributionType=UNIFORM, fieldName='',
                                     localCsys=None)

regionDef = mdb.models['{fileG}'].rootAssembly.sets['C1']
mdb.models['{fileG}'].HistoryOutputRequest(name='H-Output-2',
                                           createStepName='Step-1', variables=('RT',), region=regionDef,
                                           sectionPoints=DEFAULT, rebar=EXCLUDE)

import os, glob

mdb.Job(name='Job-{fileG}-G23', model='{fileG}', description='', type=ANALYSIS,
        atTime=None, waitMinutes=0, waitHours=0, queue=None, memory=90,
        memoryUnits=PERCENTAGE, getMemoryFromAnalysis=True,
        explicitPrecision=SINGLE, nodalOutputPrecision=SINGLE, echoPrint=OFF,
        modelPrint=OFF, contactPrint=OFF, historyPrint=OFF, userSubroutine='',
        scratch='', multiprocessingMode=DEFAULT, numCpus={CPUs}, numDomains={CPUs}, numGPUs=0)
mdb.jobs['Job-{fileG}-G23'].submit(consistencyChecking=OFF)

mdb.jobs['Job-{fileG}-G23'].waitForCompletion()

o3 = session.openOdb(name='%s' % (path + '\Job-{fileG}-G23.odb'))

odb = session.odbs['%s' % (path + '\Job-{fileG}-G23.odb')]

session.viewports['Viewport: 1'].setValues(displayedObject=o3)
odbName = session.viewports[session.currentViewportName].odbDisplay.name

for i in session.xyDataObjects.keys():
    del session.xyDataObjects['%s' % (i)]

session.odbData[odbName].setValues(activeFrames=(('Step-1', (-1,)),))
session.xyDataListFromField(odb=odb, outputPosition=NODAL, variable=(('RF',
    NODAL, ((COMPONENT, 'RF2'),)),), nodeSets=('RP6',))

forceG23 = 0
for i in session.xyDataObjects.keys():
    forceG23 = forceG23 + (session.xyDataObjects[i][0][1])

stressG23 = abs(forceG23 / ({L} * {H}))

G23 = stressG23 / (({Dispy} / {H}) + ({Dispz} / {W}))
"""

    if G23 == False:
        script += "G23 = 'N/A' \n"

    script += f"""print ('----------------------------------------------------')
print ('----------------------------------------------------')
print ('The homogenised elastic properties:')
print ('E11=%s Stress units' % (E11))
print ('V12=%s ratio' % (V12))
print ('V13=%s ratio' % (V13))
print ('E22=%s Stress units' % (E22))
print ('V21=%s ratio' % (V21))
print ('V23=%s ratio' % (V23))
print ('E33=%s Stress units' % (E33))
print ('V31=%s ratio' % (V31))
print ('V32=%s ratio' % (V32))
print ('G12=%s Stress units' % (G12))
print ('G12T=%s Stress units' % (G12T))
print ('G13=%s Stress units' % (G13))
print ('G23=%s Stress units' % (G23))
print('----------------------------------------------------')
print('Processing duration %s seconds' % (time.time() - start))
print('----------------------------------------------------')

filename = ('{filename}_elastic_properties.txt')
print('The homogenised elastic properties are saved in ABAQUS Work Directory under %s' % filename)
f = open(filename, 'w')
"""
    script += """f.write('{0:^10}{1:^20}{2:^20}'.format('Property','Value','Unit'))
f.write('                                                                                      ')
f.write('{0:^10}{1:^20}{2:^20}'.format('E11',E11,'Stress units'))
f.write('                                                                                      ')
f.write('{0:^10}{1:^20}{2:^20}'.format('V12',V12,'ratio'))
f.write('                                                                                      ')
f.write('{0:^10}{1:^20}{2:^20}'.format('V13',V13,'ratio'))
f.write('                                                                                      ')
f.write('{0:^10}{1:^20}{2:^20}'.format('E22',E22,'Stress units'))
f.write('                                                                                      ')
f.write('{0:^10}{1:^20}{2:^20}'.format('V21',V21,'ratio'))
f.write('                                                                                      ')
f.write('{0:^10}{1:^20}{2:^20}'.format('V23',V23,'ratio'))
f.write('                                                                                      ')
f.write('{0:^10}{1:^20}{2:^20}'.format('E33',E33,'Stress units'))
f.write('                                                                                      ')
f.write('{0:^10}{1:^20}{2:^20}'.format('V31',V31,'ratio'))
f.write('                                                                                      ')
f.write('{0:^10}{1:^20}{2:^20}'.format('V32',V32,'ratio'))
f.write('                                                                                      ')
f.write('{0:^10}{1:^20}{2:^20}'.format('G12',G12,'Stress units'))
f.write('                                                                                      ')
f.write('{0:^10}{1:^20}{2:^20}'.format('G12T',G12T,'Stress units'))
f.write('                                                                                      ')
f.write('{0:^10}{1:^20}{2:^20}'.format('G13',G13,'Stress units'))
f.write('                                                                                      ')
f.write('{0:^10}{1:^20}{2:^20}'.format('G23',G23,'Stress units'))
f.write('                                                                                      ')

f.write('processing duration %s Seconds' % (time.time() - start))

f.close()
"""
    return script