import numpy as np


def topbot(towset, dir_x, dir_z, set, altset, setno, setdof):
    count = 0
    bc_topbot = ""
    rve_topbot = ""
    mat_one = np.arange(1, dir_z * dir_z + 1).reshape(dir_z, dir_z)
    trans_one = np.transpose(mat_one)

    mat_two = np.arange(dir_z * dir_z - dir_z + 1, (dir_z * (2*dir_z-1)+1)).reshape(dir_z, dir_z)
    trans_two = np.transpose(mat_two)

    mat_three = np.arange(dir_z * (2*dir_z-1) - dir_z + 1, (dir_z * (3*dir_z-2)+1)).reshape(dir_z, dir_z)
    trans_three = np.transpose(mat_three)

    mat_four = np.arange(dir_z * (3*dir_z-2) - dir_z + 1, (dir_z * (4*dir_z-3)+1)).reshape(dir_z, dir_z)
    trans_four = np.transpose(mat_four)


    for i in towset:
        if i == "1-t" or i == "2-t" or i == "3-t" or i == "4-t":
            bc_topbot += f"""*Nset, nset=topbc, instance=Tow{i}, generate
1,  {dir_x * dir_z},  1
"""
            for j in range(dir_x * dir_z):
                bc_topbot += f"""*Nset, nset=S{i}-{j + 1}, instance=Tow{i}
 {j + 1},
"""
                arg2 = (j + 1) % dir_z != 0 and j % dir_z != 0
                if i == "1-t":
                    matrix = trans_one

                elif i == "2-t":
                    matrix = trans_two

                if i == "3-t":
                    matrix = trans_three

                elif i == "4-t":
                    matrix = trans_four

                if dir_z < j < dir_z * (dir_z -1) and arg2:
                    for a in range(3):
                        rve_topbot += f"""** Constraint: topbot{i}-{j}-{a}
*Equation
{setno[a]}
S{i}-{j + 1}, {setdof[a]}, 1.
S1-b-{matrix.item(j)}, {setdof[a]}, -1.{set[a]}
"""

                elif dir_z * dir_z < j < dir_z * (dir_z*2-1) - dir_z and arg2:
                    for a in range(3):
                        rve_topbot += f"""** Constraint: topbot{i}-{j}-{a}
*Equation
{setno[a]}
S{i}-{j + 1}, {setdof[a]}, 1.
S2-b-{matrix.item(j - dir_z * dir_z + dir_z)}, {setdof[a]}, -1.{set[a]}
"""
                elif dir_z * (dir_z * 2 - 1) < j < dir_z * (dir_z * 3 - 2) - dir_z and arg2:
                    for a in range(3):
                        rve_topbot += f"""** Constraint: topbot{i}-{j}-{a}
*Equation
{setno[a]}
S{i}-{j + 1}, {setdof[a]}, 1.
S3-b-{matrix.item(j - dir_z * (2* dir_z -1) + dir_z)}, {setdof[a]}, -1.{set[a]}
"""

                elif dir_z * (dir_z * 3 - 1) - dir_z < j < dir_z * (dir_z * 4 - 3) - dir_z and arg2:
                    for a in range(3):
                        rve_topbot += f"""** Constraint: topbot{i}-{j}-{a}
*Equation
{setno[a]}
S{i}-{j + 1}, {setdof[a]}, 1.
S4-b-{matrix.item(j - (dir_z * (dir_z * 3 - 1) - dir_z) + dir_z)}, {setdof[a]}, -1.{set[a]}
"""

        elif i == "1-b" or i == "2-b" or i == "3-b" or i == "4-b":
            bc_topbot += f"""*Nset, nset=botbc, instance=Tow{i}, generate
1,  {dir_x * dir_z},  1
"""
            for j in range(dir_x * dir_z):
                bc_topbot += f"""*Nset, nset=S{i}-{j + 1}, instance=Tow{i}
 {j + 1},
"""


    return bc_topbot, rve_topbot


def rightleft(dir_x, dir_y, dir_z, set, altset, setno, setdof):
    bc_rightleft = ""
    rve_rightleft = ""

    arg0 = range(0, dir_z)
    arg1 = range(0, dir_z)
    arg2 = range(1, dir_z)
    arg3 = range(0, dir_z - 1)

    for k in range(1, dir_y):
        for j in arg0:
            bc_rightleft += f"""*Nset, nset=S1-t-{j + 1}-{k}, instance=Tow1-t
{k * dir_x * dir_z + j + 1},
*Nset, nset=S1-t-{j + 1}-{k}_2, instance=Tow1-t
{k * dir_x * dir_z + j + 1 + (dir_x - 1) * dir_z},

*Nset, nset=S2-t-{j + 1}-{k}, instance=Tow2-t
{k * dir_x * dir_z + j + 1},
*Nset, nset=S2-t-{j + 1}-{k}_2, instance=Tow2-t
{k * dir_x * dir_z + j + 1 + (dir_x - 1) * dir_z},

*Nset, nset=S3-t-{j + 1}-{k}, instance=Tow3-t
{k * dir_x * dir_z + j + 1},
*Nset, nset=S3-t-{j + 1}-{k}_2, instance=Tow3-t
{k * dir_x * dir_z + j + 1 + (dir_x - 1) * dir_z},

*Nset, nset=S4-t-{j + 1}-{k}, instance=Tow4-t
{k * dir_x * dir_z + j + 1},
*Nset, nset=S4-t-{j + 1}-{k}_2, instance=Tow4-t
{k * dir_x * dir_z + j + 1 + (dir_x - 1) * dir_z},
"""

        for a in range(3):
            for j in arg1:
                rve_rightleft += f"""** Constraint: rightleft2-t-{j}-{a}
*Equation
{setno[a]}
S2-t-{j + 1}-{k}_2, {setdof[a]}, 1.
S2-t-{j + 1}-{k}, {setdof[a]}, -1.{set[a]}
** Constraint: rightleft3-t-{j}-{a}
*Equation
{setno[a]}
S3-t-{j + 1}-{k}_2, {setdof[a]}, 1.
S3-t-{j + 1}-{k}, {setdof[a]}, -1.{set[a]}
"""

            for j in arg2:
                rve_rightleft += f"""** Constraint: rightleft1-t-{j}-{a}
*Equation
{setno[a]}
S1-t-{j + 1}-{k}_2, {setdof[a]}, 1.
S1-t-{j + 1}-{k}, {setdof[a]}, -1.{set[a]}
"""

            for j in arg3:
                rve_rightleft += f"""** Constraint: rightleft4-t-{j}-{a}
*Equation
{setno[a]}
S4-t-{j + 1}-{k}_2, {setdof[a]}, 1.
S4-t-{j + 1}-{k}, {setdof[a]}, -1.{set[a]}
"""
    for l in range(1, dir_x - 1):
        for m in range(1, dir_y):
            bc_rightleft += f"""*Nset, nset=S1-b-{l}-{m}1, instance=Tow1-b
    {l * dir_z + 1 + m * dir_x * dir_z},
    *Nset, nset=S4-b-{l}-{m}1, instance=Tow4-b
    {l * dir_z + dir_z + m * dir_x * dir_z},
    """
            for a in range(3):
                rve_rightleft += f"""** Constraint: leftright{l}-{m}-{a}
*Equation
{setno[a]}
S4-b-{l}-{m}1, {setdof[a]}, 1.
S1-b-{l}-{m}1, {setdof[a]}, -1.{set[a]}
"""

    return bc_rightleft, rve_rightleft


def frontback(dir_x, dir_y, dir_z, set, altset, setno, setdof):
    bc_frontback = ""
    rve_frontback = ""

    arg0 = range(0, dir_z)
    arg1 = range(0, dir_z)
    arg2 = range(1, dir_z)
    arg3 = range(0, dir_z - 1)

    for k in range(1, dir_y):
        for j in arg0:
            bc_frontback += f"""*Nset, nset=S1-b-{j + 1}-{k}, instance=Tow1-b
    {k * dir_x * dir_z + j + 1},
    *Nset, nset=S1-b-{j + 1}-{k}_2, instance=Tow1-b
    {k * dir_x * dir_z + j + 1 + (dir_x - 1) * dir_z},

    *Nset, nset=S2-b-{j + 1}-{k}, instance=Tow2-b
    {k * dir_x * dir_z + j + 1},
    *Nset, nset=S2-b-{j + 1}-{k}_2, instance=Tow2-b
    {k * dir_x * dir_z + j + 1 + (dir_x - 1) * dir_z},

    *Nset, nset=S3-b-{j + 1}-{k}, instance=Tow3-b
    {k * dir_x * dir_z + j + 1},
    *Nset, nset=S3-b-{j + 1}-{k}_2, instance=Tow3-b
    {k * dir_x * dir_z + j + 1 + (dir_x - 1) * dir_z},

    *Nset, nset=S4-b-{j + 1}-{k}, instance=Tow4-b
    {k * dir_x * dir_z + j + 1},
    *Nset, nset=S4-b-{j + 1}-{k}_2, instance=Tow4-b
    {k * dir_x * dir_z + j + 1 + (dir_x - 1) * dir_z},
    """

        for a in range(3):
            for j in arg1:
                rve_frontback += f"""** Constraint: frontback2-b-{j}-{a}
*Equation
{setno[a]}
S2-b-{j + 1}-{k}_2, {setdof[a]}, 1.
S2-b-{j + 1}-{k}, {setdof[a]}, -1.{set[a]}
** Constraint: frontback3-b-{j}-{a}
*Equation
{setno[a]}
S3-b-{j + 1}-{k}_2, {setdof[a]}, 1.
S3-b-{j + 1}-{k}, {setdof[a]}, -1.{set[a]}
"""

            for j in arg2:
                rve_frontback += f"""** Constraint: frontback1-b-{j}-{a}
*Equation
{setno[a]}
S1-b-{j + 1}-{k}_2, {setdof[a]}, 1.
S1-b-{j + 1}-{k}, {setdof[a]}, -1.{set[a]}
"""
            for j in arg3:
                rve_frontback += f"""** Constraint: frontback4-b-{j}-{a}
*Equation
{setno[a]}
S4-b-{j + 1}-{k}_2, {setdof[a]}, 1.
S4-b-{j + 1}-{k}, {setdof[a]}, -1.{set[a]}
"""

    for l in range(1, dir_x - 1):
        for m in range(1, dir_y):
            bc_frontback += f"""*Nset, nset=S1-t-{l}-{m}1, instance=Tow1-t
 {l * dir_z + 1 + m * dir_x * dir_z},
*Nset, nset=S4-t-{l}-{m}1, instance=Tow4-t
 {l * dir_z + dir_z + m * dir_x * dir_z},
"""
            for a in range(3):
                rve_frontback += f"""** Constraint: frontback{l}-{m}-{a}
*Equation
{setno[a]}
S4-t-{l}-{m}1, {setdof[a]}, 1.
S1-t-{l}-{m}1, {setdof[a]}, -1.{set[a]}
"""

    return bc_frontback, rve_frontback


def edges1(dir_x, dir_y, dir_z, set, altset, setno, setdof):
    bc_edges1 = ""
    rve_edges1 = ""

    for l in range(2, dir_z):
        bc_edges1 += f"""*Nset, nset=S1-b-{l}-bbedge, instance=Tow1-b
{l},
*Nset, nset=S2-b-{l}-bbedge, instance=Tow2-b
{l},
*Nset, nset=S3-b-{l}-bbedge, instance=Tow3-b
{l},
*Nset, nset=S4-b-{l}-bbedge, instance=Tow4-b
{l},
*Nset, nset=S1-b-{l}-fbedge, instance=Tow1-b
{l+(dir_x-1)*dir_z},
*Nset, nset=S2-b-{l}-fbedge, instance=Tow2-b
{l+(dir_x-1)*dir_z},
*Nset, nset=S3-b-{l}-fbedge, instance=Tow3-b
{l+(dir_x-1)*dir_z},
*Nset, nset=S4-b-{l}-fbedge, instance=Tow4-b
{l+(dir_x-1)*dir_z},
*Nset, nset=S1-t-{l}-btedge, instance=Tow1-t
{(l-1) * dir_z + 1},
*Nset, nset=S1-t-{l}-btedge2, instance=Tow1-t
{(l+dir_z-2) * dir_z + 1},
*Nset, nset=S1-t-{l}-btedge3, instance=Tow1-t
{(l+2*dir_z-3) * dir_z + 1},
*Nset, nset=S1-t-{l}-btedge4, instance=Tow1-t
{(l+3*dir_z-4) * dir_z + 1},
*Nset, nset=S4-t-{l}-ftedge, instance=Tow4-t
{(l) * dir_z},
*Nset, nset=S4-t-{l}-ftedge2, instance=Tow4-t
{(l+dir_z-1) * dir_z},
*Nset, nset=S4-t-{l}-ftedge3, instance=Tow4-t
{(l+2*dir_z-2) * dir_z},
*Nset, nset=S4-t-{l}-ftedge4, instance=Tow4-t
{(l+3*dir_z-3) * dir_z},
"""
        for a in range(3):
            rve_edges1 += f"""** Constraint: bb-fbedge{l}-{a}
*Equation
{setno[a]}
S1-b-{l}-bbedge, {setdof[a]}, 1.
S1-b-{l}-fbedge, {setdof[a]}, -1.{altset[a]}
** Constraint: bb-fbedge2{l}-{a}
*Equation
{setno[a]}
S2-b-{l}-bbedge, {setdof[a]}, 1.
S2-b-{l}-fbedge, {setdof[a]}, -1.{altset[a]}
** Constraint: bb-fbedge3{l}-{a}
*Equation
{setno[a]}
S3-b-{l}-bbedge, {setdof[a]}, 1.
S3-b-{l}-fbedge, {setdof[a]}, -1.{altset[a]}
** Constraint: bb-fbedge4{l}-{a}
*Equation
{setno[a]}
S4-b-{l}-bbedge, {setdof[a]}, 1.
S4-b-{l}-fbedge, {setdof[a]}, -1.{altset[a]}
** Constraint: ft-btedge{l}-{a}
*Equation
{setno[a]}
S4-t-{l}-ftedge, {setdof[a]}, 1.
S1-t-{l}-btedge, {setdof[a]}, -1.{set[a]}
** Constraint: ft-btedge{l}2-{a}
*Equation
{setno[a]}
S4-t-{l}-ftedge2, {setdof[a]}, 1.
S1-t-{l}-btedge2, {setdof[a]}, -1.{set[a]}
** Constraint: ft-btedge{l}3-{a}
*Equation
{setno[a]}
S4-t-{l}-ftedge3, {setdof[a]}, 1.
S1-t-{l}-btedge3, {setdof[a]}, -1.{set[a]}
** Constraint: ft-btedge{l}4-{a}
*Equation
{setno[a]}
S4-t-{l}-ftedge4, {setdof[a]}, 1.
S1-t-{l}-btedge4, {setdof[a]}, -1.{set[a]}
"""

    bc_edges1 += f"""*Nset, nset=b-m-bbedge1, instance=Tow1-b
{dir_z},
*Nset, nset=b-m-bbedge4, instance=Tow4-b
1,
*Nset, nset=b-m-l-bbedge2, instance=Tow2-b
{dir_z},
*Nset, nset=b-m-r-bbedge2, instance=Tow2-b
1,
*Nset, nset=b-m-l-bbedge3, instance=Tow3-b
{dir_z},
*Nset, nset=b-m-r-bbedge3, instance=Tow3-b
1,
*Nset, nset=b-m-bbedge
b-m-bbedge1, b-m-bbedge4,
*Nset, nset=b-m-fbedge1, instance=Tow1-b
{dir_z + (dir_x - 1) * dir_z},
*Nset, nset=b-m-fbedge4, instance=Tow4-b
{1 + (dir_x - 1) * dir_z},
*Nset, nset=b-m-l-fbedge2, instance=Tow2-b
{dir_z + (dir_x - 1) * dir_z},
*Nset, nset=b-m-r-fbedge2, instance=Tow2-b
{1 + (dir_x - 1) * dir_z},
*Nset, nset=b-m-l-fbedge3, instance=Tow3-b
{dir_z + (dir_x - 1) * dir_z},
*Nset, nset=b-m-r-fbedge3, instance=Tow3-b
{1 + (dir_x - 1) * dir_z},
*Nset, nset=S1-t-m-btedge, instance=Tow1-t
{(dir_z-1)*dir_z + 1},
*Nset, nset=S1-t-m-btedge2, instance=Tow1-t
{(2*dir_z-2)*dir_z + 1},
*Nset, nset=S1-t-m-btedge3, instance=Tow1-t
{(3*dir_z-3)*dir_z + 1},
*Nset, nset=S4-t-m-ftedge, instance=Tow4-t
{dir_z*dir_z},
*Nset, nset=S4-t-m-ftedge2, instance=Tow4-t
{(2*dir_z-1)*dir_z},
*Nset, nset=S4-t-m-ftedge3, instance=Tow4-t
{(3*dir_z-2)*dir_z},
"""
    for a in range(3):
        rve_edges1 += f"""** Constraint: bb-fbedgee1-{a}
*Equation
{setno[a]}
b-m-fbedge1, {setdof[a]}, 1.
b-m-bbedge1, {setdof[a]}, -1.{set[a]}
** Constraint: bb-fbedgee2r-{a}
*Equation
{setno[a]}
b-m-r-fbedge2, {setdof[a]}, 1.
b-m-r-bbedge2, {setdof[a]}, -1.{set[a]}
** Constraint: bb-fbedgee2l-{a}
*Equation
{setno[a]}
b-m-l-fbedge2, {setdof[a]}, 1.
b-m-l-bbedge2, {setdof[a]}, -1.{set[a]}
** Constraint: bb-fbedgee3r-{a}
*Equation
{setno[a]}
b-m-r-fbedge3, {setdof[a]}, 1.
b-m-r-bbedge3, {setdof[a]}, -1.{set[a]}
** Constraint: bb-fbedgee3l-{a}
*Equation
{setno[a]}
b-m-l-fbedge3, {setdof[a]}, 1.
b-m-l-bbedge3, {setdof[a]}, -1.{set[a]}
** Constraint: bb-fbedgee2-{a}
*Equation
{setno[a]}
b-m-fbedge4, {setdof[a]}, 1.
b-m-bbedge4, {setdof[a]}, -1.{set[a]}
** Constraint: bt-ftedgem-{a}
*Equation
{setno[a]}
S4-t-m-ftedge, {setdof[a]}, 1.
S1-t-m-btedge, {setdof[a]}, -1.{set[a]}
** Constraint: bt-ftedgem2-{a}
*Equation
{setno[a]}
S4-t-m-ftedge2, {setdof[a]}, 1.
S1-t-m-btedge2, {setdof[a]}, -1.{set[a]}
** Constraint: bt-ftedgem3-{a}
*Equation
{setno[a]}
S4-t-m-ftedge3, {setdof[a]}, 1.
S1-t-m-btedge3, {setdof[a]}, -1.{set[a]}
"""

    for j in range(1, dir_y-1):
        bc_edges1 += f"""*Nset, nset=S1-b-{j}fr, instance=Tow1-b
{j*dir_x*dir_z+(dir_x-1)*dir_z+1},
*Nset, nset=S1-b-{j}br, instance=Tow1-b
{1+j*(dir_x*dir_z)},
*Nset, nset=S4-b-{j}fl, instance=Tow4-b
{j*dir_x*dir_z+(dir_x-1)*dir_z+dir_z},
*Nset, nset=S4-b-{j}bl, instance=Tow4-b
{dir_z+j*(dir_x*dir_z)},
*Nset, nset=S4-t-{j}fr, instance=Tow4-t
{dir_z+j*(dir_x*dir_z)},
*Nset, nset=S1-t-{j}br, instance=Tow1-t
{1+j*(dir_x*dir_z)},
*Nset, nset=S4-t-{j}fl, instance=Tow4-t
{j*dir_x*dir_z+(dir_x-1)*dir_z+dir_z},
*Nset, nset=S1-t-{j}bl, instance=Tow1-t
{j*dir_x*dir_z+(dir_x-1)*dir_z+1},
"""
        for a in range(3):
            rve_edges1 += f"""** Constraint: fr-bredge{j}-{a}
*Equation
{setno[a]}
S1-b-{j}br, {setdof[a]}, 1.
S1-b-{j}fr, {setdof[a]}, -1.{altset[a]}
** Constraint: fr-bredge1{j}-{a}
*Equation
{setno[a]}
S1-t-{j}br, {setdof[a]}, 1.
S4-t-{j}fr, {setdof[a]}, -1.{altset[a]}
** Constraint: fl-bledge{j}-{a}
*Equation
{setno[a]}
S4-b-{j}fl, {setdof[a]}, 1.
S4-b-{j}bl, {setdof[a]}, -1.{set[a]}
** Constraint: fl-bledge{j}-{a}
*Equation
{setno[a]}
S4-t-{j}fl, {setdof[a]}, 1.
S1-t-{j}bl, {setdof[a]}, -1.{set[a]}
"""

    bc_edges1 += f"""*Nset, nset=S1-b-fr, instance=Tow1-b
{(dir_y-1)*dir_x*dir_z+(dir_x-1)*dir_z+1},
*Nset, nset=S1-b-br, instance=Tow1-b
{1+(dir_y-1)*(dir_x*dir_z)},
*Nset, nset=S4-b-fl, instance=Tow4-b
{(dir_y-1)*dir_x*dir_z+(dir_x-1)*dir_z+dir_z},
*Nset, nset=S4-b-bl, instance=Tow4-b
{dir_z+(dir_y-1)*(dir_x*dir_z)},
*Nset, nset=S4-t-fr, instance=Tow4-t
{dir_z + (dir_y-1) * (dir_x * dir_z)},
*Nset, nset=S1-t-br, instance=Tow1-t
{1 + (dir_y-1) * (dir_x * dir_z)},
*Nset, nset=S4-t-fl, instance=Tow4-t
{(dir_y-1) * dir_x * dir_z + (dir_x - 1) * dir_z + dir_z},
*Nset, nset=S1-t-bl, instance=Tow1-t
{(dir_y-1) * dir_x * dir_z + (dir_x - 1) * dir_z + 1},
"""
    for a in range(3):
        rve_edges1 += f"""** Constraint: fr-bredge-{a}
*Equation
{setno[a]}
S1-b-br, {setdof[a]}, 1.
S1-b-fr, {setdof[a]}, -1.{altset[a]}
** Constraint: fr-bredge1-{a}
*Equation
{setno[a]}
S1-t-br, {setdof[a]}, 1.
S4-t-fr, {setdof[a]}, -1.{altset[a]}
** Constraint: fl-bledge-{a}
*Equation
{setno[a]}
S4-t-fl, {setdof[a]}, 1.
S1-t-bl, {setdof[a]}, -1.{set[a]}
** Constraint: fl-bledge-{a}
*Equation
{setno[a]}
S4-b-fl, {setdof[a]}, 1.
S4-b-bl, {setdof[a]}, -1.{set[a]}
"""

    bc_edges1 += f"""*Nset, nset=C1, instance=Tow4-t
{dir_x*dir_z},
*Nset, nset=C2, instance=Tow1-t
{(dir_x-1)*dir_z+1},
*Nset, nset=C3, instance=Tow1-t
{1},
*Nset, nset=C4, instance=Tow4-t
{dir_z},
*Nset, nset=C5, instance=Tow4-b
{dir_x*dir_z},
*Nset, nset=C6, instance=Tow4-b
{dir_z},
*Nset, nset=C7, instance=Tow1-b
{1},
*Nset, nset=C8, instance=Tow1-b
{(dir_x-1)*dir_z+1},
"""
    for a in range(3):
        rve_edges1 += f"""** Constraint: C4-C3-{a}
*Equation
{setno[a]}
C3, {setdof[a]}, 1.
C4, {setdof[a]}, -1.{altset[a]}
"""

    return bc_edges1, rve_edges1


def edges2(dir_x, dir_z, set, altset, setno, setdof):
    bc_edges2 = ""
    rve_edges2 = ""

    for l in range(2, dir_z):
        for a in range(3):
            rve_edges2 += f"""** Constraint: bt-bbedge{l}-{a}
*Equation
{setno[a]}
S1-t-{l}-btedge, {setdof[a]}, 1.
S1-b-{l}-bbedge, {setdof[a]}, -1.{set[a]}
** Constraint: bt-bbedge2{l}-{a}
*Equation
{setno[a]}
S1-t-{l}-btedge2, {setdof[a]}, 1.
S2-b-{l}-bbedge, {setdof[a]}, -1.{set[a]}
** Constraint: bt-bbedge3{l}-{a}
*Equation
{setno[a]}
S1-t-{l}-btedge3, {setdof[a]}, 1.
S3-b-{l}-bbedge, {setdof[a]}, -1.{set[a]}
** Constraint: bt-bbedge4{l}-{a}
*Equation
{setno[a]}
S1-t-{l}-btedge4, {setdof[a]}, 1.
S4-b-{l}-bbedge, {setdof[a]}, -1.{set[a]}
"""

    for l in range(dir_x):
        if 1 < l < dir_z:
            bc_edges2 += f"""*Nset, nset=S1-t-{l}-ltedge, instance=Tow1-t
{(dir_x-1)*dir_z+l},
*Nset, nset=S2-t-{l}-ltedge, instance=Tow2-t
{(dir_x-1)*dir_z+l},
*Nset, nset=S3-t-{l}-ltedge, instance=Tow3-t
{(dir_x-1)*dir_z+l},
*Nset, nset=S4-t-{l}-ltedge, instance=Tow4-t
{(dir_x-1)*dir_z+l},
*Nset, nset=S1-t-{l}-rtedge, instance=Tow1-t
{l},
*Nset, nset=S2-t-{l}-rtedge, instance=Tow2-t
{l},
*Nset, nset=S3-t-{l}-rtedge, instance=Tow3-t
{l},
*Nset, nset=S4-t-{l}-rtedge, instance=Tow4-t
{l},
*Nset, nset=S4-b-{l}-lbedge, instance=Tow4-b
{(l-1)*dir_z+dir_z}
*Nset, nset=S4-b-{l}-lbedge2, instance=Tow4-b
{(l-2+dir_z)*dir_z+dir_z}
*Nset, nset=S4-b-{l}-lbedge3, instance=Tow4-b
{(l-3+2*dir_z)*dir_z+dir_z}
*Nset, nset=S4-b-{l}-lbedge4, instance=Tow4-b
{(l-4+3*dir_z)*dir_z+dir_z}
*Nset, nset=S1-b-{l}-rbedge, instance=Tow1-b
{(l-1) * dir_z+1},
*Nset, nset=S1-b-{l}-rbedge2, instance=Tow1-b
{(l-2+dir_z) * dir_z+1},
*Nset, nset=S1-b-{l}-rbedge3, instance=Tow1-b
{(l-3+2*dir_z) * dir_z+1},
*Nset, nset=S1-b-{l}-rbedge4, instance=Tow1-b
{(l-4+3*dir_z) * dir_z+1},
"""
            for a in range(3):
                rve_edges2 += f"""** Constraint: lt-lbedge{l}-{a}
*Equation
{setno[a]}
S1-t-{l}-ltedge, {setdof[a]}, 1.
S4-b-{l}-lbedge, {setdof[a]}, -1.{set[a]}
** Constraint: lt-lbedge{l}2-{a}
*Equation
{setno[a]}
S2-t-{l}-ltedge, {setdof[a]}, 1.
S4-b-{l}-lbedge2, {setdof[a]}, -1.{set[a]}
** Constraint: lt-lbedge{l}-{a}
*Equation
{setno[a]}
S3-t-{l}-ltedge, {setdof[a]}, 1.
S4-b-{l}-lbedge3, {setdof[a]}, -1.{set[a]}
** Constraint: lt-lbedge{l}2-{a}
*Equation
{setno[a]}
S4-t-{l}-ltedge, {setdof[a]}, 1.
S4-b-{l}-lbedge4, {setdof[a]}, -1.{set[a]}
** Constraint: rt-rbedge{l}-{a}
*Equation
{setno[a]}
S1-b-{l}-rbedge, {setdof[a]}, 1.
S1-t-{l}-rtedge, {setdof[a]}, -1.{altset[a]}
** Constraint: rt-rbedge{l}2-{a}
*Equation
{setno[a]}
S1-b-{l}-rbedge2, {setdof[a]}, 1.
S2-t-{l}-rtedge, {setdof[a]}, -1.{altset[a]}
** Constraint: rt-rbedge{l}3-{a}
*Equation
{setno[a]}
S1-b-{l}-rbedge3, {setdof[a]}, 1.
S3-t-{l}-rtedge, {setdof[a]}, -1.{altset[a]}
** Constraint: rt-rbedge{l}4-{a}
*Equation
{setno[a]}
S1-b-{l}-rbedge4, {setdof[a]}, 1.
S4-t-{l}-rtedge, {setdof[a]}, -1.{altset[a]}
"""

    for a in range(3):
        rve_edges2 += f"""** Constraint: C2-C6-{a}
*Equation
{setno[a]}
C6, {setdof[a]}, 1.
C2, {setdof[a]}, -1.{altset[a]}
** Constraint: C4-C8-{a}
*Equation
{setno[a]}
C4, {setdof[a]}, 1.
C8, {setdof[a]}, -1.{set[a]}
** Constraint: C1-C5-{a}
*Equation
{setno[a]}
C5, {setdof[a]}, 1.
C1, {setdof[a]}, -1.{altset[a]}
"""

    return bc_edges2, rve_edges2


def edges3(dir_x, dir_y, dir_z, set, altset, setno, setdof):
    bc_edges3 = ""
    rve_edges3 = ""

    for l in range(2, dir_z):
        for a in range(3):
            rve_edges3 += f"""** Constraint: lb-rbedge{l}
*Equation
{setno[a]}
S4-b-{l}-lbedge, {setdof[a]}, 1.
S1-b-{l}-rbedge, {setdof[a]}, -1.{set[a]}
** Constraint: lb-rbedge{l}2
*Equation
{setno[a]}
S4-b-{l}-lbedge2, {setdof[a]}, 1.
S1-b-{l}-rbedge2, {setdof[a]}, -1.{set[a]}
** Constraint: lb-rbedge{l}
*Equation
{setno[a]}
S4-b-{l}-lbedge3, {setdof[a]}, 1.
S1-b-{l}-rbedge3, {setdof[a]}, -1.{set[a]}
** Constraint: lb-rbedge{l}2
*Equation
{setno[a]}
S4-b-{l}-lbedge4, {setdof[a]}, 1.
S1-b-{l}-rbedge4, {setdof[a]}, -1.{set[a]}
"""

    for j in range(1, dir_y - 1):
        for a in range(3):
            rve_edges3 += f"""** Constraint: lb-rbedge{l}
*Equation
{setno[a]}
S1-t-{j}bl, {setdof[a]}, 1.
S1-t-{j}br, {setdof[a]}, -1.{set[a]}
** Constraint: lb-rbedge{l}2
*Equation
{setno[a]}
S4-b-{j}bl, {setdof[a]}, 1.
S1-b-{j}br, {setdof[a]}, -1.{set[a]}
"""

    bc_edges3 += f"""*Nset, nset=S4-b-m1-lbedge, instance=Tow4-b
{dir_z*dir_z},
*Nset, nset=S4-b-m2-lbedge, instance=Tow4-b
{(2*dir_z-1)*dir_z},
*Nset, nset=S4-b-m3-lbedge, instance=Tow4-b
{(3*dir_z-2)*dir_z},
*Nset, nset=S1-b-m1-rbedge, instance=Tow1-b
{(dir_z-1)*dir_z + 1},
*Nset, nset=S1-b-m2-rbedge, instance=Tow1-b
{(2*dir_z-2)*dir_z + 1},
*Nset, nset=S1-b-m3-rbedge, instance=Tow1-b
{(3*dir_z-3)*dir_z + 1},
"""

    for a in range(3):
        rve_edges3 += f"""** Constraint: bl-bredge{l}3
*Equation
{setno[a]}
S4-b-m1-lbedge, {setdof[a]}, 1.
S1-b-m1-rbedge, {setdof[a]}, -1.{set[a]}
** Constraint: bl-bredge{l}3
*Equation
{setno[a]}
S4-b-m2-lbedge, {setdof[a]}, 1.
S1-b-m2-rbedge, {setdof[a]}, -1.{set[a]}
** Constraint: bl-bredge{l}3
*Equation
{setno[a]}
S4-b-m3-lbedge, {setdof[a]}, 1.
S1-b-m3-rbedge, {setdof[a]}, -1.{set[a]}
** Constraint: bl-bredge{l}3-1
*Equation
{setno[a]}
S4-b-bl, {setdof[a]}, 1.
S1-b-br, {setdof[a]}, -1.{set[a]}
** Constraint: bl-bredge{l}3-2
*Equation
{setno[a]}
S1-t-bl, {setdof[a]}, 1.
S1-t-br, {setdof[a]}, -1.{set[a]}
"""
        rve_edges3 += f"""** Constraint: C2-C3
*Equation
{setno[a]}
C2, {setdof[a]}, 1.
C3, {setdof[a]}, -1.{set[a]}
** Constraint: C5-C8
*Equation
{setno[a]}
C8, {setdof[a]}, 1.
C5, {setdof[a]}, -1.{altset[a]}
"""

    return bc_edges3, rve_edges3


def C1_C7(module):
    rve_C1_C7 = ""

    if module == "E":
        rve_C1_C7 += f"""** Constraint: C1-C7
*Equation
3
C1, 1, 1.
C7, 1, -1.
RP4, 1, -1.
** Constraint: C1-C7
*Equation
3
C1, 2, 1.
C7, 2, -1.
RP5, 2, -1.
** Constraint: C1-C7
*Equation
3
C1, 3, 1.
C7, 3, -1.
RP6, 3, -1.
"""
    elif module == "G":
        rve_C1_C7 += f"""** Constraint: C1-C7
*Equation
5
C1, 3, 1.
C7, 3, -1.
RP2, 3, -1.
RP5, 3, -1.
RP6, 3, -1.
** Constraint: C1-C7
*Equation
5
C1, 2, 1.
C7, 2, -1.
RP1, 2, -1.
RP4, 2, -1.
RP6, 2, -1.
** Constraint: C1-C7
*Equation
5
C1, 1, 1.
C7, 1, -1.
RP3, 1, -1.
RP4, 1, -1.
RP5, 1, -1.
"""

    return rve_C1_C7

