from RVE_functions import *
import sys
from scriptfile import *

inp_filename = "NAME"  # desired name of the input files. Name of saved input file will be in the format
# *inp_filename*_E and *inp_filename*_G
E11 = True
E22 = False
E33 = False
G12 = True
G12T = False
G13 = False
G23 = False

# Tow parameters
inp_tow_width = 1.89  # width of the tows
inp_tow_height = 0.168  # height of the tows
inp_tow_mat = [1.278E-9, 1570, 157, 157, 0.5, 0.5, 0.5, 0.65, 0.65, 0.65]  # tow material properties, [density, E1, E2, E3, v12, v13
# v23, G12, G13, G23
inp_element_size = 0.168/3  # proposed dimensions for the elements

# Stitch parameters

# designing the stitch(es). Requires: stitch no. [x position (1, 2, 3), z-position (1, 2, 3) , y-position (top/bottom)]
inp_stitch_order = [[1, [[1, 1, 't'], [2, 2, 't'], [2, 2, 'b'], [1, 1, 'b'], [1, 1, 't']]],
 [2, [[2, 2, 't'], [3, 3, 't'], [3, 3, 'b'], [2, 2, 'b'], [2, 2, 't']]],
 [3, [[3, 3, 't'], [4, 4, 't'], [4, 4, 'b'], [3, 3, 'b'], [3, 3, 't']]],
 [4, [[4, 4, 't'], [5, 5, 't'], [5, 5, 'b'], [4, 4, 'b'], [4, 4, 't']]]]




#                                               Z <-----
#               (1,3)----(1,2)----(1,1)                 |
#                 |        |        |                   |
#               (2,3)----(2,2)----(2,1)                 v
#                 |        |        |                   X
#               (3,3)----(3,2)----(3,1)

#                                               Z <-----
#                 -------------------                   |
#                 |        t1        |                  |
#                 -------------------                   v
#                 |        t2        |                  X
#                 -------------------

#                                               Z <-----
#                 -------------------                   |
#                 |        |        |                   |
#                 |   b2   |   b1   |                    v
#                 |        |        |                   X
#                 -------------------

#NB: Y is out of plane direction

# Stitches are designed by giving the trajectory of the stitch using the coordinates of the stitch position and
# whether it connects on the top or bottom side of the RVE
inp_stitch_area_full = 0.00159  # area of the stitch
inp_stitch_area_knockdown = 0.5  # knockdown factor for chosen region of stitch NOTE: EACH STITCH IS TWO STITCHES
inp_stitch_knockdown = [[1, "1"],
                   [2, "1"],
                   [3, "1"],
                   [4, "1"],
                   [5, "1"],
                   [6, "1"],
                   [7, "1"],
                   [8, "1"]]
inp_stitch_full = [[1, "2, 3, 4"],
                    [2, "2, 3, 4"],
                    [3, "2, 3, 4"],
                    [4, "2, 3, 4"],
                    [5, "2, 3, 4"],
                    [6, "2, 3, 4"],
                    [7, "2, 3, 4"],
                    [8, "2, 3, 4"]]
inp_stitch_mat = [1.38E-9, 2.8E3, 0.3]   # material properties of the stitch


# General properties
inp_friction_00 = 0.0001
inp_friction_090 = 0.0001

# Get the full part definition for a single tow
tow_part, tow_instance, dir_x, dir_y, dir_z = get_tow(inp_tow_width, inp_tow_height, inp_element_size)
CC1 = dir_x*dir_z
CC2 = (dir_x-1)*dir_z+1
CC4 = dir_z
CC5 = dir_x*dir_z

script = fscriptfile(inp_filename, 1, inp_tow_width, inp_tow_height, E11, E22, E33, G12, G12T, G13, G23,
                     CC1, CC2, CC4, CC5)
# Get the full part definition for the stitches and the full instance definition for the stitches
stitch_part, stitch_instance = get_stitches(inp_stitch_order, inp_tow_width, inp_tow_height, inp_stitch_full,
                                            inp_stitch_area_full, inp_stitch_knockdown, inp_stitch_area_knockdown, sys)

slave_sets, master_sets, slave_surface, master_surface, constraints = get_constraints(inp_stitch_order, dir_x, dir_z, sys)

int_surface, int_def = get_interactions(dir_x, dir_z, dir_y)

# format the material properties for tow
tow_engineering_constants = (f"{inp_tow_mat[1]}, {inp_tow_mat[2]}, {inp_tow_mat[3]}, "
                             f"{inp_tow_mat[4]}, {inp_tow_mat[5]}, {inp_tow_mat[6]}, "
                             f"{inp_tow_mat[7]}, {inp_tow_mat[8]} \n"
                             f"{inp_tow_mat[9]}")

script_jobs = ""

module = ["E", "G"]
for i in module:
    refpoints, RPs, rve_constraints = get_rve(inp_tow_width, inp_tow_height, dir_x, dir_y, dir_z, i)

    # Writing the input
    file_input = f"""*Heading
**Job name: draw Model name: Model-1
*PREPRINT, ECHO=NO, MODEL=NO, HISTORY=NO, CONTACT=NO
**
** PARTS
**
{tow_part}
{stitch_part}**
** ASSEMBLY
**
*Assembly, name=Assembly
**  
{tow_instance}
{stitch_instance}**
{refpoints}
{RPs}{slave_sets}{master_sets}{int_surface}
{slave_surface}{master_surface}
{constraints}{rve_constraints}
*End Assembly
** 
** MATERIALS
** 
*Material, name=Material-Tow
*Density
{inp_tow_mat[0]},
*Elastic, type=ENGINEERING CONSTANTS
{tow_engineering_constants}
*Material, name=Material-Stitch
*Density
{inp_stitch_mat[0]}
*Elastic
{inp_stitch_mat[1]}, {inp_stitch_mat[2]}
*No Compression
** 
** INTERACTION PROPERTIES
** 
*Surface Interaction, name=IntProp-00
*Friction
{inp_friction_00}
*Surface Behavior, pressure-overclosure=HARD
*Surface Interaction, name=IntProp-090
*Friction
{inp_friction_090}
*Surface Behavior, pressure - overclosure = HARD
**
** INTERACTIONS
**
{int_def}
** ----------------------------------------------------------------
**
** STEP: Step-1
** 
*Step, name=Step-1, nlgeom=YES
*Static, stabilize=2e-05, allsdtol=0.05, continue=NO
1., 1., 1e-05, 1.
** 
*End Step  
"""

    name = f"{inp_filename}_{i}"

    def rve(filename, input, ext):
        """This function takes the filename and the input as an input argument,
        a document with the name *filename_i*.inp is created and the input from *input* is written to this file"""
        with open(f"{filename}.{ext}", "w") as g:
            g.writelines(input)

    rve(name, file_input, "inp")
    rve('script_abaqus', script, 'py' )

