import pandas as pd

#Merge floods.xslx and floods_mswep_merged.xlsx
dailymax = pd.read_excel('Daily_R24.xlsx')
rolling = pd.read_excel('Max-rolling_R.xlsx')

dailymax['id'] = dailymax['id'].astype(int)
rolling['id'] = rolling['id'].astype(int)
df = pd.merge(rolling, dailymax[['id','Day-3', 'Day-2', 'Day-1', 'Day0', 'Day1']], how='left', on='id')
#df.to_excel('test.xlsx', index=False)

# Load the Excel file
#file_path = 'floods_mswep_merged.xlsx'  # Replace with your actual file path
#df = pd.read_excel(file_path)

# Define a function to generate a unique key for each row based on latitude, longitude, country, and date
def generate_key(row):
    return f"{row['latitude']}_{row['longitude']}_{row['country']}_{row['date']}"

# Create a unique identifier column
df['unique_key'] = df.apply(generate_key, axis=1)

# Dictionary to store the maximum values for each key
max_values = {}

# Populate the max_values dictionary with the maximums for each key (if present in the data)
for col in ['Max3h', 'Max6h', 'Max12h', 'Max24h', 'Max48h', 'Day-3', 'Day-2', 'Day-1', 'Day0', 'Day1']:
    grouped = df.groupby('unique_key')[col].max()
    max_values[col] = grouped.to_dict()

# Fill missing values based on the computed maximums for each key
def fill_columns(row):
    key = row['unique_key']
    for col in ['Max3h', 'Max6h', 'Max12h', 'Max24h', 'Max48h','Day-3', 'Day-2', 'Day-1', 'Day0', 'Day1']:
        if pd.isna(row[col]) and key in max_values[col]:
            row[col] = max_values[col][key]
    return row

# Apply the fill function to the dataframe
df = df.apply(fill_columns, axis=1)

# Drop the unique_key column (optional)
df.drop(columns=['unique_key'], inplace=True)

# Save the updated file
output_file = 'Fatalities-Rain-dataset-1980-2020.xlsx'
df.to_excel(output_file, index=False)
print(f"Updated file saved as {output_file}")
