# Create the temp and max directories if they don't exist
mkdir -p temp
mkdir -p max

# Process each .nc file
for file in *.nc; do
    # Extract the base filename (without extension) to use for output file names
    base_filename=$(basename "$file" .nc)

    # Select timesteps from 2 to 41 and save to the temp directory
    cdo seltimestep,2/41 "$file" "temp/$base_filename_temp.nc"

    # Apply the daysum operation (to sum over each day)
    cdo daysum "temp/$base_filename_temp.nc" "temp/${base_filename}_day_sum.nc"

    # Calculate the field maximum and save to the max directory
    cdo fldmax "temp/${base_filename}_day_sum.nc" "max/${base_filename}.nc"

    # Clean up the temporary files
    rm "temp/$base_filename_temp.nc" "temp/${base_filename}_day_sum.nc"
done

