# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.11
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.





from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_casadi')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_casadi')
    _casadi = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_casadi', [dirname(__file__)])
        except ImportError:
            import _casadi
            return _casadi
        if fp is not None:
            try:
                _mod = imp.load_module('_casadi', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _casadi = swig_import_helper()
    del swig_import_helper
else:
    import _casadi
del _swig_python_version_info
try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyCasadiObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


CASADI_INT_TYPE_STR = _casadi.CASADI_INT_TYPE_STR


import contextlib

class _copyableObject(object):
  def __copy__(self):
    return self.__class__(self)

  def __deepcopy__(self,dummy=None):
    return self.__class__(self)

_object = object = _copyableObject

_swig_repr_default = _swig_repr
def _swig_repr(self):
  if hasattr(self,'repr'):
    return self.repr()
  else:
    return _swig_repr_default(self)

def DM_from_array(m, check_only=True):
  import numpy as np
  if isinstance(m, np.ndarray):
    if len(m.shape)>2:
      return False
    try:
      m = m.astype(float,casting="same_kind",copy=False)
    except:
      return False
    if check_only:
      return True
    else:
      shape = m.shape + (1, 1)
      nrow, ncol = shape[0], shape[1]
      return (nrow,ncol,m.flat)
  return False

def IM_from_array(m, check_only=True):
  import numpy as np
  if isinstance(m, np.ndarray):
    if len(m.shape)>2:
      return False
    try:
      m = m.astype(int,casting="same_kind",copy=False)
    except:
      return False
    if check_only:
      return True
    else:
      shape = m.shape + (1, 1)
      nrow, ncol = shape[0], shape[1]
      return (nrow,ncol,m.flat)
  return False

def SX_from_array(m, check_only=True):
  import numpy as np
  if isinstance(m, np.ndarray):
    if len(m.shape)>2:
      return False
    if m.dtype!=np.object: return None
    shape = m.shape + (1, 1)
    nrow, ncol = shape[0], shape[1]
    return (nrow,ncol,m.flat)
  return False

def DM_from_csc(m, check_only=True):
  if hasattr(m,"tocsc"):
    m = m.tocsc()
  if m.__class__.__name__ == "csc_matrix":
    if len(m.shape)!=2: return False
    if check_only: return True
    return m.shape + (m.indptr.flat,m.indices.flat,m.data.flat)
  return False


MNAME = _casadi.MNAME
class SwigPyIterator(_object):
    """


    SwigPyIterator() -> 



    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _casadi.delete_SwigPyIterator

    def value(self, *args):
        """


        value(self) -> PyObject *



        """
        return _casadi.SwigPyIterator_value(self, *args)


    def incr(self, *args):
        """


        incr(self, size_t n) -> SwigPyIterator



        """
        return _casadi.SwigPyIterator_incr(self, *args)


    def decr(self, *args):
        """


        decr(self, size_t n) -> SwigPyIterator



        """
        return _casadi.SwigPyIterator_decr(self, *args)


    def distance(self, *args):
        """


        distance(self, SwigPyIterator x) -> ptrdiff_t



        """
        return _casadi.SwigPyIterator_distance(self, *args)


    def equal(self, *args):
        """


        equal(self, SwigPyIterator x) -> bool



        """
        return _casadi.SwigPyIterator_equal(self, *args)


    def copy(self, *args):
        """


        copy(self) -> SwigPyIterator



        """
        return _casadi.SwigPyIterator_copy(self, *args)


    def next(self, *args):
        """


        next(self) -> PyObject *



        """
        return _casadi.SwigPyIterator_next(self, *args)


    def __next__(self, *args):
        """


        __next__(self) -> PyObject *



        """
        return _casadi.SwigPyIterator___next__(self, *args)


    def previous(self, *args):
        """


        previous(self) -> PyObject *



        """
        return _casadi.SwigPyIterator_previous(self, *args)


    def advance(self, *args):
        """


        advance(self, ptrdiff_t n) -> SwigPyIterator



        """
        return _casadi.SwigPyIterator_advance(self, *args)


    def __eq__(self, *args):
        """


        __eq__(self, SwigPyIterator x) -> bool



        """
        return _casadi.SwigPyIterator___eq__(self, *args)


    def __ne__(self, *args):
        """


        __ne__(self, SwigPyIterator x) -> bool



        """
        return _casadi.SwigPyIterator___ne__(self, *args)


    def __iadd__(self, *args):
        """


        __iadd__(self, ptrdiff_t n) -> SwigPyIterator



        """
        return _casadi.SwigPyIterator___iadd__(self, *args)


    def __isub__(self, *args):
        """


        __isub__(self, ptrdiff_t n) -> SwigPyIterator



        """
        return _casadi.SwigPyIterator___isub__(self, *args)


    def __add__(self, *args):
        """


        __add__(self, ptrdiff_t n) -> SwigPyIterator



        """
        return _casadi.SwigPyIterator___add__(self, *args)


    def __sub__(self, *args):
        """


        __sub__(self, SwigPyIterator x) -> ptrdiff_t
        __sub__(self, ptrdiff_t n) -> SwigPyIterator



        """
        return _casadi.SwigPyIterator___sub__(self, *args)

    def __iter__(self):
        return self
SwigPyIterator_swigregister = _casadi.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

L_INT = _casadi.L_INT
L_BOOL = _casadi.L_BOOL
LL = _casadi.LL
LR = _casadi.LR
L_DICT = _casadi.L_DICT
L_DOUBLE = _casadi.L_DOUBLE
L_STR = _casadi.L_STR
LABEL = _casadi.LABEL

if __name__ != "casadi.casadi":
  raise Exception("""
            CasADi is not running from its package context.

            You probably specified the wrong casadi directory.

            When setting PYTHONPATH or sys.path.append,
            take care not to add a trailing '/casadi'.

        """)

def swigtypeconvertor(*args):
  return swig_typename_convertor_python2cpp(args)

def swig_typename_convertor_python2cpp(a):
  try:
    import numpy as np
  except:
    class NoExist:
      pass
    class Temp(object):
      ndarray = NoExist
    np = Temp()
  if isinstance(a,list):
    if len(a)>0:
      return "[%s]" % "|".join(set([swig_typename_convertor_python2cpp(i) for i in a]))
    else:
      return "[]"
  elif isinstance(a,tuple):
    return "(%s)" % ",".join([swig_typename_convertor_python2cpp(i) for i in a])
  elif isinstance(a,np.ndarray):
    return "np.array(%s)" % ",".join(set([swig_typename_convertor_python2cpp(i) for i in np.array(a).flatten().tolist()]))
  elif isinstance(a,dict):
    if len(a)>0:
      return "|".join(set([swig_typename_convertor_python2cpp(i) for i in a.keys()])) +":"+ "|".join(set([swig_typename_convertor_python2cpp(i) for i in a.values()]))
    else:
      return "dict"
  return type(a).__name__


try:
  from numpy import pi, inf
except:
  pass

arcsin = lambda x: _casadi.asin(x)
arccos = lambda x: _casadi.acos(x)
arctan = lambda x: _casadi.atan(x)
arctan2 = lambda x,y: _casadi.atan2(x, y)
arctanh = lambda x: _casadi.atanh(x)
arcsinh = lambda x: _casadi.asinh(x)
arccosh = lambda x: _casadi.acosh(x)


def veccat(*args): return _veccat(args)
def vertcat(*args): return _vertcat(args)
def horzcat(*args): return _horzcat(args)
def diagcat(*args): return _diagcat(args)
def vvcat(args): return _veccat(args)
def vcat(args): return _vertcat(args)
def hcat(args): return _horzcat(args)
def dcat(args): return _diagcat(args)


class NZproxy:
  def __init__(self,matrix):
    self.matrix = matrix

  def __getitem__(self,s):
    return self.matrix.get_nz(False, s)

  def __setitem__(self,s,val):
    return self.matrix.set_nz(val, False, s)

  def __len__(self):
    return self.matrix.nnz()

  def __iter__(self):
    for i in range(len(self)):
      yield self[i]


class PrintableCommon(_object):
    """


    PrintableCommon() -> 



    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PrintableCommon, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PrintableCommon, name)
    __repr__ = _swig_repr

    def __str__(self): return self.str()
    def repr(self): return self.type_name() + '(' + self.str() + ')'


    def __init__(self, *args):
        """


        PrintableCommon()
        PrintableCommon(PrintableCommon other)



        """
        this = _casadi.new_PrintableCommon(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_PrintableCommon
PrintableCommon_swigregister = _casadi.PrintableCommon_swigregister
PrintableCommon_swigregister(PrintableCommon)

class SharedObject(_object):
    """
      SharedObject implements a reference counting framework similar for efficient


    and easily-maintained memory management.

    To use the class, both the SharedObject class (the public class), and the
    SharedObjectInternal class (the internal class) must be inherited from. It
    can be done in two different files and together with memory management, this
    approach provides a clear distinction of which methods of the class are to
    be considered "public", i.e. methods for public use that can be considered
    to remain over time with small changes, and the internal memory.

    When interfacing a software, which typically includes including some header
    file, this is best done only in the file where the internal class is
    defined, to avoid polluting the global namespace and other side effects.

    The default constructor always means creating a null pointer to an internal
    class only. To allocate an internal class (this works only when the internal
    class isn't abstract), use the constructor with arguments.

    The copy constructor and the assignment operator perform shallow copies
    only, to make a deep copy you must use the clone method explicitly. This
    will give a shared pointer instance.

    In an inheritance hierarchy, you can cast down automatically, e.g. (
    SXFunction is a child class of Function): SXFunction derived(...); Function
    base = derived;

    To cast up, use the shared_cast template function, which works analogously
    to dynamic_cast, static_cast, const_cast etc, e.g.: SXFunction derived(...);
    Function base = derived; SXFunction derived_from_base =
    shared_cast<SXFunction>(base);

    A failed shared_cast will result in a null pointer (cf. dynamic_cast)

    Joel Andersson

    C++ includes: shared_object.hpp 


    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SharedObject, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SharedObject, name)
    __repr__ = _swig_repr

    def class_name(self, *args):
        """
        Get class name.

        class_name(self) -> str





        """
        return _casadi.SharedObject_class_name(self, *args)


    def disp(self, *args):
        """
        Print a description of the object.

        disp(self, bool more)





        """
        return _casadi.SharedObject_disp(self, *args)


    def str(self, *args):
        """
        Get string representation.

        str(self, bool more) -> str





        """
        return _casadi.SharedObject_str(self, *args)


    def print_ptr(self, *args):
        """
        [INTERNAL]  Print the pointer to the internal class

        print_ptr(self)





        """
        return _casadi.SharedObject_print_ptr(self, *args)


    def is_null(self, *args):
        """
        Is a null pointer?

        is_null(self) -> bool





        """
        return _casadi.SharedObject_is_null(self, *args)


    def __hash__(self, *args):
        """
          Returns a number that is unique for a given Node. If the Object does not

          __hash__(self) -> int

        point to any node, "0" is returned.




        """
        return _casadi.SharedObject___hash__(self, *args)


    def __init__(self, *args):
        """


        SharedObject()
        SharedObject(SharedObject other)



        """
        this = _casadi.new_SharedObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_SharedObject
SharedObject_swigregister = _casadi.SharedObject_swigregister
SharedObject_swigregister(SharedObject)

class WeakRef(SharedObject):
    """
      Weak reference type A weak reference to a SharedObject.



    Joel Andersson

    C++ includes: shared_object.hpp 


    """

    __swig_setmethods__ = {}
    for _s in [SharedObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WeakRef, name, value)
    __swig_getmethods__ = {}
    for _s in [SharedObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, WeakRef, name)
    __repr__ = _swig_repr

    def shared(self, *args):
        """
        Get a shared (owning) reference.

        shared(self) -> SharedObject





        """
        return _casadi.WeakRef_shared(self, *args)


    def alive(self, *args):
        """
        Check if alive.

        alive(self) -> bool





        """
        return _casadi.WeakRef_alive(self, *args)


    def __init__(self, *args):
        """


          WeakRef(int dummy)
          WeakRef(WeakRef other)
          WeakRef(SharedObject shared)


        .......

        ::

          WeakRef(WeakRef other)



        .............


        .......

        ::

          WeakRef(SharedObject shared)



        Construct from a shared object (also implicit type conversion)



        .............


        .......

        ::

          WeakRef(int dummy)



        Default constructor.



        .............



        """
        this = _casadi.new_WeakRef(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_WeakRef
WeakRef_swigregister = _casadi.WeakRef_swigregister
WeakRef_swigregister(WeakRef)


def complement(*args):
    """
      Returns the list of all i in [0, size[ not found in supplied list.

      complement([int] v, int size) -> [int]


    The supplied vector may contain duplicates and may be non-monotonous The
    supplied vector will be checked for bounds The result vector is guaranteed
    to be monotonously increasing




    """
    return _casadi.complement(*args)

def lookupvector(*args):
    """


      lookupvector([int] v) -> [int]
      lookupvector([int] v, int size) -> [int]


    .......

    ::

      lookupvector([int] v)



    .............


    .......

    ::

      lookupvector([int] v, int size)



    Returns a vector for quickly looking up entries of supplied list.

    lookupvector[i]!=-1 <=> v contains i v[lookupvector[i]] == i <=> v contains
    i

    Duplicates are treated by looking up last occurrence



    .............



    """
    return _casadi.lookupvector(*args)

def temporary_file(*args):
    """


    temporary_file(str prefix, str suffix) -> str



    """
    return _casadi.temporary_file(*args)

def normalized_setup(*args):
    """


    normalized_setup()
    normalized_setup(std::istream & stream)



    """
    return _casadi.normalized_setup(*args)

def normalized_out(*args):
    """


    normalized_out(float val)



    """
    return _casadi.normalized_out(*args)

def normalized_in(*args):
    """


    normalized_in(std::istream & stream, double & ret) -> int



    """
    return _casadi.normalized_in(*args)
SWIG_IND1 = _casadi.SWIG_IND1
class GenericType(PrintableCommon):
    """
      Generic data type, can hold different types such as bool, casadi_int, string


    etc.

    Joel Andersson

    C++ includes: generic_type.hpp 


    """

    __swig_setmethods__ = {}
    for _s in [PrintableCommon]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GenericType, name, value)
    __swig_getmethods__ = {}
    for _s in [PrintableCommon]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GenericType, name)
    __repr__ = _swig_repr

    def serialize(self, *args):
        """
        Serialize an object.

        serialize(self, casadi::SerializingStream & s)





        """
        return _casadi.GenericType_serialize(self, *args)


    def deserialize(*args):
        """


        deserialize(casadi::DeserializingStream & s) -> GenericType



        """
        return _casadi.GenericType_deserialize(*args)

    deserialize = staticmethod(deserialize)

    def __init__(self, *args):
        """


        GenericType()
        GenericType(GenericType other)



        """
        this = _casadi.new_GenericType(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_GenericType
GenericType_swigregister = _casadi.GenericType_swigregister
GenericType_swigregister(GenericType)

def GenericType_deserialize(*args):
    """


    deserialize(casadi::DeserializingStream & s) -> GenericType



    """
    return _casadi.GenericType_deserialize(*args)

OP_ASSIGN = _casadi.OP_ASSIGN
OP_ADD = _casadi.OP_ADD
OP_SUB = _casadi.OP_SUB
OP_MUL = _casadi.OP_MUL
OP_DIV = _casadi.OP_DIV
OP_NEG = _casadi.OP_NEG
OP_EXP = _casadi.OP_EXP
OP_LOG = _casadi.OP_LOG
OP_POW = _casadi.OP_POW
OP_CONSTPOW = _casadi.OP_CONSTPOW
OP_SQRT = _casadi.OP_SQRT
OP_SQ = _casadi.OP_SQ
OP_TWICE = _casadi.OP_TWICE
OP_SIN = _casadi.OP_SIN
OP_COS = _casadi.OP_COS
OP_TAN = _casadi.OP_TAN
OP_ASIN = _casadi.OP_ASIN
OP_ACOS = _casadi.OP_ACOS
OP_ATAN = _casadi.OP_ATAN
OP_LT = _casadi.OP_LT
OP_LE = _casadi.OP_LE
OP_EQ = _casadi.OP_EQ
OP_NE = _casadi.OP_NE
OP_NOT = _casadi.OP_NOT
OP_AND = _casadi.OP_AND
OP_OR = _casadi.OP_OR
OP_FLOOR = _casadi.OP_FLOOR
OP_CEIL = _casadi.OP_CEIL
OP_FMOD = _casadi.OP_FMOD
OP_FABS = _casadi.OP_FABS
OP_SIGN = _casadi.OP_SIGN
OP_COPYSIGN = _casadi.OP_COPYSIGN
OP_IF_ELSE_ZERO = _casadi.OP_IF_ELSE_ZERO
OP_ERF = _casadi.OP_ERF
OP_FMIN = _casadi.OP_FMIN
OP_FMAX = _casadi.OP_FMAX
OP_INV = _casadi.OP_INV
OP_SINH = _casadi.OP_SINH
OP_COSH = _casadi.OP_COSH
OP_TANH = _casadi.OP_TANH
OP_ASINH = _casadi.OP_ASINH
OP_ACOSH = _casadi.OP_ACOSH
OP_ATANH = _casadi.OP_ATANH
OP_ATAN2 = _casadi.OP_ATAN2
OP_CONST = _casadi.OP_CONST
OP_INPUT = _casadi.OP_INPUT
OP_OUTPUT = _casadi.OP_OUTPUT
OP_PARAMETER = _casadi.OP_PARAMETER
OP_CALL = _casadi.OP_CALL
OP_FIND = _casadi.OP_FIND
OP_LOW = _casadi.OP_LOW
OP_MAP = _casadi.OP_MAP
OP_MTIMES = _casadi.OP_MTIMES
OP_SOLVE = _casadi.OP_SOLVE
OP_TRANSPOSE = _casadi.OP_TRANSPOSE
OP_DETERMINANT = _casadi.OP_DETERMINANT
OP_INVERSE = _casadi.OP_INVERSE
OP_DOT = _casadi.OP_DOT
OP_BILIN = _casadi.OP_BILIN
OP_RANK1 = _casadi.OP_RANK1
OP_HORZCAT = _casadi.OP_HORZCAT
OP_VERTCAT = _casadi.OP_VERTCAT
OP_DIAGCAT = _casadi.OP_DIAGCAT
OP_HORZSPLIT = _casadi.OP_HORZSPLIT
OP_VERTSPLIT = _casadi.OP_VERTSPLIT
OP_DIAGSPLIT = _casadi.OP_DIAGSPLIT
OP_RESHAPE = _casadi.OP_RESHAPE
OP_SUBREF = _casadi.OP_SUBREF
OP_SUBASSIGN = _casadi.OP_SUBASSIGN
OP_GETNONZEROS = _casadi.OP_GETNONZEROS
OP_GETNONZEROS_PARAM = _casadi.OP_GETNONZEROS_PARAM
OP_ADDNONZEROS = _casadi.OP_ADDNONZEROS
OP_ADDNONZEROS_PARAM = _casadi.OP_ADDNONZEROS_PARAM
OP_SETNONZEROS = _casadi.OP_SETNONZEROS
OP_SETNONZEROS_PARAM = _casadi.OP_SETNONZEROS_PARAM
OP_PROJECT = _casadi.OP_PROJECT
OP_ASSERTION = _casadi.OP_ASSERTION
OP_MONITOR = _casadi.OP_MONITOR
OP_NORM2 = _casadi.OP_NORM2
OP_NORM1 = _casadi.OP_NORM1
OP_NORMINF = _casadi.OP_NORMINF
OP_NORMF = _casadi.OP_NORMF
OP_MMIN = _casadi.OP_MMIN
OP_MMAX = _casadi.OP_MMAX
OP_HORZREPMAT = _casadi.OP_HORZREPMAT
OP_HORZREPSUM = _casadi.OP_HORZREPSUM
OP_ERFINV = _casadi.OP_ERFINV
OP_PRINTME = _casadi.OP_PRINTME
OP_LIFT = _casadi.OP_LIFT
OP_EINSTEIN = _casadi.OP_EINSTEIN
OP_BSPLINE = _casadi.OP_BSPLINE
OP_CONVEXIFY = _casadi.OP_CONVEXIFY
class SparsityInterfaceCommon(_object):
    """


    SparsityInterfaceCommon() -> 



    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SparsityInterfaceCommon, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SparsityInterfaceCommon, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        SparsityInterfaceCommon()
        SparsityInterfaceCommon(SparsityInterfaceCommon other)



        """
        this = _casadi.new_SparsityInterfaceCommon(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_SparsityInterfaceCommon
SparsityInterfaceCommon_swigregister = _casadi.SparsityInterfaceCommon_swigregister
SparsityInterfaceCommon_swigregister(SparsityInterfaceCommon)

class Sparsity(SharedObject, SparsityInterfaceCommon, PrintableCommon):
    """
      General sparsity class.



    The storage format is a compressed column storage (CCS) format.  In this
    format, the structural non-zero elements are stored in column-major order,
    starting from the upper left corner of the matrix and ending in the lower
    right corner.

    In addition to the dimension ( size1(), size2()), (i.e. the number of rows
    and the number of columns respectively), there are also two vectors of
    integers:

    "colind" [length size2()+1], which contains the index to the first non-
    zero element on or after the corresponding column. All the non-zero elements
    of a particular i are thus the elements with index el that fulfills:
    colind[i] <= el < colind[i+1].

    "row" [same length as the number of non-zero elements, nnz()] The rows for
    each of the structural non-zeros.

    Note that with this format, it is cheap to loop over all the non-zero
    elements of a particular column, at constant time per element, but expensive
    to jump to access a location (i, j).

    If the matrix is dense, i.e. length(row) == size1()*size2(), the format
    reduces to standard dense column major format, which allows access to an
    arbitrary element in constant time.

    Since the object is reference counted (it inherits from SharedObject),
    several matrices are allowed to share the same sparsity pattern.

    The implementations of methods marked as such in this class has been taken
    from the CSparse package and modified to fit CasADi data structures and
    separation of sparsity pattern calculation and numerical evaluation. These
    functions are Copyright(c) Timothy A. Davis, 2006-2009 and licensed as a
    derivative work under the GNU LGPL

    See:   Matrix

    Joel Andersson

    C++ includes: sparsity.hpp 


    """

    __swig_setmethods__ = {}
    for _s in [SharedObject, SparsityInterfaceCommon, PrintableCommon]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sparsity, name, value)
    __swig_getmethods__ = {}
    for _s in [SharedObject, SparsityInterfaceCommon, PrintableCommon]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sparsity, name)
    __repr__ = _swig_repr

    def scalar(*args):
        """
        Create a scalar sparsity pattern.

        scalar(bool dense_scalar) -> Sparsity





        """
        return _casadi.Sparsity_scalar(*args)

    scalar = staticmethod(scalar)

    def dense(*args):
        """
        Create a dense rectangular sparsity pattern.

        dense(int nrow, int ncol) -> Sparsity
        dense((int,int) rc) -> Sparsity





        """
        return _casadi.Sparsity_dense(*args)

    dense = staticmethod(dense)

    def unit(*args):
        """
          Create the sparsity pattern for a unit vector of length n and a nonzero on

          unit(int n, int el) -> Sparsity

        position el.




        """
        return _casadi.Sparsity_unit(*args)

    unit = staticmethod(unit)

    def upper(*args):
        """


        upper(int n) -> Sparsity



        """
        return _casadi.Sparsity_upper(*args)

    upper = staticmethod(upper)

    def lower(*args):
        """


        lower(int n) -> Sparsity



        """
        return _casadi.Sparsity_lower(*args)

    lower = staticmethod(lower)

    def diag(*args):
        """
        Create diagonal sparsity pattern.

        diag(int nrow) -> Sparsity
        diag((int,int) rc) -> Sparsity
        diag(int nrow, int ncol) -> Sparsity





        """
        return _casadi.Sparsity_diag(*args)

    diag = staticmethod(diag)

    def band(*args):
        """


        band(int n, int p) -> Sparsity



        """
        return _casadi.Sparsity_band(*args)

    band = staticmethod(band)

    def banded(*args):
        """


        banded(int n, int p) -> Sparsity



        """
        return _casadi.Sparsity_banded(*args)

    banded = staticmethod(banded)

    def rowcol(*args):
        """


        rowcol([int] row, [int] col, int nrow, int ncol) -> Sparsity



        """
        return _casadi.Sparsity_rowcol(*args)

    rowcol = staticmethod(rowcol)

    def triplet(*args):
        """


        triplet(int nrow, int ncol, [int] row, [int] col) -> Sparsity
        triplet(int nrow, int ncol, [int] row, [int] col, bool invert_mapping) -> (Sparsity , [int] OUTPUT)



        """
        return _casadi.Sparsity_triplet(*args)

    triplet = staticmethod(triplet)

    def nonzeros(*args):
        """


        nonzeros(int nrow, int ncol, [int] nz, bool ind1) -> Sparsity



        """
        return _casadi.Sparsity_nonzeros(*args)

    nonzeros = staticmethod(nonzeros)

    def compressed(*args):
        """
          Create from a single vector containing the pattern in compressed column

          compressed([int] v, bool order_rows) -> Sparsity

        storage format: The format: The first two entries are the number of rows
        (nrow) and columns (ncol) The next ncol+1 entries are the column offsets
        (colind). Note that the last element, colind[ncol], gives the number of
        nonzeros The last colind[ncol] entries are the row indices




        """
        return _casadi.Sparsity_compressed(*args)

    compressed = staticmethod(compressed)

    def sanity_check(self, *args):
        """
          [DEPRECATED] Correctness of sparsity patterns are checked during

          sanity_check(self, bool complete)

        construction




        """
        return _casadi.Sparsity_sanity_check(self, *args)


    def get_diag(self, *args):
        """
          Get the diagonal of the matrix/create a diagonal matrix (mapping will

          get_diag(self) -> (Sparsity , [int] OUTPUT)

        contain the nonzero mapping) When the input is square, the diagonal elements
        are returned. If the input is vector-like, a diagonal matrix is constructed
        with it.




        """
        return _casadi.Sparsity_get_diag(self, *args)


    def compress(self, *args):
        """
        Compress a sparsity pattern.

        compress(self) -> [int]





        """
        return _casadi.Sparsity_compress(self, *args)


    def is_equal(self, *args):
        """


        is_equal(self, Sparsity y) -> bool
        is_equal(self, int nrow, int ncol, [int] colind, [int] row) -> bool



        """
        return _casadi.Sparsity_is_equal(self, *args)


    def __eq__(self, *args):
        """


        __eq__(self, Sparsity y) -> bool



        """
        return _casadi.Sparsity___eq__(self, *args)


    def __ne__(self, *args):
        """


        __ne__(self, Sparsity y) -> bool



        """
        return _casadi.Sparsity___ne__(self, *args)


    def is_stacked(self, *args):
        """
        Check if pattern is horizontal repeat of another.

        is_stacked(self, Sparsity y, int n) -> bool





        """
        return _casadi.Sparsity_is_stacked(self, *args)


    def size1(self, *args):
        """
        Get the number of rows.

        size1(self) -> int





        """
        return _casadi.Sparsity_size1(self, *args)


    def rows(self, *args):
        """
        Get the number of rows, Octave-style syntax.

        rows(self) -> int





        """
        return _casadi.Sparsity_rows(self, *args)


    def size2(self, *args):
        """
        Get the number of columns.

        size2(self) -> int





        """
        return _casadi.Sparsity_size2(self, *args)


    def columns(self, *args):
        """
        Get the number of columns, Octave-style syntax.

        columns(self) -> int





        """
        return _casadi.Sparsity_columns(self, *args)


    def numel(self, *args):
        """
          The total number of elements, including structural zeros, i.e.

          numel(self) -> int

        size2()*size1() Beware of overflow.

        See:   nnz()




        """
        return _casadi.Sparsity_numel(self, *args)


    def density(self, *args):
        """
          The percentage of nonzero Equivalent to (100.0 * nnz())/numel(), but avoids

          density(self) -> float

        overflow.




        """
        return _casadi.Sparsity_density(self, *args)


    def is_empty(self, *args):
        """
          Check if the sparsity is empty.

          is_empty(self, bool both) -> bool


        A sparsity is considered empty if one of the dimensions is zero (or
        optionally both dimensions)




        """
        return _casadi.Sparsity_is_empty(self, *args)


    def nnz(self, *args):
        """
          Get the number of (structural) non-zeros.

          nnz(self) -> int


        See:   numel()




        """
        return _casadi.Sparsity_nnz(self, *args)


    def nnz_upper(self, *args):
        """
          Number of non-zeros in the upper triangular half, i.e. the number of

          nnz_upper(self, bool strictly) -> int

        elements (i, j) with j>=i.




        """
        return _casadi.Sparsity_nnz_upper(self, *args)


    def nnz_lower(self, *args):
        """
          Number of non-zeros in the lower triangular half, i.e. the number of

          nnz_lower(self, bool strictly) -> int

        elements (i, j) with j<=i.




        """
        return _casadi.Sparsity_nnz_lower(self, *args)


    def nnz_diag(self, *args):
        """
          Number of non-zeros on the diagonal, i.e. the number of elements (i, j) with

          nnz_diag(self) -> int

        j==i.




        """
        return _casadi.Sparsity_nnz_diag(self, *args)


    def bw_upper(self, *args):
        """
        Upper half-bandwidth.

        bw_upper(self) -> int





        """
        return _casadi.Sparsity_bw_upper(self, *args)


    def bw_lower(self, *args):
        """
        Lower half-bandwidth.

        bw_lower(self) -> int





        """
        return _casadi.Sparsity_bw_lower(self, *args)


    def size(self, *args):
        """
          Get the size along a particular dimensions.

          size(self) -> (int,int)
          size(self, int axis) -> int




        .......

        ::

          size(self)



        Get the shape.



        .............


        .......

        ::

          size(self, int axis)



        Get the size along a particular dimensions.



        .............



        """
        return _casadi.Sparsity_size(self, *args)


    def info(self, *args):
        """
        Obtain information about sparsity

        info(self) -> dict





        """
        return _casadi.Sparsity_info(self, *args)


    def to_file(self, *args):
        """
          Export sparsity pattern to file

          to_file(self, str filename, str format_hint)


        Supported formats: .mtx Matrix Market




        """
        return _casadi.Sparsity_to_file(self, *args)


    def from_file(*args):
        """


        from_file(str filename, str format_hint) -> Sparsity



        """
        return _casadi.Sparsity_from_file(*args)

    from_file = staticmethod(from_file)

    def serialize(self, *args):
        """
          Serialize an object.

          serialize(self) -> str
          serialize(self, casadi::SerializingStream & s)




        .......

        ::

          serialize(self, casadi::SerializingStream & s)



        Serialize an object.



        .............


        .......

        ::

          serialize(self)



        Serialize.



        .............



        """
        return _casadi.Sparsity_serialize(self, *args)


    def deserialize(*args):
        """


        deserialize(std::istream & stream) -> Sparsity
        deserialize(casadi::DeserializingStream & s) -> Sparsity
        deserialize(str s) -> Sparsity



        """
        return _casadi.Sparsity_deserialize(*args)

    deserialize = staticmethod(deserialize)

    def colind(self, *args):
        """
          Get a reference to the colindex of column cc (see class description)

          colind(self) -> [int]
          colind(self, int cc) -> int




        .......

        ::

          colind(self)



        Get the column index for each column Together with the row-vector, one
        obtains the sparsity pattern in the column compressed format.



        .............


        .......

        ::

          colind(self, int cc)



        Get a reference to the colindex of column cc (see class description)



        .............



        """
        return _casadi.Sparsity_colind(self, *args)


    def row(self, *args):
        """
          Get the row of a non-zero element.

          row(self) -> [int]
          row(self, int el) -> int




        .......

        ::

          row(self, int el)



        Get the row of a non-zero element.



        .............


        .......

        ::

          row(self)



        Get the row for each non-zero entry Together with the column-vector, this
        vector gives the sparsity of the matrix in sparse triplet format, and
        together with the colind vector, one obtains the sparsity in column
        compressed format.



        .............



        """
        return _casadi.Sparsity_row(self, *args)


    def get_col(self, *args):
        """
          Get the column for each non-zero entry Together with the row-vector, this

          get_col(self) -> [int]

        vector gives the sparsity of the matrix in sparse triplet format, i.e. the
        column and row for each non-zero elements.




        """
        return _casadi.Sparsity_get_col(self, *args)


    def resize(self, *args):
        """
        Resize.

        resize(self, int nrow, int ncol)





        """
        return _casadi.Sparsity_resize(self, *args)


    def add_nz(self, *args):
        """
          Get the index of a non-zero element Add the element if it does not exist and

          add_nz(self, int rr, int cc) -> int

        copy object if it's not unique.




        """
        return _casadi.Sparsity_add_nz(self, *args)


    def has_nz(self, *args):
        """
        Returns true if the pattern has a non-zero at location rr, cc.

        has_nz(self, int rr, int cc) -> bool





        """
        return _casadi.Sparsity_has_nz(self, *args)


    def get_nz(self, *args):
        """
          Get the nonzero index for a set of elements The index vector is used both

          get_nz(self) -> [int]
          get_nz(self, int rr, int cc) -> int
          get_nz(self, [int] rr, [int] cc) -> [int]

        for input and outputs and must be sorted by increasing nonzero index, i.e.
        column-wise. Elements not found in the sparsity pattern are set to -1.



        .......

        ::

          get_nz(self, int rr, int cc)



        Get the index of an existing non-zero element return -1 if the element does
        not exist.



        .............


        .......

        ::

          get_nz(self)



        Get the nonzero index for a set of elements The index vector is used both
        for input and outputs and must be sorted by increasing nonzero index, i.e.
        column-wise. Elements not found in the sparsity pattern are set to -1.



        .............


        .......

        ::

          get_nz(self, [int] rr, [int] cc)



        Get a set of non-zero element return -1 if the element does not exist.



        .............



        """
        return _casadi.Sparsity_get_nz(self, *args)


    def get_lower(self, *args):
        """
        Get nonzeros in lower triangular part.

        get_lower(self) -> [int]





        """
        return _casadi.Sparsity_get_lower(self, *args)


    def get_upper(self, *args):
        """
        Get nonzeros in upper triangular part.

        get_upper(self) -> [int]





        """
        return _casadi.Sparsity_get_upper(self, *args)


    def get_ccs(self, *args):
        """
        Get the sparsity in compressed column storage (CCS) format.

        get_ccs(self) -> ([int] OUTPUT, [int] OUTPUT)





        """
        return _casadi.Sparsity_get_ccs(self, *args)


    def get_crs(self, *args):
        """
        Get the sparsity in compressed row storage (CRS) format.

        get_crs(self) -> ([int] OUTPUT, [int] OUTPUT)





        """
        return _casadi.Sparsity_get_crs(self, *args)


    def get_triplet(self, *args):
        """
        Get the sparsity in sparse triplet format.

        get_triplet(self) -> ([int] OUTPUT, [int] OUTPUT)





        """
        return _casadi.Sparsity_get_triplet(self, *args)


    def sub(self, *args):
        """
          Get a set of elements.

          sub(self, [int] rr, Sparsity sp, bool ind1) -> (Sparsity , [int] OUTPUT)
          sub(self, [int] rr, [int] cc, bool ind1) -> (Sparsity , [int] OUTPUT)


        Returns the sparsity of the corresponding elements, with a mapping such that
        submatrix[k] = originalmatrix[mapping[k]]



        .......

        ::

          sub(self, [int] rr, Sparsity sp, bool ind1)



        Get a set of elements.

        Returns the sparsity of the corresponding elements, with a mapping such that
        submatrix[k] = originalmatrix[mapping[k]]



        .............


        .......

        ::

          sub(self, [int] rr, [int] cc, bool ind1)



        Get a submatrix.

        Returns the sparsity of the submatrix, with a mapping such that submatrix[k]
        = originalmatrix[mapping[k]]



        .............



        """
        return _casadi.Sparsity_sub(self, *args)


    def transpose(self, *args):
        """
          Transpose the matrix and get the reordering of the non-zero entries.

          transpose(self, bool invert_mapping) -> (Sparsity , [int] OUTPUT)


        Parameters:
        -----------

        mapping:  the non-zeros of the original matrix for each non-zero of the new
        matrix




        """
        return _casadi.Sparsity_transpose(self, *args)


    def is_transpose(self, *args):
        """
        Check if the sparsity is the transpose of another.

        is_transpose(self, Sparsity y) -> bool





        """
        return _casadi.Sparsity_is_transpose(self, *args)


    def is_reshape(self, *args):
        """
        Check if the sparsity is a reshape of another.

        is_reshape(self, Sparsity y) -> bool





        """
        return _casadi.Sparsity_is_reshape(self, *args)


    def combine(self, *args):
        """
          Combine two sparsity patterns Returns the new sparsity pattern as well as a

          combine(self, Sparsity y, bool f0x_is_zero, bool function0_is_zero) -> Sparsity

        mapping with the same length as the number of non-zero elements The mapping
        matrix contains the arguments for each nonzero, the first bit indicates if
        the first argument is nonzero, the second bit indicates if the second
        argument is nonzero (note that none of, one of or both of the arguments can
        be nonzero)




        """
        return _casadi.Sparsity_combine(self, *args)


    def unite(self, *args):
        """
        Union of two sparsity patterns.

        unite(self, Sparsity y) -> Sparsity





        """
        return _casadi.Sparsity_unite(self, *args)


    def __add__(self, *args):
        """


        __add__(self, Sparsity b) -> Sparsity



        """
        return _casadi.Sparsity___add__(self, *args)


    def intersect(self, *args):
        """
          Intersection of two sparsity patterns Returns the new sparsity pattern as

          intersect(self, Sparsity y) -> Sparsity

        well as a mapping with the same length as the number of non-zero elements
        The value is 1 if the non-zero comes from the first (i.e. this) object, 2 if
        it is from the second and 3 (i.e. 1 | 2) if from both.




        """
        return _casadi.Sparsity_intersect(self, *args)


    def __mul__(self, *args):
        """


        __mul__(self, Sparsity b) -> Sparsity



        """
        return _casadi.Sparsity___mul__(self, *args)


    def is_subset(self, *args):
        """
        Is subset?

        is_subset(self, Sparsity rhs) -> bool





        """
        return _casadi.Sparsity_is_subset(self, *args)


    def pattern_inverse(self, *args):
        """
        Take the inverse of a sparsity pattern; flip zeros and non-zeros.

        pattern_inverse(self) -> Sparsity





        """
        return _casadi.Sparsity_pattern_inverse(self, *args)


    def enlarge(self, *args):
        """
          Enlarge matrix Make the matrix larger by inserting empty rows and columns,

          enlarge(self, int nrow, int ncol, [int] rr, [int] cc, bool ind1)

        keeping the existing non-zeros.

        For the matrices A to B A(m, n) length(jj)=m , length(ii)=n B(nrow, ncol)

        A=enlarge(m, n, ii, jj) makes sure that

        B[jj, ii] == A




        """
        return _casadi.Sparsity_enlarge(self, *args)


    def enlargeRows(self, *args):
        """
        Enlarge the matrix along the first dimension (i.e. insert rows)

        enlargeRows(self, int nrow, [int] rr, bool ind1)





        """
        return _casadi.Sparsity_enlargeRows(self, *args)


    def enlargeColumns(self, *args):
        """
        Enlarge the matrix along the second dimension (i.e. insert columns)

        enlargeColumns(self, int ncol, [int] cc, bool ind1)





        """
        return _casadi.Sparsity_enlargeColumns(self, *args)


    def makeDense(self, *args):
        """
        Make a patten dense.

        makeDense(self) -> (Sparsity , [int] OUTPUT)





        """
        return _casadi.Sparsity_makeDense(self, *args)


    def erase(self, *args):
        """
          Erase elements of a matrix.

          erase(self, [int] rr, bool ind1) -> [int]
          erase(self, [int] rr, [int] cc, bool ind1) -> [int]




        .......

        ::

          erase(self, [int] rr, bool ind1)



        Erase elements of a matrix.



        .............


        .......

        ::

          erase(self, [int] rr, [int] cc, bool ind1)



        Erase rows and/or columns of a matrix.



        .............



        """
        return _casadi.Sparsity_erase(self, *args)


    def append(self, *args):
        """
        Append another sparsity patten vertically (NOTE: only efficient if vector)

        append(self, Sparsity sp)





        """
        return _casadi.Sparsity_append(self, *args)


    def appendColumns(self, *args):
        """
        Append another sparsity patten horizontally.

        appendColumns(self, Sparsity sp)





        """
        return _casadi.Sparsity_appendColumns(self, *args)


    def is_scalar(self, *args):
        """
        Is scalar?

        is_scalar(self, bool scalar_and_dense) -> bool





        """
        return _casadi.Sparsity_is_scalar(self, *args)


    def is_dense(self, *args):
        """
        Is dense?

        is_dense(self) -> bool





        """
        return _casadi.Sparsity_is_dense(self, *args)


    def is_row(self, *args):
        """
        Check if the pattern is a row vector (i.e. size1()==1)

        is_row(self) -> bool





        """
        return _casadi.Sparsity_is_row(self, *args)


    def is_column(self, *args):
        """
        Check if the pattern is a column vector (i.e. size2()==1)

        is_column(self) -> bool





        """
        return _casadi.Sparsity_is_column(self, *args)


    def is_vector(self, *args):
        """
        Check if the pattern is a row or column vector.

        is_vector(self) -> bool





        """
        return _casadi.Sparsity_is_vector(self, *args)


    def is_diag(self, *args):
        """
        Is diagonal?

        is_diag(self) -> bool





        """
        return _casadi.Sparsity_is_diag(self, *args)


    def is_square(self, *args):
        """
        Is square?

        is_square(self) -> bool





        """
        return _casadi.Sparsity_is_square(self, *args)


    def is_symmetric(self, *args):
        """
        Is symmetric?

        is_symmetric(self) -> bool





        """
        return _casadi.Sparsity_is_symmetric(self, *args)


    def is_triu(self, *args):
        """
        Is upper triangular?

        is_triu(self) -> bool





        """
        return _casadi.Sparsity_is_triu(self, *args)


    def is_tril(self, *args):
        """
        Is lower triangular?

        is_tril(self) -> bool





        """
        return _casadi.Sparsity_is_tril(self, *args)


    def is_singular(self, *args):
        """
        Check whether the sparsity-pattern indicates structural singularity.

        is_singular(self) -> bool





        """
        return _casadi.Sparsity_is_singular(self, *args)


    def rowsSequential(self, *args):
        """
          Do the rows appear sequentially on each column.

          rowsSequential(self, bool strictly) -> bool


        Parameters:
        -----------

        strictly:  if true, then do not allow multiple entries




        """
        return _casadi.Sparsity_rowsSequential(self, *args)


    def removeDuplicates(self, *args):
        """
          Remove duplicate entries.

          removeDuplicates(self) -> [int]


        The same indices will be removed from the mapping vector, which must have
        the same length as the number of nonzeros




        """
        return _casadi.Sparsity_removeDuplicates(self, *args)


    def etree(self, *args):
        """
          Calculate the elimination tree See Direct Methods for Sparse Linear Systems

          etree(self, bool ata) -> [int]

        by Davis (2006). If the parameter ata is false, the algorithm is equivalent
        to MATLAB's etree(A), except that the indices are zero- based. If ata is
        true, the algorithm is equivalent to MATLAB's etree(A, 'col').

        The implementation is a modified version of cs_etree in CSparse Copyright(c)
        Timothy A. Davis, 2006-2009 Licensed as a derivative work under the GNU LGPL




        """
        return _casadi.Sparsity_etree(self, *args)


    def ldl(self, *args):
        """
          Symbolic LDL factorization Returns the sparsity pattern of L^T.

          ldl(self, bool amd) -> (Sparsity , [int] OUTPUT)


        The implementation is a modified version of LDL Copyright(c) Timothy A.
        Davis, 2005-2013 Licensed as a derivative work under the GNU LGPL




        """
        return _casadi.Sparsity_ldl(self, *args)


    def qr_sparse(self, *args):
        """
          Symbolic QR factorization Returns the sparsity pattern of V (compact

          qr_sparse(self, bool amd) -> (Sparsity OUTPUT, Sparsity OUTPUT, [int] OUTPUT, [int] OUTPUT)

        representation of Q) and R as well as vectors needed for the numerical
        factorization and solution. The implementation is a modified version of
        CSparse Copyright(c) Timothy A. Davis, 2006-2009 Licensed as a derivative
        work under the GNU LGPL.




        """
        return _casadi.Sparsity_qr_sparse(self, *args)


    def dfs(self, *args):
        """
          Depth-first search on the adjacency graph of the sparsity See Direct Methods

          dfs(self, int j, int top, [int] pinv) -> (int , [int] INOUT, [int] INOUT, [bool] INOUT)

        for Sparse Linear Systems by Davis (2006).




        """
        return _casadi.Sparsity_dfs(self, *args)


    def scc(self, *args):
        """
          Find the strongly connected components of the bigraph defined by the

          scc(self) -> (int , [int] OUTPUT, [int] OUTPUT)

        sparsity pattern of a square matrix.

        See Direct Methods for Sparse Linear Systems by Davis (2006). Returns:
        Number of components

        Offset for each components (length: 1 + number of components)

        Indices for each components, component i has indices index[offset[i]], ...,
        index[offset[i+1]]

        In the case that the matrix is symmetric, the result has a particular
        interpretation: Given a symmetric matrix A and n = A.scc(p, r)

        => A[p, p] will appear block-diagonal with n blocks and with the indices of
        the block boundaries to be found in r.

        The implementation is a modified version of cs_scc in CSparse Copyright(c)
        Timothy A. Davis, 2006-2009 Licensed as a derivative work under the GNU LGPL




        """
        return _casadi.Sparsity_scc(self, *args)


    def btf(self, *args):
        """
          Calculate the block triangular form (BTF) See Direct Methods for Sparse

          btf(self) -> (int , [int] OUTPUT, [int] OUTPUT, [int] OUTPUT, [int] OUTPUT, [int] OUTPUT, [int] OUTPUT)

        Linear Systems by Davis (2006).

        The function computes the Dulmage-Mendelsohn decomposition, which allows you
        to reorder the rows and columns of a matrix to bring it into block
        triangular form (BTF).

        It will not consider the distance of off-diagonal elements to the diagonal:
        there is no guarantee you will get a block-diagonal matrix if you supply a
        randomly permuted block-diagonal matrix.

        If your matrix is symmetrical, this method is of limited use; permutation
        can make it non-symmetric.

        See:   scc  The implementation is a modified version of cs_dmperm in CSparse
        Copyright(c) Timothy A. Davis, 2006-2009 Licensed as a derivative work under
        the GNU LGPL




        """
        return _casadi.Sparsity_btf(self, *args)


    def amd(self, *args):
        """
          Approximate minimal degree preordering Fill-reducing ordering applied to the

          amd(self) -> [int]

        sparsity pattern of a linear system prior to factorization. The system must
        be symmetric, for an unsymmetric matrix A, first form the square of the
        pattern, A'*A.

        The implementation is a modified version of cs_amd in CSparse Copyright(c)
        Timothy A. Davis, 2006-2009 Licensed as a derivative work under the GNU LGPL




        """
        return _casadi.Sparsity_amd(self, *args)


    def find(self, *args):
        """
          Get the location of all non-zero elements as they would appear in a Dense

          find(self, bool ind1) -> [int]

        matrix A : DenseMatrix 4 x 3 B : SparseMatrix 4 x 3 , 5 structural non-
        zeros.

        k = A.find() A[k] will contain the elements of A that are non-zero in B

        Inverse of nonzeros.




        """
        return _casadi.Sparsity_find(self, *args)


    def uni_coloring(self, *args):
        """
          Perform a unidirectional coloring: A greedy distance-2 coloring algorithm

          uni_coloring(self, Sparsity AT, int cutoff) -> Sparsity

        (Algorithm 3.1 in A. H. GEBREMEDHIN, F. MANNE, A. POTHEN)




        """
        return _casadi.Sparsity_uni_coloring(self, *args)


    def star_coloring(self, *args):
        """
          Perform a star coloring of a symmetric matrix: A greedy distance-2 coloring

          star_coloring(self, int ordering, int cutoff) -> Sparsity

        algorithm Algorithm 4.1 in What Color Is Your Jacobian? Graph Coloring for
        Computing Derivatives A. H. GEBREMEDHIN, F. MANNE, A. POTHEN SIAM Rev.,
        47(4), 629705 (2006)

        Ordering options: None (0), largest first (1)




        """
        return _casadi.Sparsity_star_coloring(self, *args)


    def star_coloring2(self, *args):
        """
          Perform a star coloring of a symmetric matrix: A new greedy distance-2

          star_coloring2(self, int ordering, int cutoff) -> Sparsity

        coloring algorithm Algorithm 4.1 in NEW ACYCLIC AND STAR COLORING ALGORITHMS
        WITH APPLICATION TO COMPUTING HESSIANS A. H. GEBREMEDHIN, A. TARAFDAR, F.
        MANNE, A. POTHEN SIAM J. SCI. COMPUT. Vol. 29, No. 3, pp. 10421072 (2007)

        Ordering options: None (0), largest first (1)




        """
        return _casadi.Sparsity_star_coloring2(self, *args)


    def largest_first(self, *args):
        """
        Order the columns by decreasing degree.

        largest_first(self) -> [int]





        """
        return _casadi.Sparsity_largest_first(self, *args)


    def pmult(self, *args):
        """
          Permute rows and/or columns Multiply the sparsity with a permutation matrix

          pmult(self, [int] p, bool permute_rows, bool permute_columns, bool invert_permutation) -> Sparsity

        from the left and/or from the right P * A * trans(P), A * trans(P) or A *
        trans(P) with P defined by an index vector containing the row for each col.
        As an alternative, P can be transposed (inverted).




        """
        return _casadi.Sparsity_pmult(self, *args)


    def dim(self, *args):
        """
        Get the dimension as a string.

        dim(self, bool with_nz) -> str





        """
        return _casadi.Sparsity_dim(self, *args)


    def postfix_dim(self, *args):
        """
          Dimension string as a postfix to a name Rules:

          postfix_dim(self) -> str


        Dense and scalar: ""

        0-by-0: "[]"

        Dense column vector: "[5]"

        Dense matrix: "[5x10]"

        Otherwise: "[5x10,3nz]"




        """
        return _casadi.Sparsity_postfix_dim(self, *args)


    def repr_el(self, *args):
        """
        Describe the nonzero location k as a string.

        repr_el(self, int k) -> str





        """
        return _casadi.Sparsity_repr_el(self, *args)


    def spy(self, *args):
        """
        Print a textual representation of sparsity.

        spy(self)





        """
        return _casadi.Sparsity_spy(self, *args)


    def spy_matlab(self, *args):
        """
          Generate a script for Matlab or Octave which visualizes the sparsity using

          spy_matlab(self, str mfile)

        the spy command.




        """
        return _casadi.Sparsity_spy_matlab(self, *args)


    def export_code(self, *args):
        """
          Export matrix in specific language.

          export_code(self, str lang, dict options)


        lang: only 'matlab' supported for now

        ::

           * options:
           *   inline: Indicates if you want everything on a single line (default: False)
           *   name: Name of exported variable (default: 'sp')
           *   as_matrix: Matlab does not have a sparsity object. (default: false)
          *               With this option true, a numeric matrix will be constructed
           * 






        """
        return _casadi.Sparsity_export_code(self, *args)


    def type_name(*args):
        """


        type_name() -> str



        """
        return _casadi.Sparsity_type_name(*args)

    type_name = staticmethod(type_name)

    def hash(self, *args):
        """


        hash(self) -> std::size_t



        """
        return _casadi.Sparsity_hash(self, *args)


    def test_cast(*args):
        """


        test_cast(casadi::SharedObjectInternal const * ptr) -> bool



        """
        return _casadi.Sparsity_test_cast(*args)

    test_cast = staticmethod(test_cast)

    def kkt(*args):
        """


        kkt(Sparsity H, Sparsity J, bool with_x_diag, bool with_lam_g_diag) -> Sparsity



        """
        return _casadi.Sparsity_kkt(*args)

    kkt = staticmethod(kkt)

    def __setstate__(self, state):
        self.__init__(Sparsity.deserialize(state["serialization"]))

    def __getstate__(self):
        return {"serialization": self.serialize()}


    @property
    def shape(self):
        return (self.size1(),self.size2())

    @property
    def T(self):
        return _casadi.transpose(self)

    def __array__(self,*args,**kwargs):
        return DM.ones(self).full()


    def __init__(self, *args):
        """


          Sparsity(int dummy)
          Sparsity((int,int) rc)
          Sparsity(Sparsity other)
          Sparsity(int nrow, int ncol)
          Sparsity(int nrow, int ncol, [int] colind, [int] row, bool order_rows)


        .......

        ::

          Sparsity(Sparsity other)



        .............


        .......

        ::

          Sparsity(int nrow, int ncol)



        Pattern with all structural zeros.



        .............


        .......

        ::

          Sparsity(int nrow, int ncol, [int] colind, [int] row, bool order_rows)



        Construct from sparsity pattern vectors given in compressed column storage
        format.



        .............


        .......

        ::

          Sparsity(int dummy)



        Default constructor.



        .............


        .......

        ::

          Sparsity((int,int) rc)



        Create a sparse matrix with all structural zeros.



        .............



        """
        this = _casadi.new_Sparsity(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_Sparsity
Sparsity_swigregister = _casadi.Sparsity_swigregister
Sparsity_swigregister(Sparsity)

def Sparsity_scalar(*args):
    """
    Create a scalar sparsity pattern.

    scalar(bool dense_scalar) -> Sparsity





    """
    return _casadi.Sparsity_scalar(*args)

def Sparsity_dense(*args):
    """
    Create a dense rectangular sparsity pattern.

    dense(int nrow, int ncol) -> Sparsity
    dense((int,int) rc) -> Sparsity





    """
    return _casadi.Sparsity_dense(*args)

def Sparsity_unit(*args):
    """
      Create the sparsity pattern for a unit vector of length n and a nonzero on

      unit(int n, int el) -> Sparsity

    position el.




    """
    return _casadi.Sparsity_unit(*args)

def Sparsity_upper(*args):
    """


    upper(int n) -> Sparsity



    """
    return _casadi.Sparsity_upper(*args)

def Sparsity_lower(*args):
    """


    lower(int n) -> Sparsity



    """
    return _casadi.Sparsity_lower(*args)

def Sparsity_diag(*args):
    """
    Create diagonal sparsity pattern.

    diag(int nrow) -> Sparsity
    diag((int,int) rc) -> Sparsity
    diag(int nrow, int ncol) -> Sparsity





    """
    return _casadi.Sparsity_diag(*args)

def Sparsity_band(*args):
    """


    band(int n, int p) -> Sparsity



    """
    return _casadi.Sparsity_band(*args)

def Sparsity_banded(*args):
    """


    banded(int n, int p) -> Sparsity



    """
    return _casadi.Sparsity_banded(*args)

def Sparsity_rowcol(*args):
    """


    rowcol([int] row, [int] col, int nrow, int ncol) -> Sparsity



    """
    return _casadi.Sparsity_rowcol(*args)

def Sparsity_triplet(*args):
    """


    triplet(int nrow, int ncol, [int] row, [int] col) -> Sparsity
    triplet(int nrow, int ncol, [int] row, [int] col, bool invert_mapping) -> (Sparsity , [int] OUTPUT)



    """
    return _casadi.Sparsity_triplet(*args)

def Sparsity_nonzeros(*args):
    """


    nonzeros(int nrow, int ncol, [int] nz, bool ind1) -> Sparsity



    """
    return _casadi.Sparsity_nonzeros(*args)

def Sparsity_compressed(*args):
    """
      Create from a single vector containing the pattern in compressed column

      compressed([int] v, bool order_rows) -> Sparsity

    storage format: The format: The first two entries are the number of rows
    (nrow) and columns (ncol) The next ncol+1 entries are the column offsets
    (colind). Note that the last element, colind[ncol], gives the number of
    nonzeros The last colind[ncol] entries are the row indices




    """
    return _casadi.Sparsity_compressed(*args)

def Sparsity_from_file(*args):
    """


    from_file(str filename, str format_hint) -> Sparsity



    """
    return _casadi.Sparsity_from_file(*args)

def Sparsity_deserialize(*args):
    """


    deserialize(std::istream & stream) -> Sparsity
    deserialize(casadi::DeserializingStream & s) -> Sparsity
    deserialize(str s) -> Sparsity



    """
    return _casadi.Sparsity_deserialize(*args)

def Sparsity_type_name(*args):
    """


    type_name() -> str



    """
    return _casadi.Sparsity_type_name(*args)

def Sparsity_test_cast(*args):
    """


    test_cast(casadi::SharedObjectInternal const * ptr) -> bool



    """
    return _casadi.Sparsity_test_cast(*args)

def Sparsity_kkt(*args):
    """


    kkt(Sparsity H, Sparsity J, bool with_x_diag, bool with_lam_g_diag) -> Sparsity



    """
    return _casadi.Sparsity_kkt(*args)


def hash_combine(*args):
    """
      Generate a hash value incrementally (function taken from boost)

      hash_combine(std::size_t & seed, [int] v)
      hash_combine(std::size_t & seed, casadi_int const * v, std::size_t sz)




    .......

    ::

      hash_combine(std::size_t & seed, [int] v)



    Generate a hash value incrementally (function taken from boost)



    .............


    .......

    ::

      hash_combine(std::size_t & seed, casadi_int const * v, std::size_t sz)



    Generate a hash value incrementally, array.



    .............



    """
    return _casadi.hash_combine(*args)

def hash_sparsity(*args):
    """


      hash_sparsity(int nrow, int ncol, casadi_int const * colind, casadi_int const * row) -> std::size_t
      hash_sparsity(int nrow, int ncol, [int] colind, [int] row) -> std::size_t


    .......

    ::

      hash_sparsity(int nrow, int ncol, casadi_int const * colind, casadi_int const * row)



    .............


    .......

    ::

      hash_sparsity(int nrow, int ncol, [int] colind, [int] row)



    Hash a sparsity pattern.



    .............



    """
    return _casadi.hash_sparsity(*args)
class Slice(PrintableCommon):
    """
      Class representing a Slice.



    Note that Python or Octave do not need to use this class. They can just use
    slicing utility from the host language ( M[0:6] in Python, M(1:7) )

    C++ includes: slice.hpp 


    """

    __swig_setmethods__ = {}
    for _s in [PrintableCommon]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Slice, name, value)
    __swig_getmethods__ = {}
    for _s in [PrintableCommon]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Slice, name)
    __repr__ = _swig_repr
    __swig_getmethods__["start"] = _casadi.Slice_start_get
    if _newclass:
        start = _swig_property(_casadi.Slice_start_get)
    __swig_getmethods__["stop"] = _casadi.Slice_stop_get
    if _newclass:
        stop = _swig_property(_casadi.Slice_stop_get)
    __swig_getmethods__["step"] = _casadi.Slice_step_get
    if _newclass:
        step = _swig_property(_casadi.Slice_step_get)

    def all(self, *args):
        """
          Get a vector of indices (nested slice)

          all(self) -> [int]
          all(self, int len, bool ind1) -> [int]
          all(self, Slice outer, int len) -> [int]




        .......

        ::

          all(self)
          all(self, int len, bool ind1)



        Get a vector of indices.



        .............


        .......

        ::

          all(self, Slice outer, int len)



        Get a vector of indices (nested slice)



        .............



        """
        return _casadi.Slice_all(self, *args)


    def size(self, *args):
        """
        Get number of elements.

        size(self) -> size_t





        """
        return _casadi.Slice_size(self, *args)


    def is_empty(self, *args):
        """
        Check if slice is empty.

        is_empty(self) -> bool





        """
        return _casadi.Slice_is_empty(self, *args)


    def is_scalar(self, *args):
        """
        Is the slice a scalar.

        is_scalar(self, int len) -> bool





        """
        return _casadi.Slice_is_scalar(self, *args)


    def scalar(self, *args):
        """
        Get scalar (if is_scalar)

        scalar(self, int len) -> int





        """
        return _casadi.Slice_scalar(self, *args)


    def __eq__(self, *args):
        """


        __eq__(self, Slice other) -> bool



        """
        return _casadi.Slice___eq__(self, *args)


    def __ne__(self, *args):
        """


        __ne__(self, Slice other) -> bool



        """
        return _casadi.Slice___ne__(self, *args)


    def apply(self, *args):
        """
        Apply concrete length.

        apply(self, int len, bool ind1) -> Slice





        """
        return _casadi.Slice_apply(self, *args)


    def __sub__(self, *args):
        """


        __sub__(self, int i) -> Slice



        """
        return _casadi.Slice___sub__(self, *args)


    def __mul__(self, *args):
        """


        __mul__(self, int i) -> Slice



        """
        return _casadi.Slice___mul__(self, *args)


    def type_name(self, *args):
        """
        Get name of the class.

        type_name(self) -> str





        """
        return _casadi.Slice_type_name(self, *args)


    def disp(self, *args):
        """
        Print a description of the object.

        disp(self, bool more)





        """
        return _casadi.Slice_disp(self, *args)


    def str(self, *args):
        """
        Get string representation.

        str(self, bool more) -> str





        """
        return _casadi.Slice_str(self, *args)


    def info(self, *args):
        """
        Obtain information

        info(self) -> dict





        """
        return _casadi.Slice_info(self, *args)


    def serialize(self, *args):
        """
        Serialize an object.

        serialize(self, casadi::SerializingStream & s)





        """
        return _casadi.Slice_serialize(self, *args)


    def deserialize(*args):
        """


        deserialize(casadi::DeserializingStream & s) -> Slice



        """
        return _casadi.Slice_deserialize(*args)

    deserialize = staticmethod(deserialize)

    def __init__(self, *args):
        """


          Slice()
          Slice(int i, bool ind1)
          Slice(Slice other)
          Slice(int start, int stop, int step)
          Slice(int start, int stop, int step)
          Slice(int start, int stop, int step)
          Slice(int start, int stop, int step)


        .......

        ::

          Slice()



        Default constructor - all elements.



        .............


        .......

        ::

          Slice(Slice other)
          Slice(int start, int stop, int step)
          Slice(int start, int stop, int step)
          Slice(int start, int stop, int step)



        .............


        .......

        ::

          Slice(int start, int stop, int step)



        A slice.



        .............


        .......

        ::

          Slice(int i, bool ind1)



        A single element (explicit to avoid ambiguity with IM overload.



        .............



        """
        this = _casadi.new_Slice(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_Slice
Slice_swigregister = _casadi.Slice_swigregister
Slice_swigregister(Slice)

def Slice_deserialize(*args):
    """


    deserialize(casadi::DeserializingStream & s) -> Slice



    """
    return _casadi.Slice_deserialize(*args)


def to_slice(*args):
    """
    Construct from an index vector (requires is_slice(v) to be true)

    to_slice([int] v, bool ind1) -> Slice





    """
    return _casadi.to_slice(*args)

def to_slice2(*args):
    """
      Construct nested slices from an index vector (requires is_slice2(v) to be

      to_slice2([int] v) -> std::pair< casadi::Slice,casadi::Slice >

    true)




    """
    return _casadi.to_slice2(*args)

def is_slice(*args):
    """
    Check if an index vector can be represented more efficiently as a slice.

    is_slice([int] v, bool ind1) -> bool





    """
    return _casadi.is_slice(*args)

def is_slice2(*args):
    """
      Check if an index vector can be represented more efficiently as two nested

      is_slice2([int] v) -> bool

    slices.




    """
    return _casadi.is_slice2(*args)
class GenericMatrixCommon(_object):
    """
      Matrix base class.

      GenericMatrixCommon() -> 


    This is a common base class for MX and Matrix<>, introducing a uniform
    syntax and implementing common functionality using the curiously recurring
    template pattern (CRTP) idiom.  The class is designed with the idea that
    "everything is a matrix", that is, also scalars and vectors. This
    philosophy makes it easy to use and to interface in particularly with Python
    and Matlab/Octave.  The syntax tries to stay as close as possible to the
    ublas syntax when it comes to vector/matrix operations.  Index starts with
    0. Index vec happens as follows: (rr, cc) -> k = rr+cc*size1() Vectors are
    column vectors.  The storage format is Compressed Column Storage (CCS),
    similar to that used for sparse matrices in Matlab, but unlike this format,
    we do allow for elements to be structurally non-zero but numerically zero.
    The sparsity pattern, which is reference counted and cached, can be accessed
    with Sparsity& sparsity() Joel Andersson

    C++ includes: generic_matrix.hpp 


    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GenericMatrixCommon, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GenericMatrixCommon, name)
    __repr__ = _swig_repr

    def __mldivide__(x, y): return _casadi.mldivide(x, y)
    def __rmldivide__(y, x): return _casadi.mldivide(x, y)
    def __mrdivide__(x, y): return _casadi.mrdivide(x, y)
    def __rmrdivide__(y, x): return _casadi.mrdivide(x, y)
    def __mpower__(x, y): return _casadi.mpower(x, y)
    def __rmpower__(y, x): return _casadi.mpower(x, y)


    def __init__(self, *args):
        """


        GenericMatrixCommon()
        GenericMatrixCommon(GenericMatrixCommon other)



        """
        this = _casadi.new_GenericMatrixCommon(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_GenericMatrixCommon
GenericMatrixCommon_swigregister = _casadi.GenericMatrixCommon_swigregister
GenericMatrixCommon_swigregister(GenericMatrixCommon)


def index_interp1d(*args):
    """


    index_interp1d([float] x, float xq, bool equidistant) -> float



    """
    return _casadi.index_interp1d(*args)
class GenDM(GenericMatrixCommon, SparsityInterfaceCommon):
    """





    """

    __swig_setmethods__ = {}
    for _s in [GenericMatrixCommon, SparsityInterfaceCommon]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GenDM, name, value)
    __swig_getmethods__ = {}
    for _s in [GenericMatrixCommon, SparsityInterfaceCommon]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GenDM, name)
    __repr__ = _swig_repr

    def nnz(self, *args):
        """
        Get the number of (structural) non-zero elements.

        nnz(self) -> int





        """
        return _casadi.GenDM_nnz(self, *args)


    def nnz_lower(self, *args):
        """
        Get the number of non-zeros in the lower triangular half.

        nnz_lower(self) -> int





        """
        return _casadi.GenDM_nnz_lower(self, *args)


    def nnz_upper(self, *args):
        """
        Get the number of non-zeros in the upper triangular half.

        nnz_upper(self) -> int





        """
        return _casadi.GenDM_nnz_upper(self, *args)


    def nnz_diag(self, *args):
        """
        Get get the number of non-zeros on the diagonal.

        nnz_diag(self) -> int





        """
        return _casadi.GenDM_nnz_diag(self, *args)


    def numel(self, *args):
        """
        Get the number of elements.

        numel(self) -> int





        """
        return _casadi.GenDM_numel(self, *args)


    def size1(self, *args):
        """
        Get the first dimension (i.e. number of rows)

        size1(self) -> int





        """
        return _casadi.GenDM_size1(self, *args)


    def rows(self, *args):
        """
        Get the number of rows, Octave-style syntax.

        rows(self) -> int





        """
        return _casadi.GenDM_rows(self, *args)


    def size2(self, *args):
        """
        Get the second dimension (i.e. number of columns)

        size2(self) -> int





        """
        return _casadi.GenDM_size2(self, *args)


    def columns(self, *args):
        """
        Get the number of columns, Octave-style syntax.

        columns(self) -> int





        """
        return _casadi.GenDM_columns(self, *args)


    def dim(self, *args):
        """
          Get string representation of dimensions. The representation is e.g. "4x5"

          dim(self, bool with_nz) -> str

        or "4x5,10nz".




        """
        return _casadi.GenDM_dim(self, *args)


    def size(self, *args):
        """
          Get the size along a particular dimensions.

          size(self) -> (int,int)
          size(self, int axis) -> int




        .......

        ::

          size(self)



        Get the shape.



        .............


        .......

        ::

          size(self, int axis)



        Get the size along a particular dimensions.



        .............



        """
        return _casadi.GenDM_size(self, *args)


    def is_empty(self, *args):
        """
          Check if the sparsity is empty, i.e. if one of the dimensions is zero (or

          is_empty(self, bool both) -> bool

        optionally both dimensions)




        """
        return _casadi.GenDM_is_empty(self, *args)


    def is_dense(self, *args):
        """
        Check if the matrix expression is dense.

        is_dense(self) -> bool





        """
        return _casadi.GenDM_is_dense(self, *args)


    def is_scalar(self, *args):
        """
        Check if the matrix expression is scalar.

        is_scalar(self, bool scalar_and_dense) -> bool





        """
        return _casadi.GenDM_is_scalar(self, *args)


    def is_square(self, *args):
        """
        Check if the matrix expression is square.

        is_square(self) -> bool





        """
        return _casadi.GenDM_is_square(self, *args)


    def is_vector(self, *args):
        """
        Check if the matrix is a row or column vector.

        is_vector(self) -> bool





        """
        return _casadi.GenDM_is_vector(self, *args)


    def is_row(self, *args):
        """
        Check if the matrix is a row vector (i.e. size1()==1)

        is_row(self) -> bool





        """
        return _casadi.GenDM_is_row(self, *args)


    def is_column(self, *args):
        """
        Check if the matrix is a column vector (i.e. size2()==1)

        is_column(self) -> bool





        """
        return _casadi.GenDM_is_column(self, *args)


    def is_triu(self, *args):
        """
        Check if the matrix is upper triangular.

        is_triu(self) -> bool





        """
        return _casadi.GenDM_is_triu(self, *args)


    def is_tril(self, *args):
        """
        Check if the matrix is lower triangular.

        is_tril(self) -> bool





        """
        return _casadi.GenDM_is_tril(self, *args)


    def row(self, *args):
        """
        Get the sparsity pattern. See the Sparsity class for details.

        row(self) -> [int]
        row(self, int el) -> int





        """
        return _casadi.GenDM_row(self, *args)


    def colind(self, *args):
        """
        Get the sparsity pattern. See the Sparsity class for details.

        colind(self) -> [int]
        colind(self, int col) -> int





        """
        return _casadi.GenDM_colind(self, *args)


    def sparsity(self, *args):
        """
        Get the sparsity pattern.

        sparsity(self) -> Sparsity





        """
        return _casadi.GenDM_sparsity(self, *args)


    def sym(*args):
        """
          Create a vector of length r of vectors of length p with nrow-by-ncol

          sym(str name, int nrow, int ncol) -> DM
          sym(str name, (int,int) rc) -> DM
          sym(str name, Sparsity sp) -> DM
          sym(str name, Sparsity sp, int p) -> [DM]
          sym(str name, int nrow, int ncol, int p) -> [DM]
          sym(str name, Sparsity sp, int p, int r) -> [[DM]]
          sym(str name, int nrow, int ncol, int p, int r) -> [[DM]]

        symbolic primitives.



        .......

        ::

          sym(str name, (int,int) rc)



        Construct a symbolic primitive with given dimensions.



        .............


        .......

        ::

          sym(str name, int nrow, int ncol, int p)



        Create a vector of length p with nrow-by-ncol symbolic primitives.



        .............


        .......

        ::

          sym(str name, Sparsity sp, int p, int r)



        Create a vector of length r of vectors of length p with symbolic primitives
        with given sparsity.



        .............


        .......

        ::

          sym(str name, int nrow, int ncol, int p, int r)



        Create a vector of length r of vectors of length p with nrow-by-ncol
        symbolic primitives.



        .............


        .......

        ::

          sym(str name, Sparsity sp)



        Create symbolic primitive with a given sparsity pattern.



        .............


        .......

        ::

          sym(str name, int nrow, int ncol)



        Create an nrow-by-ncol symbolic primitive.



        .............


        .......

        ::

          sym(str name, Sparsity sp, int p)



        Create a vector of length p with with matrices with symbolic primitives of
        given sparsity.



        .............



        """
        return _casadi.GenDM_sym(*args)

    sym = staticmethod(sym)

    def zeros(*args):
        """
          Create a dense matrix or a matrix with specified sparsity with all entries

          zeros(int nrow, int ncol) -> DM
          zeros((int,int) rc) -> DM
          zeros(Sparsity sp) -> DM

        zero.




        """
        return _casadi.GenDM_zeros(*args)

    zeros = staticmethod(zeros)

    def ones(*args):
        """
          Create a dense matrix or a matrix with specified sparsity with all entries

          ones(int nrow, int ncol) -> DM
          ones((int,int) rc) -> DM
          ones(Sparsity sp) -> DM

        one.




        """
        return _casadi.GenDM_ones(*args)

    ones = staticmethod(ones)

    def __init__(self, *args):
        """


        GenDM()
        GenDM(GenDM other)



        """
        this = _casadi.new_GenDM(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_GenDM
GenDM_swigregister = _casadi.GenDM_swigregister
GenDM_swigregister(GenDM)

def GenDM_sym(*args):
    """
      Create a vector of length r of vectors of length p with nrow-by-ncol

      sym(str name, int nrow, int ncol) -> DM
      sym(str name, (int,int) rc) -> DM
      sym(str name, Sparsity sp) -> DM
      sym(str name, Sparsity sp, int p) -> [DM]
      sym(str name, int nrow, int ncol, int p) -> [DM]
      sym(str name, Sparsity sp, int p, int r) -> [[DM]]
      sym(str name, int nrow, int ncol, int p, int r) -> [[DM]]

    symbolic primitives.



    .......

    ::

      sym(str name, (int,int) rc)



    Construct a symbolic primitive with given dimensions.



    .............


    .......

    ::

      sym(str name, int nrow, int ncol, int p)



    Create a vector of length p with nrow-by-ncol symbolic primitives.



    .............


    .......

    ::

      sym(str name, Sparsity sp, int p, int r)



    Create a vector of length r of vectors of length p with symbolic primitives
    with given sparsity.



    .............


    .......

    ::

      sym(str name, int nrow, int ncol, int p, int r)



    Create a vector of length r of vectors of length p with nrow-by-ncol
    symbolic primitives.



    .............


    .......

    ::

      sym(str name, Sparsity sp)



    Create symbolic primitive with a given sparsity pattern.



    .............


    .......

    ::

      sym(str name, int nrow, int ncol)



    Create an nrow-by-ncol symbolic primitive.



    .............


    .......

    ::

      sym(str name, Sparsity sp, int p)



    Create a vector of length p with with matrices with symbolic primitives of
    given sparsity.



    .............



    """
    return _casadi.GenDM_sym(*args)

def GenDM_zeros(*args):
    """
      Create a dense matrix or a matrix with specified sparsity with all entries

      zeros(int nrow, int ncol) -> DM
      zeros((int,int) rc) -> DM
      zeros(Sparsity sp) -> DM

    zero.




    """
    return _casadi.GenDM_zeros(*args)

def GenDM_ones(*args):
    """
      Create a dense matrix or a matrix with specified sparsity with all entries

      ones(int nrow, int ncol) -> DM
      ones((int,int) rc) -> DM
      ones(Sparsity sp) -> DM

    one.




    """
    return _casadi.GenDM_ones(*args)

class GenSX(GenericMatrixCommon, SparsityInterfaceCommon):
    """





    """

    __swig_setmethods__ = {}
    for _s in [GenericMatrixCommon, SparsityInterfaceCommon]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GenSX, name, value)
    __swig_getmethods__ = {}
    for _s in [GenericMatrixCommon, SparsityInterfaceCommon]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GenSX, name)
    __repr__ = _swig_repr

    def nnz(self, *args):
        """
        Get the number of (structural) non-zero elements.

        nnz(self) -> int





        """
        return _casadi.GenSX_nnz(self, *args)


    def nnz_lower(self, *args):
        """
        Get the number of non-zeros in the lower triangular half.

        nnz_lower(self) -> int





        """
        return _casadi.GenSX_nnz_lower(self, *args)


    def nnz_upper(self, *args):
        """
        Get the number of non-zeros in the upper triangular half.

        nnz_upper(self) -> int





        """
        return _casadi.GenSX_nnz_upper(self, *args)


    def nnz_diag(self, *args):
        """
        Get get the number of non-zeros on the diagonal.

        nnz_diag(self) -> int





        """
        return _casadi.GenSX_nnz_diag(self, *args)


    def numel(self, *args):
        """
        Get the number of elements.

        numel(self) -> int





        """
        return _casadi.GenSX_numel(self, *args)


    def size1(self, *args):
        """
        Get the first dimension (i.e. number of rows)

        size1(self) -> int





        """
        return _casadi.GenSX_size1(self, *args)


    def rows(self, *args):
        """
        Get the number of rows, Octave-style syntax.

        rows(self) -> int





        """
        return _casadi.GenSX_rows(self, *args)


    def size2(self, *args):
        """
        Get the second dimension (i.e. number of columns)

        size2(self) -> int





        """
        return _casadi.GenSX_size2(self, *args)


    def columns(self, *args):
        """
        Get the number of columns, Octave-style syntax.

        columns(self) -> int





        """
        return _casadi.GenSX_columns(self, *args)


    def dim(self, *args):
        """
          Get string representation of dimensions. The representation is e.g. "4x5"

          dim(self, bool with_nz) -> str

        or "4x5,10nz".




        """
        return _casadi.GenSX_dim(self, *args)


    def size(self, *args):
        """
          Get the size along a particular dimensions.

          size(self) -> (int,int)
          size(self, int axis) -> int




        .......

        ::

          size(self)



        Get the shape.



        .............


        .......

        ::

          size(self, int axis)



        Get the size along a particular dimensions.



        .............



        """
        return _casadi.GenSX_size(self, *args)


    def is_empty(self, *args):
        """
          Check if the sparsity is empty, i.e. if one of the dimensions is zero (or

          is_empty(self, bool both) -> bool

        optionally both dimensions)




        """
        return _casadi.GenSX_is_empty(self, *args)


    def is_dense(self, *args):
        """
        Check if the matrix expression is dense.

        is_dense(self) -> bool





        """
        return _casadi.GenSX_is_dense(self, *args)


    def is_scalar(self, *args):
        """
        Check if the matrix expression is scalar.

        is_scalar(self, bool scalar_and_dense) -> bool





        """
        return _casadi.GenSX_is_scalar(self, *args)


    def is_square(self, *args):
        """
        Check if the matrix expression is square.

        is_square(self) -> bool





        """
        return _casadi.GenSX_is_square(self, *args)


    def is_vector(self, *args):
        """
        Check if the matrix is a row or column vector.

        is_vector(self) -> bool





        """
        return _casadi.GenSX_is_vector(self, *args)


    def is_row(self, *args):
        """
        Check if the matrix is a row vector (i.e. size1()==1)

        is_row(self) -> bool





        """
        return _casadi.GenSX_is_row(self, *args)


    def is_column(self, *args):
        """
        Check if the matrix is a column vector (i.e. size2()==1)

        is_column(self) -> bool





        """
        return _casadi.GenSX_is_column(self, *args)


    def is_triu(self, *args):
        """
        Check if the matrix is upper triangular.

        is_triu(self) -> bool





        """
        return _casadi.GenSX_is_triu(self, *args)


    def is_tril(self, *args):
        """
        Check if the matrix is lower triangular.

        is_tril(self) -> bool





        """
        return _casadi.GenSX_is_tril(self, *args)


    def row(self, *args):
        """
        Get the sparsity pattern. See the Sparsity class for details.

        row(self) -> [int]
        row(self, int el) -> int





        """
        return _casadi.GenSX_row(self, *args)


    def colind(self, *args):
        """
        Get the sparsity pattern. See the Sparsity class for details.

        colind(self) -> [int]
        colind(self, int col) -> int





        """
        return _casadi.GenSX_colind(self, *args)


    def sparsity(self, *args):
        """
        Get the sparsity pattern.

        sparsity(self) -> Sparsity





        """
        return _casadi.GenSX_sparsity(self, *args)


    def sym(*args):
        """
          Create a vector of length r of vectors of length p with nrow-by-ncol

          sym(str name, int nrow, int ncol) -> SX
          sym(str name, (int,int) rc) -> SX
          sym(str name, Sparsity sp) -> SX
          sym(str name, Sparsity sp, int p) -> [SX]
          sym(str name, int nrow, int ncol, int p) -> [SX]
          sym(str name, Sparsity sp, int p, int r) -> [[SX]]
          sym(str name, int nrow, int ncol, int p, int r) -> [[SX]]

        symbolic primitives.



        .......

        ::

          sym(str name, (int,int) rc)



        Construct a symbolic primitive with given dimensions.



        .............


        .......

        ::

          sym(str name, int nrow, int ncol, int p)



        Create a vector of length p with nrow-by-ncol symbolic primitives.



        .............


        .......

        ::

          sym(str name, Sparsity sp, int p, int r)



        Create a vector of length r of vectors of length p with symbolic primitives
        with given sparsity.



        .............


        .......

        ::

          sym(str name, int nrow, int ncol, int p, int r)



        Create a vector of length r of vectors of length p with nrow-by-ncol
        symbolic primitives.



        .............


        .......

        ::

          sym(str name, Sparsity sp)



        Create symbolic primitive with a given sparsity pattern.



        .............


        .......

        ::

          sym(str name, int nrow, int ncol)



        Create an nrow-by-ncol symbolic primitive.



        .............


        .......

        ::

          sym(str name, Sparsity sp, int p)



        Create a vector of length p with with matrices with symbolic primitives of
        given sparsity.



        .............



        """
        return _casadi.GenSX_sym(*args)

    sym = staticmethod(sym)

    def zeros(*args):
        """
          Create a dense matrix or a matrix with specified sparsity with all entries

          zeros(int nrow, int ncol) -> SX
          zeros((int,int) rc) -> SX
          zeros(Sparsity sp) -> SX

        zero.




        """
        return _casadi.GenSX_zeros(*args)

    zeros = staticmethod(zeros)

    def ones(*args):
        """
          Create a dense matrix or a matrix with specified sparsity with all entries

          ones(int nrow, int ncol) -> SX
          ones((int,int) rc) -> SX
          ones(Sparsity sp) -> SX

        one.




        """
        return _casadi.GenSX_ones(*args)

    ones = staticmethod(ones)

    def __init__(self, *args):
        """


        GenSX()
        GenSX(GenSX other)



        """
        this = _casadi.new_GenSX(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_GenSX
GenSX_swigregister = _casadi.GenSX_swigregister
GenSX_swigregister(GenSX)

def GenSX_sym(*args):
    """
      Create a vector of length r of vectors of length p with nrow-by-ncol

      sym(str name, int nrow, int ncol) -> SX
      sym(str name, (int,int) rc) -> SX
      sym(str name, Sparsity sp) -> SX
      sym(str name, Sparsity sp, int p) -> [SX]
      sym(str name, int nrow, int ncol, int p) -> [SX]
      sym(str name, Sparsity sp, int p, int r) -> [[SX]]
      sym(str name, int nrow, int ncol, int p, int r) -> [[SX]]

    symbolic primitives.



    .......

    ::

      sym(str name, (int,int) rc)



    Construct a symbolic primitive with given dimensions.



    .............


    .......

    ::

      sym(str name, int nrow, int ncol, int p)



    Create a vector of length p with nrow-by-ncol symbolic primitives.



    .............


    .......

    ::

      sym(str name, Sparsity sp, int p, int r)



    Create a vector of length r of vectors of length p with symbolic primitives
    with given sparsity.



    .............


    .......

    ::

      sym(str name, int nrow, int ncol, int p, int r)



    Create a vector of length r of vectors of length p with nrow-by-ncol
    symbolic primitives.



    .............


    .......

    ::

      sym(str name, Sparsity sp)



    Create symbolic primitive with a given sparsity pattern.



    .............


    .......

    ::

      sym(str name, int nrow, int ncol)



    Create an nrow-by-ncol symbolic primitive.



    .............


    .......

    ::

      sym(str name, Sparsity sp, int p)



    Create a vector of length p with with matrices with symbolic primitives of
    given sparsity.



    .............



    """
    return _casadi.GenSX_sym(*args)

def GenSX_zeros(*args):
    """
      Create a dense matrix or a matrix with specified sparsity with all entries

      zeros(int nrow, int ncol) -> SX
      zeros((int,int) rc) -> SX
      zeros(Sparsity sp) -> SX

    zero.




    """
    return _casadi.GenSX_zeros(*args)

def GenSX_ones(*args):
    """
      Create a dense matrix or a matrix with specified sparsity with all entries

      ones(int nrow, int ncol) -> SX
      ones((int,int) rc) -> SX
      ones(Sparsity sp) -> SX

    one.




    """
    return _casadi.GenSX_ones(*args)

class GenMX(GenericMatrixCommon, SparsityInterfaceCommon):
    """





    """

    __swig_setmethods__ = {}
    for _s in [GenericMatrixCommon, SparsityInterfaceCommon]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GenMX, name, value)
    __swig_getmethods__ = {}
    for _s in [GenericMatrixCommon, SparsityInterfaceCommon]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GenMX, name)
    __repr__ = _swig_repr

    def nnz(self, *args):
        """
        Get the number of (structural) non-zero elements.

        nnz(self) -> int





        """
        return _casadi.GenMX_nnz(self, *args)


    def nnz_lower(self, *args):
        """
        Get the number of non-zeros in the lower triangular half.

        nnz_lower(self) -> int





        """
        return _casadi.GenMX_nnz_lower(self, *args)


    def nnz_upper(self, *args):
        """
        Get the number of non-zeros in the upper triangular half.

        nnz_upper(self) -> int





        """
        return _casadi.GenMX_nnz_upper(self, *args)


    def nnz_diag(self, *args):
        """
        Get get the number of non-zeros on the diagonal.

        nnz_diag(self) -> int





        """
        return _casadi.GenMX_nnz_diag(self, *args)


    def numel(self, *args):
        """
        Get the number of elements.

        numel(self) -> int





        """
        return _casadi.GenMX_numel(self, *args)


    def size1(self, *args):
        """
        Get the first dimension (i.e. number of rows)

        size1(self) -> int





        """
        return _casadi.GenMX_size1(self, *args)


    def rows(self, *args):
        """
        Get the number of rows, Octave-style syntax.

        rows(self) -> int





        """
        return _casadi.GenMX_rows(self, *args)


    def size2(self, *args):
        """
        Get the second dimension (i.e. number of columns)

        size2(self) -> int





        """
        return _casadi.GenMX_size2(self, *args)


    def columns(self, *args):
        """
        Get the number of columns, Octave-style syntax.

        columns(self) -> int





        """
        return _casadi.GenMX_columns(self, *args)


    def dim(self, *args):
        """
          Get string representation of dimensions. The representation is e.g. "4x5"

          dim(self, bool with_nz) -> str

        or "4x5,10nz".




        """
        return _casadi.GenMX_dim(self, *args)


    def size(self, *args):
        """
          Get the size along a particular dimensions.

          size(self) -> (int,int)
          size(self, int axis) -> int




        .......

        ::

          size(self)



        Get the shape.



        .............


        .......

        ::

          size(self, int axis)



        Get the size along a particular dimensions.



        .............



        """
        return _casadi.GenMX_size(self, *args)


    def is_empty(self, *args):
        """
          Check if the sparsity is empty, i.e. if one of the dimensions is zero (or

          is_empty(self, bool both) -> bool

        optionally both dimensions)




        """
        return _casadi.GenMX_is_empty(self, *args)


    def is_dense(self, *args):
        """
        Check if the matrix expression is dense.

        is_dense(self) -> bool





        """
        return _casadi.GenMX_is_dense(self, *args)


    def is_scalar(self, *args):
        """
        Check if the matrix expression is scalar.

        is_scalar(self, bool scalar_and_dense) -> bool





        """
        return _casadi.GenMX_is_scalar(self, *args)


    def is_square(self, *args):
        """
        Check if the matrix expression is square.

        is_square(self) -> bool





        """
        return _casadi.GenMX_is_square(self, *args)


    def is_vector(self, *args):
        """
        Check if the matrix is a row or column vector.

        is_vector(self) -> bool





        """
        return _casadi.GenMX_is_vector(self, *args)


    def is_row(self, *args):
        """
        Check if the matrix is a row vector (i.e. size1()==1)

        is_row(self) -> bool





        """
        return _casadi.GenMX_is_row(self, *args)


    def is_column(self, *args):
        """
        Check if the matrix is a column vector (i.e. size2()==1)

        is_column(self) -> bool





        """
        return _casadi.GenMX_is_column(self, *args)


    def is_triu(self, *args):
        """
        Check if the matrix is upper triangular.

        is_triu(self) -> bool





        """
        return _casadi.GenMX_is_triu(self, *args)


    def is_tril(self, *args):
        """
        Check if the matrix is lower triangular.

        is_tril(self) -> bool





        """
        return _casadi.GenMX_is_tril(self, *args)


    def row(self, *args):
        """
        Get the sparsity pattern. See the Sparsity class for details.

        row(self) -> [int]
        row(self, int el) -> int





        """
        return _casadi.GenMX_row(self, *args)


    def colind(self, *args):
        """
        Get the sparsity pattern. See the Sparsity class for details.

        colind(self) -> [int]
        colind(self, int col) -> int





        """
        return _casadi.GenMX_colind(self, *args)


    def sparsity(self, *args):
        """
        Get the sparsity pattern.

        sparsity(self) -> Sparsity





        """
        return _casadi.GenMX_sparsity(self, *args)


    def sym(*args):
        """
          Create a vector of length r of vectors of length p with nrow-by-ncol

          sym(str name, int nrow, int ncol) -> MX
          sym(str name, (int,int) rc) -> MX
          sym(str name, Sparsity sp) -> MX
          sym(str name, Sparsity sp, int p) -> [MX]
          sym(str name, int nrow, int ncol, int p) -> [MX]
          sym(str name, Sparsity sp, int p, int r) -> [[MX]]
          sym(str name, int nrow, int ncol, int p, int r) -> [[MX]]

        symbolic primitives.



        .......

        ::

          sym(str name, (int,int) rc)



        Construct a symbolic primitive with given dimensions.



        .............


        .......

        ::

          sym(str name, int nrow, int ncol, int p)



        Create a vector of length p with nrow-by-ncol symbolic primitives.



        .............


        .......

        ::

          sym(str name, Sparsity sp, int p, int r)



        Create a vector of length r of vectors of length p with symbolic primitives
        with given sparsity.



        .............


        .......

        ::

          sym(str name, int nrow, int ncol, int p, int r)



        Create a vector of length r of vectors of length p with nrow-by-ncol
        symbolic primitives.



        .............


        .......

        ::

          sym(str name, Sparsity sp)



        Create symbolic primitive with a given sparsity pattern.



        .............


        .......

        ::

          sym(str name, int nrow, int ncol)



        Create an nrow-by-ncol symbolic primitive.



        .............


        .......

        ::

          sym(str name, Sparsity sp, int p)



        Create a vector of length p with with matrices with symbolic primitives of
        given sparsity.



        .............



        """
        return _casadi.GenMX_sym(*args)

    sym = staticmethod(sym)

    def zeros(*args):
        """
          Create a dense matrix or a matrix with specified sparsity with all entries

          zeros(int nrow, int ncol) -> MX
          zeros((int,int) rc) -> MX
          zeros(Sparsity sp) -> MX

        zero.




        """
        return _casadi.GenMX_zeros(*args)

    zeros = staticmethod(zeros)

    def ones(*args):
        """
          Create a dense matrix or a matrix with specified sparsity with all entries

          ones(int nrow, int ncol) -> MX
          ones((int,int) rc) -> MX
          ones(Sparsity sp) -> MX

        one.




        """
        return _casadi.GenMX_ones(*args)

    ones = staticmethod(ones)

    def __init__(self, *args):
        """


        GenMX()
        GenMX(GenMX other)



        """
        this = _casadi.new_GenMX(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_GenMX
GenMX_swigregister = _casadi.GenMX_swigregister
GenMX_swigregister(GenMX)

def GenMX_sym(*args):
    """
      Create a vector of length r of vectors of length p with nrow-by-ncol

      sym(str name, int nrow, int ncol) -> MX
      sym(str name, (int,int) rc) -> MX
      sym(str name, Sparsity sp) -> MX
      sym(str name, Sparsity sp, int p) -> [MX]
      sym(str name, int nrow, int ncol, int p) -> [MX]
      sym(str name, Sparsity sp, int p, int r) -> [[MX]]
      sym(str name, int nrow, int ncol, int p, int r) -> [[MX]]

    symbolic primitives.



    .......

    ::

      sym(str name, (int,int) rc)



    Construct a symbolic primitive with given dimensions.



    .............


    .......

    ::

      sym(str name, int nrow, int ncol, int p)



    Create a vector of length p with nrow-by-ncol symbolic primitives.



    .............


    .......

    ::

      sym(str name, Sparsity sp, int p, int r)



    Create a vector of length r of vectors of length p with symbolic primitives
    with given sparsity.



    .............


    .......

    ::

      sym(str name, int nrow, int ncol, int p, int r)



    Create a vector of length r of vectors of length p with nrow-by-ncol
    symbolic primitives.



    .............


    .......

    ::

      sym(str name, Sparsity sp)



    Create symbolic primitive with a given sparsity pattern.



    .............


    .......

    ::

      sym(str name, int nrow, int ncol)



    Create an nrow-by-ncol symbolic primitive.



    .............


    .......

    ::

      sym(str name, Sparsity sp, int p)



    Create a vector of length p with with matrices with symbolic primitives of
    given sparsity.



    .............



    """
    return _casadi.GenMX_sym(*args)

def GenMX_zeros(*args):
    """
      Create a dense matrix or a matrix with specified sparsity with all entries

      zeros(int nrow, int ncol) -> MX
      zeros((int,int) rc) -> MX
      zeros(Sparsity sp) -> MX

    zero.




    """
    return _casadi.GenMX_zeros(*args)

def GenMX_ones(*args):
    """
      Create a dense matrix or a matrix with specified sparsity with all entries

      ones(int nrow, int ncol) -> MX
      ones((int,int) rc) -> MX
      ones(Sparsity sp) -> MX

    one.




    """
    return _casadi.GenMX_ones(*args)

class GenericExpressionCommon(_object):
    """


    GenericExpressionCommon() -> 



    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GenericExpressionCommon, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GenericExpressionCommon, name)
    __repr__ = _swig_repr

    def __hash__(self):
      try:
        return self.element_hash()
      except:
        return SharedObject.__hash__(self)
    def __matmul__(x, y): return _casadi.mtimes(x, y)
    def __rmatmul__(x, y): return _casadi.mtimes(y, x)


    def __add__(x, y): return _casadi.plus(x, y)
    def __radd__(x, y): return _casadi.plus(y, x)
    def __sub__(x, y): return _casadi.minus(x, y)
    def __rsub__(x, y): return _casadi.minus(y, x)
    def __mul__(x, y): return _casadi.times(x, y)
    def __rmul__(x, y): return _casadi.times(y, x)
    def __div__(x, y): return _casadi.rdivide(x, y)
    def __rdiv__(x, y): return _casadi.rdivide(y, x)
    def __truediv__(x, y): return _casadi.rdivide(x, y)
    def __rtruediv__(x, y): return _casadi.rdivide(y, x)
    def __lt__(x, y): return _casadi.lt(x, y)
    def __rlt__(x, y): return _casadi.lt(y, x)
    def __le__(x, y): return _casadi.le(x, y)
    def __rle__(x, y): return _casadi.le(y, x)
    def __gt__(x, y): return _casadi.lt(y, x)
    def __rgt__(x, y): return _casadi.lt(x, y)
    def __ge__(x, y): return _casadi.le(y, x)
    def __rge__(x, y): return _casadi.le(x, y)
    def __eq__(x, y): return _casadi.eq(x, y)
    def __req__(x, y): return _casadi.eq(y, x)
    def __ne__(x, y): return _casadi.ne(x, y)
    def __rne__(x, y): return _casadi.ne(y, x)
    def __pow__(x, n): return _casadi.power(x, n)
    def __rpow__(n, x): return _casadi.power(x, n)
    def __arctan2__(x, y): return _casadi.atan2(x, y)
    def __rarctan2__(y, x): return _casadi.atan2(x, y)
    def fmin(x, y): return _casadi.fmin(x, y)
    def fmax(x, y): return _casadi.fmax(x, y)
    def __fmin__(x, y): return _casadi.fmin(x, y)
    def __rfmin__(y, x): return _casadi.fmin(x, y)
    def __fmax__(x, y): return _casadi.fmax(x, y)
    def __rfmax__(y, x): return _casadi.fmax(x, y)
    def logic_and(x, y): return _casadi.logic_and(x, y)
    def logic_or(x, y): return _casadi.logic_or(x, y)
    def fabs(x): return _casadi.fabs(x)
    def sqrt(x): return _casadi.sqrt(x)
    def sin(x): return _casadi.sin(x)
    def cos(x): return _casadi.cos(x)
    def tan(x): return _casadi.tan(x)
    def arcsin(x): return _casadi.asin(x)
    def arccos(x): return _casadi.acos(x)
    def arctan(x): return _casadi.atan(x)
    def sinh(x): return _casadi.sinh(x)
    def cosh(x): return _casadi.cosh(x)
    def tanh(x): return _casadi.tanh(x)
    def arcsinh(x): return _casadi.asinh(x)
    def arccosh(x): return _casadi.acosh(x)
    def arctanh(x): return _casadi.atanh(x)
    def exp(x): return _casadi.exp(x)
    def log(x): return _casadi.log(x)
    def log10(x): return _casadi.log10(x)
    def floor(x): return _casadi.floor(x)
    def ceil(x): return _casadi.ceil(x)
    def erf(x): return _casadi.erf(x)
    def sign(x): return _casadi.sign(x)
    def fmod(x, y): return _casadi.mod(x, y)
    def __copysign__(x, y): return _casadi.copysign(x, y)
    def __rcopysign__(y, x): return _casadi.copysign(x, y)
    def copysign(x, y): return _casadi.copysign(x, y)
    def rcopysign(y, x): return _casadi.copysign(x, y)
    def __constpow__(x, y): return _casadi.constpow(x, y)
    def __rconstpow__(y, x): return _casadi.constpow(x, y)
    def constpow(x, y): return _casadi.constpow(x, y)
    def rconstpow(y, x): return _casadi.constpow(x, y)


    def __init__(self, *args):
        """


        GenericExpressionCommon()
        GenericExpressionCommon(GenericExpressionCommon other)



        """
        this = _casadi.new_GenericExpressionCommon(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_GenericExpressionCommon
GenericExpressionCommon_swigregister = _casadi.GenericExpressionCommon_swigregister
GenericExpressionCommon_swigregister(GenericExpressionCommon)

IS_GLOBAL = _casadi.IS_GLOBAL
IS_MEMBER = _casadi.IS_MEMBER
IS_SPARSITY = _casadi.IS_SPARSITY
IS_DMATRIX = _casadi.IS_DMATRIX
IS_IMATRIX = _casadi.IS_IMATRIX
IS_SX = _casadi.IS_SX
IS_MX = _casadi.IS_MX
IS_DOUBLE = _casadi.IS_DOUBLE
class MatrixCommon(_object):
    """
      Sparse matrix class. SX and DM are specializations.

      MatrixCommon() -> 


    General sparse matrix class that is designed with the idea that "everything
    is a matrix", that is, also scalars and vectors. This philosophy makes it
    easy to use and to interface in particularly with Python and Matlab/Octave.
    Index starts with 0. Index vec happens as follows: (rr, cc) -> k =
    rr+cc*size1() Vectors are column vectors.  The storage format is Compressed
    Column Storage (CCS), similar to that used for sparse matrices in Matlab,
    but unlike this format, we do allow for elements to be structurally non-zero
    but numerically zero.  Matrix<Scalar> is polymorphic with a
    std::vector<Scalar> that contain all non-identical-zero elements. The
    sparsity can be accessed with Sparsity& sparsity() Joel Andersson

    C++ includes: casadi_common.hpp 


    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MatrixCommon, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MatrixCommon, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


          MatrixCommon()
          MatrixCommon(MatrixCommon other)


        .......

        ::

          MatrixCommon(MatrixCommon other)



        .............


        .......

        ::

          MatrixCommon()



        constructors

        empty 0-by-0 matrix constructor



        .............



        """
        this = _casadi.new_MatrixCommon(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_MatrixCommon
MatrixCommon_swigregister = _casadi.MatrixCommon_swigregister
MatrixCommon_swigregister(MatrixCommon)

class DM(MatrixCommon, GenericExpressionCommon, GenDM, PrintableCommon):
    """





    """

    __swig_setmethods__ = {}
    for _s in [MatrixCommon, GenericExpressionCommon, GenDM, PrintableCommon]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DM, name, value)
    __swig_getmethods__ = {}
    for _s in [MatrixCommon, GenericExpressionCommon, GenDM, PrintableCommon]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DM, name)
    __repr__ = _swig_repr

    def sanity_check(self, *args):
        """
        [DEPRECATED] Correctness is checked during construction

        sanity_check(self, bool complete)





        """
        return _casadi.DM_sanity_check(self, *args)


    def has_nz(self, *args):
        """
        Returns true if the matrix has a non-zero at location rr, cc.

        has_nz(self, int rr, int cc) -> bool





        """
        return _casadi.DM_has_nz(self, *args)


    def __bool__(self, *args):
        """
        Returns the truth value of a Matrix.

        __bool__(self) -> bool





        """
        return _casadi.DM___bool__(self, *args)


    def get(self, *args):
        """


        get(self, bool ind1, Sparsity sp) -> DM
        get(self, bool ind1, Slice rr) -> DM
        get(self, bool ind1, IM rr) -> DM
        get(self, bool ind1, Slice rr, Slice cc) -> DM
        get(self, bool ind1, Slice rr, IM cc) -> DM
        get(self, bool ind1, IM rr, Slice cc) -> DM
        get(self, bool ind1, IM rr, IM cc) -> DM



        """
        return _casadi.DM_get(self, *args)


    def set(self, *args):
        """


        set(self, DM m, bool ind1, Sparsity sp)
        set(self, DM m, bool ind1, Slice rr)
        set(self, DM m, bool ind1, IM rr)
        set(self, DM m, bool ind1, Slice rr, Slice cc)
        set(self, DM m, bool ind1, Slice rr, IM cc)
        set(self, DM m, bool ind1, IM rr, Slice cc)
        set(self, DM m, bool ind1, IM rr, IM cc)



        """
        return _casadi.DM_set(self, *args)


    def get_nz(self, *args):
        """


        get_nz(self, bool ind1, Slice k) -> DM
        get_nz(self, bool ind1, IM k) -> DM



        """
        return _casadi.DM_get_nz(self, *args)


    def set_nz(self, *args):
        """


        set_nz(self, DM m, bool ind1, Slice k)
        set_nz(self, DM m, bool ind1, IM k)



        """
        return _casadi.DM_set_nz(self, *args)


    def __pos__(self, *args):
        """


        __pos__(self) -> DM



        """
        return _casadi.DM___pos__(self, *args)


    def __neg__(self, *args):
        """


        __neg__(self) -> DM



        """
        return _casadi.DM___neg__(self, *args)


    def binary(*args):
        """


        binary(int op, DM x, DM y) -> DM



        """
        return _casadi.DM_binary(*args)

    binary = staticmethod(binary)

    def unary(*args):
        """


        unary(int op, DM x) -> DM



        """
        return _casadi.DM_unary(*args)

    unary = staticmethod(unary)

    def scalar_matrix(*args):
        """


        scalar_matrix(int op, DM x, DM y) -> DM



        """
        return _casadi.DM_scalar_matrix(*args)

    scalar_matrix = staticmethod(scalar_matrix)

    def matrix_scalar(*args):
        """


        matrix_scalar(int op, DM x, DM y) -> DM



        """
        return _casadi.DM_matrix_scalar(*args)

    matrix_scalar = staticmethod(matrix_scalar)

    def matrix_matrix(*args):
        """


        matrix_matrix(int op, DM x, DM y) -> DM



        """
        return _casadi.DM_matrix_matrix(*args)

    matrix_matrix = staticmethod(matrix_matrix)

    def printme(self, *args):
        """


        printme(self, DM y) -> DM



        """
        return _casadi.DM_printme(self, *args)


    def set_max_depth(*args):
        """


        set_max_depth(int eq_depth)



        """
        return _casadi.DM_set_max_depth(*args)

    set_max_depth = staticmethod(set_max_depth)

    def get_max_depth(*args):
        """


        get_max_depth() -> int



        """
        return _casadi.DM_get_max_depth(*args)

    get_max_depth = staticmethod(get_max_depth)

    def get_input(*args):
        """


        get_input(Function f) -> [DM]



        """
        return _casadi.DM_get_input(*args)

    get_input = staticmethod(get_input)

    def get_free(*args):
        """


        get_free(Function f) -> [DM]



        """
        return _casadi.DM_get_free(*args)

    get_free = staticmethod(get_free)

    def type_name(*args):
        """


        type_name() -> str



        """
        return _casadi.DM_type_name(*args)

    type_name = staticmethod(type_name)

    def print_split(self, *args):
        """
        Get strings corresponding to the nonzeros and the interdependencies.

        print_split(self) -> ([str] OUTPUT, [str] OUTPUT)





        """
        return _casadi.DM_print_split(self, *args)


    def disp(self, *args):
        """
        Print a representation of the object.

        disp(self, bool more)





        """
        return _casadi.DM_disp(self, *args)


    def str(self, *args):
        """
        Get string representation.

        str(self, bool more) -> str





        """
        return _casadi.DM_str(self, *args)


    def print_scalar(self, *args):
        """
        Print scalar.

        print_scalar(self)





        """
        return _casadi.DM_print_scalar(self, *args)


    def print_vector(self, *args):
        """
        Print vector-style.

        print_vector(self, bool truncate)





        """
        return _casadi.DM_print_vector(self, *args)


    def print_dense(self, *args):
        """
        Print dense matrix-stype.

        print_dense(self, bool truncate)





        """
        return _casadi.DM_print_dense(self, *args)


    def print_sparse(self, *args):
        """
        Print sparse matrix style.

        print_sparse(self, bool truncate)





        """
        return _casadi.DM_print_sparse(self, *args)


    def clear(self, *args):
        """


        clear(self)



        """
        return _casadi.DM_clear(self, *args)


    def resize(self, *args):
        """


        resize(self, int nrow, int ncol)



        """
        return _casadi.DM_resize(self, *args)


    def reserve(self, *args):
        """


        reserve(self, int nnz)
        reserve(self, int nnz, int ncol)



        """
        return _casadi.DM_reserve(self, *args)


    def erase(self, *args):
        """
          Erase a submatrix (leaving structural zeros in its place) Erase elements of

          erase(self, [int] rr, bool ind1)
          erase(self, [int] rr, [int] cc, bool ind1)

        a matrix.



        .......

        ::

          erase(self, [int] rr, bool ind1)



        Erase a submatrix (leaving structural zeros in its place) Erase elements of
        a matrix.



        .............


        .......

        ::

          erase(self, [int] rr, [int] cc, bool ind1)



        Erase a submatrix (leaving structural zeros in its place) Erase rows and/or
        columns of a matrix.



        .............



        """
        return _casadi.DM_erase(self, *args)


    def remove(self, *args):
        """
        Remove columns and rows Remove/delete rows and/or columns of a matrix.

        remove(self, [int] rr, [int] cc)





        """
        return _casadi.DM_remove(self, *args)


    def enlarge(self, *args):
        """
          Enlarge matrix Make the matrix larger by inserting empty rows and columns,

          enlarge(self, int nrow, int ncol, [int] rr, [int] cc, bool ind1)

        keeping the existing non-zeros.




        """
        return _casadi.DM_enlarge(self, *args)


    def sparsity(self, *args):
        """
        Get an owning reference to the sparsity pattern.

        sparsity(self) -> Sparsity





        """
        return _casadi.DM_sparsity(self, *args)


    def triplet(*args):
        """


        triplet([int] row, [int] col, DM d) -> DM
        triplet([int] row, [int] col, DM d, (int,int) rc) -> DM
        triplet([int] row, [int] col, DM d, int nrow, int ncol) -> DM



        """
        return _casadi.DM_triplet(*args)

    triplet = staticmethod(triplet)

    def inf(*args):
        """
        create a matrix with all inf

        inf(int nrow, int ncol) -> DM
        inf((int,int) rc) -> DM
        inf(Sparsity sp) -> DM





        """
        return _casadi.DM_inf(*args)

    inf = staticmethod(inf)

    def nan(*args):
        """
        create a matrix with all nan

        nan(int nrow, int ncol) -> DM
        nan((int,int) rc) -> DM
        nan(Sparsity sp) -> DM





        """
        return _casadi.DM_nan(*args)

    nan = staticmethod(nan)

    def eye(*args):
        """


        eye(int n) -> DM



        """
        return _casadi.DM_eye(*args)

    eye = staticmethod(eye)

    def element_hash(self, *args):
        """


        element_hash(self) -> int



        """
        return _casadi.DM_element_hash(self, *args)


    def is_regular(self, *args):
        """


        is_regular(self) -> bool



        """
        return _casadi.DM_is_regular(self, *args)


    def is_smooth(self, *args):
        """


        is_smooth(self) -> bool



        """
        return _casadi.DM_is_smooth(self, *args)


    def is_leaf(self, *args):
        """


        is_leaf(self) -> bool



        """
        return _casadi.DM_is_leaf(self, *args)


    def is_commutative(self, *args):
        """


        is_commutative(self) -> bool



        """
        return _casadi.DM_is_commutative(self, *args)


    def is_symbolic(self, *args):
        """


        is_symbolic(self) -> bool



        """
        return _casadi.DM_is_symbolic(self, *args)


    def is_valid_input(self, *args):
        """


        is_valid_input(self) -> bool



        """
        return _casadi.DM_is_valid_input(self, *args)


    def has_duplicates(self, *args):
        """


        has_duplicates(self) -> bool



        """
        return _casadi.DM_has_duplicates(self, *args)


    def reset_input(self, *args):
        """


        reset_input(self)



        """
        return _casadi.DM_reset_input(self, *args)


    def is_constant(self, *args):
        """
          Check if the matrix is constant (note that false negative answers are

          is_constant(self) -> bool

        possible)




        """
        return _casadi.DM_is_constant(self, *args)


    def is_integer(self, *args):
        """
          Check if the matrix is integer-valued (note that false negative answers are

          is_integer(self) -> bool

        possible)




        """
        return _casadi.DM_is_integer(self, *args)


    def is_zero(self, *args):
        """
        check if the matrix is 0 (note that false negative answers are possible)

        is_zero(self) -> bool





        """
        return _casadi.DM_is_zero(self, *args)


    def is_one(self, *args):
        """
        check if the matrix is 1 (note that false negative answers are possible)

        is_one(self) -> bool





        """
        return _casadi.DM_is_one(self, *args)


    def is_minus_one(self, *args):
        """
        check if the matrix is -1 (note that false negative answers are possible)

        is_minus_one(self) -> bool





        """
        return _casadi.DM_is_minus_one(self, *args)


    def is_eye(self, *args):
        """
          check if the matrix is an identity matrix (note that false negative answers

          is_eye(self) -> bool

        are possible)




        """
        return _casadi.DM_is_eye(self, *args)


    def op(self, *args):
        """


        op(self) -> int



        """
        return _casadi.DM_op(self, *args)


    def is_op(self, *args):
        """


        is_op(self, int op) -> bool



        """
        return _casadi.DM_is_op(self, *args)


    def has_zeros(self, *args):
        """
        Check if the matrix has any zero entries which are not structural zeros.

        has_zeros(self) -> bool





        """
        return _casadi.DM_has_zeros(self, *args)


    def nonzeros(self, *args):
        """
          Get all nonzeros.

          nonzeros(self) -> [float]


        Implementation of Matrix::get_nonzeros (in public API)




        """
        return _casadi.DM_nonzeros(self, *args)


    def elements(self, *args):
        """
        Get all elements.

        elements(self) -> [float]





        """
        return _casadi.DM_elements(self, *args)


    def __float__(self, *args):
        """


        __float__(self) -> float



        """
        return _casadi.DM___float__(self, *args)


    def __int__(self, *args):
        """


        __int__(self) -> int



        """
        return _casadi.DM___int__(self, *args)


    def name(self, *args):
        """


        name(self) -> str



        """
        return _casadi.DM_name(self, *args)


    def dep(self, *args):
        """


        dep(self, int ch) -> DM



        """
        return _casadi.DM_dep(self, *args)


    def n_dep(self, *args):
        """


        n_dep(self) -> int



        """
        return _casadi.DM_n_dep(self, *args)


    def set_precision(*args):
        """
          Set the 'precision, width & scientific' used in printing and serializing to

          set_precision(int precision)

        streams.




        """
        return _casadi.DM_set_precision(*args)

    set_precision = staticmethod(set_precision)

    def set_width(*args):
        """
          Set the 'precision, width & scientific' used in printing and serializing to

          set_width(int width)

        streams.




        """
        return _casadi.DM_set_width(*args)

    set_width = staticmethod(set_width)

    def set_scientific(*args):
        """
          Set the 'precision, width & scientific' used in printing and serializing to

          set_scientific(bool scientific)

        streams.




        """
        return _casadi.DM_set_scientific(*args)

    set_scientific = staticmethod(set_scientific)

    def rng(*args):
        """


        rng(int seed)



        """
        return _casadi.DM_rng(*args)

    rng = staticmethod(rng)

    def rand(*args):
        """
        Create a matrix with uniformly distributed random numbers.

        rand(int nrow, int ncol) -> DM
        rand((int,int) rc) -> DM
        rand(Sparsity sp) -> DM





        """
        return _casadi.DM_rand(*args)

    rand = staticmethod(rand)

    def export_code(self, *args):
        """
          Export matrix in specific language.

          export_code(self, str lang, dict options)


        lang: only 'matlab' supported for now

        ::

          * options:
          *   inline: Indicates if you want everything on a single line (default: False)
          *   name: Name of exported variable (default: 'm')
          *   indent_level: Level of indentation (default: 0)
          *   spoof_zero: Replace numerical zero by a 1e-200 (default: false)
          *               might be needed for matlab sparse construct,
          *               which doesn't allow numerical zero
          * 






        """
        return _casadi.DM_export_code(self, *args)


    def info(self, *args):
        """


        info(self) -> dict



        """
        return _casadi.DM_info(self, *args)


    def serialize(self, *args):
        """
          Serialize an object.

          serialize(self) -> str
          serialize(self, casadi::SerializingStream & s)




        .......

        ::

          serialize(self, casadi::SerializingStream & s)



        Serialize an object.



        .............


        .......

        ::

          serialize(self)



        Serialize.



        .............



        """
        return _casadi.DM_serialize(self, *args)


    def deserialize(*args):
        """


        deserialize(std::istream & stream) -> DM
        deserialize(casadi::DeserializingStream & s) -> DM
        deserialize(str s) -> DM



        """
        return _casadi.DM_deserialize(*args)

    deserialize = staticmethod(deserialize)

    def to_file(self, *args):
        """
          Export numerical matrix to file

          to_file(self, str filename, str format)


        Supported formats:



        ::

          *   - .mtx   Matrix Market (sparse)
          *   - .txt   Ascii full precision representation (sparse)
          *            Whitespace separated, aligned.
          *            Comments with # % or /
          *            Uses C locale
          *            Structural zeros represented by 00
          *            Does not scale well for large sparse matrices
          * 






        """
        return _casadi.DM_to_file(self, *args)


    def from_file(*args):
        """
          Export numerical matrix to file

          from_file(str filename, str format_hint) -> DM


        Supported formats:



        ::

          *   - .mtx   Matrix Market (sparse)
          *   - .txt   Ascii full precision representation (sparse)
          *            Whitespace separated, aligned.
          *            Comments with # % or /
          *            Uses C locale
          *            Structural zeros represented by 00
          *            Does not scale well for large sparse matrices
          * 






        """
        return _casadi.DM_from_file(*args)

    from_file = staticmethod(from_file)

    def __init__(self, *args):
        """


        DM()
        DM(Sparsity sp)
        DM(float val)
        DM([[float]] m)
        DM(DM m)
        DM([SXElem] x)
        DM(SX x)
        DM(int nrow, int ncol)
        DM(Sparsity sp, DM d)



        """
        this = _casadi.new_DM(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def assign(self, *args):
        """


        assign(self, DM rhs)



        """
        return _casadi.DM_assign(self, *args)


    @property
    def shape(self):
        return (self.size1(),self.size2())

    def reshape(self,arg):
        return _casadi.reshape(self,arg)

    @property
    def T(self):
        return _casadi.transpose(self)

    def __getitem__(self, s):
          if isinstance(s, tuple) and len(s)==2:
            if s[1] is None: raise TypeError("Cannot slice with None")
            return self.get(False, s[0], s[1])
          return self.get(False, s)

    def __iter__(self):
      raise Exception("""CasADi matrices are not iterable by design.
                      Did you mean to iterate over m.nz, with m IM/DM/SX?
                      Did you mean to iterate over horzsplit(m,1)/vertsplit(m,1) with m IM/DM/SX/MX?
                      """)

    def __setitem__(self,s,val):
          if isinstance(s,tuple) and len(s)==2:
            return self.set(val, False, s[0], s[1])
          return self.set(val, False, s)

    @property
    def nz(self):
      return NZproxy(self)



    def full(self, *args):
        """


        full(self) -> PyObject *



        """
        return _casadi.DM_full(self, *args)


    def sparse(self, *args):
        """


        sparse(self) -> PyObject *



        """
        return _casadi.DM_sparse(self, *args)



    __array_priority__ = 999.0

    def __array_wrap__(self,out_arr,context=None):
      if context is None:
        return out_arr
      name = context[0].__name__
      args = list(context[1])

      if len(context[1])==3:
        raise Exception("Error with %s. Looks like you are using an assignment operator, such as 'a+=b' where 'a' is a numpy type. This is not supported, and cannot be supported without changing numpy." % name)

      if "vectorized" in name:
          name = name[:-len(" (vectorized)")]

      conversion = {"multiply": "mul", "divide": "div", "true_divide": "div", "subtract":"sub","power":"pow","greater_equal":"ge","less_equal": "le", "less": "lt", "greater": "gt"}
      if name in conversion:
        name = conversion[name]
      if len(context[1])==2 and context[1][1] is self and not(context[1][0] is self):
        name = 'r' + name
        args.reverse()
      if not(hasattr(self,name)) or ('mul' in name):
        name = '__' + name + '__'
      fun=getattr(self, name)
      return fun(*args[1:])

    def __array_ufunc__(self, ufunc, method, *inputs, **kwargs):
      conversion = {"multiply": "mul", "divide": "div", "true_divide": "div", "subtract":"sub","power":"pow","greater_equal":"ge","less_equal": "le", "less": "lt", "greater": "gt"}
      name = ufunc.__name__
      inputs = list(inputs)
      if len(inputs)==3:
        import warnings
        warnings.warn("Error with %s. Looks like you are using an assignment operator, such as 'a+=b' where 'a' is a numpy type. This is not supported, and cannot be supported without changing numpy." % name, RuntimeWarning)
        return NotImplemented
      if "vectorized" in name:
          name = name[:-len(" (vectorized)")]
      if name in conversion:
        name = conversion[name]
      if len(inputs)==2 and inputs[1] is self and not(inputs[0] is self):
        name = 'r' + name
        inputs.reverse()
      if not(hasattr(self,name)) or ('mul' in name):
        name = '__' + name + '__'
      try:
        assert method=="__call__"
        fun=getattr(self, name)
        return fun(*inputs[1:])
      except:
#Fall back to numpy conversion
        new_inputs = list(inputs)
        try:
          new_inputs[0] = new_inputs[0].full()
        except:
          import warnings
          warnings.warn("Implicit conversion of symbolic CasADi type to numeric matrix not supported.\n"
                                 + "This may occur when you pass a CasADi object to a numpy function.\n"
                                 + "Use an equivalent CasADi function instead of that numpy function.", RuntimeWarning)
          return NotImplemented
        return new_inputs[0].__array_ufunc__(ufunc, method, *new_inputs, **kwargs)


    def __array__(self,*args,**kwargs):
      import numpy as n
      if len(args) > 1 and isinstance(args[1],tuple) and isinstance(args[1][0],n.ufunc) and isinstance(args[1][0],n.ufunc) and len(args[1])>1 and args[1][0].nin==len(args[1][1]):
        if len(args[1][1])==3:
          raise Exception("Error with %s. Looks like you are using an assignment operator, such as 'a+=b'. This is not supported when 'a' is a numpy type, and cannot be supported without changing numpy itself. Either upgrade a to a CasADi type first, or use 'a = a + b'. " % args[1][0].__name__)
        return n.array([n.nan])
      else:
        if hasattr(self,'__array_custom__'):
          return self.__array_custom__(*args,**kwargs)
        else:
          try:
            return self.full()
          except:
            raise Exception("Implicit conversion of symbolic CasADi type to numeric matrix not supported.\n"
                       + "This may occur when you pass a CasADi object to a numpy function.\n"
                       + "Use an equivalent CasADi function instead of that numpy function.")



    def __array_custom__(self,*args,**kwargs):
      if "dtype" in kwargs and not(isinstance(kwargs["dtype"],n.double)):
        return n.array(self.full(),dtype=kwargs["dtype"])
      else:
        return self.full()


    def tocsc(self):
      import numpy as np
      import warnings
      with warnings.catch_warnings():
        warnings.simplefilter("ignore")
        from scipy.sparse import csc_matrix
      return csc_matrix( (self.nonzeros(),self.row(),self.colind()), shape = self.shape, dtype=np.double )
    def toarray(self,simplify=False):
      import numpy as np
      if simplify:
        if self.is_scalar():
          return float(self)
        elif self.is_vector():
          return np.array(self.T.elements())
      return np.array(self.T.elements()).reshape(self.shape)


    def __bool__(self):
      if self.numel()!=1:
        raise Exception("Only a scalar can be cast to a float")
      if self.nnz()==0:
        return False
      return float(self)!=0


    def __abs__(self):
      return abs(float(self))


    def __setstate__(self, state):
        self.__init__(DM.deserialize(state["serialization"]))

    def __getstate__(self):
        return {"serialization": self.serialize()}

    __swig_destroy__ = _casadi.delete_DM
DM_swigregister = _casadi.DM_swigregister
DM_swigregister(DM)

def DM_binary(*args):
    """


    binary(int op, DM x, DM y) -> DM



    """
    return _casadi.DM_binary(*args)

def DM_unary(*args):
    """


    unary(int op, DM x) -> DM



    """
    return _casadi.DM_unary(*args)

def DM_scalar_matrix(*args):
    """


    scalar_matrix(int op, DM x, DM y) -> DM



    """
    return _casadi.DM_scalar_matrix(*args)

def DM_matrix_scalar(*args):
    """


    matrix_scalar(int op, DM x, DM y) -> DM



    """
    return _casadi.DM_matrix_scalar(*args)

def DM_matrix_matrix(*args):
    """


    matrix_matrix(int op, DM x, DM y) -> DM



    """
    return _casadi.DM_matrix_matrix(*args)

def DM_set_max_depth(*args):
    """


    set_max_depth(int eq_depth)



    """
    return _casadi.DM_set_max_depth(*args)

def DM_get_max_depth(*args):
    """


    get_max_depth() -> int



    """
    return _casadi.DM_get_max_depth(*args)

def DM_get_input(*args):
    """


    get_input(Function f) -> [DM]



    """
    return _casadi.DM_get_input(*args)

def DM_get_free(*args):
    """


    get_free(Function f) -> [DM]



    """
    return _casadi.DM_get_free(*args)

def DM_type_name(*args):
    """


    type_name() -> str



    """
    return _casadi.DM_type_name(*args)

def DM_triplet(*args):
    """


    triplet([int] row, [int] col, DM d) -> DM
    triplet([int] row, [int] col, DM d, (int,int) rc) -> DM
    triplet([int] row, [int] col, DM d, int nrow, int ncol) -> DM



    """
    return _casadi.DM_triplet(*args)

def DM_inf(*args):
    """
    create a matrix with all inf

    inf(int nrow, int ncol) -> DM
    inf((int,int) rc) -> DM
    inf(Sparsity sp) -> DM





    """
    return _casadi.DM_inf(*args)

def DM_nan(*args):
    """
    create a matrix with all nan

    nan(int nrow, int ncol) -> DM
    nan((int,int) rc) -> DM
    nan(Sparsity sp) -> DM





    """
    return _casadi.DM_nan(*args)

def DM_eye(*args):
    """


    eye(int n) -> DM



    """
    return _casadi.DM_eye(*args)

def DM_set_precision(*args):
    """
      Set the 'precision, width & scientific' used in printing and serializing to

      set_precision(int precision)

    streams.




    """
    return _casadi.DM_set_precision(*args)

def DM_set_width(*args):
    """
      Set the 'precision, width & scientific' used in printing and serializing to

      set_width(int width)

    streams.




    """
    return _casadi.DM_set_width(*args)

def DM_set_scientific(*args):
    """
      Set the 'precision, width & scientific' used in printing and serializing to

      set_scientific(bool scientific)

    streams.




    """
    return _casadi.DM_set_scientific(*args)

def DM_rng(*args):
    """


    rng(int seed)



    """
    return _casadi.DM_rng(*args)

def DM_rand(*args):
    """
    Create a matrix with uniformly distributed random numbers.

    rand(int nrow, int ncol) -> DM
    rand((int,int) rc) -> DM
    rand(Sparsity sp) -> DM





    """
    return _casadi.DM_rand(*args)

def DM_deserialize(*args):
    """


    deserialize(std::istream & stream) -> DM
    deserialize(casadi::DeserializingStream & s) -> DM
    deserialize(str s) -> DM



    """
    return _casadi.DM_deserialize(*args)

def DM_from_file(*args):
    """
      Export numerical matrix to file

      from_file(str filename, str format_hint) -> DM


    Supported formats:



    ::

      *   - .mtx   Matrix Market (sparse)
      *   - .txt   Ascii full precision representation (sparse)
      *            Whitespace separated, aligned.
      *            Comments with # % or /
      *            Uses C locale
      *            Structural zeros represented by 00
      *            Does not scale well for large sparse matrices
      * 






    """
    return _casadi.DM_from_file(*args)

class SXElem(_object):
    """


    SXElem() -> 



    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SXElem, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SXElem, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        SXElem()
        SXElem(SXElem other)



        """
        this = _casadi.new_SXElem(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_SXElem
SXElem_swigregister = _casadi.SXElem_swigregister
SXElem_swigregister(SXElem)



try:
  import numpy

  def constpow(x,y):
    pass

  constpow=numpy.frompyfunc(constpow,2,1)
except:
  pass

class SX(MatrixCommon, GenericExpressionCommon, GenSX, PrintableCommon):
    """





    """

    __swig_setmethods__ = {}
    for _s in [MatrixCommon, GenericExpressionCommon, GenSX, PrintableCommon]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SX, name, value)
    __swig_getmethods__ = {}
    for _s in [MatrixCommon, GenericExpressionCommon, GenSX, PrintableCommon]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SX, name)
    __repr__ = _swig_repr

    def sanity_check(self, *args):
        """
        [DEPRECATED] Correctness is checked during construction

        sanity_check(self, bool complete)





        """
        return _casadi.SX_sanity_check(self, *args)


    def has_nz(self, *args):
        """
        Returns true if the matrix has a non-zero at location rr, cc.

        has_nz(self, int rr, int cc) -> bool





        """
        return _casadi.SX_has_nz(self, *args)


    def __bool__(self, *args):
        """
        Returns the truth value of a Matrix.

        __bool__(self) -> bool





        """
        return _casadi.SX___bool__(self, *args)


    def get(self, *args):
        """


        get(self, bool ind1, Sparsity sp) -> SX
        get(self, bool ind1, Slice rr) -> SX
        get(self, bool ind1, IM rr) -> SX
        get(self, bool ind1, Slice rr, Slice cc) -> SX
        get(self, bool ind1, Slice rr, IM cc) -> SX
        get(self, bool ind1, IM rr, Slice cc) -> SX
        get(self, bool ind1, IM rr, IM cc) -> SX



        """
        return _casadi.SX_get(self, *args)


    def set(self, *args):
        """


        set(self, SX m, bool ind1, Sparsity sp)
        set(self, SX m, bool ind1, Slice rr)
        set(self, SX m, bool ind1, IM rr)
        set(self, SX m, bool ind1, Slice rr, Slice cc)
        set(self, SX m, bool ind1, Slice rr, IM cc)
        set(self, SX m, bool ind1, IM rr, Slice cc)
        set(self, SX m, bool ind1, IM rr, IM cc)



        """
        return _casadi.SX_set(self, *args)


    def get_nz(self, *args):
        """


        get_nz(self, bool ind1, Slice k) -> SX
        get_nz(self, bool ind1, IM k) -> SX



        """
        return _casadi.SX_get_nz(self, *args)


    def set_nz(self, *args):
        """


        set_nz(self, SX m, bool ind1, Slice k)
        set_nz(self, SX m, bool ind1, IM k)



        """
        return _casadi.SX_set_nz(self, *args)


    def __pos__(self, *args):
        """


        __pos__(self) -> SX



        """
        return _casadi.SX___pos__(self, *args)


    def __neg__(self, *args):
        """


        __neg__(self) -> SX



        """
        return _casadi.SX___neg__(self, *args)


    def binary(*args):
        """


        binary(int op, SX x, SX y) -> SX



        """
        return _casadi.SX_binary(*args)

    binary = staticmethod(binary)

    def unary(*args):
        """


        unary(int op, SX x) -> SX



        """
        return _casadi.SX_unary(*args)

    unary = staticmethod(unary)

    def scalar_matrix(*args):
        """


        scalar_matrix(int op, SX x, SX y) -> SX



        """
        return _casadi.SX_scalar_matrix(*args)

    scalar_matrix = staticmethod(scalar_matrix)

    def matrix_scalar(*args):
        """


        matrix_scalar(int op, SX x, SX y) -> SX



        """
        return _casadi.SX_matrix_scalar(*args)

    matrix_scalar = staticmethod(matrix_scalar)

    def matrix_matrix(*args):
        """


        matrix_matrix(int op, SX x, SX y) -> SX



        """
        return _casadi.SX_matrix_matrix(*args)

    matrix_matrix = staticmethod(matrix_matrix)

    def printme(self, *args):
        """


        printme(self, SX y) -> SX



        """
        return _casadi.SX_printme(self, *args)


    def set_max_depth(*args):
        """


        set_max_depth(int eq_depth)



        """
        return _casadi.SX_set_max_depth(*args)

    set_max_depth = staticmethod(set_max_depth)

    def get_max_depth(*args):
        """


        get_max_depth() -> int



        """
        return _casadi.SX_get_max_depth(*args)

    get_max_depth = staticmethod(get_max_depth)

    def get_input(*args):
        """


        get_input(Function f) -> [SX]



        """
        return _casadi.SX_get_input(*args)

    get_input = staticmethod(get_input)

    def get_free(*args):
        """


        get_free(Function f) -> [SX]



        """
        return _casadi.SX_get_free(*args)

    get_free = staticmethod(get_free)

    def type_name(*args):
        """


        type_name() -> str



        """
        return _casadi.SX_type_name(*args)

    type_name = staticmethod(type_name)

    def print_split(self, *args):
        """
        Get strings corresponding to the nonzeros and the interdependencies.

        print_split(self) -> ([str] OUTPUT, [str] OUTPUT)





        """
        return _casadi.SX_print_split(self, *args)


    def disp(self, *args):
        """
        Print a representation of the object.

        disp(self, bool more)





        """
        return _casadi.SX_disp(self, *args)


    def str(self, *args):
        """
        Get string representation.

        str(self, bool more) -> str





        """
        return _casadi.SX_str(self, *args)


    def print_scalar(self, *args):
        """
        Print scalar.

        print_scalar(self)





        """
        return _casadi.SX_print_scalar(self, *args)


    def print_vector(self, *args):
        """
        Print vector-style.

        print_vector(self, bool truncate)





        """
        return _casadi.SX_print_vector(self, *args)


    def print_dense(self, *args):
        """
        Print dense matrix-stype.

        print_dense(self, bool truncate)





        """
        return _casadi.SX_print_dense(self, *args)


    def print_sparse(self, *args):
        """
        Print sparse matrix style.

        print_sparse(self, bool truncate)





        """
        return _casadi.SX_print_sparse(self, *args)


    def clear(self, *args):
        """


        clear(self)



        """
        return _casadi.SX_clear(self, *args)


    def resize(self, *args):
        """


        resize(self, int nrow, int ncol)



        """
        return _casadi.SX_resize(self, *args)


    def reserve(self, *args):
        """


        reserve(self, int nnz)
        reserve(self, int nnz, int ncol)



        """
        return _casadi.SX_reserve(self, *args)


    def erase(self, *args):
        """
          Erase a submatrix (leaving structural zeros in its place) Erase elements of

          erase(self, [int] rr, bool ind1)
          erase(self, [int] rr, [int] cc, bool ind1)

        a matrix.



        .......

        ::

          erase(self, [int] rr, bool ind1)



        Erase a submatrix (leaving structural zeros in its place) Erase elements of
        a matrix.



        .............


        .......

        ::

          erase(self, [int] rr, [int] cc, bool ind1)



        Erase a submatrix (leaving structural zeros in its place) Erase rows and/or
        columns of a matrix.



        .............



        """
        return _casadi.SX_erase(self, *args)


    def remove(self, *args):
        """
        Remove columns and rows Remove/delete rows and/or columns of a matrix.

        remove(self, [int] rr, [int] cc)





        """
        return _casadi.SX_remove(self, *args)


    def enlarge(self, *args):
        """
          Enlarge matrix Make the matrix larger by inserting empty rows and columns,

          enlarge(self, int nrow, int ncol, [int] rr, [int] cc, bool ind1)

        keeping the existing non-zeros.




        """
        return _casadi.SX_enlarge(self, *args)


    def sparsity(self, *args):
        """
        Get an owning reference to the sparsity pattern.

        sparsity(self) -> Sparsity





        """
        return _casadi.SX_sparsity(self, *args)


    def triplet(*args):
        """


        triplet([int] row, [int] col, SX d) -> SX
        triplet([int] row, [int] col, SX d, (int,int) rc) -> SX
        triplet([int] row, [int] col, SX d, int nrow, int ncol) -> SX



        """
        return _casadi.SX_triplet(*args)

    triplet = staticmethod(triplet)

    def inf(*args):
        """
        create a matrix with all inf

        inf(int nrow, int ncol) -> SX
        inf((int,int) rc) -> SX
        inf(Sparsity sp) -> SX





        """
        return _casadi.SX_inf(*args)

    inf = staticmethod(inf)

    def nan(*args):
        """
        create a matrix with all nan

        nan(int nrow, int ncol) -> SX
        nan((int,int) rc) -> SX
        nan(Sparsity sp) -> SX





        """
        return _casadi.SX_nan(*args)

    nan = staticmethod(nan)

    def eye(*args):
        """


        eye(int n) -> SX



        """
        return _casadi.SX_eye(*args)

    eye = staticmethod(eye)

    def element_hash(self, *args):
        """


        element_hash(self) -> int



        """
        return _casadi.SX_element_hash(self, *args)


    def is_regular(self, *args):
        """


        is_regular(self) -> bool



        """
        return _casadi.SX_is_regular(self, *args)


    def is_smooth(self, *args):
        """


        is_smooth(self) -> bool



        """
        return _casadi.SX_is_smooth(self, *args)


    def is_leaf(self, *args):
        """


        is_leaf(self) -> bool



        """
        return _casadi.SX_is_leaf(self, *args)


    def is_commutative(self, *args):
        """


        is_commutative(self) -> bool



        """
        return _casadi.SX_is_commutative(self, *args)


    def is_symbolic(self, *args):
        """


        is_symbolic(self) -> bool



        """
        return _casadi.SX_is_symbolic(self, *args)


    def is_valid_input(self, *args):
        """


        is_valid_input(self) -> bool



        """
        return _casadi.SX_is_valid_input(self, *args)


    def has_duplicates(self, *args):
        """


        has_duplicates(self) -> bool



        """
        return _casadi.SX_has_duplicates(self, *args)


    def reset_input(self, *args):
        """


        reset_input(self)



        """
        return _casadi.SX_reset_input(self, *args)


    def is_constant(self, *args):
        """
          Check if the matrix is constant (note that false negative answers are

          is_constant(self) -> bool

        possible)




        """
        return _casadi.SX_is_constant(self, *args)


    def is_integer(self, *args):
        """
          Check if the matrix is integer-valued (note that false negative answers are

          is_integer(self) -> bool

        possible)




        """
        return _casadi.SX_is_integer(self, *args)


    def is_zero(self, *args):
        """
        check if the matrix is 0 (note that false negative answers are possible)

        is_zero(self) -> bool





        """
        return _casadi.SX_is_zero(self, *args)


    def is_one(self, *args):
        """
        check if the matrix is 1 (note that false negative answers are possible)

        is_one(self) -> bool





        """
        return _casadi.SX_is_one(self, *args)


    def is_minus_one(self, *args):
        """
        check if the matrix is -1 (note that false negative answers are possible)

        is_minus_one(self) -> bool





        """
        return _casadi.SX_is_minus_one(self, *args)


    def is_eye(self, *args):
        """
          check if the matrix is an identity matrix (note that false negative answers

          is_eye(self) -> bool

        are possible)




        """
        return _casadi.SX_is_eye(self, *args)


    def op(self, *args):
        """


        op(self) -> int



        """
        return _casadi.SX_op(self, *args)


    def is_op(self, *args):
        """


        is_op(self, int op) -> bool



        """
        return _casadi.SX_is_op(self, *args)


    def has_zeros(self, *args):
        """
        Check if the matrix has any zero entries which are not structural zeros.

        has_zeros(self) -> bool





        """
        return _casadi.SX_has_zeros(self, *args)


    def nonzeros(self, *args):
        """
          Get all nonzeros.

          nonzeros(self) -> [SXElem]


        Implementation of Matrix::get_nonzeros (in public API)




        """
        return _casadi.SX_nonzeros(self, *args)


    def elements(self, *args):
        """
        Get all elements.

        elements(self) -> [SXElem]





        """
        return _casadi.SX_elements(self, *args)


    def __float__(self, *args):
        """


        __float__(self) -> float



        """
        return _casadi.SX___float__(self, *args)


    def __int__(self, *args):
        """


        __int__(self) -> int



        """
        return _casadi.SX___int__(self, *args)


    def name(self, *args):
        """


        name(self) -> str



        """
        return _casadi.SX_name(self, *args)


    def dep(self, *args):
        """


        dep(self, int ch) -> SX



        """
        return _casadi.SX_dep(self, *args)


    def n_dep(self, *args):
        """


        n_dep(self) -> int



        """
        return _casadi.SX_n_dep(self, *args)


    def set_precision(*args):
        """
          Set the 'precision, width & scientific' used in printing and serializing to

          set_precision(int precision)

        streams.




        """
        return _casadi.SX_set_precision(*args)

    set_precision = staticmethod(set_precision)

    def set_width(*args):
        """
          Set the 'precision, width & scientific' used in printing and serializing to

          set_width(int width)

        streams.




        """
        return _casadi.SX_set_width(*args)

    set_width = staticmethod(set_width)

    def set_scientific(*args):
        """
          Set the 'precision, width & scientific' used in printing and serializing to

          set_scientific(bool scientific)

        streams.




        """
        return _casadi.SX_set_scientific(*args)

    set_scientific = staticmethod(set_scientific)

    def rng(*args):
        """


        rng(int seed)



        """
        return _casadi.SX_rng(*args)

    rng = staticmethod(rng)

    def rand(*args):
        """
        Create a matrix with uniformly distributed random numbers.

        rand(int nrow, int ncol) -> SX
        rand((int,int) rc) -> SX
        rand(Sparsity sp) -> SX





        """
        return _casadi.SX_rand(*args)

    rand = staticmethod(rand)

    def export_code(self, *args):
        """
          Export matrix in specific language.

          export_code(self, str lang, dict options)


        lang: only 'matlab' supported for now

        ::

          * options:
          *   inline: Indicates if you want everything on a single line (default: False)
          *   name: Name of exported variable (default: 'm')
          *   indent_level: Level of indentation (default: 0)
          *   spoof_zero: Replace numerical zero by a 1e-200 (default: false)
          *               might be needed for matlab sparse construct,
          *               which doesn't allow numerical zero
          * 






        """
        return _casadi.SX_export_code(self, *args)


    def info(self, *args):
        """


        info(self) -> dict



        """
        return _casadi.SX_info(self, *args)


    def serialize(self, *args):
        """
          Serialize an object.

          serialize(self) -> str
          serialize(self, casadi::SerializingStream & s)




        .......

        ::

          serialize(self, casadi::SerializingStream & s)



        Serialize an object.



        .............


        .......

        ::

          serialize(self)



        Serialize.



        .............



        """
        return _casadi.SX_serialize(self, *args)


    def deserialize(*args):
        """


        deserialize(std::istream & stream) -> SX
        deserialize(casadi::DeserializingStream & s) -> SX
        deserialize(str s) -> SX



        """
        return _casadi.SX_deserialize(*args)

    deserialize = staticmethod(deserialize)

    def to_file(self, *args):
        """
          Export numerical matrix to file

          to_file(self, str filename, str format)


        Supported formats:



        ::

          *   - .mtx   Matrix Market (sparse)
          *   - .txt   Ascii full precision representation (sparse)
          *            Whitespace separated, aligned.
          *            Comments with # % or /
          *            Uses C locale
          *            Structural zeros represented by 00
          *            Does not scale well for large sparse matrices
          * 






        """
        return _casadi.SX_to_file(self, *args)


    def from_file(*args):
        """
          Export numerical matrix to file

          from_file(str filename, str format_hint) -> DM


        Supported formats:



        ::

          *   - .mtx   Matrix Market (sparse)
          *   - .txt   Ascii full precision representation (sparse)
          *            Whitespace separated, aligned.
          *            Comments with # % or /
          *            Uses C locale
          *            Structural zeros represented by 00
          *            Does not scale well for large sparse matrices
          * 






        """
        return _casadi.SX_from_file(*args)

    from_file = staticmethod(from_file)

    @property
    def shape(self):
        return (self.size1(),self.size2())

    def reshape(self,arg):
        return _casadi.reshape(self,arg)

    @property
    def T(self):
        return _casadi.transpose(self)

    def __getitem__(self, s):
          if isinstance(s, tuple) and len(s)==2:
            if s[1] is None: raise TypeError("Cannot slice with None")
            return self.get(False, s[0], s[1])
          return self.get(False, s)

    def __iter__(self):
      raise Exception("""CasADi matrices are not iterable by design.
                      Did you mean to iterate over m.nz, with m IM/DM/SX?
                      Did you mean to iterate over horzsplit(m,1)/vertsplit(m,1) with m IM/DM/SX/MX?
                      """)

    def __setitem__(self,s,val):
          if isinstance(s,tuple) and len(s)==2:
            return self.set(val, False, s[0], s[1])
          return self.set(val, False, s)

    @property
    def nz(self):
      return NZproxy(self)




    __array_priority__ = 1001.0

    def __array_wrap__(self,out_arr,context=None):
      if context is None:
        return out_arr
      name = context[0].__name__
      args = list(context[1])

      if len(context[1])==3:
        raise Exception("Error with %s. Looks like you are using an assignment operator, such as 'a+=b' where 'a' is a numpy type. This is not supported, and cannot be supported without changing numpy." % name)

      if "vectorized" in name:
          name = name[:-len(" (vectorized)")]

      conversion = {"multiply": "mul", "divide": "div", "true_divide": "div", "subtract":"sub","power":"pow","greater_equal":"ge","less_equal": "le", "less": "lt", "greater": "gt"}
      if name in conversion:
        name = conversion[name]
      if len(context[1])==2 and context[1][1] is self and not(context[1][0] is self):
        name = 'r' + name
        args.reverse()
      if not(hasattr(self,name)) or ('mul' in name):
        name = '__' + name + '__'
      fun=getattr(self, name)
      return fun(*args[1:])

    def __array_ufunc__(self, ufunc, method, *inputs, **kwargs):
      conversion = {"multiply": "mul", "divide": "div", "true_divide": "div", "subtract":"sub","power":"pow","greater_equal":"ge","less_equal": "le", "less": "lt", "greater": "gt"}
      name = ufunc.__name__
      inputs = list(inputs)
      if len(inputs)==3:
        import warnings
        warnings.warn("Error with %s. Looks like you are using an assignment operator, such as 'a+=b' where 'a' is a numpy type. This is not supported, and cannot be supported without changing numpy." % name, RuntimeWarning)
        return NotImplemented
      if "vectorized" in name:
          name = name[:-len(" (vectorized)")]
      if name in conversion:
        name = conversion[name]
      if len(inputs)==2 and inputs[1] is self and not(inputs[0] is self):
        name = 'r' + name
        inputs.reverse()
      if not(hasattr(self,name)) or ('mul' in name):
        name = '__' + name + '__'
      try:
        assert method=="__call__"
        fun=getattr(self, name)
        return fun(*inputs[1:])
      except:
#Fall back to numpy conversion
        new_inputs = list(inputs)
        try:
          new_inputs[0] = new_inputs[0].full()
        except:
          import warnings
          warnings.warn("Implicit conversion of symbolic CasADi type to numeric matrix not supported.\n"
                                 + "This may occur when you pass a CasADi object to a numpy function.\n"
                                 + "Use an equivalent CasADi function instead of that numpy function.", RuntimeWarning)
          return NotImplemented
        return new_inputs[0].__array_ufunc__(ufunc, method, *new_inputs, **kwargs)


    def __array__(self,*args,**kwargs):
      import numpy as n
      if len(args) > 1 and isinstance(args[1],tuple) and isinstance(args[1][0],n.ufunc) and isinstance(args[1][0],n.ufunc) and len(args[1])>1 and args[1][0].nin==len(args[1][1]):
        if len(args[1][1])==3:
          raise Exception("Error with %s. Looks like you are using an assignment operator, such as 'a+=b'. This is not supported when 'a' is a numpy type, and cannot be supported without changing numpy itself. Either upgrade a to a CasADi type first, or use 'a = a + b'. " % args[1][0].__name__)
        return n.array([n.nan])
      else:
        if hasattr(self,'__array_custom__'):
          return self.__array_custom__(*args,**kwargs)
        else:
          try:
            return self.full()
          except:
            raise Exception("Implicit conversion of symbolic CasADi type to numeric matrix not supported.\n"
                       + "This may occur when you pass a CasADi object to a numpy function.\n"
                       + "Use an equivalent CasADi function instead of that numpy function.")



    def __init__(self, *args):
        """


        SX()
        SX(Sparsity sp)
        SX(float val)
        SX([[float]] m)
        SX([float] x)
        SX(DM x)
        SX(SX m)
        SX(int nrow, int ncol)
        SX(Sparsity sp, SX d)



        """
        this = _casadi.new_SX(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_SX
SX_swigregister = _casadi.SX_swigregister
SX_swigregister(SX)

def SX_binary(*args):
    """


    binary(int op, SX x, SX y) -> SX



    """
    return _casadi.SX_binary(*args)

def SX_unary(*args):
    """


    unary(int op, SX x) -> SX



    """
    return _casadi.SX_unary(*args)

def SX_scalar_matrix(*args):
    """


    scalar_matrix(int op, SX x, SX y) -> SX



    """
    return _casadi.SX_scalar_matrix(*args)

def SX_matrix_scalar(*args):
    """


    matrix_scalar(int op, SX x, SX y) -> SX



    """
    return _casadi.SX_matrix_scalar(*args)

def SX_matrix_matrix(*args):
    """


    matrix_matrix(int op, SX x, SX y) -> SX



    """
    return _casadi.SX_matrix_matrix(*args)

def SX_set_max_depth(*args):
    """


    set_max_depth(int eq_depth)



    """
    return _casadi.SX_set_max_depth(*args)

def SX_get_max_depth(*args):
    """


    get_max_depth() -> int



    """
    return _casadi.SX_get_max_depth(*args)

def SX_get_input(*args):
    """


    get_input(Function f) -> [SX]



    """
    return _casadi.SX_get_input(*args)

def SX_get_free(*args):
    """


    get_free(Function f) -> [SX]



    """
    return _casadi.SX_get_free(*args)

def SX_type_name(*args):
    """


    type_name() -> str



    """
    return _casadi.SX_type_name(*args)

def SX_triplet(*args):
    """


    triplet([int] row, [int] col, SX d) -> SX
    triplet([int] row, [int] col, SX d, (int,int) rc) -> SX
    triplet([int] row, [int] col, SX d, int nrow, int ncol) -> SX



    """
    return _casadi.SX_triplet(*args)

def SX_inf(*args):
    """
    create a matrix with all inf

    inf(int nrow, int ncol) -> SX
    inf((int,int) rc) -> SX
    inf(Sparsity sp) -> SX





    """
    return _casadi.SX_inf(*args)

def SX_nan(*args):
    """
    create a matrix with all nan

    nan(int nrow, int ncol) -> SX
    nan((int,int) rc) -> SX
    nan(Sparsity sp) -> SX





    """
    return _casadi.SX_nan(*args)

def SX_eye(*args):
    """


    eye(int n) -> SX



    """
    return _casadi.SX_eye(*args)

def SX_set_precision(*args):
    """
      Set the 'precision, width & scientific' used in printing and serializing to

      set_precision(int precision)

    streams.




    """
    return _casadi.SX_set_precision(*args)

def SX_set_width(*args):
    """
      Set the 'precision, width & scientific' used in printing and serializing to

      set_width(int width)

    streams.




    """
    return _casadi.SX_set_width(*args)

def SX_set_scientific(*args):
    """
      Set the 'precision, width & scientific' used in printing and serializing to

      set_scientific(bool scientific)

    streams.




    """
    return _casadi.SX_set_scientific(*args)

def SX_rng(*args):
    """


    rng(int seed)



    """
    return _casadi.SX_rng(*args)

def SX_rand(*args):
    """
    Create a matrix with uniformly distributed random numbers.

    rand(int nrow, int ncol) -> SX
    rand((int,int) rc) -> SX
    rand(Sparsity sp) -> SX





    """
    return _casadi.SX_rand(*args)

def SX_deserialize(*args):
    """


    deserialize(std::istream & stream) -> SX
    deserialize(casadi::DeserializingStream & s) -> SX
    deserialize(str s) -> SX



    """
    return _casadi.SX_deserialize(*args)

def SX_from_file(*args):
    """
      Export numerical matrix to file

      from_file(str filename, str format_hint) -> DM


    Supported formats:



    ::

      *   - .mtx   Matrix Market (sparse)
      *   - .txt   Ascii full precision representation (sparse)
      *            Whitespace separated, aligned.
      *            Comments with # % or /
      *            Uses C locale
      *            Structural zeros represented by 00
      *            Does not scale well for large sparse matrices
      * 






    """
    return _casadi.SX_from_file(*args)

class MX(GenericExpressionCommon, PrintableCommon, GenMX, SharedObject):
    """
      MX - Matrix expression.



    The MX class is used to build up trees made up from MXNodes. It is a more
    general graph representation than the scalar expression, SX, and much less
    efficient for small objects. On the other hand, the class allows much more
    general operations than does SX, in particular matrix valued operations and
    calls to arbitrary differentiable functions.

    The MX class is designed to have identical syntax with the Matrix<> template
    class, and uses DM (i.e. Matrix<double>) as its internal representation of
    the values at a node. By keeping the syntaxes identical, it is possible to
    switch from one class to the other, as well as inlining MX functions to
    SXElem functions.

    Note that an operation is always "lazy", making a matrix multiplication
    will create a matrix multiplication node, not perform the actual
    multiplication.

    Joel Andersson

    C++ includes: mx.hpp 


    """

    __swig_setmethods__ = {}
    for _s in [GenericExpressionCommon, PrintableCommon, GenMX, SharedObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MX, name, value)
    __swig_getmethods__ = {}
    for _s in [GenericExpressionCommon, PrintableCommon, GenMX, SharedObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MX, name)
    __repr__ = _swig_repr

    def type_name(*args):
        """


        type_name() -> str



        """
        return _casadi.MX_type_name(*args)

    type_name = staticmethod(type_name)

    def __init__(self, *args):
        """


          MX()
          MX(Sparsity sp)
          MX(float x)
          MX(DM x)
          MX(MX x)
          MX(int nrow, int ncol)
          MX(Sparsity sp, MX val)
          MX(Sparsity sp, str fname)


        .......

        ::

          MX(DM x)



        .............


        .......

        ::

          MX(Sparsity sp)



        Create a sparse matrix from a sparsity pattern. Same as MX::ones(sparsity)



        .............


        .......

        ::

          MX(Sparsity sp, MX val)



        Construct matrix with a given sparsity and nonzeros.



        .............


        .......

        ::

          MX()



        Default constructor.



        .............


        .......

        ::

          MX(float x)



        Create scalar constant (also implicit type conversion)



        .............


        .......

        ::

          MX(MX x)



        Copy constructor.



        .............


        .......

        ::

          MX(int nrow, int ncol)



        Create a sparse matrix with all structural zeros.



        .............


        .......

        ::

          MX(Sparsity sp, str fname)



        Construct matrix with a given sparsity and a file with nonzeros.



        .............



        """
        this = _casadi.new_MX(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_MX

    def __bool__(self, *args):
        """
        Returns the truth value of an MX expression.

        __bool__(self) -> bool





        """
        return _casadi.MX___bool__(self, *args)


    def sparsity(self, *args):
        """
        Get an owning reference to the sparsity pattern.

        sparsity(self) -> Sparsity





        """
        return _casadi.MX_sparsity(self, *args)


    def erase(self, *args):
        """
          Erase a submatrix (leaving structural zeros in its place) Erase elements of

          erase(self, [int] rr, bool ind1)
          erase(self, [int] rr, [int] cc, bool ind1)

        a matrix.



        .......

        ::

          erase(self, [int] rr, bool ind1)



        Erase a submatrix (leaving structural zeros in its place) Erase elements of
        a matrix.



        .............


        .......

        ::

          erase(self, [int] rr, [int] cc, bool ind1)



        Erase a submatrix (leaving structural zeros in its place) Erase rows and/or
        columns of a matrix.



        .............



        """
        return _casadi.MX_erase(self, *args)


    def enlarge(self, *args):
        """
          Enlarge matrix Make the matrix larger by inserting empty rows and columns,

          enlarge(self, int nrow, int ncol, [int] rr, [int] cc, bool ind1)

        keeping the existing non-zeros.




        """
        return _casadi.MX_enlarge(self, *args)


    def __neg__(self, *args):
        """


        __neg__(self) -> MX



        """
        return _casadi.MX___neg__(self, *args)


    def dep(self, *args):
        """
        Get the nth dependency as MX.

        dep(self, int ch) -> MX





        """
        return _casadi.MX_dep(self, *args)


    def n_out(self, *args):
        """
        Number of outputs.

        n_out(self) -> int





        """
        return _casadi.MX_n_out(self, *args)


    def get_output(self, *args):
        """
        Get an output.

        get_output(self, int oind) -> MX





        """
        return _casadi.MX_get_output(self, *args)


    def n_dep(self, *args):
        """
        Get the number of dependencies of a binary SXElem.

        n_dep(self) -> int





        """
        return _casadi.MX_n_dep(self, *args)


    def name(self, *args):
        """
        Get the name.

        name(self) -> str





        """
        return _casadi.MX_name(self, *args)


    def __float__(self, *args):
        """


        __float__(self) -> float



        """
        return _casadi.MX___float__(self, *args)


    def to_DM(self, *args):
        """


        to_DM(self) -> DM



        """
        return _casadi.MX_to_DM(self, *args)


    def is_symbolic(self, *args):
        """
        Check if symbolic.

        is_symbolic(self) -> bool





        """
        return _casadi.MX_is_symbolic(self, *args)


    def is_constant(self, *args):
        """
        Check if constant.

        is_constant(self) -> bool





        """
        return _casadi.MX_is_constant(self, *args)


    def is_call(self, *args):
        """
        Check if evaluation.

        is_call(self) -> bool





        """
        return _casadi.MX_is_call(self, *args)


    def which_function(self, *args):
        """
        Get function - only valid when is_call() is true.

        which_function(self) -> Function





        """
        return _casadi.MX_which_function(self, *args)


    def is_output(self, *args):
        """
        Check if evaluation output.

        is_output(self) -> bool





        """
        return _casadi.MX_is_output(self, *args)


    def which_output(self, *args):
        """
        Get the index of evaluation output - only valid when is_output() is true.

        which_output(self) -> int





        """
        return _casadi.MX_which_output(self, *args)


    def is_op(self, *args):
        """
        Is it a certain operation.

        is_op(self, int op) -> bool





        """
        return _casadi.MX_is_op(self, *args)


    def is_multiplication(self, *args):
        """
        Check if multiplication.

        is_multiplication(self) -> bool





        """
        return _casadi.MX_is_multiplication(self, *args)


    def is_commutative(self, *args):
        """
        Check if commutative operation.

        is_commutative(self) -> bool





        """
        return _casadi.MX_is_commutative(self, *args)


    def is_norm(self, *args):
        """
        Check if norm.

        is_norm(self) -> bool





        """
        return _casadi.MX_is_norm(self, *args)


    def is_valid_input(self, *args):
        """
          Check if matrix can be used to define function inputs. Valid inputs for

          is_valid_input(self) -> bool

        MXFunctions are combinations of Reshape, concatenations and SymbolicMX.




        """
        return _casadi.MX_is_valid_input(self, *args)


    def n_primitives(self, *args):
        """
        Get the number of primitives for MXFunction inputs/outputs.

        n_primitives(self) -> int





        """
        return _casadi.MX_n_primitives(self, *args)


    def primitives(self, *args):
        """
        Get primitives.

        primitives(self) -> [MX]





        """
        return _casadi.MX_primitives(self, *args)


    def split_primitives(self, *args):
        """
        Split up an expression along symbolic primitives.

        split_primitives(self, MX x) -> [MX]





        """
        return _casadi.MX_split_primitives(self, *args)


    def join_primitives(self, *args):
        """
        Join an expression along symbolic primitives.

        join_primitives(self, [MX] v) -> MX





        """
        return _casadi.MX_join_primitives(self, *args)


    def has_duplicates(self, *args):
        """
          [INTERNAL]  Detect duplicate symbolic expressions If there are symbolic

          has_duplicates(self) -> bool

        primitives appearing more than once, the function will return true and the
        names of the duplicate expressions will be passed to casadi_warning. Note:
        Will mark the node using MX::set_temp. Make sure to call reset_input() after
        usage.




        """
        return _casadi.MX_has_duplicates(self, *args)


    def reset_input(self, *args):
        """
        [INTERNAL]  Reset the marker for an input expression.

        reset_input(self)





        """
        return _casadi.MX_reset_input(self, *args)


    def is_eye(self, *args):
        """
        check if identity

        is_eye(self) -> bool





        """
        return _casadi.MX_is_eye(self, *args)


    def is_zero(self, *args):
        """
        check if zero (note that false negative answers are possible)

        is_zero(self) -> bool





        """
        return _casadi.MX_is_zero(self, *args)


    def is_one(self, *args):
        """
        check if zero (note that false negative answers are possible)

        is_one(self) -> bool





        """
        return _casadi.MX_is_one(self, *args)


    def is_minus_one(self, *args):
        """
        check if zero (note that false negative answers are possible)

        is_minus_one(self) -> bool





        """
        return _casadi.MX_is_minus_one(self, *args)


    def is_transpose(self, *args):
        """
        Is the expression a transpose?

        is_transpose(self) -> bool





        """
        return _casadi.MX_is_transpose(self, *args)


    def is_regular(self, *args):
        """
        Checks if expression does not contain NaN or Inf.

        is_regular(self) -> bool





        """
        return _casadi.MX_is_regular(self, *args)


    def is_binary(self, *args):
        """
        Is binary operation.

        is_binary(self) -> bool





        """
        return _casadi.MX_is_binary(self, *args)


    def is_unary(self, *args):
        """
        Is unary operation.

        is_unary(self) -> bool





        """
        return _casadi.MX_is_unary(self, *args)


    def op(self, *args):
        """
        Get operation type.

        op(self) -> int





        """
        return _casadi.MX_op(self, *args)


    def info(self, *args):
        """
        Obtain information about node

        info(self) -> dict





        """
        return _casadi.MX_info(self, *args)


    def serialize(self, *args):
        """
        Serialize an object.

        serialize(self, casadi::SerializingStream & s)





        """
        return _casadi.MX_serialize(self, *args)


    def deserialize(*args):
        """


        deserialize(casadi::DeserializingStream & s) -> MX



        """
        return _casadi.MX_deserialize(*args)

    deserialize = staticmethod(deserialize)

    def get_temp(self, *args):
        """
        [INTERNAL]  Get the temporary variable

        get_temp(self) -> int





        """
        return _casadi.MX_get_temp(self, *args)


    def set_temp(self, *args):
        """
        [INTERNAL]  Set the temporary variable.

        set_temp(self, int t)





        """
        return _casadi.MX_set_temp(self, *args)


    def binary(*args):
        """
        Create nodes by their ID.

        binary(int op, MX x, MX y) -> MX





        """
        return _casadi.MX_binary(*args)

    binary = staticmethod(binary)

    def unary(*args):
        """
        Create nodes by their ID.

        unary(int op, MX x) -> MX





        """
        return _casadi.MX_unary(*args)

    unary = staticmethod(unary)

    def inf(*args):
        """
        create a matrix with all inf

        inf(int nrow, int ncol) -> MX
        inf((int,int) rc) -> MX
        inf(Sparsity sp) -> MX





        """
        return _casadi.MX_inf(*args)

    inf = staticmethod(inf)

    def nan(*args):
        """
        create a matrix with all nan

        nan(int nrow, int ncol) -> MX
        nan((int,int) rc) -> MX
        nan(Sparsity sp) -> MX





        """
        return _casadi.MX_nan(*args)

    nan = staticmethod(nan)

    def eye(*args):
        """


        eye(int n) -> MX



        """
        return _casadi.MX_eye(*args)

    eye = staticmethod(eye)

    def get(self, *args):
        """
          Get a submatrix, two arguments

          get(self, bool ind1, int rr) -> MX
          get(self, bool ind1, Sparsity sp) -> MX
          get(self, bool ind1, Slice rr) -> MX
          get(self, bool ind1, IM rr) -> MX
          get(self, bool ind1, MX rr) -> MX
          get(self, bool ind1, int rr, int cc) -> MX
          get(self, bool ind1, int rr, Slice cc) -> MX
          get(self, bool ind1, Slice rr, int cc) -> MX
          get(self, bool ind1, Slice rr, Slice cc) -> MX
          get(self, bool ind1, Slice rr, IM cc) -> MX
          get(self, bool ind1, Slice rr, MX cc) -> MX
          get(self, bool ind1, IM rr, Slice cc) -> MX
          get(self, bool ind1, IM rr, IM cc) -> MX
          get(self, bool ind1, MX rr, Slice cc) -> MX
          get(self, bool ind1, MX rr, MX cc) -> MX




        .......

        ::

          get(self, bool ind1, IM rr)
          get(self, bool ind1, Slice rr, IM cc)
          get(self, bool ind1, IM rr, Slice cc)
          get(self, bool ind1, IM rr, IM cc)



        .............


        .......

        ::

          get(self, bool ind1, int rr)
          get(self, bool ind1, Sparsity sp)
          get(self, bool ind1, Slice rr)
          get(self, bool ind1, MX rr)



        Get a submatrix, single argument



        .............


        .......

        ::

          get(self, bool ind1, int rr, int cc)
          get(self, bool ind1, int rr, Slice cc)
          get(self, bool ind1, Slice rr, int cc)
          get(self, bool ind1, Slice rr, Slice cc)
          get(self, bool ind1, Slice rr, MX cc)
          get(self, bool ind1, MX rr, Slice cc)
          get(self, bool ind1, MX rr, MX cc)



        Get a submatrix, two arguments



        .............



        """
        return _casadi.MX_get(self, *args)


    def set(self, *args):
        """


          set(self, MX m, bool ind1, Sparsity sp)
          set(self, MX m, bool ind1, Slice rr)
          set(self, MX m, bool ind1, IM rr)
          set(self, MX m, bool ind1, Slice rr, Slice cc)
          set(self, MX m, bool ind1, Slice rr, IM cc)
          set(self, MX m, bool ind1, IM rr, Slice cc)
          set(self, MX m, bool ind1, IM rr, IM cc)


        .......

        ::

          set(self, MX m, bool ind1, IM rr)
          set(self, MX m, bool ind1, Slice rr, Slice cc)
          set(self, MX m, bool ind1, Slice rr, IM cc)
          set(self, MX m, bool ind1, IM rr, Slice cc)
          set(self, MX m, bool ind1, IM rr, IM cc)



        .............


        .......

        ::

          set(self, MX m, bool ind1, Sparsity sp)
          set(self, MX m, bool ind1, Slice rr)



        Set a submatrix, single argument



        .............



        """
        return _casadi.MX_set(self, *args)


    def get_nz(self, *args):
        """
          Get a set of nonzeros

          get_nz(self, bool ind1, int kk) -> MX
          get_nz(self, bool ind1, Slice kk) -> MX
          get_nz(self, bool ind1, IM kk) -> MX
          get_nz(self, bool ind1, MX kk) -> MX
          get_nz(self, bool ind1, Slice inner, MX outer) -> MX
          get_nz(self, bool ind1, MX inner, Slice outer) -> MX
          get_nz(self, bool ind1, MX inner, MX outer) -> MX




        .......

        ::

          get_nz(self, bool ind1, IM kk)



        .............


        .......

        ::

          get_nz(self, bool ind1, int kk)
          get_nz(self, bool ind1, Slice kk)
          get_nz(self, bool ind1, MX kk)
          get_nz(self, bool ind1, Slice inner, MX outer)
          get_nz(self, bool ind1, MX inner, Slice outer)
          get_nz(self, bool ind1, MX inner, MX outer)



        Get a set of nonzeros



        .............



        """
        return _casadi.MX_get_nz(self, *args)


    def set_nz(self, *args):
        """
          Set a set of nonzeros

          set_nz(self, MX m, bool ind1, int kk)
          set_nz(self, MX m, bool ind1, Slice kk)
          set_nz(self, MX m, bool ind1, IM kk)
          set_nz(self, MX m, bool ind1, MX kk)




        .......

        ::

          set_nz(self, MX m, bool ind1, IM kk)



        .............


        .......

        ::

          set_nz(self, MX m, bool ind1, int kk)
          set_nz(self, MX m, bool ind1, Slice kk)
          set_nz(self, MX m, bool ind1, MX kk)



        Set a set of nonzeros



        .............



        """
        return _casadi.MX_set_nz(self, *args)


    def einstein(*args):
        """
          Computes an einstein dense tensor contraction.

          einstein(MX A, MX B, [int] dim_a, [int] dim_b, [int] dim_c, [int] a, [int] b, [int] c) -> MX
          einstein(MX A, MX B, MX C, [int] dim_a, [int] dim_b, [int] dim_c, [int] a, [int] b, [int] c) -> MX


        Computes the product: C_c = A_a + B_b where a b c are index/einstein
        notation in an encoded form

        For example, an matrix-matrix product may be written as: C_ij = A_ik B_kj

        The encoded form uses strictly negative numbers to indicate labels. For the
        above example, we would have: a {-1, -3} b {-3, -2} c {-1 -2}




        """
        return _casadi.MX_einstein(*args)

    einstein = staticmethod(einstein)

    def bspline_dual(*args):
        """
        Find first nonzero If failed, returns the number of rows.

        bspline_dual([float] x, [[float]] knots, [int] degree, dict opts) -> DM





        """
        return _casadi.MX_bspline_dual(*args)

    bspline_dual = staticmethod(bspline_dual)

    def interpn_linear(*args):
        """


        interpn_linear([MX] x, MX v, [MX] xq, dict opts) -> MX



        """
        return _casadi.MX_interpn_linear(*args)

    interpn_linear = staticmethod(interpn_linear)

    def printme(self, *args):
        """


        printme(self, MX b) -> MX



        """
        return _casadi.MX_printme(self, *args)


    def attachAssert(self, *args):
        """
          returns itself, but with an assertion attached

          attachAssert(self, MX y, str fail_message) -> MX


        If y does not evaluate to 1, a runtime error is raised




        """
        return _casadi.MX_attachAssert(self, *args)


    def monitor(self, *args):
        """
          Monitor an expression Returns itself, but with the side effect of printing

          monitor(self, str comment) -> MX

        the nonzeros along with a comment.




        """
        return _casadi.MX_monitor(self, *args)


    def mapping(self, *args):
        """
        Get an IM representation of a GetNonzeros or SetNonzeros node.

        mapping(self) -> IM





        """
        return _casadi.MX_mapping(self, *args)


    def set_max_depth(*args):
        """


        set_max_depth(int eq_depth)



        """
        return _casadi.MX_set_max_depth(*args)

    set_max_depth = staticmethod(set_max_depth)

    def get_max_depth(*args):
        """


        get_max_depth() -> int



        """
        return _casadi.MX_get_max_depth(*args)

    get_max_depth = staticmethod(get_max_depth)

    def test_cast(*args):
        """


        test_cast(casadi::SharedObjectInternal const * ptr) -> bool



        """
        return _casadi.MX_test_cast(*args)

    test_cast = staticmethod(test_cast)

    def get_input(*args):
        """


        get_input(Function f) -> [MX]



        """
        return _casadi.MX_get_input(*args)

    get_input = staticmethod(get_input)

    def get_free(*args):
        """


        get_free(Function f) -> [MX]



        """
        return _casadi.MX_get_free(*args)

    get_free = staticmethod(get_free)

    @property
    def shape(self):
        return (self.size1(),self.size2())

    def reshape(self,arg):
        return _casadi.reshape(self,arg)

    @property
    def T(self):
        return _casadi.transpose(self)

    def __getitem__(self, s):
          if isinstance(s, tuple) and len(s)==2:
            if s[1] is None: raise TypeError("Cannot slice with None")
            return self.get(False, s[0], s[1])
          return self.get(False, s)

    def __iter__(self):
      raise Exception("""CasADi matrices are not iterable by design.
                      Did you mean to iterate over m.nz, with m IM/DM/SX?
                      Did you mean to iterate over horzsplit(m,1)/vertsplit(m,1) with m IM/DM/SX/MX?
                      """)

    def __setitem__(self,s,val):
          if isinstance(s,tuple) and len(s)==2:
            return self.set(val, False, s[0], s[1])
          return self.set(val, False, s)

    @property
    def nz(self):
      return NZproxy(self)




    __array_priority__ = 1002.0

    def __array_wrap__(self,out_arr,context=None):
      if context is None:
        return out_arr
      name = context[0].__name__
      args = list(context[1])

      if len(context[1])==3:
        raise Exception("Error with %s. Looks like you are using an assignment operator, such as 'a+=b' where 'a' is a numpy type. This is not supported, and cannot be supported without changing numpy." % name)

      if "vectorized" in name:
          name = name[:-len(" (vectorized)")]

      conversion = {"multiply": "mul", "divide": "div", "true_divide": "div", "subtract":"sub","power":"pow","greater_equal":"ge","less_equal": "le", "less": "lt", "greater": "gt"}
      if name in conversion:
        name = conversion[name]
      if len(context[1])==2 and context[1][1] is self and not(context[1][0] is self):
        name = 'r' + name
        args.reverse()
      if not(hasattr(self,name)) or ('mul' in name):
        name = '__' + name + '__'
      fun=getattr(self, name)
      return fun(*args[1:])

    def __array_ufunc__(self, ufunc, method, *inputs, **kwargs):
      conversion = {"multiply": "mul", "divide": "div", "true_divide": "div", "subtract":"sub","power":"pow","greater_equal":"ge","less_equal": "le", "less": "lt", "greater": "gt"}
      name = ufunc.__name__
      inputs = list(inputs)
      if len(inputs)==3:
        import warnings
        warnings.warn("Error with %s. Looks like you are using an assignment operator, such as 'a+=b' where 'a' is a numpy type. This is not supported, and cannot be supported without changing numpy." % name, RuntimeWarning)
        return NotImplemented
      if "vectorized" in name:
          name = name[:-len(" (vectorized)")]
      if name in conversion:
        name = conversion[name]
      if len(inputs)==2 and inputs[1] is self and not(inputs[0] is self):
        name = 'r' + name
        inputs.reverse()
      if not(hasattr(self,name)) or ('mul' in name):
        name = '__' + name + '__'
      try:
        assert method=="__call__"
        fun=getattr(self, name)
        return fun(*inputs[1:])
      except:
#Fall back to numpy conversion
        new_inputs = list(inputs)
        try:
          new_inputs[0] = new_inputs[0].full()
        except:
          import warnings
          warnings.warn("Implicit conversion of symbolic CasADi type to numeric matrix not supported.\n"
                                 + "This may occur when you pass a CasADi object to a numpy function.\n"
                                 + "Use an equivalent CasADi function instead of that numpy function.", RuntimeWarning)
          return NotImplemented
        return new_inputs[0].__array_ufunc__(ufunc, method, *new_inputs, **kwargs)


    def __array__(self,*args,**kwargs):
      import numpy as n
      if len(args) > 1 and isinstance(args[1],tuple) and isinstance(args[1][0],n.ufunc) and isinstance(args[1][0],n.ufunc) and len(args[1])>1 and args[1][0].nin==len(args[1][1]):
        if len(args[1][1])==3:
          raise Exception("Error with %s. Looks like you are using an assignment operator, such as 'a+=b'. This is not supported when 'a' is a numpy type, and cannot be supported without changing numpy itself. Either upgrade a to a CasADi type first, or use 'a = a + b'. " % args[1][0].__name__)
        return n.array([n.nan])
      else:
        if hasattr(self,'__array_custom__'):
          return self.__array_custom__(*args,**kwargs)
        else:
          try:
            return self.full()
          except:
            raise Exception("Implicit conversion of symbolic CasADi type to numeric matrix not supported.\n"
                       + "This may occur when you pass a CasADi object to a numpy function.\n"
                       + "Use an equivalent CasADi function instead of that numpy function.")


MX_swigregister = _casadi.MX_swigregister
MX_swigregister(MX)

def MX_type_name(*args):
    """


    type_name() -> str



    """
    return _casadi.MX_type_name(*args)

def MX_deserialize(*args):
    """


    deserialize(casadi::DeserializingStream & s) -> MX



    """
    return _casadi.MX_deserialize(*args)

def MX_binary(*args):
    """
    Create nodes by their ID.

    binary(int op, MX x, MX y) -> MX





    """
    return _casadi.MX_binary(*args)

def MX_unary(*args):
    """
    Create nodes by their ID.

    unary(int op, MX x) -> MX





    """
    return _casadi.MX_unary(*args)

def MX_inf(*args):
    """
    create a matrix with all inf

    inf(int nrow, int ncol) -> MX
    inf((int,int) rc) -> MX
    inf(Sparsity sp) -> MX





    """
    return _casadi.MX_inf(*args)

def MX_nan(*args):
    """
    create a matrix with all nan

    nan(int nrow, int ncol) -> MX
    nan((int,int) rc) -> MX
    nan(Sparsity sp) -> MX





    """
    return _casadi.MX_nan(*args)

def MX_eye(*args):
    """


    eye(int n) -> MX



    """
    return _casadi.MX_eye(*args)

def MX_einstein(*args):
    """
      Computes an einstein dense tensor contraction.

      einstein(MX A, MX B, [int] dim_a, [int] dim_b, [int] dim_c, [int] a, [int] b, [int] c) -> MX
      einstein(MX A, MX B, MX C, [int] dim_a, [int] dim_b, [int] dim_c, [int] a, [int] b, [int] c) -> MX


    Computes the product: C_c = A_a + B_b where a b c are index/einstein
    notation in an encoded form

    For example, an matrix-matrix product may be written as: C_ij = A_ik B_kj

    The encoded form uses strictly negative numbers to indicate labels. For the
    above example, we would have: a {-1, -3} b {-3, -2} c {-1 -2}




    """
    return _casadi.MX_einstein(*args)

def MX_bspline_dual(*args):
    """
    Find first nonzero If failed, returns the number of rows.

    bspline_dual([float] x, [[float]] knots, [int] degree, dict opts) -> DM





    """
    return _casadi.MX_bspline_dual(*args)

def MX_interpn_linear(*args):
    """


    interpn_linear([MX] x, MX v, [MX] xq, dict opts) -> MX



    """
    return _casadi.MX_interpn_linear(*args)

def MX_set_max_depth(*args):
    """


    set_max_depth(int eq_depth)



    """
    return _casadi.MX_set_max_depth(*args)

def MX_get_max_depth(*args):
    """


    get_max_depth() -> int



    """
    return _casadi.MX_get_max_depth(*args)

def MX_test_cast(*args):
    """


    test_cast(casadi::SharedObjectInternal const * ptr) -> bool



    """
    return _casadi.MX_test_cast(*args)

def MX_get_input(*args):
    """


    get_input(Function f) -> [MX]



    """
    return _casadi.MX_get_input(*args)

def MX_get_free(*args):
    """


    get_free(Function f) -> [MX]



    """
    return _casadi.MX_get_free(*args)


def attach_return_type(f,t):
  if not(hasattr(f,'func_annotations')):
    f.func_annotations = {}
  if not(isinstance(getattr(f,'func_annotations'),dict)):
    raise Exception("Cannot annotate this python Method to be a sparsitygenerator. Method has func_annotations attribute with unknown type.")
  f.func_annotations["return"] = t
  return f

def pyevaluate(f):
  return attach_return_type(f,None)

def pycallback(f):
  return attach_return_type(f,int)


def pyfunction(inputs,outputs):
  def wrap(f):

    @pyevaluate
    def fcustom(f2):
      res = f([f2.getInput(i) for i in range(f2.n_in())])
      if not isinstance(res,list):
        res = [res]
      for i in range(f2.n_out()):
        f2.setOutput(res[i],i)
    import warnings

    with warnings.catch_warnings():
      warnings.filterwarnings("ignore",category=DeprecationWarning)
      Fun = CustomFunction("CustomFunction",fcustom,inputs,outputs)
      return Fun

  return wrap

def PyFunction(name, obj, inputs, outputs, opts={}):
    @pyevaluate
    def fcustom(f):
      res = [f.getOutput(i) for i in range(f.n_out())]
      obj.evaluate([f.getInput(i) for i in range(f.n_in())],res)
      for i in range(f.n_out()): f.setOutput(res[i], i)

    import warnings

    with warnings.catch_warnings():
      warnings.filterwarnings("ignore",category=DeprecationWarning)
      return CustomFunction("CustomFunction", fcustom,
                            inputs, outputs, opts)


class Function(SharedObject, PrintableCommon):
    """
      Function object A Function instance is a general multiple-input, multiple-


    output function where each input and output can be a sparse matrix. .

    For an introduction to this class, see the CasADi user guide. Function is a
    reference counted and immutable class; copying a class instance is very
    cheap and its behavior (with some exceptions) is not affected by calling its
    member functions. Joel Andersson >List of available options

    +------------------+-----------------+------------------+------------------+
    |        Id        |      Type       |   Description    |     Used in      |
    +==================+=================+==================+==================+
    | ad_weight        | OT_DOUBLE       | Weighting factor | casadi::Function |
    |                  |                 | for derivative   | Internal         |
    |                  |                 | calculation.When |                  |
    |                  |                 | there is an      |                  |
    |                  |                 | option of either |                  |
    |                  |                 | using forward or |                  |
    |                  |                 | reverse mode     |                  |
    |                  |                 | directional      |                  |
    |                  |                 | derivatives, the |                  |
    |                  |                 | condition ad_wei |                  |
    |                  |                 | ght*nf<=(1-ad_we |                  |
    |                  |                 | ight)*na is used |                  |
    |                  |                 | where nf and na  |                  |
    |                  |                 | are estimates of |                  |
    |                  |                 | the number of    |                  |
    |                  |                 | forward/reverse  |                  |
    |                  |                 | mode directional |                  |
    |                  |                 | derivatives      |                  |
    |                  |                 | needed. By       |                  |
    |                  |                 | default,         |                  |
    |                  |                 | ad_weight is     |                  |
    |                  |                 | calculated       |                  |
    |                  |                 | automatically,   |                  |
    |                  |                 | but this can be  |                  |
    |                  |                 | overridden by    |                  |
    |                  |                 | setting this     |                  |
    |                  |                 | option. In       |                  |
    |                  |                 | particular, 0    |                  |
    |                  |                 | means forcing    |                  |
    |                  |                 | forward mode and |                  |
    |                  |                 | 1 forcing        |                  |
    |                  |                 | reverse mode.    |                  |
    |                  |                 | Leave unset for  |                  |
    |                  |                 | (class specific) |                  |
    |                  |                 | heuristics.      |                  |
    +------------------+-----------------+------------------+------------------+
    | ad_weight_sp     | OT_DOUBLE       | Weighting factor | casadi::Function |
    |                  |                 | for sparsity     | Internal         |
    |                  |                 | pattern          |                  |
    |                  |                 | calculation calc |                  |
    |                  |                 | ulation.Override |                  |
    |                  |                 | s default        |                  |
    |                  |                 | behavior. Set to |                  |
    |                  |                 | 0 and 1 to force |                  |
    |                  |                 | forward and      |                  |
    |                  |                 | reverse mode     |                  |
    |                  |                 | respectively.    |                  |
    |                  |                 | Cf. option       |                  |
    |                  |                 | "ad_weight".     |                  |
    |                  |                 | When set to -1,  |                  |
    |                  |                 | sparsity is      |                  |
    |                  |                 | completely       |                  |
    |                  |                 | ignored and      |                  |
    |                  |                 | dense matrices   |                  |
    |                  |                 | are used.        |                  |
    +------------------+-----------------+------------------+------------------+
    | always_inline    | OT_BOOL         | Force inlining.  | casadi::Function |
    |                  |                 |                  | Internal         |
    +------------------+-----------------+------------------+------------------+
    | compiler         | OT_STRING       | Just-in-time     | casadi::Function |
    |                  |                 | compiler plugin  | Internal         |
    |                  |                 | to be used.      |                  |
    +------------------+-----------------+------------------+------------------+
    | custom_jacobian  | OT_FUNCTION     | Override         | casadi::Function |
    |                  |                 | CasADi's AD. Use | Internal         |
    |                  |                 | together with    |                  |
    |                  |                 | 'jac_penalty':   |                  |
    |                  |                 | 0. Note: Highly  |                  |
    |                  |                 | experimental.    |                  |
    |                  |                 | Syntax may break |                  |
    |                  |                 | often.           |                  |
    +------------------+-----------------+------------------+------------------+
    | derivative_of    | OT_FUNCTION     | The function is  | casadi::Function |
    |                  |                 | a derivative of  | Internal         |
    |                  |                 | another          |                  |
    |                  |                 | function. The    |                  |
    |                  |                 | type of          |                  |
    |                  |                 | derivative       |                  |
    |                  |                 | (directional     |                  |
    |                  |                 | derivative,      |                  |
    |                  |                 | Jacobian) is     |                  |
    |                  |                 | inferred from    |                  |
    |                  |                 | the function     |                  |
    |                  |                 | name.            |                  |
    +------------------+-----------------+------------------+------------------+
    | dump             | OT_BOOL         | Dump function to | casadi::Function |
    |                  |                 | file upon first  | Internal         |
    |                  |                 | evaluation.      |                  |
    |                  |                 | [false]          |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_dir         | OT_STRING       | Directory to     | casadi::Function |
    |                  |                 | dump             | Internal         |
    |                  |                 | inputs/outputs   |                  |
    |                  |                 | to. Make sure    |                  |
    |                  |                 | the directory    |                  |
    |                  |                 | exists [.]       |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_format      | OT_STRING       | Choose file      | casadi::Function |
    |                  |                 | format to dump   | Internal         |
    |                  |                 | matrices. See    |                  |
    |                  |                 | DM.from_file     |                  |
    |                  |                 | [mtx]            |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_in          | OT_BOOL         | Dump numerical   | casadi::Function |
    |                  |                 | values of inputs | Internal         |
    |                  |                 | to file          |                  |
    |                  |                 | (readable with   |                  |
    |                  |                 | DM.from_file )   |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_out         | OT_BOOL         | Dump numerical   | casadi::Function |
    |                  |                 | values of        | Internal         |
    |                  |                 | outputs to file  |                  |
    |                  |                 | (readable with   |                  |
    |                  |                 | DM.from_file )   |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_fd        | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation by   |                  |
    |                  |                 | finite           |                  |
    |                  |                 | differencing.    |                  |
    |                  |                 | [default:        |                  |
    |                  |                 | false]]          |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_forward   | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | Jacobian-times-  |                  |
    |                  |                 | vector products  |                  |
    |                  |                 | - typically      |                  |
    |                  |                 | using forward    |                  |
    |                  |                 | mode AD - if     |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_jacobian  | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | Jacobians of all |                  |
    |                  |                 | differentiable   |                  |
    |                  |                 | outputs with     |                  |
    |                  |                 | respect to all   |                  |
    |                  |                 | differentiable   |                  |
    |                  |                 | inputs - if      |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_reverse   | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | transposed       |                  |
    |                  |                 | Jacobian-times-  |                  |
    |                  |                 | vector products  |                  |
    |                  |                 | - typically      |                  |
    |                  |                 | using reverse    |                  |
    |                  |                 | mode AD - if     |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | fd_method        | OT_STRING       | Method for       | casadi::Function |
    |                  |                 | finite           | Internal         |
    |                  |                 | differencing     |                  |
    |                  |                 | [default         |                  |
    |                  |                 | 'central']       |                  |
    +------------------+-----------------+------------------+------------------+
    | fd_options       | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to the    | Internal         |
    |                  |                 | finite           |                  |
    |                  |                 | difference       |                  |
    |                  |                 | instance         |                  |
    +------------------+-----------------+------------------+------------------+
    | forward_options  | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to a      | Internal         |
    |                  |                 | forward mode     |                  |
    |                  |                 | constructor      |                  |
    +------------------+-----------------+------------------+------------------+
    | gather_stats     | OT_BOOL         | Deprecated       | casadi::Function |
    |                  |                 | option           | Internal         |
    |                  |                 | (ignored):       |                  |
    |                  |                 | Statistics are   |                  |
    |                  |                 | now always       |                  |
    |                  |                 | collected.       |                  |
    +------------------+-----------------+------------------+------------------+
    | input_scheme     | OT_STRINGVECTOR | Deprecated       | casadi::Function |
    |                  |                 | option (ignored) | Internal         |
    +------------------+-----------------+------------------+------------------+
    | inputs_check     | OT_BOOL         | Throw exceptions | casadi::Function |
    |                  |                 | when the         | Internal         |
    |                  |                 | numerical values |                  |
    |                  |                 | of the inputs    |                  |
    |                  |                 | don't make sense |                  |
    +------------------+-----------------+------------------+------------------+
    | is_diff_in       | OT_BOOLVECTOR   | Indicate for     | casadi::Function |
    |                  |                 | each input if it | Internal         |
    |                  |                 | should be        |                  |
    |                  |                 | differentiable.  |                  |
    +------------------+-----------------+------------------+------------------+
    | is_diff_out      | OT_BOOLVECTOR   | Indicate for     | casadi::Function |
    |                  |                 | each output if   | Internal         |
    |                  |                 | it should be     |                  |
    |                  |                 | differentiable.  |                  |
    +------------------+-----------------+------------------+------------------+
    | jac_penalty      | OT_DOUBLE       | When requested   | casadi::Function |
    |                  |                 | for a number of  | Internal         |
    |                  |                 | forward/reverse  |                  |
    |                  |                 | directions, it   |                  |
    |                  |                 | may be cheaper   |                  |
    |                  |                 | to compute first |                  |
    |                  |                 | the full         |                  |
    |                  |                 | jacobian and     |                  |
    |                  |                 | then multiply    |                  |
    |                  |                 | with seeds,      |                  |
    |                  |                 | rather than      |                  |
    |                  |                 | obtain the       |                  |
    |                  |                 | requested        |                  |
    |                  |                 | directions in a  |                  |
    |                  |                 | straightforward  |                  |
    |                  |                 | manner. Casadi   |                  |
    |                  |                 | uses a heuristic |                  |
    |                  |                 | to decide which  |                  |
    |                  |                 | is cheaper. A    |                  |
    |                  |                 | high value of    |                  |
    |                  |                 | 'jac_penalty'    |                  |
    |                  |                 | makes it less    |                  |
    |                  |                 | likely for the   |                  |
    |                  |                 | heurstic to      |                  |
    |                  |                 | chose the full   |                  |
    |                  |                 | Jacobian         |                  |
    |                  |                 | strategy. The    |                  |
    |                  |                 | special value -1 |                  |
    |                  |                 | indicates never  |                  |
    |                  |                 | to use the full  |                  |
    |                  |                 | Jacobian         |                  |
    |                  |                 | strategy         |                  |
    +------------------+-----------------+------------------+------------------+
    | jit              | OT_BOOL         | Use just-in-time | casadi::Function |
    |                  |                 | compiler to      | Internal         |
    |                  |                 | speed up the     |                  |
    |                  |                 | evaluation       |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_cleanup      | OT_BOOL         | Cleanup up the   | casadi::Function |
    |                  |                 | temporary source | Internal         |
    |                  |                 | file that jit    |                  |
    |                  |                 | creates.         |                  |
    |                  |                 | Default: true    |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_name         | OT_STRING       | The file name    | casadi::Function |
    |                  |                 | used to write    | Internal         |
    |                  |                 | out code. The    |                  |
    |                  |                 | actual file      |                  |
    |                  |                 | names used       |                  |
    |                  |                 | depend on 'jit_t |                  |
    |                  |                 | emp_suffix' and  |                  |
    |                  |                 | include          |                  |
    |                  |                 | extensions.      |                  |
    |                  |                 | Default:         |                  |
    |                  |                 | 'jit_tmp'        |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_options      | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to the    | Internal         |
    |                  |                 | jit compiler.    |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_serialize    | OT_STRING       | Specify          | casadi::Function |
    |                  |                 | behaviour when   | Internal         |
    |                  |                 | serializing a    |                  |
    |                  |                 | jitted function: |                  |
    |                  |                 | SOURCE|link|embe |                  |
    |                  |                 | d.               |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_temp_suffix  | OT_BOOL         | Use a temporary  | casadi::Function |
    |                  |                 | (seemingly       | Internal         |
    |                  |                 | random) filename |                  |
    |                  |                 | suffix for       |                  |
    |                  |                 | generated code   |                  |
    |                  |                 | and libraries.   |                  |
    |                  |                 | This is desired  |                  |
    |                  |                 | for thread-      |                  |
    |                  |                 | safety. This     |                  |
    |                  |                 | behaviour may    |                  |
    |                  |                 | defeat caching   |                  |
    |                  |                 | compiler         |                  |
    |                  |                 | wrappers.        |                  |
    |                  |                 | Default: true    |                  |
    +------------------+-----------------+------------------+------------------+
    | max_num_dir      | OT_INT          | Specify the      | casadi::Function |
    |                  |                 | maximum number   | Internal         |
    |                  |                 | of directions    |                  |
    |                  |                 | for derivative   |                  |
    |                  |                 | functions.       |                  |
    |                  |                 | Overrules the    |                  |
    |                  |                 | builtin optimize |                  |
    |                  |                 | d_num_dir.       |                  |
    +------------------+-----------------+------------------+------------------+
    | never_inline     | OT_BOOL         | Forbid inlining. | casadi::Function |
    |                  |                 |                  | Internal         |
    +------------------+-----------------+------------------+------------------+
    | output_scheme    | OT_STRINGVECTOR | Deprecated       | casadi::Function |
    |                  |                 | option (ignored) | Internal         |
    +------------------+-----------------+------------------+------------------+
    | print_in         | OT_BOOL         | Print numerical  | casadi::Function |
    |                  |                 | values of inputs | Internal         |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | print_out        | OT_BOOL         | Print numerical  | casadi::Function |
    |                  |                 | values of        | Internal         |
    |                  |                 | outputs          |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | print_time       | OT_BOOL         | print            | casadi::Function |
    |                  |                 | information      | Internal         |
    |                  |                 | about execution  |                  |
    |                  |                 | time. Implies    |                  |
    |                  |                 | record_time.     |                  |
    +------------------+-----------------+------------------+------------------+
    | record_time      | OT_BOOL         | record           | casadi::Function |
    |                  |                 | information      | Internal         |
    |                  |                 | about execution  |                  |
    |                  |                 | time, for        |                  |
    |                  |                 | retrieval with   |                  |
    |                  |                 | stats() .        |                  |
    +------------------+-----------------+------------------+------------------+
    | regularity_check | OT_BOOL         | Throw exceptions | casadi::Function |
    |                  |                 | when NaN or Inf  | Internal         |
    |                  |                 | appears during   |                  |
    |                  |                 | evaluation       |                  |
    +------------------+-----------------+------------------+------------------+
    | reverse_options  | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to a      | Internal         |
    |                  |                 | reverse mode     |                  |
    |                  |                 | constructor      |                  |
    +------------------+-----------------+------------------+------------------+
    | user_data        | OT_VOIDPTR      | A user-defined   | casadi::Function |
    |                  |                 | field that can   | Internal         |
    |                  |                 | be used to       |                  |
    |                  |                 | identify the     |                  |
    |                  |                 | function or pass |                  |
    |                  |                 | additional       |                  |
    |                  |                 | information      |                  |
    +------------------+-----------------+------------------+------------------+
    | verbose          | OT_BOOL         | Verbose          | casadi::Function |
    |                  |                 | evaluation  for  | Internal         |
    |                  |                 | debugging        |                  |
    +------------------+-----------------+------------------+------------------+

    C++ includes: function.hpp 


    """

    __swig_setmethods__ = {}
    for _s in [SharedObject, PrintableCommon]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Function, name, value)
    __swig_getmethods__ = {}
    for _s in [SharedObject, PrintableCommon]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Function, name)
    __repr__ = _swig_repr

    def type_name(*args):
        """


        type_name() -> str



        """
        return _casadi.Function_type_name(*args)

    type_name = staticmethod(type_name)

    def jit(*args):
        """
          To resolve ambiguity on some compilers.

          jit(str name, str body, [str] name_in, [str] name_out, dict opts) -> Function
          jit(str name, str body, [str] name_in, [str] name_out, [Sparsity] sparsity_in, [Sparsity] sparsity_out, dict opts) -> Function


        Create a just-in-time compiled function from a C language string The names
        and sparsity patterns of all the inputs and outputs must be provided. If
        sparsities are not provided, all inputs and outputs are assumed to be
        scalar. Only specify the function body, assuming that input and output
        nonzeros are stored in arrays with the specified naming convension. The data
        type used is 'casadi_real', which is typically equal to 'double` or another
        data type with the same API as 'double'.

        Inputs may be null pointers. This means that the all entries are zero.
        Outputs may be null points. This means that the corresponding result can be
        ignored.

        If an error occurs in the evaluation, issue "return 1;";

        The final generated function will have a structure similar to:

        casadi_int fname(const casadi_real** arg, casadi_real** res, casadi_int* iw,
        casadi_real* w, void* mem) { const casadi_real *x1, *x2; casadi_real *r1,
        *r2; x1 = *arg++; x2 = *arg++; r1 = *res++; r2 = *res++; <FUNCTION_BODY>
        return 0; }




        """
        return _casadi.Function_jit(*args)

    jit = staticmethod(jit)
    __swig_destroy__ = _casadi.delete_Function

    def expand(self, *args):
        """
        Expand a function to SX.

        expand(self) -> Function
        expand(self, str name, dict opts) -> Function





        """
        return _casadi.Function_expand(self, *args)


    def n_in(self, *args):
        """
        Get the number of function inputs.

        n_in(self) -> int





        """
        return _casadi.Function_n_in(self, *args)


    def n_out(self, *args):
        """
        Get the number of function outputs.

        n_out(self) -> int





        """
        return _casadi.Function_n_out(self, *args)


    def size1_in(self, *args):
        """
        Get input dimension.

        size1_in(self, int ind) -> int
        size1_in(self, str iname) -> int





        """
        return _casadi.Function_size1_in(self, *args)


    def size2_in(self, *args):
        """
        Get input dimension.

        size2_in(self, int ind) -> int
        size2_in(self, str iname) -> int





        """
        return _casadi.Function_size2_in(self, *args)


    def size_in(self, *args):
        """
        Get input dimension.

        size_in(self, int ind) -> (int,int)
        size_in(self, str iname) -> (int,int)





        """
        return _casadi.Function_size_in(self, *args)


    def size1_out(self, *args):
        """
        Get output dimension.

        size1_out(self, int ind) -> int
        size1_out(self, str oname) -> int





        """
        return _casadi.Function_size1_out(self, *args)


    def size2_out(self, *args):
        """
        Get output dimension.

        size2_out(self, int ind) -> int
        size2_out(self, str oname) -> int





        """
        return _casadi.Function_size2_out(self, *args)


    def size_out(self, *args):
        """
        Get output dimension.

        size_out(self, int ind) -> (int,int)
        size_out(self, str oname) -> (int,int)





        """
        return _casadi.Function_size_out(self, *args)


    def nnz_in(self, *args):
        """
          Get number of input nonzeros.

          nnz_in(self) -> int
          nnz_in(self, int ind) -> int
          nnz_in(self, str iname) -> int


        For a particular input or for all of the inputs




        """
        return _casadi.Function_nnz_in(self, *args)


    def nnz_out(self, *args):
        """
          Get number of output nonzeros.

          nnz_out(self) -> int
          nnz_out(self, int ind) -> int
          nnz_out(self, str oname) -> int


        For a particular output or for all of the outputs




        """
        return _casadi.Function_nnz_out(self, *args)


    def numel_in(self, *args):
        """
          Get number of input elements.

          numel_in(self) -> int
          numel_in(self, int ind) -> int
          numel_in(self, str iname) -> int


        For a particular input or for all of the inputs




        """
        return _casadi.Function_numel_in(self, *args)


    def numel_out(self, *args):
        """
          Get number of output elements.

          numel_out(self) -> int
          numel_out(self, int ind) -> int
          numel_out(self, str oname) -> int


        For a particular output or for all of the outputs




        """
        return _casadi.Function_numel_out(self, *args)


    def name_in(self, *args):
        """
          Get input scheme name by index.

          name_in(self) -> [str]
          name_in(self, int ind) -> str




        .......

        ::

          name_in(self, int ind)



        Get input scheme name by index.



        .............


        .......

        ::

          name_in(self)



        Get input scheme.



        .............



        """
        return _casadi.Function_name_in(self, *args)


    def name_out(self, *args):
        """
          Get output scheme name by index.

          name_out(self) -> [str]
          name_out(self, int ind) -> str




        .......

        ::

          name_out(self, int ind)



        Get output scheme name by index.



        .............


        .......

        ::

          name_out(self)



        Get output scheme.



        .............



        """
        return _casadi.Function_name_out(self, *args)


    def index_in(self, *args):
        """
          Find the index for a string describing a particular entry of an input

          index_in(self, str name) -> int

        scheme.

        example: schemeEntry("x_opt") -> returns NLPSOL_X if FunctionInternal
        adheres to SCHEME_NLPINput




        """
        return _casadi.Function_index_in(self, *args)


    def index_out(self, *args):
        """
          Find the index for a string describing a particular entry of an output

          index_out(self, str name) -> int

        scheme.

        example: schemeEntry("x_opt") -> returns NLPSOL_X if FunctionInternal
        adheres to SCHEME_NLPINput




        """
        return _casadi.Function_index_out(self, *args)


    def default_in(self, *args):
        """
        Get default input value.

        default_in(self, int ind) -> float





        """
        return _casadi.Function_default_in(self, *args)


    def max_in(self, *args):
        """
        Get largest input value.

        max_in(self, int ind) -> float





        """
        return _casadi.Function_max_in(self, *args)


    def min_in(self, *args):
        """
        Get smallest input value.

        min_in(self, int ind) -> float





        """
        return _casadi.Function_min_in(self, *args)


    def sparsity_in(self, *args):
        """
        Get sparsity of a given input.

        sparsity_in(self, int ind) -> Sparsity
        sparsity_in(self, str iname) -> Sparsity





        """
        return _casadi.Function_sparsity_in(self, *args)


    def sparsity_out(self, *args):
        """
        Get sparsity of a given output.

        sparsity_out(self, int ind) -> Sparsity
        sparsity_out(self, str iname) -> Sparsity





        """
        return _casadi.Function_sparsity_out(self, *args)


    def is_diff_in(self, *args):
        """
        Get differentiability of inputs/output.

        is_diff_in(self) -> [bool]
        is_diff_in(self, int ind) -> bool





        """
        return _casadi.Function_is_diff_in(self, *args)


    def is_diff_out(self, *args):
        """
        Get differentiability of inputs/output.

        is_diff_out(self) -> [bool]
        is_diff_out(self, int ind) -> bool





        """
        return _casadi.Function_is_diff_out(self, *args)


    def factory(self, *args):
        """


        factory(self, str name, [str] s_in, [str] s_out, dict:[str] aux, dict opts) -> Function



        """
        return _casadi.Function_factory(self, *args)


    def oracle(self, *args):
        """
        Get oracle.

        oracle(self) -> Function





        """
        return _casadi.Function_oracle(self, *args)


    def wrap(self, *args):
        """
        Wrap in an Function instance consisting of only one MX call.

        wrap(self) -> Function





        """
        return _casadi.Function_wrap(self, *args)


    def wrap_as_needed(self, *args):
        """
        Wrap in a Function with options.

        wrap_as_needed(self, dict opts) -> Function





        """
        return _casadi.Function_wrap_as_needed(self, *args)


    def which_depends(self, *args):
        """
          Which variables enter with some order.

          which_depends(self, str s_in, [str] s_out, int order, bool tr) -> [bool]


        Parameters:
        -----------

        order:  Only 1 (linear) and 2 (nonlinear) allowed

        tr:  Flip the relationship. Return which expressions contain the variables




        """
        return _casadi.Function_which_depends(self, *args)


    def print_dimensions(self, *args):
        """
        Print dimensions of inputs and outputs.

        print_dimensions(self)





        """
        return _casadi.Function_print_dimensions(self, *args)


    def print_options(self, *args):
        """
        Print options to a stream.

        print_options(self)





        """
        return _casadi.Function_print_options(self, *args)


    def print_option(self, *args):
        """
        Print all information there is to know about a certain option.

        print_option(self, str name)





        """
        return _casadi.Function_print_option(self, *args)


    def uses_output(self, *args):
        """
        Do the derivative functions need nondifferentiated outputs?

        uses_output(self) -> bool





        """
        return _casadi.Function_uses_output(self, *args)


    def jacobian_old(self, *args):
        """
          Generate a Jacobian function of output oind with respect to input iind.

          jacobian_old(self, int iind, int oind) -> Function


        Parameters:
        -----------

        iind:  The index of the input

        oind:  The index of the output Legacy function: To be deprecated in a future
        version of CasADi. Exists only for compatibility with Function::jacobian
        pre-CasADi 3.2




        """
        return _casadi.Function_jacobian_old(self, *args)


    def hessian_old(self, *args):
        """
          Generate a Hessian function of output oind with respect to input iind.

          hessian_old(self, int iind, int oind) -> Function


        Parameters:
        -----------

        iind:  The index of the input

        oind:  The index of the output Legacy function: To be deprecated in a future
        version of CasADi. Exists only for compatibility with Function::hessian pre-
        CasADi 3.2




        """
        return _casadi.Function_hessian_old(self, *args)


    def jacobian(self, *args):
        """
          Generate a Jacobian function of all the inputs elements with respect to all

          jacobian(self) -> Function

        the output elements).




        """
        return _casadi.Function_jacobian(self, *args)


    def jac(self, *args):
        """
          Calculate all Jacobian blocks Generates a function that takes all non-

          jac(self) -> Function

        differentiated inputs and outputs and calculates all Jacobian blocks. Inputs
        that are not needed by the routine are all-zero sparse matrices with the
        correct dimensions. Output blocks that are not calculated, e.g. if the
        corresponding input or output is marked non-differentiated are also all-zero
        sparse. The Jacobian blocks are sorted starting by all the blocks for the
        first output, then all the blocks for the second output and so on. E.g.
        f:(x,y)->(r,s) results in the function jac_f:(x,y,r,s)->(dr_dx, dr_dy,
        ds_dx, ds_dy) This function is cached.




        """
        return _casadi.Function_jac(self, *args)


    def call(self, *args):
        """
          Generate a Jacobian function of output oind with respect to input iind.

          call(self, dict:DM arg, bool always_inline, bool never_inline) -> dict:DM
          call(self, [DM] arg, bool always_inline, bool never_inline) -> [DM]
          call(self, [SX] arg, bool always_inline, bool never_inline) -> [SX]
          call(self, dict:SX arg, bool always_inline, bool never_inline) -> dict:SX
          call(self, dict:MX arg, bool always_inline, bool never_inline) -> dict:MX
          call(self, [MX] arg, bool always_inline, bool never_inline) -> [MX]


        Parameters:
        -----------

        iind:  The index of the input

        oind:  The index of the output Legacy function: To be deprecated in a future
        version of CasADi. Exists only for compatibility with Function::jacobian
        pre-CasADi 3.2



        .......

        ::

          call(self, [DM] arg, bool always_inline, bool never_inline)



        Evaluate the function symbolically or numerically.



        .............


        .......

        ::

          call(self, dict:DM arg, bool always_inline, bool never_inline)
          call(self, [SX] arg, bool always_inline, bool never_inline)
          call(self, dict:SX arg, bool always_inline, bool never_inline)
          call(self, dict:MX arg, bool always_inline, bool never_inline)
          call(self, [MX] arg, bool always_inline, bool never_inline)



        Generate a Jacobian function of output oind with respect to input iind.

        Parameters:
        -----------

        iind:  The index of the input

        oind:  The index of the output Legacy function: To be deprecated in a future
        version of CasADi. Exists only for compatibility with Function::jacobian
        pre-CasADi 3.2



        .............



        """
        return _casadi.Function_call(self, *args)


    def mapsum(self, *args):
        """
          Evaluate symbolically in parallel and sum (matrix graph)

          mapsum(self, [MX] x, str parallelization) -> [MX]


        Parameters:
        -----------

        parallelization:  Type of parallelization used: unroll|serial|openmp




        """
        return _casadi.Function_mapsum(self, *args)


    def mapaccum(self, *args):
        """
          Create a mapaccumulated version of this function.

          mapaccum(self, int N, dict opts) -> Function
          mapaccum(self, str name, int N, dict opts) -> Function
          mapaccum(self, str name, int N, int n_accum, dict opts) -> Function
          mapaccum(self, str name, int n, [str] accum_in, [str] accum_out, dict opts) -> Function
          mapaccum(self, str name, int n, [int] accum_in, [int] accum_out, dict opts) -> Function


        Suppose the function has a signature of:

        ::

             f: (x, u) -> (x_next , y )




        The the mapaccumulated version has the signature:

        ::

             F: (x0, U) -> (X , Y )

              with
                  U: horzcat([u0, u1, ..., u_(N-1)])
                  X: horzcat([x1, x2, ..., x_N])
                  Y: horzcat([y0, y1, ..., y_(N-1)])

              and
                  x1, y0 <- f(x0, u0)
                  x2, y1 <- f(x1, u1)
                  ...
                  x_N, y_(N-1) <- f(x_(N-1), u_(N-1))




        Mapaccum has the following benefits over writing an equivalent for- loop:
        much faster at construction time

        potentially much faster compilation times (for codegen)

        offers a trade-off between memory and evaluation time

        The base (settable through the options dictionary, default 10), is used to
        create a tower of function calls, containing unrolled for- loops of length
        maximum base.

        This technique is much more scalable in terms of memory-usage, but slightly
        slower at evaluation, than a plain for-loop. The effect is similar to that
        of a for-loop with a check-pointing instruction after each chunk of
        iterations with size base.

        Set base to -1 to unroll all the way; no gains in memory efficiency here.




        """
        return _casadi.Function_mapaccum(self, *args)


    def fold(self, *args):
        """
          Create a mapaccumulated version of this function.

          fold(self, int N, dict opts) -> Function


        Suppose the function has a signature of:

        ::

             f: (x, u) -> (x_next , y )




        The the mapaccumulated version has the signature:

        ::

             F: (x0, U) -> (X , Y )

              with
                  U: horzcat([u0, u1, ..., u_(N-1)])
                  X: horzcat([x1, x2, ..., x_N])
                  Y: horzcat([y0, y1, ..., y_(N-1)])

              and
                  x1, y0 <- f(x0, u0)
                  x2, y1 <- f(x1, u1)
                  ...
                  x_N, y_(N-1) <- f(x_(N-1), u_(N-1))




        Mapaccum has the following benefits over writing an equivalent for- loop:
        much faster at construction time

        potentially much faster compilation times (for codegen)

        offers a trade-off between memory and evaluation time

        The base (settable through the options dictionary, default 10), is used to
        create a tower of function calls, containing unrolled for- loops of length
        maximum base.

        This technique is much more scalable in terms of memory-usage, but slightly
        slower at evaluation, than a plain for-loop. The effect is similar to that
        of a for-loop with a check-pointing instruction after each chunk of
        iterations with size base.

        Set base to -1 to unroll all the way; no gains in memory efficiency here.




        """
        return _casadi.Function_fold(self, *args)


    def map(self, *args):
        """
          Map with reduction A subset of the inputs are non-repeated and a subset of

          map(self, int n, str parallelization) -> Function
          map(self, int n, [bool] reduce_in, [bool] reduce_out, dict opts) -> Function
          map(self, int n, str parallelization, int max_num_threads) -> Function
          map(self, str name, str parallelization, int n, [str] reduce_in, [str] reduce_out, dict opts) -> Function
          map(self, str name, str parallelization, int n, [int] reduce_in, [int] reduce_out, dict opts) -> Function

        the outputs summed up.



        .......

        ::

          map(self, int n, str parallelization, int max_num_threads)



        .............


        .......

        ::

          map(self, int n, str parallelization)



        Create a mapped version of this function.

        Suppose the function has a signature of:

        ::

             f: (a, p) -> ( s )




        The the mapped version has the signature:

        ::

             F: (A, P) -> (S )

              with
                  A: horzcat([a0, a1, ..., a_(N-1)])
                  P: horzcat([p0, p1, ..., p_(N-1)])
                  S: horzcat([s0, s1, ..., s_(N-1)])
              and
                  s0 <- f(a0, p0)
                  s1 <- f(a1, p1)
                  ...
                  s_(N-1) <- f(a_(N-1), p_(N-1))




        Parameters:
        -----------

        parallelization:  Type of parallelization used: unroll|serial|openmp



        .............


        .......

        ::

          map(self, int n, [bool] reduce_in, [bool] reduce_out, dict opts)
          map(self, str name, str parallelization, int n, [str] reduce_in, [str] reduce_out, dict opts)
          map(self, str name, str parallelization, int n, [int] reduce_in, [int] reduce_out, dict opts)



        Map with reduction A subset of the inputs are non-repeated and a subset of
        the outputs summed up.



        .............



        """
        return _casadi.Function_map(self, *args)


    def slice(self, *args):
        """
        returns a new function with a selection of inputs/outputs of the original

        slice(self, str name, [int] order_in, [int] order_out, dict opts) -> Function





        """
        return _casadi.Function_slice(self, *args)


    def conditional(*args):
        """


        conditional(str name, [Function] f, Function f_def, dict opts) -> Function



        """
        return _casadi.Function_conditional(*args)

    conditional = staticmethod(conditional)

    def bspline(*args):
        """


        bspline(str name, [[float]] knots, [float] coeffs, [int] degree, int m, dict opts) -> Function



        """
        return _casadi.Function_bspline(*args)

    bspline = staticmethod(bspline)

    def if_else(*args):
        """


        if_else(str name, Function f_true, Function f_false, dict opts) -> Function



        """
        return _casadi.Function_if_else(*args)

    if_else = staticmethod(if_else)

    def forward(self, *args):
        """
          Get a function that calculates nfwd forward derivatives.

          forward(self, int nfwd) -> Function


        Returns a function with n_in + n_out + n_in inputs and nfwd outputs. The
        first n_in inputs correspond to nondifferentiated inputs. The next n_out
        inputs correspond to nondifferentiated outputs. and the last n_in inputs
        correspond to forward seeds, stacked horizontally The n_out outputs
        correspond to forward sensitivities, stacked horizontally. * (n_in = n_in(),
        n_out = n_out())

        The functions returned are cached, meaning that if called multiple timed
        with the same value, then multiple references to the same function will be
        returned.




        """
        return _casadi.Function_forward(self, *args)


    def reverse(self, *args):
        """
          Get a function that calculates nadj adjoint derivatives.

          reverse(self, int nadj) -> Function


        Returns a function with n_in + n_out + n_out inputs and n_in outputs. The
        first n_in inputs correspond to nondifferentiated inputs. The next n_out
        inputs correspond to nondifferentiated outputs. and the last n_out inputs
        correspond to adjoint seeds, stacked horizontally The n_in outputs
        correspond to adjoint sensitivities, stacked horizontally. * (n_in = n_in(),
        n_out = n_out())

        (n_in = n_in(), n_out = n_out())

        The functions returned are cached, meaning that if called multiple timed
        with the same value, then multiple references to the same function will be
        returned.




        """
        return _casadi.Function_reverse(self, *args)


    def sparsity_jac(self, *args):
        """
        Get, if necessary generate, the sparsity of a Jacobian block

        sparsity_jac(self, str iind, int oind, bool compact, bool symmetric) -> Sparsity
        sparsity_jac(self, int iind, int oind, bool compact, bool symmetric) -> Sparsity
        sparsity_jac(self, int iind, str oind, bool compact, bool symmetric) -> Sparsity
        sparsity_jac(self, str iind, str oind, bool compact, bool symmetric) -> Sparsity





        """
        return _casadi.Function_sparsity_jac(self, *args)


    def generate(self, *args):
        """
        Export / Generate C code for the function.

        generate(self, dict opts) -> str
        generate(self, str fname, dict opts) -> str





        """
        return _casadi.Function_generate(self, *args)


    def generate_dependencies(self, *args):
        """
        Export / Generate C code for the dependency function.

        generate_dependencies(self, str fname, dict opts) -> str





        """
        return _casadi.Function_generate_dependencies(self, *args)


    def generate_in(self, *args):
        """
          Export an input file that can be passed to generate C code with a main.

          generate_in(self, str fname) -> [DM]
          generate_in(self, str fname, [DM] arg)


        generate_out  convert_in to convert between dict/map and vector




        """
        return _casadi.Function_generate_in(self, *args)


    def generate_out(self, *args):
        """
          Export an output file that can be checked with generated C code output.

          generate_out(self, str fname) -> [DM]
          generate_out(self, str fname, [DM] arg)


        generate_in  convert_out to convert between dict/map and vector




        """
        return _casadi.Function_generate_out(self, *args)


    def serialize(self, *args):
        """
        Serialize.

        serialize(self, dict opts) -> str





        """
        return _casadi.Function_serialize(self, *args)


    def save(self, *args):
        """
          Export function in specific language.

          save(self, str fname, dict opts)


        Only allowed for (a subset of) SX/MX Functions




        """
        return _casadi.Function_save(self, *args)


    def export_code(self, *args):
        """
          Export function in specific language.

          export_code(self, str lang, dict options) -> str
          export_code(self, str lang, str fname, dict options)


        Only allowed for (a subset of) SX/MX Functions




        """
        return _casadi.Function_export_code(self, *args)


    def stats(self, *args):
        """
        Get all statistics obtained at the end of the last evaluate call.

        stats(self, int mem) -> dict





        """
        return _casadi.Function_stats(self, *args)


    def sx_in(self, *args):
        """
          Get symbolic primitives equivalent to the input expressions There is no

          sx_in(self) -> [SX]
          sx_in(self, int iind) -> SX
          sx_in(self, str iname) -> SX

        guarantee that subsequent calls return unique answers.




        """
        return _casadi.Function_sx_in(self, *args)


    def mx_in(self, *args):
        """
          Get symbolic primitives equivalent to the input expressions There is no

          mx_in(self) -> [MX]
          mx_in(self, int ind) -> MX
          mx_in(self, str iname) -> MX

        guarantee that subsequent calls return unique answers.




        """
        return _casadi.Function_mx_in(self, *args)


    def sx_out(self, *args):
        """
          Get symbolic primitives equivalent to the output expressions There is no

          sx_out(self) -> [SX]
          sx_out(self, int oind) -> SX
          sx_out(self, str oname) -> SX

        guarantee that subsequent calls return unique answers.




        """
        return _casadi.Function_sx_out(self, *args)


    def mx_out(self, *args):
        """
          Get symbolic primitives equivalent to the output expressions There is no

          mx_out(self) -> [MX]
          mx_out(self, int ind) -> MX
          mx_out(self, str oname) -> MX

        guarantee that subsequent calls return unique answers.




        """
        return _casadi.Function_mx_out(self, *args)


    def nz_from_in(self, *args):
        """
        Convert from/to flat vector of input/output nonzeros.

        nz_from_in(self, [DM] arg) -> [float]





        """
        return _casadi.Function_nz_from_in(self, *args)


    def nz_from_out(self, *args):
        """
        Convert from/to flat vector of input/output nonzeros.

        nz_from_out(self, [DM] arg) -> [float]





        """
        return _casadi.Function_nz_from_out(self, *args)


    def nz_to_in(self, *args):
        """
        Convert from/to flat vector of input/output nonzeros.

        nz_to_in(self, [float] arg) -> [DM]





        """
        return _casadi.Function_nz_to_in(self, *args)


    def nz_to_out(self, *args):
        """
        Convert from/to flat vector of input/output nonzeros.

        nz_to_out(self, [float] arg) -> [DM]





        """
        return _casadi.Function_nz_to_out(self, *args)


    def convert_in(self, *args):
        """
          Convert from/to input/output lists/map.

          convert_in(self, dict:DM arg) -> [DM]
          convert_in(self, [DM] arg) -> dict:DM
          convert_in(self, [SX] arg) -> dict:SX
          convert_in(self, dict:SX arg) -> [SX]
          convert_in(self, dict:MX arg) -> [MX]
          convert_in(self, [MX] arg) -> dict:MX


        Will raise an error when an unknown key is used or a list has incorrect
        size. Does not perform sparsity checking.




        """
        return _casadi.Function_convert_in(self, *args)


    def convert_out(self, *args):
        """
          Convert from/to input/output lists/map.

          convert_out(self, dict:DM arg) -> [DM]
          convert_out(self, [DM] arg) -> dict:DM
          convert_out(self, [SX] arg) -> dict:SX
          convert_out(self, dict:SX arg) -> [SX]
          convert_out(self, dict:MX arg) -> [MX]
          convert_out(self, [MX] arg) -> dict:MX


        Will raise an error when an unknown key is used or a list has incorrect
        size. Does not perform sparsity checking.




        """
        return _casadi.Function_convert_out(self, *args)


    def has_free(self, *args):
        """
        Does the function have free variables.

        has_free(self) -> bool





        """
        return _casadi.Function_has_free(self, *args)


    def get_free(self, *args):
        """
        Get free variables as a string.

        get_free(self) -> [str]





        """
        return _casadi.Function_get_free(self, *args)


    def free_sx(self, *args):
        """
        Get all the free variables of the function.

        free_sx(self) -> [SX]





        """
        return _casadi.Function_free_sx(self, *args)


    def free_mx(self, *args):
        """
        Get all the free variables of the function.

        free_mx(self) -> [MX]





        """
        return _casadi.Function_free_mx(self, *args)


    def generate_lifted(self, *args):
        """
        Extract the functions needed for the Lifted Newton method.

        generate_lifted(self) -> (Function OUTPUT, Function OUTPUT)





        """
        return _casadi.Function_generate_lifted(self, *args)


    def n_nodes(self, *args):
        """
        Number of nodes in the algorithm.

        n_nodes(self) -> int





        """
        return _casadi.Function_n_nodes(self, *args)


    def n_instructions(self, *args):
        """
        Number of instruction in the algorithm (SXFunction/MXFunction)

        n_instructions(self) -> int





        """
        return _casadi.Function_n_instructions(self, *args)


    def instruction_id(self, *args):
        """
        Identifier index of the instruction (SXFunction/MXFunction)

        instruction_id(self, int k) -> int





        """
        return _casadi.Function_instruction_id(self, *args)


    def instruction_input(self, *args):
        """
          Locations in the work vector for the inputs of the instruction

          instruction_input(self, int k) -> [int]

        (SXFunction/MXFunction)




        """
        return _casadi.Function_instruction_input(self, *args)


    def instruction_constant(self, *args):
        """
        Get the floating point output argument of an instruction ( SXFunction)

        instruction_constant(self, int k) -> float





        """
        return _casadi.Function_instruction_constant(self, *args)


    def instruction_output(self, *args):
        """
          Location in the work vector for the output of the instruction

          instruction_output(self, int k) -> [int]

        (SXFunction/MXFunction)




        """
        return _casadi.Function_instruction_output(self, *args)


    def instruction_MX(self, *args):
        """
        Get the MX node corresponding to an instruction ( MXFunction)

        instruction_MX(self, int k) -> MX





        """
        return _casadi.Function_instruction_MX(self, *args)


    def instructions_sx(self, *args):
        """
          Get the SX node corresponding to all instructions ( SXFunction)

          instructions_sx(self) -> SX


        Note: input and output instructions have no SX representation. This method
        returns nan for those instructions.




        """
        return _casadi.Function_instructions_sx(self, *args)


    def has_spfwd(self, *args):
        """
        Is the class able to propagate seeds through the algorithm?

        has_spfwd(self) -> bool





        """
        return _casadi.Function_has_spfwd(self, *args)


    def has_sprev(self, *args):
        """
        Is the class able to propagate seeds through the algorithm?

        has_sprev(self) -> bool





        """
        return _casadi.Function_has_sprev(self, *args)


    def sz_arg(self, *args):
        """
        Get required length of arg field.

        sz_arg(self) -> size_t





        """
        return _casadi.Function_sz_arg(self, *args)


    def sz_res(self, *args):
        """
        Get required length of res field.

        sz_res(self) -> size_t





        """
        return _casadi.Function_sz_res(self, *args)


    def sz_iw(self, *args):
        """
        Get required length of iw field.

        sz_iw(self) -> size_t





        """
        return _casadi.Function_sz_iw(self, *args)


    def sz_w(self, *args):
        """
        Get required length of w field.

        sz_w(self) -> size_t





        """
        return _casadi.Function_sz_w(self, *args)


    def name(self, *args):
        """
        Name of the function.

        name(self) -> str





        """
        return _casadi.Function_name(self, *args)


    def is_a(self, *args):
        """
          Check if the function is of a particular type Optionally check if name

          is_a(self, str type, bool recursive) -> bool

        matches one of the base classes (default true)




        """
        return _casadi.Function_is_a(self, *args)


    def check_name(*args):
        """


        check_name(str name) -> bool



        """
        return _casadi.Function_check_name(*args)

    check_name = staticmethod(check_name)

    def fix_name(*args):
        """


        fix_name(str name) -> str



        """
        return _casadi.Function_fix_name(*args)

    fix_name = staticmethod(fix_name)

    def load(*args):
        """


        load(str filename) -> Function



        """
        return _casadi.Function_load(*args)

    load = staticmethod(load)

    def deserialize(*args):
        """


        deserialize(std::istream & stream) -> Function
        deserialize(casadi::DeserializingStream & s) -> Function
        deserialize(str s) -> Function



        """
        return _casadi.Function_deserialize(*args)

    deserialize = staticmethod(deserialize)

    def assert_size_in(self, *args):
        """
        Assert that an input dimension is equal so some given value.

        assert_size_in(self, int i, int nrow, int ncol)





        """
        return _casadi.Function_assert_size_in(self, *args)


    def assert_size_out(self, *args):
        """
        Assert that an output dimension is equal so some given value.

        assert_size_out(self, int i, int nrow, int ncol)





        """
        return _casadi.Function_assert_size_out(self, *args)


    def checkout(self, *args):
        """
        Checkout a memory object.

        checkout(self) -> int





        """
        return _casadi.Function_checkout(self, *args)


    def release(self, *args):
        """
        Release a memory object.

        release(self, int mem)





        """
        return _casadi.Function_release(self, *args)


    def get_function(self, *args):
        """


        get_function(self) -> [str]
        get_function(self, str name) -> Function



        """
        return _casadi.Function_get_function(self, *args)


    def has_function(self, *args):
        """


        has_function(self, str fname) -> bool



        """
        return _casadi.Function_has_function(self, *args)


    def info(self, *args):
        """
        Obtain information about function

        info(self) -> dict





        """
        return _casadi.Function_info(self, *args)


    def __setstate__(self, state):
        self.__init__(Function.deserialize(state["serialization"]))

    def __getstate__(self):
        return {"serialization": self.serialize()}


    def __call__(self, *args, **kwargs):
    # Either named inputs or ordered inputs
      if len(args)>0 and len(kwargs)>0:
        raise SyntaxError('Function evaluation requires all arguments to be named or none')
      if len(args)>0:
    # Ordered inputs -> return tuple
        ret = self.call(args)
        if len(ret)==0:
          return None
        elif len(ret)==1:
          return ret[0]
        else:
          return tuple(ret)
      else:
    # Named inputs -> return dictionary
        return self.call(kwargs)

    def buffer(self):
      """
      Create a FunctionBuffer object for evaluating with minimal overhead

      """
      import functools
      fb = FunctionBuffer(self)
      caller = functools.partial(_casadi._function_buffer_eval, fb._self())
      return (fb, caller)


    def __init__(self, *args):
        """


          Function()
          Function(str fname)
          Function(Function other)
          Function(str name, [SX] ex_in, [SX] ex_out, dict opts)
          Function(str name, [MX] ex_in, [MX] ex_out, dict opts)
          Function(str name, dict:SX dict, [str] name_in, [str] name_out, dict opts)
          Function(str name, dict:MX dict, [str] name_in, [str] name_out, dict opts)
          Function(str name, [SX] ex_in, [SX] ex_out, [str] name_in, [str] name_out, dict opts)
          Function(str name, [MX] ex_in, [MX] ex_out, [str] name_in, [str] name_out, dict opts)


        .......

        ::

          Function(Function other)



        .............


        .......

        ::

          Function()



        Default constructor, null pointer.



        .............


        .......

        ::

          Function(str fname)



        Construct from a file.



        .............


        .......

        ::

          Function(str name, [SX] ex_in, [SX] ex_out, dict opts)
          Function(str name, dict:SX dict, [str] name_in, [str] name_out, dict opts)
          Function(str name, [SX] ex_in, [SX] ex_out, [str] name_in, [str] name_out, dict opts)



        Construct an SX function.



        .............


        .......

        ::

          Function(str name, [MX] ex_in, [MX] ex_out, dict opts)
          Function(str name, dict:MX dict, [str] name_in, [str] name_out, dict opts)
          Function(str name, [MX] ex_in, [MX] ex_out, [str] name_in, [str] name_out, dict opts)



        Construct an MX function.



        .............



        """
        this = _casadi.new_Function(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
Function_swigregister = _casadi.Function_swigregister
Function_swigregister(Function)

def Function_type_name(*args):
    """


    type_name() -> str



    """
    return _casadi.Function_type_name(*args)

def Function_jit(*args):
    """
      To resolve ambiguity on some compilers.

      jit(str name, str body, [str] name_in, [str] name_out, dict opts) -> Function
      jit(str name, str body, [str] name_in, [str] name_out, [Sparsity] sparsity_in, [Sparsity] sparsity_out, dict opts) -> Function


    Create a just-in-time compiled function from a C language string The names
    and sparsity patterns of all the inputs and outputs must be provided. If
    sparsities are not provided, all inputs and outputs are assumed to be
    scalar. Only specify the function body, assuming that input and output
    nonzeros are stored in arrays with the specified naming convension. The data
    type used is 'casadi_real', which is typically equal to 'double` or another
    data type with the same API as 'double'.

    Inputs may be null pointers. This means that the all entries are zero.
    Outputs may be null points. This means that the corresponding result can be
    ignored.

    If an error occurs in the evaluation, issue "return 1;";

    The final generated function will have a structure similar to:

    casadi_int fname(const casadi_real** arg, casadi_real** res, casadi_int* iw,
    casadi_real* w, void* mem) { const casadi_real *x1, *x2; casadi_real *r1,
    *r2; x1 = *arg++; x2 = *arg++; r1 = *res++; r2 = *res++; <FUNCTION_BODY>
    return 0; }




    """
    return _casadi.Function_jit(*args)

def Function_conditional(*args):
    """


    conditional(str name, [Function] f, Function f_def, dict opts) -> Function



    """
    return _casadi.Function_conditional(*args)

def Function_bspline(*args):
    """


    bspline(str name, [[float]] knots, [float] coeffs, [int] degree, int m, dict opts) -> Function



    """
    return _casadi.Function_bspline(*args)

def Function_if_else(*args):
    """


    if_else(str name, Function f_true, Function f_false, dict opts) -> Function



    """
    return _casadi.Function_if_else(*args)

def Function_check_name(*args):
    """


    check_name(str name) -> bool



    """
    return _casadi.Function_check_name(*args)

def Function_fix_name(*args):
    """


    fix_name(str name) -> str



    """
    return _casadi.Function_fix_name(*args)

def Function_load(*args):
    """


    load(str filename) -> Function



    """
    return _casadi.Function_load(*args)

def Function_deserialize(*args):
    """


    deserialize(std::istream & stream) -> Function
    deserialize(casadi::DeserializingStream & s) -> Function
    deserialize(str s) -> Function



    """
    return _casadi.Function_deserialize(*args)

class FunctionBuffer(_object):
    """
      Class to achieve minimal overhead function evaluations.



    C++ includes: function.hpp 


    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, FunctionBuffer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, FunctionBuffer, name)
    __repr__ = _swig_repr

    def set_arg(self, *args):
        """
          Set input buffer for input i.

          set_arg(self, int i, memoryview(ro) a, casadi_int size)


        mem.set_arg(0, memoryview(a))

        Note that CasADi uses 'fortran' order: column-by-column




        """
        return _casadi.FunctionBuffer_set_arg(self, *args)


    def set_res(self, *args):
        """
          Set output buffer for ouput i.

          set_res(self, int i, memoryview(rw) a, casadi_int size)


        mem.set_res(0, memoryview(a))

        Note that CasADi uses 'fortran' order: column-by-column




        """
        return _casadi.FunctionBuffer_set_res(self, *args)


    def ret(self, *args):
        """
        Get last return value.

        ret(self) -> int





        """
        return _casadi.FunctionBuffer_ret(self, *args)


    def _eval(self, *args):
        """


        _eval(self)



        """
        return _casadi.FunctionBuffer__eval(self, *args)


    def _self(self, *args):
        """


        _self(self) -> void*



        """
        return _casadi.FunctionBuffer__self(self, *args)


    def __init__(self, *args):
        """


          FunctionBuffer(FunctionBuffer other)
          FunctionBuffer(Function f)


        .......

        ::

          FunctionBuffer(FunctionBuffer other)



        .............


        .......

        ::

          FunctionBuffer(Function f)



        Main constructor.



        .............



        """
        this = _casadi.new_FunctionBuffer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_FunctionBuffer
FunctionBuffer_swigregister = _casadi.FunctionBuffer_swigregister
FunctionBuffer_swigregister(FunctionBuffer)


def _function_buffer_eval(*args):
    """


    _function_buffer_eval(void* raw)



    """
    return _casadi._function_buffer_eval(*args)

def external(*args):
    """
      Load a just-in-time compiled external function File name given.

      external(str name, dict opts) -> Function
      external(str name, Importer li, dict opts) -> Function
      external(str name, str bin_name, dict opts) -> Function




    .......

    ::

      external(str name, Importer li, dict opts)



    Load a just-in-time compiled external function File name given.



    .............


    .......

    ::

      external(str name, dict opts)



    Load an external function from a shared library.

    Parameters:
    -----------

    name:  Name as in the label assigned to a CasADi Function object:
    Function(name,...,...) Will be used to look up symbols/functions named eg.
    <name>_eval Use nm (linux/osx) or depends.exe (win) to check which symbols
    are present in your shared library

    File name is assumed to be ./<name>.so



    .............


    .......

    ::

      external(str name, str bin_name, dict opts)



    Load an external function from a shared library.

    Parameters:
    -----------

    name:  Name as in the label assigned to a CasADi Function object:
    Function(name,...,...) Will be used to look up symbols/functions named eg.
    <name>_eval Use nm (linux/osx) or depends.exe (win) to check which symbols
    are present in your shared library

    bin_name:  File name of the shared library



    .............



    """
    return _casadi.external(*args)

def integrator(*args):
    """


      integrator(str name, str solver, dict:SX dae, dict opts) -> Function
      integrator(str name, str solver, dict:MX dae, dict opts) -> Function


    .......

    ::

      integrator(str name, str solver, dict:MX dae, dict opts)



    .............


    .......

    ::

      integrator(str name, str solver, dict:SX dae, dict opts)



    Create an ODE/DAE integrator Solves an initial value problem (IVP) coupled
    to a terminal value problem with differential equation given as an implicit
    ODE coupled to an algebraic equation and a set of quadratures:



    ::

      Initial conditions at t=t0
      x(t0)  = x0
      q(t0)  = 0

      Forward integration from t=t0 to t=tf
      der(x) = function(x, z, p, t)                  Forward ODE
      0 = fz(x, z, p, t)                  Forward algebraic equations
      der(q) = fq(x, z, p, t)                  Forward quadratures

      Terminal conditions at t=tf
      rx(tf)  = rx0
      rq(tf)  = 0

      Backward integration from t=tf to t=t0
      der(rx) = gx(rx, rz, rp, x, z, p, t)        Backward ODE
      0 = gz(rx, rz, rp, x, z, p, t)        Backward algebraic equations
      der(rq) = gq(rx, rz, rp, x, z, p, t)        Backward quadratures

      where we assume that both the forward and backwards integrations are index-1
      (i.e. dfz/dz, dgz/drz are invertible) and furthermore that
      gx, gz and gq have a linear dependency on rx, rz and rp.



    General information
    ===================



    >List of available options

    +------------------+-----------------+------------------+------------------+
    |        Id        |      Type       |   Description    |     Used in      |
    +==================+=================+==================+==================+
    | augmented_option | OT_DICT         | Options to be    | casadi::Integrat |
    | s                |                 | passed down to   | or               |
    |                  |                 | the augmented    |                  |
    |                  |                 | integrator, if   |                  |
    |                  |                 | one is           |                  |
    |                  |                 | constructed.     |                  |
    +------------------+-----------------+------------------+------------------+
    | common_options   | OT_DICT         | Options for      | casadi::OracleFu |
    |                  |                 | auto-generated   | nction           |
    |                  |                 | functions        |                  |
    +------------------+-----------------+------------------+------------------+
    | expand           | OT_BOOL         | Replace MX with  | casadi::Integrat |
    |                  |                 | SX expressions   | or               |
    |                  |                 | in problem       |                  |
    |                  |                 | formulation      |                  |
    |                  |                 | [false]          |                  |
    +------------------+-----------------+------------------+------------------+
    | grid             | OT_DOUBLEVECTOR | Time grid        | casadi::Integrat |
    |                  |                 |                  | or               |
    +------------------+-----------------+------------------+------------------+
    | monitor          | OT_STRINGVECTOR | Set of user      | casadi::OracleFu |
    |                  |                 | problem          | nction           |
    |                  |                 | functions to be  |                  |
    |                  |                 | monitored        |                  |
    +------------------+-----------------+------------------+------------------+
    | number_of_finite | OT_INT          | Number of finite | casadi::Integrat |
    | _elements        |                 | elements         | or               |
    +------------------+-----------------+------------------+------------------+
    | output_t0        | OT_BOOL         | Output the state | casadi::Integrat |
    |                  |                 | at the initial   | or               |
    |                  |                 | time             |                  |
    +------------------+-----------------+------------------+------------------+
    | print_stats      | OT_BOOL         | Print out        | casadi::Integrat |
    |                  |                 | statistics after | or               |
    |                  |                 | integration      |                  |
    +------------------+-----------------+------------------+------------------+
    | rootfinder       | OT_STRING       | An implicit      | casadi::Integrat |
    |                  |                 | function solver  | or               |
    +------------------+-----------------+------------------+------------------+
    | rootfinder_optio | OT_DICT         | Options to be    | casadi::Integrat |
    | ns               |                 | passed to the    | or               |
    |                  |                 | NLP Solver       |                  |
    +------------------+-----------------+------------------+------------------+
    | show_eval_warnin | OT_BOOL         | Show warnings    | casadi::OracleFu |
    | gs               |                 | generated from   | nction           |
    |                  |                 | function         |                  |
    |                  |                 | evaluations      |                  |
    |                  |                 | [true]           |                  |
    +------------------+-----------------+------------------+------------------+
    | simplify         | OT_BOOL         | Implement as MX  | casadi::Integrat |
    |                  |                 | Function (codege | or               |
    |                  |                 | neratable/serial |                  |
    |                  |                 | izable) default: |                  |
    |                  |                 | false            |                  |
    +------------------+-----------------+------------------+------------------+
    | simplify_options | OT_DICT         | Any options to   | casadi::Integrat |
    |                  |                 | pass to          | or               |
    |                  |                 | simplified form  |                  |
    |                  |                 | Function         |                  |
    |                  |                 | constructor      |                  |
    +------------------+-----------------+------------------+------------------+
    | specific_options | OT_DICT         | Options for      | casadi::OracleFu |
    |                  |                 | specific auto-   | nction           |
    |                  |                 | generated        |                  |
    |                  |                 | functions,       |                  |
    |                  |                 | overwriting the  |                  |
    |                  |                 | defaults from    |                  |
    |                  |                 | common_options.  |                  |
    |                  |                 | Nested           |                  |
    |                  |                 | dictionary.      |                  |
    +------------------+-----------------+------------------+------------------+
    | t0               | OT_DOUBLE       | Beginning of the | casadi::Integrat |
    |                  |                 | time horizon     | or               |
    +------------------+-----------------+------------------+------------------+
    | tf               | OT_DOUBLE       | End of the time  | casadi::Integrat |
    |                  |                 | horizon          | or               |
    +------------------+-----------------+------------------+------------------+

    >Input scheme: casadi::IntegratorInput (INTEGRATOR_NUM_IN = 6)

    +----------------+-------+-------------------------------------------------+
    |   Full name    | Short |                   Description                   |
    +================+=======+=================================================+
    | INTEGRATOR_X0  | x0    | Differential state at the initial time.         |
    +----------------+-------+-------------------------------------------------+
    | INTEGRATOR_P   | p     | Parameters.                                     |
    +----------------+-------+-------------------------------------------------+
    | INTEGRATOR_Z0  | z0    | Initial guess for the algebraic variable.       |
    +----------------+-------+-------------------------------------------------+
    | INTEGRATOR_RX0 | rx0   | Backward differential state at the final time.  |
    +----------------+-------+-------------------------------------------------+
    | INTEGRATOR_RP  | rp    | Backward parameter vector.                      |
    +----------------+-------+-------------------------------------------------+
    | INTEGRATOR_RZ0 | rz0   | Initial guess for the backwards algebraic       |
    |                |       | variable.                                       |
    +----------------+-------+-------------------------------------------------+

    >Output scheme: casadi::IntegratorOutput (INTEGRATOR_NUM_OUT = 6)

    +----------------+-------+-------------------------------------------------+
    |   Full name    | Short |                   Description                   |
    +================+=======+=================================================+
    | INTEGRATOR_XF  | xf    | Differential state at the final time.           |
    +----------------+-------+-------------------------------------------------+
    | INTEGRATOR_QF  | qf    | Quadrature state at the final time.             |
    +----------------+-------+-------------------------------------------------+
    | INTEGRATOR_ZF  | zf    | Algebraic variable at the final time.           |
    +----------------+-------+-------------------------------------------------+
    | INTEGRATOR_RXF | rxf   | Backward differential state at the initial      |
    |                |       | time.                                           |
    +----------------+-------+-------------------------------------------------+
    | INTEGRATOR_RQF | rqf   | Backward quadrature state at the initial time.  |
    +----------------+-------+-------------------------------------------------+
    | INTEGRATOR_RZF | rzf   | Backward algebraic variable at the initial      |
    |                |       | time.                                           |
    +----------------+-------+-------------------------------------------------+

    List of plugins
    ===============



    - cvodes

    - idas

    - collocation

    - rk

    Note: some of the plugins in this list might not be available on your
    system. Also, there might be extra plugins available to you that are not
    listed here. You can obtain their documentation with
    Integrator.doc("myextraplugin")



    --------------------------------------------------------------------------------

    cvodes
    ------



    Interface to CVodes from the Sundials suite.

    A call to evaluate will integrate to the end.

    You can retrieve the entire state trajectory as follows, after the evaluate
    call: Call reset. Then call integrate(t_i) and getOuput for a series of
    times t_i.

    >List of available options

    +----------------------------+-----------+---------------------------------+
    |             Id             |   Type    |           Description           |
    +============================+===========+=================================+
    | abstol                     | OT_DOUBLE | Absolute tolerence for the IVP  |
    |                            |           | solution                        |
    +----------------------------+-----------+---------------------------------+
    | disable_internal_warnings  | OT_BOOL   | Disable SUNDIALS internal       |
    |                            |           | warning messages                |
    +----------------------------+-----------+---------------------------------+
    | fsens_all_at_once          | OT_BOOL   | Calculate all right hand sides  |
    |                            |           | of the sensitivity equations at |
    |                            |           | once                            |
    +----------------------------+-----------+---------------------------------+
    | fsens_err_con              | OT_BOOL   | include the forward             |
    |                            |           | sensitivities in all error      |
    |                            |           | controls                        |
    +----------------------------+-----------+---------------------------------+
    | interpolation_type         | OT_STRING | Type of interpolation for the   |
    |                            |           | adjoint sensitivities           |
    +----------------------------+-----------+---------------------------------+
    | linear_multistep_method    | OT_STRING | Integrator scheme: BDF|adams    |
    +----------------------------+-----------+---------------------------------+
    | linear_solver              | OT_STRING | A custom linear solver creator  |
    |                            |           | function [default: qr]          |
    +----------------------------+-----------+---------------------------------+
    | linear_solver_options      | OT_DICT   | Options to be passed to the     |
    |                            |           | linear solver                   |
    +----------------------------+-----------+---------------------------------+
    | max_krylov                 | OT_INT    | Maximum Krylov subspace size    |
    +----------------------------+-----------+---------------------------------+
    | max_multistep_order        | OT_INT    | Maximum order for the           |
    |                            |           | (variable-order) multistep      |
    |                            |           | method                          |
    +----------------------------+-----------+---------------------------------+
    | max_num_steps              | OT_INT    | Maximum number of integrator    |
    |                            |           | steps                           |
    +----------------------------+-----------+---------------------------------+
    | max_order                  | OT_DOUBLE | Maximum order                   |
    +----------------------------+-----------+---------------------------------+
    | max_step_size              | OT_DOUBLE | Max step size [default: 0/inf]  |
    +----------------------------+-----------+---------------------------------+
    | min_step_size              | OT_DOUBLE | Min step size [default: 0/0.0]  |
    +----------------------------+-----------+---------------------------------+
    | newton_scheme              | OT_STRING | Linear solver scheme in the     |
    |                            |           | Newton method:                  |
    |                            |           | DIRECT|gmres|bcgstab|tfqmr      |
    +----------------------------+-----------+---------------------------------+
    | nonlin_conv_coeff          | OT_DOUBLE | Coefficient in the nonlinear    |
    |                            |           | convergence test                |
    +----------------------------+-----------+---------------------------------+
    | nonlinear_solver_iteration | OT_STRING | Nonlinear solver type:          |
    |                            |           | NEWTON|functional               |
    +----------------------------+-----------+---------------------------------+
    | quad_err_con               | OT_BOOL   | Should the quadratures affect   |
    |                            |           | the step size control           |
    +----------------------------+-----------+---------------------------------+
    | reltol                     | OT_DOUBLE | Relative tolerence for the IVP  |
    |                            |           | solution                        |
    +----------------------------+-----------+---------------------------------+
    | second_order_correction    | OT_BOOL   | Second order correction in the  |
    |                            |           | augmented system Jacobian       |
    |                            |           | [true]                          |
    +----------------------------+-----------+---------------------------------+
    | sensitivity_method         | OT_STRING | Sensitivity method:             |
    |                            |           | SIMULTANEOUS|staggered          |
    +----------------------------+-----------+---------------------------------+
    | step0                      | OT_DOUBLE | initial step size [default:     |
    |                            |           | 0/estimated]                    |
    +----------------------------+-----------+---------------------------------+
    | steps_per_checkpoint       | OT_INT    | Number of steps between two     |
    |                            |           | consecutive checkpoints         |
    +----------------------------+-----------+---------------------------------+
    | stop_at_end                | OT_BOOL   | Stop the integrator at the end  |
    |                            |           | of the interval                 |
    +----------------------------+-----------+---------------------------------+
    | use_preconditioner         | OT_BOOL   | Precondition the iterative      |
    |                            |           | solver [default: true]          |
    +----------------------------+-----------+---------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    idas
    ----



    Interface to IDAS from the Sundials suite.

    >List of available options

    +---------------------------+-----------------+----------------------------+
    |            Id             |      Type       |        Description         |
    +===========================+=================+============================+
    | abstol                    | OT_DOUBLE       | Absolute tolerence for the |
    |                           |                 | IVP solution               |
    +---------------------------+-----------------+----------------------------+
    | abstolv                   | OT_DOUBLEVECTOR | Absolute tolerarance for   |
    |                           |                 | each component             |
    +---------------------------+-----------------+----------------------------+
    | calc_ic                   | OT_BOOL         | Use IDACalcIC to get       |
    |                           |                 | consistent initial         |
    |                           |                 | conditions.                |
    +---------------------------+-----------------+----------------------------+
    | calc_icB                  | OT_BOOL         | Use IDACalcIC to get       |
    |                           |                 | consistent initial         |
    |                           |                 | conditions for backwards   |
    |                           |                 | system [default: equal to  |
    |                           |                 | calc_ic].                  |
    +---------------------------+-----------------+----------------------------+
    | cj_scaling                | OT_BOOL         | IDAS scaling on cj for the |
    |                           |                 | user-defined linear solver |
    |                           |                 | module                     |
    +---------------------------+-----------------+----------------------------+
    | constraints               | OT_INTVECTOR    | Constrain the solution     |
    |                           |                 | y=[x,z]. 0 (default): no   |
    |                           |                 | constraint on yi, 1: yi >= |
    |                           |                 | 0.0, -1: yi <= 0.0, 2: yi  |
    |                           |                 | > 0.0, -2: yi < 0.0.       |
    +---------------------------+-----------------+----------------------------+
    | disable_internal_warnings | OT_BOOL         | Disable SUNDIALS internal  |
    |                           |                 | warning messages           |
    +---------------------------+-----------------+----------------------------+
    | first_time                | OT_DOUBLE       | First requested time as a  |
    |                           |                 | fraction of the time       |
    |                           |                 | interval                   |
    +---------------------------+-----------------+----------------------------+
    | fsens_err_con             | OT_BOOL         | include the forward        |
    |                           |                 | sensitivities in all error |
    |                           |                 | controls                   |
    +---------------------------+-----------------+----------------------------+
    | init_xdot                 | OT_DOUBLEVECTOR | Initial values for the     |
    |                           |                 | state derivatives          |
    +---------------------------+-----------------+----------------------------+
    | interpolation_type        | OT_STRING       | Type of interpolation for  |
    |                           |                 | the adjoint sensitivities  |
    +---------------------------+-----------------+----------------------------+
    | linear_solver             | OT_STRING       | A custom linear solver     |
    |                           |                 | creator function [default: |
    |                           |                 | qr]                        |
    +---------------------------+-----------------+----------------------------+
    | linear_solver_options     | OT_DICT         | Options to be passed to    |
    |                           |                 | the linear solver          |
    +---------------------------+-----------------+----------------------------+
    | max_krylov                | OT_INT          | Maximum Krylov subspace    |
    |                           |                 | size                       |
    +---------------------------+-----------------+----------------------------+
    | max_multistep_order       | OT_INT          | Maximum order for the      |
    |                           |                 | (variable-order) multistep |
    |                           |                 | method                     |
    +---------------------------+-----------------+----------------------------+
    | max_num_steps             | OT_INT          | Maximum number of          |
    |                           |                 | integrator steps           |
    +---------------------------+-----------------+----------------------------+
    | max_order                 | OT_DOUBLE       | Maximum order              |
    +---------------------------+-----------------+----------------------------+
    | max_step_size             | OT_DOUBLE       | Maximim step size          |
    +---------------------------+-----------------+----------------------------+
    | newton_scheme             | OT_STRING       | Linear solver scheme in    |
    |                           |                 | the Newton method:         |
    |                           |                 | DIRECT|gmres|bcgstab|tfqmr |
    +---------------------------+-----------------+----------------------------+
    | nonlin_conv_coeff         | OT_DOUBLE       | Coefficient in the         |
    |                           |                 | nonlinear convergence test |
    +---------------------------+-----------------+----------------------------+
    | quad_err_con              | OT_BOOL         | Should the quadratures     |
    |                           |                 | affect the step size       |
    |                           |                 | control                    |
    +---------------------------+-----------------+----------------------------+
    | reltol                    | OT_DOUBLE       | Relative tolerence for the |
    |                           |                 | IVP solution               |
    +---------------------------+-----------------+----------------------------+
    | second_order_correction   | OT_BOOL         | Second order correction in |
    |                           |                 | the augmented system       |
    |                           |                 | Jacobian [true]            |
    +---------------------------+-----------------+----------------------------+
    | sensitivity_method        | OT_STRING       | Sensitivity method:        |
    |                           |                 | SIMULTANEOUS|staggered     |
    +---------------------------+-----------------+----------------------------+
    | step0                     | OT_DOUBLE       | initial step size          |
    |                           |                 | [default: 0/estimated]     |
    +---------------------------+-----------------+----------------------------+
    | steps_per_checkpoint      | OT_INT          | Number of steps between    |
    |                           |                 | two consecutive            |
    |                           |                 | checkpoints                |
    +---------------------------+-----------------+----------------------------+
    | stop_at_end               | OT_BOOL         | Stop the integrator at the |
    |                           |                 | end of the interval        |
    +---------------------------+-----------------+----------------------------+
    | suppress_algebraic        | OT_BOOL         | Suppress algebraic         |
    |                           |                 | variables in the error     |
    |                           |                 | testing                    |
    +---------------------------+-----------------+----------------------------+
    | use_preconditioner        | OT_BOOL         | Precondition the iterative |
    |                           |                 | solver [default: true]     |
    +---------------------------+-----------------+----------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    collocation
    -----------



    Fixed-step implicit Runge-Kutta integrator ODE/DAE integrator based on
    collocation schemes

    The method is still under development

    >List of available options

    +---------------------------+-----------------+----------------------------+
    |            Id             |      Type       |        Description         |
    +===========================+=================+============================+
    | augmented_options         | OT_DICT         | Options to be passed down  |
    |                           |                 | to the augmented           |
    |                           |                 | integrator, if one is      |
    |                           |                 | constructed.               |
    +---------------------------+-----------------+----------------------------+
    | collocation_scheme        | OT_STRING       | Collocation scheme:        |
    |                           |                 | radau|legendre             |
    +---------------------------+-----------------+----------------------------+
    | expand                    | OT_BOOL         | Replace MX with SX         |
    |                           |                 | expressions in problem     |
    |                           |                 | formulation [false]        |
    +---------------------------+-----------------+----------------------------+
    | grid                      | OT_DOUBLEVECTOR | Time grid                  |
    +---------------------------+-----------------+----------------------------+
    | interpolation_order       | OT_INT          | Order of the interpolating |
    |                           |                 | polynomials                |
    +---------------------------+-----------------+----------------------------+
    | number_of_finite_elements | OT_INT          | Number of finite elements  |
    +---------------------------+-----------------+----------------------------+
    | output_t0                 | OT_BOOL         | Output the state at the    |
    |                           |                 | initial time               |
    +---------------------------+-----------------+----------------------------+
    | print_stats               | OT_BOOL         | Print out statistics after |
    |                           |                 | integration                |
    +---------------------------+-----------------+----------------------------+
    | rootfinder                | OT_STRING       | An implicit function       |
    |                           |                 | solver                     |
    +---------------------------+-----------------+----------------------------+
    | rootfinder_options        | OT_DICT         | Options to be passed to    |
    |                           |                 | the NLP Solver             |
    +---------------------------+-----------------+----------------------------+
    | simplify                  | OT_BOOL         | Implement as MX  Function  |
    |                           |                 | (codegeneratable/serializa |
    |                           |                 | ble) default: false        |
    +---------------------------+-----------------+----------------------------+
    | simplify_options          | OT_DICT         | Any options to pass to     |
    |                           |                 | simplified form Function   |
    |                           |                 | constructor                |
    +---------------------------+-----------------+----------------------------+
    | t0                        | OT_DOUBLE       | Beginning of the time      |
    |                           |                 | horizon                    |
    +---------------------------+-----------------+----------------------------+
    | tf                        | OT_DOUBLE       | End of the time horizon    |
    +---------------------------+-----------------+----------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    rk --



    Fixed-step explicit Runge-Kutta integrator for ODEs Currently implements
    RK4.

    The method is still under development

    --------------------------------------------------------------------------------



    Joel Andersson



    .............



    """
    return _casadi.integrator(*args)

def has_integrator(*args):
    """
    Check if a particular plugin is available.

    has_integrator(str name) -> bool





    """
    return _casadi.has_integrator(*args)

def load_integrator(*args):
    """
    Explicitly load a plugin dynamically.

    load_integrator(str name)





    """
    return _casadi.load_integrator(*args)

def doc_integrator(*args):
    """
    Get the documentation string for a plugin.

    doc_integrator(str name) -> str





    """
    return _casadi.doc_integrator(*args)

def integrator_in(*args):
    """
      Get integrator input scheme name by index.

      integrator_in() -> [str]
      integrator_in(int ind) -> str




    .......

    ::

      integrator_in()



    Get input scheme of integrators.



    .............


    .......

    ::

      integrator_in(int ind)



    Get integrator input scheme name by index.



    .............



    """
    return _casadi.integrator_in(*args)

def integrator_out(*args):
    """
      Get output scheme name by index.

      integrator_out() -> [str]
      integrator_out(int ind) -> str




    .......

    ::

      integrator_out()



    Get integrator output scheme of integrators.



    .............


    .......

    ::

      integrator_out(int ind)



    Get output scheme name by index.



    .............



    """
    return _casadi.integrator_out(*args)

def integrator_n_in(*args):
    """
    Get the number of integrator inputs.

    integrator_n_in() -> int





    """
    return _casadi.integrator_n_in(*args)

def integrator_n_out(*args):
    """
    Get the number of integrator outputs.

    integrator_n_out() -> int





    """
    return _casadi.integrator_n_out(*args)

def conic(*args):
    """
      Create a QP solver Solves the following strictly convex problem:

      conic(str name, str solver, dict:Sparsity qp, dict opts) -> Function




    ::

      min          1/2 x' H x + g' x
      x

      subject to
      LBA <= A x <= UBA
      LBX <= x   <= UBX

      resize(Q x, np, np) + P >= 0 (psd)

      with :
      H sparse (n x n) positive definite
      g dense  (n x 1)
      A sparse (nc x n)
      Q sparse symmetric (np^2 x n)
      P sparse symmetric (np x nq)

      n: number of decision variables (x)
      nc: number of constraints (A)
      nq: shape of psd constraint matrix



    If H is not positive-definite, the solver should throw an error.

    Second-order cone constraints can be added as psd constraints through a
    helper function 'soc':

    x in R^n y in R

    || x ||_2 <= y

    <=>

    soc(x, y) psd

    This can be proven with soc(x, y)=[y*I x; x' y] using the Shur complement.

    General information
    ===================



    >List of available options

    +------------------+-----------------+------------------+------------------+
    |        Id        |      Type       |   Description    |     Used in      |
    +==================+=================+==================+==================+
    | ad_weight        | OT_DOUBLE       | Weighting factor | casadi::Function |
    |                  |                 | for derivative   | Internal         |
    |                  |                 | calculation.When |                  |
    |                  |                 | there is an      |                  |
    |                  |                 | option of either |                  |
    |                  |                 | using forward or |                  |
    |                  |                 | reverse mode     |                  |
    |                  |                 | directional      |                  |
    |                  |                 | derivatives, the |                  |
    |                  |                 | condition ad_wei |                  |
    |                  |                 | ght*nf<=(1-ad_we |                  |
    |                  |                 | ight)*na is used |                  |
    |                  |                 | where nf and na  |                  |
    |                  |                 | are estimates of |                  |
    |                  |                 | the number of    |                  |
    |                  |                 | forward/reverse  |                  |
    |                  |                 | mode directional |                  |
    |                  |                 | derivatives      |                  |
    |                  |                 | needed. By       |                  |
    |                  |                 | default,         |                  |
    |                  |                 | ad_weight is     |                  |
    |                  |                 | calculated       |                  |
    |                  |                 | automatically,   |                  |
    |                  |                 | but this can be  |                  |
    |                  |                 | overridden by    |                  |
    |                  |                 | setting this     |                  |
    |                  |                 | option. In       |                  |
    |                  |                 | particular, 0    |                  |
    |                  |                 | means forcing    |                  |
    |                  |                 | forward mode and |                  |
    |                  |                 | 1 forcing        |                  |
    |                  |                 | reverse mode.    |                  |
    |                  |                 | Leave unset for  |                  |
    |                  |                 | (class specific) |                  |
    |                  |                 | heuristics.      |                  |
    +------------------+-----------------+------------------+------------------+
    | ad_weight_sp     | OT_DOUBLE       | Weighting factor | casadi::Function |
    |                  |                 | for sparsity     | Internal         |
    |                  |                 | pattern          |                  |
    |                  |                 | calculation calc |                  |
    |                  |                 | ulation.Override |                  |
    |                  |                 | s default        |                  |
    |                  |                 | behavior. Set to |                  |
    |                  |                 | 0 and 1 to force |                  |
    |                  |                 | forward and      |                  |
    |                  |                 | reverse mode     |                  |
    |                  |                 | respectively.    |                  |
    |                  |                 | Cf. option       |                  |
    |                  |                 | "ad_weight".     |                  |
    |                  |                 | When set to -1,  |                  |
    |                  |                 | sparsity is      |                  |
    |                  |                 | completely       |                  |
    |                  |                 | ignored and      |                  |
    |                  |                 | dense matrices   |                  |
    |                  |                 | are used.        |                  |
    +------------------+-----------------+------------------+------------------+
    | always_inline    | OT_BOOL         | Force inlining.  | casadi::Function |
    |                  |                 |                  | Internal         |
    +------------------+-----------------+------------------+------------------+
    | compiler         | OT_STRING       | Just-in-time     | casadi::Function |
    |                  |                 | compiler plugin  | Internal         |
    |                  |                 | to be used.      |                  |
    +------------------+-----------------+------------------+------------------+
    | custom_jacobian  | OT_FUNCTION     | Override         | casadi::Function |
    |                  |                 | CasADi's AD. Use | Internal         |
    |                  |                 | together with    |                  |
    |                  |                 | 'jac_penalty':   |                  |
    |                  |                 | 0. Note: Highly  |                  |
    |                  |                 | experimental.    |                  |
    |                  |                 | Syntax may break |                  |
    |                  |                 | often.           |                  |
    +------------------+-----------------+------------------+------------------+
    | derivative_of    | OT_FUNCTION     | The function is  | casadi::Function |
    |                  |                 | a derivative of  | Internal         |
    |                  |                 | another          |                  |
    |                  |                 | function. The    |                  |
    |                  |                 | type of          |                  |
    |                  |                 | derivative       |                  |
    |                  |                 | (directional     |                  |
    |                  |                 | derivative,      |                  |
    |                  |                 | Jacobian) is     |                  |
    |                  |                 | inferred from    |                  |
    |                  |                 | the function     |                  |
    |                  |                 | name.            |                  |
    +------------------+-----------------+------------------+------------------+
    | discrete         | OT_BOOLVECTOR   | Indicates which  | casadi::Conic    |
    |                  |                 | of the variables |                  |
    |                  |                 | are discrete,    |                  |
    |                  |                 | i.e. integer-    |                  |
    |                  |                 | valued           |                  |
    +------------------+-----------------+------------------+------------------+
    | dump             | OT_BOOL         | Dump function to | casadi::Function |
    |                  |                 | file upon first  | Internal         |
    |                  |                 | evaluation.      |                  |
    |                  |                 | [false]          |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_dir         | OT_STRING       | Directory to     | casadi::Function |
    |                  |                 | dump             | Internal         |
    |                  |                 | inputs/outputs   |                  |
    |                  |                 | to. Make sure    |                  |
    |                  |                 | the directory    |                  |
    |                  |                 | exists [.]       |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_format      | OT_STRING       | Choose file      | casadi::Function |
    |                  |                 | format to dump   | Internal         |
    |                  |                 | matrices. See    |                  |
    |                  |                 | DM.from_file     |                  |
    |                  |                 | [mtx]            |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_in          | OT_BOOL         | Dump numerical   | casadi::Function |
    |                  |                 | values of inputs | Internal         |
    |                  |                 | to file          |                  |
    |                  |                 | (readable with   |                  |
    |                  |                 | DM.from_file )   |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_out         | OT_BOOL         | Dump numerical   | casadi::Function |
    |                  |                 | values of        | Internal         |
    |                  |                 | outputs to file  |                  |
    |                  |                 | (readable with   |                  |
    |                  |                 | DM.from_file )   |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_fd        | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation by   |                  |
    |                  |                 | finite           |                  |
    |                  |                 | differencing.    |                  |
    |                  |                 | [default:        |                  |
    |                  |                 | false]]          |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_forward   | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | Jacobian-times-  |                  |
    |                  |                 | vector products  |                  |
    |                  |                 | - typically      |                  |
    |                  |                 | using forward    |                  |
    |                  |                 | mode AD - if     |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_jacobian  | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | Jacobians of all |                  |
    |                  |                 | differentiable   |                  |
    |                  |                 | outputs with     |                  |
    |                  |                 | respect to all   |                  |
    |                  |                 | differentiable   |                  |
    |                  |                 | inputs - if      |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_reverse   | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | transposed       |                  |
    |                  |                 | Jacobian-times-  |                  |
    |                  |                 | vector products  |                  |
    |                  |                 | - typically      |                  |
    |                  |                 | using reverse    |                  |
    |                  |                 | mode AD - if     |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | error_on_fail    | OT_BOOL         | When the         | casadi::Conic    |
    |                  |                 | numerical        |                  |
    |                  |                 | process returns  |                  |
    |                  |                 | unsuccessfully,  |                  |
    |                  |                 | raise an error   |                  |
    |                  |                 | (default false). |                  |
    +------------------+-----------------+------------------+------------------+
    | fd_method        | OT_STRING       | Method for       | casadi::Function |
    |                  |                 | finite           | Internal         |
    |                  |                 | differencing     |                  |
    |                  |                 | [default         |                  |
    |                  |                 | 'central']       |                  |
    +------------------+-----------------+------------------+------------------+
    | fd_options       | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to the    | Internal         |
    |                  |                 | finite           |                  |
    |                  |                 | difference       |                  |
    |                  |                 | instance         |                  |
    +------------------+-----------------+------------------+------------------+
    | forward_options  | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to a      | Internal         |
    |                  |                 | forward mode     |                  |
    |                  |                 | constructor      |                  |
    +------------------+-----------------+------------------+------------------+
    | gather_stats     | OT_BOOL         | Deprecated       | casadi::Function |
    |                  |                 | option           | Internal         |
    |                  |                 | (ignored):       |                  |
    |                  |                 | Statistics are   |                  |
    |                  |                 | now always       |                  |
    |                  |                 | collected.       |                  |
    +------------------+-----------------+------------------+------------------+
    | input_scheme     | OT_STRINGVECTOR | Deprecated       | casadi::Function |
    |                  |                 | option (ignored) | Internal         |
    +------------------+-----------------+------------------+------------------+
    | inputs_check     | OT_BOOL         | Throw exceptions | casadi::Function |
    |                  |                 | when the         | Internal         |
    |                  |                 | numerical values |                  |
    |                  |                 | of the inputs    |                  |
    |                  |                 | don't make sense |                  |
    +------------------+-----------------+------------------+------------------+
    | is_diff_in       | OT_BOOLVECTOR   | Indicate for     | casadi::Function |
    |                  |                 | each input if it | Internal         |
    |                  |                 | should be        |                  |
    |                  |                 | differentiable.  |                  |
    +------------------+-----------------+------------------+------------------+
    | is_diff_out      | OT_BOOLVECTOR   | Indicate for     | casadi::Function |
    |                  |                 | each output if   | Internal         |
    |                  |                 | it should be     |                  |
    |                  |                 | differentiable.  |                  |
    +------------------+-----------------+------------------+------------------+
    | jac_penalty      | OT_DOUBLE       | When requested   | casadi::Function |
    |                  |                 | for a number of  | Internal         |
    |                  |                 | forward/reverse  |                  |
    |                  |                 | directions, it   |                  |
    |                  |                 | may be cheaper   |                  |
    |                  |                 | to compute first |                  |
    |                  |                 | the full         |                  |
    |                  |                 | jacobian and     |                  |
    |                  |                 | then multiply    |                  |
    |                  |                 | with seeds,      |                  |
    |                  |                 | rather than      |                  |
    |                  |                 | obtain the       |                  |
    |                  |                 | requested        |                  |
    |                  |                 | directions in a  |                  |
    |                  |                 | straightforward  |                  |
    |                  |                 | manner. Casadi   |                  |
    |                  |                 | uses a heuristic |                  |
    |                  |                 | to decide which  |                  |
    |                  |                 | is cheaper. A    |                  |
    |                  |                 | high value of    |                  |
    |                  |                 | 'jac_penalty'    |                  |
    |                  |                 | makes it less    |                  |
    |                  |                 | likely for the   |                  |
    |                  |                 | heurstic to      |                  |
    |                  |                 | chose the full   |                  |
    |                  |                 | Jacobian         |                  |
    |                  |                 | strategy. The    |                  |
    |                  |                 | special value -1 |                  |
    |                  |                 | indicates never  |                  |
    |                  |                 | to use the full  |                  |
    |                  |                 | Jacobian         |                  |
    |                  |                 | strategy         |                  |
    +------------------+-----------------+------------------+------------------+
    | jit              | OT_BOOL         | Use just-in-time | casadi::Function |
    |                  |                 | compiler to      | Internal         |
    |                  |                 | speed up the     |                  |
    |                  |                 | evaluation       |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_cleanup      | OT_BOOL         | Cleanup up the   | casadi::Function |
    |                  |                 | temporary source | Internal         |
    |                  |                 | file that jit    |                  |
    |                  |                 | creates.         |                  |
    |                  |                 | Default: true    |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_name         | OT_STRING       | The file name    | casadi::Function |
    |                  |                 | used to write    | Internal         |
    |                  |                 | out code. The    |                  |
    |                  |                 | actual file      |                  |
    |                  |                 | names used       |                  |
    |                  |                 | depend on 'jit_t |                  |
    |                  |                 | emp_suffix' and  |                  |
    |                  |                 | include          |                  |
    |                  |                 | extensions.      |                  |
    |                  |                 | Default:         |                  |
    |                  |                 | 'jit_tmp'        |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_options      | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to the    | Internal         |
    |                  |                 | jit compiler.    |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_serialize    | OT_STRING       | Specify          | casadi::Function |
    |                  |                 | behaviour when   | Internal         |
    |                  |                 | serializing a    |                  |
    |                  |                 | jitted function: |                  |
    |                  |                 | SOURCE|link|embe |                  |
    |                  |                 | d.               |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_temp_suffix  | OT_BOOL         | Use a temporary  | casadi::Function |
    |                  |                 | (seemingly       | Internal         |
    |                  |                 | random) filename |                  |
    |                  |                 | suffix for       |                  |
    |                  |                 | generated code   |                  |
    |                  |                 | and libraries.   |                  |
    |                  |                 | This is desired  |                  |
    |                  |                 | for thread-      |                  |
    |                  |                 | safety. This     |                  |
    |                  |                 | behaviour may    |                  |
    |                  |                 | defeat caching   |                  |
    |                  |                 | compiler         |                  |
    |                  |                 | wrappers.        |                  |
    |                  |                 | Default: true    |                  |
    +------------------+-----------------+------------------+------------------+
    | max_num_dir      | OT_INT          | Specify the      | casadi::Function |
    |                  |                 | maximum number   | Internal         |
    |                  |                 | of directions    |                  |
    |                  |                 | for derivative   |                  |
    |                  |                 | functions.       |                  |
    |                  |                 | Overrules the    |                  |
    |                  |                 | builtin optimize |                  |
    |                  |                 | d_num_dir.       |                  |
    +------------------+-----------------+------------------+------------------+
    | never_inline     | OT_BOOL         | Forbid inlining. | casadi::Function |
    |                  |                 |                  | Internal         |
    +------------------+-----------------+------------------+------------------+
    | output_scheme    | OT_STRINGVECTOR | Deprecated       | casadi::Function |
    |                  |                 | option (ignored) | Internal         |
    +------------------+-----------------+------------------+------------------+
    | print_in         | OT_BOOL         | Print numerical  | casadi::Function |
    |                  |                 | values of inputs | Internal         |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | print_out        | OT_BOOL         | Print numerical  | casadi::Function |
    |                  |                 | values of        | Internal         |
    |                  |                 | outputs          |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | print_problem    | OT_BOOL         | Print a numeric  | casadi::Conic    |
    |                  |                 | description of   |                  |
    |                  |                 | the problem      |                  |
    +------------------+-----------------+------------------+------------------+
    | print_time       | OT_BOOL         | print            | casadi::Function |
    |                  |                 | information      | Internal         |
    |                  |                 | about execution  |                  |
    |                  |                 | time. Implies    |                  |
    |                  |                 | record_time.     |                  |
    +------------------+-----------------+------------------+------------------+
    | record_time      | OT_BOOL         | record           | casadi::Function |
    |                  |                 | information      | Internal         |
    |                  |                 | about execution  |                  |
    |                  |                 | time, for        |                  |
    |                  |                 | retrieval with   |                  |
    |                  |                 | stats().         |                  |
    +------------------+-----------------+------------------+------------------+
    | regularity_check | OT_BOOL         | Throw exceptions | casadi::Function |
    |                  |                 | when NaN or Inf  | Internal         |
    |                  |                 | appears during   |                  |
    |                  |                 | evaluation       |                  |
    +------------------+-----------------+------------------+------------------+
    | reverse_options  | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to a      | Internal         |
    |                  |                 | reverse mode     |                  |
    |                  |                 | constructor      |                  |
    +------------------+-----------------+------------------+------------------+
    | user_data        | OT_VOIDPTR      | A user-defined   | casadi::Function |
    |                  |                 | field that can   | Internal         |
    |                  |                 | be used to       |                  |
    |                  |                 | identify the     |                  |
    |                  |                 | function or pass |                  |
    |                  |                 | additional       |                  |
    |                  |                 | information      |                  |
    +------------------+-----------------+------------------+------------------+
    | verbose          | OT_BOOL         | Verbose          | casadi::Function |
    |                  |                 | evaluation  for  | Internal         |
    |                  |                 | debugging        |                  |
    +------------------+-----------------+------------------+------------------+

    >Input scheme: casadi::ConicInput (CONIC_NUM_IN = 12)

    +--------------+--------+--------------------------------------------------+
    |  Full name   | Short  |                   Description                    |
    +==============+========+==================================================+
    | CONIC_H      | h      | The square matrix H: sparse, (n x n). Only the   |
    |              |        | lower triangular part is actually used. The      |
    |              |        | matrix is assumed to be symmetrical.             |
    +--------------+--------+--------------------------------------------------+
    | CONIC_G      | g      | The vector g: dense, (n x 1)                     |
    +--------------+--------+--------------------------------------------------+
    | CONIC_A      | a      | The matrix A: sparse, (nc x n) - product with x  |
    |              |        | must be dense.                                   |
    +--------------+--------+--------------------------------------------------+
    | CONIC_LBA    | lba    | dense, (nc x 1)                                  |
    +--------------+--------+--------------------------------------------------+
    | CONIC_UBA    | uba    | dense, (nc x 1)                                  |
    +--------------+--------+--------------------------------------------------+
    | CONIC_LBX    | lbx    | dense, (n x 1)                                   |
    +--------------+--------+--------------------------------------------------+
    | CONIC_UBX    | ubx    | dense, (n x 1)                                   |
    +--------------+--------+--------------------------------------------------+
    | CONIC_X0     | x0     | dense, (n x 1)                                   |
    +--------------+--------+--------------------------------------------------+
    | CONIC_LAM_X0 | lam_x0 | dense                                            |
    +--------------+--------+--------------------------------------------------+
    | CONIC_LAM_A0 | lam_a0 | dense                                            |
    +--------------+--------+--------------------------------------------------+
    | CONIC_Q      | q      | The matrix Q: sparse symmetric, (np^2 x n)       |
    +--------------+--------+--------------------------------------------------+
    | CONIC_P      | p      | The matrix P: sparse symmetric, (np x np)        |
    +--------------+--------+--------------------------------------------------+

    >Output scheme: casadi::ConicOutput (CONIC_NUM_OUT = 4)

    +-------------+-------+---------------------------------------------------+
    |  Full name  | Short |                    Description                    |
    +=============+=======+===================================================+
    | CONIC_X     | x     | The primal solution.                              |
    +-------------+-------+---------------------------------------------------+
    | CONIC_COST  | cost  | The optimal cost.                                 |
    +-------------+-------+---------------------------------------------------+
    | CONIC_LAM_A | lam_a | The dual solution corresponding to linear bounds. |
    +-------------+-------+---------------------------------------------------+
    | CONIC_LAM_X | lam_x | The dual solution corresponding to simple bounds. |
    +-------------+-------+---------------------------------------------------+

    List of plugins
    ===============



    - cbc

    - clp

    - cplex

    - gurobi

    - hpmpc

    - ooqp

    - osqp

    - qpoases

    - sqic

    - superscs

    - nlpsol

    - qrqp

    Note: some of the plugins in this list might not be available on your
    system. Also, there might be extra plugins available to you that are not
    listed here. You can obtain their documentation with
    Conic.doc("myextraplugin")



    --------------------------------------------------------------------------------

    cbc
    ---



    Interface to Cbc solver for sparse Quadratic Programs

    >List of available options

    +-------------+-----------------------+------------------------------------+
    |     Id      |         Type          |            Description             |
    +=============+=======================+====================================+
    | cbc         | OT_DICT               | Options to be passed to CBC.Three  |
    |             |                       | sets of options are supported. The |
    |             |                       | first can be found in              |
    |             |                       | OsiSolverParameters.hpp. The       |
    |             |                       | second can be found in             |
    |             |                       | CbcModel.hpp. The third are        |
    |             |                       | options that can be passed to      |
    |             |                       | CbcMain1.                          |
    +-------------+-----------------------+------------------------------------+
    | hot_start   | OT_BOOL               | Hot start with x0 [Default false]. |
    +-------------+-----------------------+------------------------------------+
    | sos_groups  | OT_INTVECTORVECTOR    | Definition of SOS groups by        |
    |             |                       | indices.                           |
    +-------------+-----------------------+------------------------------------+
    | sos_types   | OT_INTVECTOR          | Specify 1 or 2 for each SOS group. |
    +-------------+-----------------------+------------------------------------+
    | sos_weights | OT_DOUBLEVECTORVECTOR | Weights corresponding to SOS       |
    |             |                       | entries.                           |
    +-------------+-----------------------+------------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    clp
    ---



    Interface to Clp solver for sparse Quadratic Programs

    >List of available options

    +-----+---------+----------------------------------------------------------+
    | Id  |  Type   |                       Description                        |
    +=====+=========+==========================================================+
    | clp | OT_DICT | Options to be passed to CLP. A first set of options can  |
    |     |         | be found in ClpParameters.hpp. eg. 'PrimalTolerance'.    |
    |     |         | There are other options in additions. 'AutomaticScaling' |
    |     |         | (bool) is recognised. 'initial_solve' (default off)      |
    |     |         | activates the use of Clp's initialSolve.                 |
    |     |         | 'initial_solve_options' takes a dictionary with          |
    |     |         | following keys (see ClpSolve.hpp): SolveType (string),   |
    |     |         | PresolveType (string), NumberPasses, SpecialOptions      |
    |     |         | (intvectorvector), IndependentOptions (intvectorvector). |
    +-----+---------+----------------------------------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    cplex
    -----



    Interface to Cplex solver for sparse Quadratic Programs

    >List of available options

    +---------------+-----------------------+----------------------------------+
    |      Id       |         Type          |           Description            |
    +===============+=======================+==================================+
    | cplex         | OT_DICT               | Options to be passed to CPLEX    |
    +---------------+-----------------------+----------------------------------+
    | dep_check     | OT_INT                | Detect redundant constraints.    |
    +---------------+-----------------------+----------------------------------+
    | dump_filename | OT_STRING             | The filename to dump to.         |
    +---------------+-----------------------+----------------------------------+
    | dump_to_file  | OT_BOOL               | Dumps QP to file in CPLEX        |
    |               |                       | format.                          |
    +---------------+-----------------------+----------------------------------+
    | mip_start     | OT_BOOL               | Hot start integers with x0       |
    |               |                       | [Default false].                 |
    +---------------+-----------------------+----------------------------------+
    | qp_method     | OT_INT                | Determines which CPLEX algorithm |
    |               |                       | to use.                          |
    +---------------+-----------------------+----------------------------------+
    | sos_groups    | OT_INTVECTORVECTOR    | Definition of SOS groups by      |
    |               |                       | indices.                         |
    +---------------+-----------------------+----------------------------------+
    | sos_types     | OT_INTVECTOR          | Specify 1 or 2 for each SOS      |
    |               |                       | group.                           |
    +---------------+-----------------------+----------------------------------+
    | sos_weights   | OT_DOUBLEVECTORVECTOR | Weights corresponding to SOS     |
    |               |                       | entries.                         |
    +---------------+-----------------------+----------------------------------+
    | tol           | OT_DOUBLE             | Tolerance of solver              |
    +---------------+-----------------------+----------------------------------+
    | warm_start    | OT_BOOL               | Use warm start with simplex      |
    |               |                       | methods (affects only the        |
    |               |                       | simplex methods).                |
    +---------------+-----------------------+----------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    gurobi
    ------



    Interface to the GUROBI Solver for quadratic programming

    >List of available options

    +-------------+-----------------------+------------------------------------+
    |     Id      |         Type          |            Description             |
    +=============+=======================+====================================+
    | gurobi      | OT_DICT               | Options to be passed to gurobi.    |
    +-------------+-----------------------+------------------------------------+
    | sos_groups  | OT_INTVECTORVECTOR    | Definition of SOS groups by        |
    |             |                       | indices.                           |
    +-------------+-----------------------+------------------------------------+
    | sos_types   | OT_INTVECTOR          | Specify 1 or 2 for each SOS group. |
    +-------------+-----------------------+------------------------------------+
    | sos_weights | OT_DOUBLEVECTORVECTOR | Weights corresponding to SOS       |
    |             |                       | entries.                           |
    +-------------+-----------------------+------------------------------------+
    | vtype       | OT_STRINGVECTOR       | Type of variables: [CONTINUOUS|bin |
    |             |                       | ary|integer|semicont|semiint]      |
    +-------------+-----------------------+------------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    hpmpc
    -----



    Interface to HMPC Solver

    In order to use this interface, you must:

    Decision variables must only by state and control, and the variable ordering
    must be [x0 u0 x1 u1 ...]

    The constraints must be in order: [ gap0 lincon0 gap1 lincon1 ]

    gap: Ak+1 = Ak xk + Bk uk lincon: yk= Ck xk + Dk uk



    ::

             A0 B0 -I
             C0 D0
                    A1 B1 -I
                    C1 D1



    where I must be a diagonal sparse matrix Either supply all of N, nx, ng, nu
    options or rely on automatic detection

    >List of available options

    +----------------+--------------+------------------------------------------+
    |       Id       |     Type     |               Description                |
    +================+==============+==========================================+
    | N              | OT_INT       | OCP horizon                              |
    +----------------+--------------+------------------------------------------+
    | blasfeo_target | OT_STRING    | hpmpc target                             |
    +----------------+--------------+------------------------------------------+
    | inf            | OT_DOUBLE    | HPMPC cannot handle infinities.          |
    |                |              | Infinities will be replaced by this      |
    |                |              | option's value.                          |
    +----------------+--------------+------------------------------------------+
    | max_iter       | OT_INT       | Max number of iterations                 |
    +----------------+--------------+------------------------------------------+
    | mu0            | OT_DOUBLE    | Max element in cost function as estimate |
    |                |              | of max multiplier                        |
    +----------------+--------------+------------------------------------------+
    | ng             | OT_INTVECTOR | Number of non-dynamic constraints,       |
    |                |              | length N+1                               |
    +----------------+--------------+------------------------------------------+
    | nu             | OT_INTVECTOR | Number of controls, length N             |
    +----------------+--------------+------------------------------------------+
    | nx             | OT_INTVECTOR | Number of states, length N+1             |
    +----------------+--------------+------------------------------------------+
    | print_level    | OT_INT       | Amount of diagnostic printing [Default:  |
    |                |              | 1].                                      |
    +----------------+--------------+------------------------------------------+
    | target         | OT_STRING    | hpmpc target                             |
    +----------------+--------------+------------------------------------------+
    | tol            | OT_DOUBLE    | Tolerance in the duality measure         |
    +----------------+--------------+------------------------------------------+
    | warm_start     | OT_BOOL      | Use warm-starting                        |
    +----------------+--------------+------------------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    ooqp
    ----



    Interface to the OOQP Solver for quadratic programming The current
    implementation assumes that OOQP is configured with the MA27 sparse linear
    solver.

    NOTE: when doing multiple calls to evaluate(), check if you need to
    reInit();

    >List of available options

    +-------------+-----------+------------------------------------------------+
    |     Id      |   Type    |                  Description                   |
    +=============+===========+================================================+
    | artol       | OT_DOUBLE | tolerance as provided with setArTol to OOQP    |
    +-------------+-----------+------------------------------------------------+
    | mutol       | OT_DOUBLE | tolerance as provided with setMuTol to OOQP    |
    +-------------+-----------+------------------------------------------------+
    | print_level | OT_INT    | Print level. OOQP listens to print_level 0, 10 |
    |             |           | and 100                                        |
    +-------------+-----------+------------------------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    osqp
    ----



    Interface to the OSQP Solver for quadratic programming

    >List of available options

    +-------------------+---------+--------------------------------------------+
    |        Id         |  Type   |                Description                 |
    +===================+=========+============================================+
    | osqp              | OT_DICT | const Options to be passed to osqp.        |
    +-------------------+---------+--------------------------------------------+
    | warm_start_dual   | OT_BOOL | Use lam_a0 and lam_x0 input to warmstart   |
    |                   |         | [Default: truw].                           |
    +-------------------+---------+--------------------------------------------+
    | warm_start_primal | OT_BOOL | Use x0 input to warmstart [Default: true]. |
    +-------------------+---------+--------------------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    qpoases
    -------



    Interface to QPOases Solver for quadratic programming

    >List of available options

    +-------------------------------+-----------+------------------------------+
    |              Id               |   Type    |         Description          |
    +===============================+===========+==============================+
    | CPUtime                       | OT_DOUBLE | The maximum allowed CPU time |
    |                               |           | in seconds for the whole     |
    |                               |           | initialisation (and the      |
    |                               |           | actually required one on     |
    |                               |           | output). Disabled if unset.  |
    +-------------------------------+-----------+------------------------------+
    | boundRelaxation               | OT_DOUBLE | Initial relaxation of bounds |
    |                               |           | to start homotopy and        |
    |                               |           | initial value for far        |
    |                               |           | bounds.                      |
    +-------------------------------+-----------+------------------------------+
    | boundTolerance                | OT_DOUBLE | If upper and lower bounds    |
    |                               |           | differ less than this        |
    |                               |           | tolerance, they are regarded |
    |                               |           | equal, i.e. as equality      |
    |                               |           | constraint.                  |
    +-------------------------------+-----------+------------------------------+
    | enableCholeskyRefactorisation | OT_INT    | Specifies the frequency of a |
    |                               |           | full re-factorisation of     |
    |                               |           | projected Hessian matrix: 0: |
    |                               |           | turns them off, 1: uses them |
    |                               |           | at each iteration etc.       |
    +-------------------------------+-----------+------------------------------+
    | enableDriftCorrection         | OT_INT    | Specifies the frequency of   |
    |                               |           | drift corrections: 0: turns  |
    |                               |           | them off.                    |
    +-------------------------------+-----------+------------------------------+
    | enableEqualities              | OT_BOOL   | Specifies whether equalities |
    |                               |           | should be treated as always  |
    |                               |           | active (True) or not (False) |
    +-------------------------------+-----------+------------------------------+
    | enableFarBounds               | OT_BOOL   | Enables the use of far       |
    |                               |           | bounds.                      |
    +-------------------------------+-----------+------------------------------+
    | enableFlippingBounds          | OT_BOOL   | Enables the use of flipping  |
    |                               |           | bounds.                      |
    +-------------------------------+-----------+------------------------------+
    | enableFullLITests             | OT_BOOL   | Enables condition-hardened   |
    |                               |           | (but more expensive) LI      |
    |                               |           | test.                        |
    +-------------------------------+-----------+------------------------------+
    | enableInertiaCorrection       | OT_BOOL   | Should working set be        |
    |                               |           | repaired when negative       |
    |                               |           | curvature is discovered      |
    |                               |           | during hotstart.             |
    +-------------------------------+-----------+------------------------------+
    | enableNZCTests                | OT_BOOL   | Enables nonzero curvature    |
    |                               |           | tests.                       |
    +-------------------------------+-----------+------------------------------+
    | enableRamping                 | OT_BOOL   | Enables ramping.             |
    +-------------------------------+-----------+------------------------------+
    | enableRegularisation          | OT_BOOL   | Enables automatic Hessian    |
    |                               |           | regularisation.              |
    +-------------------------------+-----------+------------------------------+
    | epsDen                        | OT_DOUBLE | Denominator tolerance for    |
    |                               |           | ratio tests.                 |
    +-------------------------------+-----------+------------------------------+
    | epsFlipping                   | OT_DOUBLE | Tolerance of squared         |
    |                               |           | Cholesky diagonal factor     |
    |                               |           | which triggers flipping      |
    |                               |           | bound.                       |
    +-------------------------------+-----------+------------------------------+
    | epsIterRef                    | OT_DOUBLE | Early termination tolerance  |
    |                               |           | for iterative refinement.    |
    +-------------------------------+-----------+------------------------------+
    | epsLITests                    | OT_DOUBLE | Tolerance for linear         |
    |                               |           | independence tests.          |
    +-------------------------------+-----------+------------------------------+
    | epsNZCTests                   | OT_DOUBLE | Tolerance for nonzero        |
    |                               |           | curvature tests.             |
    +-------------------------------+-----------+------------------------------+
    | epsNum                        | OT_DOUBLE | Numerator tolerance for      |
    |                               |           | ratio tests.                 |
    +-------------------------------+-----------+------------------------------+
    | epsRegularisation             | OT_DOUBLE | Scaling factor of identity   |
    |                               |           | matrix used for Hessian      |
    |                               |           | regularisation.              |
    +-------------------------------+-----------+------------------------------+
    | finalRamping                  | OT_DOUBLE | Final value for ramping      |
    |                               |           | strategy.                    |
    +-------------------------------+-----------+------------------------------+
    | growFarBounds                 | OT_DOUBLE | Factor to grow far bounds.   |
    +-------------------------------+-----------+------------------------------+
    | hessian_type                  | OT_STRING | Type of Hessian - see        |
    |                               |           | qpOASES documentation [UNKNO |
    |                               |           | WN|posdef|semidef|indef|zero |
    |                               |           | |identity]]                  |
    +-------------------------------+-----------+------------------------------+
    | initialFarBounds              | OT_DOUBLE | Initial size for far bounds. |
    +-------------------------------+-----------+------------------------------+
    | initialRamping                | OT_DOUBLE | Start value for ramping      |
    |                               |           | strategy.                    |
    +-------------------------------+-----------+------------------------------+
    | initialStatusBounds           | OT_STRING | Initial status of bounds at  |
    |                               |           | first iteration.             |
    +-------------------------------+-----------+------------------------------+
    | linsol_plugin                 | OT_STRING | Linear solver plugin         |
    +-------------------------------+-----------+------------------------------+
    | maxDualJump                   | OT_DOUBLE | Maximum allowed jump in dual |
    |                               |           | variables in linear          |
    |                               |           | independence tests.          |
    +-------------------------------+-----------+------------------------------+
    | maxPrimalJump                 | OT_DOUBLE | Maximum allowed jump in      |
    |                               |           | primal variables in nonzero  |
    |                               |           | curvature tests.             |
    +-------------------------------+-----------+------------------------------+
    | max_schur                     | OT_INT    | Maximal number of Schur      |
    |                               |           | updates [75]                 |
    +-------------------------------+-----------+------------------------------+
    | nWSR                          | OT_INT    | The maximum number of        |
    |                               |           | working set recalculations   |
    |                               |           | to be performed during the   |
    |                               |           | initial homotopy. Default is |
    |                               |           | 5(nx + nc)                   |
    +-------------------------------+-----------+------------------------------+
    | numRefinementSteps            | OT_INT    | Maximum number of iterative  |
    |                               |           | refinement steps.            |
    +-------------------------------+-----------+------------------------------+
    | numRegularisationSteps        | OT_INT    | Maximum number of successive |
    |                               |           | regularisation steps.        |
    +-------------------------------+-----------+------------------------------+
    | printLevel                    | OT_STRING | Defines the amount of text   |
    |                               |           | output during QP solution,   |
    |                               |           | see Section 5.7              |
    +-------------------------------+-----------+------------------------------+
    | schur                         | OT_BOOL   | Use Schur Complement         |
    |                               |           | Approach [false]             |
    +-------------------------------+-----------+------------------------------+
    | sparse                        | OT_BOOL   | Formulate the QP using       |
    |                               |           | sparse matrices. [false]     |
    +-------------------------------+-----------+------------------------------+
    | terminationTolerance          | OT_DOUBLE | Relative termination         |
    |                               |           | tolerance to stop homotopy.  |
    +-------------------------------+-----------+------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    sqic
    ----



    Interface to the SQIC solver for quadratic programming

    --------------------------------------------------------------------------------





    --------------------------------------------------------------------------------

    superscs
    --------



    Interface to the SuperSCS solver for conic programming

    Joris Gillis, 2019

    >List of available options

    +----------+---------+-----------------------------------+
    |    Id    |  Type   |            Description            |
    +==========+=========+===================================+
    | superscs | OT_DICT | Options to be passed to superscs. |
    +----------+---------+-----------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    nlpsol
    ------



    Solve QPs using an Nlpsol Use the 'nlpsol' option to specify the NLP solver
    to use.

    >List of available options

    +----------------+-----------+---------------------------------+
    |       Id       |   Type    |           Description           |
    +================+===========+=================================+
    | nlpsol         | OT_STRING | Name of solver.                 |
    +----------------+-----------+---------------------------------+
    | nlpsol_options | OT_DICT   | Options to be passed to solver. |
    +----------------+-----------+---------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    qrqp
    ----



    Solve QPs using an active-set method

    >List of available options

    +-----------------+-----------+--------------------------------------------+
    |       Id        |   Type    |                Description                 |
    +=================+===========+============================================+
    | constr_viol_tol | OT_DOUBLE | Constraint violation tolerance [1e-8].     |
    +-----------------+-----------+--------------------------------------------+
    | dual_inf_tol    | OT_DOUBLE | Dual feasibility violation tolerance       |
    |                 |           | [1e-8]                                     |
    +-----------------+-----------+--------------------------------------------+
    | max_iter        | OT_INT    | Maximum number of iterations [1000].       |
    +-----------------+-----------+--------------------------------------------+
    | min_lam         | OT_DOUBLE | Smallest multiplier treated as inactive    |
    |                 |           | for the initial active set [0].            |
    +-----------------+-----------+--------------------------------------------+
    | print_header    | OT_BOOL   | Print header [true].                       |
    +-----------------+-----------+--------------------------------------------+
    | print_info      | OT_BOOL   | Print info [true].                         |
    +-----------------+-----------+--------------------------------------------+
    | print_iter      | OT_BOOL   | Print iterations [true].                   |
    +-----------------+-----------+--------------------------------------------+
    | print_lincomb   | OT_BOOL   | Print dependant linear combinations of     |
    |                 |           | constraints [false]. Printed numbers are   |
    |                 |           | 0-based indices into the vector of [simple |
    |                 |           | bounds;linear bounds]                      |
    +-----------------+-----------+--------------------------------------------+

    --------------------------------------------------------------------------------



    Joel Andersson




    """
    return _casadi.conic(*args)

def qpsol(*args):
    """


    qpsol(str name, str solver, dict:SX qp, dict opts) -> Function
    qpsol(str name, str solver, dict:MX qp, dict opts) -> Function



    """
    return _casadi.qpsol(*args)

def conic_in(*args):
    """
      Get QP solver input scheme name by index.

      conic_in() -> [str]
      conic_in(int ind) -> str




    .......

    ::

      conic_in()



    Get input scheme of QP solvers.



    .............


    .......

    ::

      conic_in(int ind)



    Get QP solver input scheme name by index.



    .............



    """
    return _casadi.conic_in(*args)

def conic_out(*args):
    """
      Get output scheme name by index.

      conic_out() -> [str]
      conic_out(int ind) -> str




    .......

    ::

      conic_out()



    Get QP solver output scheme of QP solvers.



    .............


    .......

    ::

      conic_out(int ind)



    Get output scheme name by index.



    .............



    """
    return _casadi.conic_out(*args)

def conic_n_in(*args):
    """
    Get the number of QP solver inputs.

    conic_n_in() -> int





    """
    return _casadi.conic_n_in(*args)

def conic_n_out(*args):
    """
    Get the number of QP solver outputs.

    conic_n_out() -> int





    """
    return _casadi.conic_n_out(*args)

def conic_options(*args):
    """
    Get all options for a plugin.

    conic_options(str name) -> [str]





    """
    return _casadi.conic_options(*args)

def conic_option_type(*args):
    """
    Get type info for a particular option.

    conic_option_type(str name, str op) -> str





    """
    return _casadi.conic_option_type(*args)

def conic_option_info(*args):
    """
    Get documentation for a particular option.

    conic_option_info(str name, str op) -> str





    """
    return _casadi.conic_option_info(*args)

def has_conic(*args):
    """
    Check if a particular plugin is available.

    has_conic(str name) -> bool





    """
    return _casadi.has_conic(*args)

def load_conic(*args):
    """
    Explicitly load a plugin dynamically.

    load_conic(str name)





    """
    return _casadi.load_conic(*args)

def doc_conic(*args):
    """
    Get the documentation string for a plugin.

    doc_conic(str name) -> str





    """
    return _casadi.doc_conic(*args)

def conic_debug(*args):
    """
    Generate native code in the interfaced language for debugging

    conic_debug(Function f, std::ostream & file)
    conic_debug(Function f, str filename)





    """
    return _casadi.conic_debug(*args)

def nlpsol(*args):
    """


      nlpsol(str name, str solver, Importer compiler, dict opts) -> Function
      nlpsol(str name, str solver, NlpBuilder nl, dict opts) -> Function
      nlpsol(str name, str solver, dict:SX nlp, dict opts) -> Function
      nlpsol(str name, str solver, dict:MX nlp, dict opts) -> Function
      nlpsol(str name, str solver, str fname, dict opts) -> Function


    .......

    ::

      nlpsol(str name, str solver, Importer compiler, dict opts)
      nlpsol(str name, str solver, NlpBuilder nl, dict opts)
      nlpsol(str name, str solver, dict:MX nlp, dict opts)
      nlpsol(str name, str solver, str fname, dict opts)



    .............


    .......

    ::

      nlpsol(str name, str solver, dict:SX nlp, dict opts)



    Create an NLP solver Creates a solver for the following parametric nonlinear
    program (NLP):

    ::

      min          F(x, p)
      x

      subject to
      LBX <=   x    <= UBX
      LBG <= G(x, p) <= UBG
      p  == P

      nx: number of decision variables
      ng: number of constraints
      np: number of parameters



    General information
    ===================



    >List of available options

    +------------------+-----------------+------------------+------------------+
    |        Id        |      Type       |   Description    |     Used in      |
    +==================+=================+==================+==================+
    | bound_consistenc | OT_BOOL         | Ensure that      | casadi::Nlpsol   |
    | y                |                 | primal-dual      |                  |
    |                  |                 | solution is      |                  |
    |                  |                 | consistent with  |                  |
    |                  |                 | the bounds       |                  |
    +------------------+-----------------+------------------+------------------+
    | calc_f           | OT_BOOL         | Calculate 'f' in | casadi::Nlpsol   |
    |                  |                 | the Nlpsol base  |                  |
    |                  |                 | class            |                  |
    +------------------+-----------------+------------------+------------------+
    | calc_g           | OT_BOOL         | Calculate 'g' in | casadi::Nlpsol   |
    |                  |                 | the Nlpsol base  |                  |
    |                  |                 | class            |                  |
    +------------------+-----------------+------------------+------------------+
    | calc_lam_p       | OT_BOOL         | Calculate        | casadi::Nlpsol   |
    |                  |                 | 'lam_p' in the   |                  |
    |                  |                 | Nlpsol base      |                  |
    |                  |                 | class            |                  |
    +------------------+-----------------+------------------+------------------+
    | calc_lam_x       | OT_BOOL         | Calculate        | casadi::Nlpsol   |
    |                  |                 | 'lam_x' in the   |                  |
    |                  |                 | Nlpsol base      |                  |
    |                  |                 | class            |                  |
    +------------------+-----------------+------------------+------------------+
    | calc_multipliers | OT_BOOL         | Calculate        | casadi::Nlpsol   |
    |                  |                 | Lagrange         |                  |
    |                  |                 | multipliers in   |                  |
    |                  |                 | the Nlpsol base  |                  |
    |                  |                 | class            |                  |
    +------------------+-----------------+------------------+------------------+
    | common_options   | OT_DICT         | Options for      | casadi::OracleFu |
    |                  |                 | auto-generated   | nction           |
    |                  |                 | functions        |                  |
    +------------------+-----------------+------------------+------------------+
    | discrete         | OT_BOOLVECTOR   | Indicates which  | casadi::Nlpsol   |
    |                  |                 | of the variables |                  |
    |                  |                 | are discrete,    |                  |
    |                  |                 | i.e. integer-    |                  |
    |                  |                 | valued           |                  |
    +------------------+-----------------+------------------+------------------+
    | error_on_fail    | OT_BOOL         | When the         | casadi::Nlpsol   |
    |                  |                 | numerical        |                  |
    |                  |                 | process returns  |                  |
    |                  |                 | unsuccessfully,  |                  |
    |                  |                 | raise an error   |                  |
    |                  |                 | (default false). |                  |
    +------------------+-----------------+------------------+------------------+
    | eval_errors_fata | OT_BOOL         | When errors      | casadi::Nlpsol   |
    | l                |                 | occur during     |                  |
    |                  |                 | evaluation of    |                  |
    |                  |                 | f,g,...,stop the |                  |
    |                  |                 | iterations       |                  |
    +------------------+-----------------+------------------+------------------+
    | expand           | OT_BOOL         | Replace MX with  | casadi::OracleFu |
    |                  |                 | SX expressions   | nction           |
    |                  |                 | in problem       |                  |
    |                  |                 | formulation      |                  |
    |                  |                 | [false]          |                  |
    +------------------+-----------------+------------------+------------------+
    | ignore_check_vec | OT_BOOL         | If set to true,  | casadi::Nlpsol   |
    |                  |                 | the input shape  |                  |
    |                  |                 | of F will not be |                  |
    |                  |                 | checked.         |                  |
    +------------------+-----------------+------------------+------------------+
    | iteration_callba | OT_FUNCTION     | A function that  | casadi::Nlpsol   |
    | ck               |                 | will be called   |                  |
    |                  |                 | at each          |                  |
    |                  |                 | iteration with   |                  |
    |                  |                 | the solver as    |                  |
    |                  |                 | input. Check     |                  |
    |                  |                 | documentation of |                  |
    |                  |                 | Callback .       |                  |
    +------------------+-----------------+------------------+------------------+
    | iteration_callba | OT_BOOL         | If set to true,  | casadi::Nlpsol   |
    | ck_ignore_errors |                 | errors thrown by |                  |
    |                  |                 | iteration_callba |                  |
    |                  |                 | ck will be       |                  |
    |                  |                 | ignored.         |                  |
    +------------------+-----------------+------------------+------------------+
    | iteration_callba | OT_INT          | Only call the    | casadi::Nlpsol   |
    | ck_step          |                 | callback         |                  |
    |                  |                 | function every   |                  |
    |                  |                 | few iterations.  |                  |
    +------------------+-----------------+------------------+------------------+
    | min_lam          | OT_DOUBLE       | Minimum allowed  | casadi::Nlpsol   |
    |                  |                 | multiplier value |                  |
    +------------------+-----------------+------------------+------------------+
    | monitor          | OT_STRINGVECTOR | Set of user      | casadi::OracleFu |
    |                  |                 | problem          | nction           |
    |                  |                 | functions to be  |                  |
    |                  |                 | monitored        |                  |
    +------------------+-----------------+------------------+------------------+
    | no_nlp_grad      | OT_BOOL         | Prevent the      | casadi::Nlpsol   |
    |                  |                 | creation of the  |                  |
    |                  |                 | 'nlp_grad'       |                  |
    |                  |                 | function         |                  |
    +------------------+-----------------+------------------+------------------+
    | oracle_options   | OT_DICT         | Options to be    | casadi::Nlpsol   |
    |                  |                 | passed to the    |                  |
    |                  |                 | oracle function  |                  |
    +------------------+-----------------+------------------+------------------+
    | sens_linsol      | OT_STRING       | Linear solver    | casadi::Nlpsol   |
    |                  |                 | used for         |                  |
    |                  |                 | parametric       |                  |
    |                  |                 | sensitivities    |                  |
    |                  |                 | (default 'qr').  |                  |
    +------------------+-----------------+------------------+------------------+
    | sens_linsol_opti | OT_DICT         | Linear solver    | casadi::Nlpsol   |
    | ons              |                 | options used for |                  |
    |                  |                 | parametric       |                  |
    |                  |                 | sensitivities.   |                  |
    +------------------+-----------------+------------------+------------------+
    | show_eval_warnin | OT_BOOL         | Show warnings    | casadi::OracleFu |
    | gs               |                 | generated from   | nction           |
    |                  |                 | function         |                  |
    |                  |                 | evaluations      |                  |
    |                  |                 | [true]           |                  |
    +------------------+-----------------+------------------+------------------+
    | specific_options | OT_DICT         | Options for      | casadi::OracleFu |
    |                  |                 | specific auto-   | nction           |
    |                  |                 | generated        |                  |
    |                  |                 | functions,       |                  |
    |                  |                 | overwriting the  |                  |
    |                  |                 | defaults from    |                  |
    |                  |                 | common_options.  |                  |
    |                  |                 | Nested           |                  |
    |                  |                 | dictionary.      |                  |
    +------------------+-----------------+------------------+------------------+
    | verbose_init     | OT_BOOL         | Print out timing | casadi::Nlpsol   |
    |                  |                 | information      |                  |
    |                  |                 | about the        |                  |
    |                  |                 | different stages |                  |
    |                  |                 | of               |                  |
    |                  |                 | initialization   |                  |
    +------------------+-----------------+------------------+------------------+
    | warn_initial_bou | OT_BOOL         | Warn if the      | casadi::Nlpsol   |
    | nds              |                 | initial guess    |                  |
    |                  |                 | does not satisfy |                  |
    |                  |                 | LBX and UBX      |                  |
    +------------------+-----------------+------------------+------------------+

    >Input scheme: casadi::NlpsolInput (NLPSOL_NUM_IN = 8)

    +---------------+--------+-------------------------------------------------+
    |   Full name   | Short  |                   Description                   |
    +===============+========+=================================================+
    | NLPSOL_X0     | x0     | Decision variables, initial guess (nx x 1)      |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_P      | p      | Value of fixed parameters (np x 1)              |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_LBX    | lbx    | Decision variables lower bound (nx x 1),        |
    |               |        | default -inf.                                   |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_UBX    | ubx    | Decision variables upper bound (nx x 1),        |
    |               |        | default +inf.                                   |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_LBG    | lbg    | Constraints lower bound (ng x 1), default -inf. |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_UBG    | ubg    | Constraints upper bound (ng x 1), default +inf. |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_LAM_X0 | lam_x0 | Lagrange multipliers for bounds on X, initial   |
    |               |        | guess (nx x 1)                                  |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_LAM_G0 | lam_g0 | Lagrange multipliers for bounds on G, initial   |
    |               |        | guess (ng x 1)                                  |
    +---------------+--------+-------------------------------------------------+

    >Output scheme: casadi::NlpsolOutput (NLPSOL_NUM_OUT = 6)

    +--------------+-------+---------------------------------------------------+
    |  Full name   | Short |                    Description                    |
    +==============+=======+===================================================+
    | NLPSOL_X     | x     | Decision variables at the optimal solution (nx x  |
    |              |       | 1)                                                |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_F     | f     | Cost function value at the optimal solution (1 x  |
    |              |       | 1)                                                |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_G     | g     | Constraints function at the optimal solution (ng  |
    |              |       | x 1)                                              |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_LAM_X | lam_x | Lagrange multipliers for bounds on X at the       |
    |              |       | solution (nx x 1)                                 |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_LAM_G | lam_g | Lagrange multipliers for bounds on G at the       |
    |              |       | solution (ng x 1)                                 |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_LAM_P | lam_p | Lagrange multipliers for bounds on P at the       |
    |              |       | solution (np x 1)                                 |
    +--------------+-------+---------------------------------------------------+

    List of plugins
    ===============



    - AmplInterface

    - blocksqp

    - bonmin

    - ipopt

    - knitro

    - snopt

    - worhp

    - qrsqp

    - scpgen

    - sqpmethod

    Note: some of the plugins in this list might not be available on your
    system. Also, there might be extra plugins available to you that are not
    listed here. You can obtain their documentation with
    Nlpsol.doc("myextraplugin")



    --------------------------------------------------------------------------------

    AmplInterface
    -------------



    >List of available options

    +--------+-----------+--------------------+
    |   Id   |   Type    |    Description     |
    +========+===========+====================+
    | solver | OT_STRING | AMPL solver binary |
    +--------+-----------+--------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    blocksqp
    --------



    This is a modified version of blockSQP by Janka et al.

    Dennis Janka, Joel Andersson

    >List of available options

    +----------------------------+-----------+---------------------------------+
    |             Id             |   Type    |           Description           |
    +============================+===========+=================================+
    | block_hess                 | OT_INT    | Blockwise Hessian               |
    |                            |           | approximation?                  |
    +----------------------------+-----------+---------------------------------+
    | col_eps                    | OT_DOUBLE | Epsilon for COL scaling         |
    |                            |           | strategy                        |
    +----------------------------+-----------+---------------------------------+
    | col_tau1                   | OT_DOUBLE | tau1 for COL scaling strategy   |
    +----------------------------+-----------+---------------------------------+
    | col_tau2                   | OT_DOUBLE | tau2 for COL scaling strategy   |
    +----------------------------+-----------+---------------------------------+
    | conv_strategy              | OT_INT    | Convexification strategy        |
    +----------------------------+-----------+---------------------------------+
    | delta                      | OT_DOUBLE | Filter line search parameter,   |
    |                            |           | cf. IPOPT paper                 |
    +----------------------------+-----------+---------------------------------+
    | delta_h0                   | OT_DOUBLE | Filter line search parameter,   |
    |                            |           | cf. IPOPT paper                 |
    +----------------------------+-----------+---------------------------------+
    | eps                        | OT_DOUBLE | Values smaller than this are    |
    |                            |           | regarded as numerically zero    |
    +----------------------------+-----------+---------------------------------+
    | eta                        | OT_DOUBLE | Filter line search parameter,   |
    |                            |           | cf. IPOPT paper                 |
    +----------------------------+-----------+---------------------------------+
    | fallback_scaling           | OT_INT    | If indefinite update is used,   |
    |                            |           | the type of fallback strategy   |
    +----------------------------+-----------+---------------------------------+
    | fallback_update            | OT_INT    | If indefinite update is used,   |
    |                            |           | the type of fallback strategy   |
    +----------------------------+-----------+---------------------------------+
    | gamma_f                    | OT_DOUBLE | Filter line search parameter,   |
    |                            |           | cf. IPOPT paper                 |
    +----------------------------+-----------+---------------------------------+
    | gamma_theta                | OT_DOUBLE | Filter line search parameter,   |
    |                            |           | cf. IPOPT paper                 |
    +----------------------------+-----------+---------------------------------+
    | globalization              | OT_BOOL   | Enable globalization            |
    +----------------------------+-----------+---------------------------------+
    | hess_damp                  | OT_INT    | Activate Powell damping for     |
    |                            |           | BFGS                            |
    +----------------------------+-----------+---------------------------------+
    | hess_damp_fac              | OT_DOUBLE | Damping factor for BFGS Powell  |
    |                            |           | modification                    |
    +----------------------------+-----------+---------------------------------+
    | hess_lim_mem               | OT_INT    | Full or limited memory          |
    +----------------------------+-----------+---------------------------------+
    | hess_memsize               | OT_INT    | Memory size for L-BFGS updates  |
    +----------------------------+-----------+---------------------------------+
    | hess_scaling               | OT_INT    | Scaling strategy for Hessian    |
    |                            |           | approximation                   |
    +----------------------------+-----------+---------------------------------+
    | hess_update                | OT_INT    | Type of Hessian approximation   |
    +----------------------------+-----------+---------------------------------+
    | ini_hess_diag              | OT_DOUBLE | Initial Hessian guess: diagonal |
    |                            |           | matrix diag(iniHessDiag)        |
    +----------------------------+-----------+---------------------------------+
    | kappa_f                    | OT_DOUBLE | Filter line search parameter,   |
    |                            |           | cf. IPOPT paper                 |
    +----------------------------+-----------+---------------------------------+
    | kappa_minus                | OT_DOUBLE | Filter line search parameter,   |
    |                            |           | cf. IPOPT paper                 |
    +----------------------------+-----------+---------------------------------+
    | kappa_plus                 | OT_DOUBLE | Filter line search parameter,   |
    |                            |           | cf. IPOPT paper                 |
    +----------------------------+-----------+---------------------------------+
    | kappa_plus_max             | OT_DOUBLE | Filter line search parameter,   |
    |                            |           | cf. IPOPT paper                 |
    +----------------------------+-----------+---------------------------------+
    | kappa_soc                  | OT_DOUBLE | Filter line search parameter,   |
    |                            |           | cf. IPOPT paper                 |
    +----------------------------+-----------+---------------------------------+
    | linsol                     | OT_STRING | The linear solver to be used by |
    |                            |           | the QP method                   |
    +----------------------------+-----------+---------------------------------+
    | max_consec_reduced_steps   | OT_INT    | Maximum number of consecutive   |
    |                            |           | reduced steps                   |
    +----------------------------+-----------+---------------------------------+
    | max_consec_skipped_updates | OT_INT    | Maximum number of consecutive   |
    |                            |           | skipped updates                 |
    +----------------------------+-----------+---------------------------------+
    | max_conv_qp                | OT_INT    | How many additional QPs may be  |
    |                            |           | solved for convexification per  |
    |                            |           | iteration?                      |
    +----------------------------+-----------+---------------------------------+
    | max_it_qp                  | OT_INT    | Maximum number of QP iterations |
    |                            |           | per SQP iteration               |
    +----------------------------+-----------+---------------------------------+
    | max_iter                   | OT_INT    | Maximum number of SQP           |
    |                            |           | iterations                      |
    +----------------------------+-----------+---------------------------------+
    | max_line_search            | OT_INT    | Maximum number of steps in line |
    |                            |           | search                          |
    +----------------------------+-----------+---------------------------------+
    | max_soc_iter               | OT_INT    | Maximum number of SOC line      |
    |                            |           | search iterations               |
    +----------------------------+-----------+---------------------------------+
    | max_time_qp                | OT_DOUBLE | Maximum number of time in       |
    |                            |           | seconds per QP solve per SQP    |
    |                            |           | iteration                       |
    +----------------------------+-----------+---------------------------------+
    | nlinfeastol                | OT_DOUBLE | Nonlinear feasibility tolerance |
    +----------------------------+-----------+---------------------------------+
    | obj_lo                     | OT_DOUBLE | Lower bound on objective        |
    |                            |           | function [-inf]                 |
    +----------------------------+-----------+---------------------------------+
    | obj_up                     | OT_DOUBLE | Upper bound on objective        |
    |                            |           | function [inf]                  |
    +----------------------------+-----------+---------------------------------+
    | opttol                     | OT_DOUBLE | Optimality tolerance            |
    +----------------------------+-----------+---------------------------------+
    | print_header               | OT_BOOL   | Print solver header at startup  |
    +----------------------------+-----------+---------------------------------+
    | print_iteration            | OT_BOOL   | Print SQP iterations            |
    +----------------------------+-----------+---------------------------------+
    | print_maxit_reached        | OT_BOOL   | Print error when maximum number |
    |                            |           | of SQP iterations reached       |
    +----------------------------+-----------+---------------------------------+
    | qp_init                    | OT_BOOL   | Use warmstarting                |
    +----------------------------+-----------+---------------------------------+
    | qpsol                      | OT_STRING | The QP solver to be used by the |
    |                            |           | SQP method                      |
    +----------------------------+-----------+---------------------------------+
    | qpsol_options              | OT_DICT   | Options to be passed to the QP  |
    |                            |           | solver                          |
    +----------------------------+-----------+---------------------------------+
    | restore_feas               | OT_BOOL   | Use feasibility restoration     |
    |                            |           | phase                           |
    +----------------------------+-----------+---------------------------------+
    | rho                        | OT_DOUBLE | Feasibility restoration phase   |
    |                            |           | parameter                       |
    +----------------------------+-----------+---------------------------------+
    | s_f                        | OT_DOUBLE | Filter line search parameter,   |
    |                            |           | cf. IPOPT paper                 |
    +----------------------------+-----------+---------------------------------+
    | s_theta                    | OT_DOUBLE | Filter line search parameter,   |
    |                            |           | cf. IPOPT paper                 |
    +----------------------------+-----------+---------------------------------+
    | schur                      | OT_BOOL   | Use qpOASES Schur compliment    |
    |                            |           | approach                        |
    +----------------------------+-----------+---------------------------------+
    | skip_first_globalization   | OT_BOOL   | No globalization strategy in    |
    |                            |           | first iteration                 |
    +----------------------------+-----------+---------------------------------+
    | theta_max                  | OT_DOUBLE | Filter line search parameter,   |
    |                            |           | cf. IPOPT paper                 |
    +----------------------------+-----------+---------------------------------+
    | theta_min                  | OT_DOUBLE | Filter line search parameter,   |
    |                            |           | cf. IPOPT paper                 |
    +----------------------------+-----------+---------------------------------+
    | warmstart                  | OT_BOOL   | Use warmstarting                |
    +----------------------------+-----------+---------------------------------+
    | which_second_derv          | OT_INT    | For which block should second   |
    |                            |           | derivatives be provided by the  |
    |                            |           | user                            |
    +----------------------------+-----------+---------------------------------+
    | zeta                       | OT_DOUBLE | Feasibility restoration phase   |
    |                            |           | parameter                       |
    +----------------------------+-----------+---------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    bonmin
    ------



    When in warmstart mode, output NLPSOL_LAM_X may be used as input

    NOTE: Even when max_iter == 0, it is not guaranteed that input(NLPSOL_X0) ==
    output(NLPSOL_X). Indeed if bounds on X or constraints are unmet, they will
    differ.

    For a good tutorial on BONMIN,
    seehttp://drops.dagstuhl.de/volltexte/2009/2089/pdf/09061.WaechterAndreas.Paper.2089.pdf

    A good resource about the algorithms in BONMIN is: Wachter and L. T.
    Biegler, On the Implementation of an Interior-Point Filter Line-Search
    Algorithm for Large-Scale Nonlinear Programming, Mathematical Programming
    106(1), pp. 25-57, 2006 (As Research Report RC 23149, IBM T. J. Watson
    Research Center, Yorktown, USA

    Caveats: with default options, multipliers for the decision variables are
    wrong for equality constraints. Change the 'fixed_variable_treatment' to
    'make_constraint' or 'relax_bounds' to obtain correct results.

    >List of available options

    +-------------------------+-----------------------+------------------------+
    |           Id            |         Type          |      Description       |
    +=========================+=======================+========================+
    | bonmin                  | OT_DICT               | Options to be passed   |
    |                         |                       | to BONMIN              |
    +-------------------------+-----------------------+------------------------+
    | con_integer_md          | OT_DICT               | Integer metadata (a    |
    |                         |                       | dictionary with lists  |
    |                         |                       | of integers) about     |
    |                         |                       | constraints to be      |
    |                         |                       | passed to BONMIN       |
    +-------------------------+-----------------------+------------------------+
    | con_numeric_md          | OT_DICT               | Numeric metadata (a    |
    |                         |                       | dictionary with lists  |
    |                         |                       | of reals) about        |
    |                         |                       | constraints to be      |
    |                         |                       | passed to BONMIN       |
    +-------------------------+-----------------------+------------------------+
    | con_string_md           | OT_DICT               | String metadata (a     |
    |                         |                       | dictionary with lists  |
    |                         |                       | of strings) about      |
    |                         |                       | constraints to be      |
    |                         |                       | passed to BONMIN       |
    +-------------------------+-----------------------+------------------------+
    | grad_f                  | OT_FUNCTION           | Function for           |
    |                         |                       | calculating the        |
    |                         |                       | gradient of the        |
    |                         |                       | objective (column,     |
    |                         |                       | autogenerated by       |
    |                         |                       | default)               |
    +-------------------------+-----------------------+------------------------+
    | grad_f_options          | OT_DICT               | Options for the        |
    |                         |                       | autogenerated gradient |
    |                         |                       | of the objective.      |
    +-------------------------+-----------------------+------------------------+
    | hess_lag                | OT_FUNCTION           | Function for           |
    |                         |                       | calculating the        |
    |                         |                       | Hessian of the         |
    |                         |                       | Lagrangian             |
    |                         |                       | (autogenerated by      |
    |                         |                       | default)               |
    +-------------------------+-----------------------+------------------------+
    | hess_lag_options        | OT_DICT               | Options for the        |
    |                         |                       | autogenerated Hessian  |
    |                         |                       | of the Lagrangian.     |
    +-------------------------+-----------------------+------------------------+
    | jac_g                   | OT_FUNCTION           | Function for           |
    |                         |                       | calculating the        |
    |                         |                       | Jacobian of the        |
    |                         |                       | constraints            |
    |                         |                       | (autogenerated by      |
    |                         |                       | default)               |
    +-------------------------+-----------------------+------------------------+
    | jac_g_options           | OT_DICT               | Options for the        |
    |                         |                       | autogenerated Jacobian |
    |                         |                       | of the constraints.    |
    +-------------------------+-----------------------+------------------------+
    | pass_nonlinear_constrai | OT_BOOL               | Pass list of           |
    | nts                     |                       | constraints entering   |
    |                         |                       | nonlinearly to BONMIN  |
    +-------------------------+-----------------------+------------------------+
    | pass_nonlinear_variable | OT_BOOL               | Pass list of variables |
    | s                       |                       | entering nonlinearly   |
    |                         |                       | to BONMIN              |
    +-------------------------+-----------------------+------------------------+
    | sos1_groups             | OT_INTVECTORVECTOR    | Options for the        |
    |                         |                       | autogenerated gradient |
    |                         |                       | of the objective.      |
    +-------------------------+-----------------------+------------------------+
    | sos1_priorities         | OT_INTVECTOR          | Options for the        |
    |                         |                       | autogenerated gradient |
    |                         |                       | of the objective.      |
    +-------------------------+-----------------------+------------------------+
    | sos1_weights            | OT_DOUBLEVECTORVECTOR | Options for the        |
    |                         |                       | autogenerated gradient |
    |                         |                       | of the objective.      |
    +-------------------------+-----------------------+------------------------+
    | var_integer_md          | OT_DICT               | Integer metadata (a    |
    |                         |                       | dictionary with lists  |
    |                         |                       | of integers) about     |
    |                         |                       | variables to be passed |
    |                         |                       | to BONMIN              |
    +-------------------------+-----------------------+------------------------+
    | var_numeric_md          | OT_DICT               | Numeric metadata (a    |
    |                         |                       | dictionary with lists  |
    |                         |                       | of reals) about        |
    |                         |                       | variables to be passed |
    |                         |                       | to BONMIN              |
    +-------------------------+-----------------------+------------------------+
    | var_string_md           | OT_DICT               | String metadata (a     |
    |                         |                       | dictionary with lists  |
    |                         |                       | of strings) about      |
    |                         |                       | variables to be passed |
    |                         |                       | to BONMIN              |
    +-------------------------+-----------------------+------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    ipopt
    -----



    When in warmstart mode, output NLPSOL_LAM_X may be used as input

    NOTE: Even when max_iter == 0, it is not guaranteed that input(NLPSOL_X0) ==
    output(NLPSOL_X). Indeed if bounds on X or constraints are unmet, they will
    differ.

    For a good tutorial on IPOPT,
    seehttp://drops.dagstuhl.de/volltexte/2009/2089/pdf/09061.WaechterAndreas.Paper.2089.pdf

    A good resource about the algorithms in IPOPT is: Wachter and L. T. Biegler,
    On the Implementation of an Interior-Point Filter Line-Search Algorithm for
    Large-Scale Nonlinear Programming, Mathematical Programming 106(1), pp.
    25-57, 2006 (As Research Report RC 23149, IBM T. J. Watson Research Center,
    Yorktown, USA

    Caveats: with default options, multipliers for the decision variables are
    wrong for equality constraints. Change the 'fixed_variable_treatment' to
    'make_constraint' or 'relax_bounds' to obtain correct results.

    >List of available options

    +--------------------------+-------------+---------------------------------+
    |            Id            |    Type     |           Description           |
    +==========================+=============+=================================+
    | clip_inactive_lam        | OT_BOOL     | Explicitly set Lagrange         |
    |                          |             | multipliers to 0 when bound is  |
    |                          |             | deemed inactive (default:       |
    |                          |             | false).                         |
    +--------------------------+-------------+---------------------------------+
    | con_integer_md           | OT_DICT     | Integer metadata (a dictionary  |
    |                          |             | with lists of integers) about   |
    |                          |             | constraints to be passed to     |
    |                          |             | IPOPT                           |
    +--------------------------+-------------+---------------------------------+
    | con_numeric_md           | OT_DICT     | Numeric metadata (a dictionary  |
    |                          |             | with lists of reals) about      |
    |                          |             | constraints to be passed to     |
    |                          |             | IPOPT                           |
    +--------------------------+-------------+---------------------------------+
    | con_string_md            | OT_DICT     | String metadata (a dictionary   |
    |                          |             | with lists of strings) about    |
    |                          |             | constraints to be passed to     |
    |                          |             | IPOPT                           |
    +--------------------------+-------------+---------------------------------+
    | convexify_margin         | OT_DOUBLE   | When using a convexification    |
    |                          |             | strategy, make sure that the    |
    |                          |             | smallest eigenvalue is at least |
    |                          |             | this (default: 1e-7).           |
    +--------------------------+-------------+---------------------------------+
    | convexify_strategy       | OT_STRING   | NONE|regularize|eigen-reflect   |
    |                          |             | |eigen-clip. Strategy to        |
    |                          |             | convexify the Lagrange Hessian  |
    |                          |             | before passing it to the        |
    |                          |             | solver.                         |
    +--------------------------+-------------+---------------------------------+
    | grad_f                   | OT_FUNCTION | Function for calculating the    |
    |                          |             | gradient of the objective       |
    |                          |             | (column, autogenerated by       |
    |                          |             | default)                        |
    +--------------------------+-------------+---------------------------------+
    | hess_lag                 | OT_FUNCTION | Function for calculating the    |
    |                          |             | Hessian of the Lagrangian       |
    |                          |             | (autogenerated by default)      |
    +--------------------------+-------------+---------------------------------+
    | inactive_lam_strategy    | OT_STRING   | Strategy to detect if a bound   |
    |                          |             | is inactive. RELTOL: use        |
    |                          |             | solver-defined constraint       |
    |                          |             | tolerance *                     |
    |                          |             | inactive_lam_value|abstol: use  |
    |                          |             | inactive_lam_value              |
    +--------------------------+-------------+---------------------------------+
    | inactive_lam_value       | OT_DOUBLE   | Value used in                   |
    |                          |             | inactive_lam_strategy (default: |
    |                          |             | 10).                            |
    +--------------------------+-------------+---------------------------------+
    | ipopt                    | OT_DICT     | Options to be passed to IPOPT   |
    +--------------------------+-------------+---------------------------------+
    | jac_g                    | OT_FUNCTION | Function for calculating the    |
    |                          |             | Jacobian of the constraints     |
    |                          |             | (autogenerated by default)      |
    +--------------------------+-------------+---------------------------------+
    | max_iter_eig             | OT_DOUBLE   | Maximum number of iterations to |
    |                          |             | compute an eigenvalue           |
    |                          |             | decomposition (default: 50).    |
    +--------------------------+-------------+---------------------------------+
    | pass_nonlinear_variables | OT_BOOL     | Pass list of variables entering |
    |                          |             | nonlinearly to IPOPT            |
    +--------------------------+-------------+---------------------------------+
    | var_integer_md           | OT_DICT     | Integer metadata (a dictionary  |
    |                          |             | with lists of integers) about   |
    |                          |             | variables to be passed to IPOPT |
    +--------------------------+-------------+---------------------------------+
    | var_numeric_md           | OT_DICT     | Numeric metadata (a dictionary  |
    |                          |             | with lists of reals) about      |
    |                          |             | variables to be passed to IPOPT |
    +--------------------------+-------------+---------------------------------+
    | var_string_md            | OT_DICT     | String metadata (a dictionary   |
    |                          |             | with lists of strings) about    |
    |                          |             | variables to be passed to IPOPT |
    +--------------------------+-------------+---------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    knitro
    ------



    KNITRO interface

    >List of available options

    +--------------------------+--------------------+--------------------------+
    |            Id            |        Type        |       Description        |
    +==========================+====================+==========================+
    | complem_variables        | OT_INTVECTORVECTOR | List of complementary    |
    |                          |                    | constraints on simple    |
    |                          |                    | bounds. Pair (i, j)      |
    |                          |                    | encodes complementarity  |
    |                          |                    | between the bounds on    |
    |                          |                    | variable i and variable  |
    |                          |                    | j.                       |
    +--------------------------+--------------------+--------------------------+
    | contype                  | OT_INTVECTOR       | Type of constraint       |
    +--------------------------+--------------------+--------------------------+
    | detect_linear_constraint | OT_BOOL            | Detect type of           |
    | s                        |                    | constraints              |
    +--------------------------+--------------------+--------------------------+
    | knitro                   | OT_DICT            | Options to be passed to  |
    |                          |                    | KNITRO                   |
    +--------------------------+--------------------+--------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    snopt
    -----



    SNOPT interface

    >List of available options

    +-------+-----------+---------------------------------------------+
    |  Id   |   Type    |                 Description                 |
    +=======+===========+=============================================+
    | snopt | OT_DICT   | Options to be passed to SNOPT               |
    +-------+-----------+---------------------------------------------+
    | start | OT_STRING | Warm-start options for Worhp: cold|warm|hot |
    +-------+-----------+---------------------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    worhp
    -----



    WORHP interface

    Designed for Worhp 1.12

    >List of available options

    +-------+---------+-------------------------------+
    |  Id   |  Type   |          Description          |
    +=======+=========+===============================+
    | worhp | OT_DICT | Options to be passed to WORHP |
    +-------+---------+-------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    qrsqp
    -----



    A textbook SQPMethod

    --------------------------------------------------------------------------------





    --------------------------------------------------------------------------------

    scpgen
    ------



    A structure-exploiting sequential quadratic programming (to be come
    sequential convex programming) method for nonlinear programming.

    >List of available options

    +-----------------------+-----------------+--------------------------------+
    |          Id           |      Type       |          Description           |
    +=======================+=================+================================+
    | beta                  | OT_DOUBLE       | Line-search parameter,         |
    |                       |                 | restoration factor of stepsize |
    +-----------------------+-----------------+--------------------------------+
    | c1                    | OT_DOUBLE       | Armijo condition, coefficient  |
    |                       |                 | of decrease in merit           |
    +-----------------------+-----------------+--------------------------------+
    | codegen               | OT_BOOL         | C-code generation              |
    +-----------------------+-----------------+--------------------------------+
    | hessian_approximation | OT_STRING       | gauss-newton|exact             |
    +-----------------------+-----------------+--------------------------------+
    | lbfgs_memory          | OT_INT          | Size of L-BFGS memory.         |
    +-----------------------+-----------------+--------------------------------+
    | max_iter              | OT_INT          | Maximum number of SQP          |
    |                       |                 | iterations                     |
    +-----------------------+-----------------+--------------------------------+
    | max_iter_ls           | OT_INT          | Maximum number of linesearch   |
    |                       |                 | iterations                     |
    +-----------------------+-----------------+--------------------------------+
    | merit_memsize         | OT_INT          | Size of memory to store        |
    |                       |                 | history of merit function      |
    |                       |                 | values                         |
    +-----------------------+-----------------+--------------------------------+
    | merit_start           | OT_DOUBLE       | Lower bound for the merit      |
    |                       |                 | function parameter             |
    +-----------------------+-----------------+--------------------------------+
    | name_x                | OT_STRINGVECTOR | Names of the variables.        |
    +-----------------------+-----------------+--------------------------------+
    | print_header          | OT_BOOL         | Print the header with problem  |
    |                       |                 | statistics                     |
    +-----------------------+-----------------+--------------------------------+
    | print_x               | OT_INTVECTOR    | Which variables to print.      |
    +-----------------------+-----------------+--------------------------------+
    | qpsol                 | OT_STRING       | The QP solver to be used by    |
    |                       |                 | the SQP method                 |
    +-----------------------+-----------------+--------------------------------+
    | qpsol_options         | OT_DICT         | Options to be passed to the QP |
    |                       |                 | solver                         |
    +-----------------------+-----------------+--------------------------------+
    | reg_threshold         | OT_DOUBLE       | Threshold for the              |
    |                       |                 | regularization.                |
    +-----------------------+-----------------+--------------------------------+
    | regularize            | OT_BOOL         | Automatic regularization of    |
    |                       |                 | Lagrange Hessian.              |
    +-----------------------+-----------------+--------------------------------+
    | tol_du                | OT_DOUBLE       | Stopping criterion for dual    |
    |                       |                 | infeasability                  |
    +-----------------------+-----------------+--------------------------------+
    | tol_pr                | OT_DOUBLE       | Stopping criterion for primal  |
    |                       |                 | infeasibility                  |
    +-----------------------+-----------------+--------------------------------+
    | tol_pr_step           | OT_DOUBLE       | Stopping criterion for the     |
    |                       |                 | step size                      |
    +-----------------------+-----------------+--------------------------------+
    | tol_reg               | OT_DOUBLE       | Stopping criterion for         |
    |                       |                 | regularization                 |
    +-----------------------+-----------------+--------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    sqpmethod
    ---------



    A textbook SQPMethod

    >List of available options

    +-----------------------+-------------+------------------------------------+
    |          Id           |    Type     |            Description             |
    +=======================+=============+====================================+
    | beta                  | OT_DOUBLE   | Line-search parameter, restoration |
    |                       |             | factor of stepsize                 |
    +-----------------------+-------------+------------------------------------+
    | c1                    | OT_DOUBLE   | Armijo condition, coefficient of   |
    |                       |             | decrease in merit                  |
    +-----------------------+-------------+------------------------------------+
    | convexify_margin      | OT_DOUBLE   | When using a convexification       |
    |                       |             | strategy, make sure that the       |
    |                       |             | smallest eigenvalue is at least    |
    |                       |             | this (default: 1e-7).              |
    +-----------------------+-------------+------------------------------------+
    | convexify_strategy    | OT_STRING   | NONE|regularize|eigen-reflect      |
    |                       |             | |eigen-clip. Strategy to convexify |
    |                       |             | the Lagrange Hessian before        |
    |                       |             | passing it to the solver.          |
    +-----------------------+-------------+------------------------------------+
    | hess_lag              | OT_FUNCTION | Function for calculating the       |
    |                       |             | Hessian of the Lagrangian          |
    |                       |             | (autogenerated by default)         |
    +-----------------------+-------------+------------------------------------+
    | hessian_approximation | OT_STRING   | limited-memory|exact               |
    +-----------------------+-------------+------------------------------------+
    | jac_fg                | OT_FUNCTION | Function for calculating the       |
    |                       |             | gradient of the objective and      |
    |                       |             | Jacobian of the constraints        |
    |                       |             | (autogenerated by default)         |
    +-----------------------+-------------+------------------------------------+
    | lbfgs_memory          | OT_INT      | Size of L-BFGS memory.             |
    +-----------------------+-------------+------------------------------------+
    | max_iter              | OT_INT      | Maximum number of SQP iterations   |
    +-----------------------+-------------+------------------------------------+
    | max_iter_eig          | OT_DOUBLE   | Maximum number of iterations to    |
    |                       |             | compute an eigenvalue              |
    |                       |             | decomposition (default: 50).       |
    +-----------------------+-------------+------------------------------------+
    | max_iter_ls           | OT_INT      | Maximum number of linesearch       |
    |                       |             | iterations                         |
    +-----------------------+-------------+------------------------------------+
    | merit_memory          | OT_INT      | Size of memory to store history of |
    |                       |             | merit function values              |
    +-----------------------+-------------+------------------------------------+
    | min_iter              | OT_INT      | Minimum number of SQP iterations   |
    +-----------------------+-------------+------------------------------------+
    | min_step_size         | OT_DOUBLE   | The size (inf-norm) of the step    |
    |                       |             | size should not become smaller     |
    |                       |             | than this.                         |
    +-----------------------+-------------+------------------------------------+
    | print_header          | OT_BOOL     | Print the header with problem      |
    |                       |             | statistics                         |
    +-----------------------+-------------+------------------------------------+
    | print_iteration       | OT_BOOL     | Print the iterations               |
    +-----------------------+-------------+------------------------------------+
    | print_status          | OT_BOOL     | Print a status message after       |
    |                       |             | solving                            |
    +-----------------------+-------------+------------------------------------+
    | qpsol                 | OT_STRING   | The QP solver to be used by the    |
    |                       |             | SQP method [qpoases]               |
    +-----------------------+-------------+------------------------------------+
    | qpsol_options         | OT_DICT     | Options to be passed to the QP     |
    |                       |             | solver                             |
    +-----------------------+-------------+------------------------------------+
    | tol_du                | OT_DOUBLE   | Stopping criterion for dual        |
    |                       |             | infeasability                      |
    +-----------------------+-------------+------------------------------------+
    | tol_pr                | OT_DOUBLE   | Stopping criterion for primal      |
    |                       |             | infeasibility                      |
    +-----------------------+-------------+------------------------------------+

    --------------------------------------------------------------------------------



    Joel Andersson



    .............



    """
    return _casadi.nlpsol(*args)

def nlpsol_in(*args):
    """
      Get NLP solver input scheme name by index.

      nlpsol_in() -> [str]
      nlpsol_in(int ind) -> str


    >Input scheme: casadi::NlpsolInput (NLPSOL_NUM_IN = 8)

    +---------------+--------+-------------------------------------------------+
    |   Full name   | Short  |                   Description                   |
    +===============+========+=================================================+
    | NLPSOL_X0     | x0     | Decision variables, initial guess (nx x 1)      |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_P      | p      | Value of fixed parameters (np x 1)              |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_LBX    | lbx    | Decision variables lower bound (nx x 1),        |
    |               |        | default -inf.                                   |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_UBX    | ubx    | Decision variables upper bound (nx x 1),        |
    |               |        | default +inf.                                   |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_LBG    | lbg    | Constraints lower bound (ng x 1), default -inf. |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_UBG    | ubg    | Constraints upper bound (ng x 1), default +inf. |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_LAM_X0 | lam_x0 | Lagrange multipliers for bounds on X, initial   |
    |               |        | guess (nx x 1)                                  |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_LAM_G0 | lam_g0 | Lagrange multipliers for bounds on G, initial   |
    |               |        | guess (ng x 1)                                  |
    +---------------+--------+-------------------------------------------------+



    .......

    ::

      nlpsol_in(int ind)



    Get NLP solver input scheme name by index.

    >Input scheme: casadi::NlpsolInput (NLPSOL_NUM_IN = 8)

    +---------------+--------+-------------------------------------------------+
    |   Full name   | Short  |                   Description                   |
    +===============+========+=================================================+
    | NLPSOL_X0     | x0     | Decision variables, initial guess (nx x 1)      |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_P      | p      | Value of fixed parameters (np x 1)              |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_LBX    | lbx    | Decision variables lower bound (nx x 1),        |
    |               |        | default -inf.                                   |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_UBX    | ubx    | Decision variables upper bound (nx x 1),        |
    |               |        | default +inf.                                   |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_LBG    | lbg    | Constraints lower bound (ng x 1), default -inf. |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_UBG    | ubg    | Constraints upper bound (ng x 1), default +inf. |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_LAM_X0 | lam_x0 | Lagrange multipliers for bounds on X, initial   |
    |               |        | guess (nx x 1)                                  |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_LAM_G0 | lam_g0 | Lagrange multipliers for bounds on G, initial   |
    |               |        | guess (ng x 1)                                  |
    +---------------+--------+-------------------------------------------------+



    .............


    .......

    ::

      nlpsol_in()



    Get input scheme of NLP solvers.

    >Input scheme: casadi::NlpsolInput (NLPSOL_NUM_IN = 8)

    +---------------+--------+-------------------------------------------------+
    |   Full name   | Short  |                   Description                   |
    +===============+========+=================================================+
    | NLPSOL_X0     | x0     | Decision variables, initial guess (nx x 1)      |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_P      | p      | Value of fixed parameters (np x 1)              |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_LBX    | lbx    | Decision variables lower bound (nx x 1),        |
    |               |        | default -inf.                                   |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_UBX    | ubx    | Decision variables upper bound (nx x 1),        |
    |               |        | default +inf.                                   |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_LBG    | lbg    | Constraints lower bound (ng x 1), default -inf. |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_UBG    | ubg    | Constraints upper bound (ng x 1), default +inf. |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_LAM_X0 | lam_x0 | Lagrange multipliers for bounds on X, initial   |
    |               |        | guess (nx x 1)                                  |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_LAM_G0 | lam_g0 | Lagrange multipliers for bounds on G, initial   |
    |               |        | guess (ng x 1)                                  |
    +---------------+--------+-------------------------------------------------+



    .............



    """
    return _casadi.nlpsol_in(*args)

def nlpsol_out(*args):
    """
      Get output scheme name by index.

      nlpsol_out() -> [str]
      nlpsol_out(int ind) -> str


    >Output scheme: casadi::NlpsolOutput (NLPSOL_NUM_OUT = 6)

    +--------------+-------+---------------------------------------------------+
    |  Full name   | Short |                    Description                    |
    +==============+=======+===================================================+
    | NLPSOL_X     | x     | Decision variables at the optimal solution (nx x  |
    |              |       | 1)                                                |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_F     | f     | Cost function value at the optimal solution (1 x  |
    |              |       | 1)                                                |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_G     | g     | Constraints function at the optimal solution (ng  |
    |              |       | x 1)                                              |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_LAM_X | lam_x | Lagrange multipliers for bounds on X at the       |
    |              |       | solution (nx x 1)                                 |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_LAM_G | lam_g | Lagrange multipliers for bounds on G at the       |
    |              |       | solution (ng x 1)                                 |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_LAM_P | lam_p | Lagrange multipliers for bounds on P at the       |
    |              |       | solution (np x 1)                                 |
    +--------------+-------+---------------------------------------------------+



    .......

    ::

      nlpsol_out(int ind)



    Get output scheme name by index.

    >Output scheme: casadi::NlpsolOutput (NLPSOL_NUM_OUT = 6)

    +--------------+-------+---------------------------------------------------+
    |  Full name   | Short |                    Description                    |
    +==============+=======+===================================================+
    | NLPSOL_X     | x     | Decision variables at the optimal solution (nx x  |
    |              |       | 1)                                                |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_F     | f     | Cost function value at the optimal solution (1 x  |
    |              |       | 1)                                                |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_G     | g     | Constraints function at the optimal solution (ng  |
    |              |       | x 1)                                              |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_LAM_X | lam_x | Lagrange multipliers for bounds on X at the       |
    |              |       | solution (nx x 1)                                 |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_LAM_G | lam_g | Lagrange multipliers for bounds on G at the       |
    |              |       | solution (ng x 1)                                 |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_LAM_P | lam_p | Lagrange multipliers for bounds on P at the       |
    |              |       | solution (np x 1)                                 |
    +--------------+-------+---------------------------------------------------+



    .............


    .......

    ::

      nlpsol_out()



    Get NLP solver output scheme of NLP solvers.

    >Output scheme: casadi::NlpsolOutput (NLPSOL_NUM_OUT = 6)

    +--------------+-------+---------------------------------------------------+
    |  Full name   | Short |                    Description                    |
    +==============+=======+===================================================+
    | NLPSOL_X     | x     | Decision variables at the optimal solution (nx x  |
    |              |       | 1)                                                |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_F     | f     | Cost function value at the optimal solution (1 x  |
    |              |       | 1)                                                |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_G     | g     | Constraints function at the optimal solution (ng  |
    |              |       | x 1)                                              |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_LAM_X | lam_x | Lagrange multipliers for bounds on X at the       |
    |              |       | solution (nx x 1)                                 |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_LAM_G | lam_g | Lagrange multipliers for bounds on G at the       |
    |              |       | solution (ng x 1)                                 |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_LAM_P | lam_p | Lagrange multipliers for bounds on P at the       |
    |              |       | solution (np x 1)                                 |
    +--------------+-------+---------------------------------------------------+



    .............



    """
    return _casadi.nlpsol_out(*args)

def nlpsol_n_in(*args):
    """
    Number of NLP solver inputs.

    nlpsol_n_in() -> int





    """
    return _casadi.nlpsol_n_in(*args)

def nlpsol_n_out(*args):
    """
    Number of NLP solver outputs.

    nlpsol_n_out() -> int





    """
    return _casadi.nlpsol_n_out(*args)

def nlpsol_default_in(*args):
    """
    Default input for an NLP solver.

    nlpsol_default_in() -> [float]
    nlpsol_default_in(int ind) -> float





    """
    return _casadi.nlpsol_default_in(*args)

def nlpsol_options(*args):
    """
    Get all options for a plugin.

    nlpsol_options(str name) -> [str]





    """
    return _casadi.nlpsol_options(*args)

def nlpsol_option_type(*args):
    """
    Get type info for a particular option.

    nlpsol_option_type(str name, str op) -> str





    """
    return _casadi.nlpsol_option_type(*args)

def nlpsol_option_info(*args):
    """
    Get documentation for a particular option.

    nlpsol_option_info(str name, str op) -> str





    """
    return _casadi.nlpsol_option_info(*args)

def has_nlpsol(*args):
    """
    Check if a particular plugin is available.

    has_nlpsol(str name) -> bool





    """
    return _casadi.has_nlpsol(*args)

def load_nlpsol(*args):
    """
    Explicitly load a plugin dynamically.

    load_nlpsol(str name)





    """
    return _casadi.load_nlpsol(*args)

def doc_nlpsol(*args):
    """
    Get the documentation string for a plugin.

    doc_nlpsol(str name) -> str





    """
    return _casadi.doc_nlpsol(*args)

def rootfinder(*args):
    """


      rootfinder(str name, str solver, dict:SX rfp, dict opts) -> Function
      rootfinder(str name, str solver, dict:MX rfp, dict opts) -> Function
      rootfinder(str name, str solver, Function f, dict opts) -> Function


    .......

    ::

      rootfinder(str name, str solver, dict:SX rfp, dict opts)



    Create a solver for rootfinding problems Takes a function where one of the
    inputs is unknown and one of the outputs is a residual function that is
    always zero, defines a new function where the the unknown input has been
    replaced by a guess for the unknown and the residual output has been
    replaced by the calculated value for the input.

    For a function [y0, y1, ...,yi, .., yn] = F(x0, x1, ..., xj, ..., xm), where
    xj is unknown and yi=0, defines a new function [y0, y1, ...,xj, .., yn] =
    G(x0, x1, ..., xj_guess, ..., xm),

    xj and yi must have the same dimension and d(yi)/d(xj) must be invertable.

    By default, the first input is unknown and the first output is the residual.

    General information
    ===================



    >List of available options

    +------------------+-----------------+------------------+------------------+
    |        Id        |      Type       |   Description    |     Used in      |
    +==================+=================+==================+==================+
    | common_options   | OT_DICT         | Options for      | casadi::OracleFu |
    |                  |                 | auto-generated   | nction           |
    |                  |                 | functions        |                  |
    +------------------+-----------------+------------------+------------------+
    | constraints      | OT_INTVECTOR    | Constrain the    | casadi::Rootfind |
    |                  |                 | unknowns. 0      | er               |
    |                  |                 | (default): no    |                  |
    |                  |                 | constraint on    |                  |
    |                  |                 | ui, 1: ui >=     |                  |
    |                  |                 | 0.0, -1: ui <=   |                  |
    |                  |                 | 0.0, 2: ui >     |                  |
    |                  |                 | 0.0, -2: ui <    |                  |
    |                  |                 | 0.0.             |                  |
    +------------------+-----------------+------------------+------------------+
    | error_on_fail    | OT_BOOL         | When the         | casadi::Rootfind |
    |                  |                 | numerical        | er               |
    |                  |                 | process returns  |                  |
    |                  |                 | unsuccessfully,  |                  |
    |                  |                 | raise an error   |                  |
    |                  |                 | (default false). |                  |
    +------------------+-----------------+------------------+------------------+
    | expand           | OT_BOOL         | Replace MX with  | casadi::OracleFu |
    |                  |                 | SX expressions   | nction           |
    |                  |                 | in problem       |                  |
    |                  |                 | formulation      |                  |
    |                  |                 | [false]          |                  |
    +------------------+-----------------+------------------+------------------+
    | implicit_input   | OT_INT          | Index of the     | casadi::Rootfind |
    |                  |                 | input that       | er               |
    |                  |                 | corresponds to   |                  |
    |                  |                 | the actual root- |                  |
    |                  |                 | finding          |                  |
    +------------------+-----------------+------------------+------------------+
    | implicit_output  | OT_INT          | Index of the     | casadi::Rootfind |
    |                  |                 | output that      | er               |
    |                  |                 | corresponds to   |                  |
    |                  |                 | the actual root- |                  |
    |                  |                 | finding          |                  |
    +------------------+-----------------+------------------+------------------+
    | jacobian_functio | OT_FUNCTION     | Function object  | casadi::Rootfind |
    | n                |                 | for calculating  | er               |
    |                  |                 | the Jacobian     |                  |
    |                  |                 | (autogenerated   |                  |
    |                  |                 | by default)      |                  |
    +------------------+-----------------+------------------+------------------+
    | linear_solver    | OT_STRING       | User-defined     | casadi::Rootfind |
    |                  |                 | linear solver    | er               |
    |                  |                 | class. Needed    |                  |
    |                  |                 | for              |                  |
    |                  |                 | sensitivities.   |                  |
    +------------------+-----------------+------------------+------------------+
    | linear_solver_op | OT_DICT         | Options to be    | casadi::Rootfind |
    | tions            |                 | passed to the    | er               |
    |                  |                 | linear solver.   |                  |
    +------------------+-----------------+------------------+------------------+
    | monitor          | OT_STRINGVECTOR | Set of user      | casadi::OracleFu |
    |                  |                 | problem          | nction           |
    |                  |                 | functions to be  |                  |
    |                  |                 | monitored        |                  |
    +------------------+-----------------+------------------+------------------+
    | show_eval_warnin | OT_BOOL         | Show warnings    | casadi::OracleFu |
    | gs               |                 | generated from   | nction           |
    |                  |                 | function         |                  |
    |                  |                 | evaluations      |                  |
    |                  |                 | [true]           |                  |
    +------------------+-----------------+------------------+------------------+
    | specific_options | OT_DICT         | Options for      | casadi::OracleFu |
    |                  |                 | specific auto-   | nction           |
    |                  |                 | generated        |                  |
    |                  |                 | functions,       |                  |
    |                  |                 | overwriting the  |                  |
    |                  |                 | defaults from    |                  |
    |                  |                 | common_options.  |                  |
    |                  |                 | Nested           |                  |
    |                  |                 | dictionary.      |                  |
    +------------------+-----------------+------------------+------------------+

    >Input scheme: casadi::RootfinderInput (ROOTFINDER_NUM_IN = 2)

    +---------------+-------+---------------------------------+
    |   Full name   | Short |           Description           |
    +===============+=======+=================================+
    | ROOTFINDER_X0 | x0    | Initial guess for the solution. |
    +---------------+-------+---------------------------------+
    | ROOTFINDER_P  | p     | Parameters.                     |
    +---------------+-------+---------------------------------+

    >Output scheme: casadi::RootfinderOutput (ROOTFINDER_NUM_OUT = 1)

    +--------------+-------+--------------------------------------+
    |  Full name   | Short |             Description              |
    +==============+=======+======================================+
    | ROOTFINDER_X | x     | Solution to the system of equations. |
    +--------------+-------+--------------------------------------+

    List of plugins
    ===============



    - kinsol

    - fast_newton

    - nlpsol

    - newton

    Note: some of the plugins in this list might not be available on your
    system. Also, there might be extra plugins available to you that are not
    listed here. You can obtain their documentation with
    Rootfinder.doc("myextraplugin")



    --------------------------------------------------------------------------------

    kinsol
    ------



    KINSOL interface from the Sundials suite

    >List of available options

    +---------------------------+-----------------+----------------------------+
    |            Id             |      Type       |        Description         |
    +===========================+=================+============================+
    | abstol                    | OT_DOUBLE       | Stopping criterion         |
    |                           |                 | tolerance                  |
    +---------------------------+-----------------+----------------------------+
    | disable_internal_warnings | OT_BOOL         | Disable KINSOL internal    |
    |                           |                 | warning messages           |
    +---------------------------+-----------------+----------------------------+
    | exact_jacobian            | OT_BOOL         | Use exact Jacobian         |
    |                           |                 | information                |
    +---------------------------+-----------------+----------------------------+
    | f_scale                   | OT_DOUBLEVECTOR | Equation scaling factors   |
    +---------------------------+-----------------+----------------------------+
    | iterative_solver          | OT_STRING       | gmres|bcgstab|tfqmr        |
    +---------------------------+-----------------+----------------------------+
    | linear_solver_type        | OT_STRING       | dense|banded|iterative|use |
    |                           |                 | r_defined                  |
    +---------------------------+-----------------+----------------------------+
    | lower_bandwidth           | OT_INT          | Lower bandwidth for banded |
    |                           |                 | linear solvers             |
    +---------------------------+-----------------+----------------------------+
    | max_iter                  | OT_INT          | Maximum number of Newton   |
    |                           |                 | iterations. Putting 0 sets |
    |                           |                 | the default value of       |
    |                           |                 | KinSol.                    |
    +---------------------------+-----------------+----------------------------+
    | max_krylov                | OT_INT          | Maximum Krylov space       |
    |                           |                 | dimension                  |
    +---------------------------+-----------------+----------------------------+
    | pretype                   | OT_STRING       | Type of preconditioner     |
    +---------------------------+-----------------+----------------------------+
    | strategy                  | OT_STRING       | Globalization strategy     |
    +---------------------------+-----------------+----------------------------+
    | u_scale                   | OT_DOUBLEVECTOR | Variable scaling factors   |
    +---------------------------+-----------------+----------------------------+
    | upper_bandwidth           | OT_INT          | Upper bandwidth for banded |
    |                           |                 | linear solvers             |
    +---------------------------+-----------------+----------------------------+
    | use_preconditioner        | OT_BOOL         | Precondition an iterative  |
    |                           |                 | solver                     |
    +---------------------------+-----------------+----------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    fast_newton
    -----------



    Implements simple newton iterations to solve an implicit function.

    >List of available options

    +------------+-----------+-------------------------------------------------+
    |     Id     |   Type    |                   Description                   |
    +============+===========+=================================================+
    | abstol     | OT_DOUBLE | Stopping criterion tolerance on ||g||__inf)     |
    +------------+-----------+-------------------------------------------------+
    | abstolStep | OT_DOUBLE | Stopping criterion tolerance on step size       |
    +------------+-----------+-------------------------------------------------+
    | max_iter   | OT_INT    | Maximum number of Newton iterations to perform  |
    |            |           | before returning.                               |
    +------------+-----------+-------------------------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    nlpsol
    ------





    --------------------------------------------------------------------------------





    --------------------------------------------------------------------------------

    newton
    ------



    Implements simple newton iterations to solve an implicit function.

    >List of available options

    +-----------------+-----------+--------------------------------------------+
    |       Id        |   Type    |                Description                 |
    +=================+===========+============================================+
    | abstol          | OT_DOUBLE | Stopping criterion tolerance on max(|F|)   |
    +-----------------+-----------+--------------------------------------------+
    | abstolStep      | OT_DOUBLE | Stopping criterion tolerance on step size  |
    +-----------------+-----------+--------------------------------------------+
    | line_search     | OT_BOOL   | Enable line-search (default: true)         |
    +-----------------+-----------+--------------------------------------------+
    | max_iter        | OT_INT    | Maximum number of Newton iterations to     |
    |                 |           | perform before returning.                  |
    +-----------------+-----------+--------------------------------------------+
    | print_iteration | OT_BOOL   | Print information about each iteration     |
    +-----------------+-----------+--------------------------------------------+

    --------------------------------------------------------------------------------



    Joel Andersson



    .............


    .......

    ::

      rootfinder(str name, str solver, dict:MX rfp, dict opts)
      rootfinder(str name, str solver, Function f, dict opts)



    .............



    """
    return _casadi.rootfinder(*args)

def rootfinder_in(*args):
    """
      Get rootfinder input scheme name by index.

      rootfinder_in() -> [str]
      rootfinder_in(int ind) -> str




    .......

    ::

      rootfinder_in(int ind)



    Get rootfinder input scheme name by index.



    .............


    .......

    ::

      rootfinder_in()



    Get rootfinder input scheme.



    .............



    """
    return _casadi.rootfinder_in(*args)

def rootfinder_out(*args):
    """
      Get rootfinder output scheme name by index.

      rootfinder_out() -> [str]
      rootfinder_out(int ind) -> str




    .......

    ::

      rootfinder_out(int ind)



    Get rootfinder output scheme name by index.



    .............


    .......

    ::

      rootfinder_out()



    Get rootfinder output scheme.



    .............



    """
    return _casadi.rootfinder_out(*args)

def rootfinder_n_in(*args):
    """
    Number of rootfinder inputs.

    rootfinder_n_in() -> int





    """
    return _casadi.rootfinder_n_in(*args)

def rootfinder_n_out(*args):
    """
    Number of rootfinder outputs.

    rootfinder_n_out() -> int





    """
    return _casadi.rootfinder_n_out(*args)

def rootfinder_options(*args):
    """
    Get all options for a plugin.

    rootfinder_options(str name) -> [str]





    """
    return _casadi.rootfinder_options(*args)

def rootfinder_option_type(*args):
    """
    Get type info for a particular option.

    rootfinder_option_type(str name, str op) -> str





    """
    return _casadi.rootfinder_option_type(*args)

def rootfinder_option_info(*args):
    """
    Get documentation for a particular option.

    rootfinder_option_info(str name, str op) -> str





    """
    return _casadi.rootfinder_option_info(*args)

def has_rootfinder(*args):
    """
    Check if a particular plugin is available.

    has_rootfinder(str name) -> bool





    """
    return _casadi.has_rootfinder(*args)

def load_rootfinder(*args):
    """
    Explicitly load a plugin dynamically.

    load_rootfinder(str name)





    """
    return _casadi.load_rootfinder(*args)

def doc_rootfinder(*args):
    """
    Get the documentation string for a plugin.

    doc_rootfinder(str name) -> str





    """
    return _casadi.doc_rootfinder(*args)
class Linsol(SharedObject, PrintableCommon):
    """
      Linear solver Create a solver for linear systems of equations Solves the


    linear system A*X = B or A^T*X = B for X with A square and non- singular.

    If A is structurally singular, an error will be thrown during init. If A is
    numerically singular, the prepare step will fail.

    General information
    ===================



    List of plugins
    ===============



    - csparsecholesky

    - csparse

    - ma27

    - lapacklu

    - lapackqr

    - mumps

    - ldl

    - qr

    - tridiag

    - symbolicqr

    Note: some of the plugins in this list might not be available on your
    system. Also, there might be extra plugins available to you that are not
    listed here. You can obtain their documentation with
    Linsol.doc("myextraplugin")



    --------------------------------------------------------------------------------

    csparsecholesky
    ---------------



    Linsol with CSparseCholesky Interface

    --------------------------------------------------------------------------------





    --------------------------------------------------------------------------------

    csparse
    -------



    Linsol with CSparse Interface

    --------------------------------------------------------------------------------





    --------------------------------------------------------------------------------

    ma27
    ----



    Interface to the sparse direct linear solver MA27 Works for symmetric
    indefinite systems Partly adopted from qpOASES 3.2 Joel Andersson

    --------------------------------------------------------------------------------

    lapacklu
    --------



    This class solves the linear system A.x=b by making an LU factorization of
    A: A = L.U, with L lower and U upper triangular

    >List of available options

    +-----------------------------+---------+----------------------------------+
    |             Id              |  Type   |           Description            |
    +=============================+=========+==================================+
    | allow_equilibration_failure | OT_BOOL | Non-fatal error when             |
    |                             |         | equilibration fails              |
    +-----------------------------+---------+----------------------------------+
    | equilibration               | OT_BOOL | Equilibrate the matrix           |
    +-----------------------------+---------+----------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    lapackqr
    --------



    This class solves the linear system A.x=b by making an QR factorization of
    A: A = Q.R, with Q orthogonal and R upper triangular

    >List of available options

    +----------+--------+------------------------------------------------------+
    |    Id    |  Type  |                     Description                      |
    +==========+========+======================================================+
    | max_nrhs | OT_INT | Maximum number of right-hand-sides that get          |
    |          |        | processed in a single pass [default:10].             |
    +----------+--------+------------------------------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    mumps
    -----



    Interface to the sparse direct linear solver MUMPS Works for symmetric
    indefinite systems Joel Andersson

    >List of available options

    +-----------+---------+-------------------+
    |    Id     |  Type   |    Description    |
    +===========+=========+===================+
    | posdef    | OT_BOOL | Positive definite |
    +-----------+---------+-------------------+
    | symmetric | OT_BOOL | Symmetric matrix  |
    +-----------+---------+-------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    ldl
    ---



    Linear solver using sparse direct LDL factorization

    --------------------------------------------------------------------------------





    --------------------------------------------------------------------------------

    qr --



    Linear solver using sparse direct QR factorization

    --------------------------------------------------------------------------------





    --------------------------------------------------------------------------------

    tridiag
    -------



    Linear solver for tridiagonal matrices

    --------------------------------------------------------------------------------





    --------------------------------------------------------------------------------

    symbolicqr
    ----------



    Linear solver for sparse least-squares problems Inspired
    fromhttps://github.com/scipy/scipy/blob/v0.14.0/scipy/sparse/linalg/isolve/lsqr.py#L96

    Linsol based on QR factorization with sparsity pattern based reordering
    without partial pivoting

    >List of available options

    +-------+---------+----------------------------------------------------+
    |  Id   |  Type   |                    Description                     |
    +=======+=========+====================================================+
    | fopts | OT_DICT | Options to be passed to generated function objects |
    +-------+---------+----------------------------------------------------+

    --------------------------------------------------------------------------------



    Joel Andersson

    C++ includes: linsol.hpp 


    """

    __swig_setmethods__ = {}
    for _s in [SharedObject, PrintableCommon]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Linsol, name, value)
    __swig_getmethods__ = {}
    for _s in [SharedObject, PrintableCommon]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Linsol, name)
    __repr__ = _swig_repr

    def type_name(*args):
        """


        type_name() -> str



        """
        return _casadi.Linsol_type_name(*args)

    type_name = staticmethod(type_name)

    def has_plugin(*args):
        """


        has_plugin(str name) -> bool



        """
        return _casadi.Linsol_has_plugin(*args)

    has_plugin = staticmethod(has_plugin)

    def load_plugin(*args):
        """


        load_plugin(str name)



        """
        return _casadi.Linsol_load_plugin(*args)

    load_plugin = staticmethod(load_plugin)

    def doc(*args):
        """


        doc(str name) -> str



        """
        return _casadi.Linsol_doc(*args)

    doc = staticmethod(doc)

    def plugin_name(self, *args):
        """
        Query plugin name.

        plugin_name(self) -> str





        """
        return _casadi.Linsol_plugin_name(self, *args)


    def sparsity(self, *args):
        """
        Get linear system sparsity.

        sparsity(self) -> Sparsity





        """
        return _casadi.Linsol_sparsity(self, *args)


    def sfact(self, *args):
        """
        Symbolic factorization of the linear system, e.g. selecting pivots.

        sfact(self, DM A)





        """
        return _casadi.Linsol_sfact(self, *args)


    def nfact(self, *args):
        """
        Numeric factorization of the linear system.

        nfact(self, DM A)





        """
        return _casadi.Linsol_nfact(self, *args)


    def solve(self, *args):
        """
        Solve linear system of equations

        solve(self, DM A, DM B, bool tr) -> DM
        solve(self, MX A, MX B, bool tr) -> MX





        """
        return _casadi.Linsol_solve(self, *args)


    def neig(self, *args):
        """
        Number of negative eigenvalues Not available for all solvers.

        neig(self, DM A) -> int





        """
        return _casadi.Linsol_neig(self, *args)


    def rank(self, *args):
        """
        Matrix rank Not available for all solvers.

        rank(self, DM A) -> int





        """
        return _casadi.Linsol_rank(self, *args)


    def stats(self, *args):
        """
        Get all statistics obtained at the end of the last evaluate call.

        stats(self, int mem) -> dict





        """
        return _casadi.Linsol_stats(self, *args)


    def __init__(self, *args):
        """


          Linsol()
          Linsol(Linsol other)
          Linsol(str name, str solver, Sparsity sp, dict opts)


        .......

        ::

          Linsol(Linsol other)



        .............


        .......

        ::

          Linsol()



        Default constructor.



        .............


        .......

        ::

          Linsol(str name, str solver, Sparsity sp, dict opts)



        Constructor.



        .............



        """
        this = _casadi.new_Linsol(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_Linsol
Linsol_swigregister = _casadi.Linsol_swigregister
Linsol_swigregister(Linsol)

def Linsol_type_name(*args):
    """


    type_name() -> str



    """
    return _casadi.Linsol_type_name(*args)

def Linsol_has_plugin(*args):
    """


    has_plugin(str name) -> bool



    """
    return _casadi.Linsol_has_plugin(*args)

def Linsol_load_plugin(*args):
    """


    load_plugin(str name)



    """
    return _casadi.Linsol_load_plugin(*args)

def Linsol_doc(*args):
    """


    doc(str name) -> str



    """
    return _casadi.Linsol_doc(*args)


def has_linsol(*args):
    """
    Check if a particular plugin is available.

    has_linsol(str name) -> bool





    """
    return _casadi.has_linsol(*args)

def load_linsol(*args):
    """
    Explicitly load a plugin dynamically.

    load_linsol(str name)





    """
    return _casadi.load_linsol(*args)

def doc_linsol(*args):
    """
    Get the documentation string for a plugin.

    doc_linsol(str name) -> str





    """
    return _casadi.doc_linsol(*args)

def dplesol(*args):
    """


      dplesol([DM] A, [DM] V, str solver, dict opts) -> [DM]
      dplesol(MX A, MX V, str solver, dict opts) -> MX
      dplesol([MX] A, [MX] V, str solver, dict opts) -> [MX]
      dplesol(str name, str solver, dict:Sparsity st, dict opts) -> Function


    .......

    ::

      dplesol([DM] A, [DM] V, str solver, dict opts)
      dplesol(MX A, MX V, str solver, dict opts)
      dplesol([MX] A, [MX] V, str solver, dict opts)



    .............


    .......

    ::

      dplesol(str name, str solver, dict:Sparsity st, dict opts)



    Discrete periodic Lyapunov Equation solver Given matrices $A_k$ and
    symmetric $V_k, k = 0..K-1$

    ::

      A_k in R^(n x n)
      V_k in R^n


    provides all of $P_k$ that satisfy:

    ::

      P_0 = A_(K-1)*P_(K-1)*A_(K-1)' + V_k
      P_k+1 = A_k*P_k*A_k' + V_k  for k = 1..K-1




    General information
    ===================



    >List of available options

    +------------------+-----------------+------------------+------------------+
    |        Id        |      Type       |   Description    |     Used in      |
    +==================+=================+==================+==================+
    | ad_weight        | OT_DOUBLE       | Weighting factor | casadi::Function |
    |                  |                 | for derivative   | Internal         |
    |                  |                 | calculation.When |                  |
    |                  |                 | there is an      |                  |
    |                  |                 | option of either |                  |
    |                  |                 | using forward or |                  |
    |                  |                 | reverse mode     |                  |
    |                  |                 | directional      |                  |
    |                  |                 | derivatives, the |                  |
    |                  |                 | condition ad_wei |                  |
    |                  |                 | ght*nf<=(1-ad_we |                  |
    |                  |                 | ight)*na is used |                  |
    |                  |                 | where nf and na  |                  |
    |                  |                 | are estimates of |                  |
    |                  |                 | the number of    |                  |
    |                  |                 | forward/reverse  |                  |
    |                  |                 | mode directional |                  |
    |                  |                 | derivatives      |                  |
    |                  |                 | needed. By       |                  |
    |                  |                 | default,         |                  |
    |                  |                 | ad_weight is     |                  |
    |                  |                 | calculated       |                  |
    |                  |                 | automatically,   |                  |
    |                  |                 | but this can be  |                  |
    |                  |                 | overridden by    |                  |
    |                  |                 | setting this     |                  |
    |                  |                 | option. In       |                  |
    |                  |                 | particular, 0    |                  |
    |                  |                 | means forcing    |                  |
    |                  |                 | forward mode and |                  |
    |                  |                 | 1 forcing        |                  |
    |                  |                 | reverse mode.    |                  |
    |                  |                 | Leave unset for  |                  |
    |                  |                 | (class specific) |                  |
    |                  |                 | heuristics.      |                  |
    +------------------+-----------------+------------------+------------------+
    | ad_weight_sp     | OT_DOUBLE       | Weighting factor | casadi::Function |
    |                  |                 | for sparsity     | Internal         |
    |                  |                 | pattern          |                  |
    |                  |                 | calculation calc |                  |
    |                  |                 | ulation.Override |                  |
    |                  |                 | s default        |                  |
    |                  |                 | behavior. Set to |                  |
    |                  |                 | 0 and 1 to force |                  |
    |                  |                 | forward and      |                  |
    |                  |                 | reverse mode     |                  |
    |                  |                 | respectively.    |                  |
    |                  |                 | Cf. option       |                  |
    |                  |                 | "ad_weight".     |                  |
    |                  |                 | When set to -1,  |                  |
    |                  |                 | sparsity is      |                  |
    |                  |                 | completely       |                  |
    |                  |                 | ignored and      |                  |
    |                  |                 | dense matrices   |                  |
    |                  |                 | are used.        |                  |
    +------------------+-----------------+------------------+------------------+
    | always_inline    | OT_BOOL         | Force inlining.  | casadi::Function |
    |                  |                 |                  | Internal         |
    +------------------+-----------------+------------------+------------------+
    | compiler         | OT_STRING       | Just-in-time     | casadi::Function |
    |                  |                 | compiler plugin  | Internal         |
    |                  |                 | to be used.      |                  |
    +------------------+-----------------+------------------+------------------+
    | const_dim        | OT_BOOL         | Assume constant  | casadi::Dple     |
    |                  |                 | dimension of P   |                  |
    +------------------+-----------------+------------------+------------------+
    | custom_jacobian  | OT_FUNCTION     | Override         | casadi::Function |
    |                  |                 | CasADi's AD. Use | Internal         |
    |                  |                 | together with    |                  |
    |                  |                 | 'jac_penalty':   |                  |
    |                  |                 | 0. Note: Highly  |                  |
    |                  |                 | experimental.    |                  |
    |                  |                 | Syntax may break |                  |
    |                  |                 | often.           |                  |
    +------------------+-----------------+------------------+------------------+
    | derivative_of    | OT_FUNCTION     | The function is  | casadi::Function |
    |                  |                 | a derivative of  | Internal         |
    |                  |                 | another          |                  |
    |                  |                 | function. The    |                  |
    |                  |                 | type of          |                  |
    |                  |                 | derivative       |                  |
    |                  |                 | (directional     |                  |
    |                  |                 | derivative,      |                  |
    |                  |                 | Jacobian) is     |                  |
    |                  |                 | inferred from    |                  |
    |                  |                 | the function     |                  |
    |                  |                 | name.            |                  |
    +------------------+-----------------+------------------+------------------+
    | dump             | OT_BOOL         | Dump function to | casadi::Function |
    |                  |                 | file upon first  | Internal         |
    |                  |                 | evaluation.      |                  |
    |                  |                 | [false]          |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_dir         | OT_STRING       | Directory to     | casadi::Function |
    |                  |                 | dump             | Internal         |
    |                  |                 | inputs/outputs   |                  |
    |                  |                 | to. Make sure    |                  |
    |                  |                 | the directory    |                  |
    |                  |                 | exists [.]       |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_format      | OT_STRING       | Choose file      | casadi::Function |
    |                  |                 | format to dump   | Internal         |
    |                  |                 | matrices. See    |                  |
    |                  |                 | DM.from_file     |                  |
    |                  |                 | [mtx]            |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_in          | OT_BOOL         | Dump numerical   | casadi::Function |
    |                  |                 | values of inputs | Internal         |
    |                  |                 | to file          |                  |
    |                  |                 | (readable with   |                  |
    |                  |                 | DM.from_file )   |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_out         | OT_BOOL         | Dump numerical   | casadi::Function |
    |                  |                 | values of        | Internal         |
    |                  |                 | outputs to file  |                  |
    |                  |                 | (readable with   |                  |
    |                  |                 | DM.from_file )   |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_fd        | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation by   |                  |
    |                  |                 | finite           |                  |
    |                  |                 | differencing.    |                  |
    |                  |                 | [default:        |                  |
    |                  |                 | false]]          |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_forward   | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | Jacobian-times-  |                  |
    |                  |                 | vector products  |                  |
    |                  |                 | - typically      |                  |
    |                  |                 | using forward    |                  |
    |                  |                 | mode AD - if     |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_jacobian  | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | Jacobians of all |                  |
    |                  |                 | differentiable   |                  |
    |                  |                 | outputs with     |                  |
    |                  |                 | respect to all   |                  |
    |                  |                 | differentiable   |                  |
    |                  |                 | inputs - if      |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_reverse   | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | transposed       |                  |
    |                  |                 | Jacobian-times-  |                  |
    |                  |                 | vector products  |                  |
    |                  |                 | - typically      |                  |
    |                  |                 | using reverse    |                  |
    |                  |                 | mode AD - if     |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | eps_unstable     | OT_DOUBLE       | A margin for     | casadi::Dple     |
    |                  |                 | unstability      |                  |
    |                  |                 | detection        |                  |
    +------------------+-----------------+------------------+------------------+
    | error_unstable   | OT_BOOL         | Throw an         | casadi::Dple     |
    |                  |                 | exception when   |                  |
    |                  |                 | it is detected   |                  |
    |                  |                 | that             |                  |
    |                  |                 | Product(A_i,     |                  |
    |                  |                 | i=N..1)has       |                  |
    |                  |                 | eigenvalues      |                  |
    |                  |                 | greater than     |                  |
    |                  |                 | 1-eps_unstable   |                  |
    +------------------+-----------------+------------------+------------------+
    | fd_method        | OT_STRING       | Method for       | casadi::Function |
    |                  |                 | finite           | Internal         |
    |                  |                 | differencing     |                  |
    |                  |                 | [default         |                  |
    |                  |                 | 'central']       |                  |
    +------------------+-----------------+------------------+------------------+
    | fd_options       | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to the    | Internal         |
    |                  |                 | finite           |                  |
    |                  |                 | difference       |                  |
    |                  |                 | instance         |                  |
    +------------------+-----------------+------------------+------------------+
    | forward_options  | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to a      | Internal         |
    |                  |                 | forward mode     |                  |
    |                  |                 | constructor      |                  |
    +------------------+-----------------+------------------+------------------+
    | gather_stats     | OT_BOOL         | Deprecated       | casadi::Function |
    |                  |                 | option           | Internal         |
    |                  |                 | (ignored):       |                  |
    |                  |                 | Statistics are   |                  |
    |                  |                 | now always       |                  |
    |                  |                 | collected.       |                  |
    +------------------+-----------------+------------------+------------------+
    | input_scheme     | OT_STRINGVECTOR | Deprecated       | casadi::Function |
    |                  |                 | option (ignored) | Internal         |
    +------------------+-----------------+------------------+------------------+
    | inputs_check     | OT_BOOL         | Throw exceptions | casadi::Function |
    |                  |                 | when the         | Internal         |
    |                  |                 | numerical values |                  |
    |                  |                 | of the inputs    |                  |
    |                  |                 | don't make sense |                  |
    +------------------+-----------------+------------------+------------------+
    | is_diff_in       | OT_BOOLVECTOR   | Indicate for     | casadi::Function |
    |                  |                 | each input if it | Internal         |
    |                  |                 | should be        |                  |
    |                  |                 | differentiable.  |                  |
    +------------------+-----------------+------------------+------------------+
    | is_diff_out      | OT_BOOLVECTOR   | Indicate for     | casadi::Function |
    |                  |                 | each output if   | Internal         |
    |                  |                 | it should be     |                  |
    |                  |                 | differentiable.  |                  |
    +------------------+-----------------+------------------+------------------+
    | jac_penalty      | OT_DOUBLE       | When requested   | casadi::Function |
    |                  |                 | for a number of  | Internal         |
    |                  |                 | forward/reverse  |                  |
    |                  |                 | directions, it   |                  |
    |                  |                 | may be cheaper   |                  |
    |                  |                 | to compute first |                  |
    |                  |                 | the full         |                  |
    |                  |                 | jacobian and     |                  |
    |                  |                 | then multiply    |                  |
    |                  |                 | with seeds,      |                  |
    |                  |                 | rather than      |                  |
    |                  |                 | obtain the       |                  |
    |                  |                 | requested        |                  |
    |                  |                 | directions in a  |                  |
    |                  |                 | straightforward  |                  |
    |                  |                 | manner. Casadi   |                  |
    |                  |                 | uses a heuristic |                  |
    |                  |                 | to decide which  |                  |
    |                  |                 | is cheaper. A    |                  |
    |                  |                 | high value of    |                  |
    |                  |                 | 'jac_penalty'    |                  |
    |                  |                 | makes it less    |                  |
    |                  |                 | likely for the   |                  |
    |                  |                 | heurstic to      |                  |
    |                  |                 | chose the full   |                  |
    |                  |                 | Jacobian         |                  |
    |                  |                 | strategy. The    |                  |
    |                  |                 | special value -1 |                  |
    |                  |                 | indicates never  |                  |
    |                  |                 | to use the full  |                  |
    |                  |                 | Jacobian         |                  |
    |                  |                 | strategy         |                  |
    +------------------+-----------------+------------------+------------------+
    | jit              | OT_BOOL         | Use just-in-time | casadi::Function |
    |                  |                 | compiler to      | Internal         |
    |                  |                 | speed up the     |                  |
    |                  |                 | evaluation       |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_cleanup      | OT_BOOL         | Cleanup up the   | casadi::Function |
    |                  |                 | temporary source | Internal         |
    |                  |                 | file that jit    |                  |
    |                  |                 | creates.         |                  |
    |                  |                 | Default: true    |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_name         | OT_STRING       | The file name    | casadi::Function |
    |                  |                 | used to write    | Internal         |
    |                  |                 | out code. The    |                  |
    |                  |                 | actual file      |                  |
    |                  |                 | names used       |                  |
    |                  |                 | depend on 'jit_t |                  |
    |                  |                 | emp_suffix' and  |                  |
    |                  |                 | include          |                  |
    |                  |                 | extensions.      |                  |
    |                  |                 | Default:         |                  |
    |                  |                 | 'jit_tmp'        |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_options      | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to the    | Internal         |
    |                  |                 | jit compiler.    |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_serialize    | OT_STRING       | Specify          | casadi::Function |
    |                  |                 | behaviour when   | Internal         |
    |                  |                 | serializing a    |                  |
    |                  |                 | jitted function: |                  |
    |                  |                 | SOURCE|link|embe |                  |
    |                  |                 | d.               |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_temp_suffix  | OT_BOOL         | Use a temporary  | casadi::Function |
    |                  |                 | (seemingly       | Internal         |
    |                  |                 | random) filename |                  |
    |                  |                 | suffix for       |                  |
    |                  |                 | generated code   |                  |
    |                  |                 | and libraries.   |                  |
    |                  |                 | This is desired  |                  |
    |                  |                 | for thread-      |                  |
    |                  |                 | safety. This     |                  |
    |                  |                 | behaviour may    |                  |
    |                  |                 | defeat caching   |                  |
    |                  |                 | compiler         |                  |
    |                  |                 | wrappers.        |                  |
    |                  |                 | Default: true    |                  |
    +------------------+-----------------+------------------+------------------+
    | max_num_dir      | OT_INT          | Specify the      | casadi::Function |
    |                  |                 | maximum number   | Internal         |
    |                  |                 | of directions    |                  |
    |                  |                 | for derivative   |                  |
    |                  |                 | functions.       |                  |
    |                  |                 | Overrules the    |                  |
    |                  |                 | builtin optimize |                  |
    |                  |                 | d_num_dir.       |                  |
    +------------------+-----------------+------------------+------------------+
    | never_inline     | OT_BOOL         | Forbid inlining. | casadi::Function |
    |                  |                 |                  | Internal         |
    +------------------+-----------------+------------------+------------------+
    | output_scheme    | OT_STRINGVECTOR | Deprecated       | casadi::Function |
    |                  |                 | option (ignored) | Internal         |
    +------------------+-----------------+------------------+------------------+
    | pos_def          | OT_BOOL         | Assume P         | casadi::Dple     |
    |                  |                 | positive         |                  |
    |                  |                 | definite         |                  |
    +------------------+-----------------+------------------+------------------+
    | print_in         | OT_BOOL         | Print numerical  | casadi::Function |
    |                  |                 | values of inputs | Internal         |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | print_out        | OT_BOOL         | Print numerical  | casadi::Function |
    |                  |                 | values of        | Internal         |
    |                  |                 | outputs          |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | print_time       | OT_BOOL         | print            | casadi::Function |
    |                  |                 | information      | Internal         |
    |                  |                 | about execution  |                  |
    |                  |                 | time. Implies    |                  |
    |                  |                 | record_time.     |                  |
    +------------------+-----------------+------------------+------------------+
    | record_time      | OT_BOOL         | record           | casadi::Function |
    |                  |                 | information      | Internal         |
    |                  |                 | about execution  |                  |
    |                  |                 | time, for        |                  |
    |                  |                 | retrieval with   |                  |
    |                  |                 | stats().         |                  |
    +------------------+-----------------+------------------+------------------+
    | regularity_check | OT_BOOL         | Throw exceptions | casadi::Function |
    |                  |                 | when NaN or Inf  | Internal         |
    |                  |                 | appears during   |                  |
    |                  |                 | evaluation       |                  |
    +------------------+-----------------+------------------+------------------+
    | reverse_options  | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to a      | Internal         |
    |                  |                 | reverse mode     |                  |
    |                  |                 | constructor      |                  |
    +------------------+-----------------+------------------+------------------+
    | user_data        | OT_VOIDPTR      | A user-defined   | casadi::Function |
    |                  |                 | field that can   | Internal         |
    |                  |                 | be used to       |                  |
    |                  |                 | identify the     |                  |
    |                  |                 | function or pass |                  |
    |                  |                 | additional       |                  |
    |                  |                 | information      |                  |
    +------------------+-----------------+------------------+------------------+
    | verbose          | OT_BOOL         | Verbose          | casadi::Function |
    |                  |                 | evaluation  for  | Internal         |
    |                  |                 | debugging        |                  |
    +------------------+-----------------+------------------+------------------+

    >Input scheme: casadi::DpleInput (DPLE_NUM_IN = 2)

    +-----------+-------+------------------------------------------------------+
    | Full name | Short |                     Description                      |
    +===========+=======+======================================================+
    | DPLE_A    | a     | A matrices (horzcat when const_dim, diagcat          |
    |           |       | otherwise) [a].                                      |
    +-----------+-------+------------------------------------------------------+
    | DPLE_V    | v     | V matrices (horzcat when const_dim, diagcat          |
    |           |       | otherwise) [v].                                      |
    +-----------+-------+------------------------------------------------------+

    >Output scheme: casadi::DpleOutput (DPLE_NUM_OUT = 1)

    +-----------+-------+------------------------------------------------------+
    | Full name | Short |                     Description                      |
    +===========+=======+======================================================+
    | DPLE_P    | p     | Lyapunov matrix (horzcat when const_dim, diagcat     |
    |           |       | otherwise) (Cholesky of P if pos_def) [p].           |
    +-----------+-------+------------------------------------------------------+

    List of plugins
    ===============



    - slicot

    Note: some of the plugins in this list might not be available on your
    system. Also, there might be extra plugins available to you that are not
    listed here. You can obtain their documentation with
    Dple.doc("myextraplugin")



    --------------------------------------------------------------------------------

    slicot
    ------



    An efficient solver for Discrete Periodic Lyapunov Equations using SLICOT

    Uses Periodic Schur Decomposition ('psd') and does not assume positive
    definiteness. Based on Periodic Lyapunov equations: some applications and
    new algorithms. Int. J. Control, vol. 67, pp. 69-87, 1997.

    Overview of the method: J. Gillis Practical Methods for Approximate Robust
    Periodic Optimal Control ofNonlinear Mechanical Systems, PhD Thesis,
    KULeuven, 2015

    >List of available options

    +-----------------------+-----------+--------------------------------------+
    |          Id           |   Type    |             Description              |
    +=======================+===========+======================================+
    | linear_solver         | OT_STRING | User-defined linear solver class.    |
    |                       |           | Needed for sensitivities.            |
    +-----------------------+-----------+--------------------------------------+
    | linear_solver_options | OT_DICT   | Options to be passed to the linear   |
    |                       |           | solver.                              |
    +-----------------------+-----------+--------------------------------------+
    | psd_num_zero          | OT_DOUBLE | Numerical zero used in Periodic      |
    |                       |           | Schur decomposition with slicot.This |
    |                       |           | option is needed when your systems   |
    |                       |           | has Floquet multiplierszero or close |
    |                       |           | to zero                              |
    +-----------------------+-----------+--------------------------------------+

    --------------------------------------------------------------------------------



    Joris Gillis



    .............



    """
    return _casadi.dplesol(*args)

def dple_in(*args):
    """
      Get DPLE input scheme name by index.

      dple_in() -> [str]
      dple_in(int ind) -> str




    .......

    ::

      dple_in()



    Get input scheme of DPLE solvers.



    .............


    .......

    ::

      dple_in(int ind)



    Get DPLE input scheme name by index.



    .............



    """
    return _casadi.dple_in(*args)

def dple_out(*args):
    """
      Get DPLE output scheme name by index.

      dple_out() -> [str]
      dple_out(int ind) -> str




    .......

    ::

      dple_out()



    Get output scheme of DPLE solvers.



    .............


    .......

    ::

      dple_out(int ind)



    Get DPLE output scheme name by index.



    .............



    """
    return _casadi.dple_out(*args)

def dple_n_in(*args):
    """
    Get the number of QP solver inputs.

    dple_n_in() -> int





    """
    return _casadi.dple_n_in(*args)

def dple_n_out(*args):
    """
    Get the number of QP solver outputs.

    dple_n_out() -> int





    """
    return _casadi.dple_n_out(*args)

def has_dple(*args):
    """
    Check if a particular plugin is available.

    has_dple(str name) -> bool





    """
    return _casadi.has_dple(*args)

def load_dple(*args):
    """
    Explicitly load a plugin dynamically.

    load_dple(str name)





    """
    return _casadi.load_dple(*args)

def doc_dple(*args):
    """
    Get the documentation string for a plugin.

    doc_dple(str name) -> str





    """
    return _casadi.doc_dple(*args)

def expmsol(*args):
    """
      Performs a matrix exponentiation expm(A)

      expmsol(str name, str solver, Sparsity A, dict opts) -> Function


    General information
    ===================



    >List of available options

    +------------------+-----------------+------------------+------------------+
    |        Id        |      Type       |   Description    |     Used in      |
    +==================+=================+==================+==================+
    | ad_weight        | OT_DOUBLE       | Weighting factor | casadi::Function |
    |                  |                 | for derivative   | Internal         |
    |                  |                 | calculation.When |                  |
    |                  |                 | there is an      |                  |
    |                  |                 | option of either |                  |
    |                  |                 | using forward or |                  |
    |                  |                 | reverse mode     |                  |
    |                  |                 | directional      |                  |
    |                  |                 | derivatives, the |                  |
    |                  |                 | condition ad_wei |                  |
    |                  |                 | ght*nf<=(1-ad_we |                  |
    |                  |                 | ight)*na is used |                  |
    |                  |                 | where nf and na  |                  |
    |                  |                 | are estimates of |                  |
    |                  |                 | the number of    |                  |
    |                  |                 | forward/reverse  |                  |
    |                  |                 | mode directional |                  |
    |                  |                 | derivatives      |                  |
    |                  |                 | needed. By       |                  |
    |                  |                 | default,         |                  |
    |                  |                 | ad_weight is     |                  |
    |                  |                 | calculated       |                  |
    |                  |                 | automatically,   |                  |
    |                  |                 | but this can be  |                  |
    |                  |                 | overridden by    |                  |
    |                  |                 | setting this     |                  |
    |                  |                 | option. In       |                  |
    |                  |                 | particular, 0    |                  |
    |                  |                 | means forcing    |                  |
    |                  |                 | forward mode and |                  |
    |                  |                 | 1 forcing        |                  |
    |                  |                 | reverse mode.    |                  |
    |                  |                 | Leave unset for  |                  |
    |                  |                 | (class specific) |                  |
    |                  |                 | heuristics.      |                  |
    +------------------+-----------------+------------------+------------------+
    | ad_weight_sp     | OT_DOUBLE       | Weighting factor | casadi::Function |
    |                  |                 | for sparsity     | Internal         |
    |                  |                 | pattern          |                  |
    |                  |                 | calculation calc |                  |
    |                  |                 | ulation.Override |                  |
    |                  |                 | s default        |                  |
    |                  |                 | behavior. Set to |                  |
    |                  |                 | 0 and 1 to force |                  |
    |                  |                 | forward and      |                  |
    |                  |                 | reverse mode     |                  |
    |                  |                 | respectively.    |                  |
    |                  |                 | Cf. option       |                  |
    |                  |                 | "ad_weight".     |                  |
    |                  |                 | When set to -1,  |                  |
    |                  |                 | sparsity is      |                  |
    |                  |                 | completely       |                  |
    |                  |                 | ignored and      |                  |
    |                  |                 | dense matrices   |                  |
    |                  |                 | are used.        |                  |
    +------------------+-----------------+------------------+------------------+
    | always_inline    | OT_BOOL         | Force inlining.  | casadi::Function |
    |                  |                 |                  | Internal         |
    +------------------+-----------------+------------------+------------------+
    | compiler         | OT_STRING       | Just-in-time     | casadi::Function |
    |                  |                 | compiler plugin  | Internal         |
    |                  |                 | to be used.      |                  |
    +------------------+-----------------+------------------+------------------+
    | const_A          | OT_BOOL         | Assume A is      | casadi::Expm     |
    |                  |                 | constant.        |                  |
    |                  |                 | Default: false.  |                  |
    +------------------+-----------------+------------------+------------------+
    | custom_jacobian  | OT_FUNCTION     | Override         | casadi::Function |
    |                  |                 | CasADi's AD. Use | Internal         |
    |                  |                 | together with    |                  |
    |                  |                 | 'jac_penalty':   |                  |
    |                  |                 | 0. Note: Highly  |                  |
    |                  |                 | experimental.    |                  |
    |                  |                 | Syntax may break |                  |
    |                  |                 | often.           |                  |
    +------------------+-----------------+------------------+------------------+
    | derivative_of    | OT_FUNCTION     | The function is  | casadi::Function |
    |                  |                 | a derivative of  | Internal         |
    |                  |                 | another          |                  |
    |                  |                 | function. The    |                  |
    |                  |                 | type of          |                  |
    |                  |                 | derivative       |                  |
    |                  |                 | (directional     |                  |
    |                  |                 | derivative,      |                  |
    |                  |                 | Jacobian) is     |                  |
    |                  |                 | inferred from    |                  |
    |                  |                 | the function     |                  |
    |                  |                 | name.            |                  |
    +------------------+-----------------+------------------+------------------+
    | dump             | OT_BOOL         | Dump function to | casadi::Function |
    |                  |                 | file upon first  | Internal         |
    |                  |                 | evaluation.      |                  |
    |                  |                 | [false]          |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_dir         | OT_STRING       | Directory to     | casadi::Function |
    |                  |                 | dump             | Internal         |
    |                  |                 | inputs/outputs   |                  |
    |                  |                 | to. Make sure    |                  |
    |                  |                 | the directory    |                  |
    |                  |                 | exists [.]       |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_format      | OT_STRING       | Choose file      | casadi::Function |
    |                  |                 | format to dump   | Internal         |
    |                  |                 | matrices. See    |                  |
    |                  |                 | DM.from_file     |                  |
    |                  |                 | [mtx]            |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_in          | OT_BOOL         | Dump numerical   | casadi::Function |
    |                  |                 | values of inputs | Internal         |
    |                  |                 | to file          |                  |
    |                  |                 | (readable with   |                  |
    |                  |                 | DM.from_file )   |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_out         | OT_BOOL         | Dump numerical   | casadi::Function |
    |                  |                 | values of        | Internal         |
    |                  |                 | outputs to file  |                  |
    |                  |                 | (readable with   |                  |
    |                  |                 | DM.from_file )   |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_fd        | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation by   |                  |
    |                  |                 | finite           |                  |
    |                  |                 | differencing.    |                  |
    |                  |                 | [default:        |                  |
    |                  |                 | false]]          |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_forward   | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | Jacobian-times-  |                  |
    |                  |                 | vector products  |                  |
    |                  |                 | - typically      |                  |
    |                  |                 | using forward    |                  |
    |                  |                 | mode AD - if     |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_jacobian  | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | Jacobians of all |                  |
    |                  |                 | differentiable   |                  |
    |                  |                 | outputs with     |                  |
    |                  |                 | respect to all   |                  |
    |                  |                 | differentiable   |                  |
    |                  |                 | inputs - if      |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_reverse   | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | transposed       |                  |
    |                  |                 | Jacobian-times-  |                  |
    |                  |                 | vector products  |                  |
    |                  |                 | - typically      |                  |
    |                  |                 | using reverse    |                  |
    |                  |                 | mode AD - if     |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | fd_method        | OT_STRING       | Method for       | casadi::Function |
    |                  |                 | finite           | Internal         |
    |                  |                 | differencing     |                  |
    |                  |                 | [default         |                  |
    |                  |                 | 'central']       |                  |
    +------------------+-----------------+------------------+------------------+
    | fd_options       | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to the    | Internal         |
    |                  |                 | finite           |                  |
    |                  |                 | difference       |                  |
    |                  |                 | instance         |                  |
    +------------------+-----------------+------------------+------------------+
    | forward_options  | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to a      | Internal         |
    |                  |                 | forward mode     |                  |
    |                  |                 | constructor      |                  |
    +------------------+-----------------+------------------+------------------+
    | gather_stats     | OT_BOOL         | Deprecated       | casadi::Function |
    |                  |                 | option           | Internal         |
    |                  |                 | (ignored):       |                  |
    |                  |                 | Statistics are   |                  |
    |                  |                 | now always       |                  |
    |                  |                 | collected.       |                  |
    +------------------+-----------------+------------------+------------------+
    | input_scheme     | OT_STRINGVECTOR | Deprecated       | casadi::Function |
    |                  |                 | option (ignored) | Internal         |
    +------------------+-----------------+------------------+------------------+
    | inputs_check     | OT_BOOL         | Throw exceptions | casadi::Function |
    |                  |                 | when the         | Internal         |
    |                  |                 | numerical values |                  |
    |                  |                 | of the inputs    |                  |
    |                  |                 | don't make sense |                  |
    +------------------+-----------------+------------------+------------------+
    | is_diff_in       | OT_BOOLVECTOR   | Indicate for     | casadi::Function |
    |                  |                 | each input if it | Internal         |
    |                  |                 | should be        |                  |
    |                  |                 | differentiable.  |                  |
    +------------------+-----------------+------------------+------------------+
    | is_diff_out      | OT_BOOLVECTOR   | Indicate for     | casadi::Function |
    |                  |                 | each output if   | Internal         |
    |                  |                 | it should be     |                  |
    |                  |                 | differentiable.  |                  |
    +------------------+-----------------+------------------+------------------+
    | jac_penalty      | OT_DOUBLE       | When requested   | casadi::Function |
    |                  |                 | for a number of  | Internal         |
    |                  |                 | forward/reverse  |                  |
    |                  |                 | directions, it   |                  |
    |                  |                 | may be cheaper   |                  |
    |                  |                 | to compute first |                  |
    |                  |                 | the full         |                  |
    |                  |                 | jacobian and     |                  |
    |                  |                 | then multiply    |                  |
    |                  |                 | with seeds,      |                  |
    |                  |                 | rather than      |                  |
    |                  |                 | obtain the       |                  |
    |                  |                 | requested        |                  |
    |                  |                 | directions in a  |                  |
    |                  |                 | straightforward  |                  |
    |                  |                 | manner. Casadi   |                  |
    |                  |                 | uses a heuristic |                  |
    |                  |                 | to decide which  |                  |
    |                  |                 | is cheaper. A    |                  |
    |                  |                 | high value of    |                  |
    |                  |                 | 'jac_penalty'    |                  |
    |                  |                 | makes it less    |                  |
    |                  |                 | likely for the   |                  |
    |                  |                 | heurstic to      |                  |
    |                  |                 | chose the full   |                  |
    |                  |                 | Jacobian         |                  |
    |                  |                 | strategy. The    |                  |
    |                  |                 | special value -1 |                  |
    |                  |                 | indicates never  |                  |
    |                  |                 | to use the full  |                  |
    |                  |                 | Jacobian         |                  |
    |                  |                 | strategy         |                  |
    +------------------+-----------------+------------------+------------------+
    | jit              | OT_BOOL         | Use just-in-time | casadi::Function |
    |                  |                 | compiler to      | Internal         |
    |                  |                 | speed up the     |                  |
    |                  |                 | evaluation       |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_cleanup      | OT_BOOL         | Cleanup up the   | casadi::Function |
    |                  |                 | temporary source | Internal         |
    |                  |                 | file that jit    |                  |
    |                  |                 | creates.         |                  |
    |                  |                 | Default: true    |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_name         | OT_STRING       | The file name    | casadi::Function |
    |                  |                 | used to write    | Internal         |
    |                  |                 | out code. The    |                  |
    |                  |                 | actual file      |                  |
    |                  |                 | names used       |                  |
    |                  |                 | depend on 'jit_t |                  |
    |                  |                 | emp_suffix' and  |                  |
    |                  |                 | include          |                  |
    |                  |                 | extensions.      |                  |
    |                  |                 | Default:         |                  |
    |                  |                 | 'jit_tmp'        |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_options      | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to the    | Internal         |
    |                  |                 | jit compiler.    |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_serialize    | OT_STRING       | Specify          | casadi::Function |
    |                  |                 | behaviour when   | Internal         |
    |                  |                 | serializing a    |                  |
    |                  |                 | jitted function: |                  |
    |                  |                 | SOURCE|link|embe |                  |
    |                  |                 | d.               |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_temp_suffix  | OT_BOOL         | Use a temporary  | casadi::Function |
    |                  |                 | (seemingly       | Internal         |
    |                  |                 | random) filename |                  |
    |                  |                 | suffix for       |                  |
    |                  |                 | generated code   |                  |
    |                  |                 | and libraries.   |                  |
    |                  |                 | This is desired  |                  |
    |                  |                 | for thread-      |                  |
    |                  |                 | safety. This     |                  |
    |                  |                 | behaviour may    |                  |
    |                  |                 | defeat caching   |                  |
    |                  |                 | compiler         |                  |
    |                  |                 | wrappers.        |                  |
    |                  |                 | Default: true    |                  |
    +------------------+-----------------+------------------+------------------+
    | max_num_dir      | OT_INT          | Specify the      | casadi::Function |
    |                  |                 | maximum number   | Internal         |
    |                  |                 | of directions    |                  |
    |                  |                 | for derivative   |                  |
    |                  |                 | functions.       |                  |
    |                  |                 | Overrules the    |                  |
    |                  |                 | builtin optimize |                  |
    |                  |                 | d_num_dir.       |                  |
    +------------------+-----------------+------------------+------------------+
    | never_inline     | OT_BOOL         | Forbid inlining. | casadi::Function |
    |                  |                 |                  | Internal         |
    +------------------+-----------------+------------------+------------------+
    | output_scheme    | OT_STRINGVECTOR | Deprecated       | casadi::Function |
    |                  |                 | option (ignored) | Internal         |
    +------------------+-----------------+------------------+------------------+
    | print_in         | OT_BOOL         | Print numerical  | casadi::Function |
    |                  |                 | values of inputs | Internal         |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | print_out        | OT_BOOL         | Print numerical  | casadi::Function |
    |                  |                 | values of        | Internal         |
    |                  |                 | outputs          |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | print_time       | OT_BOOL         | print            | casadi::Function |
    |                  |                 | information      | Internal         |
    |                  |                 | about execution  |                  |
    |                  |                 | time. Implies    |                  |
    |                  |                 | record_time.     |                  |
    +------------------+-----------------+------------------+------------------+
    | record_time      | OT_BOOL         | record           | casadi::Function |
    |                  |                 | information      | Internal         |
    |                  |                 | about execution  |                  |
    |                  |                 | time, for        |                  |
    |                  |                 | retrieval with   |                  |
    |                  |                 | stats().         |                  |
    +------------------+-----------------+------------------+------------------+
    | regularity_check | OT_BOOL         | Throw exceptions | casadi::Function |
    |                  |                 | when NaN or Inf  | Internal         |
    |                  |                 | appears during   |                  |
    |                  |                 | evaluation       |                  |
    +------------------+-----------------+------------------+------------------+
    | reverse_options  | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to a      | Internal         |
    |                  |                 | reverse mode     |                  |
    |                  |                 | constructor      |                  |
    +------------------+-----------------+------------------+------------------+
    | user_data        | OT_VOIDPTR      | A user-defined   | casadi::Function |
    |                  |                 | field that can   | Internal         |
    |                  |                 | be used to       |                  |
    |                  |                 | identify the     |                  |
    |                  |                 | function or pass |                  |
    |                  |                 | additional       |                  |
    |                  |                 | information      |                  |
    +------------------+-----------------+------------------+------------------+
    | verbose          | OT_BOOL         | Verbose          | casadi::Function |
    |                  |                 | evaluation  for  | Internal         |
    |                  |                 | debugging        |                  |
    +------------------+-----------------+------------------+------------------+

    List of plugins
    ===============



    - slicot

    Note: some of the plugins in this list might not be available on your
    system. Also, there might be extra plugins available to you that are not
    listed here. You can obtain their documentation with
    Expm.doc("myextraplugin")



    --------------------------------------------------------------------------------

    slicot
    ------





    --------------------------------------------------------------------------------



    Joris Gillis




    """
    return _casadi.expmsol(*args)

def expm_n_in(*args):
    """
    Get the number of expm solver inputs.

    expm_n_in() -> int





    """
    return _casadi.expm_n_in(*args)

def expm_n_out(*args):
    """
    Get the number of expm solver outputs.

    expm_n_out() -> int





    """
    return _casadi.expm_n_out(*args)

def has_expm(*args):
    """
    Check if a particular plugin is available.

    has_expm(str name) -> bool





    """
    return _casadi.has_expm(*args)

def load_expm(*args):
    """
    Explicitly load a plugin dynamically.

    load_expm(str name)





    """
    return _casadi.load_expm(*args)

def doc_expm(*args):
    """
    Get the documentation string for a plugin.

    doc_expm(str name) -> str





    """
    return _casadi.doc_expm(*args)

def interpolant(*args):
    """
      Parametric variant of interpolant.

      interpolant(str name, str solver, [[float]] grid, int m, dict opts) -> Function
      interpolant(str name, str solver, [int] grid_dims, int m, dict opts) -> Function
      interpolant(str name, str solver, [[float]] grid, [float] values, dict opts) -> Function
      interpolant(str name, str solver, [int] grid_dims, [float] values, dict opts) -> Function


    The resulting function will have an additional argument for the grid

    By default, derivatives wrt the coefficients are not supported (zero). Some
    interpolant plugins may support the inline=true which enables correct
    derivatives



    .......

    ::

      interpolant(str name, str solver, [[float]] grid, int m, dict opts)



    Parametric variant of interpolant.

    The resulting function will have an additional argument for the coefficients

    By default, derivatives wrt the coefficients are not supported (zero). Some
    interpolant plugins may support the inline=true which enables correct
    derivatives



    .............


    .......

    ::

      interpolant(str name, str solver, [int] grid_dims, int m, dict opts)



    Parametric variant of interpolant.

    The resulting function will have additional arguments for the grid and
    coefficients

    By default, derivatives wrt the coefficients are not supported (zero). Some
    interpolant plugins may support the inline=true which enables correct
    derivatives



    .............


    .......

    ::

      interpolant(str name, str solver, [[float]] grid, [float] values, dict opts)



    An interpolant function for lookup table data

    Parameters:
    -----------

    name:  label for the resulting Function

    solver:  name of the plugin

    grid:  collection of 1D grids whose outer product defines the full N-D
    rectangular grid

    values:  flattened vector of all values for all gridpoints

    Syntax 1D

    ::

      * # Python
      * xgrid = np.linspace(1,6,6)
      * V = [-1,-1,-2,-3,0,2]
      * LUT = casadi.interpolant("LUT","bspline",[xgrid],V)
      * print(LUT(2.5))
      * 



    ::

      * % Matlab
      * xgrid = 1:6;
      * V = [-1 -1 -2 -3 0 2];
      * LUT = casadi.interpolant('LUT','bspline',{xgrid},V);
      * LUT(2.5)
      * 



    Syntax 2D

    ::

      * # Python
      * xgrid = np.linspace(-5,5,11)
      * ygrid = np.linspace(-4,4,9)
      * X,Y = np.meshgrid(xgrid,ygrid,indexing='ij')
      * R = np.sqrt(5*X**2 + Y**2)+ 1
      * data = np.sin(R)/R
      * data_flat = data.ravel(order='F')
      * LUT = casadi.interpolant('name','bspline',[xgrid,ygrid],data_flat)
      * print(LUT([0.5,1]))
      * \\enverbatim
      * \\verbatim
      * % Matlab
      * xgrid = -5:1:5;
      * ygrid = -4:1:4;
      * R = sqrt(5*X.^2 + Y.^2)+ 1;
      * V = sin(R)./(R);
      * LUT = interpolant('LUT','bspline',{xgrid, ygrid},V(:));
      * LUT([0.5 1])
      * 



    General information
    ===================



    >List of available options

    +------------------+-----------------+------------------+------------------+
    |        Id        |      Type       |   Description    |     Used in      |
    +==================+=================+==================+==================+
    | ad_weight        | OT_DOUBLE       | Weighting factor | casadi::Function |
    |                  |                 | for derivative   | Internal         |
    |                  |                 | calculation.When |                  |
    |                  |                 | there is an      |                  |
    |                  |                 | option of either |                  |
    |                  |                 | using forward or |                  |
    |                  |                 | reverse mode     |                  |
    |                  |                 | directional      |                  |
    |                  |                 | derivatives, the |                  |
    |                  |                 | condition ad_wei |                  |
    |                  |                 | ght*nf<=(1-ad_we |                  |
    |                  |                 | ight)*na is used |                  |
    |                  |                 | where nf and na  |                  |
    |                  |                 | are estimates of |                  |
    |                  |                 | the number of    |                  |
    |                  |                 | forward/reverse  |                  |
    |                  |                 | mode directional |                  |
    |                  |                 | derivatives      |                  |
    |                  |                 | needed. By       |                  |
    |                  |                 | default,         |                  |
    |                  |                 | ad_weight is     |                  |
    |                  |                 | calculated       |                  |
    |                  |                 | automatically,   |                  |
    |                  |                 | but this can be  |                  |
    |                  |                 | overridden by    |                  |
    |                  |                 | setting this     |                  |
    |                  |                 | option. In       |                  |
    |                  |                 | particular, 0    |                  |
    |                  |                 | means forcing    |                  |
    |                  |                 | forward mode and |                  |
    |                  |                 | 1 forcing        |                  |
    |                  |                 | reverse mode.    |                  |
    |                  |                 | Leave unset for  |                  |
    |                  |                 | (class specific) |                  |
    |                  |                 | heuristics.      |                  |
    +------------------+-----------------+------------------+------------------+
    | ad_weight_sp     | OT_DOUBLE       | Weighting factor | casadi::Function |
    |                  |                 | for sparsity     | Internal         |
    |                  |                 | pattern          |                  |
    |                  |                 | calculation calc |                  |
    |                  |                 | ulation.Override |                  |
    |                  |                 | s default        |                  |
    |                  |                 | behavior. Set to |                  |
    |                  |                 | 0 and 1 to force |                  |
    |                  |                 | forward and      |                  |
    |                  |                 | reverse mode     |                  |
    |                  |                 | respectively.    |                  |
    |                  |                 | Cf. option       |                  |
    |                  |                 | "ad_weight".     |                  |
    |                  |                 | When set to -1,  |                  |
    |                  |                 | sparsity is      |                  |
    |                  |                 | completely       |                  |
    |                  |                 | ignored and      |                  |
    |                  |                 | dense matrices   |                  |
    |                  |                 | are used.        |                  |
    +------------------+-----------------+------------------+------------------+
    | always_inline    | OT_BOOL         | Force inlining.  | casadi::Function |
    |                  |                 |                  | Internal         |
    +------------------+-----------------+------------------+------------------+
    | batch_x          | OT_INT          | Evaluate a batch | casadi::Interpol |
    |                  |                 | of different     | ant              |
    |                  |                 | inputs at once   |                  |
    |                  |                 | (default 1).     |                  |
    +------------------+-----------------+------------------+------------------+
    | compiler         | OT_STRING       | Just-in-time     | casadi::Function |
    |                  |                 | compiler plugin  | Internal         |
    |                  |                 | to be used.      |                  |
    +------------------+-----------------+------------------+------------------+
    | custom_jacobian  | OT_FUNCTION     | Override         | casadi::Function |
    |                  |                 | CasADi's AD. Use | Internal         |
    |                  |                 | together with    |                  |
    |                  |                 | 'jac_penalty':   |                  |
    |                  |                 | 0. Note: Highly  |                  |
    |                  |                 | experimental.    |                  |
    |                  |                 | Syntax may break |                  |
    |                  |                 | often.           |                  |
    +------------------+-----------------+------------------+------------------+
    | derivative_of    | OT_FUNCTION     | The function is  | casadi::Function |
    |                  |                 | a derivative of  | Internal         |
    |                  |                 | another          |                  |
    |                  |                 | function. The    |                  |
    |                  |                 | type of          |                  |
    |                  |                 | derivative       |                  |
    |                  |                 | (directional     |                  |
    |                  |                 | derivative,      |                  |
    |                  |                 | Jacobian) is     |                  |
    |                  |                 | inferred from    |                  |
    |                  |                 | the function     |                  |
    |                  |                 | name.            |                  |
    +------------------+-----------------+------------------+------------------+
    | dump             | OT_BOOL         | Dump function to | casadi::Function |
    |                  |                 | file upon first  | Internal         |
    |                  |                 | evaluation.      |                  |
    |                  |                 | [false]          |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_dir         | OT_STRING       | Directory to     | casadi::Function |
    |                  |                 | dump             | Internal         |
    |                  |                 | inputs/outputs   |                  |
    |                  |                 | to. Make sure    |                  |
    |                  |                 | the directory    |                  |
    |                  |                 | exists [.]       |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_format      | OT_STRING       | Choose file      | casadi::Function |
    |                  |                 | format to dump   | Internal         |
    |                  |                 | matrices. See    |                  |
    |                  |                 | DM.from_file     |                  |
    |                  |                 | [mtx]            |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_in          | OT_BOOL         | Dump numerical   | casadi::Function |
    |                  |                 | values of inputs | Internal         |
    |                  |                 | to file          |                  |
    |                  |                 | (readable with   |                  |
    |                  |                 | DM.from_file )   |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_out         | OT_BOOL         | Dump numerical   | casadi::Function |
    |                  |                 | values of        | Internal         |
    |                  |                 | outputs to file  |                  |
    |                  |                 | (readable with   |                  |
    |                  |                 | DM.from_file )   |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_fd        | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation by   |                  |
    |                  |                 | finite           |                  |
    |                  |                 | differencing.    |                  |
    |                  |                 | [default:        |                  |
    |                  |                 | false]]          |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_forward   | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | Jacobian-times-  |                  |
    |                  |                 | vector products  |                  |
    |                  |                 | - typically      |                  |
    |                  |                 | using forward    |                  |
    |                  |                 | mode AD - if     |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_jacobian  | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | Jacobians of all |                  |
    |                  |                 | differentiable   |                  |
    |                  |                 | outputs with     |                  |
    |                  |                 | respect to all   |                  |
    |                  |                 | differentiable   |                  |
    |                  |                 | inputs - if      |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_reverse   | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | transposed       |                  |
    |                  |                 | Jacobian-times-  |                  |
    |                  |                 | vector products  |                  |
    |                  |                 | - typically      |                  |
    |                  |                 | using reverse    |                  |
    |                  |                 | mode AD - if     |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | fd_method        | OT_STRING       | Method for       | casadi::Function |
    |                  |                 | finite           | Internal         |
    |                  |                 | differencing     |                  |
    |                  |                 | [default         |                  |
    |                  |                 | 'central']       |                  |
    +------------------+-----------------+------------------+------------------+
    | fd_options       | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to the    | Internal         |
    |                  |                 | finite           |                  |
    |                  |                 | difference       |                  |
    |                  |                 | instance         |                  |
    +------------------+-----------------+------------------+------------------+
    | forward_options  | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to a      | Internal         |
    |                  |                 | forward mode     |                  |
    |                  |                 | constructor      |                  |
    +------------------+-----------------+------------------+------------------+
    | gather_stats     | OT_BOOL         | Deprecated       | casadi::Function |
    |                  |                 | option           | Internal         |
    |                  |                 | (ignored):       |                  |
    |                  |                 | Statistics are   |                  |
    |                  |                 | now always       |                  |
    |                  |                 | collected.       |                  |
    +------------------+-----------------+------------------+------------------+
    | inline           | OT_BOOL         | Implement the    | casadi::Interpol |
    |                  |                 | lookup table in  | ant              |
    |                  |                 | MX primitives.   |                  |
    |                  |                 | Useful when you  |                  |
    |                  |                 | need derivatives |                  |
    |                  |                 | with respect to  |                  |
    |                  |                 | grid and/or      |                  |
    |                  |                 | coefficients.    |                  |
    |                  |                 | Such derivatives |                  |
    |                  |                 | are              |                  |
    |                  |                 | fundamentally    |                  |
    |                  |                 | dense, so use    |                  |
    |                  |                 | with caution.    |                  |
    +------------------+-----------------+------------------+------------------+
    | input_scheme     | OT_STRINGVECTOR | Deprecated       | casadi::Function |
    |                  |                 | option (ignored) | Internal         |
    +------------------+-----------------+------------------+------------------+
    | inputs_check     | OT_BOOL         | Throw exceptions | casadi::Function |
    |                  |                 | when the         | Internal         |
    |                  |                 | numerical values |                  |
    |                  |                 | of the inputs    |                  |
    |                  |                 | don't make sense |                  |
    +------------------+-----------------+------------------+------------------+
    | is_diff_in       | OT_BOOLVECTOR   | Indicate for     | casadi::Function |
    |                  |                 | each input if it | Internal         |
    |                  |                 | should be        |                  |
    |                  |                 | differentiable.  |                  |
    +------------------+-----------------+------------------+------------------+
    | is_diff_out      | OT_BOOLVECTOR   | Indicate for     | casadi::Function |
    |                  |                 | each output if   | Internal         |
    |                  |                 | it should be     |                  |
    |                  |                 | differentiable.  |                  |
    +------------------+-----------------+------------------+------------------+
    | jac_penalty      | OT_DOUBLE       | When requested   | casadi::Function |
    |                  |                 | for a number of  | Internal         |
    |                  |                 | forward/reverse  |                  |
    |                  |                 | directions, it   |                  |
    |                  |                 | may be cheaper   |                  |
    |                  |                 | to compute first |                  |
    |                  |                 | the full         |                  |
    |                  |                 | jacobian and     |                  |
    |                  |                 | then multiply    |                  |
    |                  |                 | with seeds,      |                  |
    |                  |                 | rather than      |                  |
    |                  |                 | obtain the       |                  |
    |                  |                 | requested        |                  |
    |                  |                 | directions in a  |                  |
    |                  |                 | straightforward  |                  |
    |                  |                 | manner. Casadi   |                  |
    |                  |                 | uses a heuristic |                  |
    |                  |                 | to decide which  |                  |
    |                  |                 | is cheaper. A    |                  |
    |                  |                 | high value of    |                  |
    |                  |                 | 'jac_penalty'    |                  |
    |                  |                 | makes it less    |                  |
    |                  |                 | likely for the   |                  |
    |                  |                 | heurstic to      |                  |
    |                  |                 | chose the full   |                  |
    |                  |                 | Jacobian         |                  |
    |                  |                 | strategy. The    |                  |
    |                  |                 | special value -1 |                  |
    |                  |                 | indicates never  |                  |
    |                  |                 | to use the full  |                  |
    |                  |                 | Jacobian         |                  |
    |                  |                 | strategy         |                  |
    +------------------+-----------------+------------------+------------------+
    | jit              | OT_BOOL         | Use just-in-time | casadi::Function |
    |                  |                 | compiler to      | Internal         |
    |                  |                 | speed up the     |                  |
    |                  |                 | evaluation       |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_cleanup      | OT_BOOL         | Cleanup up the   | casadi::Function |
    |                  |                 | temporary source | Internal         |
    |                  |                 | file that jit    |                  |
    |                  |                 | creates.         |                  |
    |                  |                 | Default: true    |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_name         | OT_STRING       | The file name    | casadi::Function |
    |                  |                 | used to write    | Internal         |
    |                  |                 | out code. The    |                  |
    |                  |                 | actual file      |                  |
    |                  |                 | names used       |                  |
    |                  |                 | depend on 'jit_t |                  |
    |                  |                 | emp_suffix' and  |                  |
    |                  |                 | include          |                  |
    |                  |                 | extensions.      |                  |
    |                  |                 | Default:         |                  |
    |                  |                 | 'jit_tmp'        |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_options      | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to the    | Internal         |
    |                  |                 | jit compiler.    |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_serialize    | OT_STRING       | Specify          | casadi::Function |
    |                  |                 | behaviour when   | Internal         |
    |                  |                 | serializing a    |                  |
    |                  |                 | jitted function: |                  |
    |                  |                 | SOURCE|link|embe |                  |
    |                  |                 | d.               |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_temp_suffix  | OT_BOOL         | Use a temporary  | casadi::Function |
    |                  |                 | (seemingly       | Internal         |
    |                  |                 | random) filename |                  |
    |                  |                 | suffix for       |                  |
    |                  |                 | generated code   |                  |
    |                  |                 | and libraries.   |                  |
    |                  |                 | This is desired  |                  |
    |                  |                 | for thread-      |                  |
    |                  |                 | safety. This     |                  |
    |                  |                 | behaviour may    |                  |
    |                  |                 | defeat caching   |                  |
    |                  |                 | compiler         |                  |
    |                  |                 | wrappers.        |                  |
    |                  |                 | Default: true    |                  |
    +------------------+-----------------+------------------+------------------+
    | lookup_mode      | OT_STRINGVECTOR | Specifies, for   | casadi::Interpol |
    |                  |                 | each grid        | ant              |
    |                  |                 | dimenion, the    |                  |
    |                  |                 | lookup algorithm |                  |
    |                  |                 | used to find the |                  |
    |                  |                 | correct index.   |                  |
    |                  |                 | 'linear' uses a  |                  |
    |                  |                 | for-loop +       |                  |
    |                  |                 | break; (default  |                  |
    |                  |                 | when             |                  |
    |                  |                 | #knots<=100),    |                  |
    |                  |                 | 'exact' uses     |                  |
    |                  |                 | floored division |                  |
    |                  |                 | (only for        |                  |
    |                  |                 | uniform grids),  |                  |
    |                  |                 | 'binary' uses a  |                  |
    |                  |                 | binary search.   |                  |
    |                  |                 | (default when    |                  |
    |                  |                 | #knots>100).     |                  |
    +------------------+-----------------+------------------+------------------+
    | max_num_dir      | OT_INT          | Specify the      | casadi::Function |
    |                  |                 | maximum number   | Internal         |
    |                  |                 | of directions    |                  |
    |                  |                 | for derivative   |                  |
    |                  |                 | functions.       |                  |
    |                  |                 | Overrules the    |                  |
    |                  |                 | builtin optimize |                  |
    |                  |                 | d_num_dir.       |                  |
    +------------------+-----------------+------------------+------------------+
    | never_inline     | OT_BOOL         | Forbid inlining. | casadi::Function |
    |                  |                 |                  | Internal         |
    +------------------+-----------------+------------------+------------------+
    | output_scheme    | OT_STRINGVECTOR | Deprecated       | casadi::Function |
    |                  |                 | option (ignored) | Internal         |
    +------------------+-----------------+------------------+------------------+
    | print_in         | OT_BOOL         | Print numerical  | casadi::Function |
    |                  |                 | values of inputs | Internal         |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | print_out        | OT_BOOL         | Print numerical  | casadi::Function |
    |                  |                 | values of        | Internal         |
    |                  |                 | outputs          |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | print_time       | OT_BOOL         | print            | casadi::Function |
    |                  |                 | information      | Internal         |
    |                  |                 | about execution  |                  |
    |                  |                 | time. Implies    |                  |
    |                  |                 | record_time.     |                  |
    +------------------+-----------------+------------------+------------------+
    | record_time      | OT_BOOL         | record           | casadi::Function |
    |                  |                 | information      | Internal         |
    |                  |                 | about execution  |                  |
    |                  |                 | time, for        |                  |
    |                  |                 | retrieval with   |                  |
    |                  |                 | stats().         |                  |
    +------------------+-----------------+------------------+------------------+
    | regularity_check | OT_BOOL         | Throw exceptions | casadi::Function |
    |                  |                 | when NaN or Inf  | Internal         |
    |                  |                 | appears during   |                  |
    |                  |                 | evaluation       |                  |
    +------------------+-----------------+------------------+------------------+
    | reverse_options  | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to a      | Internal         |
    |                  |                 | reverse mode     |                  |
    |                  |                 | constructor      |                  |
    +------------------+-----------------+------------------+------------------+
    | user_data        | OT_VOIDPTR      | A user-defined   | casadi::Function |
    |                  |                 | field that can   | Internal         |
    |                  |                 | be used to       |                  |
    |                  |                 | identify the     |                  |
    |                  |                 | function or pass |                  |
    |                  |                 | additional       |                  |
    |                  |                 | information      |                  |
    +------------------+-----------------+------------------+------------------+
    | verbose          | OT_BOOL         | Verbose          | casadi::Function |
    |                  |                 | evaluation  for  | Internal         |
    |                  |                 | debugging        |                  |
    +------------------+-----------------+------------------+------------------+

    List of plugins
    ===============



    - bspline

    - linear

    Note: some of the plugins in this list might not be available on your
    system. Also, there might be extra plugins available to you that are not
    listed here. You can obtain their documentation with
    Interpolant.doc("myextraplugin")



    --------------------------------------------------------------------------------

    bspline
    -------



    >List of available options

    +-----------------------+--------------+-----------------------------------+
    |          Id           |     Type     |            Description            |
    +=======================+==============+===================================+
    | algorithm             | OT_STRING    | Algorithm used for fitting the    |
    |                       |              | data: 'not_a_knot' (default, same |
    |                       |              | as Matlab), 'smooth_linear'.      |
    +-----------------------+--------------+-----------------------------------+
    | degree                | OT_INTVECTOR | Sets, for each grid dimension,    |
    |                       |              | the degree of the spline.         |
    +-----------------------+--------------+-----------------------------------+
    | linear_solver         | OT_STRING    | Solver used for constructing the  |
    |                       |              | coefficient tensor.               |
    +-----------------------+--------------+-----------------------------------+
    | linear_solver_options | OT_DICT      | Options to be passed to the       |
    |                       |              | linear solver.                    |
    +-----------------------+--------------+-----------------------------------+
    | smooth_linear_frac    | OT_DOUBLE    | When 'smooth_linear' algorithm is |
    |                       |              | active, determines sharpness      |
    |                       |              | between 0 (sharp, as linear       |
    |                       |              | interpolation) and 0.5            |
    |                       |              | (smooth).Default value is 0.1.    |
    +-----------------------+--------------+-----------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    linear
    ------



    >List of available options

    +-------------+-----------------+------------------------------------------+
    |     Id      |      Type       |               Description                |
    +=============+=================+==========================================+
    | lookup_mode | OT_STRINGVECTOR | Sets, for each grid dimenion, the lookup |
    |             |                 | algorithm used to find the correct       |
    |             |                 | index. 'linear' uses a for-loop + break; |
    |             |                 | 'exact' uses floored division (only for  |
    |             |                 | uniform grids).                          |
    +-------------+-----------------+------------------------------------------+

    --------------------------------------------------------------------------------



    Joel Andersson



    .............


    .......

    ::

      interpolant(str name, str solver, [int] grid_dims, [float] values, dict opts)



    Parametric variant of interpolant.

    The resulting function will have an additional argument for the grid

    By default, derivatives wrt the coefficients are not supported (zero). Some
    interpolant plugins may support the inline=true which enables correct
    derivatives



    .............



    """
    return _casadi.interpolant(*args)

def has_interpolant(*args):
    """
    Check if a particular plugin is available.

    has_interpolant(str name) -> bool





    """
    return _casadi.has_interpolant(*args)

def load_interpolant(*args):
    """
    Explicitly load a plugin dynamically.

    load_interpolant(str name)





    """
    return _casadi.load_interpolant(*args)

def doc_interpolant(*args):
    """
    Get the documentation string for a plugin.

    doc_interpolant(str name) -> str





    """
    return _casadi.doc_interpolant(*args)
class CodeGenerator(_object):
    """
      Helper class for C code generation.



    Joel Andersson

    C++ includes: code_generator.hpp 


    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CodeGenerator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CodeGenerator, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        Constructor.

        CodeGenerator(str name, dict opts)





        """
        this = _casadi.new_CodeGenerator(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def add(self, *args):
        """
        Add a function (name generated)

        add(self, Function f, bool with_jac_sparsity)





        """
        return _casadi.CodeGenerator_add(self, *args)


    def dump(self, *args):
        """
        Generate a file, return code as string.

        dump(self) -> str





        """
        return _casadi.CodeGenerator_dump(self, *args)


    def generate(self, *args):
        """
          Generate file(s) The "prefix" argument will be prepended to the generated

          generate(self, str prefix) -> str

        files and may be a directory or a file prefix. returns the filename.




        """
        return _casadi.CodeGenerator_generate(self, *args)


    def add_include(self, *args):
        """
          Add an include file optionally using a relative path "..." instead of an

          add_include(self, str new_include, bool relative_path, str use_ifdef)

        absolute path <...>




        """
        return _casadi.CodeGenerator_add_include(self, *args)

    __swig_destroy__ = _casadi.delete_CodeGenerator
CodeGenerator_swigregister = _casadi.CodeGenerator_swigregister
CodeGenerator_swigregister(CodeGenerator)

FLAG = _casadi.FLAG

def _horzcat(*args):
    """


    _horzcat([Sparsity] v) -> Sparsity
    _horzcat([DM] v) -> DM
    _horzcat([SX] v) -> SX
    _horzcat([MX] v) -> MX



    """
    return _casadi._horzcat(*args)

def _vertcat(*args):
    """


    _vertcat([Sparsity] v) -> Sparsity
    _vertcat([DM] v) -> DM
    _vertcat([SX] v) -> SX
    _vertcat([MX] v) -> MX



    """
    return _casadi._vertcat(*args)

def horzsplit(*args):
    """


    horzsplit(Sparsity v, int incr) -> [Sparsity]
    horzsplit(DM v, int incr) -> [DM]
    horzsplit(SX v, int incr) -> [SX]
    horzsplit(MX v, int incr) -> [MX]
    horzsplit(Sparsity v, [int] offset) -> [Sparsity]
    horzsplit(DM v, [int] offset) -> [DM]
    horzsplit(SX v, [int] offset) -> [SX]
    horzsplit(MX v, [int] offset) -> [MX]



    """
    return _casadi.horzsplit(*args)

def offset(*args):
    """


    offset([Sparsity] v, bool vert) -> [int]
    offset([DM] v, bool vert) -> [int]
    offset([SX] v, bool vert) -> [int]
    offset([MX] v, bool vert) -> [int]



    """
    return _casadi.offset(*args)

def vertsplit(*args):
    """


    vertsplit(Sparsity v, int incr) -> [Sparsity]
    vertsplit(DM v, int incr) -> [DM]
    vertsplit(SX v, int incr) -> [SX]
    vertsplit(MX v, int incr) -> [MX]
    vertsplit(Sparsity v, [int] offset) -> [Sparsity]
    vertsplit(DM v, [int] offset) -> [DM]
    vertsplit(SX v, [int] offset) -> [SX]
    vertsplit(MX v, [int] offset) -> [MX]



    """
    return _casadi.vertsplit(*args)

def blocksplit(*args):
    """


    blocksplit(Sparsity x, int vert_incr, int horz_incr) -> [[Sparsity]]
    blocksplit(DM x, int vert_incr, int horz_incr) -> [[DM]]
    blocksplit(SX x, int vert_incr, int horz_incr) -> [[SX]]
    blocksplit(MX x, int vert_incr, int horz_incr) -> [[MX]]
    blocksplit(Sparsity x, [int] vert_offset, [int] horz_offset) -> [[Sparsity]]
    blocksplit(DM x, [int] vert_offset, [int] horz_offset) -> [[DM]]
    blocksplit(SX x, [int] vert_offset, [int] horz_offset) -> [[SX]]
    blocksplit(MX x, [int] vert_offset, [int] horz_offset) -> [[MX]]



    """
    return _casadi.blocksplit(*args)

def _diagcat(*args):
    """


    _diagcat([Sparsity] A) -> Sparsity
    _diagcat([DM] A) -> DM
    _diagcat([SX] A) -> SX
    _diagcat([MX] A) -> MX



    """
    return _casadi._diagcat(*args)

def diagsplit(*args):
    """


    diagsplit(Sparsity x, int incr) -> [Sparsity]
    diagsplit(DM x, int incr) -> [DM]
    diagsplit(SX x, int incr) -> [SX]
    diagsplit(MX x, int incr) -> [MX]
    diagsplit(Sparsity x, [int] output_offset) -> [Sparsity]
    diagsplit(DM x, [int] output_offset) -> [DM]
    diagsplit(SX x, [int] output_offset) -> [SX]
    diagsplit(MX x, [int] output_offset) -> [MX]
    diagsplit(Sparsity x, int incr1, int incr2) -> [Sparsity]
    diagsplit(Sparsity x, [int] output_offset1, [int] output_offset2) -> [Sparsity]
    diagsplit(DM x, int incr1, int incr2) -> [DM]
    diagsplit(DM x, [int] output_offset1, [int] output_offset2) -> [DM]
    diagsplit(SX x, int incr1, int incr2) -> [SX]
    diagsplit(SX x, [int] output_offset1, [int] output_offset2) -> [SX]
    diagsplit(MX x, int incr1, int incr2) -> [MX]
    diagsplit(MX x, [int] output_offset1, [int] output_offset2) -> [MX]



    """
    return _casadi.diagsplit(*args)

def _veccat(*args):
    """


    _veccat([Sparsity] x) -> Sparsity
    _veccat([DM] x) -> DM
    _veccat([SX] x) -> SX
    _veccat([MX] x) -> MX



    """
    return _casadi._veccat(*args)

def mtimes(*args):
    """


    mtimes([Sparsity] args) -> Sparsity
    mtimes([DM] args) -> DM
    mtimes([SX] args) -> SX
    mtimes([MX] args) -> MX
    mtimes(Sparsity x, Sparsity y) -> Sparsity
    mtimes(DM x, DM y) -> DM
    mtimes(SX x, SX y) -> SX
    mtimes(MX x, MX y) -> MX



    """
    return _casadi.mtimes(*args)

def mac(*args):
    """


    mac(Sparsity X, Sparsity Y, Sparsity Z) -> Sparsity
    mac(DM X, DM Y, DM Z) -> DM
    mac(SX X, SX Y, SX Z) -> SX
    mac(MX X, MX Y, MX Z) -> MX



    """
    return _casadi.mac(*args)

def transpose(*args):
    """
      Transpose the matrix and get the reordering of the non-zero entries.

      transpose(Sparsity X) -> Sparsity
      transpose(DM X) -> DM
      transpose(SX X) -> SX
      transpose(MX X) -> MX


    Parameters:
    -----------

    mapping:  the non-zeros of the original matrix for each non-zero of the new
    matrix




    """
    return _casadi.transpose(*args)

def vec(*args):
    """


    vec(Sparsity a) -> Sparsity
    vec(DM a) -> DM
    vec(SX a) -> SX
    vec(MX a) -> MX



    """
    return _casadi.vec(*args)

def reshape(*args):
    """


    reshape(Sparsity a, (int,int) rc) -> Sparsity
    reshape(Sparsity a, Sparsity sp) -> Sparsity
    reshape(DM a, (int,int) rc) -> DM
    reshape(DM a, Sparsity sp) -> DM
    reshape(SX a, (int,int) rc) -> SX
    reshape(SX a, Sparsity sp) -> SX
    reshape(MX a, (int,int) rc) -> MX
    reshape(MX a, Sparsity sp) -> MX
    reshape(Sparsity a, int nrow, int ncol) -> Sparsity
    reshape(DM a, int nrow, int ncol) -> DM
    reshape(SX a, int nrow, int ncol) -> SX
    reshape(MX a, int nrow, int ncol) -> MX



    """
    return _casadi.reshape(*args)

def sprank(*args):
    """


    sprank(Sparsity A) -> int
    sprank(DM A) -> int
    sprank(SX A) -> int
    sprank(MX A) -> int



    """
    return _casadi.sprank(*args)

def norm_0_mul(*args):
    """


    norm_0_mul(Sparsity x, Sparsity y) -> int
    norm_0_mul(DM x, DM y) -> int
    norm_0_mul(SX x, SX y) -> int
    norm_0_mul(MX x, MX y) -> int



    """
    return _casadi.norm_0_mul(*args)

def triu(*args):
    """


    triu(Sparsity a, bool includeDiagonal) -> Sparsity
    triu(DM a, bool includeDiagonal) -> DM
    triu(SX a, bool includeDiagonal) -> SX
    triu(MX a, bool includeDiagonal) -> MX



    """
    return _casadi.triu(*args)

def tril(*args):
    """


    tril(Sparsity a, bool includeDiagonal) -> Sparsity
    tril(DM a, bool includeDiagonal) -> DM
    tril(SX a, bool includeDiagonal) -> SX
    tril(MX a, bool includeDiagonal) -> MX



    """
    return _casadi.tril(*args)

def kron(*args):
    """


    kron(Sparsity a, Sparsity b) -> Sparsity
    kron(DM a, DM b) -> DM
    kron(SX a, SX b) -> SX
    kron(MX a, MX b) -> MX



    """
    return _casadi.kron(*args)

def repmat(*args):
    """


    repmat(Sparsity A, int n, int m) -> Sparsity
    repmat(Sparsity A, (int,int) rc) -> Sparsity
    repmat(DM A, int n, int m) -> DM
    repmat(DM A, (int,int) rc) -> DM
    repmat(SX A, int n, int m) -> SX
    repmat(SX A, (int,int) rc) -> SX
    repmat(MX A, int n, int m) -> MX
    repmat(MX A, (int,int) rc) -> MX



    """
    return _casadi.repmat(*args)

def sum2(*args):
    """


    sum2(Sparsity x) -> Sparsity
    sum2(DM x) -> DM
    sum2(SX x) -> SX
    sum2(MX x) -> MX



    """
    return _casadi.sum2(*args)

def sum1(*args):
    """


    sum1(Sparsity x) -> Sparsity
    sum1(DM x) -> DM
    sum1(SX x) -> SX
    sum1(MX x) -> MX



    """
    return _casadi.sum1(*args)

def plus(*args):
    """


    plus(float x, float y) -> float
    plus(DM x, DM y) -> DM
    plus(SX x, SX y) -> SX
    plus(MX x, MX y) -> MX



    """
    return _casadi.plus(*args)

def minus(*args):
    """


    minus(float x, float y) -> float
    minus(DM x, DM y) -> DM
    minus(SX x, SX y) -> SX
    minus(MX x, MX y) -> MX



    """
    return _casadi.minus(*args)

def times(*args):
    """


    times(float x, float y) -> float
    times(DM x, DM y) -> DM
    times(SX x, SX y) -> SX
    times(MX x, MX y) -> MX



    """
    return _casadi.times(*args)

def rdivide(*args):
    """


    rdivide(float x, float y) -> float
    rdivide(DM x, DM y) -> DM
    rdivide(SX x, SX y) -> SX
    rdivide(MX x, MX y) -> MX



    """
    return _casadi.rdivide(*args)

def ldivide(*args):
    """


    ldivide(float x, float y) -> float
    ldivide(DM x, DM y) -> DM
    ldivide(SX x, SX y) -> SX
    ldivide(MX x, MX y) -> MX



    """
    return _casadi.ldivide(*args)

def lt(*args):
    """


    lt(float x, float y) -> float
    lt(DM x, DM y) -> DM
    lt(SX x, SX y) -> SX
    lt(MX x, MX y) -> MX



    """
    return _casadi.lt(*args)

def le(*args):
    """


    le(float x, float y) -> float
    le(DM x, DM y) -> DM
    le(SX x, SX y) -> SX
    le(MX x, MX y) -> MX



    """
    return _casadi.le(*args)

def gt(*args):
    """


    gt(float x, float y) -> float
    gt(DM x, DM y) -> DM
    gt(SX x, SX y) -> SX
    gt(MX x, MX y) -> MX



    """
    return _casadi.gt(*args)

def ge(*args):
    """


    ge(float x, float y) -> float
    ge(DM x, DM y) -> DM
    ge(SX x, SX y) -> SX
    ge(MX x, MX y) -> MX



    """
    return _casadi.ge(*args)

def eq(*args):
    """


    eq(float x, float y) -> float
    eq(DM x, DM y) -> DM
    eq(SX x, SX y) -> SX
    eq(MX x, MX y) -> MX



    """
    return _casadi.eq(*args)

def ne(*args):
    """


    ne(float x, float y) -> float
    ne(DM x, DM y) -> DM
    ne(SX x, SX y) -> SX
    ne(MX x, MX y) -> MX



    """
    return _casadi.ne(*args)

def logic_and(*args):
    """


    logic_and(float x, float y) -> float
    logic_and(DM x, DM y) -> DM
    logic_and(SX x, SX y) -> SX
    logic_and(MX x, MX y) -> MX



    """
    return _casadi.logic_and(*args)

def logic_or(*args):
    """


    logic_or(float x, float y) -> float
    logic_or(DM x, DM y) -> DM
    logic_or(SX x, SX y) -> SX
    logic_or(MX x, MX y) -> MX



    """
    return _casadi.logic_or(*args)

def logic_not(*args):
    """


    logic_not(float x) -> float
    logic_not(DM x) -> DM
    logic_not(SX x) -> SX
    logic_not(MX x) -> MX



    """
    return _casadi.logic_not(*args)

def fabs(*args):
    """


    fabs(float x) -> float
    fabs(DM x) -> DM
    fabs(SX x) -> SX
    fabs(MX x) -> MX



    """
    return _casadi.fabs(*args)

def sqrt(*args):
    """


    sqrt(float x) -> float
    sqrt(DM x) -> DM
    sqrt(SX x) -> SX
    sqrt(MX x) -> MX



    """
    return _casadi.sqrt(*args)

def sin(*args):
    """


    sin(float x) -> float
    sin(DM x) -> DM
    sin(SX x) -> SX
    sin(MX x) -> MX



    """
    return _casadi.sin(*args)

def cos(*args):
    """


    cos(float x) -> float
    cos(DM x) -> DM
    cos(SX x) -> SX
    cos(MX x) -> MX



    """
    return _casadi.cos(*args)

def tan(*args):
    """


    tan(float x) -> float
    tan(DM x) -> DM
    tan(SX x) -> SX
    tan(MX x) -> MX



    """
    return _casadi.tan(*args)

def atan(*args):
    """


    atan(float x) -> float
    atan(DM x) -> DM
    atan(SX x) -> SX
    atan(MX x) -> MX



    """
    return _casadi.atan(*args)

def asin(*args):
    """


    asin(float x) -> float
    asin(DM x) -> DM
    asin(SX x) -> SX
    asin(MX x) -> MX



    """
    return _casadi.asin(*args)

def acos(*args):
    """


    acos(float x) -> float
    acos(DM x) -> DM
    acos(SX x) -> SX
    acos(MX x) -> MX



    """
    return _casadi.acos(*args)

def tanh(*args):
    """


    tanh(float x) -> float
    tanh(DM x) -> DM
    tanh(SX x) -> SX
    tanh(MX x) -> MX



    """
    return _casadi.tanh(*args)

def sinh(*args):
    """


    sinh(float x) -> float
    sinh(DM x) -> DM
    sinh(SX x) -> SX
    sinh(MX x) -> MX



    """
    return _casadi.sinh(*args)

def cosh(*args):
    """


    cosh(float x) -> float
    cosh(DM x) -> DM
    cosh(SX x) -> SX
    cosh(MX x) -> MX



    """
    return _casadi.cosh(*args)

def atanh(*args):
    """


    atanh(float x) -> float
    atanh(DM x) -> DM
    atanh(SX x) -> SX
    atanh(MX x) -> MX



    """
    return _casadi.atanh(*args)

def asinh(*args):
    """


    asinh(float x) -> float
    asinh(DM x) -> DM
    asinh(SX x) -> SX
    asinh(MX x) -> MX



    """
    return _casadi.asinh(*args)

def acosh(*args):
    """


    acosh(float x) -> float
    acosh(DM x) -> DM
    acosh(SX x) -> SX
    acosh(MX x) -> MX



    """
    return _casadi.acosh(*args)

def exp(*args):
    """


    exp(float x) -> float
    exp(DM x) -> DM
    exp(SX x) -> SX
    exp(MX x) -> MX



    """
    return _casadi.exp(*args)

def log(*args):
    """


    log(float x) -> float
    log(DM x) -> DM
    log(SX x) -> SX
    log(MX x) -> MX



    """
    return _casadi.log(*args)

def log10(*args):
    """


    log10(float x) -> float
    log10(DM x) -> DM
    log10(SX x) -> SX
    log10(MX x) -> MX



    """
    return _casadi.log10(*args)

def floor(*args):
    """


    floor(float x) -> float
    floor(DM x) -> DM
    floor(SX x) -> SX
    floor(MX x) -> MX



    """
    return _casadi.floor(*args)

def ceil(*args):
    """


    ceil(float x) -> float
    ceil(DM x) -> DM
    ceil(SX x) -> SX
    ceil(MX x) -> MX



    """
    return _casadi.ceil(*args)

def erf(*args):
    """


    erf(float x) -> float
    erf(DM x) -> DM
    erf(SX x) -> SX
    erf(MX x) -> MX



    """
    return _casadi.erf(*args)

def erfinv(*args):
    """


    erfinv(float x) -> float
    erfinv(DM x) -> DM
    erfinv(SX x) -> SX
    erfinv(MX x) -> MX



    """
    return _casadi.erfinv(*args)

def sign(*args):
    """


    sign(float x) -> float
    sign(DM x) -> DM
    sign(SX x) -> SX
    sign(MX x) -> MX



    """
    return _casadi.sign(*args)

def power(*args):
    """


    power(float x, float n) -> float
    power(DM x, DM n) -> DM
    power(SX x, SX n) -> SX
    power(MX x, MX n) -> MX



    """
    return _casadi.power(*args)

def mod(*args):
    """


    mod(float x, float y) -> float
    mod(DM x, DM y) -> DM
    mod(SX x, SX y) -> SX
    mod(MX x, MX y) -> MX



    """
    return _casadi.mod(*args)

def fmod(*args):
    """


    fmod(float x, float y) -> float
    fmod(DM x, DM y) -> DM
    fmod(SX x, SX y) -> SX
    fmod(MX x, MX y) -> MX



    """
    return _casadi.fmod(*args)

def atan2(*args):
    """


    atan2(float x, float y) -> float
    atan2(DM x, DM y) -> DM
    atan2(SX x, SX y) -> SX
    atan2(MX x, MX y) -> MX



    """
    return _casadi.atan2(*args)

def fmin(*args):
    """


    fmin(float x, float y) -> float
    fmin(DM x, DM y) -> DM
    fmin(SX x, SX y) -> SX
    fmin(MX x, MX y) -> MX



    """
    return _casadi.fmin(*args)

def fmax(*args):
    """


    fmax(float x, float y) -> float
    fmax(DM x, DM y) -> DM
    fmax(SX x, SX y) -> SX
    fmax(MX x, MX y) -> MX



    """
    return _casadi.fmax(*args)

def simplify(*args):
    """
    Simplify an expression.

    simplify(float x) -> float
    simplify(DM x) -> DM
    simplify(SX x) -> SX
    simplify(MX x) -> MX





    """
    return _casadi.simplify(*args)

def is_equal(*args):
    """


    is_equal(float x, float y, int depth) -> bool
    is_equal(DM x, DM y, int depth) -> bool
    is_equal(SX x, SX y, int depth) -> bool
    is_equal(MX x, MX y, int depth) -> bool



    """
    return _casadi.is_equal(*args)

def copysign(*args):
    """


    copysign(float x, float y) -> float
    copysign(DM x, DM y) -> DM
    copysign(SX x, SX y) -> SX
    copysign(MX x, MX y) -> MX



    """
    return _casadi.copysign(*args)

def constpow(*args):
    """


    constpow(float x, float y) -> float
    constpow(DM x, DM y) -> DM
    constpow(SX x, SX y) -> SX
    constpow(MX x, MX y) -> MX



    """
    return _casadi.constpow(*args)

def mpower(*args):
    """
    Matrix power x^n.

    mpower(DM x, DM n) -> DM
    mpower(SX x, SX n) -> SX
    mpower(MX x, MX n) -> MX





    """
    return _casadi.mpower(*args)

def mrdivide(*args):
    """
    Matrix divide (cf. slash '/' in MATLAB)

    mrdivide(DM x, DM y) -> DM
    mrdivide(SX x, SX y) -> SX
    mrdivide(MX x, MX y) -> MX





    """
    return _casadi.mrdivide(*args)

def mldivide(*args):
    """
    Matrix divide (cf. backslash '\\' in MATLAB)

    mldivide(DM x, DM y) -> DM
    mldivide(SX x, SX y) -> SX
    mldivide(MX x, MX y) -> MX





    """
    return _casadi.mldivide(*args)

def symvar(*args):
    """
      Get symbols present in expression.

      symvar(DM x) -> [DM]
      symvar(SX x) -> [SX]
      symvar(MX x) -> [MX]


    Returned vector is ordered according to the order of variable()/parameter()
    calls used to create the variables




    """
    return _casadi.symvar(*args)

def bilin(*args):
    """
    Calculate bilinear form x^T A y.

    bilin(DM A, DM x, DM y) -> DM
    bilin(SX A, SX x, SX y) -> SX
    bilin(MX A, MX x, MX y) -> MX





    """
    return _casadi.bilin(*args)

def rank1(*args):
    """
    Make a rank-1 update to a matrix A Calculates A + 1/2 * alpha * x*y'.

    rank1(DM A, DM alpha, DM x, DM y) -> DM
    rank1(SX A, SX alpha, SX x, SX y) -> SX
    rank1(MX A, MX alpha, MX x, MX y) -> MX





    """
    return _casadi.rank1(*args)

def sumsqr(*args):
    """
    Calculate sum of squares: sum_ij X_ij^2.

    sumsqr(DM X) -> DM
    sumsqr(SX X) -> SX
    sumsqr(MX X) -> MX





    """
    return _casadi.sumsqr(*args)

def linspace(*args):
    """
    Matlab's linspace command.

    linspace(DM a, DM b, int nsteps) -> DM
    linspace(SX a, SX b, int nsteps) -> SX
    linspace(MX a, MX b, int nsteps) -> MX





    """
    return _casadi.linspace(*args)

def interp1d(*args):
    """
      Performs 1d linear interpolation.

      interp1d([float] x, DM v, [float] xq, str mode, bool equidistant) -> DM
      interp1d([float] x, SX v, [float] xq, str mode, bool equidistant) -> SX
      interp1d([float] x, MX v, [float] xq, str mode, bool equidistant) -> MX


    The data-points to be interpolated are given as (x[i], v[i]). xq[j] is used
    as interplating value




    """
    return _casadi.interp1d(*args)

def soc(*args):
    """
      Construct second-order-convex.

      soc(DM x, DM y) -> DM
      soc(SX x, SX y) -> SX
      soc(MX x, MX y) -> MX


    Parameters:
    -----------

    x:  vector expression of size n

    y:  scalar expression

    soc(x,y) computes [y*eye(n) x; x' y]

    soc(x,y) positive semi definite <=> || x ||_2 <= y




    """
    return _casadi.soc(*args)

def cross(*args):
    """
    Matlab's cross command.

    cross(DM a, DM b, int dim) -> DM
    cross(SX a, SX b, int dim) -> SX
    cross(MX a, MX b, int dim) -> MX





    """
    return _casadi.cross(*args)

def skew(*args):
    """
    Generate a skew symmetric matrix from a 3-vector.

    skew(DM a) -> DM
    skew(SX a) -> SX
    skew(MX a) -> MX





    """
    return _casadi.skew(*args)

def inv_skew(*args):
    """
    Generate the 3-vector progenitor of a skew symmetric matrix.

    inv_skew(DM a) -> DM
    inv_skew(SX a) -> SX
    inv_skew(MX a) -> MX





    """
    return _casadi.inv_skew(*args)

def det(*args):
    """
    Matrix determinant (experimental)

    det(DM A) -> DM
    det(SX A) -> SX
    det(MX A) -> MX





    """
    return _casadi.det(*args)

def inv_minor(*args):
    """
    Matrix inverse (experimental)

    inv_minor(DM A) -> DM
    inv_minor(SX A) -> SX
    inv_minor(MX A) -> MX





    """
    return _casadi.inv_minor(*args)

def inv(*args):
    """
    Matrix inverse.

    inv(DM A) -> DM
    inv(SX A) -> SX
    inv(MX A) -> MX
    inv(DM A, str lsolver, dict opts) -> DM
    inv(SX A, str lsolver, dict opts) -> SX
    inv(MX A, str lsolver, dict opts) -> MX





    """
    return _casadi.inv(*args)

def trace(*args):
    """
    Matrix trace.

    trace(DM a) -> DM
    trace(SX a) -> SX
    trace(MX a) -> MX





    """
    return _casadi.trace(*args)

def tril2symm(*args):
    """
    Convert a lower triangular matrix to a symmetric one.

    tril2symm(DM a) -> DM
    tril2symm(SX a) -> SX
    tril2symm(MX a) -> MX





    """
    return _casadi.tril2symm(*args)

def triu2symm(*args):
    """
    Convert a upper triangular matrix to a symmetric one.

    triu2symm(DM a) -> DM
    triu2symm(SX a) -> SX
    triu2symm(MX a) -> MX





    """
    return _casadi.triu2symm(*args)

def norm_fro(*args):
    """
    Frobenius norm.

    norm_fro(DM x) -> DM
    norm_fro(SX x) -> SX
    norm_fro(MX x) -> MX





    """
    return _casadi.norm_fro(*args)

def norm_2(*args):
    """
    2-norm

    norm_2(DM x) -> DM
    norm_2(SX x) -> SX
    norm_2(MX x) -> MX





    """
    return _casadi.norm_2(*args)

def norm_1(*args):
    """
    1-norm

    norm_1(DM x) -> DM
    norm_1(SX x) -> SX
    norm_1(MX x) -> MX





    """
    return _casadi.norm_1(*args)

def norm_inf(*args):
    """
    Infinity-norm.

    norm_inf(DM x) -> DM
    norm_inf(SX x) -> SX
    norm_inf(MX x) -> MX





    """
    return _casadi.norm_inf(*args)

def dot(*args):
    """
    Inner product of two matrices with x and y matrices of the same dimension.

    dot(DM x, DM y) -> DM
    dot(SX x, SX y) -> SX
    dot(MX x, MX y) -> MX





    """
    return _casadi.dot(*args)

def nullspace(*args):
    """
      Computes the nullspace of a matrix A.

      nullspace(DM A) -> DM
      nullspace(SX A) -> SX
      nullspace(MX A) -> MX


    Finds Z m-by-(m-n) such that AZ = 0 with A n-by-m with m > n

    Assumes A is full rank

    Inspired by Numerical Methods in Scientific Computing by Ake Bjorck




    """
    return _casadi.nullspace(*args)

def polyval(*args):
    """
    Evaluate a polynomial with coefficients p in x.

    polyval(DM p, DM x) -> DM
    polyval(SX p, SX x) -> SX
    polyval(MX p, MX x) -> MX





    """
    return _casadi.polyval(*args)

def diag(*args):
    """
    Create diagonal sparsity pattern.

    diag(DM A) -> DM
    diag(SX A) -> SX
    diag(MX A) -> MX





    """
    return _casadi.diag(*args)

def unite(*args):
    """
    Union of two sparsity patterns.

    unite(DM A, DM B) -> DM
    unite(SX A, SX B) -> SX
    unite(MX A, MX B) -> MX





    """
    return _casadi.unite(*args)

def densify(*args):
    """
    Make the matrix dense and assign nonzeros to a value.

    densify(DM x) -> DM
    densify(SX x) -> SX
    densify(MX x) -> MX





    """
    return _casadi.densify(*args)

def project(*args):
    """
      Create a new matrix with a given sparsity pattern but with the nonzeros

      project(DM A, Sparsity sp, bool intersect) -> DM
      project(SX A, Sparsity sp, bool intersect) -> SX
      project(MX A, Sparsity sp, bool intersect) -> MX

    taken from an existing matrix.




    """
    return _casadi.project(*args)

def if_else(*args):
    """
    Branching on MX nodes Ternary operator, "cond ? if_true : if_false".

    if_else(DM cond, DM if_true, DM if_false, bool short_circuit) -> DM
    if_else(SX cond, SX if_true, SX if_false, bool short_circuit) -> SX
    if_else(MX cond, MX if_true, MX if_false, bool short_circuit) -> MX





    """
    return _casadi.if_else(*args)

def conditional(*args):
    """
      Create a switch.

      conditional(DM ind, [DM] x, DM x_default, bool short_circuit) -> DM
      conditional(SX ind, [SX] x, SX x_default, bool short_circuit) -> SX
      conditional(MX ind, [MX] x, MX x_default, bool short_circuit) -> MX


    If the condition

    Parameters:
    -----------

    ind:  evaluates to the integer k, where 0<=k<f.size(), then x[k] will be
    returned, otherwise

    x_default:  will be returned.




    """
    return _casadi.conditional(*args)

def depends_on(*args):
    """
    Check if expression depends on the argument The argument must be symbolic.

    depends_on(DM f, DM arg) -> bool
    depends_on(SX f, SX arg) -> bool
    depends_on(MX f, MX arg) -> bool





    """
    return _casadi.depends_on(*args)

def solve(*args):
    """
    Solve the QP.

    solve(DM A, DM b) -> DM
    solve(SX A, SX b) -> SX
    solve(MX A, MX b) -> MX
    solve(DM A, DM b, str lsolver, dict opts) -> DM
    solve(SX A, SX b, str lsolver, dict opts) -> SX
    solve(MX A, MX b, str lsolver, dict opts) -> MX





    """
    return _casadi.solve(*args)

def pinv(*args):
    """
      Computes the Moore-Penrose pseudo-inverse.

      pinv(DM A) -> DM
      pinv(SX A) -> SX
      pinv(MX A) -> MX
      pinv(DM A, str lsolver, dict opts) -> DM
      pinv(SX A, str lsolver, dict opts) -> SX
      pinv(MX A, str lsolver, dict opts) -> MX


    If the matrix A is fat (size1>size2), mul(A, pinv(A)) is unity. If the
    matrix A is slender (size2<size1), mul(pinv(A), A) is unity.




    """
    return _casadi.pinv(*args)

def expm_const(*args):
    """


    expm_const(DM A, DM t) -> DM
    expm_const(SX A, SX t) -> SX
    expm_const(MX A, MX t) -> MX



    """
    return _casadi.expm_const(*args)

def expm(*args):
    """


    expm(DM A) -> DM
    expm(SX A) -> SX
    expm(MX A) -> MX



    """
    return _casadi.expm(*args)

def jacobian(*args):
    """
    Calculate Jacobian.

    jacobian(DM ex, DM arg, dict opts) -> DM
    jacobian(SX ex, SX arg, dict opts) -> SX
    jacobian(MX ex, MX arg, dict opts) -> MX





    """
    return _casadi.jacobian(*args)

def jtimes(*args):
    """
      Calculate the Jacobian and multiply by a vector from the right This is

      jtimes(DM ex, DM arg, DM v, bool tr) -> DM
      jtimes(SX ex, SX arg, SX v, bool tr) -> SX
      jtimes(MX ex, MX arg, MX v, bool tr) -> MX

    equivalent to mul(jacobian(ex, arg), v) or mul(jacobian(ex, arg).T, v) for
    tr set to false and true respectively. If contrast to these expressions, it
    will use directional derivatives which is typically (but not necessarily)
    more efficient if the complete Jacobian is not needed and v has few rows.




    """
    return _casadi.jtimes(*args)

def linearize(*args):
    """
    Linearize an expression.

    linearize(DM f, DM x, DM x0) -> DM
    linearize(SX f, SX x, SX x0) -> SX
    linearize(MX f, MX x, MX x0) -> MX





    """
    return _casadi.linearize(*args)

def which_depends(*args):
    """
    Find out which variables enter with some order.

    which_depends(DM expr, DM var, int order, bool tr) -> [bool]
    which_depends(SX expr, SX var, int order, bool tr) -> [bool]
    which_depends(MX expr, MX var, int order, bool tr) -> [bool]





    """
    return _casadi.which_depends(*args)

def is_linear(*args):
    """
      Is expr linear in var?

      is_linear(DM expr, DM var) -> bool
      is_linear(SX expr, SX var) -> bool
      is_linear(MX expr, MX var) -> bool


    False negatives are possible (an expression may not be recognised as linear
    while it really is), false positives not.




    """
    return _casadi.is_linear(*args)

def is_quadratic(*args):
    """
      Is expr quadratic in var?

      is_quadratic(DM expr, DM var) -> bool
      is_quadratic(SX expr, SX var) -> bool
      is_quadratic(MX expr, MX var) -> bool


    False negatives are possible (an expression may not be recognised as
    quadratic while it really is), false positives not.




    """
    return _casadi.is_quadratic(*args)

def gradient(*args):
    """
    Calculate Jacobian.

    gradient(DM ex, DM arg) -> DM
    gradient(SX ex, SX arg) -> SX
    gradient(MX ex, MX arg) -> MX





    """
    return _casadi.gradient(*args)

def tangent(*args):
    """
    Calculate Jacobian.

    tangent(DM ex, DM arg) -> DM
    tangent(SX ex, SX arg) -> SX
    tangent(MX ex, MX arg) -> MX





    """
    return _casadi.tangent(*args)

def hessian(*args):
    """


    hessian(DM ex, DM arg) -> (DM , DM OUTPUT1)
    hessian(SX ex, SX arg) -> (SX , SX OUTPUT1)
    hessian(MX ex, MX arg) -> (MX , MX OUTPUT1)



    """
    return _casadi.hessian(*args)

def quadratic_coeff(*args):
    """
      Recognizes quadratic form in scalar expression.

      quadratic_coeff(DM ex, DM arg, bool check) -> (DM OUTPUT1, DM OUTPUT2, DM OUTPUT3)
      quadratic_coeff(SX ex, SX arg, bool check) -> (SX OUTPUT1, SX OUTPUT2, SX OUTPUT3)
      quadratic_coeff(MX ex, MX arg, bool check) -> (MX OUTPUT1, MX OUTPUT2, MX OUTPUT3)


    1/2*x' A x + b' x + c

    e = 0.5*bilin(A,x,x)+dot(b,x)+c

    Parameters:
    -----------

    check[in]:  When true (default), A is checked to be independent of x.
    Provided to deal with false positive dependency checks.




    """
    return _casadi.quadratic_coeff(*args)

def linear_coeff(*args):
    """
      Recognizes linear form in vector expression.

      linear_coeff(DM ex, DM arg, bool check) -> (DM OUTPUT1, DM OUTPUT2)
      linear_coeff(SX ex, SX arg, bool check) -> (SX OUTPUT1, SX OUTPUT2)
      linear_coeff(MX ex, MX arg, bool check) -> (MX OUTPUT1, MX OUTPUT2)


    A x + b

    Parameters:
    -----------

    check[in]:  When true (default)m, A is checked to be independent of x.
    Provided to deal with false positive dependency checks.




    """
    return _casadi.linear_coeff(*args)

def n_nodes(*args):
    """


    n_nodes(DM A) -> int
    n_nodes(SX A) -> int
    n_nodes(MX A) -> int



    """
    return _casadi.n_nodes(*args)

def print_operator(*args):
    """
    Get a string representation for a binary MatType, using custom arguments.

    print_operator(DM xb, [str] args) -> str
    print_operator(SX xb, [str] args) -> str
    print_operator(MX xb, [str] args) -> str





    """
    return _casadi.print_operator(*args)

def repsum(*args):
    """
    Given a repeated matrix, computes the sum of repeated parts.

    repsum(DM A, int n, int m) -> DM
    repsum(SX A, int n, int m) -> SX
    repsum(MX A, int n, int m) -> MX





    """
    return _casadi.repsum(*args)

def diff(*args):
    """
    Returns difference (n-th order) along given axis (MATLAB convention)

    diff(DM A, int n, int axis) -> DM
    diff(SX A, int n, int axis) -> SX
    diff(MX A, int n, int axis) -> MX





    """
    return _casadi.diff(*args)

def cumsum(*args):
    """
    Returns cumulative sum along given axis (MATLAB convention)

    cumsum(DM A, int axis) -> DM
    cumsum(SX A, int axis) -> SX
    cumsum(MX A, int axis) -> MX





    """
    return _casadi.cumsum(*args)

def einstein(*args):
    """
      Computes an einstein dense tensor contraction.

      einstein(DM A, DM B, [int] dim_a, [int] dim_b, [int] dim_c, [int] a, [int] b, [int] c) -> DM
      einstein(SX A, SX B, [int] dim_a, [int] dim_b, [int] dim_c, [int] a, [int] b, [int] c) -> SX
      einstein(MX A, MX B, [int] dim_a, [int] dim_b, [int] dim_c, [int] a, [int] b, [int] c) -> MX
      einstein(DM A, DM B, DM C, [int] dim_a, [int] dim_b, [int] dim_c, [int] a, [int] b, [int] c) -> DM
      einstein(SX A, SX B, SX C, [int] dim_a, [int] dim_b, [int] dim_c, [int] a, [int] b, [int] c) -> SX
      einstein(MX A, MX B, MX C, [int] dim_a, [int] dim_b, [int] dim_c, [int] a, [int] b, [int] c) -> MX


    Computes the product: C_c = A_a + B_b where a b c are index/einstein
    notation in an encoded form

    For example, an matrix-matrix product may be written as: C_ij = A_ik B_kj

    The encoded form uses strictly negative numbers to indicate labels. For the
    above example, we would have: a {-1, -3} b {-3, -2} c {-1 -2}




    """
    return _casadi.einstein(*args)

def mmin(*args):
    """
    Smallest element in a matrix.

    mmin(DM x) -> DM
    mmin(SX x) -> SX
    mmin(MX x) -> MX





    """
    return _casadi.mmin(*args)

def mmax(*args):
    """
    Largest element in a matrix.

    mmax(DM x) -> DM
    mmax(SX x) -> SX
    mmax(MX x) -> MX





    """
    return _casadi.mmax(*args)

def evalf(*args):
    """
      Evaluates the expression numerically.

      evalf(DM x) -> DM
      evalf(SX x) -> DM
      evalf(MX x) -> DM


    An error is raised when the expression contains symbols




    """
    return _casadi.evalf(*args)

def forward(*args):
    """
    Forward directional derivative.

    forward([DM] ex, [DM] arg, [[DM]] v, dict opts) -> [[DM]]
    forward([SX] ex, [SX] arg, [[SX]] v, dict opts) -> [[SX]]
    forward([MX] ex, [MX] arg, [[MX]] v, dict opts) -> [[MX]]





    """
    return _casadi.forward(*args)

def reverse(*args):
    """
    Reverse directional derivative.

    reverse([DM] ex, [DM] arg, [[DM]] v, dict opts) -> [[DM]]
    reverse([SX] ex, [SX] arg, [[SX]] v, dict opts) -> [[SX]]
    reverse([MX] ex, [MX] arg, [[MX]] v, dict opts) -> [[MX]]





    """
    return _casadi.reverse(*args)

def substitute(*args):
    """
    Substitute variable var with expression expr in multiple expressions.

    substitute(DM ex, DM v, DM vdef) -> DM
    substitute([DM] ex, [DM] v, [DM] vdef) -> [DM]
    substitute(SX ex, SX v, SX vdef) -> SX
    substitute([SX] ex, [SX] v, [SX] vdef) -> [SX]
    substitute(MX ex, MX v, MX vdef) -> MX
    substitute([MX] ex, [MX] v, [MX] vdef) -> [MX]





    """
    return _casadi.substitute(*args)

def substitute_inplace(*args):
    """
      Inplace substitution with piggyback expressions Substitute variables v out

      substitute_inplace([DM] v, bool reverse) -> ([DM] INOUT1, [DM] INOUT2)
      substitute_inplace([SX] v, bool reverse) -> ([SX] INOUT1, [SX] INOUT2)
      substitute_inplace([MX] v, bool reverse) -> ([MX] INOUT1, [MX] INOUT2)

    of the expressions vdef sequentially, as well as out of a number of other
    expressions piggyback.




    """
    return _casadi.substitute_inplace(*args)

def shared(*args):
    """
    Get a shared (owning) reference.

    shared([DM] ex, str v_prefix, str v_suffix) -> ([DM] OUTPUT1, [DM] OUTPUT2, [DM] OUTPUT3)
    shared([SX] ex, str v_prefix, str v_suffix) -> ([SX] OUTPUT1, [SX] OUTPUT2, [SX] OUTPUT3)
    shared([MX] ex, str v_prefix, str v_suffix) -> ([MX] OUTPUT1, [MX] OUTPUT2, [MX] OUTPUT3)





    """
    return _casadi.shared(*args)

def blockcat(*args):
    """


    blockcat([[DM]] v) -> DM
    blockcat([[SX]] v) -> SX
    blockcat([[MX]] v) -> MX
    blockcat(Sparsity A, Sparsity B, Sparsity C, Sparsity D) -> Sparsity
    blockcat(DM A, DM B, DM C, DM D) -> DM
    blockcat(SX A, SX B, SX C, SX D) -> SX
    blockcat(MX A, MX B, MX C, MX D) -> MX



    """
    return _casadi.blockcat(*args)

def logic_all(*args):
    """
    Get a vector of indices (nested slice)

    logic_all(DM x) -> DM
    logic_all(SX x) -> SX





    """
    return _casadi.logic_all(*args)

def logic_any(*args):
    """
    Returns true only if any element in the matrix is true.

    logic_any(DM x) -> DM
    logic_any(SX x) -> SX





    """
    return _casadi.logic_any(*args)

def adj(*args):
    """
    Matrix adjoint.

    adj(DM A) -> DM
    adj(SX A) -> SX





    """
    return _casadi.adj(*args)

def minor(*args):
    """
    Get the (i,j) minor matrix.

    minor(DM x, int i, int j) -> DM
    minor(SX x, int i, int j) -> SX





    """
    return _casadi.minor(*args)

def cofactor(*args):
    """
    Get the (i,j) cofactor matrix.

    cofactor(DM x, int i, int j) -> DM
    cofactor(SX x, int i, int j) -> SX





    """
    return _casadi.cofactor(*args)

def qr(*args):
    """
      QR factorization using the modified Gram-Schmidt algorithm More stable than

      qr(DM A) -> (DM OUTPUT1, DM OUTPUT2)
      qr(SX A) -> (SX OUTPUT1, SX OUTPUT2)

    the classical Gram-Schmidt, but may break down if the rows of A are nearly
    linearly dependent See J. Demmel: Applied Numerical Linear Algebra
    (algorithm 3.1.). Note that in SWIG, Q and R are returned by value.




    """
    return _casadi.qr(*args)

def qr_sparse(*args):
    """
      Symbolic QR factorization Returns the sparsity pattern of V (compact

      qr_sparse(DM A, bool amd) -> (DM OUTPUT1, DM OUTPUT2, DM OUTPUT3, [int] OUTPUT4, [int] OUTPUT5)
      qr_sparse(SX A, bool amd) -> (SX OUTPUT1, SX OUTPUT2, SX OUTPUT3, [int] OUTPUT4, [int] OUTPUT5)

    representation of Q) and R as well as vectors needed for the numerical
    factorization and solution. The implementation is a modified version of
    CSparse Copyright(c) Timothy A. Davis, 2006-2009 Licensed as a derivative
    work under the GNU LGPL.




    """
    return _casadi.qr_sparse(*args)

def qr_solve(*args):
    """
    Solve using a sparse QR factorization.

    qr_solve(DM b, DM v, DM r, DM beta, [int] prinv, [int] pc, bool tr) -> DM
    qr_solve(SX b, SX v, SX r, SX beta, [int] prinv, [int] pc, bool tr) -> SX





    """
    return _casadi.qr_solve(*args)

def ldl(*args):
    """
      Symbolic LDL factorization Returns the sparsity pattern of L^T.

      ldl(DM A, bool amd) -> (DM OUTPUT1, DM OUTPUT2, [int] OUTPUT3)
      ldl(SX A, bool amd) -> (SX OUTPUT1, SX OUTPUT2, [int] OUTPUT3)


    The implementation is a modified version of LDL Copyright(c) Timothy A.
    Davis, 2005-2013 Licensed as a derivative work under the GNU LGPL




    """
    return _casadi.ldl(*args)

def ldl_solve(*args):
    """
    Solve using a sparse LDL^T factorization.

    ldl_solve(DM b, DM D, DM LT, [int] p) -> DM
    ldl_solve(SX b, SX D, SX LT, [int] p) -> SX





    """
    return _casadi.ldl_solve(*args)

def chol(*args):
    """
      Obtain a Cholesky factorisation of a matrix Performs and LDL transformation

      chol(DM A) -> DM
      chol(SX A) -> SX

    [L,D] = ldl(A) and returns diag(sqrt(D))*L'.




    """
    return _casadi.chol(*args)

def norm_inf_mul(*args):
    """
    Inf-norm of a Matrix-Matrix product.

    norm_inf_mul(DM x, DM y) -> DM
    norm_inf_mul(SX x, SX y) -> SX





    """
    return _casadi.norm_inf_mul(*args)

def sparsify(*args):
    """
    Make a matrix sparse by removing numerical zeros.

    sparsify(DM A, float tol) -> DM
    sparsify(SX A, float tol) -> SX





    """
    return _casadi.sparsify(*args)

def expand(*args):
    """
    Expand the expression as a weighted sum (with constant weights)

    expand(DM ex) -> (DM OUTPUT1, DM OUTPUT2)
    expand(SX ex) -> (SX OUTPUT1, SX OUTPUT2)





    """
    return _casadi.expand(*args)

def pw_const(*args):
    """
      Create a piecewise constant function Create a piecewise constant function

      pw_const(DM t, DM tval, DM val) -> DM
      pw_const(SX t, SX tval, SX val) -> SX

    with n=val.size() intervals.

    Inputs:

    Parameters:
    -----------

    t:  a scalar variable (e.g. time)

    tval:  vector with the discrete values of t at the interval transitions
    (length n-1)

    val:  vector with the value of the function for each interval (length n)




    """
    return _casadi.pw_const(*args)

def pw_lin(*args):
    """
      t a scalar variable (e.g. time)

      pw_lin(DM t, DM tval, DM val) -> DM
      pw_lin(SX t, SX tval, SX val) -> SX


    Create a piecewise linear function Create a piecewise linear function:

    Inputs: tval vector with the the discrete values of t (monotonically
    increasing) val vector with the corresponding function values (same length
    as tval)




    """
    return _casadi.pw_lin(*args)

def heaviside(*args):
    """
      Heaviside function.

      heaviside(DM x) -> DM
      heaviside(SX x) -> SX


    \\[ \\begin {cases} H(x) = 0 & x<0 \\\\ H(x) = 1/2 & x=0 \\\\
    H(x) = 1 & x>0 \\\\ \\end {cases} \\]




    """
    return _casadi.heaviside(*args)

def rectangle(*args):
    """
      rectangle function

      rectangle(DM x) -> DM
      rectangle(SX x) -> SX


    \\[ \\begin {cases} \\Pi(x) = 1 & |x| < 1/2 \\\\ \\Pi(x) = 1/2 &
    |x| = 1/2 \\\\ \\Pi(x) = 0 & |x| > 1/2 \\\\ \\end {cases} \\]

    Also called: gate function, block function, band function, pulse function,
    window function




    """
    return _casadi.rectangle(*args)

def triangle(*args):
    """
      triangle function

      triangle(DM x) -> DM
      triangle(SX x) -> SX


    \\[ \\begin {cases} \\Lambda(x) = 0 & |x| >= 1 \\\\ \\Lambda(x)
    = 1-|x| & |x| < 1 \\end {cases} \\]




    """
    return _casadi.triangle(*args)

def ramp(*args):
    """
      ramp function

      ramp(DM x) -> DM
      ramp(SX x) -> SX


    \\[ \\begin {cases} R(x) = 0 & x <= 1 \\\\ R(x) = x & x > 1 \\\\
    \\end {cases} \\]

    Also called: slope function




    """
    return _casadi.ramp(*args)

def gauss_quadrature(*args):
    """
    Matrix adjoint.

    gauss_quadrature(DM f, DM x, DM a, DM b, int order) -> DM
    gauss_quadrature(SX f, SX x, SX a, SX b, int order) -> SX
    gauss_quadrature(DM f, DM x, DM a, DM b, int order, DM w) -> DM
    gauss_quadrature(SX f, SX x, SX a, SX b, int order, SX w) -> SX





    """
    return _casadi.gauss_quadrature(*args)

def taylor(*args):
    """
      univariate Taylor series expansion

      taylor(DM ex, DM x, DM a, int order) -> DM
      taylor(SX ex, SX x, SX a, int order) -> SX


    Calculate the Taylor expansion of expression 'ex' up to order 'order' with
    respect to variable 'x' around the point 'a'

    $(x)=f(a)+f'(a)(x-a)+f''(a)\\frac
    {(x-a)^2}{2!}+f'''(a)\\frac{(x-a)^3}{3!}+\\ldots$

    Example usage:

    ::

    >>   x






    """
    return _casadi.taylor(*args)

def mtaylor(*args):
    """
      multivariate Taylor series expansion

      mtaylor(DM ex, DM x, DM a, int order) -> DM
      mtaylor(SX ex, SX x, SX a, int order) -> SX
      mtaylor(DM ex, DM x, DM a, int order, [int] order_contributions) -> DM
      mtaylor(SX ex, SX x, SX a, int order, [int] order_contributions) -> SX


    Do Taylor expansions until the aggregated order of a term is equal to
    'order'. The aggregated order of $x^n y^m$ equals $n+m$.

    The argument order_contributions can denote how match each variable
    contributes to the aggregated order. If x=[x, y] and order_contributions=[1,
    2], then the aggregated order of $x^n y^m$ equals $1n+2m$.

    Example usage

    $ \\sin(b+a)+\\cos(b+a)(x-a)+\\cos(b+a)(y-b) $ $ y+x-(x^3+3y x^2+3 y^2
    x+y^3)/6 $ $ (-3 x^2 y-x^3)/6+y+x $




    """
    return _casadi.mtaylor(*args)

def poly_coeff(*args):
    """
      extracts polynomial coefficients from an expression

      poly_coeff(DM ex, DM x) -> DM
      poly_coeff(SX ex, SX x) -> SX


    Parameters:
    -----------

    ex:  Scalar expression that represents a polynomial

    x:  Scalar symbol that the polynomial is build up with




    """
    return _casadi.poly_coeff(*args)

def poly_roots(*args):
    """
      Attempts to find the roots of a polynomial.

      poly_roots(DM p) -> DM
      poly_roots(SX p) -> SX


    This will only work for polynomials up to order 3 It is assumed that the
    roots are real.




    """
    return _casadi.poly_roots(*args)

def eig_symbolic(*args):
    """
      Attempts to find the eigenvalues of a symbolic matrix This will only work

      eig_symbolic(DM m) -> DM
      eig_symbolic(SX m) -> SX

    for up to 3x3 matrices.




    """
    return _casadi.eig_symbolic(*args)

def find(*args):
    """
      Get the location of all non-zero elements as they would appear in a Dense

      find(MX x) -> MX

    matrix A : DenseMatrix 4 x 3 B : SparseMatrix 4 x 3 , 5 structural non-
    zeros.

    k = A.find() A[k] will contain the elements of A that are non-zero in B

    Inverse of nonzeros.




    """
    return _casadi.find(*args)

def low(*args):
    """
    Find first nonzero If failed, returns the number of rows.

    low(MX v, MX p, dict options) -> MX





    """
    return _casadi.low(*args)

def inv_node(*args):
    """
    Inverse node.

    inv_node(MX x) -> MX





    """
    return _casadi.inv_node(*args)

def matrix_expand(*args):
    """
      Expand MX graph to SXFunction call.

      matrix_expand(MX e, [MX] boundary, dict options) -> MX
      matrix_expand([MX] e, [MX] boundary, dict options) -> [MX]


    Expand the given expression e, optionally supplying expressions contained in
    it at which expansion should stop.




    """
    return _casadi.matrix_expand(*args)

def graph_substitute(*args):
    """
      Substitute multiple expressions in graph Substitute variable var with

      graph_substitute(MX ex, [MX] v, [MX] vdef) -> MX
      graph_substitute([MX] ex, [MX] v, [MX] vdef) -> [MX]

    expression expr in multiple expressions, preserving nodes.




    """
    return _casadi.graph_substitute(*args)

def bspline(*args):
    """
    Find first nonzero If failed, returns the number of rows.

    bspline(MX x, DM coeffs, [[float]] knots, [int] degree, int m, dict opts) -> MX
    bspline(MX x, MX coeffs, [[float]] knots, [int] degree, int m, dict opts) -> MX





    """
    return _casadi.bspline(*args)

def convexify(*args):
    """
    Find first nonzero If failed, returns the number of rows.

    convexify(MX H, dict opts) -> MX





    """
    return _casadi.convexify(*args)
class Importer(SharedObject, PrintableCommon):
    """
      Importer.



    Just-in-time compilation of code

    General information
    ===================



    List of plugins
    ===============



    - clang

    - shell

    Note: some of the plugins in this list might not be available on your
    system. Also, there might be extra plugins available to you that are not
    listed here. You can obtain their documentation with
    Importer.doc("myextraplugin")



    --------------------------------------------------------------------------------

    clang
    -----



    Interface to the JIT compiler CLANG

    >List of available options

    +--------------+-----------------+-----------------------------------------+
    |      Id      |      Type       |               Description               |
    +==============+=================+=========================================+
    | flags        | OT_STRINGVECTOR | Compile flags for the JIT compiler.     |
    |              |                 | Default: None                           |
    +--------------+-----------------+-----------------------------------------+
    | include_path | OT_STRING       | Include paths for the JIT compiler. The |
    |              |                 | include directory shipped with CasADi   |
    |              |                 | will be automatically appended.         |
    +--------------+-----------------+-----------------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    shell
    -----



    Interface to the JIT compiler SHELL

    >List of available options

    +----------------------+-----------------+---------------------------------+
    |          Id          |      Type       |           Description           |
    +======================+=================+=================================+
    | cleanup              | OT_BOOL         | Cleanup temporary files when    |
    |                      |                 | unloading. Default: true        |
    +----------------------+-----------------+---------------------------------+
    | compiler             | OT_STRING       | Compiler command                |
    +----------------------+-----------------+---------------------------------+
    | compiler_flags       | OT_STRINGVECTOR | Alias for 'compiler_flags'      |
    +----------------------+-----------------+---------------------------------+
    | compiler_output_flag | OT_STRING       | Compiler flag to denote object  |
    |                      |                 | output. Default: '-o '          |
    +----------------------+-----------------+---------------------------------+
    | compiler_setup       | OT_STRING       | Compiler setup command.         |
    |                      |                 | Intended to be fixed. The       |
    |                      |                 | 'flag' option is the prefered   |
    |                      |                 | way to set custom flags.        |
    +----------------------+-----------------+---------------------------------+
    | extra_suffixes       | OT_STRINGVECTOR | List of suffixes for extra      |
    |                      |                 | files that the compiler may     |
    |                      |                 | generate. Default: None         |
    +----------------------+-----------------+---------------------------------+
    | flags                | OT_STRINGVECTOR | Compile flags for the JIT       |
    |                      |                 | compiler. Default: None         |
    +----------------------+-----------------+---------------------------------+
    | folder               | OT_STRING       | Folder to put temporary objects |
    |                      |                 | in.                             |
    +----------------------+-----------------+---------------------------------+
    | linker               | OT_STRING       | Linker command                  |
    +----------------------+-----------------+---------------------------------+
    | linker_flags         | OT_STRINGVECTOR | Linker flags for the JIT        |
    |                      |                 | compiler. Default: None         |
    +----------------------+-----------------+---------------------------------+
    | linker_output_flag   | OT_STRING       | Linker flag to denote shared    |
    |                      |                 | library output. Default: '-o '  |
    +----------------------+-----------------+---------------------------------+
    | linker_setup         | OT_STRING       | Linker setup command. Intended  |
    |                      |                 | to be fixed. The 'flag' option  |
    |                      |                 | is the prefered way to set      |
    |                      |                 | custom flags.                   |
    +----------------------+-----------------+---------------------------------+
    | name                 | OT_STRING       | The file name used to write out |
    |                      |                 | compiled objects/libraries. The |
    |                      |                 | actual file names used depend   |
    |                      |                 | on 'temp_suffix' and include    |
    |                      |                 | extensions. Default:            |
    |                      |                 | 'tmp_casadi_compiler_shell'     |
    +----------------------+-----------------+---------------------------------+
    | temp_suffix          | OT_BOOL         | Use a temporary (seemingly      |
    |                      |                 | random) filename suffix for     |
    |                      |                 | file names. This is desired for |
    |                      |                 | thread-safety. This behaviour   |
    |                      |                 | may defeat caching compiler     |
    |                      |                 | wrappers. Default: true         |
    +----------------------+-----------------+---------------------------------+

    --------------------------------------------------------------------------------



    Joris Gillis

    C++ includes: importer.hpp 


    """

    __swig_setmethods__ = {}
    for _s in [SharedObject, PrintableCommon]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Importer, name, value)
    __swig_getmethods__ = {}
    for _s in [SharedObject, PrintableCommon]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Importer, name)
    __repr__ = _swig_repr

    def type_name(*args):
        """


        type_name() -> str



        """
        return _casadi.Importer_type_name(*args)

    type_name = staticmethod(type_name)

    def test_cast(*args):
        """


        test_cast(casadi::SharedObjectInternal const * ptr) -> bool



        """
        return _casadi.Importer_test_cast(*args)

    test_cast = staticmethod(test_cast)

    def has_plugin(*args):
        """


        has_plugin(str name) -> bool



        """
        return _casadi.Importer_has_plugin(*args)

    has_plugin = staticmethod(has_plugin)

    def load_plugin(*args):
        """


        load_plugin(str name)



        """
        return _casadi.Importer_load_plugin(*args)

    load_plugin = staticmethod(load_plugin)

    def doc(*args):
        """


        doc(str name) -> str



        """
        return _casadi.Importer_doc(*args)

    doc = staticmethod(doc)

    def plugin_name(self, *args):
        """
        Query plugin name.

        plugin_name(self) -> str





        """
        return _casadi.Importer_plugin_name(self, *args)


    def has_function(self, *args):
        """


        has_function(self, str symname) -> bool



        """
        return _casadi.Importer_has_function(self, *args)


    def has_meta(self, *args):
        """
        Does a meta entry exist?

        has_meta(self, str cmd, int ind) -> bool





        """
        return _casadi.Importer_has_meta(self, *args)


    def get_meta(self, *args):
        """
        Get entry as a text.

        get_meta(self, str cmd, int ind) -> str





        """
        return _casadi.Importer_get_meta(self, *args)


    def inlined(self, *args):
        """
        Check if a function is inlined.

        inlined(self, str symname) -> bool





        """
        return _casadi.Importer_inlined(self, *args)


    def body(self, *args):
        """
        Get the function body, if inlined.

        body(self, str symname) -> str





        """
        return _casadi.Importer_body(self, *args)


    def library(self, *args):
        """
        Get library name.

        library(self) -> str





        """
        return _casadi.Importer_library(self, *args)


    def serialize(self, *args):
        """
        Serialize an object.

        serialize(self, casadi::SerializingStream & s)





        """
        return _casadi.Importer_serialize(self, *args)


    def deserialize(*args):
        """


        deserialize(casadi::DeserializingStream & s) -> Importer



        """
        return _casadi.Importer_deserialize(*args)

    deserialize = staticmethod(deserialize)

    def __init__(self, *args):
        """


          Importer()
          Importer(Importer other)
          Importer(str name, str compiler, dict opts)


        .......

        ::

          Importer(Importer other)



        .............


        .......

        ::

          Importer(str name, str compiler, dict opts)



        Importer factory.



        .............


        .......

        ::

          Importer()



        Default constructor.



        .............



        """
        this = _casadi.new_Importer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_Importer
Importer_swigregister = _casadi.Importer_swigregister
Importer_swigregister(Importer)

def Importer_type_name(*args):
    """


    type_name() -> str



    """
    return _casadi.Importer_type_name(*args)

def Importer_test_cast(*args):
    """


    test_cast(casadi::SharedObjectInternal const * ptr) -> bool



    """
    return _casadi.Importer_test_cast(*args)

def Importer_has_plugin(*args):
    """


    has_plugin(str name) -> bool



    """
    return _casadi.Importer_has_plugin(*args)

def Importer_load_plugin(*args):
    """


    load_plugin(str name)



    """
    return _casadi.Importer_load_plugin(*args)

def Importer_doc(*args):
    """


    doc(str name) -> str



    """
    return _casadi.Importer_doc(*args)

def Importer_deserialize(*args):
    """


    deserialize(casadi::DeserializingStream & s) -> Importer



    """
    return _casadi.Importer_deserialize(*args)

class Callback(Function):
    """
      Callback function functionality.



    This class provides a public API to the FunctionInternal class that can be
    subclassed by the user, who is then able to implement the different virtual
    method. Note that the Function class also provides a public API to
    FunctionInternal, but only allows calling, not being called.

    The user is responsible for not deleting this class for the lifetime of the
    internal function object.

    Joris Gillis, Joel Andersson

    C++ includes: callback.hpp 


    """

    __swig_setmethods__ = {}
    for _s in [Function]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Callback, name, value)
    __swig_getmethods__ = {}
    for _s in [Function]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Callback, name)
    __repr__ = _swig_repr

    def type_name(*args):
        """


        type_name() -> str



        """
        return _casadi.Callback_type_name(*args)

    type_name = staticmethod(type_name)

    def __init__(self, *args):
        """
          Copy constructor (throws an error)

          Callback(self)
          Callback(self, Callback obj)




        .......

        ::

          Callback(self)



        Default constructor.



        .............


        .......

        ::

          Callback(self, Callback obj)



        Copy constructor (throws an error)



        .............



        """
        if self.__class__ == Callback:
            _self = None
        else:
            _self = self
        this = _casadi.new_Callback(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_Callback

    def construct(self, *args):
        """
          Construct internal object This is the step that actually construct the

          construct(self, str name, dict opts)

        internal object, as the class constructor only creates a null pointer. It
        should be called from the user constructor.




        """
        return _casadi.Callback_construct(self, *args)


    def init(self, *args):
        """
          Initialize the object This function is called after the object construction

          init(self)

        (for the whole class hierarchy) is complete, but before the finalization
        step. It is called recursively for the whole class hierarchy, starting with
        the lowest level.




        """
        return _casadi.Callback_init(self, *args)


    def finalize(self, *args):
        """
          Finalize the object This function is called after the construction and init

          finalize(self)

        steps are completed, but before user functions are called. It is called
        recursively for the whole class hierarchy, starting with the highest level.




        """
        return _casadi.Callback_finalize(self, *args)


    def eval(self, *args):
        """
          Evaluate numerically, using temporary matrices and work vectors.

          eval(self, [DM] arg) -> [DM]


        This signature is not thread-safe. For guaranteed thread-safety, use
        eval_buffer




        """
        return _casadi.Callback_eval(self, *args)


    def eval_buffer(self, *args):
        """
          A copy-free low level interface.

          eval_buffer(self, double const ** arg, [int] sizes_arg, double ** res, [int] sizes_res) -> int


        In Python, you will be passed two tuples of memoryview objects




        """
        return _casadi.Callback_eval_buffer(self, *args)


    def has_eval_buffer(self, *args):
        """


        has_eval_buffer(self) -> bool



        """
        return _casadi.Callback_has_eval_buffer(self, *args)


    def get_n_in(self, *args):
        """
        Get the number of inputs This function is called during construction.

        get_n_in(self) -> int





        """
        return _casadi.Callback_get_n_in(self, *args)


    def get_n_out(self, *args):
        """
        Get the number of outputs This function is called during construction.

        get_n_out(self) -> int





        """
        return _casadi.Callback_get_n_out(self, *args)


    def get_sparsity_in(self, *args):
        """
        Get the sparsity of an input This function is called during construction.

        get_sparsity_in(self, int i) -> Sparsity





        """
        return _casadi.Callback_get_sparsity_in(self, *args)


    def get_sparsity_out(self, *args):
        """
        Get the sparsity of an output This function is called during construction.

        get_sparsity_out(self, int i) -> Sparsity





        """
        return _casadi.Callback_get_sparsity_out(self, *args)


    def get_name_in(self, *args):
        """
        Get the sparsity of an input This function is called during construction.

        get_name_in(self, int i) -> str





        """
        return _casadi.Callback_get_name_in(self, *args)


    def get_name_out(self, *args):
        """
        Get the sparsity of an output This function is called during construction.

        get_name_out(self, int i) -> str





        """
        return _casadi.Callback_get_name_out(self, *args)


    def uses_output(self, *args):
        """
        Do the derivative functions need nondifferentiated outputs?

        uses_output(self) -> bool





        """
        return _casadi.Callback_uses_output(self, *args)


    def has_jacobian(self, *args):
        """
        Return Jacobian of all input elements with respect to all output elements.

        has_jacobian(self) -> bool





        """
        return _casadi.Callback_has_jacobian(self, *args)


    def get_jacobian(self, *args):
        """
        Return Jacobian of all input elements with respect to all output elements.

        get_jacobian(self, str name, [str] inames, [str] onames, dict opts) -> Function





        """
        return _casadi.Callback_get_jacobian(self, *args)


    def has_forward(self, *args):
        """
          Return function that calculates forward derivatives forward(nfwd) returns a

          has_forward(self, int nfwd) -> bool

        cached instance if available, and calls  Function get_forward(casadi_int
        nfwd) if no cached version is available.




        """
        return _casadi.Callback_has_forward(self, *args)


    def get_forward(self, *args):
        """
          Return function that calculates forward derivatives forward(nfwd) returns a

          get_forward(self, int nfwd, str name, [str] inames, [str] onames, dict opts) -> Function

        cached instance if available, and calls  Function get_forward(casadi_int
        nfwd) if no cached version is available.




        """
        return _casadi.Callback_get_forward(self, *args)


    def has_reverse(self, *args):
        """
          Return function that calculates adjoint derivatives reverse(nadj) returns a

          has_reverse(self, int nadj) -> bool

        cached instance if available, and calls  Function get_reverse(casadi_int
        nadj) if no cached version is available.




        """
        return _casadi.Callback_has_reverse(self, *args)


    def get_reverse(self, *args):
        """
          Return function that calculates adjoint derivatives reverse(nadj) returns a

          get_reverse(self, int nadj, str name, [str] inames, [str] onames, dict opts) -> Function

        cached instance if available, and calls  Function get_reverse(casadi_int
        nadj) if no cached version is available.




        """
        return _casadi.Callback_get_reverse(self, *args)


    def has_jacobian_sparsity(self, *args):
        """
          Return sparsity of Jacobian of all input elements with respect to all output

          has_jacobian_sparsity(self) -> bool

        elements.




        """
        return _casadi.Callback_has_jacobian_sparsity(self, *args)


    def get_jacobian_sparsity(self, *args):
        """
          Return sparsity of Jacobian of all input elements with respect to all output

          get_jacobian_sparsity(self) -> Sparsity

        elements.




        """
        return _casadi.Callback_get_jacobian_sparsity(self, *args)

    def __disown__(self):
        self.this.disown()
        _casadi.disown_Callback(self)
        return weakref_proxy(self)
Callback_swigregister = _casadi.Callback_swigregister
Callback_swigregister(Callback)

def Callback_type_name(*args):
    """


    type_name() -> str



    """
    return _casadi.Callback_type_name(*args)

class GlobalOptions(_object):
    """
      Collects global CasADi options.



    Note to developers: use sparingly. Global options are - in general - a
    rather bad idea

    this class must never be instantiated. Access its static members directly
    Joris Gillis

    C++ includes: global_options.hpp 


    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GlobalOptions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GlobalOptions, name)
    __repr__ = _swig_repr

    def setSimplificationOnTheFly(*args):
        """


        setSimplificationOnTheFly(bool flag)



        """
        return _casadi.GlobalOptions_setSimplificationOnTheFly(*args)

    setSimplificationOnTheFly = staticmethod(setSimplificationOnTheFly)

    def getSimplificationOnTheFly(*args):
        """


        getSimplificationOnTheFly() -> bool



        """
        return _casadi.GlobalOptions_getSimplificationOnTheFly(*args)

    getSimplificationOnTheFly = staticmethod(getSimplificationOnTheFly)

    def setHierarchicalSparsity(*args):
        """


        setHierarchicalSparsity(bool flag)



        """
        return _casadi.GlobalOptions_setHierarchicalSparsity(*args)

    setHierarchicalSparsity = staticmethod(setHierarchicalSparsity)

    def getHierarchicalSparsity(*args):
        """


        getHierarchicalSparsity() -> bool



        """
        return _casadi.GlobalOptions_getHierarchicalSparsity(*args)

    getHierarchicalSparsity = staticmethod(getHierarchicalSparsity)

    def setCasadiPath(*args):
        """


        setCasadiPath(str path)



        """
        return _casadi.GlobalOptions_setCasadiPath(*args)

    setCasadiPath = staticmethod(setCasadiPath)

    def getCasadiPath(*args):
        """


        getCasadiPath() -> str



        """
        return _casadi.GlobalOptions_getCasadiPath(*args)

    getCasadiPath = staticmethod(getCasadiPath)

    def setCasadiIncludePath(*args):
        """


        setCasadiIncludePath(str path)



        """
        return _casadi.GlobalOptions_setCasadiIncludePath(*args)

    setCasadiIncludePath = staticmethod(setCasadiIncludePath)

    def getCasadiIncludePath(*args):
        """


        getCasadiIncludePath() -> str



        """
        return _casadi.GlobalOptions_getCasadiIncludePath(*args)

    getCasadiIncludePath = staticmethod(getCasadiIncludePath)

    def setMaxNumDir(*args):
        """


        setMaxNumDir(int ndir)



        """
        return _casadi.GlobalOptions_setMaxNumDir(*args)

    setMaxNumDir = staticmethod(setMaxNumDir)

    def getMaxNumDir(*args):
        """


        getMaxNumDir() -> int



        """
        return _casadi.GlobalOptions_getMaxNumDir(*args)

    getMaxNumDir = staticmethod(getMaxNumDir)

    def __init__(self, *args):
        """


        GlobalOptions(GlobalOptions other)



        """
        this = _casadi.new_GlobalOptions(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_GlobalOptions
GlobalOptions_swigregister = _casadi.GlobalOptions_swigregister
GlobalOptions_swigregister(GlobalOptions)

def GlobalOptions_setSimplificationOnTheFly(*args):
    """


    setSimplificationOnTheFly(bool flag)



    """
    return _casadi.GlobalOptions_setSimplificationOnTheFly(*args)

def GlobalOptions_getSimplificationOnTheFly(*args):
    """


    getSimplificationOnTheFly() -> bool



    """
    return _casadi.GlobalOptions_getSimplificationOnTheFly(*args)

def GlobalOptions_setHierarchicalSparsity(*args):
    """


    setHierarchicalSparsity(bool flag)



    """
    return _casadi.GlobalOptions_setHierarchicalSparsity(*args)

def GlobalOptions_getHierarchicalSparsity(*args):
    """


    getHierarchicalSparsity() -> bool



    """
    return _casadi.GlobalOptions_getHierarchicalSparsity(*args)

def GlobalOptions_setCasadiPath(*args):
    """


    setCasadiPath(str path)



    """
    return _casadi.GlobalOptions_setCasadiPath(*args)

def GlobalOptions_getCasadiPath(*args):
    """


    getCasadiPath() -> str



    """
    return _casadi.GlobalOptions_getCasadiPath(*args)

def GlobalOptions_setCasadiIncludePath(*args):
    """


    setCasadiIncludePath(str path)



    """
    return _casadi.GlobalOptions_setCasadiIncludePath(*args)

def GlobalOptions_getCasadiIncludePath(*args):
    """


    getCasadiIncludePath() -> str



    """
    return _casadi.GlobalOptions_getCasadiIncludePath(*args)

def GlobalOptions_setMaxNumDir(*args):
    """


    setMaxNumDir(int ndir)



    """
    return _casadi.GlobalOptions_setMaxNumDir(*args)

def GlobalOptions_getMaxNumDir(*args):
    """


    getMaxNumDir() -> int



    """
    return _casadi.GlobalOptions_getMaxNumDir(*args)

class CasadiMeta(_object):
    """
      Collects global CasADi meta information.



    Joris Gillis

    C++ includes: casadi_meta.hpp 


    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CasadiMeta, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CasadiMeta, name)
    __repr__ = _swig_repr

    def version(*args):
        """


        version() -> char const *



        """
        return _casadi.CasadiMeta_version(*args)

    version = staticmethod(version)

    def git_revision(*args):
        """


        git_revision() -> char const *



        """
        return _casadi.CasadiMeta_git_revision(*args)

    git_revision = staticmethod(git_revision)

    def git_describe(*args):
        """


        git_describe() -> char const *



        """
        return _casadi.CasadiMeta_git_describe(*args)

    git_describe = staticmethod(git_describe)

    def feature_list(*args):
        """


        feature_list() -> char const *



        """
        return _casadi.CasadiMeta_feature_list(*args)

    feature_list = staticmethod(feature_list)

    def build_type(*args):
        """


        build_type() -> char const *



        """
        return _casadi.CasadiMeta_build_type(*args)

    build_type = staticmethod(build_type)

    def compiler_id(*args):
        """


        compiler_id() -> char const *



        """
        return _casadi.CasadiMeta_compiler_id(*args)

    compiler_id = staticmethod(compiler_id)

    def compiler(*args):
        """


        compiler() -> char const *



        """
        return _casadi.CasadiMeta_compiler(*args)

    compiler = staticmethod(compiler)

    def compiler_flags(*args):
        """


        compiler_flags() -> char const *



        """
        return _casadi.CasadiMeta_compiler_flags(*args)

    compiler_flags = staticmethod(compiler_flags)

    def modules(*args):
        """


        modules() -> char const *



        """
        return _casadi.CasadiMeta_modules(*args)

    modules = staticmethod(modules)

    def plugins(*args):
        """


        plugins() -> char const *



        """
        return _casadi.CasadiMeta_plugins(*args)

    plugins = staticmethod(plugins)

    def install_prefix(*args):
        """


        install_prefix() -> char const *



        """
        return _casadi.CasadiMeta_install_prefix(*args)

    install_prefix = staticmethod(install_prefix)

    def __init__(self, *args):
        """


        CasadiMeta(CasadiMeta other)



        """
        this = _casadi.new_CasadiMeta(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_CasadiMeta
CasadiMeta_swigregister = _casadi.CasadiMeta_swigregister
CasadiMeta_swigregister(CasadiMeta)

def CasadiMeta_version(*args):
    """


    version() -> char const *



    """
    return _casadi.CasadiMeta_version(*args)

def CasadiMeta_git_revision(*args):
    """


    git_revision() -> char const *



    """
    return _casadi.CasadiMeta_git_revision(*args)

def CasadiMeta_git_describe(*args):
    """


    git_describe() -> char const *



    """
    return _casadi.CasadiMeta_git_describe(*args)

def CasadiMeta_feature_list(*args):
    """


    feature_list() -> char const *



    """
    return _casadi.CasadiMeta_feature_list(*args)

def CasadiMeta_build_type(*args):
    """


    build_type() -> char const *



    """
    return _casadi.CasadiMeta_build_type(*args)

def CasadiMeta_compiler_id(*args):
    """


    compiler_id() -> char const *



    """
    return _casadi.CasadiMeta_compiler_id(*args)

def CasadiMeta_compiler(*args):
    """


    compiler() -> char const *



    """
    return _casadi.CasadiMeta_compiler(*args)

def CasadiMeta_compiler_flags(*args):
    """


    compiler_flags() -> char const *



    """
    return _casadi.CasadiMeta_compiler_flags(*args)

def CasadiMeta_modules(*args):
    """


    modules() -> char const *



    """
    return _casadi.CasadiMeta_modules(*args)

def CasadiMeta_plugins(*args):
    """


    plugins() -> char const *



    """
    return _casadi.CasadiMeta_plugins(*args)

def CasadiMeta_install_prefix(*args):
    """


    install_prefix() -> char const *



    """
    return _casadi.CasadiMeta_install_prefix(*args)


def collocation_points(*args):
    """
      Obtain collocation points of specific order and scheme.

      collocation_points(int order, str scheme) -> [float]


    Parameters:
    -----------

    order:  Which order (1 to 9 supported)

    scheme:  'radau' or 'legendre'




    """
    return _casadi.collocation_points(*args)

def collocation_interpolators(*args):
    """
      Obtain collocation interpolating matrices.

      collocation_interpolators([float] tau) -> ([[float]] OUTPUT, [float] OUTPUT)


    A collocation method poses a polynomial Pi that interpolates exactly through
    an initial state (0,X_0) and helper states at collocation points
    (tau_j,X(j)).

    This function computes the linear mapping between dPi/dt and coefficients
    Z=[X_0 X].

    Parameters:
    -----------

    tau:  location of collocation points, as obtained from collocation_points

    output_C:  interpolating coefficients to obtain derivatives. Length:
    order+1, order+1



    ::

    dPi/dt @Z_j = (1/h) Sum_i C[j][i]*Z_i,



    with h the length of the integration interval.

    Parameters:
    -----------

    output_D:  interpolating coefficients to obtain end state. Length: order+1



    ::

    Pi @X_f = Sum_i D[i]*Z_i






    """
    return _casadi.collocation_interpolators(*args)

def collocation_coeff(*args):
    """
      Obtain collocation interpolating matrices.

      collocation_coeff([float] tau) -> (DM OUTPUT, DM OUTPUT, DM OUTPUT)


    A collocation method poses a polynomial Pi that interpolates exactly through
    an initial state (0,X_0) and helper states at collocation points
    (tau_j,Xc_j) with j=1..degree.

    This function computes the linear mapping between dPi/dt and coefficients
    Z=[X_0 Xc].

    Parameters:
    -----------

    tau:  location of collocation points (length: degree), as obtained from
    collocation_points

    C:  interpolating coefficients to obtain derivatives. Size: (degree+1)-by-
    degree

    You may find the slopes of Pi at the collocation points as

    ::

    dPi/dt @ Xc = (1/h) Z*C,



    with h the length of the integration interval.

    Parameters:
    -----------

    D:  interpolating coefficients to obtain end state. Size: (degree+1)-by-1

    You may find the end point of Pi as

    ::

    Pi @X_f = Z*D



    Parameters:
    -----------

    B:  quadrature coefficients Size: degree-by-1

    Given quadrature righ-hand-sides 'quad' evaluated at the collocation points,
    you may find the integrated quadratures as

    ::

    q = quad*B*h






    """
    return _casadi.collocation_coeff(*args)
LEGENDRE = _casadi.LEGENDRE
RADAU = _casadi.RADAU

def simpleRK(*args):
    """
      Construct an explicit Runge-Kutta integrator The constructed function has

      simpleRK(Function f, int N, int order) -> Function

    three inputs, corresponding to initial state (x0), parameter (p) and
    integration time (h) and one output, corresponding to final state (xf).

    Parameters:
    -----------

    f:  ODE function with two inputs (x and p) and one output (xdot)

    N:  Number of integrator steps

    order:  Order of interpolating polynomials




    """
    return _casadi.simpleRK(*args)

def simpleIRK(*args):
    """
      Construct an implicit Runge-Kutta integrator using a collocation scheme The

      simpleIRK(Function f, int N, int order, str scheme, str solver, dict solver_options) -> Function

    constructed function has three inputs, corresponding to initial state (x0),
    parameter (p) and integration time (h) and one output, corresponding to
    final state (xf).

    Parameters:
    -----------

    f:  ODE function with two inputs (x and p) and one output (xdot)

    N:  Number of integrator steps

    order:  Order of interpolating polynomials

    scheme:   Collocation scheme, as excepted by collocationPoints function.

    solver:  Solver plugin

    solver_options:  Options to be passed to the solver plugin




    """
    return _casadi.simpleIRK(*args)

def simpleIntegrator(*args):
    """
      Simplified wrapper for the Integrator class Constructs an integrator using

      simpleIntegrator(Function f, str integrator, dict integrator_options) -> Function

    the same syntax as simpleRK and simpleIRK. The constructed function has
    three inputs, corresponding to initial state (x0), parameter (p) and
    integration time (h) and one output, corresponding to final state (xf).

    Parameters:
    -----------

    f:  ODE function with two inputs (x and p) and one output (xdot)

    N:  Number of integrator steps

    order:  Order of interpolating polynomials

    scheme:   Collocation scheme, as excepted by collocationPoints function.




    """
    return _casadi.simpleIntegrator(*args)

def detect_simple_bounds(*args):
    """
      Detect simple bounds from general constraints.

      detect_simple_bounds(SX xX, SX p, SX g, SX lbg, SX ubg) -> ([int] OUTPUT, SX OUTPUT, SX OUTPUT, Function OUTPUT, Function OUTPUT)
      detect_simple_bounds(MX xX, MX p, MX g, MX lbg, MX ubg) -> ([int] OUTPUT, MX OUTPUT, MX OUTPUT, Function OUTPUT, Function OUTPUT)


    Given parametric constraints:

    ::

      *   subject to lbg(p) <= g(x,p) <= ubg(p)
      * 



    Returns an equivalent set

    ::

      *   subject to  lbg(p)(gi) <= g(x,p)(gi) <= ubg(p)(gi)
      *               lbx(p) <= x                 <= ubx(p)
      * 



    Parameters:
    -----------

    lam_forward:  (lam_g,p)->(lam_sg,lam_x)

    lam_backward:  (lam_sg,lam_x,p)->(lam_g)




    """
    return _casadi.detect_simple_bounds(*args)
class NlpBuilder(PrintableCommon):
    """
      A symbolic NLP representation.



    Joel Andersson

    C++ includes: nlp_builder.hpp 


    """

    __swig_setmethods__ = {}
    for _s in [PrintableCommon]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NlpBuilder, name, value)
    __swig_getmethods__ = {}
    for _s in [PrintableCommon]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NlpBuilder, name)
    __repr__ = _swig_repr
    __swig_getmethods__["x"] = _casadi.NlpBuilder_x_get
    if _newclass:
        x = _swig_property(_casadi.NlpBuilder_x_get)
    __swig_getmethods__["f"] = _casadi.NlpBuilder_f_get
    if _newclass:
        f = _swig_property(_casadi.NlpBuilder_f_get)
    __swig_getmethods__["g"] = _casadi.NlpBuilder_g_get
    if _newclass:
        g = _swig_property(_casadi.NlpBuilder_g_get)
    __swig_getmethods__["x_lb"] = _casadi.NlpBuilder_x_lb_get
    if _newclass:
        x_lb = _swig_property(_casadi.NlpBuilder_x_lb_get)
    __swig_getmethods__["x_ub"] = _casadi.NlpBuilder_x_ub_get
    if _newclass:
        x_ub = _swig_property(_casadi.NlpBuilder_x_ub_get)
    __swig_getmethods__["g_lb"] = _casadi.NlpBuilder_g_lb_get
    if _newclass:
        g_lb = _swig_property(_casadi.NlpBuilder_g_lb_get)
    __swig_getmethods__["g_ub"] = _casadi.NlpBuilder_g_ub_get
    if _newclass:
        g_ub = _swig_property(_casadi.NlpBuilder_g_ub_get)
    __swig_getmethods__["x_init"] = _casadi.NlpBuilder_x_init_get
    if _newclass:
        x_init = _swig_property(_casadi.NlpBuilder_x_init_get)
    __swig_getmethods__["lambda_init"] = _casadi.NlpBuilder_lambda_init_get
    if _newclass:
        lambda_init = _swig_property(_casadi.NlpBuilder_lambda_init_get)
    __swig_getmethods__["discrete"] = _casadi.NlpBuilder_discrete_get
    if _newclass:
        discrete = _swig_property(_casadi.NlpBuilder_discrete_get)

    def import_nl(self, *args):
        """
        Import an .nl file.

        import_nl(self, str filename, dict opts)





        """
        return _casadi.NlpBuilder_import_nl(self, *args)


    def type_name(self, *args):
        """
        Readable name of the class.

        type_name(self) -> str





        """
        return _casadi.NlpBuilder_type_name(self, *args)


    def disp(self, *args):
        """
        Print a description of the object.

        disp(self, bool more)





        """
        return _casadi.NlpBuilder_disp(self, *args)


    def str(self, *args):
        """
        Get string representation.

        str(self, bool more) -> str





        """
        return _casadi.NlpBuilder_str(self, *args)


    def __init__(self, *args):
        """


        NlpBuilder()
        NlpBuilder(NlpBuilder other)



        """
        this = _casadi.new_NlpBuilder(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_NlpBuilder
NlpBuilder_swigregister = _casadi.NlpBuilder_swigregister
NlpBuilder_swigregister(NlpBuilder)

CONSTANT = _casadi.CONSTANT
PARAMETER = _casadi.PARAMETER
DISCRETE = _casadi.DISCRETE
CONTINUOUS = _casadi.CONTINUOUS
INPUT = _casadi.INPUT
OUTPUT = _casadi.OUTPUT
INTERNAL = _casadi.INTERNAL
ALGEBRAIC = _casadi.ALGEBRAIC
DIFFERENTIAL = _casadi.DIFFERENTIAL
NO_ALIAS = _casadi.NO_ALIAS
ALIAS = _casadi.ALIAS
NEGATED_ALIAS = _casadi.NEGATED_ALIAS
CAT_UNKNOWN = _casadi.CAT_UNKNOWN
CAT_DERIVATIVE = _casadi.CAT_DERIVATIVE
CAT_STATE = _casadi.CAT_STATE
CAT_DEPENDENT_CONSTANT = _casadi.CAT_DEPENDENT_CONSTANT
CAT_INDEPENDENT_CONSTANT = _casadi.CAT_INDEPENDENT_CONSTANT
CAT_DEPENDENT_PARAMETER = _casadi.CAT_DEPENDENT_PARAMETER
CAT_INDEPENDENT_PARAMETER = _casadi.CAT_INDEPENDENT_PARAMETER
CAT_ALGEBRAIC = _casadi.CAT_ALGEBRAIC
class Variable(PrintableCommon):
    """


    Variable() -> 



    """

    __swig_setmethods__ = {}
    for _s in [PrintableCommon]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Variable, name, value)
    __swig_getmethods__ = {}
    for _s in [PrintableCommon]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Variable, name)
    __repr__ = _swig_repr

    def name(self, *args):
        """


        name(self) -> str



        """
        return _casadi.Variable_name(self, *args)

    __swig_getmethods__["v"] = _casadi.Variable_v_get
    if _newclass:
        v = _swig_property(_casadi.Variable_v_get)
    __swig_getmethods__["d"] = _casadi.Variable_d_get
    if _newclass:
        d = _swig_property(_casadi.Variable_d_get)
    __swig_getmethods__["nominal"] = _casadi.Variable_nominal_get
    if _newclass:
        nominal = _swig_property(_casadi.Variable_nominal_get)
    __swig_getmethods__["start"] = _casadi.Variable_start_get
    if _newclass:
        start = _swig_property(_casadi.Variable_start_get)
    __swig_getmethods__["min"] = _casadi.Variable_min_get
    if _newclass:
        min = _swig_property(_casadi.Variable_min_get)
    __swig_getmethods__["max"] = _casadi.Variable_max_get
    if _newclass:
        max = _swig_property(_casadi.Variable_max_get)
    __swig_getmethods__["guess"] = _casadi.Variable_guess_get
    if _newclass:
        guess = _swig_property(_casadi.Variable_guess_get)
    __swig_getmethods__["derivative_start"] = _casadi.Variable_derivative_start_get
    if _newclass:
        derivative_start = _swig_property(_casadi.Variable_derivative_start_get)
    __swig_getmethods__["variability"] = _casadi.Variable_variability_get
    if _newclass:
        variability = _swig_property(_casadi.Variable_variability_get)
    __swig_getmethods__["causality"] = _casadi.Variable_causality_get
    if _newclass:
        causality = _swig_property(_casadi.Variable_causality_get)
    __swig_getmethods__["category"] = _casadi.Variable_category_get
    if _newclass:
        category = _swig_property(_casadi.Variable_category_get)
    __swig_getmethods__["alias"] = _casadi.Variable_alias_get
    if _newclass:
        alias = _swig_property(_casadi.Variable_alias_get)
    __swig_getmethods__["description"] = _casadi.Variable_description_get
    if _newclass:
        description = _swig_property(_casadi.Variable_description_get)
    __swig_getmethods__["valueReference"] = _casadi.Variable_valueReference_get
    if _newclass:
        valueReference = _swig_property(_casadi.Variable_valueReference_get)
    __swig_getmethods__["unit"] = _casadi.Variable_unit_get
    if _newclass:
        unit = _swig_property(_casadi.Variable_unit_get)
    __swig_getmethods__["display_unit"] = _casadi.Variable_display_unit_get
    if _newclass:
        display_unit = _swig_property(_casadi.Variable_display_unit_get)
    __swig_getmethods__["free"] = _casadi.Variable_free_get
    if _newclass:
        free = _swig_property(_casadi.Variable_free_get)

    def type_name(self, *args):
        """


        type_name(self) -> str



        """
        return _casadi.Variable_type_name(self, *args)


    def disp(self, *args):
        """


        disp(self, bool more)



        """
        return _casadi.Variable_disp(self, *args)


    def str(self, *args):
        """


        str(self, bool more) -> str



        """
        return _casadi.Variable_str(self, *args)


    def __init__(self, *args):
        """


        Variable()
        Variable(Variable other)
        Variable(str name, Sparsity sp)



        """
        this = _casadi.new_Variable(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_Variable
Variable_swigregister = _casadi.Variable_swigregister
Variable_swigregister(Variable)

class DaeBuilder(PrintableCommon):
    """
      An initial-value problem in differential-algebraic equations.



    Independent variables:
    ======================





    ::

      t:      time




    Time-continuous variables:
    ==========================





    ::

      x:      states defined by ODE
      s:      implicitly defined states
      z:      algebraic variables
      u:      control signals
      q:      quadrature states
      y:      outputs




    Time-constant variables:
    ========================





    ::

      p:      free parameters
      d:      dependent parameters




    Dynamic constraints (imposed everywhere):
    =========================================





    ::

      ODE                    \\dot{x} ==  ode(t, x, s, z, u, p, d)
      DAE or implicit ODE:         0 ==  dae(t, x, s, z, u, p, d, sdot)
      algebraic equations:         0 ==  alg(t, x, s, z, u, p, d)
      quadrature equations:  \\dot{q} == quad(t, x, s, z, u, p, d)
      dependent parameters:        d == ddef(t, x, s, z, u, p, d)
      output equations:            y == ydef(t, x, s, z, u, p, d)




    Point constraints (imposed pointwise):
    ======================================





    ::

      Initial equations:           0 == init(t, x, s, z, u, p, d, sdot)




    Joel Andersson

    C++ includes: dae_builder.hpp 


    """

    __swig_setmethods__ = {}
    for _s in [PrintableCommon]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DaeBuilder, name, value)
    __swig_getmethods__ = {}
    for _s in [PrintableCommon]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DaeBuilder, name)
    __repr__ = _swig_repr
    __swig_getmethods__["t"] = _casadi.DaeBuilder_t_get
    if _newclass:
        t = _swig_property(_casadi.DaeBuilder_t_get)
    __swig_getmethods__["x"] = _casadi.DaeBuilder_x_get
    if _newclass:
        x = _swig_property(_casadi.DaeBuilder_x_get)
    __swig_getmethods__["ode"] = _casadi.DaeBuilder_ode_get
    if _newclass:
        ode = _swig_property(_casadi.DaeBuilder_ode_get)
    __swig_getmethods__["lam_ode"] = _casadi.DaeBuilder_lam_ode_get
    if _newclass:
        lam_ode = _swig_property(_casadi.DaeBuilder_lam_ode_get)
    __swig_getmethods__["s"] = _casadi.DaeBuilder_s_get
    if _newclass:
        s = _swig_property(_casadi.DaeBuilder_s_get)
    __swig_getmethods__["sdot"] = _casadi.DaeBuilder_sdot_get
    if _newclass:
        sdot = _swig_property(_casadi.DaeBuilder_sdot_get)
    __swig_getmethods__["dae"] = _casadi.DaeBuilder_dae_get
    if _newclass:
        dae = _swig_property(_casadi.DaeBuilder_dae_get)
    __swig_getmethods__["lam_dae"] = _casadi.DaeBuilder_lam_dae_get
    if _newclass:
        lam_dae = _swig_property(_casadi.DaeBuilder_lam_dae_get)
    __swig_getmethods__["z"] = _casadi.DaeBuilder_z_get
    if _newclass:
        z = _swig_property(_casadi.DaeBuilder_z_get)
    __swig_getmethods__["alg"] = _casadi.DaeBuilder_alg_get
    if _newclass:
        alg = _swig_property(_casadi.DaeBuilder_alg_get)
    __swig_getmethods__["lam_alg"] = _casadi.DaeBuilder_lam_alg_get
    if _newclass:
        lam_alg = _swig_property(_casadi.DaeBuilder_lam_alg_get)
    __swig_getmethods__["q"] = _casadi.DaeBuilder_q_get
    if _newclass:
        q = _swig_property(_casadi.DaeBuilder_q_get)
    __swig_getmethods__["quad"] = _casadi.DaeBuilder_quad_get
    if _newclass:
        quad = _swig_property(_casadi.DaeBuilder_quad_get)
    __swig_getmethods__["lam_quad"] = _casadi.DaeBuilder_lam_quad_get
    if _newclass:
        lam_quad = _swig_property(_casadi.DaeBuilder_lam_quad_get)
    __swig_getmethods__["w"] = _casadi.DaeBuilder_w_get
    if _newclass:
        w = _swig_property(_casadi.DaeBuilder_w_get)
    __swig_getmethods__["wdef"] = _casadi.DaeBuilder_wdef_get
    if _newclass:
        wdef = _swig_property(_casadi.DaeBuilder_wdef_get)
    __swig_getmethods__["lam_wdef"] = _casadi.DaeBuilder_lam_wdef_get
    if _newclass:
        lam_wdef = _swig_property(_casadi.DaeBuilder_lam_wdef_get)
    __swig_getmethods__["y"] = _casadi.DaeBuilder_y_get
    if _newclass:
        y = _swig_property(_casadi.DaeBuilder_y_get)
    __swig_getmethods__["ydef"] = _casadi.DaeBuilder_ydef_get
    if _newclass:
        ydef = _swig_property(_casadi.DaeBuilder_ydef_get)
    __swig_getmethods__["lam_ydef"] = _casadi.DaeBuilder_lam_ydef_get
    if _newclass:
        lam_ydef = _swig_property(_casadi.DaeBuilder_lam_ydef_get)
    __swig_getmethods__["u"] = _casadi.DaeBuilder_u_get
    if _newclass:
        u = _swig_property(_casadi.DaeBuilder_u_get)
    __swig_getmethods__["p"] = _casadi.DaeBuilder_p_get
    if _newclass:
        p = _swig_property(_casadi.DaeBuilder_p_get)
    __swig_getmethods__["c"] = _casadi.DaeBuilder_c_get
    if _newclass:
        c = _swig_property(_casadi.DaeBuilder_c_get)
    __swig_getmethods__["cdef"] = _casadi.DaeBuilder_cdef_get
    if _newclass:
        cdef = _swig_property(_casadi.DaeBuilder_cdef_get)
    __swig_getmethods__["d"] = _casadi.DaeBuilder_d_get
    if _newclass:
        d = _swig_property(_casadi.DaeBuilder_d_get)
    __swig_getmethods__["ddef"] = _casadi.DaeBuilder_ddef_get
    if _newclass:
        ddef = _swig_property(_casadi.DaeBuilder_ddef_get)
    __swig_getmethods__["lam_ddef"] = _casadi.DaeBuilder_lam_ddef_get
    if _newclass:
        lam_ddef = _swig_property(_casadi.DaeBuilder_lam_ddef_get)
    __swig_getmethods__["aux"] = _casadi.DaeBuilder_aux_get
    if _newclass:
        aux = _swig_property(_casadi.DaeBuilder_aux_get)
    __swig_getmethods__["init"] = _casadi.DaeBuilder_init_get
    if _newclass:
        init = _swig_property(_casadi.DaeBuilder_init_get)

    def add_p(self, *args):
        """
        Add a new parameter

        add_p(self, str name, int n) -> MX





        """
        return _casadi.DaeBuilder_add_p(self, *args)


    def add_u(self, *args):
        """
        Add a new control.

        add_u(self, str name, int n) -> MX





        """
        return _casadi.DaeBuilder_add_u(self, *args)


    def add_x(self, *args):
        """
        Add a new differential state.

        add_x(self, str name, int n) -> MX





        """
        return _casadi.DaeBuilder_add_x(self, *args)


    def add_s(self, *args):
        """
        Add a implicit state.

        add_s(self, str name, int n) -> (MX,MX)





        """
        return _casadi.DaeBuilder_add_s(self, *args)


    def add_z(self, *args):
        """
        Add a new algebraic variable.

        add_z(self, str name, int n) -> MX





        """
        return _casadi.DaeBuilder_add_z(self, *args)


    def add_q(self, *args):
        """
        Add a new quadrature state.

        add_q(self, str name, int n) -> MX





        """
        return _casadi.DaeBuilder_add_q(self, *args)


    def add_d(self, *args):
        """
        Add a new dependent parameter.

        add_d(self, str name, MX new_ddef) -> MX





        """
        return _casadi.DaeBuilder_add_d(self, *args)


    def add_y(self, *args):
        """
        Add a new output.

        add_y(self, str name, MX new_ydef) -> MX





        """
        return _casadi.DaeBuilder_add_y(self, *args)


    def add_ode(self, *args):
        """
        Add an ordinary differential equation.

        add_ode(self, str name, MX new_ode)





        """
        return _casadi.DaeBuilder_add_ode(self, *args)


    def add_dae(self, *args):
        """
        Add a differential-algebraic equation.

        add_dae(self, str name, MX new_dae)





        """
        return _casadi.DaeBuilder_add_dae(self, *args)


    def add_alg(self, *args):
        """
        Add an algebraic equation.

        add_alg(self, str name, MX new_alg)





        """
        return _casadi.DaeBuilder_add_alg(self, *args)


    def add_quad(self, *args):
        """
        Add a quadrature equation.

        add_quad(self, str name, MX new_quad)





        """
        return _casadi.DaeBuilder_add_quad(self, *args)


    def add_aux(self, *args):
        """
        Add an auxiliary variable.

        add_aux(self, str name, int n) -> MX





        """
        return _casadi.DaeBuilder_add_aux(self, *args)


    def sanity_check(self, *args):
        """
        Check if dimensions match.

        sanity_check(self)





        """
        return _casadi.DaeBuilder_sanity_check(self, *args)


    def split_dae(self, *args):
        """
        Identify and separate the algebraic variables and equations in the DAE.

        split_dae(self)





        """
        return _casadi.DaeBuilder_split_dae(self, *args)


    def eliminate_alg(self, *args):
        """
        Eliminate algebraic variables and equations transforming them into outputs.

        eliminate_alg(self)





        """
        return _casadi.DaeBuilder_eliminate_alg(self, *args)


    def make_semi_explicit(self, *args):
        """
        Transform the implicit DAE to a semi-explicit DAE.

        make_semi_explicit(self)





        """
        return _casadi.DaeBuilder_make_semi_explicit(self, *args)


    def make_explicit(self, *args):
        """
        Transform the implicit DAE or semi-explicit DAE into an explicit ODE.

        make_explicit(self)





        """
        return _casadi.DaeBuilder_make_explicit(self, *args)


    def sort_d(self, *args):
        """
        Sort dependent parameters.

        sort_d(self)





        """
        return _casadi.DaeBuilder_sort_d(self, *args)


    def split_d(self, *args):
        """
        Eliminate interdependencies amongst dependent parameters.

        split_d(self)





        """
        return _casadi.DaeBuilder_split_d(self, *args)


    def eliminate_d(self, *args):
        """
        Eliminate dependent parameters.

        eliminate_d(self)





        """
        return _casadi.DaeBuilder_eliminate_d(self, *args)


    def eliminate_quad(self, *args):
        """
        Eliminate quadrature states and turn them into ODE states.

        eliminate_quad(self)





        """
        return _casadi.DaeBuilder_eliminate_quad(self, *args)


    def sort_dae(self, *args):
        """
        Sort the DAE and implicitly defined states.

        sort_dae(self)





        """
        return _casadi.DaeBuilder_sort_dae(self, *args)


    def sort_alg(self, *args):
        """
        Sort the algebraic equations and algebraic states.

        sort_alg(self)





        """
        return _casadi.DaeBuilder_sort_alg(self, *args)


    def scale_variables(self, *args):
        """
        Scale the variables.

        scale_variables(self)





        """
        return _casadi.DaeBuilder_scale_variables(self, *args)


    def scale_equations(self, *args):
        """
        Scale the implicit equations.

        scale_equations(self)





        """
        return _casadi.DaeBuilder_scale_equations(self, *args)


    def add_fun(self, *args):
        """
          Add an external function.

          add_fun(self, Function f) -> Function
          add_fun(self, str name, Importer compiler, dict opts) -> Function
          add_fun(self, str name, [str] arg, [str] res, dict opts) -> Function




        .......

        ::

          add_fun(self, Function f)



        Add an already existing function.



        .............


        .......

        ::

          add_fun(self, str name, Importer compiler, dict opts)



        Add an external function.



        .............


        .......

        ::

          add_fun(self, str name, [str] arg, [str] res, dict opts)



        Add a function from loaded expressions.



        .............



        """
        return _casadi.DaeBuilder_add_fun(self, *args)


    def has_fun(self, *args):
        """
        Does a particular function already exist?

        has_fun(self, str name) -> bool





        """
        return _casadi.DaeBuilder_has_fun(self, *args)


    def fun(self, *args):
        """
        Get function by name.

        fun(self, str name) -> Function





        """
        return _casadi.DaeBuilder_fun(self, *args)


    def parse_fmi(self, *args):
        """
        Import existing problem from FMI/XML

        parse_fmi(self, str filename)





        """
        return _casadi.DaeBuilder_parse_fmi(self, *args)


    def add_lc(self, *args):
        """
        Add a named linear combination of output expressions.

        add_lc(self, str name, [str] f_out) -> MX





        """
        return _casadi.DaeBuilder_add_lc(self, *args)


    def create(self, *args):
        """
        Construct a function object.

        create(self, str fname, [str] s_in, [str] s_out) -> Function





        """
        return _casadi.DaeBuilder_create(self, *args)


    def var(self, *args):
        """
        Get variable expression by name.

        var(self, str name) -> MX





        """
        return _casadi.DaeBuilder_var(self, *args)


    def __call__(self, *args):
        """


        __call__(self, str name) -> MX



        """
        return _casadi.DaeBuilder___call__(self, *args)


    def der(self, *args):
        """
          Get a derivative expression by non-differentiated expression.

          der(self, MX var) -> MX
          der(self, str name) -> MX




        .......

        ::

          der(self, str name)



        Get a derivative expression by name.



        .............


        .......

        ::

          der(self, MX var)



        Get a derivative expression by non-differentiated expression.



        .............



        """
        return _casadi.DaeBuilder_der(self, *args)


    def nominal(self, *args):
        """
          Get the nominal value(s) by expression.

          nominal(self, MX var) -> [float]
          nominal(self, str name) -> float




        .......

        ::

          nominal(self, MX var)



        Get the nominal value(s) by expression.



        .............


        .......

        ::

          nominal(self, str name)



        Get the nominal value by name.



        .............



        """
        return _casadi.DaeBuilder_nominal(self, *args)


    def set_nominal(self, *args):
        """
          Set the nominal value(s) by expression.

          set_nominal(self, MX var, [float] val)
          set_nominal(self, str name, float val)




        .......

        ::

          set_nominal(self, MX var, [float] val)



        Set the nominal value(s) by expression.



        .............


        .......

        ::

          set_nominal(self, str name, float val)



        Set the nominal value by name.



        .............



        """
        return _casadi.DaeBuilder_set_nominal(self, *args)


    def min(self, *args):
        """
          Get the lower bound(s) by expression.

          min(self, MX var, bool normalized) -> [float]
          min(self, str name, bool normalized) -> float




        .......

        ::

          min(self, MX var, bool normalized)



        Get the lower bound(s) by expression.



        .............


        .......

        ::

          min(self, str name, bool normalized)



        Get the lower bound by name.



        .............



        """
        return _casadi.DaeBuilder_min(self, *args)


    def set_min(self, *args):
        """
          Set the lower bound(s) by expression.

          set_min(self, MX var, [float] val, bool normalized)
          set_min(self, str name, float val, bool normalized)




        .......

        ::

          set_min(self, MX var, [float] val, bool normalized)



        Set the lower bound(s) by expression.



        .............


        .......

        ::

          set_min(self, str name, float val, bool normalized)



        Set the lower bound by name.



        .............



        """
        return _casadi.DaeBuilder_set_min(self, *args)


    def max(self, *args):
        """
          Get the upper bound(s) by expression.

          max(self, MX var, bool normalized) -> [float]
          max(self, str name, bool normalized) -> float




        .......

        ::

          max(self, MX var, bool normalized)



        Get the upper bound(s) by expression.



        .............


        .......

        ::

          max(self, str name, bool normalized)



        Get the upper bound by name.



        .............



        """
        return _casadi.DaeBuilder_max(self, *args)


    def set_max(self, *args):
        """
          Set the upper bound(s) by expression.

          set_max(self, MX var, [float] val, bool normalized)
          set_max(self, str name, float val, bool normalized)




        .......

        ::

          set_max(self, MX var, [float] val, bool normalized)



        Set the upper bound(s) by expression.



        .............


        .......

        ::

          set_max(self, str name, float val, bool normalized)



        Set the upper bound by name.



        .............



        """
        return _casadi.DaeBuilder_set_max(self, *args)


    def guess(self, *args):
        """
          Get the initial guess(es) by expression.

          guess(self, MX var, bool normalized) -> [float]
          guess(self, str name, bool normalized) -> float




        .......

        ::

          guess(self, MX var, bool normalized)



        Get the initial guess(es) by expression.



        .............


        .......

        ::

          guess(self, str name, bool normalized)



        Get the initial guess by name.



        .............



        """
        return _casadi.DaeBuilder_guess(self, *args)


    def set_guess(self, *args):
        """
          Set the initial guess(es) by expression.

          set_guess(self, MX var, [float] val, bool normalized)
          set_guess(self, str name, float val, bool normalized)




        .......

        ::

          set_guess(self, MX var, [float] val, bool normalized)



        Set the initial guess(es) by expression.



        .............


        .......

        ::

          set_guess(self, str name, float val, bool normalized)



        Set the initial guess by name.



        .............



        """
        return _casadi.DaeBuilder_set_guess(self, *args)


    def start(self, *args):
        """
          Get the (optionally normalized) value(s) at time 0 by expression.

          start(self, MX var, bool normalized) -> [float]
          start(self, str name, bool normalized) -> float




        .......

        ::

          start(self, MX var, bool normalized)



        Get the (optionally normalized) value(s) at time 0 by expression.



        .............


        .......

        ::

          start(self, str name, bool normalized)



        Get the (optionally normalized) value at time 0 by name.



        .............



        """
        return _casadi.DaeBuilder_start(self, *args)


    def set_start(self, *args):
        """
          Set the (optionally normalized) value(s) at time 0 by expression.

          set_start(self, MX var, [float] val, bool normalized)
          set_start(self, str name, float val, bool normalized)




        .......

        ::

          set_start(self, MX var, [float] val, bool normalized)



        Set the (optionally normalized) value(s) at time 0 by expression.



        .............


        .......

        ::

          set_start(self, str name, float val, bool normalized)



        Set the (optionally normalized) value at time 0 by name.



        .............



        """
        return _casadi.DaeBuilder_set_start(self, *args)


    def derivative_start(self, *args):
        """
          Get the (optionally normalized) derivative value(s) at time 0 by expression.

          derivative_start(self, MX var, bool normalized) -> [float]
          derivative_start(self, str name, bool normalized) -> float




        .......

        ::

          derivative_start(self, MX var, bool normalized)



        Get the (optionally normalized) derivative value(s) at time 0 by expression.



        .............


        .......

        ::

          derivative_start(self, str name, bool normalized)



        Get the (optionally normalized) derivative value at time 0 by name.



        .............



        """
        return _casadi.DaeBuilder_derivative_start(self, *args)


    def set_derivative_start(self, *args):
        """
          Set the (optionally normalized) derivative value(s) at time 0 by expression.

          set_derivative_start(self, MX var, [float] val, bool normalized)
          set_derivative_start(self, str name, float val, bool normalized)




        .......

        ::

          set_derivative_start(self, MX var, [float] val, bool normalized)



        Set the (optionally normalized) derivative value(s) at time 0 by expression.



        .............


        .......

        ::

          set_derivative_start(self, str name, float val, bool normalized)



        Set the (optionally normalized) derivative value at time 0 by name.



        .............



        """
        return _casadi.DaeBuilder_set_derivative_start(self, *args)


    def unit(self, *args):
        """
          Get the unit given a vector of symbolic variables (all units must be

          unit(self, MX var) -> str
          unit(self, str name) -> str

        identical)



        .......

        ::

          unit(self, MX var)



        Get the unit given a vector of symbolic variables (all units must be
        identical)



        .............


        .......

        ::

          unit(self, str name)



        Get the unit for a component.



        .............



        """
        return _casadi.DaeBuilder_unit(self, *args)


    def set_unit(self, *args):
        """
        Set the unit for a component.

        set_unit(self, str name, str val)





        """
        return _casadi.DaeBuilder_set_unit(self, *args)


    def type_name(self, *args):
        """
        Readable name of the class.

        type_name(self) -> str





        """
        return _casadi.DaeBuilder_type_name(self, *args)


    def disp(self, *args):
        """
        Print representation.

        disp(self, bool more)





        """
        return _casadi.DaeBuilder_disp(self, *args)


    def str(self, *args):
        """
        Get string representation.

        str(self, bool more) -> str





        """
        return _casadi.DaeBuilder_str(self, *args)


    def add_variable(self, *args):
        """
          Add a new variable: returns corresponding symbolic expression.

          add_variable(self, str name, int n) -> MX
          add_variable(self, str name, Variable var)
          add_variable(self, str name, Sparsity sp) -> MX




        .......

        ::

          add_variable(self, str name, Variable var)



        Add a variable.



        .............


        .......

        ::

          add_variable(self, str name, int n)
          add_variable(self, str name, Sparsity sp)



        Add a new variable: returns corresponding symbolic expression.



        .............



        """
        return _casadi.DaeBuilder_add_variable(self, *args)


    def variable(self, *args):
        """
        Access a variable by name

        variable(self, str name) -> Variable
        variable(self, str name) -> Variable





        """
        return _casadi.DaeBuilder_variable(self, *args)


    def __init__(self, *args):
        """


          DaeBuilder()
          DaeBuilder(DaeBuilder other)


        .......

        ::

          DaeBuilder(DaeBuilder other)



        .............


        .......

        ::

          DaeBuilder()



        Default constructor.



        .............



        """
        this = _casadi.new_DaeBuilder(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_DaeBuilder
DaeBuilder_swigregister = _casadi.DaeBuilder_swigregister
DaeBuilder_swigregister(DaeBuilder)

class XmlFile(SharedObject, PrintableCommon):
    """
      XML parser Can be used for parsing XML files into CasADi data structures.



    Joel Andersson

    C++ includes: xml_file.hpp 


    """

    __swig_setmethods__ = {}
    for _s in [SharedObject, PrintableCommon]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlFile, name, value)
    __swig_getmethods__ = {}
    for _s in [SharedObject, PrintableCommon]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, XmlFile, name)
    __repr__ = _swig_repr

    def type_name(*args):
        """


        type_name() -> str



        """
        return _casadi.XmlFile_type_name(*args)

    type_name = staticmethod(type_name)
    __swig_destroy__ = _casadi.delete_XmlFile

    def load_plugin(*args):
        """


        load_plugin(str name)



        """
        return _casadi.XmlFile_load_plugin(*args)

    load_plugin = staticmethod(load_plugin)

    def doc(*args):
        """


        doc(str name) -> str



        """
        return _casadi.XmlFile_doc(*args)

    doc = staticmethod(doc)

    def __init__(self, *args):
        """


        XmlFile()
        XmlFile(XmlFile other)
        XmlFile(str name)



        """
        this = _casadi.new_XmlFile(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
XmlFile_swigregister = _casadi.XmlFile_swigregister
XmlFile_swigregister(XmlFile)

def XmlFile_type_name(*args):
    """


    type_name() -> str



    """
    return _casadi.XmlFile_type_name(*args)

def XmlFile_load_plugin(*args):
    """


    load_plugin(str name)



    """
    return _casadi.XmlFile_load_plugin(*args)

def XmlFile_doc(*args):
    """


    doc(str name) -> str



    """
    return _casadi.XmlFile_doc(*args)

class SerializerBase(_object):
    """
    C++ includes: serializer.hpp 




    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerializerBase, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SerializerBase, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _casadi.delete_SerializerBase

    def pack(self, *args):
        """


        pack(self, Linsol e)
        pack(self, std::vector< casadi::Linsol,std::allocator< casadi::Linsol > > const & e)
        pack(self, int e)
        pack(self, float e)
        pack(self, [Sparsity] e)
        pack(self, Sparsity e)
        pack(self, [float] e)
        pack(self, [int] e)
        pack(self, [str] e)
        pack(self, DM e)
        pack(self, [DM] e)
        pack(self, SX e)
        pack(self, [SX] e)
        pack(self, MX e)
        pack(self, [MX] e)
        pack(self, str e)
        pack(self, [Function] e)
        pack(self, Function e)
        pack(self, [GenericType] e)
        pack(self, GenericType e)



        """
        return _casadi.SerializerBase_pack(self, *args)

    _SERIALIZED_SPARSITY = _casadi.SerializerBase__SERIALIZED_SPARSITY
    _SERIALIZED_MX = _casadi.SerializerBase__SERIALIZED_MX
    _SERIALIZED_DM = _casadi.SerializerBase__SERIALIZED_DM
    _SERIALIZED_SX = _casadi.SerializerBase__SERIALIZED_SX
    _SERIALIZED_LINSOL = _casadi.SerializerBase__SERIALIZED_LINSOL
    _SERIALIZED_FUNCTION = _casadi.SerializerBase__SERIALIZED_FUNCTION
    _SERIALIZED_GENERICTYPE = _casadi.SerializerBase__SERIALIZED_GENERICTYPE
    _SERIALIZED_INT = _casadi.SerializerBase__SERIALIZED_INT
    _SERIALIZED_DOUBLE = _casadi.SerializerBase__SERIALIZED_DOUBLE
    _SERIALIZED_STRING = _casadi.SerializerBase__SERIALIZED_STRING
    _SERIALIZED_SPARSITY_VECTOR = _casadi.SerializerBase__SERIALIZED_SPARSITY_VECTOR
    _SERIALIZED_MX_VECTOR = _casadi.SerializerBase__SERIALIZED_MX_VECTOR
    _SERIALIZED_DM_VECTOR = _casadi.SerializerBase__SERIALIZED_DM_VECTOR
    _SERIALIZED_SX_VECTOR = _casadi.SerializerBase__SERIALIZED_SX_VECTOR
    _SERIALIZED_LINSOL_VECTOR = _casadi.SerializerBase__SERIALIZED_LINSOL_VECTOR
    _SERIALIZED_FUNCTION_VECTOR = _casadi.SerializerBase__SERIALIZED_FUNCTION_VECTOR
    _SERIALIZED_GENERICTYPE_VECTOR = _casadi.SerializerBase__SERIALIZED_GENERICTYPE_VECTOR
    _SERIALIZED_INT_VECTOR = _casadi.SerializerBase__SERIALIZED_INT_VECTOR
    _SERIALIZED_DOUBLE_VECTOR = _casadi.SerializerBase__SERIALIZED_DOUBLE_VECTOR
    _SERIALIZED_STRING_VECTOR = _casadi.SerializerBase__SERIALIZED_STRING_VECTOR

    def type_to_string(*args):
        """


        type_to_string(casadi::SerializerBase::SerializationType type) -> str



        """
        return _casadi.SerializerBase_type_to_string(*args)

    type_to_string = staticmethod(type_to_string)

    def connect(self, *args):
        """


        connect(self, DeserializerBase s)



        """
        return _casadi.SerializerBase_connect(self, *args)


    def reset(self, *args):
        """


        reset(self)



        """
        return _casadi.SerializerBase_reset(self, *args)

SerializerBase_swigregister = _casadi.SerializerBase_swigregister
SerializerBase_swigregister(SerializerBase)

def SerializerBase_type_to_string(*args):
    """


    type_to_string(casadi::SerializerBase::SerializationType type) -> str



    """
    return _casadi.SerializerBase_type_to_string(*args)

class DeserializerBase(_object):
    """
    C++ includes: serializer.hpp 




    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DeserializerBase, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DeserializerBase, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _casadi.delete_DeserializerBase

    def _pop_type(self, *args):
        """


        _pop_type(self) -> casadi::SerializerBase::SerializationType



        """
        return _casadi.DeserializerBase__pop_type(self, *args)


    def blind_unpack_sparsity(self, *args):
        """


        blind_unpack_sparsity(self) -> Sparsity



        """
        return _casadi.DeserializerBase_blind_unpack_sparsity(self, *args)


    def blind_unpack_mx(self, *args):
        """


        blind_unpack_mx(self) -> MX



        """
        return _casadi.DeserializerBase_blind_unpack_mx(self, *args)


    def blind_unpack_dm(self, *args):
        """


        blind_unpack_dm(self) -> DM



        """
        return _casadi.DeserializerBase_blind_unpack_dm(self, *args)


    def blind_unpack_sx(self, *args):
        """


        blind_unpack_sx(self) -> SX



        """
        return _casadi.DeserializerBase_blind_unpack_sx(self, *args)


    def blind_unpack_linsol(self, *args):
        """


        blind_unpack_linsol(self) -> Linsol



        """
        return _casadi.DeserializerBase_blind_unpack_linsol(self, *args)


    def blind_unpack_function(self, *args):
        """


        blind_unpack_function(self) -> Function



        """
        return _casadi.DeserializerBase_blind_unpack_function(self, *args)


    def blind_unpack_generictype(self, *args):
        """


        blind_unpack_generictype(self) -> GenericType



        """
        return _casadi.DeserializerBase_blind_unpack_generictype(self, *args)


    def blind_unpack_int(self, *args):
        """


        blind_unpack_int(self) -> int



        """
        return _casadi.DeserializerBase_blind_unpack_int(self, *args)


    def blind_unpack_double(self, *args):
        """


        blind_unpack_double(self) -> float



        """
        return _casadi.DeserializerBase_blind_unpack_double(self, *args)


    def blind_unpack_string(self, *args):
        """


        blind_unpack_string(self) -> str



        """
        return _casadi.DeserializerBase_blind_unpack_string(self, *args)


    def blind_unpack_sparsity_vector(self, *args):
        """


        blind_unpack_sparsity_vector(self) -> [Sparsity]



        """
        return _casadi.DeserializerBase_blind_unpack_sparsity_vector(self, *args)


    def blind_unpack_mx_vector(self, *args):
        """


        blind_unpack_mx_vector(self) -> [MX]



        """
        return _casadi.DeserializerBase_blind_unpack_mx_vector(self, *args)


    def blind_unpack_dm_vector(self, *args):
        """


        blind_unpack_dm_vector(self) -> [DM]



        """
        return _casadi.DeserializerBase_blind_unpack_dm_vector(self, *args)


    def blind_unpack_sx_vector(self, *args):
        """


        blind_unpack_sx_vector(self) -> [SX]



        """
        return _casadi.DeserializerBase_blind_unpack_sx_vector(self, *args)


    def blind_unpack_linsol_vector(self, *args):
        """


        blind_unpack_linsol_vector(self) -> std::vector< casadi::Linsol,std::allocator< casadi::Linsol > >



        """
        return _casadi.DeserializerBase_blind_unpack_linsol_vector(self, *args)


    def blind_unpack_function_vector(self, *args):
        """


        blind_unpack_function_vector(self) -> [Function]



        """
        return _casadi.DeserializerBase_blind_unpack_function_vector(self, *args)


    def blind_unpack_generictype_vector(self, *args):
        """


        blind_unpack_generictype_vector(self) -> [GenericType]



        """
        return _casadi.DeserializerBase_blind_unpack_generictype_vector(self, *args)


    def blind_unpack_int_vector(self, *args):
        """


        blind_unpack_int_vector(self) -> [int]



        """
        return _casadi.DeserializerBase_blind_unpack_int_vector(self, *args)


    def blind_unpack_double_vector(self, *args):
        """


        blind_unpack_double_vector(self) -> [float]



        """
        return _casadi.DeserializerBase_blind_unpack_double_vector(self, *args)


    def blind_unpack_string_vector(self, *args):
        """


        blind_unpack_string_vector(self) -> [str]



        """
        return _casadi.DeserializerBase_blind_unpack_string_vector(self, *args)


    def unpack_sparsity(self, *args):
        """


        unpack_sparsity(self) -> Sparsity



        """
        return _casadi.DeserializerBase_unpack_sparsity(self, *args)


    def unpack_mx(self, *args):
        """


        unpack_mx(self) -> MX



        """
        return _casadi.DeserializerBase_unpack_mx(self, *args)


    def unpack_dm(self, *args):
        """


        unpack_dm(self) -> DM



        """
        return _casadi.DeserializerBase_unpack_dm(self, *args)


    def unpack_sx(self, *args):
        """


        unpack_sx(self) -> SX



        """
        return _casadi.DeserializerBase_unpack_sx(self, *args)


    def unpack_linsol(self, *args):
        """


        unpack_linsol(self) -> Linsol



        """
        return _casadi.DeserializerBase_unpack_linsol(self, *args)


    def unpack_function(self, *args):
        """


        unpack_function(self) -> Function



        """
        return _casadi.DeserializerBase_unpack_function(self, *args)


    def unpack_generictype(self, *args):
        """


        unpack_generictype(self) -> GenericType



        """
        return _casadi.DeserializerBase_unpack_generictype(self, *args)


    def unpack_int(self, *args):
        """


        unpack_int(self) -> int



        """
        return _casadi.DeserializerBase_unpack_int(self, *args)


    def unpack_double(self, *args):
        """


        unpack_double(self) -> float



        """
        return _casadi.DeserializerBase_unpack_double(self, *args)


    def unpack_string(self, *args):
        """


        unpack_string(self) -> str



        """
        return _casadi.DeserializerBase_unpack_string(self, *args)


    def unpack_sparsity_vector(self, *args):
        """


        unpack_sparsity_vector(self) -> [Sparsity]



        """
        return _casadi.DeserializerBase_unpack_sparsity_vector(self, *args)


    def unpack_mx_vector(self, *args):
        """


        unpack_mx_vector(self) -> [MX]



        """
        return _casadi.DeserializerBase_unpack_mx_vector(self, *args)


    def unpack_dm_vector(self, *args):
        """


        unpack_dm_vector(self) -> [DM]



        """
        return _casadi.DeserializerBase_unpack_dm_vector(self, *args)


    def unpack_sx_vector(self, *args):
        """


        unpack_sx_vector(self) -> [SX]



        """
        return _casadi.DeserializerBase_unpack_sx_vector(self, *args)


    def unpack_linsol_vector(self, *args):
        """


        unpack_linsol_vector(self) -> std::vector< casadi::Linsol,std::allocator< casadi::Linsol > >



        """
        return _casadi.DeserializerBase_unpack_linsol_vector(self, *args)


    def unpack_function_vector(self, *args):
        """


        unpack_function_vector(self) -> [Function]



        """
        return _casadi.DeserializerBase_unpack_function_vector(self, *args)


    def unpack_generictype_vector(self, *args):
        """


        unpack_generictype_vector(self) -> [GenericType]



        """
        return _casadi.DeserializerBase_unpack_generictype_vector(self, *args)


    def unpack_int_vector(self, *args):
        """


        unpack_int_vector(self) -> [int]



        """
        return _casadi.DeserializerBase_unpack_int_vector(self, *args)


    def unpack_double_vector(self, *args):
        """


        unpack_double_vector(self) -> [float]



        """
        return _casadi.DeserializerBase_unpack_double_vector(self, *args)


    def unpack_string_vector(self, *args):
        """


        unpack_string_vector(self) -> [str]



        """
        return _casadi.DeserializerBase_unpack_string_vector(self, *args)


    def connect(self, *args):
        """


        connect(self, SerializerBase s)



        """
        return _casadi.DeserializerBase_connect(self, *args)


    def reset(self, *args):
        """


        reset(self)



        """
        return _casadi.DeserializerBase_reset(self, *args)


    def unpack(self):
      type = SerializerBase.type_to_string(self._pop_type())
      f = getattr(self, "blind_unpack_"+type)
      return f()

DeserializerBase_swigregister = _casadi.DeserializerBase_swigregister
DeserializerBase_swigregister(DeserializerBase)

class StringSerializer(SerializerBase):
    """
    C++ includes: serializer.hpp 




    """

    __swig_setmethods__ = {}
    for _s in [SerializerBase]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StringSerializer, name, value)
    __swig_getmethods__ = {}
    for _s in [SerializerBase]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, StringSerializer, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        StringSerializer(dict opts)



        """
        this = _casadi.new_StringSerializer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_StringSerializer

    def encode(self, *args):
        """
          Returns a string that holds the serialized objects.

          encode(self) -> str


        As a side effect, this method clears the internal buffer




        """
        return _casadi.StringSerializer_encode(self, *args)

StringSerializer_swigregister = _casadi.StringSerializer_swigregister
StringSerializer_swigregister(StringSerializer)

class FileSerializer(SerializerBase):
    """
    C++ includes: serializer.hpp 




    """

    __swig_setmethods__ = {}
    for _s in [SerializerBase]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FileSerializer, name, value)
    __swig_getmethods__ = {}
    for _s in [SerializerBase]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FileSerializer, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
          Advanced serialization of CasADi objects.

          FileSerializer(str fname, dict opts)


        StringSerializer, FileDeserializer




        """
        this = _casadi.new_FileSerializer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_FileSerializer
FileSerializer_swigregister = _casadi.FileSerializer_swigregister
FileSerializer_swigregister(FileSerializer)

class StringDeserializer(DeserializerBase):
    """
    C++ includes: serializer.hpp 




    """

    __swig_setmethods__ = {}
    for _s in [DeserializerBase]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StringDeserializer, name, value)
    __swig_getmethods__ = {}
    for _s in [DeserializerBase]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, StringDeserializer, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
          Advanced deserialization of CasADi objects.

          StringDeserializer(str string)


        StringDeserializer




        """
        this = _casadi.new_StringDeserializer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_StringDeserializer

    def decode(self, *args):
        """
        Sets the string to deserialize objects from.

        decode(self, str string)





        """
        return _casadi.StringDeserializer_decode(self, *args)

StringDeserializer_swigregister = _casadi.StringDeserializer_swigregister
StringDeserializer_swigregister(StringDeserializer)

class FileDeserializer(DeserializerBase):
    """
    C++ includes: serializer.hpp 




    """

    __swig_setmethods__ = {}
    for _s in [DeserializerBase]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FileDeserializer, name, value)
    __swig_getmethods__ = {}
    for _s in [DeserializerBase]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FileDeserializer, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
          Advanced deserialization of CasADi objects.

          FileDeserializer(str fname)


        FileSerializer




        """
        this = _casadi.new_FileDeserializer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_FileDeserializer
FileDeserializer_swigregister = _casadi.FileDeserializer_swigregister
FileDeserializer_swigregister(FileDeserializer)

class Opti(PrintableCommon, SharedObject):
    """
      A simplified interface for NLP modeling/solving.



    This class offers a view with model description facilities The API is
    guaranteed to be stable.

    Example NLP:

    ::

        opti = casadi.Opti();

        x = opti.variable();
        y = opti.variable();

        opti.minimize(  (y-x^2)^2   );
        opti.subject_to( x^2+y^2==1 );
        opti.subject_to(     x+y>=1 );

        opti.solver('ipopt');
        sol = opti.solve();

        sol.value(x)
        sol.value(y)



    Example parametric NLP:

    ::

        opti = casadi.Opti();

        x = opti.variable(2,1);
        p = opti.parameter();

        opti.minimize(  (p*x(2)-x(1)^2)^2   );
        opti.subject_to( 1<=sum(x)<=2 );

        opti.solver('ipopt');

        opti.set_value(p, 3);
        sol = opti.solve();
        sol.value(x)

        opti.set_value(p, 5);
        sol = opti.solve();
        sol.value(x)



    Joris Gillis, Erik Lambrechts, Joel Andersson

    C++ includes: optistack.hpp 


    """

    __swig_setmethods__ = {}
    for _s in [PrintableCommon, SharedObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Opti, name, value)
    __swig_getmethods__ = {}
    for _s in [PrintableCommon, SharedObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Opti, name)
    __repr__ = _swig_repr

    def _variable(self, *args):
        """
          Create a decision variable (symbol)

          _variable(self, int n, int m, str attribute) -> MX


        The order of creation matters. The order will be reflected in the
        optimization problem. It is not required for decision variables to actualy
        appear in the optimization problem.

        Parameters:
        -----------

        n:  number of rows (default 1)

        m:  number of columnss (default 1)

        attribute:  'full' (default) or 'symmetric'




        """
        return _casadi.Opti__variable(self, *args)


    def _parameter(self, *args):
        """
          Create a parameter (symbol); fixed during optimization.

          _parameter(self, int n, int m, str attribute) -> MX


        The order of creation does not matter. It is not required for parameter to
        actualy appear in the optimization problem. Parameters that do appear, must
        be given a value before the problem can be solved.

        Parameters:
        -----------

        n:  number of rows (default 1)

        m:  number of columnss (default 1)

        attribute:  'full' (default) or 'symmetric'




        """
        return _casadi.Opti__parameter(self, *args)


    def minimize(self, *args):
        """
          Set objective.

          minimize(self, MX f)


        Objective must be a scalar. Default objective: 0 When method is called
        multiple times, the last call takes effect




        """
        return _casadi.Opti_minimize(self, *args)


    def _subject_to(self, *args):
        """
          Clear constraints.

          _subject_to(self)
          _subject_to(self, MX g)
          _subject_to(self, [MX] g)




        .......

        ::

          _subject_to(self)



        Clear constraints.



        .............


        .......

        ::

          _subject_to(self, MX g)
          _subject_to(self, [MX] g)



        Add constraints.

        Examples:

        ::

          * \\begin{itemize}
          * opti.subject_to( sqrt(x+y) >= 1);
          * opti.subject_to( sqrt(x+y) > 1)}: same as above
          * opti.subject_to( 1<= sqrt(x+y) )}: same as above
          * opti.subject_to( 5*x+y==1 )}: equality
          *
          * Python
          * opti.subject_to([x*y>=1,x==3])
          * opti.subject_to(opti.bounded(0,x,1))
          *
          * MATLAB
          * opti.subject_to({x*y>=1,x==3})
          * opti.subject_to( 0<=x<=1 )
          * 



        Related functionalities: opti.lbg,opti.g,opti.ubg represent the vector of
        flattened constraints

        opti.debug.show_infeasibilities() may be used to inspect which constraints
        are violated



        .............



        """
        return _casadi.Opti__subject_to(self, *args)


    def solver(self, *args):
        """
          Set a solver.

          solver(self, str solver, dict plugin_options, dict solver_options)


        Parameters:
        -----------

        solver:  any of the nlpsol plugins can be used here In practice, not all
        nlpsol plugins may be supported yet

        options:  passed on to nlpsol plugin No stability can be guaranteed about
        this part of the API

        options:  to be passed to nlpsol solver No stability can be guaranteed about
        this part of the API




        """
        return _casadi.Opti_solver(self, *args)


    def set_initial(self, *args):
        """
          Set initial guess for decision variables

          set_initial(self, [MX] assignments)
          set_initial(self, MX x, DM v)


        ::

          * opti.set_initial(x, 2)
          * opti.set_initial(10*x(1), 2)
          * 






        """
        return _casadi.Opti_set_initial(self, *args)


    def set_value(self, *args):
        """
          Set value of parameter.

          set_value(self, [MX] assignments)
          set_value(self, MX x, DM v)


        Each parameter must be given a value before 'solve' can be called




        """
        return _casadi.Opti_set_value(self, *args)


    def solve(self, *args):
        """
        Crunch the numbers; solve the problem.

        solve(self) -> OptiSol





        """
        return _casadi.Opti_solve(self, *args)


    def solve_limited(self, *args):
        """
          Crunch the numbers; solve the problem.

          solve_limited(self) -> OptiSol


        Allows the solver to return without error when an iteration or time limit is
        reached




        """
        return _casadi.Opti_solve_limited(self, *args)


    def value(self, *args):
        """
          Obtain value of expression at the current value

          value(self, DM x, [MX] values) -> double
          value(self, SX x, [MX] values) -> double
          value(self, MX x, [MX] values) -> double


        In regular mode, teh current value is the converged solution In debug mode,
        the value can be non-converged

        Parameters:
        -----------

        values:  Optional assignment expressions (e.g. x==3) to overrule the current
        value




        """
        return _casadi.Opti_value(self, *args)


    def stats(self, *args):
        """
          Get statistics.

          stats(self) -> dict


        nlpsol stats are passed as-is. No stability can be guaranteed about this
        part of the API




        """
        return _casadi.Opti_stats(self, *args)


    def return_status(self, *args):
        """
          Get return status of solver passed as-is from nlpsol No stability can be

          return_status(self) -> str

        guaranteed about this part of the API.




        """
        return _casadi.Opti_return_status(self, *args)


    def initial(self, *args):
        """
        get assignment expressions for initial values

        initial(self) -> [MX]





        """
        return _casadi.Opti_initial(self, *args)


    def value_variables(self, *args):
        """
        get assignment expressions for latest values

        value_variables(self) -> [MX]





        """
        return _casadi.Opti_value_variables(self, *args)


    def value_parameters(self, *args):
        """


        value_parameters(self) -> [MX]



        """
        return _casadi.Opti_value_parameters(self, *args)


    def dual(self, *args):
        """
          get the dual variable

          dual(self, MX m) -> MX


        m must be a constraint expression. The returned value is still a symbolic
        expression. Use value on it to obtain the numerical value.




        """
        return _casadi.Opti_dual(self, *args)


    def _nx(self, *args):
        """
        Number of (scalarised) decision variables.

        _nx(self) -> int





        """
        return _casadi.Opti__nx(self, *args)


    def _np(self, *args):
        """
        Number of (scalarised) parameters.

        _np(self) -> int





        """
        return _casadi.Opti__np(self, *args)


    def _ng(self, *args):
        """
        Number of (scalarised) constraints.

        _ng(self) -> int





        """
        return _casadi.Opti__ng(self, *args)


    def _x(self, *args):
        """
        Get all (scalarised) decision variables as a symbolic column vector.

        _x(self) -> MX





        """
        return _casadi.Opti__x(self, *args)


    def _p(self, *args):
        """
        Get all (scalarised) parameters as a symbolic column vector.

        _p(self) -> MX





        """
        return _casadi.Opti__p(self, *args)


    def _g(self, *args):
        """
        Get all (scalarised) constraint expressions as a column vector.

        _g(self) -> MX





        """
        return _casadi.Opti__g(self, *args)


    def _f(self, *args):
        """
        Get objective expression.

        _f(self) -> MX





        """
        return _casadi.Opti__f(self, *args)


    def _lbg(self, *args):
        """
        Get all (scalarised) bounds on constraints as a column vector.

        _lbg(self) -> MX





        """
        return _casadi.Opti__lbg(self, *args)


    def _ubg(self, *args):
        """


        _ubg(self) -> MX



        """
        return _casadi.Opti__ubg(self, *args)


    def _lam_g(self, *args):
        """
          Get all (scalarised) dual variables as a symbolic column vector.

          _lam_g(self) -> MX


        Useful for obtaining the Lagrange Hessian:

        ::

          * sol.value(hessian(opti.f+opti.lam_g'*opti.g,opti.x)) % MATLAB
          * sol.value(hessian(opti.f+dot(opti.lam_g,opti.g),opti.x)[0]) # Python
          * 






        """
        return _casadi.Opti__lam_g(self, *args)


    def to_function(self, *args):
        """


          to_function(self, str name, [MX] args, [MX] res, dict opts) -> Function
          to_function(self, str name, dict:MX dict, [str] name_in, [str] name_out, dict opts) -> Function
          to_function(self, str name, [MX] args, [MX] res, [str] name_in, [str] name_out, dict opts) -> Function


        .......

        ::

          to_function(self, str name, dict:MX dict, [str] name_in, [str] name_out, dict opts)
          to_function(self, str name, [MX] args, [MX] res, [str] name_in, [str] name_out, dict opts)



        .............


        .......

        ::

          to_function(self, str name, [MX] args, [MX] res, dict opts)



        Create a CasADi Function from the Opti solver.



        .............



        """
        return _casadi.Opti_to_function(self, *args)


    def bounded(*args):
        """


        bounded(MX lb, MX expr, MX ub) -> MX



        """
        return _casadi.Opti_bounded(*args)

    bounded = staticmethod(bounded)

    def _debug(self, *args):
        """
          Get a copy with advanced functionality.

          _debug(self) -> OptiAdvanced


        You get access to more methods, but you have no guarantees about API
        stability

        The copy is effectively a deep copy: Updating the state of the copy does not
        update the original.




        """
        return _casadi.Opti__debug(self, *args)


    def _advanced(self, *args):
        """
          Get a copy with advanced functionality.

          _advanced(self) -> OptiAdvanced


        You get access to more methods, but you have no guarantees about API
        stability

        The copy is effectively a deep copy: Updating the state of the copy does not
        update the original.




        """
        return _casadi.Opti__advanced(self, *args)


    def copy(self, *args):
        """
          Get a copy of the.

          copy(self) -> Opti


        The copy is effectively a deep copy: Updating the state of the copy does not
        update the original.




        """
        return _casadi.Opti_copy(self, *args)


    def update_user_dict(self, *args):
        """


          update_user_dict(self, MX m, dict meta)
          update_user_dict(self, [MX] m, dict meta)


        .......

        ::

          update_user_dict(self, [MX] m, dict meta)



        .............


        .......

        ::

          update_user_dict(self, MX m, dict meta)



        add user data Add arbitrary data in the form of a dictionary to symbols or
        constraints



        .............



        """
        return _casadi.Opti_update_user_dict(self, *args)


    def user_dict(self, *args):
        """
        Get user data.

        user_dict(self, MX m) -> dict





        """
        return _casadi.Opti_user_dict(self, *args)


    def type_name(self, *args):
        """
        Readable name of the class.

        type_name(self) -> str





        """
        return _casadi.Opti_type_name(self, *args)


    def disp(self, *args):
        """
        Print representation.

        disp(self, bool more)





        """
        return _casadi.Opti_disp(self, *args)


    def str(self, *args):
        """
        Get string representation.

        str(self, bool more) -> str





        """
        return _casadi.Opti_str(self, *args)


    def callback_class(self, *args):
        """
          Helper methods for callback()

          callback_class(self)
          callback_class(self, OptiCallback callback)


        Do not use directly.




        """
        return _casadi.Opti_callback_class(self, *args)


    @property
    def debug(self):
      return self._debug()


    @property
    def advanced(self):
      return self._advanced()


    @property
    def f(self):
      return self._f()


    @property
    def g(self):
      return self._g()


    @property
    def x(self):
      return self._x()


    @property
    def p(self):
      return self._p()


    @property
    def lam_g(self):
      return self._lam_g()


    @property
    def lbg(self):
      return self._lbg()


    @property
    def ubg(self):
      return self._ubg()


    @property
    def nx(self):
      return self._nx()


    @property
    def np(self):
      return self._np()


    @property
    def ng(self):
      return self._ng()


    @property
    def casadi_solver(self):
      return self._casadi_solver()


    def parameter(self,*args):
      import sys
      import os
      frame = sys._getframe(1)
      meta = {"stacktrace": {"file":os.path.abspath(frame.f_code.co_filename),"line":frame.f_lineno,"name":frame.f_code.co_name}}
      ret = self._parameter(*args)
      self.update_user_dict(ret, meta)
      return ret

    def variable(self,*args):
      import sys
      import os
      frame = sys._getframe(1)
      meta = {"stacktrace": {"file":os.path.abspath(frame.f_code.co_filename),"line":frame.f_lineno,"name":frame.f_code.co_name}}
      ret = self._variable(*args)
      self.update_user_dict(ret, meta)
      return ret

    def subject_to(self,*args):
      if len(args)==0:
        return self._subject_to()
      import sys
      import os
      frame = sys._getframe(1)
      meta = {"stacktrace": {"file":os.path.abspath(frame.f_code.co_filename),"line":frame.f_lineno,"name":frame.f_code.co_name}}
      ret = self._subject_to(*args)
      self.update_user_dict(args[0], meta)
      return ret



    @staticmethod
    def _callback(self,fh=None):
      if fh is None:
        self.callback_class();
        return
      class OptiCallbackHelper(OptiCallback):
          def __init__(self, callback):
            OptiCallback.__init__(self)
            self.callback = callback

          def call(self, i):
            self.callback(i)

      self._fh = fh
      self._cb = OptiCallbackHelper(fh);
      self.callback_class(self._cb);


    def callback(self,fh=None):
      self._callback(self,fh)




    def __init__(self, *args):
        """


          Opti(str problem_type)
          Opti(Opti other)


        .......

        ::

          Opti(Opti other)



        .............


        .......

        ::

          Opti(str problem_type)



        Create Opti Context.

        Parameters:
        -----------

        problem_type:  of optimization 'nlp' or 'conic' (default nlp)



        .............



        """
        this = _casadi.new_Opti(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_Opti
Opti_swigregister = _casadi.Opti_swigregister
Opti_swigregister(Opti)

def Opti_bounded(*args):
    """


    bounded(MX lb, MX expr, MX ub) -> MX



    """
    return _casadi.Opti_bounded(*args)

OPTI_GENERIC_EQUALITY = _casadi.OPTI_GENERIC_EQUALITY
OPTI_GENERIC_INEQUALITY = _casadi.OPTI_GENERIC_INEQUALITY
OPTI_EQUALITY = _casadi.OPTI_EQUALITY
OPTI_INEQUALITY = _casadi.OPTI_INEQUALITY
OPTI_DOUBLE_INEQUALITY = _casadi.OPTI_DOUBLE_INEQUALITY
OPTI_PSD = _casadi.OPTI_PSD
OPTI_UNKNOWN = _casadi.OPTI_UNKNOWN
OPTI_VAR = _casadi.OPTI_VAR
OPTI_PAR = _casadi.OPTI_PAR
OPTI_DUAL_G = _casadi.OPTI_DUAL_G
class IndexAbstraction(_object):
    """


    IndexAbstraction() -> 



    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, IndexAbstraction, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, IndexAbstraction, name)
    __repr__ = _swig_repr
    __swig_getmethods__["start"] = _casadi.IndexAbstraction_start_get
    if _newclass:
        start = _swig_property(_casadi.IndexAbstraction_start_get)
    __swig_getmethods__["stop"] = _casadi.IndexAbstraction_stop_get
    if _newclass:
        stop = _swig_property(_casadi.IndexAbstraction_stop_get)

    def __init__(self, *args):
        """


        IndexAbstraction()
        IndexAbstraction(IndexAbstraction other)



        """
        this = _casadi.new_IndexAbstraction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_IndexAbstraction
IndexAbstraction_swigregister = _casadi.IndexAbstraction_swigregister
IndexAbstraction_swigregister(IndexAbstraction)

class MetaCon(IndexAbstraction):
    """


    MetaCon() -> 



    """

    __swig_setmethods__ = {}
    for _s in [IndexAbstraction]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MetaCon, name, value)
    __swig_getmethods__ = {}
    for _s in [IndexAbstraction]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MetaCon, name)
    __repr__ = _swig_repr
    __swig_getmethods__["original"] = _casadi.MetaCon_original_get
    if _newclass:
        original = _swig_property(_casadi.MetaCon_original_get)
    __swig_getmethods__["canon"] = _casadi.MetaCon_canon_get
    if _newclass:
        canon = _swig_property(_casadi.MetaCon_canon_get)
    __swig_getmethods__["type"] = _casadi.MetaCon_type_get
    if _newclass:
        type = _swig_property(_casadi.MetaCon_type_get)
    __swig_getmethods__["lb"] = _casadi.MetaCon_lb_get
    if _newclass:
        lb = _swig_property(_casadi.MetaCon_lb_get)
    __swig_getmethods__["ub"] = _casadi.MetaCon_ub_get
    if _newclass:
        ub = _swig_property(_casadi.MetaCon_ub_get)
    __swig_getmethods__["n"] = _casadi.MetaCon_n_get
    if _newclass:
        n = _swig_property(_casadi.MetaCon_n_get)
    __swig_getmethods__["flipped"] = _casadi.MetaCon_flipped_get
    if _newclass:
        flipped = _swig_property(_casadi.MetaCon_flipped_get)
    __swig_getmethods__["dual_canon"] = _casadi.MetaCon_dual_canon_get
    if _newclass:
        dual_canon = _swig_property(_casadi.MetaCon_dual_canon_get)
    __swig_getmethods__["dual"] = _casadi.MetaCon_dual_get
    if _newclass:
        dual = _swig_property(_casadi.MetaCon_dual_get)
    __swig_getmethods__["extra"] = _casadi.MetaCon_extra_get
    if _newclass:
        extra = _swig_property(_casadi.MetaCon_extra_get)

    def __init__(self, *args):
        """


        MetaCon()
        MetaCon(MetaCon other)



        """
        this = _casadi.new_MetaCon(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_MetaCon
MetaCon_swigregister = _casadi.MetaCon_swigregister
MetaCon_swigregister(MetaCon)

class MetaVar(IndexAbstraction):
    """


    MetaVar() -> 



    """

    __swig_setmethods__ = {}
    for _s in [IndexAbstraction]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MetaVar, name, value)
    __swig_getmethods__ = {}
    for _s in [IndexAbstraction]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MetaVar, name)
    __repr__ = _swig_repr
    __swig_getmethods__["attribute"] = _casadi.MetaVar_attribute_get
    if _newclass:
        attribute = _swig_property(_casadi.MetaVar_attribute_get)
    __swig_getmethods__["n"] = _casadi.MetaVar_n_get
    if _newclass:
        n = _swig_property(_casadi.MetaVar_n_get)
    __swig_getmethods__["m"] = _casadi.MetaVar_m_get
    if _newclass:
        m = _swig_property(_casadi.MetaVar_m_get)
    __swig_getmethods__["type"] = _casadi.MetaVar_type_get
    if _newclass:
        type = _swig_property(_casadi.MetaVar_type_get)
    __swig_getmethods__["count"] = _casadi.MetaVar_count_get
    if _newclass:
        count = _swig_property(_casadi.MetaVar_count_get)
    __swig_getmethods__["i"] = _casadi.MetaVar_i_get
    if _newclass:
        i = _swig_property(_casadi.MetaVar_i_get)
    __swig_getmethods__["active_i"] = _casadi.MetaVar_active_i_get
    if _newclass:
        active_i = _swig_property(_casadi.MetaVar_active_i_get)
    __swig_getmethods__["extra"] = _casadi.MetaVar_extra_get
    if _newclass:
        extra = _swig_property(_casadi.MetaVar_extra_get)

    def __init__(self, *args):
        """


        MetaVar()
        MetaVar(MetaVar other)



        """
        this = _casadi.new_MetaVar(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_MetaVar
MetaVar_swigregister = _casadi.MetaVar_swigregister
MetaVar_swigregister(MetaVar)

class OptiCallback(_object):
    """
    C++ includes: optistack.hpp 




    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptiCallback, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, OptiCallback, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        OptiCallback(self)
        OptiCallback(self, OptiCallback obj)



        """
        if self.__class__ == OptiCallback:
            _self = None
        else:
            _self = self
        this = _casadi.new_OptiCallback(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def call(self, *args):
        """


        call(self, int i)



        """
        return _casadi.OptiCallback_call(self, *args)

    __swig_destroy__ = _casadi.delete_OptiCallback
    def __disown__(self):
        self.this.disown()
        _casadi.disown_OptiCallback(self)
        return weakref_proxy(self)
OptiCallback_swigregister = _casadi.OptiCallback_swigregister
OptiCallback_swigregister(OptiCallback)

class OptiAdvanced(Opti):
    """
    C++ includes: optistack.hpp 




    """

    __swig_setmethods__ = {}
    for _s in [Opti]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptiAdvanced, name, value)
    __swig_getmethods__ = {}
    for _s in [Opti]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OptiAdvanced, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _casadi.delete_OptiAdvanced

    def _casadi_solver(self, *args):
        """
        Get the underlying CasADi solver of the Opti stack.

        _casadi_solver(self) -> Function





        """
        return _casadi.OptiAdvanced__casadi_solver(self, *args)


    def is_parametric(self, *args):
        """
          return true if expression is only dependant on Opti parameters, not

          is_parametric(self, MX expr) -> bool

        variables




        """
        return _casadi.OptiAdvanced_is_parametric(self, *args)


    def symvar(self, *args):
        """
          Get symbols present in expression.

          symvar(self) -> [MX]
          symvar(self, MX expr) -> [MX]
          symvar(self, MX expr, casadi::VariableType type) -> [MX]


        Returned vector is ordered according to the order of variable()/parameter()
        calls used to create the variables




        """
        return _casadi.OptiAdvanced_symvar(self, *args)


    def canon_expr(self, *args):
        """
        Interpret an expression (for internal use only)

        canon_expr(self, MX expr) -> MetaCon





        """
        return _casadi.OptiAdvanced_canon_expr(self, *args)


    def get_meta(self, *args):
        """
        Get meta-data of symbol (for internal use only)

        get_meta(self, MX m) -> MetaVar





        """
        return _casadi.OptiAdvanced_get_meta(self, *args)


    def get_meta_con(self, *args):
        """
        Get meta-data of symbol (for internal use only)

        get_meta_con(self, MX m) -> MetaCon





        """
        return _casadi.OptiAdvanced_get_meta_con(self, *args)


    def set_meta(self, *args):
        """
        Set meta-data of an expression.

        set_meta(self, MX m, MetaVar meta)





        """
        return _casadi.OptiAdvanced_set_meta(self, *args)


    def set_meta_con(self, *args):
        """
        Set meta-data of an expression.

        set_meta_con(self, MX m, MetaCon meta)





        """
        return _casadi.OptiAdvanced_set_meta_con(self, *args)


    def assert_active_symbol(self, *args):
        """


        assert_active_symbol(self, MX m)



        """
        return _casadi.OptiAdvanced_assert_active_symbol(self, *args)


    def active_symvar(self, *args):
        """


        active_symvar(self, casadi::VariableType type) -> [MX]



        """
        return _casadi.OptiAdvanced_active_symvar(self, *args)


    def active_values(self, *args):
        """


        active_values(self, casadi::VariableType type) -> [DM]



        """
        return _casadi.OptiAdvanced_active_values(self, *args)


    def x_lookup(self, *args):
        """


        x_lookup(self, int i) -> MX



        """
        return _casadi.OptiAdvanced_x_lookup(self, *args)


    def g_lookup(self, *args):
        """


        g_lookup(self, int i) -> MX



        """
        return _casadi.OptiAdvanced_g_lookup(self, *args)


    def x_describe(self, *args):
        """


        x_describe(self, int i) -> str



        """
        return _casadi.OptiAdvanced_x_describe(self, *args)


    def g_describe(self, *args):
        """


        g_describe(self, int i) -> str



        """
        return _casadi.OptiAdvanced_g_describe(self, *args)


    def describe(self, *args):
        """


        describe(self, MX x, int indent) -> str



        """
        return _casadi.OptiAdvanced_describe(self, *args)


    def show_infeasibilities(self, *args):
        """


        show_infeasibilities(self, float tol)



        """
        return _casadi.OptiAdvanced_show_infeasibilities(self, *args)


    def solve_prepare(self, *args):
        """


        solve_prepare(self)



        """
        return _casadi.OptiAdvanced_solve_prepare(self, *args)


    def solve_actual(self, *args):
        """


        solve_actual(self, dict:DM args) -> dict:DM



        """
        return _casadi.OptiAdvanced_solve_actual(self, *args)


    def arg(self, *args):
        """


        arg(self) -> dict:DM



        """
        return _casadi.OptiAdvanced_arg(self, *args)


    def res(self, *args):
        """


        res(self) -> dict:DM
        res(self, dict:DM res)



        """
        return _casadi.OptiAdvanced_res(self, *args)


    def constraints(self, *args):
        """


        constraints(self) -> [MX]



        """
        return _casadi.OptiAdvanced_constraints(self, *args)


    def objective(self, *args):
        """


        objective(self) -> MX



        """
        return _casadi.OptiAdvanced_objective(self, *args)


    def baked_copy(self, *args):
        """


        baked_copy(self) -> OptiAdvanced



        """
        return _casadi.OptiAdvanced_baked_copy(self, *args)


    def assert_empty(self, *args):
        """


        assert_empty(self)



        """
        return _casadi.OptiAdvanced_assert_empty(self, *args)


    def bake(self, *args):
        """
        Fix the structure of the optimization problem.

        bake(self)





        """
        return _casadi.OptiAdvanced_bake(self, *args)

    __swig_getmethods__["problem_dirty_"] = _casadi.OptiAdvanced_problem_dirty__get
    if _newclass:
        problem_dirty_ = _swig_property(_casadi.OptiAdvanced_problem_dirty__get)

    def mark_problem_dirty(self, *args):
        """


        mark_problem_dirty(self, bool flag)



        """
        return _casadi.OptiAdvanced_mark_problem_dirty(self, *args)


    def problem_dirty(self, *args):
        """


        problem_dirty(self) -> bool



        """
        return _casadi.OptiAdvanced_problem_dirty(self, *args)

    __swig_getmethods__["solver_dirty_"] = _casadi.OptiAdvanced_solver_dirty__get
    if _newclass:
        solver_dirty_ = _swig_property(_casadi.OptiAdvanced_solver_dirty__get)

    def mark_solver_dirty(self, *args):
        """


        mark_solver_dirty(self, bool flag)



        """
        return _casadi.OptiAdvanced_mark_solver_dirty(self, *args)


    def solver_dirty(self, *args):
        """


        solver_dirty(self) -> bool



        """
        return _casadi.OptiAdvanced_solver_dirty(self, *args)

    __swig_getmethods__["solved_"] = _casadi.OptiAdvanced_solved__get
    if _newclass:
        solved_ = _swig_property(_casadi.OptiAdvanced_solved__get)

    def mark_solved(self, *args):
        """


        mark_solved(self, bool flag)



        """
        return _casadi.OptiAdvanced_mark_solved(self, *args)


    def solved(self, *args):
        """


        solved(self) -> bool



        """
        return _casadi.OptiAdvanced_solved(self, *args)


    def assert_solved(self, *args):
        """


        assert_solved(self)



        """
        return _casadi.OptiAdvanced_assert_solved(self, *args)


    def assert_baked(self, *args):
        """


        assert_baked(self)



        """
        return _casadi.OptiAdvanced_assert_baked(self, *args)


    def instance_number(self, *args):
        """


        instance_number(self) -> int



        """
        return _casadi.OptiAdvanced_instance_number(self, *args)


    def __init__(self, *args):
        """


        OptiAdvanced(OptiAdvanced other)
        OptiAdvanced(Opti x)



        """
        this = _casadi.new_OptiAdvanced(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
OptiAdvanced_swigregister = _casadi.OptiAdvanced_swigregister
OptiAdvanced_swigregister(OptiAdvanced)

class OptiSol(PrintableCommon):
    """
      A simplified interface for NLP modeling/solving.



    This class offers a view with solution retrieval facilities The API is
    guaranteed to be stable.

    Joris Gillis, Erik Lambrechts

    C++ includes: optistack.hpp 


    """

    __swig_setmethods__ = {}
    for _s in [PrintableCommon]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptiSol, name, value)
    __swig_getmethods__ = {}
    for _s in [PrintableCommon]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OptiSol, name)
    __repr__ = _swig_repr

    def type_name(self, *args):
        """


        type_name(self) -> str



        """
        return _casadi.OptiSol_type_name(self, *args)


    def disp(self, *args):
        """


        disp(self, bool more)



        """
        return _casadi.OptiSol_disp(self, *args)


    def str(self, *args):
        """


        str(self, bool more) -> str



        """
        return _casadi.OptiSol_str(self, *args)


    def value(self, *args):
        """
          Obtain value of expression at the current value

          value(self, DM x, [MX] values) -> double
          value(self, SX x, [MX] values) -> double
          value(self, MX x, [MX] values) -> double


        In regular mode, teh current value is the converged solution In debug mode,
        the value can be non-converged

        Parameters:
        -----------

        values:  Optional assignment expressions (e.g. x==3) to overrule the current
        value




        """
        return _casadi.OptiSol_value(self, *args)


    def value_variables(self, *args):
        """
        get assignment expressions for the optimal solution

        value_variables(self) -> [MX]





        """
        return _casadi.OptiSol_value_variables(self, *args)


    def value_parameters(self, *args):
        """


        value_parameters(self) -> [MX]



        """
        return _casadi.OptiSol_value_parameters(self, *args)


    def stats(self, *args):
        """
          Get statistics.

          stats(self) -> dict


        nlpsol stats are passed as-is. No stability can be guaranteed about this
        part of the API




        """
        return _casadi.OptiSol_stats(self, *args)


    def _opti(self, *args):
        """


        _opti(self) -> Opti



        """
        return _casadi.OptiSol__opti(self, *args)


    @property
    def opti(self):
      return self._opti()


    @property
    def debug(self):
      return self._debug()


    def __init__(self, *args):
        """


        OptiSol(OptiSol other)



        """
        this = _casadi.new_OptiSol(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _casadi.delete_OptiSol
OptiSol_swigregister = _casadi.OptiSol_swigregister
OptiSol_swigregister(OptiSol)

# This file is compatible with both classic and new-style classes.


