"""
Created in 2025

@author: Konstantina Kolovou Kouri
"""

import pandas as pd
import matplotlib.pyplot as plt
import glob

from itertools import cycle

def w_wo_CB_100Hz(file_path):

    csv_files = glob.glob(file_path + '/*.csv')

    colors = cycle(['#0072B2', '#56B4E9', '#E69F00', '#009E73'])
    labels =cycle(['without CB', 'with CB'])
    linestyles = cycle(['solid', 'dashed'])

    fig, ax = plt.subplots(figsize=(10, 6))

    for csv_file in csv_files:

        # Start of plot definition
        df = pd.read_csv(csv_file, skiprows=20)

        # Calculate moving averages with a window size of 5
        df['CH3_MA'] = df['CH3'].rolling(window=100).mean()

        color = next(colors)
        label = next(labels)
        linestyle = next(linestyles)

        ax.plot((df['TIME']*10**6)+1200, df['CH3_MA'], label=label, color=color, linestyle=linestyle)


    ax.set_xlabel('Time (µs)', fontsize=20)
    ax.set_ylabel('Amplitude (V)', fontsize=20)
    ax.legend(fontsize=18, loc=4)

    ax.tick_params(axis='both', which='major', labelsize=14)
    plt.xlim(0,2000)
    ax.grid(True) 

    #plt.savefig("w_wo_CB_100Hz.pdf", bbox_inches="tight")


def w_wo_CB_1kHz(file_path):

    csv_files = glob.glob(file_path + '/*.csv')

    colors = cycle(['#0072B2', '#56B4E9', '#E69F00', '#009E73'])
    labels =cycle(['without CB', 'with CB'])
    linestyles = cycle(['solid', 'dashed'])

    fig, ax = plt.subplots(figsize=(10, 6))

    for csv_file in csv_files:

        # Start of plot definition
        df = pd.read_csv(csv_file, skiprows=20)

        # Calculate moving averages with a window size of 5
        df['CH3_MA'] = df['CH3'].rolling(window=100).mean()

        color = next(colors)
        label = next(labels)
        linestyle = next(linestyles)

        ax.plot((df['TIME']*10**6)+1500, df['CH3_MA'], label=label, color=color, linestyle=linestyle)


    ax.set_xlabel('Time (µs)', fontsize=20)
    ax.set_ylabel('Amplitude (V)', fontsize=20)
    ax.legend(fontsize=18, loc=4)

    ax.tick_params(axis='both', which='major', labelsize=14)
    plt.xlim(0,3000)
    plt.ylim(-4,4)
    ax.grid(True) 

    #plt.savefig("w_wo_CB_1kHz.pdf", bbox_inches="tight")
    

#w_wo_CB_100Hz('C:\\VNS_manuscript\\data\\w_wo_CB_100Hz')
w_wo_CB_1kHz('C:\\VNS_manuscript\\data\\w_wo_CB_1kHz')


plt.show()