"""
Created in 2025

@author: Konstantina Kolovou Kouri
"""

import seaborn as sns
import matplotlib.pyplot as plt
import pandas as pd
import glob
import numpy as np

from itertools import cycle


def get_max_offset_df(csv_file, bool, label):

    df = pd.read_csv(csv_file, skiprows=20)
    
    #sliced = df.loc[:, 'CH1':]
    sliced = df.loc[:, 'CH2':]

    #df['CH1'] = df['CH1'].rolling(window=2).mean()
    df['CH2'] = df['CH2'].rolling(window=2).mean()
    df['CH3'] = df['CH3'].rolling(window=2).mean()
    #df['CH4'] = df['CH4'].rolling(window=2).mean()

    min_row = sliced.min(axis = 1)
    max_row = sliced.max(axis = 1)
    max_offset = abs(max_row - min_row)
    max_offset.name = 'Max Voltage Offset (V)'
    df = pd.DataFrame([max_offset]).transpose()
    df['CB'] = bool
    df['Condition'] = label

    return df

def electrode_offset_excitation(file_path):

    csv_files = glob.glob(file_path + '/*.csv')

    labels = cycle(['1P/3P/5P sym 100Hz', '1P/3P/5P sym 100Hz', '1P/3P/5P sym 100Hz', '1P/3P/5P sym 100Hz', '1P/3P/5P sym 100Hz', '1P/3P/5P sym 100Hz', '1P/2P sym 1kHz' , '1P/2P sym 1kHz' , '1P/2P sym 1kHz' , '1P/2P sym 1kHz', '1P/2P sym 1kHz' , '1P/2P sym 1kHz'])
    bools = cycle(['no', 'yes'])

    df = pd.DataFrame()

    for csv_file in csv_files:

        label = next(labels)
        bool = next(bools)

        df = pd.concat([df, get_max_offset_df(csv_file, bool, label)])


    sns.set_theme(style="ticks", palette="terrain", rc={'figure.figsize':(10, 6)}, font_scale=1.7) 
    plt.grid(True)
    
    sns.violinplot(data=df, x="Condition", y="Max Voltage Offset (V)", hue="CB", density_norm="width", saturation=0.5)

    #plt.savefig("electrode_offset_violin_plot.pdf", bbox_inches="tight")
    plt.show()


electrode_offset_excitation('C:\\VNS_manuscript\\data\\offset_voltage_measurements')